import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addMeta(X3Dpackage.meta().setContent("CameraExamples.x3d").setName("title"))
        .addMeta(X3Dpackage.meta().setContent("Camera, CameraShot and CameraMove examples that demonstrate storyboard capabilities and precise camera operation. This is a developmental effort for potential X3D Specification improvement.").setName("description"))
        .addMeta(X3Dpackage.meta().setContent("Two demos are found in the scene, click the \"red text\" on left or right to start. (a) SimpleShotsTest shows Zoom in/out, Pan left/right, Boom up/down, Tilt left/right, with each is defined by a CameraShot collecting a series of CameraMovements. (b) AimPointTest gradually slews the camera view to look at the sliding cube, then follows it around before returning to original viewpoint.").setName("documentation"))
        .addMeta(X3Dpackage.meta().setContent("Don Brutzman and Jeff Weekley").setName("creator"))
        .addMeta(X3Dpackage.meta().setContent("18 June 2009").setName("created"))
        .addMeta(X3Dpackage.meta().setContent("12 January 2014").setName("modified"))
        .addMeta(X3Dpackage.meta().setContent("Schematron rules, backed up by initialize() checks").setName("TODO"))
        .addMeta(X3Dpackage.meta().setContent("BeyondViewpointCameraNodesWeb3D2009.pdf").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("CameraExamplesDemo.mp4").setName("MovingImage"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/navigation.html").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("Camera nodes for Viewpoint navigation control").setName("subject"))
        .addMeta(X3Dpackage.meta().setContent("CameraPrototypes.x3d").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("CameraExamplesConsoleLog.txt").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.avi").setName("reference"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d").setName("reference"))
        # TODO warn if more than one identifier present 

        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d").setName("identifier"))
        .addMeta(X3Dpackage.meta().setContent("http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/development/CameraExamples.x3d").setName("identifier"))
        .addMeta(X3Dpackage.meta().setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit").setName("generator"))
        .addMeta(X3Dpackage.meta().setContent("../license.html").setName("license")))
      .setScene(X3Dpackage.Scene()
        # =============== Camera ============== 

        .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("Camera node provides direct control of scene view to enable cinematic camera animation shot by shot and move by move along with still digital-photography settings for offline rendering of camera images").setName("Camera").setUrl(["CameraPrototypes.x3d#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#Camera","CameraPrototypes.wrl#Camera","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#Camera"])
          # Viewpoint-related fields, NavigationInfo-related fields and Camera-unique fields 

          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Text description to be displayed for this Camera").setName("description").setType("SFString"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera position in local transformation frame, which is default prior to first CameraShot initialPosition getting activated").setName("position").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera rotation in local transformation frame, which is default prior to first CameraShot initialPosition getting activated").setName("orientation").setType("SFRotation"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("pi/4").setName("fieldOfView").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOnly").setAppinfo("input fraction drives interpolators").setName("set_fraction").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOnly").setAppinfo("input event binds or unbinds this Camera").setName("set_bind").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("output event indicates when this Camera is bound").setName("bindTime").setType("SFTime"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("output event indicates whether this Camera is bound or unbound").setName("isBound").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Vector distance to near clipping plane corresponds to NavigationInfo.avatarSize[0]").setName("nearClipPlane").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Vector distance to far clipping plane corresponds to NavigationInfo.visibilityLimit").setName("farClipPlane").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Array of CameraShot nodes which in turn contain CameraMovement nodes").setName("shots").setType("MFNode"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Whether camera headlight is on or off").setName("headlight").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera headlight color").setName("headlightColor").setType("SFColor"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera headlight intensity").setName("headlightIntensity").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera filter color that modifies virtual lens capture").setName("filterColor").setType("SFColor"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Camera filter transparency that modifies virtual lens capture").setName("filterTransparency").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("upVector changes modify camera orientation (and possibly vice versa)").setName("upVector").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane").setName("fStop").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Distance to focal plane of sharpest focus").setName("focusDistance").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations").setName("isActive").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Total duration of contained enabled CameraShot (and thus CameraMovement) move durations").setName("totalDuration").setType("SFTime"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("OfflineRender node").setName("offlineRender").setType("SFNode"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("enable console output to trace script computations and prototype progress").setName("traceEnabled").setType("SFBool")))
        # =============== CameraShot ============== 

        .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("CameraShot collects a specific set of CameraMovement animations that make up an individual shot").setName("CameraShot").setUrl(["CameraPrototypes.x3d#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraShot","CameraPrototypes.wrl#CameraShot","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraShot"])
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Text description to be displayed for this CameraShot").setName("description").setType("SFString"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Whether this CameraShot can be activated").setName("enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Set of CameraMovement nodes").setName("moves").setType("MFNode")
            # initializing CameraMovement nodes are inserted here by scene author using ProtoInstance 

            )
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Setup to reinitialize camera position for this shot").setName("initialPosition").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Setup to reinitialize camera rotation for this shot").setName("initialOrientation").setType("SFRotation"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Setup to reinitialize aimpoint (relative location for camera direction) for this shot").setName("initialAimPoint").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("pi/4").setName("initialFieldOfView").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane").setName("initialFStop").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Distance to focal plane of sharpest focus").setName("initialFocusDistance").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Subtotal duration of contained CameraMovement move durations").setName("shotDuration").setType("SFTime"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations").setName("isActive").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("enable console output to trace script computations and prototype progress").setName("traceEnabled").setType("SFBool")))
        # =============== CameraMovement ============== 

        .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("CameraMovement defines a single camera movement animation").setName("CameraMovement").setUrl(["CameraPrototypes.x3d#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#CameraMovement","CameraPrototypes.wrl#CameraMovement","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#CameraMovement"])
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Text description to be displayed for this CameraMovement").setName("description").setType("SFString"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Whether this CameraMovement can be activated").setName("enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Duration in seconds for this move").setName("duration").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Goal camera position for this move").setName("goalPosition").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Goal camera rotation for this move").setName("goalOrientation").setType("SFRotation"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Whether or not camera direction is tracking towards the aimPoint").setName("tracking").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Goal aimPoint for this move, ignored if tracking=false").setName("goalAimPoint").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Goal fieldOfView for this move").setName("goalFieldOfView").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Focal length divided effective aperture diameter indicating width of focal plane").setName("goalFStop").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Distance to focal plane of sharpest focus").setName("goalFocusDistance").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Mark start/stop with true/false output respectively useful to trigger external animations").setName("isActive").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("enable console output to trace script computations and prototype progress").setName("traceEnabled").setType("SFBool")))
        # =============== OfflineRender ============== 

        .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("OfflineRender defines a parameters for offline rendering of Camera animation output to a movie file (or possibly a still shot)").setName("OfflineRender").setUrl(["CameraPrototypes.x3d#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.x3d#OfflineRender","CameraPrototypes.wrl#OfflineRender","http://www.web3d.org/x3d/content/examples/Basic/development/CameraPrototypes.wrl#OfflineRender"])
          # TODO non-photorealistic rendering (NPR) parameters 

          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Text description to be displayed for this OfflineRender").setName("description").setType("SFString"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Whether this OfflineRender can be activated").setName("enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Frames per second recorded for this rendering").setName("frameRate").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Size of frame in number of pixels width and height").setName("frameSize").setType("SFVec2f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("Relative dimensions of pixel height/width typically 1.33 or 1").setName("pixelAspectRatio").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("inputOnly").setAppinfo("Begin render operation").setName("set_startTime").setType("SFTime"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Progress performing render operation (0..1)").setName("progress").setType("SFFloat"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setAppinfo("Render operation complete").setName("renderCompleteTime").setType("SFTime"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("Format of rendered output movie (mpeg mp4 etc.), use first supported format").setName("movieFormat").setType("MFString"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("Format of rendered output images (png jpeg gif tiff etc.) use first supported format").setName("imageFormat").setType("MFString"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("enable console output to trace script computations and prototype progress").setName("traceEnabled").setType("SFBool")))
        # =============== Lights, camera, action! ============== 

        .addChildren(X3Dpackage.DirectionalLight().setDirection([0,-1,0]).setGlobal(True).setIntensity(0.8))
        .addChildren(X3Dpackage.NavigationInfo().setType(["EXAMINE","FLY","ANY"]))
        .addChildren(X3Dpackage.Viewpoint().setDescription("Camera test scene entry view").setPosition([0,2,12]))
        .addChildren(X3Dpackage.Viewpoint().setDescription("Camera test scene from above").setOrientation([1,0,0,-1.57079]).setPosition([0,150,0]))
        # Keep prototype instances in same file while developing, then move later 

        # We will create examples matching those in the paper 

        # =============== Camera.SimpleShotsTest ============== 

        .addChildren(X3Dpackage.ProtoInstance().setDEF("Camera.SimpleShotsTest").setName("Camera")
          .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("SimpleShotsTest for camera Zoom Dolly Pan Boom and Tilt"))
          .addFieldValue(X3Dpackage.fieldValue().setName("headlight").setValue("true"))
          .addFieldValue(X3Dpackage.fieldValue().setName("position").setValue("-4 4 10"))
          .addFieldValue(X3Dpackage.fieldValue().setName("shots")
            .addChildren(X3Dpackage.ProtoInstance().setDEF("Zoom").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Simple shot of Camera Zoom"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("-50 1 -10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 1 0 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Zoom In"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-50 1 -15"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Zoom Out"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-50 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-50 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))))
            .addChildren(X3Dpackage.ProtoInstance().setDEF("Dolly").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Simple shot of Camera Dolly"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("-40 1 -10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 1 0 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setDEF("DollyMove1").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Dolly from Right to Left"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-45 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Dolly from Left to Right"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-40 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-40 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))))
            .addChildren(X3Dpackage.ProtoInstance().setDEF("Pan").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Simple shot of Camera Pan left right and back to center"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("-30 1 -10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 1 0 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setDEF("PanLeft").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Pan Left"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("2"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-30 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0.4")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("PanRight").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Pan Right"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-30 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 -0.4")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Pan back to Center"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("2"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-30 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("2"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-30 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))))
            .addChildren(X3Dpackage.ProtoInstance().setDEF("CameraBoom").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Boom"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("-20 1 -10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 1 0 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setDEF("CameraBoomUp").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Boom Up"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-20 5 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("BoomDown").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Boom Down"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-20 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("BoomPause").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("2"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-20 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))))
            .addChildren(X3Dpackage.ProtoInstance().setDEF("CameraTilt").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("-10 1 -10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 0 1 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("traceEnabled").setValue("true"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 0")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("TiltDown").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Left"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 0.785")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("TiltPause").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 0.785")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Right"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 -0.785")))
                .addChildren(X3Dpackage.ProtoInstance().setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Pause"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 -0.785")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("TiltReset").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Camera Tilt Reset"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("1"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("-10 1 -10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 0")))
                .addChildren(X3Dpackage.ProtoInstance().setDEF("TiltUp").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("Return to home"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("2"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("0 2 12"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 0 1 0")))))))
        .addChildren(X3Dpackage.Group().setDEF("AnimationGroup.SimpleShots")
          .addChildren(X3Dpackage.TimeSensor().setDEF("CameraTimer.SimpleShots"))
          # initialize clock to match totalDuration of combined Shot Moves 

          .addChildren(X3Dpackage.ROUTE().setFromField("totalDuration").setFromNode("Camera.SimpleShotsTest").setToField("cycleInterval").setToNode("CameraTimer.SimpleShots"))
          # TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 

          .addChildren(X3Dpackage.ROUTE().setFromField("fraction_changed").setFromNode("CameraTimer.SimpleShots").setToField("set_fraction").setToNode("Camera.SimpleShotsTest"))
          .addChildren(X3Dpackage.Transform().setDEF("Trigger.SimpleShots").setTranslation([-4,4,0])
            .addChildren(X3Dpackage.BooleanFilter().setDEF("TextTouchActive.SimpleShotsFilter"))
            .addChildren(X3Dpackage.TouchSensor().setDEF("TextTouch.SimpleShots").setDescription("touch to animate Camera SimpleShotsTest"))
            .addChildren(X3Dpackage.ROUTE().setFromField("inputTrue").setFromNode("TextTouchActive.SimpleShotsFilter").setToField("set_bind").setToNode("Camera.SimpleShotsTest"))
            .addChildren(X3Dpackage.ROUTE().setFromField("isActive").setFromNode("TextTouch.SimpleShots").setToField("set_boolean").setToNode("TextTouchActive.SimpleShotsFilter"))
            .addChildren(X3Dpackage.ROUTE().setFromField("touchTime").setFromNode("TextTouch.SimpleShots").setToField("startTime").setToNode("CameraTimer.SimpleShots"))
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["Click to animate","SimpleShotsTest"])
                .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setDEF("ArtDeco5").setAmbientIntensity(0.24).setDiffuseColor([0.945455,0.318988,0.321717]).setShininess(0.01).setSpecularColor([0.072727,0.021705,0.010732])
                  # Universal Media Library: ArtDeco 5 

                  )))
            # Simplify intersection test for user selecting text 

            .addChildren(X3Dpackage.Shape().setDEF("TransparentBox")
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setTransparency(1)))
              .setGeometry(X3Dpackage.Box(setSize = [6,2,0.0001])))))
        .addChildren(X3Dpackage.Group().setDEF("SimpleShotsTargets")
          .addChildren(X3Dpackage.Transform().setDEF("TargetBoxZoom").setTranslation([-50,1,-20])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material())
                .setTexture(X3Dpackage.ImageTexture().setUrl(["images/CameraMoveZoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveZoom.png"]))))
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Text().setString(["Zoom in, out"])
                  .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material())))))
          .addChildren(X3Dpackage.Transform().setDEF("TargetBoxDolly").setTranslation([-40,1,-20])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material())
                .setTexture(X3Dpackage.ImageTexture().setUrl(["images/CameraMoveDolly.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveDolly.png"]))))
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Text().setString(["Dolly left, right"])
                  .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material())))))
          .addChildren(X3Dpackage.Transform().setDEF("TargetBoxPan").setTranslation([-30,1,-20])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material())
                .setTexture(X3Dpackage.ImageTexture().setUrl(["images/CameraMovePan.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMovePan.png"]))))
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Text().setString(["Pan left, right"])
                  .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material())))))
          .addChildren(X3Dpackage.Transform().setDEF("TargetBoxBoom").setTranslation([-20,1,-20])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material())
                .setTexture(X3Dpackage.ImageTexture().setUrl(["images/CameraMoveBoom.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveBoom.png"]))))
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Text().setString(["Boom up, down"])
                  .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material())))))
          .addChildren(X3Dpackage.Transform().setDEF("TargetBoxTilt").setTranslation([-10,1,-20])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box())
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material())
                .setTexture(X3Dpackage.ImageTexture().setUrl(["images/CameraMoveTilt.png","http://www.web3d.org/x3d/content/examples/Basic/development/images/CameraMoveTilt.png"]))))
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Text().setString(["Tilt left, right"])
                  .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material()))))))
        # =============== Camera.AimPointTest ============== 

        .addChildren(X3Dpackage.ProtoInstance().setDEF("Camera.AimPointTest").setName("Camera")
          .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("AimPointTest for moving camera tracking moving target"))
          .addFieldValue(X3Dpackage.fieldValue().setName("position").setValue("4 4 10"))
          .addFieldValue(X3Dpackage.fieldValue().setName("shots")
            .addChildren(X3Dpackage.ProtoInstance().setDEF("Shot5").setName("CameraShot")
              .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("#3 Tracking shot"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialPosition").setValue("6 6 10"))
              .addFieldValue(X3Dpackage.fieldValue().setName("initialOrientation").setValue("0 1 0 0"))
              .addFieldValue(X3Dpackage.fieldValue().setName("moves")
                .addChildren(X3Dpackage.ProtoInstance().setDEF("MoveAimPoint3.1").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("AimPoint 3.1 moving BoxPath"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("tracking").setValue("true"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("8"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("6 6 10"))
                  # goalAimPoint modified by ROUTE to match moving Box 

                  )
                .addChildren(X3Dpackage.ProtoInstance().setDEF("MoveAimPoint3.2").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("AimPoint 3.2 pan right while tracking"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("tracking").setValue("true"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("8"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("40 6 12"))
                  # goalAimPoint modified by ROUTE to match moving Box 

                  )
                .addChildren(X3Dpackage.ProtoInstance().setDEF("MoveAimPoint3.3").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("AimPoint 3.3 boom up while tracking"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("tracking").setValue("true"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("3"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("40 20 13"))
                  # goalAimPoint modified by ROUTE to match moving Box 

                  )
                .addChildren(X3Dpackage.ProtoInstance().setDEF("MoveAimPoint3.4").setName("CameraMovement")
                  .addFieldValue(X3Dpackage.fieldValue().setName("description").setValue("AimPoint 3.4 restore camera back to home"))
                  # can test tracking or not using following values 

                  .addFieldValue(X3Dpackage.fieldValue().setName("tracking").setValue("true"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("duration").setValue("5"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalPosition").setValue("4 4 10"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalAimPoint").setValue("4 4 0"))
                  .addFieldValue(X3Dpackage.fieldValue().setName("goalOrientation").setValue("0 1 0 0")))))))
        .addChildren(X3Dpackage.Group().setDEF("AnimationGroup.AimPointTest")
          .addChildren(X3Dpackage.TimeSensor().setDEF("CameraTimer.AimPointTest"))
          # initialize clock to match totalDuration of combined Shot Moves 

          .addChildren(X3Dpackage.ROUTE().setFromField("totalDuration").setFromNode("Camera.AimPointTest").setToField("cycleInterval").setToNode("CameraTimer.AimPointTest"))
          # TimeSensor animates the CameraClock since that maintains the computed PositionInterpolator and OrientationInterpolator 

          .addChildren(X3Dpackage.ROUTE().setFromField("fraction_changed").setFromNode("CameraTimer.AimPointTest").setToField("set_fraction").setToNode("Camera.AimPointTest"))
          .addChildren(X3Dpackage.Transform().setDEF("Trigger.AimPointTest").setTranslation([4,4,0])
            .addChildren(X3Dpackage.BooleanFilter().setDEF("TextTouchActive.AimPointFilter"))
            .addChildren(X3Dpackage.TouchSensor().setDEF("TextTouch.AimPointTest").setDescription("touch to animate Camera AimPointTest"))
            .addChildren(X3Dpackage.ROUTE().setFromField("inputTrue").setFromNode("TextTouchActive.AimPointFilter").setToField("set_bind").setToNode("Camera.AimPointTest"))
            .addChildren(X3Dpackage.ROUTE().setFromField("isActive").setFromNode("TextTouch.AimPointTest").setToField("set_boolean").setToNode("TextTouchActive.AimPointFilter"))
            .addChildren(X3Dpackage.ROUTE().setFromField("touchTime").setFromNode("TextTouch.AimPointTest").setToField("startTime").setToNode("CameraTimer.AimPointTest"))
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["Click to animate","AimPointTest"])
                .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"])))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setUSE("ArtDeco5"))))
            .addChildren(X3Dpackage.Shape().setUSE("TransparentBox"))))
        # TODO build a test once implemented 

        .addChildren(X3Dpackage.ProtoInstance().setName("OfflineRender"))
        # =============== animate a camera shape to visualize view changes ============== 

        .addChildren(X3Dpackage.Transform().setDEF("CameraShapeTransform").setTranslation([0,0.5,0])
          # move CameraShape using active Camera 

          .addChildren(X3Dpackage.ROUTE().setFromField("position_changed").setFromNode("Camera.SimpleShotsTest").setToField("translation").setToNode("CameraShapeTransform"))
          .addChildren(X3Dpackage.ROUTE().setFromField("orientation_changed").setFromNode("Camera.SimpleShotsTest").setToField("rotation").setToNode("CameraShapeTransform"))
          .addChildren(X3Dpackage.ROUTE().setFromField("position").setFromNode("Camera.AimPointTest").setToField("translation").setToNode("CameraShapeTransform"))
          .addChildren(X3Dpackage.ROUTE().setFromField("orientation_changed").setFromNode("Camera.AimPointTest").setToField("rotation").setToNode("CameraShapeTransform"))
          .addChildren(X3Dpackage.Transform().setDEF("CameraOffsetTransform").setTranslation([0,0,0.25])
            .addChildren(X3Dpackage.TouchSensor().setDEF("CameraShapeTouched"))
            .addChildren(X3Dpackage.Inline().setDEF("CameraShape").setUrl(["CameraShape.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraShape.x3d"]))
            .addChildren(X3Dpackage.Shape().setDEF("SightLine")
              .setGeometry(X3Dpackage.IndexedLineSet(setCoordIndex = [0,1])
                .setCoord(X3Dpackage.Coordinate().setPoint([0,0,0,0,0,-100])))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setEmissiveColor([0.8,0.8,0.4])))))
          # Display frustum to show camera view within the scene, toggled by user selecting CameraShape 

          .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("Display view frustum associated with a given pair of Viewpoint NavigationInfo nodes").setName("ViewFrustum").setUrl(["../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.x3d#ViewFrustum","../../X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter14Prototypes/ViewFrustumPrototype.wrl#ViewFrustum"])
            .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("required: insert Viewpoint DEF or USE node for view of interest").setName("ViewpointNode").setType("SFNode"))
            .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("required: insert NavigationInfo DEF or USE node of interest").setName("NavigationInfoNode").setType("SFNode"))
            .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("whether or not frustum geometry is rendered").setName("visible").setType("SFBool"))
            .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("RGB color of ViewFrustum outline, default value 0.9 0.9 0.9").setName("lineColor").setType("SFColor"))
            .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("RGB color of ViewFrustum hull geometry, default value 0.8 0.8 0.8").setName("frustumColor").setType("SFColor"))
            .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("transparency of ViewFrustum hull geometry, default value 0.5").setName("transparency").setType("SFFloat"))
            .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("assumed ratio height/width, default value 0.75").setName("aspectRatio").setType("SFFloat"))
            .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("debug support, default false").setName("trace").setType("SFBool")))
          .addChildren(X3Dpackage.ProtoInstance().setDEF("ViewFrustumNode").setName("ViewFrustum")
            .addFieldValue(X3Dpackage.fieldValue().setName("ViewpointNode")
              .addChildren(X3Dpackage.Viewpoint().setDEF("FrustumViewpoint").setDescription("viewpoint for ViewFrustum").setPosition([0,0,0])))
            .addFieldValue(X3Dpackage.fieldValue().setName("NavigationInfoNode")
              .addChildren(X3Dpackage.NavigationInfo().setDEF("TestNavigationInfo").setTransitionType(["ANIMATE"]).setVisibilityLimit(100)))
            .addFieldValue(X3Dpackage.fieldValue().setName("visible").setValue("false"))
            .addFieldValue(X3Dpackage.fieldValue().setName("lineColor").setValue("0.9 0.9 0.9"))
            .addFieldValue(X3Dpackage.fieldValue().setName("frustumColor").setValue("0.8 0.8 0.8"))
            .addFieldValue(X3Dpackage.fieldValue().setName("transparency").setValue("0.95")))
          .addChildren(X3Dpackage.BooleanToggle().setDEF("ViewFrustumToggle"))
          .addChildren(X3Dpackage.ROUTE().setFromField("isActive").setFromNode("CameraShapeTouched").setToField("set_boolean").setToNode("ViewFrustumToggle"))
          .addChildren(X3Dpackage.ROUTE().setFromField("toggle").setFromNode("ViewFrustumToggle").setToField("set_visible").setToNode("ViewFrustumNode")))
        # =============== add checkerboard, axes and other things to look at while animating ============== 

        .addChildren(X3Dpackage.Background().setSkyColor([0.282353,0.380392,0.470588]))
        .addChildren(X3Dpackage.Transform().setRotation([1,0,0,-1.57079]).setScale([10,10,10])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.Material().setAmbientIntensity(0.01).setDiffuseColor([1.0,1.0,1.0]).setShininess(0.05)))
            .setGeometry(X3Dpackage.IndexedFaceSet(setColorIndex = [0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0], setColorPerVertex = False, setCoordIndex = [0,8,9,1,-1,1,9,10,2,-1,2,10,11,3,-1,3,11,12,4,-1,4,12,13,5,-1,5,13,14,6,-1,6,14,15,7,-1,8,16,17,9,-1,9,17,18,10,-1,10,18,19,11,-1,11,19,20,12,-1,12,20,21,13,-1,13,21,22,14,-1,14,22,23,15,-1,16,24,25,17,-1,17,25,26,18,-1,18,26,27,19,-1,19,27,28,20,-1,20,28,29,21,-1,21,29,30,22,-1,22,30,31,23,-1,24,32,33,25,-1,25,33,34,26,-1,26,34,35,27,-1,27,35,36,28,-1,28,36,37,29,-1,29,37,38,30,-1,30,38,39,31,-1,32,40,41,33,-1,33,41,42,34,-1,34,42,43,35,-1,35,43,44,36,-1,36,44,45,37,-1,37,45,46,38,-1,38,46,47,39,-1,40,48,49,41,-1,41,49,50,42,-1,42,50,51,43,-1,43,51,52,44,-1,44,52,53,45,-1,45,53,54,46,-1,46,54,55,47,-1,48,56,57,49,-1,49,57,58,50,-1,50,58,59,51,-1,51,59,60,52,-1,52,60,61,53,-1,53,61,62,54,-1,54,62,63,55,-1], setNormalPerVertex = False, setSolid = False)
              .setCoord(X3Dpackage.Coordinate().setPoint([-5.25,5.25,0.0,-3.75,5.25,0.0,-2.25,5.25,0.0,-0.75,5.25,0.0,0.75,5.25,0.0,2.25,5.25,0.0,3.75,5.25,0.0,5.25,5.25,0.0,-5.25,3.75,0.0,-3.75,3.75,0.0,-2.25,3.75,0.0,-0.75,3.75,0.0,0.75,3.75,0.0,2.25,3.75,0.0,3.75,3.75,0.0,5.25,3.75,0.0,-5.25,2.25,0.0,-3.75,2.25,0.0,-2.25,2.25,0.0,-0.75,2.25,0.0,0.75,2.25,0.0,2.25,2.25,0.0,3.75,2.25,0.0,5.25,2.25,0.0,-5.25,0.75,0.0,-3.75,0.75,0.0,-2.25,0.75,0.0,-0.75,0.75,0.0,0.75,0.75,0.0,2.25,0.75,0.0,3.75,0.75,0.0,5.25,0.75,0.0,-5.25,-0.75,0.0,-3.75,-0.75,0.0,-2.25,-0.75,0.0,-0.75,-0.75,0.0,0.75,-0.75,0.0,2.25,-0.75,0.0,3.75,-0.75,0.0,5.25,-0.75,0.0,-5.25,-2.25,0.0,-3.75,-2.25,0.0,-2.25,-2.25,0.0,-0.75,-2.25,0.0,0.75,-2.25,0.0,2.25,-2.25,0.0,3.75,-2.25,0.0,5.25,-2.25,0.0,-5.25,-3.75,0.0,-3.75,-3.75,0.0,-2.25,-3.75,0.0,-0.75,-3.75,0.0,0.75,-3.75,0.0,2.25,-3.75,0.0,3.75,-3.75,0.0,5.25,-3.75,0.0,-5.25,-5.25,0.0,-3.75,-5.25,0.0,-2.25,-5.25,0.0,-0.75,-5.25,0.0,0.75,-5.25,0.0,2.25,-5.25,0.0,3.75,-5.25,0.0,5.25,-5.25,0.0]))
              .setColor(X3Dpackage.Color().setColor([0.435294,0.741176,0,0,0.560784,0.580392])))))
        .addChildren(X3Dpackage.Transform().setScale([3,3,3]).setTranslation([0,0.25,0])
          .addChildren(X3Dpackage.Inline().setDEF("CoordinateAxes").setUrl(["../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","../../Savage/Tools/Authoring/CoordinateAxes.x3d","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","../../Savage/Tools/Authoring/CoordinateAxes.wrl","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"])))
        .addChildren(X3Dpackage.Transform().setDEF("MovingBoxTransform")
          .addChildren(X3Dpackage.PositionInterpolator().setDEF("BoxPath").setKey([0,0.25,0.5,0.75,1]).setKeyValue([-5,1,5,45,1,5,45,1,-45,-5,1,-45,-5,1,5]))
          .addChildren(X3Dpackage.TimeSensor().setDEF("BoxTimer").setCycleInterval(10).setLoop(True))
          .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("BoxPath").setToField("translation").setToNode("MovingBoxTransform"))
          .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("BoxPath").setToField("goalAimPoint").setToNode("MoveAimPoint3.1"))
          .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("BoxPath").setToField("goalAimPoint").setToNode("MoveAimPoint3.2"))
          .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("BoxPath").setToField("goalAimPoint").setToNode("MoveAimPoint3.3"))
          .addChildren(X3Dpackage.ROUTE().setFromField("fraction_changed").setFromNode("BoxTimer").setToField("set_fraction").setToNode("BoxPath"))
          .addChildren(X3Dpackage.Shape()
            .setGeometry(X3Dpackage.Box())
            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.Material())
              .setTexture(X3Dpackage.ImageTexture().setUrl(["../earth-topo.png","http://www.web3d.org/x3d/content/examples/Basic/earth-topo.png"])))))
        # ================ CrossHair visualization for center of screen ================ 

        .addChildren(X3Dpackage.ExternProtoDeclare().setAppinfo("CrossHair prototype provides a heads-up display (HUD) crosshair at the view center, which is useful for assessing NavigationInfo lookAt point").setName("CrossHair").setUrl(["../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.x3d#CrossHair","../../Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair","https://savage.nps.edu/Savage/Tools/HeadsUpDisplays/CrossHairPrototype.wrl#CrossHair"])
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setAppinfo("whether CrissHair orititype is enabled or not").setName("enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOnly").setAppinfo("control whether enabled/disabled").setName("set_enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("color of CrossHair marker").setName("markerColor").setType("SFColor"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("size of CrossHair in meters").setName("scale").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("inputOutput").setAppinfo("distance in front of HUD viewpoint").setName("positionOffsetFromCamera").setType("SFVec3f")))
        .addChildren(X3Dpackage.ProtoInstance().setDEF("CrossHairInstance").setName("CrossHair")
          .addFieldValue(X3Dpackage.fieldValue().setName("enabled").setValue("true"))
          .addFieldValue(X3Dpackage.fieldValue().setName("markerColor").setValue("1 0.5 0"))
          .addFieldValue(X3Dpackage.fieldValue().setName("scale").setValue("1 1 1"))
          .addFieldValue(X3Dpackage.fieldValue().setName("positionOffsetFromCamera").setValue("0 0 -6")))
        # turn on CrossHairInstance when animated camera viewpoints are bound 

        .addChildren(X3Dpackage.ROUTE().setFromField("isBound").setFromNode("Camera.SimpleShotsTest").setToField("set_enabled").setToNode("CrossHairInstance"))
        .addChildren(X3Dpackage.ROUTE().setFromField("isBound").setFromNode("Camera.AimPointTest").setToField("set_enabled").setToNode("CrossHairInstance"))
        # turn off CrossHairInstance when animated camera viewpoints are unbound <BooleanFilter DEF='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.SimpleShotsTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='isBound' fromNode='Camera.AimPointTest' toField='set_boolean' toNode='NegateCrossHair'/> <ROUTE fromField='inputNegate' fromNode='NegateCrossHair' toField='set_enabled' toNode='CrossHairInstance'/> 

        # =============== TODO Launch Prototype Example ============== 

        .addChildren(X3Dpackage.Anchor().setDescription("launch CameraExample scene").setParameter(["target=_blank"]).setUrl(["CameraExample.x3d","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.x3d","CameraExample.wrl","http://www.web3d.org/x3d/content/examples/Basic/development/CameraExample.wrl"])
          .addChildren(X3Dpackage.Transform().setTranslation([0,-3,0])
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Text().setString(["CameraPrototype","defines a prototype","","Click on this text to see","CameraExample scene"])
                .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"], setSize = 0.5)))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setDiffuseColor([1,1,0.2]))))))))

