import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addMeta(X3Dpackage.meta().setName("title").setContent("box.x3d"))
        .addMeta(X3Dpackage.meta().setName("creator").setContent("John Carlson"))
        .addMeta(X3Dpackage.meta().setName("generator").setContent("manual"))
        .addMeta(X3Dpackage.meta().setName("identifier").setContent("https://coderextreme.net/X3DJSONLD/box.x3d"))
        .addMeta(X3Dpackage.meta().setName("description").setContent("3 boxes")))
      .setScene(X3Dpackage.Scene()
        .addChildren(X3Dpackage.NavigationInfo().setType(["EXAMINE"]))
        .addChildren(X3Dpackage.Viewpoint().setDescription("Cubes on Fire").setPosition([0,0,12]))
        .addChildren(X3Dpackage.ProtoDeclare().setName("anyShape")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setName("xtranslation").setAccessType("inputOutput").setType("SFVec3f").setValue("0 0 0"))
            .addField(X3Dpackage.field().setName("myShape").setAccessType("inputOutput").setType("MFNode")
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Sphere())
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material().setDiffuseColor([1,1,1]))))))
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.Transform()
              .setIS(X3Dpackage.IS()
                .addConnect(X3Dpackage.connect().setNodeField("translation").setProtoField("xtranslation"))
                .addConnect(X3Dpackage.connect().setNodeField("children").setProtoField("myShape"))))))
        .addChildren(X3Dpackage.ProtoDeclare().setName("three")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setName("ytranslation").setAccessType("inputOutput").setType("SFVec3f").setValue("0 0 0"))
            .addField(X3Dpackage.field().setName("myShape").setAccessType("inputOutput").setType("MFNode")
              .addChildren(X3Dpackage.Shape()
                .setGeometry(X3Dpackage.Cylinder())
                .setAppearance(X3Dpackage.Appearance()
                  .setMaterial(X3Dpackage.Material().setDiffuseColor([1,1,1]))))))
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.Transform()
              .setIS(X3Dpackage.IS()
                .addConnect(X3Dpackage.connect().setNodeField("translation").setProtoField("ytranslation")))
              .addChildren(X3Dpackage.ProtoInstance().setName("anyShape")
                .addFieldValue(X3Dpackage.fieldValue().setName("xtranslation").setValue("0 0 0"))
                .setIS(X3Dpackage.IS()
                  .addConnect(X3Dpackage.connect().setNodeField("myShape").setProtoField("myShape"))))
              .addChildren(X3Dpackage.ProtoInstance().setName("anyShape")
                .addFieldValue(X3Dpackage.fieldValue().setName("xtranslation").setValue("2 0 0"))
                .setIS(X3Dpackage.IS()
                  .addConnect(X3Dpackage.connect().setNodeField("myShape").setProtoField("myShape"))))
              .addChildren(X3Dpackage.ProtoInstance().setName("anyShape")
                .addFieldValue(X3Dpackage.fieldValue().setName("xtranslation").setValue("-2 0 0"))
                .setIS(X3Dpackage.IS()
                  .addConnect(X3Dpackage.connect().setNodeField("myShape").setProtoField("myShape")))))))
        .addChildren(X3Dpackage.ProtoInstance().setName("three")
          .addFieldValue(X3Dpackage.fieldValue().setName("ytranslation").setValue("0 0 0"))
          .addFieldValue(X3Dpackage.fieldValue().setName("myShape")
            .addChildren(X3Dpackage.Shape()
              .setGeometry(X3Dpackage.Box(setSize = [1,1,1]))
              .setAppearance(X3Dpackage.Appearance()
                .setMaterial(X3Dpackage.Material().setDiffuseColor([0,1,0]))))))))

