import six
import json
import sys
class X3DNode(object):
    def __init__(self, **kwargs):
        super(X3DNode, self).__init__()
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNode>'
        return str


class X3DAppearanceChildNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DAppearanceChildNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DAppearanceChildNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DAppearanceChildNode>'
        return str


class X3DAppearanceNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DAppearanceNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DAppearanceNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DAppearanceNode>'
        return str


class X3DChildNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DChildNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DChildNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DChildNode>'
        return str


class X3DBindableNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DBindableNode, self).__init__(**kwargs)
        bindTime  = kwargs.pop("bindTime", None)
        self.__bindTime = bindTime
        Bound  = kwargs.pop("Bound", None)
        self.__Bound = Bound
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        bind  = kwargs.pop("bind", None)
        self.__bind = bind
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeBindTime(self, bindTime):
        self.__bindTime = [x for x in self.__bindTime if x not in bindTime]
        return self.__bindTime
    def getBindTime(self, bindTime = None):
        return self.__bindTime
    def bindTime_changed(self, bindTime = None):
        return self.__bindTime
    def isBound(self, Bound = None):
        return self.__Bound
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def bind(self):
        return self.__bind
    @bind.setter
    def bind(self, value = None):
        self.__bind = [value]
    def set_bind(self, bind = None):
        self.__bind = [bind]
        return self
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DBindableNode'
        if self.__bindTime is not None:
            if isinstance(self.__bindTime, six.string_types):
                str += ' bindTime="'+self.__bindTime+'"'
            else:
                str += ' bindTime="'+self.__bindTime[0]+'"'
        if self.__Bound is not None:
            if isinstance(self.__Bound, six.string_types):
                str += ' Bound="'+self.__Bound+'"'
            else:
                str += ' Bound="'+self.__Bound[0]+'"'
        if self.__bind is not None:
            if isinstance(self.__bind, six.string_types):
                str += ' bind="'+self.__bind+'"'
            else:
                str += ' bind="'+self.__bind[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DBindableNode>'
        return str


class X3DBackgroundNode(X3DBindableNode):
    def __init__(self, **kwargs):
        super(X3DBackgroundNode, self).__init__(**kwargs)
        bindTime  = kwargs.pop("bindTime", None)
        self.__bindTime = bindTime
        groundAngle  = kwargs.pop("groundAngle", None)
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        self.__groundAngle = groundAngle
        groundColor  = kwargs.pop("groundColor", None)
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        self.__groundColor = groundColor
        Bound  = kwargs.pop("Bound", None)
        self.__Bound = Bound
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        bind  = kwargs.pop("bind", None)
        self.__bind = bind
        skyAngle  = kwargs.pop("skyAngle", None)
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        self.__skyAngle = skyAngle
        skyColor  = kwargs.pop("skyColor", [0, 0, 0])
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        self.__skyColor = skyColor
        transparency  = kwargs.pop("transparency", 0)
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        self.__transparency = transparency
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeBindTime(self, bindTime):
        self.__bindTime = [x for x in self.__bindTime if x not in bindTime]
        return self.__bindTime
    def getBindTime(self, bindTime = None):
        return self.__bindTime
    def bindTime_changed(self, bindTime = None):
        return self.__bindTime
    @property
    def groundAngle(self):
        return self.__groundAngle
    @groundAngle.setter
    def groundAngle(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1.5708:
            return None
        self.__groundAngle = [value]
    def setGroundAngle(self, groundAngle = None):
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        self.__groundAngle = [groundAngle]
        return self
    def addGroundAngle(self, groundAngle = None):
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        if self.__groundAngle == None:            self.__groundAngle =  []
        self.__groundAngle +=  [groundAngle]
        return self
    def removeGroundAngle(self, groundAngle):
        self.__groundAngle = [x for x in self.__groundAngle if x not in groundAngle]
        return self.__groundAngle
    def getGroundAngle(self, groundAngle = None):
        return self.__groundAngle
    def groundAngle_changed(self, groundAngle = None):
        return self.__groundAngle
    @property
    def groundColor(self):
        return self.__groundColor
    @groundColor.setter
    def groundColor(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__groundColor = [value]
    def setGroundColor(self, groundColor = None):
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        self.__groundColor = [groundColor]
        return self
    def addGroundColor(self, groundColor = None):
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        if self.__groundColor == None:            self.__groundColor =  []
        self.__groundColor +=  [groundColor]
        return self
    def removeGroundColor(self, groundColor):
        self.__groundColor = [x for x in self.__groundColor if x not in groundColor]
        return self.__groundColor
    def getGroundColor(self, groundColor = None):
        return self.__groundColor
    def groundColor_changed(self, groundColor = None):
        return self.__groundColor
    def isBound(self, Bound = None):
        return self.__Bound
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def bind(self):
        return self.__bind
    @bind.setter
    def bind(self, value = None):
        self.__bind = [value]
    def set_bind(self, bind = None):
        self.__bind = [bind]
        return self
    @property
    def skyAngle(self):
        return self.__skyAngle
    @skyAngle.setter
    def skyAngle(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  3.1416:
            return None
        self.__skyAngle = [value]
    def setSkyAngle(self, skyAngle = None):
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        self.__skyAngle = [skyAngle]
        return self
    def addSkyAngle(self, skyAngle = None):
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        if self.__skyAngle == None:            self.__skyAngle =  []
        self.__skyAngle +=  [skyAngle]
        return self
    def removeSkyAngle(self, skyAngle):
        self.__skyAngle = [x for x in self.__skyAngle if x not in skyAngle]
        return self.__skyAngle
    def getSkyAngle(self, skyAngle = None):
        return self.__skyAngle
    def skyAngle_changed(self, skyAngle = None):
        return self.__skyAngle
    @property
    def skyColor(self):
        return self.__skyColor
    @skyColor.setter
    def skyColor(self, value = [0, 0, 0]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__skyColor = [value]
    def setSkyColor(self, skyColor = [0, 0, 0]):
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        self.__skyColor = [skyColor]
        return self
    def addSkyColor(self, skyColor = [0, 0, 0]):
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        if self.__skyColor == None:            self.__skyColor =  []
        self.__skyColor +=  [skyColor]
        return self
    def removeSkyColor(self, skyColor):
        self.__skyColor = [x for x in self.__skyColor if x not in skyColor]
        return self.__skyColor
    def getSkyColor(self, skyColor = [0, 0, 0]):
        return self.__skyColor
    def skyColor_changed(self, skyColor = [0, 0, 0]):
        return self.__skyColor
    @property
    def transparency(self):
        return self.__transparency
    @transparency.setter
    def transparency(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__transparency = [value]
    def setTransparency(self, transparency = 0):
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        self.__transparency = [transparency]
        return self
    def addTransparency(self, transparency = 0):
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        if self.__transparency == None:            self.__transparency =  []
        self.__transparency +=  [transparency]
        return self
    def removeTransparency(self, transparency):
        self.__transparency = [x for x in self.__transparency if x not in transparency]
        return self.__transparency
    def getTransparency(self, transparency = 0):
        return self.__transparency
    def transparency_changed(self, transparency = 0):
        return self.__transparency
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DBackgroundNode'
        if self.__bindTime is not None:
            if isinstance(self.__bindTime, six.string_types):
                str += ' bindTime="'+self.__bindTime+'"'
            else:
                str += ' bindTime="'+self.__bindTime[0]+'"'
        if self.__groundAngle is not None:
            if isinstance(self.__groundAngle, six.string_types):
                str += ' groundAngle="'+self.__groundAngle+'"'
            else:
                str += ' groundAngle="'+self.__groundAngle[0]+'"'
        if self.__groundColor is not None:
            if isinstance(self.__groundColor, six.string_types):
                str += ' groundColor="'+self.__groundColor+'"'
            else:
                str += ' groundColor="'+self.__groundColor[0]+'"'
        if self.__Bound is not None:
            if isinstance(self.__Bound, six.string_types):
                str += ' Bound="'+self.__Bound+'"'
            else:
                str += ' Bound="'+self.__Bound[0]+'"'
        if self.__bind is not None:
            if isinstance(self.__bind, six.string_types):
                str += ' bind="'+self.__bind+'"'
            else:
                str += ' bind="'+self.__bind[0]+'"'
        if self.__skyAngle is not None:
            if isinstance(self.__skyAngle, six.string_types):
                str += ' skyAngle="'+self.__skyAngle+'"'
            else:
                str += ' skyAngle="'+self.__skyAngle[0]+'"'
        if self.__skyColor is not None:
            if isinstance(self.__skyColor, six.string_types):
                str += ' skyColor="'+self.__skyColor+'"'
            else:
                str += ' skyColor="'+self.__skyColor[0]+'"'
        if self.__transparency is not None:
            if isinstance(self.__transparency, six.string_types):
                str += ' transparency="'+self.__transparency+'"'
            else:
                str += ' transparency="'+self.__transparency[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DBackgroundNode>'
        return str


class X3DFollowerNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DFollowerNode, self).__init__(**kwargs)
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DFollowerNode'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DFollowerNode>'
        return str


class X3DChaserNode(X3DFollowerNode):
    def __init__(self, **kwargs):
        super(X3DChaserNode, self).__init__(**kwargs)
        duration  = kwargs.pop("duration", 1)
        if duration == None or duration  <  0:
            return None
        self.__duration = duration
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DChaserNode'
        if self.__duration is not None:
            if isinstance(self.__duration, six.string_types):
                str += ' duration="'+self.__duration+'"'
            else:
                str += ' duration="'+self.__duration[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DChaserNode>'
        return str


class X3DGeometricPropertyNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DGeometricPropertyNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DGeometricPropertyNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DGeometricPropertyNode>'
        return str


class X3DColorNode(X3DGeometricPropertyNode):
    def __init__(self, **kwargs):
        super(X3DColorNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DColorNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DColorNode>'
        return str


class X3DVolumeRenderStyleNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DVolumeRenderStyleNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DVolumeRenderStyleNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DVolumeRenderStyleNode>'
        return str


class X3DComposableVolumeRenderStyleNode(X3DVolumeRenderStyleNode):
    def __init__(self, **kwargs):
        super(X3DComposableVolumeRenderStyleNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DComposableVolumeRenderStyleNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DComposableVolumeRenderStyleNode>'
        return str


class X3DGeometryNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DGeometryNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DGeometryNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DGeometryNode>'
        return str


class X3DComposedGeometryNode(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(X3DComposedGeometryNode, self).__init__(**kwargs)
        attrib  = kwargs.pop("attrib", None)
        self.__attrib = attrib
        ccw  = kwargs.pop("ccw", True)
        self.__ccw = ccw
        color  = kwargs.pop("color", None)
        self.__color = color
        colorPerVertex  = kwargs.pop("colorPerVertex", True)
        self.__colorPerVertex = colorPerVertex
        coord  = kwargs.pop("coord", None)
        self.__coord = coord
        fogCoord  = kwargs.pop("fogCoord", None)
        self.__fogCoord = fogCoord
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        normal  = kwargs.pop("normal", None)
        self.__normal = normal
        normalPerVertex  = kwargs.pop("normalPerVertex", True)
        self.__normalPerVertex = normalPerVertex
        solid  = kwargs.pop("solid", True)
        self.__solid = solid
        texCoord  = kwargs.pop("texCoord", None)
        self.__texCoord = texCoord
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def attrib(self):
        return self.__attrib
    @attrib.setter
    def attrib(self, value = None):
        self.__attrib = [value]
    def setAttrib(self, attrib = None):
        self.__attrib = [attrib]
        return self
    def addAttrib(self, attrib = None):
        if self.__attrib == None:            self.__attrib =  []
        self.__attrib +=  [attrib]
        return self
    def removeAttrib(self, attrib):
        self.__attrib = [x for x in self.__attrib if x not in attrib]
        return self.__attrib
    def getAttrib(self, attrib = None):
        return self.__attrib
    def attrib_changed(self, attrib = None):
        return self.__attrib
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = None):
        self.__color = [value]
    def setColor(self, color = None):
        self.__color = [color]
        return self
    def addColor(self, color = None):
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = None):
        return self.__color
    def color_changed(self, color = None):
        return self.__color
    @property
    def coord(self):
        return self.__coord
    @coord.setter
    def coord(self, value = None):
        self.__coord = [value]
    def setCoord(self, coord = None):
        self.__coord = [coord]
        return self
    def addCoord(self, coord = None):
        if self.__coord == None:            self.__coord =  []
        self.__coord +=  [coord]
        return self
    def removeCoord(self, coord):
        self.__coord = [x for x in self.__coord if x not in coord]
        return self.__coord
    def getCoord(self, coord = None):
        return self.__coord
    def coord_changed(self, coord = None):
        return self.__coord
    @property
    def fogCoord(self):
        return self.__fogCoord
    @fogCoord.setter
    def fogCoord(self, value = None):
        self.__fogCoord = [value]
    def setFogCoord(self, fogCoord = None):
        self.__fogCoord = [fogCoord]
        return self
    def addFogCoord(self, fogCoord = None):
        if self.__fogCoord == None:            self.__fogCoord =  []
        self.__fogCoord +=  [fogCoord]
        return self
    def removeFogCoord(self, fogCoord):
        self.__fogCoord = [x for x in self.__fogCoord if x not in fogCoord]
        return self.__fogCoord
    def getFogCoord(self, fogCoord = None):
        return self.__fogCoord
    def fogCoord_changed(self, fogCoord = None):
        return self.__fogCoord
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def normal(self):
        return self.__normal
    @normal.setter
    def normal(self, value = None):
        self.__normal = [value]
    def setNormal(self, normal = None):
        self.__normal = [normal]
        return self
    def addNormal(self, normal = None):
        if self.__normal == None:            self.__normal =  []
        self.__normal +=  [normal]
        return self
    def removeNormal(self, normal):
        self.__normal = [x for x in self.__normal if x not in normal]
        return self.__normal
    def getNormal(self, normal = None):
        return self.__normal
    def normal_changed(self, normal = None):
        return self.__normal
    @property
    def texCoord(self):
        return self.__texCoord
    @texCoord.setter
    def texCoord(self, value = None):
        self.__texCoord = [value]
    def setTexCoord(self, texCoord = None):
        self.__texCoord = [texCoord]
        return self
    def addTexCoord(self, texCoord = None):
        if self.__texCoord == None:            self.__texCoord =  []
        self.__texCoord +=  [texCoord]
        return self
    def removeTexCoord(self, texCoord):
        self.__texCoord = [x for x in self.__texCoord if x not in texCoord]
        return self.__texCoord
    def getTexCoord(self, texCoord = None):
        return self.__texCoord
    def texCoord_changed(self, texCoord = None):
        return self.__texCoord
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DComposedGeometryNode'
        if self.__ccw is not None:
            if isinstance(self.__ccw, six.string_types):
                str += ' ccw="'+self.__ccw+'"'
            else:
                str += ' ccw="'+self.__ccw[0]+'"'
        if self.__colorPerVertex is not None:
            if isinstance(self.__colorPerVertex, six.string_types):
                str += ' colorPerVertex="'+self.__colorPerVertex+'"'
            else:
                str += ' colorPerVertex="'+self.__colorPerVertex[0]+'"'
        if self.__normalPerVertex is not None:
            if isinstance(self.__normalPerVertex, six.string_types):
                str += ' normalPerVertex="'+self.__normalPerVertex+'"'
            else:
                str += ' normalPerVertex="'+self.__normalPerVertex[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<attrib'
        if self.__attrib is not None:
           for s in self.__attrib:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__attrib is not None:
           for s in self.__attrib:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</attrib>'
        str += '<color'
        if self.__color is not None:
           for s in self.__color:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__color is not None:
           for s in self.__color:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</color>'
        str += '<coord'
        if self.__coord is not None:
           for s in self.__coord:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__coord is not None:
           for s in self.__coord:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</coord>'
        str += '<fogCoord'
        if self.__fogCoord is not None:
           for s in self.__fogCoord:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__fogCoord is not None:
           for s in self.__fogCoord:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</fogCoord>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<normal'
        if self.__normal is not None:
           for s in self.__normal:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__normal is not None:
           for s in self.__normal:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</normal>'
        str += '<texCoord'
        if self.__texCoord is not None:
           for s in self.__texCoord:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__texCoord is not None:
           for s in self.__texCoord:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</texCoord>'
        str += '</X3DComposedGeometryNode>'
        return str


class X3DCoordinateNode(X3DGeometricPropertyNode):
    def __init__(self, **kwargs):
        super(X3DCoordinateNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DCoordinateNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DCoordinateNode>'
        return str


class X3DDamperNode(X3DFollowerNode):
    def __init__(self, **kwargs):
        super(X3DDamperNode, self).__init__(**kwargs)
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        order  = kwargs.pop("order", 3)
        if order == None or order  <  0:
            return None
        if order == None or order  >  5:
            return None
        self.__order = order
        tau  = kwargs.pop("tau", 0.3)
        if tau == None or tau  <  0:
            return None
        self.__tau = tau
        tolerance  = kwargs.pop("tolerance", -1)
        self.__tolerance = tolerance
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def tau(self):
        return self.__tau
    @tau.setter
    def tau(self, value = 0.3):
        if value == None or value  <  0:
            return None
        self.__tau = [value]
    def setTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        self.__tau = [tau]
        return self
    def addTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        if self.__tau == None:            self.__tau =  []
        self.__tau +=  [tau]
        return self
    def removeTau(self, tau):
        self.__tau = [x for x in self.__tau if x not in tau]
        return self.__tau
    def getTau(self, tau = 0.3):
        return self.__tau
    def tau_changed(self, tau = 0.3):
        return self.__tau
    @property
    def tolerance(self):
        return self.__tolerance
    @tolerance.setter
    def tolerance(self, value = -1):
        self.__tolerance = [value]
    def setTolerance(self, tolerance = -1):
        self.__tolerance = [tolerance]
        return self
    def addTolerance(self, tolerance = -1):
        if self.__tolerance == None:            self.__tolerance =  []
        self.__tolerance +=  [tolerance]
        return self
    def removeTolerance(self, tolerance):
        self.__tolerance = [x for x in self.__tolerance if x not in tolerance]
        return self.__tolerance
    def getTolerance(self, tolerance = -1):
        return self.__tolerance
    def tolerance_changed(self, tolerance = -1):
        return self.__tolerance
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DDamperNode'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__order is not None:
            if isinstance(self.__order, six.string_types):
                str += ' order="'+self.__order+'"'
            else:
                str += ' order="'+self.__order[0]+'"'
        if self.__tau is not None:
            if isinstance(self.__tau, six.string_types):
                str += ' tau="'+self.__tau+'"'
            else:
                str += ' tau="'+self.__tau[0]+'"'
        if self.__tolerance is not None:
            if isinstance(self.__tolerance, six.string_types):
                str += ' tolerance="'+self.__tolerance+'"'
            else:
                str += ' tolerance="'+self.__tolerance[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DDamperNode>'
        return str


class X3DSensorNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DSensorNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DSensorNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DSensorNode>'
        return str


class X3DPointingDeviceSensorNode(X3DSensorNode):
    def __init__(self, **kwargs):
        super(X3DPointingDeviceSensorNode, self).__init__(**kwargs)
        description  = kwargs.pop("description", None)
        self.__description = description
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Over  = kwargs.pop("Over", None)
        self.__Over = Over
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    def isOver(self, Over = None):
        return self.__Over
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DPointingDeviceSensorNode'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Over is not None:
            if isinstance(self.__Over, six.string_types):
                str += ' Over="'+self.__Over+'"'
            else:
                str += ' Over="'+self.__Over[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DPointingDeviceSensorNode>'
        return str


class X3DDragSensorNode(X3DPointingDeviceSensorNode):
    def __init__(self, **kwargs):
        super(X3DDragSensorNode, self).__init__(**kwargs)
        autoOffset  = kwargs.pop("autoOffset", True)
        self.__autoOffset = autoOffset
        description  = kwargs.pop("description", None)
        self.__description = description
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Over  = kwargs.pop("Over", None)
        self.__Over = Over
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        trackPoint_changed  = kwargs.pop("trackPoint_changed", None)
        self.__trackPoint_changed = trackPoint_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def autoOffset(self):
        return self.__autoOffset
    @autoOffset.setter
    def autoOffset(self, value = True):
        self.__autoOffset = [value]
    def setAutoOffset(self, autoOffset = True):
        self.__autoOffset = [autoOffset]
        return self
    def addAutoOffset(self, autoOffset = True):
        if self.__autoOffset == None:            self.__autoOffset =  []
        self.__autoOffset +=  [autoOffset]
        return self
    def removeAutoOffset(self, autoOffset):
        self.__autoOffset = [x for x in self.__autoOffset if x not in autoOffset]
        return self.__autoOffset
    def isAutoOffset(self, autoOffset = True):
        return self.__autoOffset
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    def isOver(self, Over = None):
        return self.__Over
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    def removetrackPoint_changed(self, trackPoint_changed):
        self.__trackPoint_changed = [x for x in self.__trackPoint_changed if x not in trackPoint_changed]
        return self.__trackPoint_changed
    def gettrackPoint_changed(self, trackPoint_changed = None):
        return self.__trackPoint_changed
    def trackPoint_changed_changed(self, trackPoint_changed = None):
        return self.__trackPoint_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DDragSensorNode'
        if self.__autoOffset is not None:
            if isinstance(self.__autoOffset, six.string_types):
                str += ' autoOffset="'+self.__autoOffset+'"'
            else:
                str += ' autoOffset="'+self.__autoOffset[0]+'"'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Over is not None:
            if isinstance(self.__Over, six.string_types):
                str += ' Over="'+self.__Over+'"'
            else:
                str += ' Over="'+self.__Over[0]+'"'
        if self.__trackPoint_changed is not None:
            if isinstance(self.__trackPoint_changed, six.string_types):
                str += ' trackPoint_changed="'+self.__trackPoint_changed+'"'
            else:
                str += ' trackPoint_changed="'+self.__trackPoint_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DDragSensorNode>'
        return str


class X3DEnvironmentalSensorNode(X3DSensorNode):
    def __init__(self, **kwargs):
        super(X3DEnvironmentalSensorNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        size  = kwargs.pop("size", [0, 0, 0])
        if size == None or len(size) <= 0 or min(size)  <  0:
            return None
        self.__size = size
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DEnvironmentalSensorNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__size is not None:
            if isinstance(self.__size, six.string_types):
                str += ' size="'+self.__size+'"'
            else:
                str += ' size="'+self.__size[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DEnvironmentalSensorNode>'
        return str


class X3DTextureNode(X3DAppearanceChildNode):
    def __init__(self, **kwargs):
        super(X3DTextureNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTextureNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTextureNode>'
        return str


class X3DEnvironmentTextureNode(X3DTextureNode):
    def __init__(self, **kwargs):
        super(X3DEnvironmentTextureNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DEnvironmentTextureNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DEnvironmentTextureNode>'
        return str


class X3DFontStyleNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DFontStyleNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DFontStyleNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DFontStyleNode>'
        return str


class X3DBoundedObject(object):
    def __init__(self, **kwargs):
        super(X3DBoundedObject, self).__init__()
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DBoundedObject'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        str += '>'
        str += '</X3DBoundedObject>'
        return str


class X3DGroupingNode(X3DBoundedObject, X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DGroupingNode, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DGroupingNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</X3DGroupingNode>'
        return str


class X3DInfoNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DInfoNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DInfoNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DInfoNode>'
        return str


class X3DInterpolatorNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DInterpolatorNode, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DInterpolatorNode'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DInterpolatorNode>'
        return str


class X3DKeyDeviceSensorNode(X3DSensorNode):
    def __init__(self, **kwargs):
        super(X3DKeyDeviceSensorNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DKeyDeviceSensorNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DKeyDeviceSensorNode>'
        return str


class X3DLayerNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DLayerNode, self).__init__(**kwargs)
        Pickable  = kwargs.pop("Pickable", True)
        self.__Pickable = Pickable
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        viewport  = kwargs.pop("viewport", None)
        self.__viewport = viewport
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Pickable(self):
        return self.__Pickable
    @Pickable.setter
    def Pickable(self, value = True):
        self.__Pickable = [value]
    def setIsPickable(self, Pickable = True):
        self.__Pickable = [Pickable]
        return self
    def addIsPickable(self, Pickable = True):
        if self.__Pickable == None:            self.__Pickable =  []
        self.__Pickable +=  [Pickable]
        return self
    def isPickable(self, Pickable = True):
        return self.__Pickable
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def viewport(self):
        return self.__viewport
    @viewport.setter
    def viewport(self, value = None):
        self.__viewport = [value]
    def setViewport(self, viewport = None):
        self.__viewport = [viewport]
        return self
    def addViewport(self, viewport = None):
        if self.__viewport == None:            self.__viewport =  []
        self.__viewport +=  [viewport]
        return self
    def removeViewport(self, viewport):
        self.__viewport = [x for x in self.__viewport if x not in viewport]
        return self.__viewport
    def getViewport(self, viewport = None):
        return self.__viewport
    def viewport_changed(self, viewport = None):
        return self.__viewport
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DLayerNode'
        if self.__Pickable is not None:
            if isinstance(self.__Pickable, six.string_types):
                str += ' Pickable="'+self.__Pickable+'"'
            else:
                str += ' Pickable="'+self.__Pickable[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<viewport'
        if self.__viewport is not None:
           for s in self.__viewport:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__viewport is not None:
           for s in self.__viewport:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</viewport>'
        str += '</X3DLayerNode>'
        return str


class X3DLayoutNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DLayoutNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DLayoutNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DLayoutNode>'
        return str


class X3DLightNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DLightNode, self).__init__(**kwargs)
        ambientIntensity  = kwargs.pop("ambientIntensity", 0)
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        self.__ambientIntensity = ambientIntensity
        color  = kwargs.pop("color", [1, 1, 1])
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = color
        intensity  = kwargs.pop("intensity", 1)
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        self.__intensity = intensity
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        on  = kwargs.pop("on", True)
        self.__on = on
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def ambientIntensity(self):
        return self.__ambientIntensity
    @ambientIntensity.setter
    def ambientIntensity(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__ambientIntensity = [value]
    def setAmbientIntensity(self, ambientIntensity = 0):
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        self.__ambientIntensity = [ambientIntensity]
        return self
    def addAmbientIntensity(self, ambientIntensity = 0):
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        if self.__ambientIntensity == None:            self.__ambientIntensity =  []
        self.__ambientIntensity +=  [ambientIntensity]
        return self
    def removeAmbientIntensity(self, ambientIntensity):
        self.__ambientIntensity = [x for x in self.__ambientIntensity if x not in ambientIntensity]
        return self.__ambientIntensity
    def getAmbientIntensity(self, ambientIntensity = 0):
        return self.__ambientIntensity
    def ambientIntensity_changed(self, ambientIntensity = 0):
        return self.__ambientIntensity
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = [1, 1, 1]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__color = [value]
    def setColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = [color]
        return self
    def addColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = [1, 1, 1]):
        return self.__color
    def color_changed(self, color = [1, 1, 1]):
        return self.__color
    @property
    def intensity(self):
        return self.__intensity
    @intensity.setter
    def intensity(self, value = 1):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__intensity = [value]
    def setIntensity(self, intensity = 1):
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        self.__intensity = [intensity]
        return self
    def addIntensity(self, intensity = 1):
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        if self.__intensity == None:            self.__intensity =  []
        self.__intensity +=  [intensity]
        return self
    def removeIntensity(self, intensity):
        self.__intensity = [x for x in self.__intensity if x not in intensity]
        return self.__intensity
    def getIntensity(self, intensity = 1):
        return self.__intensity
    def intensity_changed(self, intensity = 1):
        return self.__intensity
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def on(self):
        return self.__on
    @on.setter
    def on(self, value = True):
        self.__on = [value]
    def setOn(self, on = True):
        self.__on = [on]
        return self
    def addOn(self, on = True):
        if self.__on == None:            self.__on =  []
        self.__on +=  [on]
        return self
    def removeOn(self, on):
        self.__on = [x for x in self.__on if x not in on]
        return self.__on
    def isOn(self, on = True):
        return self.__on
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DLightNode'
        if self.__ambientIntensity is not None:
            if isinstance(self.__ambientIntensity, six.string_types):
                str += ' ambientIntensity="'+self.__ambientIntensity+'"'
            else:
                str += ' ambientIntensity="'+self.__ambientIntensity[0]+'"'
        if self.__color is not None:
            if isinstance(self.__color, six.string_types):
                str += ' color="'+self.__color+'"'
            else:
                str += ' color="'+self.__color[0]+'"'
        if self.__intensity is not None:
            if isinstance(self.__intensity, six.string_types):
                str += ' intensity="'+self.__intensity+'"'
            else:
                str += ' intensity="'+self.__intensity[0]+'"'
        if self.__on is not None:
            if isinstance(self.__on, six.string_types):
                str += ' on="'+self.__on+'"'
            else:
                str += ' on="'+self.__on[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DLightNode>'
        return str


class X3DMaterialNode(X3DAppearanceChildNode):
    def __init__(self, **kwargs):
        super(X3DMaterialNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DMaterialNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DMaterialNode>'
        return str


class X3DNBodyCollidableNode(X3DBoundedObject, X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DNBodyCollidableNode, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        rotation  = kwargs.pop("rotation", [0, 0, 1, 0])
        self.__rotation = rotation
        translation  = kwargs.pop("translation", [0, 0, 0])
        self.__translation = translation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def rotation(self):
        return self.__rotation
    @rotation.setter
    def rotation(self, value = [0, 0, 1, 0]):
        self.__rotation = [value]
    def setRotation(self, rotation = [0, 0, 1, 0]):
        self.__rotation = [rotation]
        return self
    def addRotation(self, rotation = [0, 0, 1, 0]):
        if self.__rotation == None:            self.__rotation =  []
        self.__rotation +=  [rotation]
        return self
    def removeRotation(self, rotation):
        self.__rotation = [x for x in self.__rotation if x not in rotation]
        return self.__rotation
    def getRotation(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    def rotation_changed(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    @property
    def translation(self):
        return self.__translation
    @translation.setter
    def translation(self, value = [0, 0, 0]):
        self.__translation = [value]
    def setTranslation(self, translation = [0, 0, 0]):
        self.__translation = [translation]
        return self
    def addTranslation(self, translation = [0, 0, 0]):
        if self.__translation == None:            self.__translation =  []
        self.__translation +=  [translation]
        return self
    def removeTranslation(self, translation):
        self.__translation = [x for x in self.__translation if x not in translation]
        return self.__translation
    def getTranslation(self, translation = [0, 0, 0]):
        return self.__translation
    def translation_changed(self, translation = [0, 0, 0]):
        return self.__translation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNBodyCollidableNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__rotation is not None:
            if isinstance(self.__rotation, six.string_types):
                str += ' rotation="'+self.__rotation+'"'
            else:
                str += ' rotation="'+self.__rotation[0]+'"'
        if self.__translation is not None:
            if isinstance(self.__translation, six.string_types):
                str += ' translation="'+self.__translation+'"'
            else:
                str += ' translation="'+self.__translation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNBodyCollidableNode>'
        return str


class X3DNBodyCollisionSpaceNode(X3DBoundedObject, X3DNode):
    def __init__(self, **kwargs):
        super(X3DNBodyCollisionSpaceNode, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNBodyCollisionSpaceNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNBodyCollisionSpaceNode>'
        return str


class X3DNetworkSensorNode(X3DSensorNode):
    def __init__(self, **kwargs):
        super(X3DNetworkSensorNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNetworkSensorNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNetworkSensorNode>'
        return str


class X3DNormalNode(X3DGeometricPropertyNode):
    def __init__(self, **kwargs):
        super(X3DNormalNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNormalNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNormalNode>'
        return str


class X3DNurbsControlCurveNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DNurbsControlCurveNode, self).__init__(**kwargs)
        controlPoint  = kwargs.pop("controlPoint", None)
        self.__controlPoint = controlPoint
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def controlPoint(self):
        return self.__controlPoint
    @controlPoint.setter
    def controlPoint(self, value = None):
        self.__controlPoint = [value]
    def setControlPoint(self, controlPoint = None):
        self.__controlPoint = [controlPoint]
        return self
    def addControlPoint(self, controlPoint = None):
        if self.__controlPoint == None:            self.__controlPoint =  []
        self.__controlPoint +=  [controlPoint]
        return self
    def removeControlPoint(self, controlPoint):
        self.__controlPoint = [x for x in self.__controlPoint if x not in controlPoint]
        return self.__controlPoint
    def getControlPoint(self, controlPoint = None):
        return self.__controlPoint
    def controlPoint_changed(self, controlPoint = None):
        return self.__controlPoint
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNurbsControlCurveNode'
        if self.__controlPoint is not None:
            if isinstance(self.__controlPoint, six.string_types):
                str += ' controlPoint="'+self.__controlPoint+'"'
            else:
                str += ' controlPoint="'+self.__controlPoint[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DNurbsControlCurveNode>'
        return str


class X3DParametricGeometryNode(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(X3DParametricGeometryNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DParametricGeometryNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DParametricGeometryNode>'
        return str


class X3DNurbsSurfaceGeometryNode(X3DParametricGeometryNode):
    def __init__(self, **kwargs):
        super(X3DNurbsSurfaceGeometryNode, self).__init__(**kwargs)
        controlPoint  = kwargs.pop("controlPoint", None)
        self.__controlPoint = controlPoint
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        solid  = kwargs.pop("solid", True)
        self.__solid = solid
        texCoord  = kwargs.pop("texCoord", None)
        self.__texCoord = texCoord
        uClosed  = kwargs.pop("uClosed", False)
        self.__uClosed = uClosed
        uDimension  = kwargs.pop("uDimension", 0)
        if uDimension == None or uDimension  <  0:
            return None
        self.__uDimension = uDimension
        uKnot  = kwargs.pop("uKnot", None)
        self.__uKnot = uKnot
        uOrder  = kwargs.pop("uOrder", 3)
        if uOrder == None or uOrder  <  2:
            return None
        self.__uOrder = uOrder
        uTessellation  = kwargs.pop("uTessellation", 0)
        self.__uTessellation = uTessellation
        vClosed  = kwargs.pop("vClosed", False)
        self.__vClosed = vClosed
        vDimension  = kwargs.pop("vDimension", 0)
        if vDimension == None or vDimension  <  0:
            return None
        self.__vDimension = vDimension
        vKnot  = kwargs.pop("vKnot", None)
        self.__vKnot = vKnot
        vOrder  = kwargs.pop("vOrder", 3)
        if vOrder == None or vOrder  <  2:
            return None
        self.__vOrder = vOrder
        vTessellation  = kwargs.pop("vTessellation", 0)
        self.__vTessellation = vTessellation
        weight  = kwargs.pop("weight", None)
        if weight == None or len(weight) <= 0 or min(weight)  <=  0:
            return None
        self.__weight = weight
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def controlPoint(self):
        return self.__controlPoint
    @controlPoint.setter
    def controlPoint(self, value = None):
        self.__controlPoint = [value]
    def setControlPoint(self, controlPoint = None):
        self.__controlPoint = [controlPoint]
        return self
    def addControlPoint(self, controlPoint = None):
        if self.__controlPoint == None:            self.__controlPoint =  []
        self.__controlPoint +=  [controlPoint]
        return self
    def removeControlPoint(self, controlPoint):
        self.__controlPoint = [x for x in self.__controlPoint if x not in controlPoint]
        return self.__controlPoint
    def getControlPoint(self, controlPoint = None):
        return self.__controlPoint
    def controlPoint_changed(self, controlPoint = None):
        return self.__controlPoint
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def texCoord(self):
        return self.__texCoord
    @texCoord.setter
    def texCoord(self, value = None):
        self.__texCoord = [value]
    def setTexCoord(self, texCoord = None):
        self.__texCoord = [texCoord]
        return self
    def addTexCoord(self, texCoord = None):
        if self.__texCoord == None:            self.__texCoord =  []
        self.__texCoord +=  [texCoord]
        return self
    def removeTexCoord(self, texCoord):
        self.__texCoord = [x for x in self.__texCoord if x not in texCoord]
        return self.__texCoord
    def getTexCoord(self, texCoord = None):
        return self.__texCoord
    def texCoord_changed(self, texCoord = None):
        return self.__texCoord
    @property
    def uTessellation(self):
        return self.__uTessellation
    @uTessellation.setter
    def uTessellation(self, value = 0):
        self.__uTessellation = [value]
    def setUTessellation(self, uTessellation = 0):
        self.__uTessellation = [uTessellation]
        return self
    def addUTessellation(self, uTessellation = 0):
        if self.__uTessellation == None:            self.__uTessellation =  []
        self.__uTessellation +=  [uTessellation]
        return self
    def removeUTessellation(self, uTessellation):
        self.__uTessellation = [x for x in self.__uTessellation if x not in uTessellation]
        return self.__uTessellation
    def getUTessellation(self, uTessellation = 0):
        return self.__uTessellation
    def uTessellation_changed(self, uTessellation = 0):
        return self.__uTessellation
    @property
    def vTessellation(self):
        return self.__vTessellation
    @vTessellation.setter
    def vTessellation(self, value = 0):
        self.__vTessellation = [value]
    def setVTessellation(self, vTessellation = 0):
        self.__vTessellation = [vTessellation]
        return self
    def addVTessellation(self, vTessellation = 0):
        if self.__vTessellation == None:            self.__vTessellation =  []
        self.__vTessellation +=  [vTessellation]
        return self
    def removeVTessellation(self, vTessellation):
        self.__vTessellation = [x for x in self.__vTessellation if x not in vTessellation]
        return self.__vTessellation
    def getVTessellation(self, vTessellation = 0):
        return self.__vTessellation
    def vTessellation_changed(self, vTessellation = 0):
        return self.__vTessellation
    @property
    def weight(self):
        return self.__weight
    @weight.setter
    def weight(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <=  0:
            return None
        self.__weight = [value]
    def setWeight(self, weight = None):
        if weight == None or len(weight) <= 0 or min(weight)  <=  0:
            return None
        self.__weight = [weight]
        return self
    def addWeight(self, weight = None):
        if weight == None or len(weight) <= 0 or min(weight)  <=  0:
            return None
        if self.__weight == None:            self.__weight =  []
        self.__weight +=  [weight]
        return self
    def removeWeight(self, weight):
        self.__weight = [x for x in self.__weight if x not in weight]
        return self.__weight
    def getWeight(self, weight = None):
        return self.__weight
    def weight_changed(self, weight = None):
        return self.__weight
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DNurbsSurfaceGeometryNode'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__uClosed is not None:
            if isinstance(self.__uClosed, six.string_types):
                str += ' uClosed="'+self.__uClosed+'"'
            else:
                str += ' uClosed="'+self.__uClosed[0]+'"'
        if self.__uDimension is not None:
            if isinstance(self.__uDimension, six.string_types):
                str += ' uDimension="'+self.__uDimension+'"'
            else:
                str += ' uDimension="'+self.__uDimension[0]+'"'
        if self.__uKnot is not None:
            if isinstance(self.__uKnot, six.string_types):
                str += ' uKnot="'+self.__uKnot+'"'
            else:
                str += ' uKnot="'+self.__uKnot[0]+'"'
        if self.__uOrder is not None:
            if isinstance(self.__uOrder, six.string_types):
                str += ' uOrder="'+self.__uOrder+'"'
            else:
                str += ' uOrder="'+self.__uOrder[0]+'"'
        if self.__uTessellation is not None:
            if isinstance(self.__uTessellation, six.string_types):
                str += ' uTessellation="'+self.__uTessellation+'"'
            else:
                str += ' uTessellation="'+self.__uTessellation[0]+'"'
        if self.__vClosed is not None:
            if isinstance(self.__vClosed, six.string_types):
                str += ' vClosed="'+self.__vClosed+'"'
            else:
                str += ' vClosed="'+self.__vClosed[0]+'"'
        if self.__vDimension is not None:
            if isinstance(self.__vDimension, six.string_types):
                str += ' vDimension="'+self.__vDimension+'"'
            else:
                str += ' vDimension="'+self.__vDimension[0]+'"'
        if self.__vKnot is not None:
            if isinstance(self.__vKnot, six.string_types):
                str += ' vKnot="'+self.__vKnot+'"'
            else:
                str += ' vKnot="'+self.__vKnot[0]+'"'
        if self.__vOrder is not None:
            if isinstance(self.__vOrder, six.string_types):
                str += ' vOrder="'+self.__vOrder+'"'
            else:
                str += ' vOrder="'+self.__vOrder[0]+'"'
        if self.__vTessellation is not None:
            if isinstance(self.__vTessellation, six.string_types):
                str += ' vTessellation="'+self.__vTessellation+'"'
            else:
                str += ' vTessellation="'+self.__vTessellation[0]+'"'
        if self.__weight is not None:
            if isinstance(self.__weight, six.string_types):
                str += ' weight="'+self.__weight+'"'
            else:
                str += ' weight="'+self.__weight[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<controlPoint'
        if self.__controlPoint is not None:
           for s in self.__controlPoint:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__controlPoint is not None:
           for s in self.__controlPoint:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</controlPoint>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<texCoord'
        if self.__texCoord is not None:
           for s in self.__texCoord:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__texCoord is not None:
           for s in self.__texCoord:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</texCoord>'
        str += '</X3DNurbsSurfaceGeometryNode>'
        return str


class X3DParticleEmitterNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DParticleEmitterNode, self).__init__(**kwargs)
        mass  = kwargs.pop("mass", 0)
        if mass == None or mass  <  0:
            return None
        self.__mass = mass
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        speed  = kwargs.pop("speed", 0)
        if speed == None or speed  <  0:
            return None
        self.__speed = speed
        surfaceArea  = kwargs.pop("surfaceArea", 0)
        if surfaceArea == None or surfaceArea  <  0:
            return None
        self.__surfaceArea = surfaceArea
        variation  = kwargs.pop("variation", 0.25)
        if variation == None or variation  <  0:
            return None
        self.__variation = variation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def mass(self):
        return self.__mass
    @mass.setter
    def mass(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__mass = [value]
    def setMass(self, mass = 0):
        if mass == None or mass  <  0:
            return None
        self.__mass = [mass]
        return self
    def addMass(self, mass = 0):
        if mass == None or mass  <  0:
            return None
        if self.__mass == None:            self.__mass =  []
        self.__mass +=  [mass]
        return self
    def removeMass(self, mass):
        self.__mass = [x for x in self.__mass if x not in mass]
        return self.__mass
    def getMass(self, mass = 0):
        return self.__mass
    def mass_changed(self, mass = 0):
        return self.__mass
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def speed(self):
        return self.__speed
    @speed.setter
    def speed(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__speed = [value]
    def setSpeed(self, speed = 0):
        if speed == None or speed  <  0:
            return None
        self.__speed = [speed]
        return self
    def addSpeed(self, speed = 0):
        if speed == None or speed  <  0:
            return None
        if self.__speed == None:            self.__speed =  []
        self.__speed +=  [speed]
        return self
    def removeSpeed(self, speed):
        self.__speed = [x for x in self.__speed if x not in speed]
        return self.__speed
    def getSpeed(self, speed = 0):
        return self.__speed
    def speed_changed(self, speed = 0):
        return self.__speed
    @property
    def variation(self):
        return self.__variation
    @variation.setter
    def variation(self, value = 0.25):
        if value == None or value  <  0:
            return None
        self.__variation = [value]
    def setVariation(self, variation = 0.25):
        if variation == None or variation  <  0:
            return None
        self.__variation = [variation]
        return self
    def addVariation(self, variation = 0.25):
        if variation == None or variation  <  0:
            return None
        if self.__variation == None:            self.__variation =  []
        self.__variation +=  [variation]
        return self
    def removeVariation(self, variation):
        self.__variation = [x for x in self.__variation if x not in variation]
        return self.__variation
    def getVariation(self, variation = 0.25):
        return self.__variation
    def variation_changed(self, variation = 0.25):
        return self.__variation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DParticleEmitterNode'
        if self.__mass is not None:
            if isinstance(self.__mass, six.string_types):
                str += ' mass="'+self.__mass+'"'
            else:
                str += ' mass="'+self.__mass[0]+'"'
        if self.__speed is not None:
            if isinstance(self.__speed, six.string_types):
                str += ' speed="'+self.__speed+'"'
            else:
                str += ' speed="'+self.__speed[0]+'"'
        if self.__surfaceArea is not None:
            if isinstance(self.__surfaceArea, six.string_types):
                str += ' surfaceArea="'+self.__surfaceArea+'"'
            else:
                str += ' surfaceArea="'+self.__surfaceArea[0]+'"'
        if self.__variation is not None:
            if isinstance(self.__variation, six.string_types):
                str += ' variation="'+self.__variation+'"'
            else:
                str += ' variation="'+self.__variation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DParticleEmitterNode>'
        return str


class X3DParticlePhysicsModelNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DParticlePhysicsModelNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DParticlePhysicsModelNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DParticlePhysicsModelNode>'
        return str


class X3DPickSensorNode(X3DSensorNode):
    def __init__(self, **kwargs):
        super(X3DPickSensorNode, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        intersectionType  = kwargs.pop("intersectionType", "BOUNDS")
        self.__intersectionType = intersectionType
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        matchCriterion  = kwargs.pop("matchCriterion", "MATCH_ANY")
        if 'MATCH_ANY' == matchCriterion:
            pass
        elif 'MATCH_EVERY' == matchCriterion:
            pass
        elif 'MATCH_ONLY_ONE' == matchCriterion:
            pass
        else:
            return None
        self.__matchCriterion = matchCriterion
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        objectType  = kwargs.pop("objectType", ["ALL"])
        self.__objectType = objectType
        pickedGeometry  = kwargs.pop("pickedGeometry", None)
        self.__pickedGeometry = pickedGeometry
        pickingGeometry  = kwargs.pop("pickingGeometry", None)
        self.__pickingGeometry = pickingGeometry
        pickTarget  = kwargs.pop("pickTarget", None)
        self.__pickTarget = pickTarget
        sortOrder  = kwargs.pop("sortOrder", "CLOSEST")
        self.__sortOrder = sortOrder
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def matchCriterion(self):
        return self.__matchCriterion
    @matchCriterion.setter
    def matchCriterion(self, value = "MATCH_ANY"):
        if 'MATCH_ANY' == value:
            pass
        elif 'MATCH_EVERY' == value:
            pass
        elif 'MATCH_ONLY_ONE' == value:
            pass
        else:
            return None
        self.__matchCriterion = [value]
    def setMatchCriterion(self, matchCriterion = "MATCH_ANY"):
        if 'MATCH_ANY' == matchCriterion:
            pass
        elif 'MATCH_EVERY' == matchCriterion:
            pass
        elif 'MATCH_ONLY_ONE' == matchCriterion:
            pass
        else:
            return None
        self.__matchCriterion = [matchCriterion]
        return self
    def addMatchCriterion(self, matchCriterion = "MATCH_ANY"):
        if 'MATCH_ANY' == matchCriterion:
            pass
        elif 'MATCH_EVERY' == matchCriterion:
            pass
        elif 'MATCH_ONLY_ONE' == matchCriterion:
            pass
        else:
            return None
        if self.__matchCriterion == None:            self.__matchCriterion =  []
        self.__matchCriterion +=  [matchCriterion]
        return self
    def removeMatchCriterion(self, matchCriterion):
        self.__matchCriterion = [x for x in self.__matchCriterion if x not in matchCriterion]
        return self.__matchCriterion
    def getMatchCriterion(self, matchCriterion = "MATCH_ANY"):
        return self.__matchCriterion
    def matchCriterion_changed(self, matchCriterion = "MATCH_ANY"):
        return self.__matchCriterion
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def objectType(self):
        return self.__objectType
    @objectType.setter
    def objectType(self, value = ["ALL"]):
        self.__objectType = [value]
    def setObjectType(self, objectType = ["ALL"]):
        self.__objectType = [objectType]
        return self
    def addObjectType(self, objectType = ["ALL"]):
        if self.__objectType == None:            self.__objectType =  []
        self.__objectType +=  [objectType]
        return self
    def removeObjectType(self, objectType):
        self.__objectType = [x for x in self.__objectType if x not in objectType]
        return self.__objectType
    def getObjectType(self, objectType = ["ALL"]):
        return self.__objectType
    def objectType_changed(self, objectType = ["ALL"]):
        return self.__objectType
    def removePickedGeometry(self, pickedGeometry):
        self.__pickedGeometry = [x for x in self.__pickedGeometry if x not in pickedGeometry]
        return self.__pickedGeometry
    def getPickedGeometry(self, pickedGeometry = None):
        return self.__pickedGeometry
    def pickedGeometry_changed(self, pickedGeometry = None):
        return self.__pickedGeometry
    @property
    def pickingGeometry(self):
        return self.__pickingGeometry
    @pickingGeometry.setter
    def pickingGeometry(self, value = None):
        self.__pickingGeometry = [value]
    def setPickingGeometry(self, pickingGeometry = None):
        self.__pickingGeometry = [pickingGeometry]
        return self
    def addPickingGeometry(self, pickingGeometry = None):
        if self.__pickingGeometry == None:            self.__pickingGeometry =  []
        self.__pickingGeometry +=  [pickingGeometry]
        return self
    def removePickingGeometry(self, pickingGeometry):
        self.__pickingGeometry = [x for x in self.__pickingGeometry if x not in pickingGeometry]
        return self.__pickingGeometry
    def getPickingGeometry(self, pickingGeometry = None):
        return self.__pickingGeometry
    def pickingGeometry_changed(self, pickingGeometry = None):
        return self.__pickingGeometry
    @property
    def pickTarget(self):
        return self.__pickTarget
    @pickTarget.setter
    def pickTarget(self, value = None):
        self.__pickTarget = [value]
    def setPickTarget(self, pickTarget = None):
        self.__pickTarget = [pickTarget]
        return self
    def addPickTarget(self, pickTarget = None):
        if self.__pickTarget == None:            self.__pickTarget =  []
        self.__pickTarget +=  [pickTarget]
        return self
    def removePickTarget(self, pickTarget):
        self.__pickTarget = [x for x in self.__pickTarget if x not in pickTarget]
        return self.__pickTarget
    def getPickTarget(self, pickTarget = None):
        return self.__pickTarget
    def pickTarget_changed(self, pickTarget = None):
        return self.__pickTarget
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DPickSensorNode'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__intersectionType is not None:
            if isinstance(self.__intersectionType, six.string_types):
                str += ' intersectionType="'+self.__intersectionType+'"'
            else:
                str += ' intersectionType="'+self.__intersectionType[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__matchCriterion is not None:
            if isinstance(self.__matchCriterion, six.string_types):
                str += ' matchCriterion="'+self.__matchCriterion+'"'
            else:
                str += ' matchCriterion="'+self.__matchCriterion[0]+'"'
        if self.__objectType is not None:
            if isinstance(self.__objectType, six.string_types):
                str += ' objectType="'+self.__objectType+'"'
            else:
                str += ' objectType="'+self.__objectType[0]+'"'
        if self.__sortOrder is not None:
            if isinstance(self.__sortOrder, six.string_types):
                str += ' sortOrder="'+self.__sortOrder+'"'
            else:
                str += ' sortOrder="'+self.__sortOrder[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<pickedGeometry'
        if self.__pickedGeometry is not None:
           for s in self.__pickedGeometry:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__pickedGeometry is not None:
           for s in self.__pickedGeometry:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</pickedGeometry>'
        str += '<pickingGeometry'
        if self.__pickingGeometry is not None:
           for s in self.__pickingGeometry:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__pickingGeometry is not None:
           for s in self.__pickingGeometry:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</pickingGeometry>'
        str += '<pickTarget'
        if self.__pickTarget is not None:
           for s in self.__pickTarget:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__pickTarget is not None:
           for s in self.__pickTarget:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</pickTarget>'
        str += '</X3DPickSensorNode>'
        return str


class X3DProductStructureChildNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DProductStructureChildNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DProductStructureChildNode'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DProductStructureChildNode>'
        return str


class X3DPrototypeInstance(X3DNode):
    def __init__(self, **kwargs):
        super(X3DPrototypeInstance, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DPrototypeInstance'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DPrototypeInstance>'
        return str


class X3DRigidJointNode(X3DNode):
    def __init__(self, **kwargs):
        super(X3DRigidJointNode, self).__init__(**kwargs)
        body1  = kwargs.pop("body1", None)
        self.__body1 = body1
        body2  = kwargs.pop("body2", None)
        self.__body2 = body2
        forceOutput  = kwargs.pop("forceOutput", ["NONE"])
        self.__forceOutput = forceOutput
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def body1(self):
        return self.__body1
    @body1.setter
    def body1(self, value = None):
        self.__body1 = [value]
    def setBody1(self, body1 = None):
        self.__body1 = [body1]
        return self
    def addBody1(self, body1 = None):
        if self.__body1 == None:            self.__body1 =  []
        self.__body1 +=  [body1]
        return self
    def removeBody1(self, body1):
        self.__body1 = [x for x in self.__body1 if x not in body1]
        return self.__body1
    def getBody1(self, body1 = None):
        return self.__body1
    def body1_changed(self, body1 = None):
        return self.__body1
    @property
    def body2(self):
        return self.__body2
    @body2.setter
    def body2(self, value = None):
        self.__body2 = [value]
    def setBody2(self, body2 = None):
        self.__body2 = [body2]
        return self
    def addBody2(self, body2 = None):
        if self.__body2 == None:            self.__body2 =  []
        self.__body2 +=  [body2]
        return self
    def removeBody2(self, body2):
        self.__body2 = [x for x in self.__body2 if x not in body2]
        return self.__body2
    def getBody2(self, body2 = None):
        return self.__body2
    def body2_changed(self, body2 = None):
        return self.__body2
    @property
    def forceOutput(self):
        return self.__forceOutput
    @forceOutput.setter
    def forceOutput(self, value = ["NONE"]):
        self.__forceOutput = [value]
    def setForceOutput(self, forceOutput = ["NONE"]):
        self.__forceOutput = [forceOutput]
        return self
    def addForceOutput(self, forceOutput = ["NONE"]):
        if self.__forceOutput == None:            self.__forceOutput =  []
        self.__forceOutput +=  [forceOutput]
        return self
    def removeForceOutput(self, forceOutput):
        self.__forceOutput = [x for x in self.__forceOutput if x not in forceOutput]
        return self.__forceOutput
    def getForceOutput(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    def forceOutput_changed(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DRigidJointNode'
        if self.__forceOutput is not None:
            if isinstance(self.__forceOutput, six.string_types):
                str += ' forceOutput="'+self.__forceOutput+'"'
            else:
                str += ' forceOutput="'+self.__forceOutput[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<body1'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body1>'
        str += '<body2'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body2>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DRigidJointNode>'
        return str


class X3DUrlObject(object):
    def __init__(self, **kwargs):
        super(X3DUrlObject, self).__init__()
        url  = kwargs.pop("url", None)
        self.__url = url
    @property
    def url(self):
        return self.__url
    @url.setter
    def url(self, value = None):
        self.__url = [value]
    def setUrl(self, url = None):
        self.__url = [url]
        return self
    def addUrl(self, url = None):
        if self.__url == None:            self.__url =  []
        self.__url +=  [url]
        return self
    def removeUrl(self, url):
        self.__url = [x for x in self.__url if x not in url]
        return self.__url
    def getUrl(self, url = None):
        return self.__url
    def url_changed(self, url = None):
        return self.__url
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DUrlObject'
        if self.__url is not None:
            if isinstance(self.__url, six.string_types):
                str += ' url="'+self.__url+'"'
            else:
                str += ' url="'+self.__url[0]+'"'
        str += '>'
        str += '</X3DUrlObject>'
        return str


class X3DScriptNode(X3DUrlObject, X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DScriptNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        url  = kwargs.pop("url", None)
        self.__url = url
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def url(self):
        return self.__url
    @url.setter
    def url(self, value = None):
        self.__url = [value]
    def setUrl(self, url = None):
        self.__url = [url]
        return self
    def addUrl(self, url = None):
        if self.__url == None:            self.__url =  []
        self.__url +=  [url]
        return self
    def removeUrl(self, url):
        self.__url = [x for x in self.__url if x not in url]
        return self.__url
    def getUrl(self, url = None):
        return self.__url
    def url_changed(self, url = None):
        return self.__url
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DScriptNode'
        if self.__url is not None:
            if isinstance(self.__url, six.string_types):
                str += ' url="'+self.__url+'"'
            else:
                str += ' url="'+self.__url[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DScriptNode>'
        return str


class X3DSequencerNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DSequencerNode, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        next  = kwargs.pop("next", None)
        self.__next = next
        previous  = kwargs.pop("previous", None)
        self.__previous = previous
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def next(self):
        return self.__next
    @next.setter
    def next(self, value = None):
        self.__next = [value]
    def setNext(self, next = None):
        self.__next = [next]
        return self
    def addNext(self, next = None):
        if self.__next == None:            self.__next =  []
        self.__next +=  [next]
        return self
    @property
    def previous(self):
        return self.__previous
    @previous.setter
    def previous(self, value = None):
        self.__previous = [value]
    def setPrevious(self, previous = None):
        self.__previous = [previous]
        return self
    def addPrevious(self, previous = None):
        if self.__previous == None:            self.__previous =  []
        self.__previous +=  [previous]
        return self
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DSequencerNode'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__next is not None:
            if isinstance(self.__next, six.string_types):
                str += ' next="'+self.__next+'"'
            else:
                str += ' next="'+self.__next[0]+'"'
        if self.__previous is not None:
            if isinstance(self.__previous, six.string_types):
                str += ' previous="'+self.__previous+'"'
            else:
                str += ' previous="'+self.__previous[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DSequencerNode>'
        return str


class X3DShaderNode(X3DAppearanceChildNode):
    def __init__(self, **kwargs):
        super(X3DShaderNode, self).__init__(**kwargs)
        activate  = kwargs.pop("activate", None)
        self.__activate = activate
        Selected  = kwargs.pop("Selected", None)
        self.__Selected = Selected
        Valid  = kwargs.pop("Valid", None)
        self.__Valid = Valid
        language  = kwargs.pop("language", None)
        self.__language = language
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def activate(self):
        return self.__activate
    @activate.setter
    def activate(self, value = None):
        self.__activate = [value]
    def setActivate(self, activate = None):
        self.__activate = [activate]
        return self
    def addActivate(self, activate = None):
        if self.__activate == None:            self.__activate =  []
        self.__activate +=  [activate]
        return self
    def isSelected(self, Selected = None):
        return self.__Selected
    def isValid(self, Valid = None):
        return self.__Valid
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DShaderNode'
        if self.__activate is not None:
            if isinstance(self.__activate, six.string_types):
                str += ' activate="'+self.__activate+'"'
            else:
                str += ' activate="'+self.__activate[0]+'"'
        if self.__Selected is not None:
            if isinstance(self.__Selected, six.string_types):
                str += ' Selected="'+self.__Selected+'"'
            else:
                str += ' Selected="'+self.__Selected[0]+'"'
        if self.__Valid is not None:
            if isinstance(self.__Valid, six.string_types):
                str += ' Valid="'+self.__Valid+'"'
            else:
                str += ' Valid="'+self.__Valid[0]+'"'
        if self.__language is not None:
            if isinstance(self.__language, six.string_types):
                str += ' language="'+self.__language+'"'
            else:
                str += ' language="'+self.__language[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DShaderNode>'
        return str


class X3DShapeNode(X3DBoundedObject, X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DShapeNode, self).__init__(**kwargs)
        appearance  = kwargs.pop("appearance", None)
        self.__appearance = appearance
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        geometry  = kwargs.pop("geometry", None)
        self.__geometry = geometry
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def appearance(self):
        return self.__appearance
    @appearance.setter
    def appearance(self, value = None):
        self.__appearance = [value]
    def setAppearance(self, appearance = None):
        self.__appearance = [appearance]
        return self
    def addAppearance(self, appearance = None):
        if self.__appearance == None:            self.__appearance =  []
        self.__appearance +=  [appearance]
        return self
    def removeAppearance(self, appearance):
        self.__appearance = [x for x in self.__appearance if x not in appearance]
        return self.__appearance
    def getAppearance(self, appearance = None):
        return self.__appearance
    def appearance_changed(self, appearance = None):
        return self.__appearance
    @property
    def geometry(self):
        return self.__geometry
    @geometry.setter
    def geometry(self, value = None):
        self.__geometry = [value]
    def setGeometry(self, geometry = None):
        self.__geometry = [geometry]
        return self
    def addGeometry(self, geometry = None):
        if self.__geometry == None:            self.__geometry =  []
        self.__geometry +=  [geometry]
        return self
    def removeGeometry(self, geometry):
        self.__geometry = [x for x in self.__geometry if x not in geometry]
        return self.__geometry
    def getGeometry(self, geometry = None):
        return self.__geometry
    def geometry_changed(self, geometry = None):
        return self.__geometry
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DShapeNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<appearance'
        if self.__appearance is not None:
           for s in self.__appearance:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__appearance is not None:
           for s in self.__appearance:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</appearance>'
        str += '<geometry'
        if self.__geometry is not None:
           for s in self.__geometry:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__geometry is not None:
           for s in self.__geometry:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</geometry>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DShapeNode>'
        return str


class X3DSoundNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DSoundNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DSoundNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DSoundNode>'
        return str


class X3DTimeDependentNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DTimeDependentNode, self).__init__(**kwargs)
        elapsedTime  = kwargs.pop("elapsedTime", None)
        if elapsedTime == None or elapsedTime  <  0:
            return None
        self.__elapsedTime = elapsedTime
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Paused  = kwargs.pop("Paused", None)
        self.__Paused = Paused
        loop  = kwargs.pop("loop", False)
        self.__loop = loop
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        pauseTime  = kwargs.pop("pauseTime", 0)
        self.__pauseTime = pauseTime
        resumeTime  = kwargs.pop("resumeTime", 0)
        self.__resumeTime = resumeTime
        startTime  = kwargs.pop("startTime", 0)
        self.__startTime = startTime
        stopTime  = kwargs.pop("stopTime", 0)
        self.__stopTime = stopTime
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeElapsedTime(self, elapsedTime):
        self.__elapsedTime = [x for x in self.__elapsedTime if x not in elapsedTime]
        return self.__elapsedTime
    def getElapsedTime(self, elapsedTime = None):
        return self.__elapsedTime
    def elapsedTime_changed(self, elapsedTime = None):
        return self.__elapsedTime
    def isActive(self, Active = None):
        return self.__Active
    def isPaused(self, Paused = None):
        return self.__Paused
    @property
    def loop(self):
        return self.__loop
    @loop.setter
    def loop(self, value = False):
        self.__loop = [value]
    def setLoop(self, loop = False):
        self.__loop = [loop]
        return self
    def addLoop(self, loop = False):
        if self.__loop == None:            self.__loop =  []
        self.__loop +=  [loop]
        return self
    def removeLoop(self, loop):
        self.__loop = [x for x in self.__loop if x not in loop]
        return self.__loop
    def isLoop(self, loop = False):
        return self.__loop
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def pauseTime(self):
        return self.__pauseTime
    @pauseTime.setter
    def pauseTime(self, value = 0):
        self.__pauseTime = [value]
    def setPauseTime(self, pauseTime = 0):
        self.__pauseTime = [pauseTime]
        return self
    def addPauseTime(self, pauseTime = 0):
        if self.__pauseTime == None:            self.__pauseTime =  []
        self.__pauseTime +=  [pauseTime]
        return self
    def removePauseTime(self, pauseTime):
        self.__pauseTime = [x for x in self.__pauseTime if x not in pauseTime]
        return self.__pauseTime
    def getPauseTime(self, pauseTime = 0):
        return self.__pauseTime
    def pauseTime_changed(self, pauseTime = 0):
        return self.__pauseTime
    @property
    def resumeTime(self):
        return self.__resumeTime
    @resumeTime.setter
    def resumeTime(self, value = 0):
        self.__resumeTime = [value]
    def setResumeTime(self, resumeTime = 0):
        self.__resumeTime = [resumeTime]
        return self
    def addResumeTime(self, resumeTime = 0):
        if self.__resumeTime == None:            self.__resumeTime =  []
        self.__resumeTime +=  [resumeTime]
        return self
    def removeResumeTime(self, resumeTime):
        self.__resumeTime = [x for x in self.__resumeTime if x not in resumeTime]
        return self.__resumeTime
    def getResumeTime(self, resumeTime = 0):
        return self.__resumeTime
    def resumeTime_changed(self, resumeTime = 0):
        return self.__resumeTime
    @property
    def startTime(self):
        return self.__startTime
    @startTime.setter
    def startTime(self, value = 0):
        self.__startTime = [value]
    def setStartTime(self, startTime = 0):
        self.__startTime = [startTime]
        return self
    def addStartTime(self, startTime = 0):
        if self.__startTime == None:            self.__startTime =  []
        self.__startTime +=  [startTime]
        return self
    def removeStartTime(self, startTime):
        self.__startTime = [x for x in self.__startTime if x not in startTime]
        return self.__startTime
    def getStartTime(self, startTime = 0):
        return self.__startTime
    def startTime_changed(self, startTime = 0):
        return self.__startTime
    @property
    def stopTime(self):
        return self.__stopTime
    @stopTime.setter
    def stopTime(self, value = 0):
        self.__stopTime = [value]
    def setStopTime(self, stopTime = 0):
        self.__stopTime = [stopTime]
        return self
    def addStopTime(self, stopTime = 0):
        if self.__stopTime == None:            self.__stopTime =  []
        self.__stopTime +=  [stopTime]
        return self
    def removeStopTime(self, stopTime):
        self.__stopTime = [x for x in self.__stopTime if x not in stopTime]
        return self.__stopTime
    def getStopTime(self, stopTime = 0):
        return self.__stopTime
    def stopTime_changed(self, stopTime = 0):
        return self.__stopTime
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTimeDependentNode'
        if self.__elapsedTime is not None:
            if isinstance(self.__elapsedTime, six.string_types):
                str += ' elapsedTime="'+self.__elapsedTime+'"'
            else:
                str += ' elapsedTime="'+self.__elapsedTime[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Paused is not None:
            if isinstance(self.__Paused, six.string_types):
                str += ' Paused="'+self.__Paused+'"'
            else:
                str += ' Paused="'+self.__Paused[0]+'"'
        if self.__loop is not None:
            if isinstance(self.__loop, six.string_types):
                str += ' loop="'+self.__loop+'"'
            else:
                str += ' loop="'+self.__loop[0]+'"'
        if self.__pauseTime is not None:
            if isinstance(self.__pauseTime, six.string_types):
                str += ' pauseTime="'+self.__pauseTime+'"'
            else:
                str += ' pauseTime="'+self.__pauseTime[0]+'"'
        if self.__resumeTime is not None:
            if isinstance(self.__resumeTime, six.string_types):
                str += ' resumeTime="'+self.__resumeTime+'"'
            else:
                str += ' resumeTime="'+self.__resumeTime[0]+'"'
        if self.__startTime is not None:
            if isinstance(self.__startTime, six.string_types):
                str += ' startTime="'+self.__startTime+'"'
            else:
                str += ' startTime="'+self.__startTime[0]+'"'
        if self.__stopTime is not None:
            if isinstance(self.__stopTime, six.string_types):
                str += ' stopTime="'+self.__stopTime+'"'
            else:
                str += ' stopTime="'+self.__stopTime[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTimeDependentNode>'
        return str


class X3DSoundSourceNode(X3DTimeDependentNode):
    def __init__(self, **kwargs):
        super(X3DSoundSourceNode, self).__init__(**kwargs)
        description  = kwargs.pop("description", None)
        self.__description = description
        duration_changed  = kwargs.pop("duration_changed", None)
        if duration_changed == None or duration_changed  <  -1:
            return None
        self.__duration_changed = duration_changed
        elapsedTime  = kwargs.pop("elapsedTime", None)
        if elapsedTime == None or elapsedTime  <  0:
            return None
        self.__elapsedTime = elapsedTime
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Paused  = kwargs.pop("Paused", None)
        self.__Paused = Paused
        loop  = kwargs.pop("loop", False)
        self.__loop = loop
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        pauseTime  = kwargs.pop("pauseTime", 0)
        self.__pauseTime = pauseTime
        pitch  = kwargs.pop("pitch", 1.0)
        if pitch == None or pitch  <=  0:
            return None
        self.__pitch = pitch
        resumeTime  = kwargs.pop("resumeTime", 0)
        self.__resumeTime = resumeTime
        startTime  = kwargs.pop("startTime", 0)
        self.__startTime = startTime
        stopTime  = kwargs.pop("stopTime", 0)
        self.__stopTime = stopTime
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    def removeduration_changed(self, duration_changed):
        self.__duration_changed = [x for x in self.__duration_changed if x not in duration_changed]
        return self.__duration_changed
    def getduration_changed(self, duration_changed = None):
        return self.__duration_changed
    def duration_changed_changed(self, duration_changed = None):
        return self.__duration_changed
    def removeElapsedTime(self, elapsedTime):
        self.__elapsedTime = [x for x in self.__elapsedTime if x not in elapsedTime]
        return self.__elapsedTime
    def getElapsedTime(self, elapsedTime = None):
        return self.__elapsedTime
    def elapsedTime_changed(self, elapsedTime = None):
        return self.__elapsedTime
    def isActive(self, Active = None):
        return self.__Active
    def isPaused(self, Paused = None):
        return self.__Paused
    @property
    def loop(self):
        return self.__loop
    @loop.setter
    def loop(self, value = False):
        self.__loop = [value]
    def setLoop(self, loop = False):
        self.__loop = [loop]
        return self
    def addLoop(self, loop = False):
        if self.__loop == None:            self.__loop =  []
        self.__loop +=  [loop]
        return self
    def removeLoop(self, loop):
        self.__loop = [x for x in self.__loop if x not in loop]
        return self.__loop
    def isLoop(self, loop = False):
        return self.__loop
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def pauseTime(self):
        return self.__pauseTime
    @pauseTime.setter
    def pauseTime(self, value = 0):
        self.__pauseTime = [value]
    def setPauseTime(self, pauseTime = 0):
        self.__pauseTime = [pauseTime]
        return self
    def addPauseTime(self, pauseTime = 0):
        if self.__pauseTime == None:            self.__pauseTime =  []
        self.__pauseTime +=  [pauseTime]
        return self
    def removePauseTime(self, pauseTime):
        self.__pauseTime = [x for x in self.__pauseTime if x not in pauseTime]
        return self.__pauseTime
    def getPauseTime(self, pauseTime = 0):
        return self.__pauseTime
    def pauseTime_changed(self, pauseTime = 0):
        return self.__pauseTime
    @property
    def pitch(self):
        return self.__pitch
    @pitch.setter
    def pitch(self, value = 1.0):
        if value == None or value  <=  0:
            return None
        self.__pitch = [value]
    def setPitch(self, pitch = 1.0):
        if pitch == None or pitch  <=  0:
            return None
        self.__pitch = [pitch]
        return self
    def addPitch(self, pitch = 1.0):
        if pitch == None or pitch  <=  0:
            return None
        if self.__pitch == None:            self.__pitch =  []
        self.__pitch +=  [pitch]
        return self
    def removePitch(self, pitch):
        self.__pitch = [x for x in self.__pitch if x not in pitch]
        return self.__pitch
    def getPitch(self, pitch = 1.0):
        return self.__pitch
    def pitch_changed(self, pitch = 1.0):
        return self.__pitch
    @property
    def resumeTime(self):
        return self.__resumeTime
    @resumeTime.setter
    def resumeTime(self, value = 0):
        self.__resumeTime = [value]
    def setResumeTime(self, resumeTime = 0):
        self.__resumeTime = [resumeTime]
        return self
    def addResumeTime(self, resumeTime = 0):
        if self.__resumeTime == None:            self.__resumeTime =  []
        self.__resumeTime +=  [resumeTime]
        return self
    def removeResumeTime(self, resumeTime):
        self.__resumeTime = [x for x in self.__resumeTime if x not in resumeTime]
        return self.__resumeTime
    def getResumeTime(self, resumeTime = 0):
        return self.__resumeTime
    def resumeTime_changed(self, resumeTime = 0):
        return self.__resumeTime
    @property
    def startTime(self):
        return self.__startTime
    @startTime.setter
    def startTime(self, value = 0):
        self.__startTime = [value]
    def setStartTime(self, startTime = 0):
        self.__startTime = [startTime]
        return self
    def addStartTime(self, startTime = 0):
        if self.__startTime == None:            self.__startTime =  []
        self.__startTime +=  [startTime]
        return self
    def removeStartTime(self, startTime):
        self.__startTime = [x for x in self.__startTime if x not in startTime]
        return self.__startTime
    def getStartTime(self, startTime = 0):
        return self.__startTime
    def startTime_changed(self, startTime = 0):
        return self.__startTime
    @property
    def stopTime(self):
        return self.__stopTime
    @stopTime.setter
    def stopTime(self, value = 0):
        self.__stopTime = [value]
    def setStopTime(self, stopTime = 0):
        self.__stopTime = [stopTime]
        return self
    def addStopTime(self, stopTime = 0):
        if self.__stopTime == None:            self.__stopTime =  []
        self.__stopTime +=  [stopTime]
        return self
    def removeStopTime(self, stopTime):
        self.__stopTime = [x for x in self.__stopTime if x not in stopTime]
        return self.__stopTime
    def getStopTime(self, stopTime = 0):
        return self.__stopTime
    def stopTime_changed(self, stopTime = 0):
        return self.__stopTime
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DSoundSourceNode'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__duration_changed is not None:
            if isinstance(self.__duration_changed, six.string_types):
                str += ' duration_changed="'+self.__duration_changed+'"'
            else:
                str += ' duration_changed="'+self.__duration_changed[0]+'"'
        if self.__elapsedTime is not None:
            if isinstance(self.__elapsedTime, six.string_types):
                str += ' elapsedTime="'+self.__elapsedTime+'"'
            else:
                str += ' elapsedTime="'+self.__elapsedTime[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Paused is not None:
            if isinstance(self.__Paused, six.string_types):
                str += ' Paused="'+self.__Paused+'"'
            else:
                str += ' Paused="'+self.__Paused[0]+'"'
        if self.__loop is not None:
            if isinstance(self.__loop, six.string_types):
                str += ' loop="'+self.__loop+'"'
            else:
                str += ' loop="'+self.__loop[0]+'"'
        if self.__pauseTime is not None:
            if isinstance(self.__pauseTime, six.string_types):
                str += ' pauseTime="'+self.__pauseTime+'"'
            else:
                str += ' pauseTime="'+self.__pauseTime[0]+'"'
        if self.__pitch is not None:
            if isinstance(self.__pitch, six.string_types):
                str += ' pitch="'+self.__pitch+'"'
            else:
                str += ' pitch="'+self.__pitch[0]+'"'
        if self.__resumeTime is not None:
            if isinstance(self.__resumeTime, six.string_types):
                str += ' resumeTime="'+self.__resumeTime+'"'
            else:
                str += ' resumeTime="'+self.__resumeTime[0]+'"'
        if self.__startTime is not None:
            if isinstance(self.__startTime, six.string_types):
                str += ' startTime="'+self.__startTime+'"'
            else:
                str += ' startTime="'+self.__startTime[0]+'"'
        if self.__stopTime is not None:
            if isinstance(self.__stopTime, six.string_types):
                str += ' stopTime="'+self.__stopTime+'"'
            else:
                str += ' stopTime="'+self.__stopTime[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DSoundSourceNode>'
        return str


class X3DTexture2DNode(X3DTextureNode):
    def __init__(self, **kwargs):
        super(X3DTexture2DNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        repeatS  = kwargs.pop("repeatS", True)
        self.__repeatS = repeatS
        repeatT  = kwargs.pop("repeatT", True)
        self.__repeatT = repeatT
        textureProperties  = kwargs.pop("textureProperties", None)
        self.__textureProperties = textureProperties
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTexture2DNode'
        if self.__repeatS is not None:
            if isinstance(self.__repeatS, six.string_types):
                str += ' repeatS="'+self.__repeatS+'"'
            else:
                str += ' repeatS="'+self.__repeatS[0]+'"'
        if self.__repeatT is not None:
            if isinstance(self.__repeatT, six.string_types):
                str += ' repeatT="'+self.__repeatT+'"'
            else:
                str += ' repeatT="'+self.__repeatT[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<textureProperties'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</textureProperties>'
        str += '</X3DTexture2DNode>'
        return str


class X3DTexture3DNode(X3DTextureNode):
    def __init__(self, **kwargs):
        super(X3DTexture3DNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        repeatR  = kwargs.pop("repeatR", False)
        self.__repeatR = repeatR
        repeatS  = kwargs.pop("repeatS", False)
        self.__repeatS = repeatS
        repeatT  = kwargs.pop("repeatT", False)
        self.__repeatT = repeatT
        textureProperties  = kwargs.pop("textureProperties", None)
        self.__textureProperties = textureProperties
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTexture3DNode'
        if self.__repeatR is not None:
            if isinstance(self.__repeatR, six.string_types):
                str += ' repeatR="'+self.__repeatR+'"'
            else:
                str += ' repeatR="'+self.__repeatR[0]+'"'
        if self.__repeatS is not None:
            if isinstance(self.__repeatS, six.string_types):
                str += ' repeatS="'+self.__repeatS+'"'
            else:
                str += ' repeatS="'+self.__repeatS[0]+'"'
        if self.__repeatT is not None:
            if isinstance(self.__repeatT, six.string_types):
                str += ' repeatT="'+self.__repeatT+'"'
            else:
                str += ' repeatT="'+self.__repeatT[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<textureProperties'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</textureProperties>'
        str += '</X3DTexture3DNode>'
        return str


class X3DTextureCoordinateNode(X3DGeometricPropertyNode):
    def __init__(self, **kwargs):
        super(X3DTextureCoordinateNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTextureCoordinateNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTextureCoordinateNode>'
        return str


class X3DTextureTransformNode(X3DAppearanceChildNode):
    def __init__(self, **kwargs):
        super(X3DTextureTransformNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTextureTransformNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTextureTransformNode>'
        return str


class X3DTouchSensorNode(X3DPointingDeviceSensorNode):
    def __init__(self, **kwargs):
        super(X3DTouchSensorNode, self).__init__(**kwargs)
        description  = kwargs.pop("description", None)
        self.__description = description
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Over  = kwargs.pop("Over", None)
        self.__Over = Over
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        touchTime  = kwargs.pop("touchTime", None)
        self.__touchTime = touchTime
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    def isOver(self, Over = None):
        return self.__Over
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    def removeTouchTime(self, touchTime):
        self.__touchTime = [x for x in self.__touchTime if x not in touchTime]
        return self.__touchTime
    def getTouchTime(self, touchTime = None):
        return self.__touchTime
    def touchTime_changed(self, touchTime = None):
        return self.__touchTime
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTouchSensorNode'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Over is not None:
            if isinstance(self.__Over, six.string_types):
                str += ' Over="'+self.__Over+'"'
            else:
                str += ' Over="'+self.__Over[0]+'"'
        if self.__touchTime is not None:
            if isinstance(self.__touchTime, six.string_types):
                str += ' touchTime="'+self.__touchTime+'"'
            else:
                str += ' touchTime="'+self.__touchTime[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTouchSensorNode>'
        return str


class X3DTriggerNode(X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DTriggerNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DTriggerNode'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DTriggerNode>'
        return str


class X3DVertexAttributeNode(X3DGeometricPropertyNode):
    def __init__(self, **kwargs):
        super(X3DVertexAttributeNode, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DVertexAttributeNode'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DVertexAttributeNode>'
        return str


class X3DViewpointNode(X3DBindableNode):
    def __init__(self, **kwargs):
        super(X3DViewpointNode, self).__init__(**kwargs)
        bindTime  = kwargs.pop("bindTime", None)
        self.__bindTime = bindTime
        description  = kwargs.pop("description", None)
        self.__description = description
        Bound  = kwargs.pop("Bound", None)
        self.__Bound = Bound
        jump  = kwargs.pop("jump", True)
        self.__jump = jump
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        orientation  = kwargs.pop("orientation", [0, 0, 1, 0])
        self.__orientation = orientation
        retainUserOffsets  = kwargs.pop("retainUserOffsets", False)
        self.__retainUserOffsets = retainUserOffsets
        bind  = kwargs.pop("bind", None)
        self.__bind = bind
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeBindTime(self, bindTime):
        self.__bindTime = [x for x in self.__bindTime if x not in bindTime]
        return self.__bindTime
    def getBindTime(self, bindTime = None):
        return self.__bindTime
    def bindTime_changed(self, bindTime = None):
        return self.__bindTime
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    def isBound(self, Bound = None):
        return self.__Bound
    @property
    def jump(self):
        return self.__jump
    @jump.setter
    def jump(self, value = True):
        self.__jump = [value]
    def setJump(self, jump = True):
        self.__jump = [jump]
        return self
    def addJump(self, jump = True):
        if self.__jump == None:            self.__jump =  []
        self.__jump +=  [jump]
        return self
    def removeJump(self, jump):
        self.__jump = [x for x in self.__jump if x not in jump]
        return self.__jump
    def isJump(self, jump = True):
        return self.__jump
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def orientation(self):
        return self.__orientation
    @orientation.setter
    def orientation(self, value = [0, 0, 1, 0]):
        self.__orientation = [value]
    def setOrientation(self, orientation = [0, 0, 1, 0]):
        self.__orientation = [orientation]
        return self
    def addOrientation(self, orientation = [0, 0, 1, 0]):
        if self.__orientation == None:            self.__orientation =  []
        self.__orientation +=  [orientation]
        return self
    def removeOrientation(self, orientation):
        self.__orientation = [x for x in self.__orientation if x not in orientation]
        return self.__orientation
    def getOrientation(self, orientation = [0, 0, 1, 0]):
        return self.__orientation
    def orientation_changed(self, orientation = [0, 0, 1, 0]):
        return self.__orientation
    @property
    def retainUserOffsets(self):
        return self.__retainUserOffsets
    @retainUserOffsets.setter
    def retainUserOffsets(self, value = False):
        self.__retainUserOffsets = [value]
    def setRetainUserOffsets(self, retainUserOffsets = False):
        self.__retainUserOffsets = [retainUserOffsets]
        return self
    def addRetainUserOffsets(self, retainUserOffsets = False):
        if self.__retainUserOffsets == None:            self.__retainUserOffsets =  []
        self.__retainUserOffsets +=  [retainUserOffsets]
        return self
    def removeRetainUserOffsets(self, retainUserOffsets):
        self.__retainUserOffsets = [x for x in self.__retainUserOffsets if x not in retainUserOffsets]
        return self.__retainUserOffsets
    def isRetainUserOffsets(self, retainUserOffsets = False):
        return self.__retainUserOffsets
    @property
    def bind(self):
        return self.__bind
    @bind.setter
    def bind(self, value = None):
        self.__bind = [value]
    def set_bind(self, bind = None):
        self.__bind = [bind]
        return self
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DViewpointNode'
        if self.__bindTime is not None:
            if isinstance(self.__bindTime, six.string_types):
                str += ' bindTime="'+self.__bindTime+'"'
            else:
                str += ' bindTime="'+self.__bindTime[0]+'"'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__Bound is not None:
            if isinstance(self.__Bound, six.string_types):
                str += ' Bound="'+self.__Bound+'"'
            else:
                str += ' Bound="'+self.__Bound[0]+'"'
        if self.__jump is not None:
            if isinstance(self.__jump, six.string_types):
                str += ' jump="'+self.__jump+'"'
            else:
                str += ' jump="'+self.__jump[0]+'"'
        if self.__orientation is not None:
            if isinstance(self.__orientation, six.string_types):
                str += ' orientation="'+self.__orientation+'"'
            else:
                str += ' orientation="'+self.__orientation[0]+'"'
        if self.__retainUserOffsets is not None:
            if isinstance(self.__retainUserOffsets, six.string_types):
                str += ' retainUserOffsets="'+self.__retainUserOffsets+'"'
            else:
                str += ' retainUserOffsets="'+self.__retainUserOffsets[0]+'"'
        if self.__bind is not None:
            if isinstance(self.__bind, six.string_types):
                str += ' bind="'+self.__bind+'"'
            else:
                str += ' bind="'+self.__bind[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DViewpointNode>'
        return str


class X3DViewportNode(X3DGroupingNode):
    def __init__(self, **kwargs):
        super(X3DViewportNode, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DViewportNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</X3DViewportNode>'
        return str


class X3DVolumeDataNode(X3DBoundedObject, X3DChildNode):
    def __init__(self, **kwargs):
        super(X3DVolumeDataNode, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        dimensions  = kwargs.pop("dimensions", [1, 1, 1])
        if dimensions == None or len(dimensions) <= 0 or min(dimensions)  <=  0:
            return None
        self.__dimensions = dimensions
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def dimensions(self):
        return self.__dimensions
    @dimensions.setter
    def dimensions(self, value = [1, 1, 1]):
        if value == None or len(value) <= 0 or min(value)  <=  0:
            return None
        self.__dimensions = [value]
    def setDimensions(self, dimensions = [1, 1, 1]):
        if dimensions == None or len(dimensions) <= 0 or min(dimensions)  <=  0:
            return None
        self.__dimensions = [dimensions]
        return self
    def addDimensions(self, dimensions = [1, 1, 1]):
        if dimensions == None or len(dimensions) <= 0 or min(dimensions)  <=  0:
            return None
        if self.__dimensions == None:            self.__dimensions =  []
        self.__dimensions +=  [dimensions]
        return self
    def removeDimensions(self, dimensions):
        self.__dimensions = [x for x in self.__dimensions if x not in dimensions]
        return self.__dimensions
    def getDimensions(self, dimensions = [1, 1, 1]):
        return self.__dimensions
    def dimensions_changed(self, dimensions = [1, 1, 1]):
        return self.__dimensions
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DVolumeDataNode'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__dimensions is not None:
            if isinstance(self.__dimensions, six.string_types):
                str += ' dimensions="'+self.__dimensions+'"'
            else:
                str += ' dimensions="'+self.__dimensions[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</X3DVolumeDataNode>'
        return str


class X3DFogObject(object):
    def __init__(self, **kwargs):
        super(X3DFogObject, self).__init__()
        color  = kwargs.pop("color", [1, 1, 1])
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = color
        fogType  = kwargs.pop("fogType", "LINEAR")
        if 'LINEAR' == fogType:
            pass
        elif 'EXPONENTIAL' == fogType:
            pass
        else:
            return None
        self.__fogType = fogType
        visibilityRange  = kwargs.pop("visibilityRange", 0)
        if visibilityRange == None or visibilityRange  <  0:
            return None
        self.__visibilityRange = visibilityRange
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = [1, 1, 1]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__color = [value]
    def setColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = [color]
        return self
    def addColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = [1, 1, 1]):
        return self.__color
    def color_changed(self, color = [1, 1, 1]):
        return self.__color
    @property
    def fogType(self):
        return self.__fogType
    @fogType.setter
    def fogType(self, value = "LINEAR"):
        if 'LINEAR' == value:
            pass
        elif 'EXPONENTIAL' == value:
            pass
        else:
            return None
        self.__fogType = [value]
    def setFogType(self, fogType = "LINEAR"):
        if 'LINEAR' == fogType:
            pass
        elif 'EXPONENTIAL' == fogType:
            pass
        else:
            return None
        self.__fogType = [fogType]
        return self
    def addFogType(self, fogType = "LINEAR"):
        if 'LINEAR' == fogType:
            pass
        elif 'EXPONENTIAL' == fogType:
            pass
        else:
            return None
        if self.__fogType == None:            self.__fogType =  []
        self.__fogType +=  [fogType]
        return self
    def removeFogType(self, fogType):
        self.__fogType = [x for x in self.__fogType if x not in fogType]
        return self.__fogType
    def getFogType(self, fogType = "LINEAR"):
        return self.__fogType
    def fogType_changed(self, fogType = "LINEAR"):
        return self.__fogType
    @property
    def visibilityRange(self):
        return self.__visibilityRange
    @visibilityRange.setter
    def visibilityRange(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__visibilityRange = [value]
    def setVisibilityRange(self, visibilityRange = 0):
        if visibilityRange == None or visibilityRange  <  0:
            return None
        self.__visibilityRange = [visibilityRange]
        return self
    def addVisibilityRange(self, visibilityRange = 0):
        if visibilityRange == None or visibilityRange  <  0:
            return None
        if self.__visibilityRange == None:            self.__visibilityRange =  []
        self.__visibilityRange +=  [visibilityRange]
        return self
    def removeVisibilityRange(self, visibilityRange):
        self.__visibilityRange = [x for x in self.__visibilityRange if x not in visibilityRange]
        return self.__visibilityRange
    def getVisibilityRange(self, visibilityRange = 0):
        return self.__visibilityRange
    def visibilityRange_changed(self, visibilityRange = 0):
        return self.__visibilityRange
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DFogObject'
        if self.__color is not None:
            if isinstance(self.__color, six.string_types):
                str += ' color="'+self.__color+'"'
            else:
                str += ' color="'+self.__color[0]+'"'
        if self.__fogType is not None:
            if isinstance(self.__fogType, six.string_types):
                str += ' fogType="'+self.__fogType+'"'
            else:
                str += ' fogType="'+self.__fogType[0]+'"'
        if self.__visibilityRange is not None:
            if isinstance(self.__visibilityRange, six.string_types):
                str += ' visibilityRange="'+self.__visibilityRange+'"'
            else:
                str += ' visibilityRange="'+self.__visibilityRange[0]+'"'
        str += '>'
        str += '</X3DFogObject>'
        return str


class X3DMetadataObject(object):
    def __init__(self, **kwargs):
        super(X3DMetadataObject, self).__init__()
        name  = kwargs.pop("name", None)
        self.__name = name
        reference  = kwargs.pop("reference", None)
        self.__reference = reference
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def reference(self):
        return self.__reference
    @reference.setter
    def reference(self, value = None):
        self.__reference = [value]
    def setReference(self, reference = None):
        self.__reference = [reference]
        return self
    def addReference(self, reference = None):
        if self.__reference == None:            self.__reference =  []
        self.__reference +=  [reference]
        return self
    def removeReference(self, reference):
        self.__reference = [x for x in self.__reference if x not in reference]
        return self.__reference
    def getReference(self, reference = None):
        return self.__reference
    def reference_changed(self, reference = None):
        return self.__reference
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DMetadataObject'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__reference is not None:
            if isinstance(self.__reference, six.string_types):
                str += ' reference="'+self.__reference+'"'
            else:
                str += ' reference="'+self.__reference[0]+'"'
        str += '>'
        str += '</X3DMetadataObject>'
        return str


class X3DPickableObject(object):
    def __init__(self, **kwargs):
        super(X3DPickableObject, self).__init__()
        pickable  = kwargs.pop("pickable", True)
        self.__pickable = pickable
    @property
    def pickable(self):
        return self.__pickable
    @pickable.setter
    def pickable(self, value = True):
        self.__pickable = [value]
    def setPickable(self, pickable = True):
        self.__pickable = [pickable]
        return self
    def addPickable(self, pickable = True):
        if self.__pickable == None:            self.__pickable =  []
        self.__pickable +=  [pickable]
        return self
    def removePickable(self, pickable):
        self.__pickable = [x for x in self.__pickable if x not in pickable]
        return self.__pickable
    def isPickable(self, pickable = True):
        return self.__pickable
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DPickableObject'
        if self.__pickable is not None:
            if isinstance(self.__pickable, six.string_types):
                str += ' pickable="'+self.__pickable+'"'
            else:
                str += ' pickable="'+self.__pickable[0]+'"'
        str += '>'
        str += '</X3DPickableObject>'
        return str


class X3DProgrammableShaderObject(object):
    def __init__(self, **kwargs):
        super(X3DProgrammableShaderObject, self).__init__()
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<X3DProgrammableShaderObject'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '</X3DProgrammableShaderObject>'
        return str


class Anchor(X3DUrlObject, X3DGroupingNode):
    def __init__(self, **kwargs):
        super(Anchor, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        description  = kwargs.pop("description", None)
        self.__description = description
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        parameter  = kwargs.pop("parameter", None)
        self.__parameter = parameter
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        url  = kwargs.pop("url", None)
        self.__url = url
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def parameter(self):
        return self.__parameter
    @parameter.setter
    def parameter(self, value = None):
        self.__parameter = [value]
    def setParameter(self, parameter = None):
        self.__parameter = [parameter]
        return self
    def addParameter(self, parameter = None):
        if self.__parameter == None:            self.__parameter =  []
        self.__parameter +=  [parameter]
        return self
    def removeParameter(self, parameter):
        self.__parameter = [x for x in self.__parameter if x not in parameter]
        return self.__parameter
    def getParameter(self, parameter = None):
        return self.__parameter
    def parameter_changed(self, parameter = None):
        return self.__parameter
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def url(self):
        return self.__url
    @url.setter
    def url(self, value = None):
        self.__url = [value]
    def setUrl(self, url = None):
        self.__url = [url]
        return self
    def addUrl(self, url = None):
        if self.__url == None:            self.__url =  []
        self.__url +=  [url]
        return self
    def removeUrl(self, url):
        self.__url = [x for x in self.__url if x not in url]
        return self.__url
    def getUrl(self, url = None):
        return self.__url
    def url_changed(self, url = None):
        return self.__url
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Anchor'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__parameter is not None:
            if isinstance(self.__parameter, six.string_types):
                str += ' parameter="'+self.__parameter+'"'
            else:
                str += ' parameter="'+self.__parameter[0]+'"'
        if self.__url is not None:
            if isinstance(self.__url, six.string_types):
                str += ' url="'+self.__url+'"'
            else:
                str += ' url="'+self.__url[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</Anchor>'
        return str


class Appearance(X3DAppearanceNode):
    def __init__(self, **kwargs):
        super(Appearance, self).__init__(**kwargs)
        fillProperties  = kwargs.pop("fillProperties", None)
        self.__fillProperties = fillProperties
        lineProperties  = kwargs.pop("lineProperties", None)
        self.__lineProperties = lineProperties
        material  = kwargs.pop("material", None)
        self.__material = material
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        pointProperties  = kwargs.pop("pointProperties", None)
        self.__pointProperties = pointProperties
        shaders  = kwargs.pop("shaders", None)
        self.__shaders = shaders
        texture  = kwargs.pop("texture", None)
        self.__texture = texture
        textureTransform  = kwargs.pop("textureTransform", None)
        self.__textureTransform = textureTransform
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def fillProperties(self):
        return self.__fillProperties
    @fillProperties.setter
    def fillProperties(self, value = None):
        self.__fillProperties = [value]
    def setFillProperties(self, fillProperties = None):
        self.__fillProperties = [fillProperties]
        return self
    def addFillProperties(self, fillProperties = None):
        if self.__fillProperties == None:            self.__fillProperties =  []
        self.__fillProperties +=  [fillProperties]
        return self
    def removeFillProperties(self, fillProperties):
        self.__fillProperties = [x for x in self.__fillProperties if x not in fillProperties]
        return self.__fillProperties
    def getFillProperties(self, fillProperties = None):
        return self.__fillProperties
    def fillProperties_changed(self, fillProperties = None):
        return self.__fillProperties
    @property
    def lineProperties(self):
        return self.__lineProperties
    @lineProperties.setter
    def lineProperties(self, value = None):
        self.__lineProperties = [value]
    def setLineProperties(self, lineProperties = None):
        self.__lineProperties = [lineProperties]
        return self
    def addLineProperties(self, lineProperties = None):
        if self.__lineProperties == None:            self.__lineProperties =  []
        self.__lineProperties +=  [lineProperties]
        return self
    def removeLineProperties(self, lineProperties):
        self.__lineProperties = [x for x in self.__lineProperties if x not in lineProperties]
        return self.__lineProperties
    def getLineProperties(self, lineProperties = None):
        return self.__lineProperties
    def lineProperties_changed(self, lineProperties = None):
        return self.__lineProperties
    @property
    def material(self):
        return self.__material
    @material.setter
    def material(self, value = None):
        self.__material = [value]
    def setMaterial(self, material = None):
        self.__material = [material]
        return self
    def addMaterial(self, material = None):
        if self.__material == None:            self.__material =  []
        self.__material +=  [material]
        return self
    def removeMaterial(self, material):
        self.__material = [x for x in self.__material if x not in material]
        return self.__material
    def getMaterial(self, material = None):
        return self.__material
    def material_changed(self, material = None):
        return self.__material
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def pointProperties(self):
        return self.__pointProperties
    @pointProperties.setter
    def pointProperties(self, value = None):
        self.__pointProperties = [value]
    def setPointProperties(self, pointProperties = None):
        self.__pointProperties = [pointProperties]
        return self
    def addPointProperties(self, pointProperties = None):
        if self.__pointProperties == None:            self.__pointProperties =  []
        self.__pointProperties +=  [pointProperties]
        return self
    def removePointProperties(self, pointProperties):
        self.__pointProperties = [x for x in self.__pointProperties if x not in pointProperties]
        return self.__pointProperties
    def getPointProperties(self, pointProperties = None):
        return self.__pointProperties
    def pointProperties_changed(self, pointProperties = None):
        return self.__pointProperties
    @property
    def shaders(self):
        return self.__shaders
    @shaders.setter
    def shaders(self, value = None):
        self.__shaders = [value]
    def setShaders(self, shaders = None):
        self.__shaders = [shaders]
        return self
    def addShaders(self, shaders = None):
        if self.__shaders == None:            self.__shaders =  []
        self.__shaders +=  [shaders]
        return self
    def removeShaders(self, shaders):
        self.__shaders = [x for x in self.__shaders if x not in shaders]
        return self.__shaders
    def getShaders(self, shaders = None):
        return self.__shaders
    def shaders_changed(self, shaders = None):
        return self.__shaders
    @property
    def texture(self):
        return self.__texture
    @texture.setter
    def texture(self, value = None):
        self.__texture = [value]
    def setTexture(self, texture = None):
        self.__texture = [texture]
        return self
    def addTexture(self, texture = None):
        if self.__texture == None:            self.__texture =  []
        self.__texture +=  [texture]
        return self
    def removeTexture(self, texture):
        self.__texture = [x for x in self.__texture if x not in texture]
        return self.__texture
    def getTexture(self, texture = None):
        return self.__texture
    def texture_changed(self, texture = None):
        return self.__texture
    @property
    def textureTransform(self):
        return self.__textureTransform
    @textureTransform.setter
    def textureTransform(self, value = None):
        self.__textureTransform = [value]
    def setTextureTransform(self, textureTransform = None):
        self.__textureTransform = [textureTransform]
        return self
    def addTextureTransform(self, textureTransform = None):
        if self.__textureTransform == None:            self.__textureTransform =  []
        self.__textureTransform +=  [textureTransform]
        return self
    def removeTextureTransform(self, textureTransform):
        self.__textureTransform = [x for x in self.__textureTransform if x not in textureTransform]
        return self.__textureTransform
    def getTextureTransform(self, textureTransform = None):
        return self.__textureTransform
    def textureTransform_changed(self, textureTransform = None):
        return self.__textureTransform
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Appearance'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<fillProperties'
        if self.__fillProperties is not None:
           for s in self.__fillProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__fillProperties is not None:
           for s in self.__fillProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</fillProperties>'
        str += '<lineProperties'
        if self.__lineProperties is not None:
           for s in self.__lineProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__lineProperties is not None:
           for s in self.__lineProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</lineProperties>'
        str += '<material'
        if self.__material is not None:
           for s in self.__material:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__material is not None:
           for s in self.__material:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</material>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<pointProperties'
        if self.__pointProperties is not None:
           for s in self.__pointProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__pointProperties is not None:
           for s in self.__pointProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</pointProperties>'
        str += '<shaders'
        if self.__shaders is not None:
           for s in self.__shaders:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__shaders is not None:
           for s in self.__shaders:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</shaders>'
        str += '<texture'
        if self.__texture is not None:
           for s in self.__texture:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__texture is not None:
           for s in self.__texture:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</texture>'
        str += '<textureTransform'
        if self.__textureTransform is not None:
           for s in self.__textureTransform:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__textureTransform is not None:
           for s in self.__textureTransform:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</textureTransform>'
        str += '</Appearance>'
        return str


class Arc2D(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Arc2D, self).__init__(**kwargs)
        endAngle  = kwargs.pop("endAngle", 1.570796)
        if endAngle == None or endAngle  <=  -6.2832:
            return None
        if endAngle == None or endAngle  >=  6.2832:
            return None
        self.__endAngle = endAngle
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        radius  = kwargs.pop("radius", 1)
        if radius == None or radius  <=  0:
            return None
        self.__radius = radius
        startAngle  = kwargs.pop("startAngle", 0)
        if startAngle == None or startAngle  <=  -6.2832:
            return None
        if startAngle == None or startAngle  >=  6.2832:
            return None
        self.__startAngle = startAngle
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Arc2D'
        if self.__endAngle is not None:
            if isinstance(self.__endAngle, six.string_types):
                str += ' endAngle="'+self.__endAngle+'"'
            else:
                str += ' endAngle="'+self.__endAngle[0]+'"'
        if self.__radius is not None:
            if isinstance(self.__radius, six.string_types):
                str += ' radius="'+self.__radius+'"'
            else:
                str += ' radius="'+self.__radius[0]+'"'
        if self.__startAngle is not None:
            if isinstance(self.__startAngle, six.string_types):
                str += ' startAngle="'+self.__startAngle+'"'
            else:
                str += ' startAngle="'+self.__startAngle[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Arc2D>'
        return str


class ArcClose2D(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(ArcClose2D, self).__init__(**kwargs)
        closureType  = kwargs.pop("closureType", "PIE")
        if 'PIE' == closureType:
            pass
        elif 'CHORD' == closureType:
            pass
        else:
            return None
        self.__closureType = closureType
        endAngle  = kwargs.pop("endAngle", 1.570796)
        if endAngle == None or endAngle  <=  -6.2832:
            return None
        if endAngle == None or endAngle  >=  6.2832:
            return None
        self.__endAngle = endAngle
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        radius  = kwargs.pop("radius", 1)
        if radius == None or radius  <=  0:
            return None
        self.__radius = radius
        solid  = kwargs.pop("solid", False)
        self.__solid = solid
        startAngle  = kwargs.pop("startAngle", 0)
        if startAngle == None or startAngle  <=  -6.2832:
            return None
        if startAngle == None or startAngle  >=  6.2832:
            return None
        self.__startAngle = startAngle
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ArcClose2D'
        if self.__closureType is not None:
            if isinstance(self.__closureType, six.string_types):
                str += ' closureType="'+self.__closureType+'"'
            else:
                str += ' closureType="'+self.__closureType[0]+'"'
        if self.__endAngle is not None:
            if isinstance(self.__endAngle, six.string_types):
                str += ' endAngle="'+self.__endAngle+'"'
            else:
                str += ' endAngle="'+self.__endAngle[0]+'"'
        if self.__radius is not None:
            if isinstance(self.__radius, six.string_types):
                str += ' radius="'+self.__radius+'"'
            else:
                str += ' radius="'+self.__radius[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__startAngle is not None:
            if isinstance(self.__startAngle, six.string_types):
                str += ' startAngle="'+self.__startAngle+'"'
            else:
                str += ' startAngle="'+self.__startAngle[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ArcClose2D>'
        return str


class AudioClip(X3DUrlObject, X3DSoundSourceNode):
    def __init__(self, **kwargs):
        super(AudioClip, self).__init__(**kwargs)
        description  = kwargs.pop("description", None)
        self.__description = description
        duration_changed  = kwargs.pop("duration_changed", None)
        if duration_changed == None or duration_changed  <  -1:
            return None
        self.__duration_changed = duration_changed
        elapsedTime  = kwargs.pop("elapsedTime", None)
        if elapsedTime == None or elapsedTime  <  0:
            return None
        self.__elapsedTime = elapsedTime
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Paused  = kwargs.pop("Paused", None)
        self.__Paused = Paused
        loop  = kwargs.pop("loop", False)
        self.__loop = loop
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        pauseTime  = kwargs.pop("pauseTime", 0)
        self.__pauseTime = pauseTime
        pitch  = kwargs.pop("pitch", 1.0)
        if pitch == None or pitch  <=  0:
            return None
        self.__pitch = pitch
        resumeTime  = kwargs.pop("resumeTime", 0)
        self.__resumeTime = resumeTime
        startTime  = kwargs.pop("startTime", 0)
        self.__startTime = startTime
        stopTime  = kwargs.pop("stopTime", 0)
        self.__stopTime = stopTime
        url  = kwargs.pop("url", None)
        self.__url = url
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    def removeduration_changed(self, duration_changed):
        self.__duration_changed = [x for x in self.__duration_changed if x not in duration_changed]
        return self.__duration_changed
    def getduration_changed(self, duration_changed = None):
        return self.__duration_changed
    def duration_changed_changed(self, duration_changed = None):
        return self.__duration_changed
    def removeElapsedTime(self, elapsedTime):
        self.__elapsedTime = [x for x in self.__elapsedTime if x not in elapsedTime]
        return self.__elapsedTime
    def getElapsedTime(self, elapsedTime = None):
        return self.__elapsedTime
    def elapsedTime_changed(self, elapsedTime = None):
        return self.__elapsedTime
    def isActive(self, Active = None):
        return self.__Active
    def isPaused(self, Paused = None):
        return self.__Paused
    @property
    def loop(self):
        return self.__loop
    @loop.setter
    def loop(self, value = False):
        self.__loop = [value]
    def setLoop(self, loop = False):
        self.__loop = [loop]
        return self
    def addLoop(self, loop = False):
        if self.__loop == None:            self.__loop =  []
        self.__loop +=  [loop]
        return self
    def removeLoop(self, loop):
        self.__loop = [x for x in self.__loop if x not in loop]
        return self.__loop
    def isLoop(self, loop = False):
        return self.__loop
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def pauseTime(self):
        return self.__pauseTime
    @pauseTime.setter
    def pauseTime(self, value = 0):
        self.__pauseTime = [value]
    def setPauseTime(self, pauseTime = 0):
        self.__pauseTime = [pauseTime]
        return self
    def addPauseTime(self, pauseTime = 0):
        if self.__pauseTime == None:            self.__pauseTime =  []
        self.__pauseTime +=  [pauseTime]
        return self
    def removePauseTime(self, pauseTime):
        self.__pauseTime = [x for x in self.__pauseTime if x not in pauseTime]
        return self.__pauseTime
    def getPauseTime(self, pauseTime = 0):
        return self.__pauseTime
    def pauseTime_changed(self, pauseTime = 0):
        return self.__pauseTime
    @property
    def pitch(self):
        return self.__pitch
    @pitch.setter
    def pitch(self, value = 1.0):
        if value == None or value  <=  0:
            return None
        self.__pitch = [value]
    def setPitch(self, pitch = 1.0):
        if pitch == None or pitch  <=  0:
            return None
        self.__pitch = [pitch]
        return self
    def addPitch(self, pitch = 1.0):
        if pitch == None or pitch  <=  0:
            return None
        if self.__pitch == None:            self.__pitch =  []
        self.__pitch +=  [pitch]
        return self
    def removePitch(self, pitch):
        self.__pitch = [x for x in self.__pitch if x not in pitch]
        return self.__pitch
    def getPitch(self, pitch = 1.0):
        return self.__pitch
    def pitch_changed(self, pitch = 1.0):
        return self.__pitch
    @property
    def resumeTime(self):
        return self.__resumeTime
    @resumeTime.setter
    def resumeTime(self, value = 0):
        self.__resumeTime = [value]
    def setResumeTime(self, resumeTime = 0):
        self.__resumeTime = [resumeTime]
        return self
    def addResumeTime(self, resumeTime = 0):
        if self.__resumeTime == None:            self.__resumeTime =  []
        self.__resumeTime +=  [resumeTime]
        return self
    def removeResumeTime(self, resumeTime):
        self.__resumeTime = [x for x in self.__resumeTime if x not in resumeTime]
        return self.__resumeTime
    def getResumeTime(self, resumeTime = 0):
        return self.__resumeTime
    def resumeTime_changed(self, resumeTime = 0):
        return self.__resumeTime
    @property
    def startTime(self):
        return self.__startTime
    @startTime.setter
    def startTime(self, value = 0):
        self.__startTime = [value]
    def setStartTime(self, startTime = 0):
        self.__startTime = [startTime]
        return self
    def addStartTime(self, startTime = 0):
        if self.__startTime == None:            self.__startTime =  []
        self.__startTime +=  [startTime]
        return self
    def removeStartTime(self, startTime):
        self.__startTime = [x for x in self.__startTime if x not in startTime]
        return self.__startTime
    def getStartTime(self, startTime = 0):
        return self.__startTime
    def startTime_changed(self, startTime = 0):
        return self.__startTime
    @property
    def stopTime(self):
        return self.__stopTime
    @stopTime.setter
    def stopTime(self, value = 0):
        self.__stopTime = [value]
    def setStopTime(self, stopTime = 0):
        self.__stopTime = [stopTime]
        return self
    def addStopTime(self, stopTime = 0):
        if self.__stopTime == None:            self.__stopTime =  []
        self.__stopTime +=  [stopTime]
        return self
    def removeStopTime(self, stopTime):
        self.__stopTime = [x for x in self.__stopTime if x not in stopTime]
        return self.__stopTime
    def getStopTime(self, stopTime = 0):
        return self.__stopTime
    def stopTime_changed(self, stopTime = 0):
        return self.__stopTime
    @property
    def url(self):
        return self.__url
    @url.setter
    def url(self, value = None):
        self.__url = [value]
    def setUrl(self, url = None):
        self.__url = [url]
        return self
    def addUrl(self, url = None):
        if self.__url == None:            self.__url =  []
        self.__url +=  [url]
        return self
    def removeUrl(self, url):
        self.__url = [x for x in self.__url if x not in url]
        return self.__url
    def getUrl(self, url = None):
        return self.__url
    def url_changed(self, url = None):
        return self.__url
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<AudioClip'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__duration_changed is not None:
            if isinstance(self.__duration_changed, six.string_types):
                str += ' duration_changed="'+self.__duration_changed+'"'
            else:
                str += ' duration_changed="'+self.__duration_changed[0]+'"'
        if self.__elapsedTime is not None:
            if isinstance(self.__elapsedTime, six.string_types):
                str += ' elapsedTime="'+self.__elapsedTime+'"'
            else:
                str += ' elapsedTime="'+self.__elapsedTime[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Paused is not None:
            if isinstance(self.__Paused, six.string_types):
                str += ' Paused="'+self.__Paused+'"'
            else:
                str += ' Paused="'+self.__Paused[0]+'"'
        if self.__loop is not None:
            if isinstance(self.__loop, six.string_types):
                str += ' loop="'+self.__loop+'"'
            else:
                str += ' loop="'+self.__loop[0]+'"'
        if self.__pauseTime is not None:
            if isinstance(self.__pauseTime, six.string_types):
                str += ' pauseTime="'+self.__pauseTime+'"'
            else:
                str += ' pauseTime="'+self.__pauseTime[0]+'"'
        if self.__pitch is not None:
            if isinstance(self.__pitch, six.string_types):
                str += ' pitch="'+self.__pitch+'"'
            else:
                str += ' pitch="'+self.__pitch[0]+'"'
        if self.__resumeTime is not None:
            if isinstance(self.__resumeTime, six.string_types):
                str += ' resumeTime="'+self.__resumeTime+'"'
            else:
                str += ' resumeTime="'+self.__resumeTime[0]+'"'
        if self.__startTime is not None:
            if isinstance(self.__startTime, six.string_types):
                str += ' startTime="'+self.__startTime+'"'
            else:
                str += ' startTime="'+self.__startTime[0]+'"'
        if self.__stopTime is not None:
            if isinstance(self.__stopTime, six.string_types):
                str += ' stopTime="'+self.__stopTime+'"'
            else:
                str += ' stopTime="'+self.__stopTime[0]+'"'
        if self.__url is not None:
            if isinstance(self.__url, six.string_types):
                str += ' url="'+self.__url+'"'
            else:
                str += ' url="'+self.__url[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</AudioClip>'
        return str


class Background(X3DBackgroundNode):
    def __init__(self, **kwargs):
        super(Background, self).__init__(**kwargs)
        backUrl  = kwargs.pop("backUrl", None)
        self.__backUrl = backUrl
        bindTime  = kwargs.pop("bindTime", None)
        self.__bindTime = bindTime
        bottomUrl  = kwargs.pop("bottomUrl", None)
        self.__bottomUrl = bottomUrl
        frontUrl  = kwargs.pop("frontUrl", None)
        self.__frontUrl = frontUrl
        groundAngle  = kwargs.pop("groundAngle", None)
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        self.__groundAngle = groundAngle
        groundColor  = kwargs.pop("groundColor", None)
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        self.__groundColor = groundColor
        Bound  = kwargs.pop("Bound", None)
        self.__Bound = Bound
        leftUrl  = kwargs.pop("leftUrl", None)
        self.__leftUrl = leftUrl
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        rightUrl  = kwargs.pop("rightUrl", None)
        self.__rightUrl = rightUrl
        bind  = kwargs.pop("bind", None)
        self.__bind = bind
        skyAngle  = kwargs.pop("skyAngle", None)
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        self.__skyAngle = skyAngle
        skyColor  = kwargs.pop("skyColor", [0, 0, 0])
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        self.__skyColor = skyColor
        topUrl  = kwargs.pop("topUrl", None)
        self.__topUrl = topUrl
        transparency  = kwargs.pop("transparency", 0)
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        self.__transparency = transparency
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def backUrl(self):
        return self.__backUrl
    @backUrl.setter
    def backUrl(self, value = None):
        self.__backUrl = [value]
    def setBackUrl(self, backUrl = None):
        self.__backUrl = [backUrl]
        return self
    def addBackUrl(self, backUrl = None):
        if self.__backUrl == None:            self.__backUrl =  []
        self.__backUrl +=  [backUrl]
        return self
    def removeBackUrl(self, backUrl):
        self.__backUrl = [x for x in self.__backUrl if x not in backUrl]
        return self.__backUrl
    def getBackUrl(self, backUrl = None):
        return self.__backUrl
    def backUrl_changed(self, backUrl = None):
        return self.__backUrl
    def removeBindTime(self, bindTime):
        self.__bindTime = [x for x in self.__bindTime if x not in bindTime]
        return self.__bindTime
    def getBindTime(self, bindTime = None):
        return self.__bindTime
    def bindTime_changed(self, bindTime = None):
        return self.__bindTime
    @property
    def bottomUrl(self):
        return self.__bottomUrl
    @bottomUrl.setter
    def bottomUrl(self, value = None):
        self.__bottomUrl = [value]
    def setBottomUrl(self, bottomUrl = None):
        self.__bottomUrl = [bottomUrl]
        return self
    def addBottomUrl(self, bottomUrl = None):
        if self.__bottomUrl == None:            self.__bottomUrl =  []
        self.__bottomUrl +=  [bottomUrl]
        return self
    def removeBottomUrl(self, bottomUrl):
        self.__bottomUrl = [x for x in self.__bottomUrl if x not in bottomUrl]
        return self.__bottomUrl
    def getBottomUrl(self, bottomUrl = None):
        return self.__bottomUrl
    def bottomUrl_changed(self, bottomUrl = None):
        return self.__bottomUrl
    @property
    def frontUrl(self):
        return self.__frontUrl
    @frontUrl.setter
    def frontUrl(self, value = None):
        self.__frontUrl = [value]
    def setFrontUrl(self, frontUrl = None):
        self.__frontUrl = [frontUrl]
        return self
    def addFrontUrl(self, frontUrl = None):
        if self.__frontUrl == None:            self.__frontUrl =  []
        self.__frontUrl +=  [frontUrl]
        return self
    def removeFrontUrl(self, frontUrl):
        self.__frontUrl = [x for x in self.__frontUrl if x not in frontUrl]
        return self.__frontUrl
    def getFrontUrl(self, frontUrl = None):
        return self.__frontUrl
    def frontUrl_changed(self, frontUrl = None):
        return self.__frontUrl
    @property
    def groundAngle(self):
        return self.__groundAngle
    @groundAngle.setter
    def groundAngle(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1.5708:
            return None
        self.__groundAngle = [value]
    def setGroundAngle(self, groundAngle = None):
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        self.__groundAngle = [groundAngle]
        return self
    def addGroundAngle(self, groundAngle = None):
        if groundAngle == None or len(groundAngle) <= 0 or min(groundAngle)  <  0:
            return None
        if groundAngle == None or len(groundAngle) <= 0 or max(groundAngle)  >  1.5708:
            return None
        if self.__groundAngle == None:            self.__groundAngle =  []
        self.__groundAngle +=  [groundAngle]
        return self
    def removeGroundAngle(self, groundAngle):
        self.__groundAngle = [x for x in self.__groundAngle if x not in groundAngle]
        return self.__groundAngle
    def getGroundAngle(self, groundAngle = None):
        return self.__groundAngle
    def groundAngle_changed(self, groundAngle = None):
        return self.__groundAngle
    @property
    def groundColor(self):
        return self.__groundColor
    @groundColor.setter
    def groundColor(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__groundColor = [value]
    def setGroundColor(self, groundColor = None):
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        self.__groundColor = [groundColor]
        return self
    def addGroundColor(self, groundColor = None):
        if groundColor == None or len(groundColor) <= 0 or min(groundColor)  <  0:
            return None
        if groundColor == None or len(groundColor) <= 0 or max(groundColor)  >  1:
            return None
        if self.__groundColor == None:            self.__groundColor =  []
        self.__groundColor +=  [groundColor]
        return self
    def removeGroundColor(self, groundColor):
        self.__groundColor = [x for x in self.__groundColor if x not in groundColor]
        return self.__groundColor
    def getGroundColor(self, groundColor = None):
        return self.__groundColor
    def groundColor_changed(self, groundColor = None):
        return self.__groundColor
    def isBound(self, Bound = None):
        return self.__Bound
    @property
    def leftUrl(self):
        return self.__leftUrl
    @leftUrl.setter
    def leftUrl(self, value = None):
        self.__leftUrl = [value]
    def setLeftUrl(self, leftUrl = None):
        self.__leftUrl = [leftUrl]
        return self
    def addLeftUrl(self, leftUrl = None):
        if self.__leftUrl == None:            self.__leftUrl =  []
        self.__leftUrl +=  [leftUrl]
        return self
    def removeLeftUrl(self, leftUrl):
        self.__leftUrl = [x for x in self.__leftUrl if x not in leftUrl]
        return self.__leftUrl
    def getLeftUrl(self, leftUrl = None):
        return self.__leftUrl
    def leftUrl_changed(self, leftUrl = None):
        return self.__leftUrl
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def rightUrl(self):
        return self.__rightUrl
    @rightUrl.setter
    def rightUrl(self, value = None):
        self.__rightUrl = [value]
    def setRightUrl(self, rightUrl = None):
        self.__rightUrl = [rightUrl]
        return self
    def addRightUrl(self, rightUrl = None):
        if self.__rightUrl == None:            self.__rightUrl =  []
        self.__rightUrl +=  [rightUrl]
        return self
    def removeRightUrl(self, rightUrl):
        self.__rightUrl = [x for x in self.__rightUrl if x not in rightUrl]
        return self.__rightUrl
    def getRightUrl(self, rightUrl = None):
        return self.__rightUrl
    def rightUrl_changed(self, rightUrl = None):
        return self.__rightUrl
    @property
    def bind(self):
        return self.__bind
    @bind.setter
    def bind(self, value = None):
        self.__bind = [value]
    def set_bind(self, bind = None):
        self.__bind = [bind]
        return self
    @property
    def skyAngle(self):
        return self.__skyAngle
    @skyAngle.setter
    def skyAngle(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  3.1416:
            return None
        self.__skyAngle = [value]
    def setSkyAngle(self, skyAngle = None):
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        self.__skyAngle = [skyAngle]
        return self
    def addSkyAngle(self, skyAngle = None):
        if skyAngle == None or len(skyAngle) <= 0 or min(skyAngle)  <  0:
            return None
        if skyAngle == None or len(skyAngle) <= 0 or max(skyAngle)  >  3.1416:
            return None
        if self.__skyAngle == None:            self.__skyAngle =  []
        self.__skyAngle +=  [skyAngle]
        return self
    def removeSkyAngle(self, skyAngle):
        self.__skyAngle = [x for x in self.__skyAngle if x not in skyAngle]
        return self.__skyAngle
    def getSkyAngle(self, skyAngle = None):
        return self.__skyAngle
    def skyAngle_changed(self, skyAngle = None):
        return self.__skyAngle
    @property
    def skyColor(self):
        return self.__skyColor
    @skyColor.setter
    def skyColor(self, value = [0, 0, 0]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__skyColor = [value]
    def setSkyColor(self, skyColor = [0, 0, 0]):
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        self.__skyColor = [skyColor]
        return self
    def addSkyColor(self, skyColor = [0, 0, 0]):
        if skyColor == None or len(skyColor) <= 0 or min(skyColor)  <  0:
            return None
        if skyColor == None or len(skyColor) <= 0 or max(skyColor)  >  1:
            return None
        if self.__skyColor == None:            self.__skyColor =  []
        self.__skyColor +=  [skyColor]
        return self
    def removeSkyColor(self, skyColor):
        self.__skyColor = [x for x in self.__skyColor if x not in skyColor]
        return self.__skyColor
    def getSkyColor(self, skyColor = [0, 0, 0]):
        return self.__skyColor
    def skyColor_changed(self, skyColor = [0, 0, 0]):
        return self.__skyColor
    @property
    def topUrl(self):
        return self.__topUrl
    @topUrl.setter
    def topUrl(self, value = None):
        self.__topUrl = [value]
    def setTopUrl(self, topUrl = None):
        self.__topUrl = [topUrl]
        return self
    def addTopUrl(self, topUrl = None):
        if self.__topUrl == None:            self.__topUrl =  []
        self.__topUrl +=  [topUrl]
        return self
    def removeTopUrl(self, topUrl):
        self.__topUrl = [x for x in self.__topUrl if x not in topUrl]
        return self.__topUrl
    def getTopUrl(self, topUrl = None):
        return self.__topUrl
    def topUrl_changed(self, topUrl = None):
        return self.__topUrl
    @property
    def transparency(self):
        return self.__transparency
    @transparency.setter
    def transparency(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__transparency = [value]
    def setTransparency(self, transparency = 0):
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        self.__transparency = [transparency]
        return self
    def addTransparency(self, transparency = 0):
        if transparency == None or transparency  <  0:
            return None
        if transparency == None or transparency  >  1:
            return None
        if self.__transparency == None:            self.__transparency =  []
        self.__transparency +=  [transparency]
        return self
    def removeTransparency(self, transparency):
        self.__transparency = [x for x in self.__transparency if x not in transparency]
        return self.__transparency
    def getTransparency(self, transparency = 0):
        return self.__transparency
    def transparency_changed(self, transparency = 0):
        return self.__transparency
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Background'
        if self.__backUrl is not None:
            if isinstance(self.__backUrl, six.string_types):
                str += ' backUrl="'+self.__backUrl+'"'
            else:
                str += ' backUrl="'+self.__backUrl[0]+'"'
        if self.__bindTime is not None:
            if isinstance(self.__bindTime, six.string_types):
                str += ' bindTime="'+self.__bindTime+'"'
            else:
                str += ' bindTime="'+self.__bindTime[0]+'"'
        if self.__bottomUrl is not None:
            if isinstance(self.__bottomUrl, six.string_types):
                str += ' bottomUrl="'+self.__bottomUrl+'"'
            else:
                str += ' bottomUrl="'+self.__bottomUrl[0]+'"'
        if self.__frontUrl is not None:
            if isinstance(self.__frontUrl, six.string_types):
                str += ' frontUrl="'+self.__frontUrl+'"'
            else:
                str += ' frontUrl="'+self.__frontUrl[0]+'"'
        if self.__groundAngle is not None:
            if isinstance(self.__groundAngle, six.string_types):
                str += ' groundAngle="'+self.__groundAngle+'"'
            else:
                str += ' groundAngle="'+self.__groundAngle[0]+'"'
        if self.__groundColor is not None:
            if isinstance(self.__groundColor, six.string_types):
                str += ' groundColor="'+self.__groundColor+'"'
            else:
                str += ' groundColor="'+self.__groundColor[0]+'"'
        if self.__Bound is not None:
            if isinstance(self.__Bound, six.string_types):
                str += ' Bound="'+self.__Bound+'"'
            else:
                str += ' Bound="'+self.__Bound[0]+'"'
        if self.__leftUrl is not None:
            if isinstance(self.__leftUrl, six.string_types):
                str += ' leftUrl="'+self.__leftUrl+'"'
            else:
                str += ' leftUrl="'+self.__leftUrl[0]+'"'
        if self.__rightUrl is not None:
            if isinstance(self.__rightUrl, six.string_types):
                str += ' rightUrl="'+self.__rightUrl+'"'
            else:
                str += ' rightUrl="'+self.__rightUrl[0]+'"'
        if self.__bind is not None:
            if isinstance(self.__bind, six.string_types):
                str += ' bind="'+self.__bind+'"'
            else:
                str += ' bind="'+self.__bind[0]+'"'
        if self.__skyAngle is not None:
            if isinstance(self.__skyAngle, six.string_types):
                str += ' skyAngle="'+self.__skyAngle+'"'
            else:
                str += ' skyAngle="'+self.__skyAngle[0]+'"'
        if self.__skyColor is not None:
            if isinstance(self.__skyColor, six.string_types):
                str += ' skyColor="'+self.__skyColor+'"'
            else:
                str += ' skyColor="'+self.__skyColor[0]+'"'
        if self.__topUrl is not None:
            if isinstance(self.__topUrl, six.string_types):
                str += ' topUrl="'+self.__topUrl+'"'
            else:
                str += ' topUrl="'+self.__topUrl[0]+'"'
        if self.__transparency is not None:
            if isinstance(self.__transparency, six.string_types):
                str += ' transparency="'+self.__transparency+'"'
            else:
                str += ' transparency="'+self.__transparency[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Background>'
        return str


class BallJoint(X3DRigidJointNode):
    def __init__(self, **kwargs):
        super(BallJoint, self).__init__(**kwargs)
        anchorPoint  = kwargs.pop("anchorPoint", [0, 0, 0])
        self.__anchorPoint = anchorPoint
        body1  = kwargs.pop("body1", None)
        self.__body1 = body1
        body1AnchorPoint  = kwargs.pop("body1AnchorPoint", None)
        self.__body1AnchorPoint = body1AnchorPoint
        body2  = kwargs.pop("body2", None)
        self.__body2 = body2
        body2AnchorPoint  = kwargs.pop("body2AnchorPoint", None)
        self.__body2AnchorPoint = body2AnchorPoint
        forceOutput  = kwargs.pop("forceOutput", ["NONE"])
        self.__forceOutput = forceOutput
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def anchorPoint(self):
        return self.__anchorPoint
    @anchorPoint.setter
    def anchorPoint(self, value = [0, 0, 0]):
        self.__anchorPoint = [value]
    def setAnchorPoint(self, anchorPoint = [0, 0, 0]):
        self.__anchorPoint = [anchorPoint]
        return self
    def addAnchorPoint(self, anchorPoint = [0, 0, 0]):
        if self.__anchorPoint == None:            self.__anchorPoint =  []
        self.__anchorPoint +=  [anchorPoint]
        return self
    def removeAnchorPoint(self, anchorPoint):
        self.__anchorPoint = [x for x in self.__anchorPoint if x not in anchorPoint]
        return self.__anchorPoint
    def getAnchorPoint(self, anchorPoint = [0, 0, 0]):
        return self.__anchorPoint
    def anchorPoint_changed(self, anchorPoint = [0, 0, 0]):
        return self.__anchorPoint
    @property
    def body1(self):
        return self.__body1
    @body1.setter
    def body1(self, value = None):
        self.__body1 = [value]
    def setBody1(self, body1 = None):
        self.__body1 = [body1]
        return self
    def addBody1(self, body1 = None):
        if self.__body1 == None:            self.__body1 =  []
        self.__body1 +=  [body1]
        return self
    def removeBody1(self, body1):
        self.__body1 = [x for x in self.__body1 if x not in body1]
        return self.__body1
    def getBody1(self, body1 = None):
        return self.__body1
    def body1_changed(self, body1 = None):
        return self.__body1
    def removeBody1AnchorPoint(self, body1AnchorPoint):
        self.__body1AnchorPoint = [x for x in self.__body1AnchorPoint if x not in body1AnchorPoint]
        return self.__body1AnchorPoint
    def getBody1AnchorPoint(self, body1AnchorPoint = None):
        return self.__body1AnchorPoint
    def body1AnchorPoint_changed(self, body1AnchorPoint = None):
        return self.__body1AnchorPoint
    @property
    def body2(self):
        return self.__body2
    @body2.setter
    def body2(self, value = None):
        self.__body2 = [value]
    def setBody2(self, body2 = None):
        self.__body2 = [body2]
        return self
    def addBody2(self, body2 = None):
        if self.__body2 == None:            self.__body2 =  []
        self.__body2 +=  [body2]
        return self
    def removeBody2(self, body2):
        self.__body2 = [x for x in self.__body2 if x not in body2]
        return self.__body2
    def getBody2(self, body2 = None):
        return self.__body2
    def body2_changed(self, body2 = None):
        return self.__body2
    def removeBody2AnchorPoint(self, body2AnchorPoint):
        self.__body2AnchorPoint = [x for x in self.__body2AnchorPoint if x not in body2AnchorPoint]
        return self.__body2AnchorPoint
    def getBody2AnchorPoint(self, body2AnchorPoint = None):
        return self.__body2AnchorPoint
    def body2AnchorPoint_changed(self, body2AnchorPoint = None):
        return self.__body2AnchorPoint
    @property
    def forceOutput(self):
        return self.__forceOutput
    @forceOutput.setter
    def forceOutput(self, value = ["NONE"]):
        self.__forceOutput = [value]
    def setForceOutput(self, forceOutput = ["NONE"]):
        self.__forceOutput = [forceOutput]
        return self
    def addForceOutput(self, forceOutput = ["NONE"]):
        if self.__forceOutput == None:            self.__forceOutput =  []
        self.__forceOutput +=  [forceOutput]
        return self
    def removeForceOutput(self, forceOutput):
        self.__forceOutput = [x for x in self.__forceOutput if x not in forceOutput]
        return self.__forceOutput
    def getForceOutput(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    def forceOutput_changed(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BallJoint'
        if self.__anchorPoint is not None:
            if isinstance(self.__anchorPoint, six.string_types):
                str += ' anchorPoint="'+self.__anchorPoint+'"'
            else:
                str += ' anchorPoint="'+self.__anchorPoint[0]+'"'
        if self.__body1AnchorPoint is not None:
            if isinstance(self.__body1AnchorPoint, six.string_types):
                str += ' body1AnchorPoint="'+self.__body1AnchorPoint+'"'
            else:
                str += ' body1AnchorPoint="'+self.__body1AnchorPoint[0]+'"'
        if self.__body2AnchorPoint is not None:
            if isinstance(self.__body2AnchorPoint, six.string_types):
                str += ' body2AnchorPoint="'+self.__body2AnchorPoint+'"'
            else:
                str += ' body2AnchorPoint="'+self.__body2AnchorPoint[0]+'"'
        if self.__forceOutput is not None:
            if isinstance(self.__forceOutput, six.string_types):
                str += ' forceOutput="'+self.__forceOutput+'"'
            else:
                str += ' forceOutput="'+self.__forceOutput[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<body1'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body1>'
        str += '<body2'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body2>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BallJoint>'
        return str


class Billboard(X3DGroupingNode):
    def __init__(self, **kwargs):
        super(Billboard, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        axisOfRotation  = kwargs.pop("axisOfRotation", [0, 1, 0])
        self.__axisOfRotation = axisOfRotation
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def axisOfRotation(self):
        return self.__axisOfRotation
    @axisOfRotation.setter
    def axisOfRotation(self, value = [0, 1, 0]):
        self.__axisOfRotation = [value]
    def setAxisOfRotation(self, axisOfRotation = [0, 1, 0]):
        self.__axisOfRotation = [axisOfRotation]
        return self
    def addAxisOfRotation(self, axisOfRotation = [0, 1, 0]):
        if self.__axisOfRotation == None:            self.__axisOfRotation =  []
        self.__axisOfRotation +=  [axisOfRotation]
        return self
    def removeAxisOfRotation(self, axisOfRotation):
        self.__axisOfRotation = [x for x in self.__axisOfRotation if x not in axisOfRotation]
        return self.__axisOfRotation
    def getAxisOfRotation(self, axisOfRotation = [0, 1, 0]):
        return self.__axisOfRotation
    def axisOfRotation_changed(self, axisOfRotation = [0, 1, 0]):
        return self.__axisOfRotation
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Billboard'
        if self.__axisOfRotation is not None:
            if isinstance(self.__axisOfRotation, six.string_types):
                str += ' axisOfRotation="'+self.__axisOfRotation+'"'
            else:
                str += ' axisOfRotation="'+self.__axisOfRotation[0]+'"'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</Billboard>'
        return str


class BlendedVolumeStyle(X3DComposableVolumeRenderStyleNode):
    def __init__(self, **kwargs):
        super(BlendedVolumeStyle, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        renderStyle  = kwargs.pop("renderStyle", None)
        self.__renderStyle = renderStyle
        voxels  = kwargs.pop("voxels", None)
        self.__voxels = voxels
        weightConstant1  = kwargs.pop("weightConstant1", 0.5)
        if weightConstant1 == None or weightConstant1  <  0:
            return None
        if weightConstant1 == None or weightConstant1  >  1:
            return None
        self.__weightConstant1 = weightConstant1
        weightConstant2  = kwargs.pop("weightConstant2", 0.5)
        if weightConstant2 == None or weightConstant2  <  0:
            return None
        if weightConstant2 == None or weightConstant2  >  1:
            return None
        self.__weightConstant2 = weightConstant2
        weightFunction1  = kwargs.pop("weightFunction1", "CONSTANT")
        if 'CONSTANT' == weightFunction1:
            pass
        elif 'ALPHA1' == weightFunction1:
            pass
        elif 'ALPHA2' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction1:
            pass
        elif 'TABLE' == weightFunction1:
            pass
        else:
            return None
        self.__weightFunction1 = weightFunction1
        weightFunction2  = kwargs.pop("weightFunction2", "CONSTANT")
        if 'CONSTANT' == weightFunction2:
            pass
        elif 'ALPHA1' == weightFunction2:
            pass
        elif 'ALPHA2' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction2:
            pass
        elif 'TABLE' == weightFunction2:
            pass
        else:
            return None
        self.__weightFunction2 = weightFunction2
        weightTransferFunction1  = kwargs.pop("weightTransferFunction1", None)
        self.__weightTransferFunction1 = weightTransferFunction1
        weightTransferFunction2  = kwargs.pop("weightTransferFunction2", None)
        self.__weightTransferFunction2 = weightTransferFunction2
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def renderStyle(self):
        return self.__renderStyle
    @renderStyle.setter
    def renderStyle(self, value = None):
        self.__renderStyle = [value]
    def setRenderStyle(self, renderStyle = None):
        self.__renderStyle = [renderStyle]
        return self
    def addRenderStyle(self, renderStyle = None):
        if self.__renderStyle == None:            self.__renderStyle =  []
        self.__renderStyle +=  [renderStyle]
        return self
    def removeRenderStyle(self, renderStyle):
        self.__renderStyle = [x for x in self.__renderStyle if x not in renderStyle]
        return self.__renderStyle
    def getRenderStyle(self, renderStyle = None):
        return self.__renderStyle
    def renderStyle_changed(self, renderStyle = None):
        return self.__renderStyle
    @property
    def voxels(self):
        return self.__voxels
    @voxels.setter
    def voxels(self, value = None):
        self.__voxels = [value]
    def setVoxels(self, voxels = None):
        self.__voxels = [voxels]
        return self
    def addVoxels(self, voxels = None):
        if self.__voxels == None:            self.__voxels =  []
        self.__voxels +=  [voxels]
        return self
    def removeVoxels(self, voxels):
        self.__voxels = [x for x in self.__voxels if x not in voxels]
        return self.__voxels
    def getVoxels(self, voxels = None):
        return self.__voxels
    def voxels_changed(self, voxels = None):
        return self.__voxels
    @property
    def weightConstant1(self):
        return self.__weightConstant1
    @weightConstant1.setter
    def weightConstant1(self, value = 0.5):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__weightConstant1 = [value]
    def setWeightConstant1(self, weightConstant1 = 0.5):
        if weightConstant1 == None or weightConstant1  <  0:
            return None
        if weightConstant1 == None or weightConstant1  >  1:
            return None
        self.__weightConstant1 = [weightConstant1]
        return self
    def addWeightConstant1(self, weightConstant1 = 0.5):
        if weightConstant1 == None or weightConstant1  <  0:
            return None
        if weightConstant1 == None or weightConstant1  >  1:
            return None
        if self.__weightConstant1 == None:            self.__weightConstant1 =  []
        self.__weightConstant1 +=  [weightConstant1]
        return self
    def removeWeightConstant1(self, weightConstant1):
        self.__weightConstant1 = [x for x in self.__weightConstant1 if x not in weightConstant1]
        return self.__weightConstant1
    def getWeightConstant1(self, weightConstant1 = 0.5):
        return self.__weightConstant1
    def weightConstant1_changed(self, weightConstant1 = 0.5):
        return self.__weightConstant1
    @property
    def weightConstant2(self):
        return self.__weightConstant2
    @weightConstant2.setter
    def weightConstant2(self, value = 0.5):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__weightConstant2 = [value]
    def setWeightConstant2(self, weightConstant2 = 0.5):
        if weightConstant2 == None or weightConstant2  <  0:
            return None
        if weightConstant2 == None or weightConstant2  >  1:
            return None
        self.__weightConstant2 = [weightConstant2]
        return self
    def addWeightConstant2(self, weightConstant2 = 0.5):
        if weightConstant2 == None or weightConstant2  <  0:
            return None
        if weightConstant2 == None or weightConstant2  >  1:
            return None
        if self.__weightConstant2 == None:            self.__weightConstant2 =  []
        self.__weightConstant2 +=  [weightConstant2]
        return self
    def removeWeightConstant2(self, weightConstant2):
        self.__weightConstant2 = [x for x in self.__weightConstant2 if x not in weightConstant2]
        return self.__weightConstant2
    def getWeightConstant2(self, weightConstant2 = 0.5):
        return self.__weightConstant2
    def weightConstant2_changed(self, weightConstant2 = 0.5):
        return self.__weightConstant2
    @property
    def weightFunction1(self):
        return self.__weightFunction1
    @weightFunction1.setter
    def weightFunction1(self, value = "CONSTANT"):
        if 'CONSTANT' == value:
            pass
        elif 'ALPHA1' == value:
            pass
        elif 'ALPHA2' == value:
            pass
        elif 'ONE_MINUS_ALPHA1' == value:
            pass
        elif 'ONE_MINUS_ALPHA2' == value:
            pass
        elif 'TABLE' == value:
            pass
        else:
            return None
        self.__weightFunction1 = [value]
    def setWeightFunction1(self, weightFunction1 = "CONSTANT"):
        if 'CONSTANT' == weightFunction1:
            pass
        elif 'ALPHA1' == weightFunction1:
            pass
        elif 'ALPHA2' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction1:
            pass
        elif 'TABLE' == weightFunction1:
            pass
        else:
            return None
        self.__weightFunction1 = [weightFunction1]
        return self
    def addWeightFunction1(self, weightFunction1 = "CONSTANT"):
        if 'CONSTANT' == weightFunction1:
            pass
        elif 'ALPHA1' == weightFunction1:
            pass
        elif 'ALPHA2' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction1:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction1:
            pass
        elif 'TABLE' == weightFunction1:
            pass
        else:
            return None
        if self.__weightFunction1 == None:            self.__weightFunction1 =  []
        self.__weightFunction1 +=  [weightFunction1]
        return self
    def removeWeightFunction1(self, weightFunction1):
        self.__weightFunction1 = [x for x in self.__weightFunction1 if x not in weightFunction1]
        return self.__weightFunction1
    def getWeightFunction1(self, weightFunction1 = "CONSTANT"):
        return self.__weightFunction1
    def weightFunction1_changed(self, weightFunction1 = "CONSTANT"):
        return self.__weightFunction1
    @property
    def weightFunction2(self):
        return self.__weightFunction2
    @weightFunction2.setter
    def weightFunction2(self, value = "CONSTANT"):
        if 'CONSTANT' == value:
            pass
        elif 'ALPHA1' == value:
            pass
        elif 'ALPHA2' == value:
            pass
        elif 'ONE_MINUS_ALPHA1' == value:
            pass
        elif 'ONE_MINUS_ALPHA2' == value:
            pass
        elif 'TABLE' == value:
            pass
        else:
            return None
        self.__weightFunction2 = [value]
    def setWeightFunction2(self, weightFunction2 = "CONSTANT"):
        if 'CONSTANT' == weightFunction2:
            pass
        elif 'ALPHA1' == weightFunction2:
            pass
        elif 'ALPHA2' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction2:
            pass
        elif 'TABLE' == weightFunction2:
            pass
        else:
            return None
        self.__weightFunction2 = [weightFunction2]
        return self
    def addWeightFunction2(self, weightFunction2 = "CONSTANT"):
        if 'CONSTANT' == weightFunction2:
            pass
        elif 'ALPHA1' == weightFunction2:
            pass
        elif 'ALPHA2' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA1' == weightFunction2:
            pass
        elif 'ONE_MINUS_ALPHA2' == weightFunction2:
            pass
        elif 'TABLE' == weightFunction2:
            pass
        else:
            return None
        if self.__weightFunction2 == None:            self.__weightFunction2 =  []
        self.__weightFunction2 +=  [weightFunction2]
        return self
    def removeWeightFunction2(self, weightFunction2):
        self.__weightFunction2 = [x for x in self.__weightFunction2 if x not in weightFunction2]
        return self.__weightFunction2
    def getWeightFunction2(self, weightFunction2 = "CONSTANT"):
        return self.__weightFunction2
    def weightFunction2_changed(self, weightFunction2 = "CONSTANT"):
        return self.__weightFunction2
    @property
    def weightTransferFunction1(self):
        return self.__weightTransferFunction1
    @weightTransferFunction1.setter
    def weightTransferFunction1(self, value = None):
        self.__weightTransferFunction1 = [value]
    def setWeightTransferFunction1(self, weightTransferFunction1 = None):
        self.__weightTransferFunction1 = [weightTransferFunction1]
        return self
    def addWeightTransferFunction1(self, weightTransferFunction1 = None):
        if self.__weightTransferFunction1 == None:            self.__weightTransferFunction1 =  []
        self.__weightTransferFunction1 +=  [weightTransferFunction1]
        return self
    def removeWeightTransferFunction1(self, weightTransferFunction1):
        self.__weightTransferFunction1 = [x for x in self.__weightTransferFunction1 if x not in weightTransferFunction1]
        return self.__weightTransferFunction1
    def getWeightTransferFunction1(self, weightTransferFunction1 = None):
        return self.__weightTransferFunction1
    def weightTransferFunction1_changed(self, weightTransferFunction1 = None):
        return self.__weightTransferFunction1
    @property
    def weightTransferFunction2(self):
        return self.__weightTransferFunction2
    @weightTransferFunction2.setter
    def weightTransferFunction2(self, value = None):
        self.__weightTransferFunction2 = [value]
    def setWeightTransferFunction2(self, weightTransferFunction2 = None):
        self.__weightTransferFunction2 = [weightTransferFunction2]
        return self
    def addWeightTransferFunction2(self, weightTransferFunction2 = None):
        if self.__weightTransferFunction2 == None:            self.__weightTransferFunction2 =  []
        self.__weightTransferFunction2 +=  [weightTransferFunction2]
        return self
    def removeWeightTransferFunction2(self, weightTransferFunction2):
        self.__weightTransferFunction2 = [x for x in self.__weightTransferFunction2 if x not in weightTransferFunction2]
        return self.__weightTransferFunction2
    def getWeightTransferFunction2(self, weightTransferFunction2 = None):
        return self.__weightTransferFunction2
    def weightTransferFunction2_changed(self, weightTransferFunction2 = None):
        return self.__weightTransferFunction2
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BlendedVolumeStyle'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__weightConstant1 is not None:
            if isinstance(self.__weightConstant1, six.string_types):
                str += ' weightConstant1="'+self.__weightConstant1+'"'
            else:
                str += ' weightConstant1="'+self.__weightConstant1[0]+'"'
        if self.__weightConstant2 is not None:
            if isinstance(self.__weightConstant2, six.string_types):
                str += ' weightConstant2="'+self.__weightConstant2+'"'
            else:
                str += ' weightConstant2="'+self.__weightConstant2[0]+'"'
        if self.__weightFunction1 is not None:
            if isinstance(self.__weightFunction1, six.string_types):
                str += ' weightFunction1="'+self.__weightFunction1+'"'
            else:
                str += ' weightFunction1="'+self.__weightFunction1[0]+'"'
        if self.__weightFunction2 is not None:
            if isinstance(self.__weightFunction2, six.string_types):
                str += ' weightFunction2="'+self.__weightFunction2+'"'
            else:
                str += ' weightFunction2="'+self.__weightFunction2[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<renderStyle'
        if self.__renderStyle is not None:
           for s in self.__renderStyle:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__renderStyle is not None:
           for s in self.__renderStyle:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</renderStyle>'
        str += '<voxels'
        if self.__voxels is not None:
           for s in self.__voxels:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__voxels is not None:
           for s in self.__voxels:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</voxels>'
        str += '<weightTransferFunction1'
        if self.__weightTransferFunction1 is not None:
           for s in self.__weightTransferFunction1:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__weightTransferFunction1 is not None:
           for s in self.__weightTransferFunction1:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</weightTransferFunction1>'
        str += '<weightTransferFunction2'
        if self.__weightTransferFunction2 is not None:
           for s in self.__weightTransferFunction2:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__weightTransferFunction2 is not None:
           for s in self.__weightTransferFunction2:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</weightTransferFunction2>'
        str += '</BlendedVolumeStyle>'
        return str


class BooleanFilter(X3DChildNode):
    def __init__(self, **kwargs):
        super(BooleanFilter, self).__init__(**kwargs)
        inputFalse  = kwargs.pop("inputFalse", None)
        self.__inputFalse = inputFalse
        inputNegate  = kwargs.pop("inputNegate", None)
        self.__inputNegate = inputNegate
        inputTrue  = kwargs.pop("inputTrue", None)
        self.__inputTrue = inputTrue
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        boolean  = kwargs.pop("boolean", None)
        self.__boolean = boolean
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeInputFalse(self, inputFalse):
        self.__inputFalse = [x for x in self.__inputFalse if x not in inputFalse]
        return self.__inputFalse
    def isInputFalse(self, inputFalse = None):
        return self.__inputFalse
    def removeInputNegate(self, inputNegate):
        self.__inputNegate = [x for x in self.__inputNegate if x not in inputNegate]
        return self.__inputNegate
    def isInputNegate(self, inputNegate = None):
        return self.__inputNegate
    def removeInputTrue(self, inputTrue):
        self.__inputTrue = [x for x in self.__inputTrue if x not in inputTrue]
        return self.__inputTrue
    def isInputTrue(self, inputTrue = None):
        return self.__inputTrue
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def boolean(self):
        return self.__boolean
    @boolean.setter
    def boolean(self, value = None):
        self.__boolean = [value]
    def set_boolean(self, boolean = None):
        self.__boolean = [boolean]
        return self
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BooleanFilter'
        if self.__inputFalse is not None:
            if isinstance(self.__inputFalse, six.string_types):
                str += ' inputFalse="'+self.__inputFalse+'"'
            else:
                str += ' inputFalse="'+self.__inputFalse[0]+'"'
        if self.__inputNegate is not None:
            if isinstance(self.__inputNegate, six.string_types):
                str += ' inputNegate="'+self.__inputNegate+'"'
            else:
                str += ' inputNegate="'+self.__inputNegate[0]+'"'
        if self.__inputTrue is not None:
            if isinstance(self.__inputTrue, six.string_types):
                str += ' inputTrue="'+self.__inputTrue+'"'
            else:
                str += ' inputTrue="'+self.__inputTrue[0]+'"'
        if self.__boolean is not None:
            if isinstance(self.__boolean, six.string_types):
                str += ' boolean="'+self.__boolean+'"'
            else:
                str += ' boolean="'+self.__boolean[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BooleanFilter>'
        return str


class BooleanSequencer(X3DSequencerNode):
    def __init__(self, **kwargs):
        super(BooleanSequencer, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        keyValue  = kwargs.pop("keyValue", None)
        self.__keyValue = keyValue
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        next  = kwargs.pop("next", None)
        self.__next = next
        previous  = kwargs.pop("previous", None)
        self.__previous = previous
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        value_changed  = kwargs.pop("value_changed", None)
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def keyValue(self):
        return self.__keyValue
    @keyValue.setter
    def keyValue(self, value = None):
        self.__keyValue = [value]
    def setKeyValue(self, keyValue = None):
        self.__keyValue = [keyValue]
        return self
    def addKeyValue(self, keyValue = None):
        if self.__keyValue == None:            self.__keyValue =  []
        self.__keyValue +=  [keyValue]
        return self
    def removeKeyValue(self, keyValue):
        self.__keyValue = [x for x in self.__keyValue if x not in keyValue]
        return self.__keyValue
    def getKeyValue(self, keyValue = None):
        return self.__keyValue
    def keyValue_changed(self, keyValue = None):
        return self.__keyValue
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def next(self):
        return self.__next
    @next.setter
    def next(self, value = None):
        self.__next = [value]
    def setNext(self, next = None):
        self.__next = [next]
        return self
    def addNext(self, next = None):
        if self.__next == None:            self.__next =  []
        self.__next +=  [next]
        return self
    @property
    def previous(self):
        return self.__previous
    @previous.setter
    def previous(self, value = None):
        self.__previous = [value]
    def setPrevious(self, previous = None):
        self.__previous = [previous]
        return self
    def addPrevious(self, previous = None):
        if self.__previous == None:            self.__previous =  []
        self.__previous +=  [previous]
        return self
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def isvalue_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BooleanSequencer'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__keyValue is not None:
            if isinstance(self.__keyValue, six.string_types):
                str += ' keyValue="'+self.__keyValue+'"'
            else:
                str += ' keyValue="'+self.__keyValue[0]+'"'
        if self.__next is not None:
            if isinstance(self.__next, six.string_types):
                str += ' next="'+self.__next+'"'
            else:
                str += ' next="'+self.__next[0]+'"'
        if self.__previous is not None:
            if isinstance(self.__previous, six.string_types):
                str += ' previous="'+self.__previous+'"'
            else:
                str += ' previous="'+self.__previous[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BooleanSequencer>'
        return str


class BooleanToggle(X3DChildNode):
    def __init__(self, **kwargs):
        super(BooleanToggle, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        boolean  = kwargs.pop("boolean", None)
        self.__boolean = boolean
        toggle  = kwargs.pop("toggle", False)
        self.__toggle = toggle
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def boolean(self):
        return self.__boolean
    @boolean.setter
    def boolean(self, value = None):
        self.__boolean = [value]
    def set_boolean(self, boolean = None):
        self.__boolean = [boolean]
        return self
    @property
    def toggle(self):
        return self.__toggle
    @toggle.setter
    def toggle(self, value = False):
        self.__toggle = [value]
    def setToggle(self, toggle = False):
        self.__toggle = [toggle]
        return self
    def addToggle(self, toggle = False):
        if self.__toggle == None:            self.__toggle =  []
        self.__toggle +=  [toggle]
        return self
    def removeToggle(self, toggle):
        self.__toggle = [x for x in self.__toggle if x not in toggle]
        return self.__toggle
    def isToggle(self, toggle = False):
        return self.__toggle
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BooleanToggle'
        if self.__boolean is not None:
            if isinstance(self.__boolean, six.string_types):
                str += ' boolean="'+self.__boolean+'"'
            else:
                str += ' boolean="'+self.__boolean[0]+'"'
        if self.__toggle is not None:
            if isinstance(self.__toggle, six.string_types):
                str += ' toggle="'+self.__toggle+'"'
            else:
                str += ' toggle="'+self.__toggle[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BooleanToggle>'
        return str


class BooleanTrigger(X3DTriggerNode):
    def __init__(self, **kwargs):
        super(BooleanTrigger, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        triggerTime  = kwargs.pop("triggerTime", None)
        self.__triggerTime = triggerTime
        triggerTrue  = kwargs.pop("triggerTrue", None)
        self.__triggerTrue = triggerTrue
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def triggerTime(self):
        return self.__triggerTime
    @triggerTime.setter
    def triggerTime(self, value = None):
        self.__triggerTime = [value]
    def set_triggerTime(self, triggerTime = None):
        self.__triggerTime = [triggerTime]
        return self
    def removeTriggerTrue(self, triggerTrue):
        self.__triggerTrue = [x for x in self.__triggerTrue if x not in triggerTrue]
        return self.__triggerTrue
    def isTriggerTrue(self, triggerTrue = None):
        return self.__triggerTrue
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BooleanTrigger'
        if self.__triggerTime is not None:
            if isinstance(self.__triggerTime, six.string_types):
                str += ' triggerTime="'+self.__triggerTime+'"'
            else:
                str += ' triggerTime="'+self.__triggerTime[0]+'"'
        if self.__triggerTrue is not None:
            if isinstance(self.__triggerTrue, six.string_types):
                str += ' triggerTrue="'+self.__triggerTrue+'"'
            else:
                str += ' triggerTrue="'+self.__triggerTrue[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BooleanTrigger>'
        return str


class BoundaryEnhancementVolumeStyle(X3DComposableVolumeRenderStyleNode):
    def __init__(self, **kwargs):
        super(BoundaryEnhancementVolumeStyle, self).__init__(**kwargs)
        boundaryOpacity  = kwargs.pop("boundaryOpacity", 0.9)
        if boundaryOpacity == None or boundaryOpacity  <  0:
            return None
        if boundaryOpacity == None or boundaryOpacity  >  1:
            return None
        self.__boundaryOpacity = boundaryOpacity
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        opacityFactor  = kwargs.pop("opacityFactor", 2)
        if opacityFactor == None or opacityFactor  <  0:
            return None
        self.__opacityFactor = opacityFactor
        retainedOpacity  = kwargs.pop("retainedOpacity", 0.2)
        if retainedOpacity == None or retainedOpacity  <  0:
            return None
        if retainedOpacity == None or retainedOpacity  >  1:
            return None
        self.__retainedOpacity = retainedOpacity
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def boundaryOpacity(self):
        return self.__boundaryOpacity
    @boundaryOpacity.setter
    def boundaryOpacity(self, value = 0.9):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__boundaryOpacity = [value]
    def setBoundaryOpacity(self, boundaryOpacity = 0.9):
        if boundaryOpacity == None or boundaryOpacity  <  0:
            return None
        if boundaryOpacity == None or boundaryOpacity  >  1:
            return None
        self.__boundaryOpacity = [boundaryOpacity]
        return self
    def addBoundaryOpacity(self, boundaryOpacity = 0.9):
        if boundaryOpacity == None or boundaryOpacity  <  0:
            return None
        if boundaryOpacity == None or boundaryOpacity  >  1:
            return None
        if self.__boundaryOpacity == None:            self.__boundaryOpacity =  []
        self.__boundaryOpacity +=  [boundaryOpacity]
        return self
    def removeBoundaryOpacity(self, boundaryOpacity):
        self.__boundaryOpacity = [x for x in self.__boundaryOpacity if x not in boundaryOpacity]
        return self.__boundaryOpacity
    def getBoundaryOpacity(self, boundaryOpacity = 0.9):
        return self.__boundaryOpacity
    def boundaryOpacity_changed(self, boundaryOpacity = 0.9):
        return self.__boundaryOpacity
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def opacityFactor(self):
        return self.__opacityFactor
    @opacityFactor.setter
    def opacityFactor(self, value = 2):
        if value == None or value  <  0:
            return None
        self.__opacityFactor = [value]
    def setOpacityFactor(self, opacityFactor = 2):
        if opacityFactor == None or opacityFactor  <  0:
            return None
        self.__opacityFactor = [opacityFactor]
        return self
    def addOpacityFactor(self, opacityFactor = 2):
        if opacityFactor == None or opacityFactor  <  0:
            return None
        if self.__opacityFactor == None:            self.__opacityFactor =  []
        self.__opacityFactor +=  [opacityFactor]
        return self
    def removeOpacityFactor(self, opacityFactor):
        self.__opacityFactor = [x for x in self.__opacityFactor if x not in opacityFactor]
        return self.__opacityFactor
    def getOpacityFactor(self, opacityFactor = 2):
        return self.__opacityFactor
    def opacityFactor_changed(self, opacityFactor = 2):
        return self.__opacityFactor
    @property
    def retainedOpacity(self):
        return self.__retainedOpacity
    @retainedOpacity.setter
    def retainedOpacity(self, value = 0.2):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__retainedOpacity = [value]
    def setRetainedOpacity(self, retainedOpacity = 0.2):
        if retainedOpacity == None or retainedOpacity  <  0:
            return None
        if retainedOpacity == None or retainedOpacity  >  1:
            return None
        self.__retainedOpacity = [retainedOpacity]
        return self
    def addRetainedOpacity(self, retainedOpacity = 0.2):
        if retainedOpacity == None or retainedOpacity  <  0:
            return None
        if retainedOpacity == None or retainedOpacity  >  1:
            return None
        if self.__retainedOpacity == None:            self.__retainedOpacity =  []
        self.__retainedOpacity +=  [retainedOpacity]
        return self
    def removeRetainedOpacity(self, retainedOpacity):
        self.__retainedOpacity = [x for x in self.__retainedOpacity if x not in retainedOpacity]
        return self.__retainedOpacity
    def getRetainedOpacity(self, retainedOpacity = 0.2):
        return self.__retainedOpacity
    def retainedOpacity_changed(self, retainedOpacity = 0.2):
        return self.__retainedOpacity
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BoundaryEnhancementVolumeStyle'
        if self.__boundaryOpacity is not None:
            if isinstance(self.__boundaryOpacity, six.string_types):
                str += ' boundaryOpacity="'+self.__boundaryOpacity+'"'
            else:
                str += ' boundaryOpacity="'+self.__boundaryOpacity[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__opacityFactor is not None:
            if isinstance(self.__opacityFactor, six.string_types):
                str += ' opacityFactor="'+self.__opacityFactor+'"'
            else:
                str += ' opacityFactor="'+self.__opacityFactor[0]+'"'
        if self.__retainedOpacity is not None:
            if isinstance(self.__retainedOpacity, six.string_types):
                str += ' retainedOpacity="'+self.__retainedOpacity+'"'
            else:
                str += ' retainedOpacity="'+self.__retainedOpacity[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BoundaryEnhancementVolumeStyle>'
        return str


class BoundedPhysicsModel(X3DParticlePhysicsModelNode):
    def __init__(self, **kwargs):
        super(BoundedPhysicsModel, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        geometry  = kwargs.pop("geometry", None)
        self.__geometry = geometry
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def geometry(self):
        return self.__geometry
    @geometry.setter
    def geometry(self, value = None):
        self.__geometry = [value]
    def setGeometry(self, geometry = None):
        self.__geometry = [geometry]
        return self
    def addGeometry(self, geometry = None):
        if self.__geometry == None:            self.__geometry =  []
        self.__geometry +=  [geometry]
        return self
    def removeGeometry(self, geometry):
        self.__geometry = [x for x in self.__geometry if x not in geometry]
        return self.__geometry
    def getGeometry(self, geometry = None):
        return self.__geometry
    def geometry_changed(self, geometry = None):
        return self.__geometry
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<BoundedPhysicsModel'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<geometry'
        if self.__geometry is not None:
           for s in self.__geometry:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__geometry is not None:
           for s in self.__geometry:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</geometry>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</BoundedPhysicsModel>'
        return str


class Box(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Box, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        size  = kwargs.pop("size", [2, 2, 2])
        self.__size = size
        solid  = kwargs.pop("solid", True)
        self.__solid = solid
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Box'
        if self.__size is not None:
            if isinstance(self.__size, six.string_types):
                str += ' size="'+self.__size+'"'
            else:
                str += ' size="'+self.__size[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Box>'
        return str


class CADAssembly(X3DProductStructureChildNode, X3DGroupingNode):
    def __init__(self, **kwargs):
        super(CADAssembly, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CADAssembly'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</CADAssembly>'
        return str


class CADFace(X3DBoundedObject, X3DProductStructureChildNode):
    def __init__(self, **kwargs):
        super(CADFace, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        shape  = kwargs.pop("shape", None)
        self.__shape = shape
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def shape(self):
        return self.__shape
    @shape.setter
    def shape(self, value = None):
        self.__shape = [value]
    def setShape(self, shape = None):
        self.__shape = [shape]
        return self
    def addShape(self, shape = None):
        if self.__shape == None:            self.__shape =  []
        self.__shape +=  [shape]
        return self
    def removeShape(self, shape):
        self.__shape = [x for x in self.__shape if x not in shape]
        return self.__shape
    def getShape(self, shape = None):
        return self.__shape
    def shape_changed(self, shape = None):
        return self.__shape
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CADFace'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<shape'
        if self.__shape is not None:
           for s in self.__shape:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__shape is not None:
           for s in self.__shape:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</shape>'
        str += '</CADFace>'
        return str


class CADLayer(X3DGroupingNode):
    def __init__(self, **kwargs):
        super(CADLayer, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        visible  = kwargs.pop("visible", None)
        self.__visible = visible
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def visible(self):
        return self.__visible
    @visible.setter
    def visible(self, value = None):
        self.__visible = [value]
    def setVisible(self, visible = None):
        self.__visible = [visible]
        return self
    def addVisible(self, visible = None):
        if self.__visible == None:            self.__visible =  []
        self.__visible +=  [visible]
        return self
    def removeVisible(self, visible):
        self.__visible = [x for x in self.__visible if x not in visible]
        return self.__visible
    def getVisible(self, visible = None):
        return self.__visible
    def visible_changed(self, visible = None):
        return self.__visible
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CADLayer'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__visible is not None:
            if isinstance(self.__visible, six.string_types):
                str += ' visible="'+self.__visible+'"'
            else:
                str += ' visible="'+self.__visible[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</CADLayer>'
        return str


class CADPart(X3DGroupingNode, X3DProductStructureChildNode):
    def __init__(self, **kwargs):
        super(CADPart, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        center  = kwargs.pop("center", [0, 0, 0])
        self.__center = center
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        name  = kwargs.pop("name", None)
        self.__name = name
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        rotation  = kwargs.pop("rotation", [0, 0, 1, 0])
        self.__rotation = rotation
        scale  = kwargs.pop("scale", [1, 1, 1])
        self.__scale = scale
        scaleOrientation  = kwargs.pop("scaleOrientation", [0, 0, 1, 0])
        self.__scaleOrientation = scaleOrientation
        translation  = kwargs.pop("translation", [0, 0, 0])
        self.__translation = translation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def center(self):
        return self.__center
    @center.setter
    def center(self, value = [0, 0, 0]):
        self.__center = [value]
    def setCenter(self, center = [0, 0, 0]):
        self.__center = [center]
        return self
    def addCenter(self, center = [0, 0, 0]):
        if self.__center == None:            self.__center =  []
        self.__center +=  [center]
        return self
    def removeCenter(self, center):
        self.__center = [x for x in self.__center if x not in center]
        return self.__center
    def getCenter(self, center = [0, 0, 0]):
        return self.__center
    def center_changed(self, center = [0, 0, 0]):
        return self.__center
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def name(self):
        return self.__name
    @name.setter
    def name(self, value = None):
        self.__name = [value]
    def setName(self, name = None):
        self.__name = [name]
        return self
    def addName(self, name = None):
        if self.__name == None:            self.__name =  []
        self.__name +=  [name]
        return self
    def removeName(self, name):
        self.__name = [x for x in self.__name if x not in name]
        return self.__name
    def getName(self, name = None):
        return self.__name
    def name_changed(self, name = None):
        return self.__name
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def rotation(self):
        return self.__rotation
    @rotation.setter
    def rotation(self, value = [0, 0, 1, 0]):
        self.__rotation = [value]
    def setRotation(self, rotation = [0, 0, 1, 0]):
        self.__rotation = [rotation]
        return self
    def addRotation(self, rotation = [0, 0, 1, 0]):
        if self.__rotation == None:            self.__rotation =  []
        self.__rotation +=  [rotation]
        return self
    def removeRotation(self, rotation):
        self.__rotation = [x for x in self.__rotation if x not in rotation]
        return self.__rotation
    def getRotation(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    def rotation_changed(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    @property
    def scale(self):
        return self.__scale
    @scale.setter
    def scale(self, value = [1, 1, 1]):
        self.__scale = [value]
    def setScale(self, scale = [1, 1, 1]):
        self.__scale = [scale]
        return self
    def addScale(self, scale = [1, 1, 1]):
        if self.__scale == None:            self.__scale =  []
        self.__scale +=  [scale]
        return self
    def removeScale(self, scale):
        self.__scale = [x for x in self.__scale if x not in scale]
        return self.__scale
    def getScale(self, scale = [1, 1, 1]):
        return self.__scale
    def scale_changed(self, scale = [1, 1, 1]):
        return self.__scale
    @property
    def scaleOrientation(self):
        return self.__scaleOrientation
    @scaleOrientation.setter
    def scaleOrientation(self, value = [0, 0, 1, 0]):
        self.__scaleOrientation = [value]
    def setScaleOrientation(self, scaleOrientation = [0, 0, 1, 0]):
        self.__scaleOrientation = [scaleOrientation]
        return self
    def addScaleOrientation(self, scaleOrientation = [0, 0, 1, 0]):
        if self.__scaleOrientation == None:            self.__scaleOrientation =  []
        self.__scaleOrientation +=  [scaleOrientation]
        return self
    def removeScaleOrientation(self, scaleOrientation):
        self.__scaleOrientation = [x for x in self.__scaleOrientation if x not in scaleOrientation]
        return self.__scaleOrientation
    def getScaleOrientation(self, scaleOrientation = [0, 0, 1, 0]):
        return self.__scaleOrientation
    def scaleOrientation_changed(self, scaleOrientation = [0, 0, 1, 0]):
        return self.__scaleOrientation
    @property
    def translation(self):
        return self.__translation
    @translation.setter
    def translation(self, value = [0, 0, 0]):
        self.__translation = [value]
    def setTranslation(self, translation = [0, 0, 0]):
        self.__translation = [translation]
        return self
    def addTranslation(self, translation = [0, 0, 0]):
        if self.__translation == None:            self.__translation =  []
        self.__translation +=  [translation]
        return self
    def removeTranslation(self, translation):
        self.__translation = [x for x in self.__translation if x not in translation]
        return self.__translation
    def getTranslation(self, translation = [0, 0, 0]):
        return self.__translation
    def translation_changed(self, translation = [0, 0, 0]):
        return self.__translation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CADPart'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__center is not None:
            if isinstance(self.__center, six.string_types):
                str += ' center="'+self.__center+'"'
            else:
                str += ' center="'+self.__center[0]+'"'
        if self.__name is not None:
            if isinstance(self.__name, six.string_types):
                str += ' name="'+self.__name+'"'
            else:
                str += ' name="'+self.__name[0]+'"'
        if self.__rotation is not None:
            if isinstance(self.__rotation, six.string_types):
                str += ' rotation="'+self.__rotation+'"'
            else:
                str += ' rotation="'+self.__rotation[0]+'"'
        if self.__scale is not None:
            if isinstance(self.__scale, six.string_types):
                str += ' scale="'+self.__scale+'"'
            else:
                str += ' scale="'+self.__scale[0]+'"'
        if self.__scaleOrientation is not None:
            if isinstance(self.__scaleOrientation, six.string_types):
                str += ' scaleOrientation="'+self.__scaleOrientation+'"'
            else:
                str += ' scaleOrientation="'+self.__scaleOrientation[0]+'"'
        if self.__translation is not None:
            if isinstance(self.__translation, six.string_types):
                str += ' translation="'+self.__translation+'"'
            else:
                str += ' translation="'+self.__translation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</CADPart>'
        return str


class CartoonVolumeStyle(X3DComposableVolumeRenderStyleNode):
    def __init__(self, **kwargs):
        super(CartoonVolumeStyle, self).__init__(**kwargs)
        colorSteps  = kwargs.pop("colorSteps", 4)
        if colorSteps == None or colorSteps  <  1:
            return None
        if colorSteps == None or colorSteps  >  64:
            return None
        self.__colorSteps = colorSteps
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        orthogonalColor  = kwargs.pop("orthogonalColor", [1, 1, 1, 1])
        if orthogonalColor == None or orthogonalColor  <  0:
            return None
        if orthogonalColor == None or orthogonalColor  >  1:
            return None
        self.__orthogonalColor = orthogonalColor
        parallelColor  = kwargs.pop("parallelColor", [0, 0, 0, 1])
        if parallelColor == None or parallelColor  <  0:
            return None
        if parallelColor == None or parallelColor  >  1:
            return None
        self.__parallelColor = parallelColor
        surfaceNormals  = kwargs.pop("surfaceNormals", None)
        self.__surfaceNormals = surfaceNormals
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def colorSteps(self):
        return self.__colorSteps
    @colorSteps.setter
    def colorSteps(self, value = 4):
        if value == None or value  <  1:
            return None
        if value == None or value  >  64:
            return None
        self.__colorSteps = [value]
    def setColorSteps(self, colorSteps = 4):
        if colorSteps == None or colorSteps  <  1:
            return None
        if colorSteps == None or colorSteps  >  64:
            return None
        self.__colorSteps = [colorSteps]
        return self
    def addColorSteps(self, colorSteps = 4):
        if colorSteps == None or colorSteps  <  1:
            return None
        if colorSteps == None or colorSteps  >  64:
            return None
        if self.__colorSteps == None:            self.__colorSteps =  []
        self.__colorSteps +=  [colorSteps]
        return self
    def removeColorSteps(self, colorSteps):
        self.__colorSteps = [x for x in self.__colorSteps if x not in colorSteps]
        return self.__colorSteps
    def getColorSteps(self, colorSteps = 4):
        return self.__colorSteps
    def colorSteps_changed(self, colorSteps = 4):
        return self.__colorSteps
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def orthogonalColor(self):
        return self.__orthogonalColor
    @orthogonalColor.setter
    def orthogonalColor(self, value = [1, 1, 1, 1]):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__orthogonalColor = [value]
    def setOrthogonalColor(self, orthogonalColor = [1, 1, 1, 1]):
        if orthogonalColor == None or orthogonalColor  <  0:
            return None
        if orthogonalColor == None or orthogonalColor  >  1:
            return None
        self.__orthogonalColor = [orthogonalColor]
        return self
    def addOrthogonalColor(self, orthogonalColor = [1, 1, 1, 1]):
        if orthogonalColor == None or orthogonalColor  <  0:
            return None
        if orthogonalColor == None or orthogonalColor  >  1:
            return None
        if self.__orthogonalColor == None:            self.__orthogonalColor =  []
        self.__orthogonalColor +=  [orthogonalColor]
        return self
    def removeOrthogonalColor(self, orthogonalColor):
        self.__orthogonalColor = [x for x in self.__orthogonalColor if x not in orthogonalColor]
        return self.__orthogonalColor
    def getOrthogonalColor(self, orthogonalColor = [1, 1, 1, 1]):
        return self.__orthogonalColor
    def orthogonalColor_changed(self, orthogonalColor = [1, 1, 1, 1]):
        return self.__orthogonalColor
    @property
    def parallelColor(self):
        return self.__parallelColor
    @parallelColor.setter
    def parallelColor(self, value = [0, 0, 0, 1]):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__parallelColor = [value]
    def setParallelColor(self, parallelColor = [0, 0, 0, 1]):
        if parallelColor == None or parallelColor  <  0:
            return None
        if parallelColor == None or parallelColor  >  1:
            return None
        self.__parallelColor = [parallelColor]
        return self
    def addParallelColor(self, parallelColor = [0, 0, 0, 1]):
        if parallelColor == None or parallelColor  <  0:
            return None
        if parallelColor == None or parallelColor  >  1:
            return None
        if self.__parallelColor == None:            self.__parallelColor =  []
        self.__parallelColor +=  [parallelColor]
        return self
    def removeParallelColor(self, parallelColor):
        self.__parallelColor = [x for x in self.__parallelColor if x not in parallelColor]
        return self.__parallelColor
    def getParallelColor(self, parallelColor = [0, 0, 0, 1]):
        return self.__parallelColor
    def parallelColor_changed(self, parallelColor = [0, 0, 0, 1]):
        return self.__parallelColor
    @property
    def surfaceNormals(self):
        return self.__surfaceNormals
    @surfaceNormals.setter
    def surfaceNormals(self, value = None):
        self.__surfaceNormals = [value]
    def setSurfaceNormals(self, surfaceNormals = None):
        self.__surfaceNormals = [surfaceNormals]
        return self
    def addSurfaceNormals(self, surfaceNormals = None):
        if self.__surfaceNormals == None:            self.__surfaceNormals =  []
        self.__surfaceNormals +=  [surfaceNormals]
        return self
    def removeSurfaceNormals(self, surfaceNormals):
        self.__surfaceNormals = [x for x in self.__surfaceNormals if x not in surfaceNormals]
        return self.__surfaceNormals
    def getSurfaceNormals(self, surfaceNormals = None):
        return self.__surfaceNormals
    def surfaceNormals_changed(self, surfaceNormals = None):
        return self.__surfaceNormals
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CartoonVolumeStyle'
        if self.__colorSteps is not None:
            if isinstance(self.__colorSteps, six.string_types):
                str += ' colorSteps="'+self.__colorSteps+'"'
            else:
                str += ' colorSteps="'+self.__colorSteps[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__orthogonalColor is not None:
            if isinstance(self.__orthogonalColor, six.string_types):
                str += ' orthogonalColor="'+self.__orthogonalColor+'"'
            else:
                str += ' orthogonalColor="'+self.__orthogonalColor[0]+'"'
        if self.__parallelColor is not None:
            if isinstance(self.__parallelColor, six.string_types):
                str += ' parallelColor="'+self.__parallelColor+'"'
            else:
                str += ' parallelColor="'+self.__parallelColor[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<surfaceNormals'
        if self.__surfaceNormals is not None:
           for s in self.__surfaceNormals:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__surfaceNormals is not None:
           for s in self.__surfaceNormals:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</surfaceNormals>'
        str += '</CartoonVolumeStyle>'
        return str


class Circle2D(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Circle2D, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        radius  = kwargs.pop("radius", 1)
        if radius == None or radius  <=  0:
            return None
        self.__radius = radius
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Circle2D'
        if self.__radius is not None:
            if isinstance(self.__radius, six.string_types):
                str += ' radius="'+self.__radius+'"'
            else:
                str += ' radius="'+self.__radius[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Circle2D>'
        return str


class ClipPlane(X3DChildNode):
    def __init__(self, **kwargs):
        super(ClipPlane, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        plane  = kwargs.pop("plane", [0, 1, 0, 0])
        if plane == None or plane  <  -1:
            return None
        if plane == None or plane  >  1:
            return None
        self.__plane = plane
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def plane(self):
        return self.__plane
    @plane.setter
    def plane(self, value = [0, 1, 0, 0]):
        if value == None or value  <  -1:
            return None
        if value == None or value  >  1:
            return None
        self.__plane = [value]
    def setPlane(self, plane = [0, 1, 0, 0]):
        if plane == None or plane  <  -1:
            return None
        if plane == None or plane  >  1:
            return None
        self.__plane = [plane]
        return self
    def addPlane(self, plane = [0, 1, 0, 0]):
        if plane == None or plane  <  -1:
            return None
        if plane == None or plane  >  1:
            return None
        if self.__plane == None:            self.__plane =  []
        self.__plane +=  [plane]
        return self
    def removePlane(self, plane):
        self.__plane = [x for x in self.__plane if x not in plane]
        return self.__plane
    def getPlane(self, plane = [0, 1, 0, 0]):
        return self.__plane
    def plane_changed(self, plane = [0, 1, 0, 0]):
        return self.__plane
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ClipPlane'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__plane is not None:
            if isinstance(self.__plane, six.string_types):
                str += ' plane="'+self.__plane+'"'
            else:
                str += ' plane="'+self.__plane[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ClipPlane>'
        return str


class CollidableOffset(X3DNBodyCollidableNode):
    def __init__(self, **kwargs):
        super(CollidableOffset, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        collidable  = kwargs.pop("collidable", None)
        self.__collidable = collidable
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        rotation  = kwargs.pop("rotation", [0, 0, 1, 0])
        self.__rotation = rotation
        translation  = kwargs.pop("translation", [0, 0, 0])
        self.__translation = translation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def rotation(self):
        return self.__rotation
    @rotation.setter
    def rotation(self, value = [0, 0, 1, 0]):
        self.__rotation = [value]
    def setRotation(self, rotation = [0, 0, 1, 0]):
        self.__rotation = [rotation]
        return self
    def addRotation(self, rotation = [0, 0, 1, 0]):
        if self.__rotation == None:            self.__rotation =  []
        self.__rotation +=  [rotation]
        return self
    def removeRotation(self, rotation):
        self.__rotation = [x for x in self.__rotation if x not in rotation]
        return self.__rotation
    def getRotation(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    def rotation_changed(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    @property
    def translation(self):
        return self.__translation
    @translation.setter
    def translation(self, value = [0, 0, 0]):
        self.__translation = [value]
    def setTranslation(self, translation = [0, 0, 0]):
        self.__translation = [translation]
        return self
    def addTranslation(self, translation = [0, 0, 0]):
        if self.__translation == None:            self.__translation =  []
        self.__translation +=  [translation]
        return self
    def removeTranslation(self, translation):
        self.__translation = [x for x in self.__translation if x not in translation]
        return self.__translation
    def getTranslation(self, translation = [0, 0, 0]):
        return self.__translation
    def translation_changed(self, translation = [0, 0, 0]):
        return self.__translation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CollidableOffset'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__rotation is not None:
            if isinstance(self.__rotation, six.string_types):
                str += ' rotation="'+self.__rotation+'"'
            else:
                str += ' rotation="'+self.__rotation[0]+'"'
        if self.__translation is not None:
            if isinstance(self.__translation, six.string_types):
                str += ' translation="'+self.__translation+'"'
            else:
                str += ' translation="'+self.__translation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<collidable'
        if self.__collidable is not None:
           for s in self.__collidable:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__collidable is not None:
           for s in self.__collidable:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</collidable>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CollidableOffset>'
        return str


class CollidableShape(X3DNBodyCollidableNode):
    def __init__(self, **kwargs):
        super(CollidableShape, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        rotation  = kwargs.pop("rotation", [0, 0, 1, 0])
        self.__rotation = rotation
        shape  = kwargs.pop("shape", None)
        self.__shape = shape
        translation  = kwargs.pop("translation", [0, 0, 0])
        self.__translation = translation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def rotation(self):
        return self.__rotation
    @rotation.setter
    def rotation(self, value = [0, 0, 1, 0]):
        self.__rotation = [value]
    def setRotation(self, rotation = [0, 0, 1, 0]):
        self.__rotation = [rotation]
        return self
    def addRotation(self, rotation = [0, 0, 1, 0]):
        if self.__rotation == None:            self.__rotation =  []
        self.__rotation +=  [rotation]
        return self
    def removeRotation(self, rotation):
        self.__rotation = [x for x in self.__rotation if x not in rotation]
        return self.__rotation
    def getRotation(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    def rotation_changed(self, rotation = [0, 0, 1, 0]):
        return self.__rotation
    @property
    def translation(self):
        return self.__translation
    @translation.setter
    def translation(self, value = [0, 0, 0]):
        self.__translation = [value]
    def setTranslation(self, translation = [0, 0, 0]):
        self.__translation = [translation]
        return self
    def addTranslation(self, translation = [0, 0, 0]):
        if self.__translation == None:            self.__translation =  []
        self.__translation +=  [translation]
        return self
    def removeTranslation(self, translation):
        self.__translation = [x for x in self.__translation if x not in translation]
        return self.__translation
    def getTranslation(self, translation = [0, 0, 0]):
        return self.__translation
    def translation_changed(self, translation = [0, 0, 0]):
        return self.__translation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CollidableShape'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__rotation is not None:
            if isinstance(self.__rotation, six.string_types):
                str += ' rotation="'+self.__rotation+'"'
            else:
                str += ' rotation="'+self.__rotation[0]+'"'
        if self.__translation is not None:
            if isinstance(self.__translation, six.string_types):
                str += ' translation="'+self.__translation+'"'
            else:
                str += ' translation="'+self.__translation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<shape'
        if self.__shape is not None:
           for s in self.__shape:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__shape is not None:
           for s in self.__shape:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</shape>'
        str += '</CollidableShape>'
        return str


class Collision(X3DSensorNode, X3DGroupingNode):
    def __init__(self, **kwargs):
        super(Collision, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        children  = kwargs.pop("children", None)
        self.__children = children
        collideTime  = kwargs.pop("collideTime", None)
        self.__collideTime = collideTime
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        proxy  = kwargs.pop("proxy", None)
        self.__proxy = proxy
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    def removeCollideTime(self, collideTime):
        self.__collideTime = [x for x in self.__collideTime if x not in collideTime]
        return self.__collideTime
    def getCollideTime(self, collideTime = None):
        return self.__collideTime
    def collideTime_changed(self, collideTime = None):
        return self.__collideTime
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    @property
    def proxy(self):
        return self.__proxy
    @proxy.setter
    def proxy(self, value = None):
        self.__proxy = [value]
    def setProxy(self, proxy = None):
        self.__proxy = [proxy]
        return self
    def addProxy(self, proxy = None):
        if self.__proxy == None:            self.__proxy =  []
        self.__proxy +=  [proxy]
        return self
    def toXML(self):
        str = ''
        str += '<Collision'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__collideTime is not None:
            if isinstance(self.__collideTime, six.string_types):
                str += ' collideTime="'+self.__collideTime+'"'
            else:
                str += ' collideTime="'+self.__collideTime[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<proxy'
        if self.__proxy is not None:
           for s in self.__proxy:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__proxy is not None:
           for s in self.__proxy:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</proxy>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</Collision>'
        return str


class CollisionCollection(X3DNode):
    def __init__(self, **kwargs):
        super(CollisionCollection, self).__init__(**kwargs)
        appliedParameters  = kwargs.pop("appliedParameters", ["BOUNCE"])
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        self.__appliedParameters = appliedParameters
        bounce  = kwargs.pop("bounce", 0)
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        self.__bounce = bounce
        collidables  = kwargs.pop("collidables", None)
        self.__collidables = collidables
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        frictionCoefficients  = kwargs.pop("frictionCoefficients", [0, 0])
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        self.__frictionCoefficients = frictionCoefficients
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        minBounceSpeed  = kwargs.pop("minBounceSpeed", 0.1)
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        self.__minBounceSpeed = minBounceSpeed
        slipFactors  = kwargs.pop("slipFactors", [0, 0])
        self.__slipFactors = slipFactors
        softnessConstantForceMix  = kwargs.pop("softnessConstantForceMix", 0.0001)
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        self.__softnessConstantForceMix = softnessConstantForceMix
        softnessErrorCorrection  = kwargs.pop("softnessErrorCorrection", 0.8)
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        self.__softnessErrorCorrection = softnessErrorCorrection
        surfaceSpeed  = kwargs.pop("surfaceSpeed", [0, 0])
        self.__surfaceSpeed = surfaceSpeed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def appliedParameters(self):
        return self.__appliedParameters
    @appliedParameters.setter
    def appliedParameters(self, value = ["BOUNCE"]):
        if '"BOUNCE"' == value:
            pass
        elif '"USER_FRICTION"' == value:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == value:
            pass
        elif '"ERROR_REDUCTION"' == value:
            pass
        elif '"CONSTANT_FORCE"' == value:
            pass
        elif '"SPEED-1"' == value:
            pass
        elif '"SPEED-2"' == value:
            pass
        elif '"SLIP-1"' == value:
            pass
        elif '"SLIP-2"' == value:
            pass
        else:
            return None
        self.__appliedParameters = [value]
    def setAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        self.__appliedParameters = [appliedParameters]
        return self
    def addAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        if self.__appliedParameters == None:            self.__appliedParameters =  []
        self.__appliedParameters +=  [appliedParameters]
        return self
    def removeAppliedParameters(self, appliedParameters):
        self.__appliedParameters = [x for x in self.__appliedParameters if x not in appliedParameters]
        return self.__appliedParameters
    def getAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        return self.__appliedParameters
    def appliedParameters_changed(self, appliedParameters = ["BOUNCE"]):
        return self.__appliedParameters
    @property
    def bounce(self):
        return self.__bounce
    @bounce.setter
    def bounce(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__bounce = [value]
    def setBounce(self, bounce = 0):
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        self.__bounce = [bounce]
        return self
    def addBounce(self, bounce = 0):
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        if self.__bounce == None:            self.__bounce =  []
        self.__bounce +=  [bounce]
        return self
    def removeBounce(self, bounce):
        self.__bounce = [x for x in self.__bounce if x not in bounce]
        return self.__bounce
    def getBounce(self, bounce = 0):
        return self.__bounce
    def bounce_changed(self, bounce = 0):
        return self.__bounce
    @property
    def collidables(self):
        return self.__collidables
    @collidables.setter
    def collidables(self, value = None):
        self.__collidables = [value]
    def setCollidables(self, collidables = None):
        self.__collidables = [collidables]
        return self
    def addCollidables(self, collidables = None):
        if self.__collidables == None:            self.__collidables =  []
        self.__collidables +=  [collidables]
        return self
    def removeCollidables(self, collidables):
        self.__collidables = [x for x in self.__collidables if x not in collidables]
        return self.__collidables
    def getCollidables(self, collidables = None):
        return self.__collidables
    def collidables_changed(self, collidables = None):
        return self.__collidables
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def frictionCoefficients(self):
        return self.__frictionCoefficients
    @frictionCoefficients.setter
    def frictionCoefficients(self, value = [0, 0]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        self.__frictionCoefficients = [value]
    def setFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        self.__frictionCoefficients = [frictionCoefficients]
        return self
    def addFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        if self.__frictionCoefficients == None:            self.__frictionCoefficients =  []
        self.__frictionCoefficients +=  [frictionCoefficients]
        return self
    def removeFrictionCoefficients(self, frictionCoefficients):
        self.__frictionCoefficients = [x for x in self.__frictionCoefficients if x not in frictionCoefficients]
        return self.__frictionCoefficients
    def getFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        return self.__frictionCoefficients
    def frictionCoefficients_changed(self, frictionCoefficients = [0, 0]):
        return self.__frictionCoefficients
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def minBounceSpeed(self):
        return self.__minBounceSpeed
    @minBounceSpeed.setter
    def minBounceSpeed(self, value = 0.1):
        if value == None or value  <  0:
            return None
        self.__minBounceSpeed = [value]
    def setMinBounceSpeed(self, minBounceSpeed = 0.1):
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        self.__minBounceSpeed = [minBounceSpeed]
        return self
    def addMinBounceSpeed(self, minBounceSpeed = 0.1):
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        if self.__minBounceSpeed == None:            self.__minBounceSpeed =  []
        self.__minBounceSpeed +=  [minBounceSpeed]
        return self
    def removeMinBounceSpeed(self, minBounceSpeed):
        self.__minBounceSpeed = [x for x in self.__minBounceSpeed if x not in minBounceSpeed]
        return self.__minBounceSpeed
    def getMinBounceSpeed(self, minBounceSpeed = 0.1):
        return self.__minBounceSpeed
    def minBounceSpeed_changed(self, minBounceSpeed = 0.1):
        return self.__minBounceSpeed
    @property
    def slipFactors(self):
        return self.__slipFactors
    @slipFactors.setter
    def slipFactors(self, value = [0, 0]):
        self.__slipFactors = [value]
    def setSlipFactors(self, slipFactors = [0, 0]):
        self.__slipFactors = [slipFactors]
        return self
    def addSlipFactors(self, slipFactors = [0, 0]):
        if self.__slipFactors == None:            self.__slipFactors =  []
        self.__slipFactors +=  [slipFactors]
        return self
    def removeSlipFactors(self, slipFactors):
        self.__slipFactors = [x for x in self.__slipFactors if x not in slipFactors]
        return self.__slipFactors
    def getSlipFactors(self, slipFactors = [0, 0]):
        return self.__slipFactors
    def slipFactors_changed(self, slipFactors = [0, 0]):
        return self.__slipFactors
    @property
    def softnessConstantForceMix(self):
        return self.__softnessConstantForceMix
    @softnessConstantForceMix.setter
    def softnessConstantForceMix(self, value = 0.0001):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__softnessConstantForceMix = [value]
    def setSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        self.__softnessConstantForceMix = [softnessConstantForceMix]
        return self
    def addSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        if self.__softnessConstantForceMix == None:            self.__softnessConstantForceMix =  []
        self.__softnessConstantForceMix +=  [softnessConstantForceMix]
        return self
    def removeSoftnessConstantForceMix(self, softnessConstantForceMix):
        self.__softnessConstantForceMix = [x for x in self.__softnessConstantForceMix if x not in softnessConstantForceMix]
        return self.__softnessConstantForceMix
    def getSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        return self.__softnessConstantForceMix
    def softnessConstantForceMix_changed(self, softnessConstantForceMix = 0.0001):
        return self.__softnessConstantForceMix
    @property
    def softnessErrorCorrection(self):
        return self.__softnessErrorCorrection
    @softnessErrorCorrection.setter
    def softnessErrorCorrection(self, value = 0.8):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__softnessErrorCorrection = [value]
    def setSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        self.__softnessErrorCorrection = [softnessErrorCorrection]
        return self
    def addSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        if self.__softnessErrorCorrection == None:            self.__softnessErrorCorrection =  []
        self.__softnessErrorCorrection +=  [softnessErrorCorrection]
        return self
    def removeSoftnessErrorCorrection(self, softnessErrorCorrection):
        self.__softnessErrorCorrection = [x for x in self.__softnessErrorCorrection if x not in softnessErrorCorrection]
        return self.__softnessErrorCorrection
    def getSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        return self.__softnessErrorCorrection
    def softnessErrorCorrection_changed(self, softnessErrorCorrection = 0.8):
        return self.__softnessErrorCorrection
    @property
    def surfaceSpeed(self):
        return self.__surfaceSpeed
    @surfaceSpeed.setter
    def surfaceSpeed(self, value = [0, 0]):
        self.__surfaceSpeed = [value]
    def setSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        self.__surfaceSpeed = [surfaceSpeed]
        return self
    def addSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        if self.__surfaceSpeed == None:            self.__surfaceSpeed =  []
        self.__surfaceSpeed +=  [surfaceSpeed]
        return self
    def removeSurfaceSpeed(self, surfaceSpeed):
        self.__surfaceSpeed = [x for x in self.__surfaceSpeed if x not in surfaceSpeed]
        return self.__surfaceSpeed
    def getSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        return self.__surfaceSpeed
    def surfaceSpeed_changed(self, surfaceSpeed = [0, 0]):
        return self.__surfaceSpeed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CollisionCollection'
        if self.__appliedParameters is not None:
            if isinstance(self.__appliedParameters, six.string_types):
                str += ' appliedParameters="'+self.__appliedParameters+'"'
            else:
                str += ' appliedParameters="'+self.__appliedParameters[0]+'"'
        if self.__bounce is not None:
            if isinstance(self.__bounce, six.string_types):
                str += ' bounce="'+self.__bounce+'"'
            else:
                str += ' bounce="'+self.__bounce[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__frictionCoefficients is not None:
            if isinstance(self.__frictionCoefficients, six.string_types):
                str += ' frictionCoefficients="'+self.__frictionCoefficients+'"'
            else:
                str += ' frictionCoefficients="'+self.__frictionCoefficients[0]+'"'
        if self.__minBounceSpeed is not None:
            if isinstance(self.__minBounceSpeed, six.string_types):
                str += ' minBounceSpeed="'+self.__minBounceSpeed+'"'
            else:
                str += ' minBounceSpeed="'+self.__minBounceSpeed[0]+'"'
        if self.__slipFactors is not None:
            if isinstance(self.__slipFactors, six.string_types):
                str += ' slipFactors="'+self.__slipFactors+'"'
            else:
                str += ' slipFactors="'+self.__slipFactors[0]+'"'
        if self.__softnessConstantForceMix is not None:
            if isinstance(self.__softnessConstantForceMix, six.string_types):
                str += ' softnessConstantForceMix="'+self.__softnessConstantForceMix+'"'
            else:
                str += ' softnessConstantForceMix="'+self.__softnessConstantForceMix[0]+'"'
        if self.__softnessErrorCorrection is not None:
            if isinstance(self.__softnessErrorCorrection, six.string_types):
                str += ' softnessErrorCorrection="'+self.__softnessErrorCorrection+'"'
            else:
                str += ' softnessErrorCorrection="'+self.__softnessErrorCorrection[0]+'"'
        if self.__surfaceSpeed is not None:
            if isinstance(self.__surfaceSpeed, six.string_types):
                str += ' surfaceSpeed="'+self.__surfaceSpeed+'"'
            else:
                str += ' surfaceSpeed="'+self.__surfaceSpeed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<collidables'
        if self.__collidables is not None:
           for s in self.__collidables:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__collidables is not None:
           for s in self.__collidables:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</collidables>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CollisionCollection>'
        return str


class CollisionSensor(X3DSensorNode):
    def __init__(self, **kwargs):
        super(CollisionSensor, self).__init__(**kwargs)
        collider  = kwargs.pop("collider", None)
        self.__collider = collider
        contacts  = kwargs.pop("contacts", None)
        self.__contacts = contacts
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        intersections  = kwargs.pop("intersections", None)
        self.__intersections = intersections
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def collider(self):
        return self.__collider
    @collider.setter
    def collider(self, value = None):
        self.__collider = [value]
    def setCollider(self, collider = None):
        self.__collider = [collider]
        return self
    def addCollider(self, collider = None):
        if self.__collider == None:            self.__collider =  []
        self.__collider +=  [collider]
        return self
    def removeCollider(self, collider):
        self.__collider = [x for x in self.__collider if x not in collider]
        return self.__collider
    def getCollider(self, collider = None):
        return self.__collider
    def collider_changed(self, collider = None):
        return self.__collider
    def removeContacts(self, contacts):
        self.__contacts = [x for x in self.__contacts if x not in contacts]
        return self.__contacts
    def getContacts(self, contacts = None):
        return self.__contacts
    def contacts_changed(self, contacts = None):
        return self.__contacts
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def removeIntersections(self, intersections):
        self.__intersections = [x for x in self.__intersections if x not in intersections]
        return self.__intersections
    def getIntersections(self, intersections = None):
        return self.__intersections
    def intersections_changed(self, intersections = None):
        return self.__intersections
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CollisionSensor'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<collider'
        if self.__collider is not None:
           for s in self.__collider:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__collider is not None:
           for s in self.__collider:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</collider>'
        str += '<contacts'
        if self.__contacts is not None:
           for s in self.__contacts:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__contacts is not None:
           for s in self.__contacts:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</contacts>'
        str += '<intersections'
        if self.__intersections is not None:
           for s in self.__intersections:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__intersections is not None:
           for s in self.__intersections:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</intersections>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CollisionSensor>'
        return str


class CollisionSpace(X3DNBodyCollisionSpaceNode):
    def __init__(self, **kwargs):
        super(CollisionSpace, self).__init__(**kwargs)
        bboxCenter  = kwargs.pop("bboxCenter", [0, 0, 0])
        self.__bboxCenter = bboxCenter
        bboxSize  = kwargs.pop("bboxSize", [-1, -1, -1])
        self.__bboxSize = bboxSize
        collidables  = kwargs.pop("collidables", None)
        self.__collidables = collidables
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        useGeometry  = kwargs.pop("useGeometry", False)
        self.__useGeometry = useGeometry
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def collidables(self):
        return self.__collidables
    @collidables.setter
    def collidables(self, value = None):
        self.__collidables = [value]
    def setCollidables(self, collidables = None):
        self.__collidables = [collidables]
        return self
    def addCollidables(self, collidables = None):
        if self.__collidables == None:            self.__collidables =  []
        self.__collidables +=  [collidables]
        return self
    def removeCollidables(self, collidables):
        self.__collidables = [x for x in self.__collidables if x not in collidables]
        return self.__collidables
    def getCollidables(self, collidables = None):
        return self.__collidables
    def collidables_changed(self, collidables = None):
        return self.__collidables
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def useGeometry(self):
        return self.__useGeometry
    @useGeometry.setter
    def useGeometry(self, value = False):
        self.__useGeometry = [value]
    def setUseGeometry(self, useGeometry = False):
        self.__useGeometry = [useGeometry]
        return self
    def addUseGeometry(self, useGeometry = False):
        if self.__useGeometry == None:            self.__useGeometry =  []
        self.__useGeometry +=  [useGeometry]
        return self
    def removeUseGeometry(self, useGeometry):
        self.__useGeometry = [x for x in self.__useGeometry if x not in useGeometry]
        return self.__useGeometry
    def isUseGeometry(self, useGeometry = False):
        return self.__useGeometry
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CollisionSpace'
        if self.__bboxCenter is not None:
            if isinstance(self.__bboxCenter, six.string_types):
                str += ' bboxCenter="'+self.__bboxCenter+'"'
            else:
                str += ' bboxCenter="'+self.__bboxCenter[0]+'"'
        if self.__bboxSize is not None:
            if isinstance(self.__bboxSize, six.string_types):
                str += ' bboxSize="'+self.__bboxSize+'"'
            else:
                str += ' bboxSize="'+self.__bboxSize[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__useGeometry is not None:
            if isinstance(self.__useGeometry, six.string_types):
                str += ' useGeometry="'+self.__useGeometry+'"'
            else:
                str += ' useGeometry="'+self.__useGeometry[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<collidables'
        if self.__collidables is not None:
           for s in self.__collidables:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__collidables is not None:
           for s in self.__collidables:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</collidables>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CollisionSpace>'
        return str


class Color(X3DColorNode):
    def __init__(self, **kwargs):
        super(Color, self).__init__(**kwargs)
        color  = kwargs.pop("color", None)
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = color
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__color = [value]
    def setColor(self, color = None):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = [color]
        return self
    def addColor(self, color = None):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = None):
        return self.__color
    def color_changed(self, color = None):
        return self.__color
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Color'
        if self.__color is not None:
            if isinstance(self.__color, six.string_types):
                str += ' color="'+self.__color+'"'
            else:
                str += ' color="'+self.__color[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Color>'
        return str


class ColorChaser(X3DChaserNode):
    def __init__(self, **kwargs):
        super(ColorChaser, self).__init__(**kwargs)
        duration  = kwargs.pop("duration", 1)
        if duration == None or duration  <  0:
            return None
        self.__duration = duration
        initialDestination  = kwargs.pop("initialDestination", [0.8, 0.8, 0.8])
        if initialDestination == None or len(initialDestination) <= 0 or min(initialDestination)  <  0:
            return None
        if initialDestination == None or len(initialDestination) <= 0 or max(initialDestination)  >  1:
            return None
        self.__initialDestination = initialDestination
        initialValue  = kwargs.pop("initialValue", [0.8, 0.8, 0.8])
        if initialValue == None or len(initialValue) <= 0 or min(initialValue)  <  0:
            return None
        if initialValue == None or len(initialValue) <= 0 or max(initialValue)  >  1:
            return None
        self.__initialValue = initialValue
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        destination  = kwargs.pop("destination", None)
        if destination == None or len(destination) <= 0 or min(destination)  <  0:
            return None
        if destination == None or len(destination) <= 0 or max(destination)  >  1:
            return None
        self.__destination = destination
        value  = kwargs.pop("value", None)
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = value
        value_changed  = kwargs.pop("value_changed", None)
        if value_changed == None or len(value_changed) <= 0 or min(value_changed)  <  0:
            return None
        if value_changed == None or len(value_changed) <= 0 or max(value_changed)  >  1:
            return None
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def destination(self):
        return self.__destination
    @destination.setter
    def destination(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__destination = [value]
    def set_destination(self, destination = None):
        if destination == None or len(destination) <= 0 or min(destination)  <  0:
            return None
        if destination == None or len(destination) <= 0 or max(destination)  >  1:
            return None
        self.__destination = [destination]
        return self
    @property
    def value(self):
        return self.__value
    @value.setter
    def value(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = [value]
    def set_value(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = [value]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ColorChaser'
        if self.__duration is not None:
            if isinstance(self.__duration, six.string_types):
                str += ' duration="'+self.__duration+'"'
            else:
                str += ' duration="'+self.__duration[0]+'"'
        if self.__initialDestination is not None:
            if isinstance(self.__initialDestination, six.string_types):
                str += ' initialDestination="'+self.__initialDestination+'"'
            else:
                str += ' initialDestination="'+self.__initialDestination[0]+'"'
        if self.__initialValue is not None:
            if isinstance(self.__initialValue, six.string_types):
                str += ' initialValue="'+self.__initialValue+'"'
            else:
                str += ' initialValue="'+self.__initialValue[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__destination is not None:
            if isinstance(self.__destination, six.string_types):
                str += ' destination="'+self.__destination+'"'
            else:
                str += ' destination="'+self.__destination[0]+'"'
        if self.__value is not None:
            if isinstance(self.__value, six.string_types):
                str += ' value="'+self.__value+'"'
            else:
                str += ' value="'+self.__value[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ColorChaser>'
        return str


class ColorDamper(X3DDamperNode):
    def __init__(self, **kwargs):
        super(ColorDamper, self).__init__(**kwargs)
        initialDestination  = kwargs.pop("initialDestination", [0.8, 0.8, 0.8])
        if initialDestination == None or len(initialDestination) <= 0 or min(initialDestination)  <  0:
            return None
        if initialDestination == None or len(initialDestination) <= 0 or max(initialDestination)  >  1:
            return None
        self.__initialDestination = initialDestination
        initialValue  = kwargs.pop("initialValue", [0.8, 0.8, 0.8])
        if initialValue == None or len(initialValue) <= 0 or min(initialValue)  <  0:
            return None
        if initialValue == None or len(initialValue) <= 0 or max(initialValue)  >  1:
            return None
        self.__initialValue = initialValue
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        order  = kwargs.pop("order", 3)
        if order == None or order  <  0:
            return None
        if order == None or order  >  5:
            return None
        self.__order = order
        destination  = kwargs.pop("destination", None)
        if destination == None or len(destination) <= 0 or min(destination)  <  0:
            return None
        if destination == None or len(destination) <= 0 or max(destination)  >  1:
            return None
        self.__destination = destination
        value  = kwargs.pop("value", None)
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = value
        tau  = kwargs.pop("tau", 0.3)
        if tau == None or tau  <  0:
            return None
        self.__tau = tau
        tolerance  = kwargs.pop("tolerance", -1)
        self.__tolerance = tolerance
        value_changed  = kwargs.pop("value_changed", None)
        if value_changed == None or len(value_changed) <= 0 or min(value_changed)  <  0:
            return None
        if value_changed == None or len(value_changed) <= 0 or max(value_changed)  >  1:
            return None
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def destination(self):
        return self.__destination
    @destination.setter
    def destination(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__destination = [value]
    def set_destination(self, destination = None):
        if destination == None or len(destination) <= 0 or min(destination)  <  0:
            return None
        if destination == None or len(destination) <= 0 or max(destination)  >  1:
            return None
        self.__destination = [destination]
        return self
    @property
    def value(self):
        return self.__value
    @value.setter
    def value(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = [value]
    def set_value(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__value = [value]
        return self
    @property
    def tau(self):
        return self.__tau
    @tau.setter
    def tau(self, value = 0.3):
        if value == None or value  <  0:
            return None
        self.__tau = [value]
    def setTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        self.__tau = [tau]
        return self
    def addTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        if self.__tau == None:            self.__tau =  []
        self.__tau +=  [tau]
        return self
    def removeTau(self, tau):
        self.__tau = [x for x in self.__tau if x not in tau]
        return self.__tau
    def getTau(self, tau = 0.3):
        return self.__tau
    def tau_changed(self, tau = 0.3):
        return self.__tau
    @property
    def tolerance(self):
        return self.__tolerance
    @tolerance.setter
    def tolerance(self, value = -1):
        self.__tolerance = [value]
    def setTolerance(self, tolerance = -1):
        self.__tolerance = [tolerance]
        return self
    def addTolerance(self, tolerance = -1):
        if self.__tolerance == None:            self.__tolerance =  []
        self.__tolerance +=  [tolerance]
        return self
    def removeTolerance(self, tolerance):
        self.__tolerance = [x for x in self.__tolerance if x not in tolerance]
        return self.__tolerance
    def getTolerance(self, tolerance = -1):
        return self.__tolerance
    def tolerance_changed(self, tolerance = -1):
        return self.__tolerance
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ColorDamper'
        if self.__initialDestination is not None:
            if isinstance(self.__initialDestination, six.string_types):
                str += ' initialDestination="'+self.__initialDestination+'"'
            else:
                str += ' initialDestination="'+self.__initialDestination[0]+'"'
        if self.__initialValue is not None:
            if isinstance(self.__initialValue, six.string_types):
                str += ' initialValue="'+self.__initialValue+'"'
            else:
                str += ' initialValue="'+self.__initialValue[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__order is not None:
            if isinstance(self.__order, six.string_types):
                str += ' order="'+self.__order+'"'
            else:
                str += ' order="'+self.__order[0]+'"'
        if self.__destination is not None:
            if isinstance(self.__destination, six.string_types):
                str += ' destination="'+self.__destination+'"'
            else:
                str += ' destination="'+self.__destination[0]+'"'
        if self.__value is not None:
            if isinstance(self.__value, six.string_types):
                str += ' value="'+self.__value+'"'
            else:
                str += ' value="'+self.__value[0]+'"'
        if self.__tau is not None:
            if isinstance(self.__tau, six.string_types):
                str += ' tau="'+self.__tau+'"'
            else:
                str += ' tau="'+self.__tau[0]+'"'
        if self.__tolerance is not None:
            if isinstance(self.__tolerance, six.string_types):
                str += ' tolerance="'+self.__tolerance+'"'
            else:
                str += ' tolerance="'+self.__tolerance[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ColorDamper>'
        return str


class ColorInterpolator(X3DInterpolatorNode):
    def __init__(self, **kwargs):
        super(ColorInterpolator, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        keyValue  = kwargs.pop("keyValue", None)
        if keyValue == None or len(keyValue) <= 0 or min(keyValue)  <  0:
            return None
        if keyValue == None or len(keyValue) <= 0 or max(keyValue)  >  1:
            return None
        self.__keyValue = keyValue
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        value_changed  = kwargs.pop("value_changed", None)
        if value_changed == None or len(value_changed) <= 0 or min(value_changed)  <  0:
            return None
        if value_changed == None or len(value_changed) <= 0 or max(value_changed)  >  1:
            return None
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def keyValue(self):
        return self.__keyValue
    @keyValue.setter
    def keyValue(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__keyValue = [value]
    def setKeyValue(self, keyValue = None):
        if keyValue == None or len(keyValue) <= 0 or min(keyValue)  <  0:
            return None
        if keyValue == None or len(keyValue) <= 0 or max(keyValue)  >  1:
            return None
        self.__keyValue = [keyValue]
        return self
    def addKeyValue(self, keyValue = None):
        if keyValue == None or len(keyValue) <= 0 or min(keyValue)  <  0:
            return None
        if keyValue == None or len(keyValue) <= 0 or max(keyValue)  >  1:
            return None
        if self.__keyValue == None:            self.__keyValue =  []
        self.__keyValue +=  [keyValue]
        return self
    def removeKeyValue(self, keyValue):
        self.__keyValue = [x for x in self.__keyValue if x not in keyValue]
        return self.__keyValue
    def getKeyValue(self, keyValue = None):
        return self.__keyValue
    def keyValue_changed(self, keyValue = None):
        return self.__keyValue
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ColorInterpolator'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__keyValue is not None:
            if isinstance(self.__keyValue, six.string_types):
                str += ' keyValue="'+self.__keyValue+'"'
            else:
                str += ' keyValue="'+self.__keyValue[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ColorInterpolator>'
        return str


class ColorRGBA(X3DColorNode):
    def __init__(self, **kwargs):
        super(ColorRGBA, self).__init__(**kwargs)
        color  = kwargs.pop("color", None)
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = color
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = None):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__color = [value]
    def setColor(self, color = None):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = [color]
        return self
    def addColor(self, color = None):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = None):
        return self.__color
    def color_changed(self, color = None):
        return self.__color
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ColorRGBA'
        if self.__color is not None:
            if isinstance(self.__color, six.string_types):
                str += ' color="'+self.__color+'"'
            else:
                str += ' color="'+self.__color[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ColorRGBA>'
        return str


class ComposedCubeMapTexture(X3DEnvironmentTextureNode):
    def __init__(self, **kwargs):
        super(ComposedCubeMapTexture, self).__init__(**kwargs)
        back  = kwargs.pop("back", None)
        self.__back = back
        bottom  = kwargs.pop("bottom", None)
        self.__bottom = bottom
        front  = kwargs.pop("front", None)
        self.__front = front
        left  = kwargs.pop("left", None)
        self.__left = left
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        right  = kwargs.pop("right", None)
        self.__right = right
        top  = kwargs.pop("top", None)
        self.__top = top
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def back(self):
        return self.__back
    @back.setter
    def back(self, value = None):
        self.__back = [value]
    def setBack(self, back = None):
        self.__back = [back]
        return self
    def addBack(self, back = None):
        if self.__back == None:            self.__back =  []
        self.__back +=  [back]
        return self
    def removeBack(self, back):
        self.__back = [x for x in self.__back if x not in back]
        return self.__back
    def getBack(self, back = None):
        return self.__back
    def back_changed(self, back = None):
        return self.__back
    @property
    def bottom(self):
        return self.__bottom
    @bottom.setter
    def bottom(self, value = None):
        self.__bottom = [value]
    def setBottom(self, bottom = None):
        self.__bottom = [bottom]
        return self
    def addBottom(self, bottom = None):
        if self.__bottom == None:            self.__bottom =  []
        self.__bottom +=  [bottom]
        return self
    def removeBottom(self, bottom):
        self.__bottom = [x for x in self.__bottom if x not in bottom]
        return self.__bottom
    def getBottom(self, bottom = None):
        return self.__bottom
    def bottom_changed(self, bottom = None):
        return self.__bottom
    @property
    def front(self):
        return self.__front
    @front.setter
    def front(self, value = None):
        self.__front = [value]
    def setFront(self, front = None):
        self.__front = [front]
        return self
    def addFront(self, front = None):
        if self.__front == None:            self.__front =  []
        self.__front +=  [front]
        return self
    def removeFront(self, front):
        self.__front = [x for x in self.__front if x not in front]
        return self.__front
    def getFront(self, front = None):
        return self.__front
    def front_changed(self, front = None):
        return self.__front
    @property
    def left(self):
        return self.__left
    @left.setter
    def left(self, value = None):
        self.__left = [value]
    def setLeft(self, left = None):
        self.__left = [left]
        return self
    def addLeft(self, left = None):
        if self.__left == None:            self.__left =  []
        self.__left +=  [left]
        return self
    def removeLeft(self, left):
        self.__left = [x for x in self.__left if x not in left]
        return self.__left
    def getLeft(self, left = None):
        return self.__left
    def left_changed(self, left = None):
        return self.__left
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def right(self):
        return self.__right
    @right.setter
    def right(self, value = None):
        self.__right = [value]
    def setRight(self, right = None):
        self.__right = [right]
        return self
    def addRight(self, right = None):
        if self.__right == None:            self.__right =  []
        self.__right +=  [right]
        return self
    def removeRight(self, right):
        self.__right = [x for x in self.__right if x not in right]
        return self.__right
    def getRight(self, right = None):
        return self.__right
    def right_changed(self, right = None):
        return self.__right
    @property
    def top(self):
        return self.__top
    @top.setter
    def top(self, value = None):
        self.__top = [value]
    def setTop(self, top = None):
        self.__top = [top]
        return self
    def addTop(self, top = None):
        if self.__top == None:            self.__top =  []
        self.__top +=  [top]
        return self
    def removeTop(self, top):
        self.__top = [x for x in self.__top if x not in top]
        return self.__top
    def getTop(self, top = None):
        return self.__top
    def top_changed(self, top = None):
        return self.__top
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ComposedCubeMapTexture'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<back'
        if self.__back is not None:
           for s in self.__back:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__back is not None:
           for s in self.__back:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</back>'
        str += '<bottom'
        if self.__bottom is not None:
           for s in self.__bottom:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__bottom is not None:
           for s in self.__bottom:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</bottom>'
        str += '<front'
        if self.__front is not None:
           for s in self.__front:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__front is not None:
           for s in self.__front:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</front>'
        str += '<left'
        if self.__left is not None:
           for s in self.__left:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__left is not None:
           for s in self.__left:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</left>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<right'
        if self.__right is not None:
           for s in self.__right:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__right is not None:
           for s in self.__right:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</right>'
        str += '<top'
        if self.__top is not None:
           for s in self.__top:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__top is not None:
           for s in self.__top:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</top>'
        str += '</ComposedCubeMapTexture>'
        return str


class ComposedShader(X3DProgrammableShaderObject, X3DShaderNode):
    def __init__(self, **kwargs):
        super(ComposedShader, self).__init__(**kwargs)
        activate  = kwargs.pop("activate", None)
        self.__activate = activate
        Selected  = kwargs.pop("Selected", None)
        self.__Selected = Selected
        Valid  = kwargs.pop("Valid", None)
        self.__Valid = Valid
        language  = kwargs.pop("language", None)
        self.__language = language
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        parts  = kwargs.pop("parts", None)
        self.__parts = parts
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
        field  = kwargs.pop("field", None)
        self.__field = field
    @property
    def activate(self):
        return self.__activate
    @activate.setter
    def activate(self, value = None):
        self.__activate = [value]
    def setActivate(self, activate = None):
        self.__activate = [activate]
        return self
    def addActivate(self, activate = None):
        if self.__activate == None:            self.__activate =  []
        self.__activate +=  [activate]
        return self
    def isSelected(self, Selected = None):
        return self.__Selected
    def isValid(self, Valid = None):
        return self.__Valid
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def parts(self):
        return self.__parts
    @parts.setter
    def parts(self, value = None):
        self.__parts = [value]
    def setParts(self, parts = None):
        self.__parts = [parts]
        return self
    def addParts(self, parts = None):
        if self.__parts == None:            self.__parts =  []
        self.__parts +=  [parts]
        return self
    def removeParts(self, parts):
        self.__parts = [x for x in self.__parts if x not in parts]
        return self.__parts
    def getParts(self, parts = None):
        return self.__parts
    def parts_changed(self, parts = None):
        return self.__parts
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    @property
    def sourceCode(self):
        return self.__sourceCode
    @sourceCode.setter
    def sourceCode(self, value = None):
        self.__sourceCode = [value]
    def setSourceCode(self, sourceCode = None):
        self.__sourceCode = [sourceCode]
        return self
    def addSourceCode(self, sourceCode = None):
        if self.__sourceCode == None:            self.__sourceCode =  []
        self.__sourceCode +=  [sourceCode]
        return self
    @property
    def field(self):
        return self.__field
    @field.setter
    def field(self, value = None):
        self.__field = [value]
    def setField(self, field = None):
        self.__field = [field]
        return self
    def addField(self, field = None):
        if self.__field == None:            self.__field =  []
        self.__field +=  [field]
        return self
    def removeField(self, field):
        self.__field = [x for x in self.__field if x not in field]
        return self.__field
    def getField(self, field = None):
        return self.__field
    def field_changed(self, field = None):
        return self.__field
    def toXML(self):
        str = ''
        str += '<ComposedShader'
        if self.__activate is not None:
            if isinstance(self.__activate, six.string_types):
                str += ' activate="'+self.__activate+'"'
            else:
                str += ' activate="'+self.__activate[0]+'"'
        if self.__Selected is not None:
            if isinstance(self.__Selected, six.string_types):
                str += ' Selected="'+self.__Selected+'"'
            else:
                str += ' Selected="'+self.__Selected[0]+'"'
        if self.__Valid is not None:
            if isinstance(self.__Valid, six.string_types):
                str += ' Valid="'+self.__Valid+'"'
            else:
                str += ' Valid="'+self.__Valid[0]+'"'
        if self.__language is not None:
            if isinstance(self.__language, six.string_types):
                str += ' language="'+self.__language+'"'
            else:
                str += ' language="'+self.__language[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<parts'
        if self.__parts is not None:
           for s in self.__parts:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__parts is not None:
           for s in self.__parts:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</parts>'
        str += '</ComposedShader>'
        return str


class ComposedTexture3D(X3DTexture3DNode):
    def __init__(self, **kwargs):
        super(ComposedTexture3D, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        repeatR  = kwargs.pop("repeatR", False)
        self.__repeatR = repeatR
        repeatS  = kwargs.pop("repeatS", False)
        self.__repeatS = repeatS
        repeatT  = kwargs.pop("repeatT", False)
        self.__repeatT = repeatT
        texture  = kwargs.pop("texture", None)
        self.__texture = texture
        textureProperties  = kwargs.pop("textureProperties", None)
        self.__textureProperties = textureProperties
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def texture(self):
        return self.__texture
    @texture.setter
    def texture(self, value = None):
        self.__texture = [value]
    def setTexture(self, texture = None):
        self.__texture = [texture]
        return self
    def addTexture(self, texture = None):
        if self.__texture == None:            self.__texture =  []
        self.__texture +=  [texture]
        return self
    def removeTexture(self, texture):
        self.__texture = [x for x in self.__texture if x not in texture]
        return self.__texture
    def getTexture(self, texture = None):
        return self.__texture
    def texture_changed(self, texture = None):
        return self.__texture
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ComposedTexture3D'
        if self.__repeatR is not None:
            if isinstance(self.__repeatR, six.string_types):
                str += ' repeatR="'+self.__repeatR+'"'
            else:
                str += ' repeatR="'+self.__repeatR[0]+'"'
        if self.__repeatS is not None:
            if isinstance(self.__repeatS, six.string_types):
                str += ' repeatS="'+self.__repeatS+'"'
            else:
                str += ' repeatS="'+self.__repeatS[0]+'"'
        if self.__repeatT is not None:
            if isinstance(self.__repeatT, six.string_types):
                str += ' repeatT="'+self.__repeatT+'"'
            else:
                str += ' repeatT="'+self.__repeatT[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<texture'
        if self.__texture is not None:
           for s in self.__texture:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__texture is not None:
           for s in self.__texture:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</texture>'
        str += '<textureProperties'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__textureProperties is not None:
           for s in self.__textureProperties:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</textureProperties>'
        str += '</ComposedTexture3D>'
        return str


class ComposedVolumeStyle(X3DComposableVolumeRenderStyleNode):
    def __init__(self, **kwargs):
        super(ComposedVolumeStyle, self).__init__(**kwargs)
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        renderStyle  = kwargs.pop("renderStyle", None)
        self.__renderStyle = renderStyle
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def renderStyle(self):
        return self.__renderStyle
    @renderStyle.setter
    def renderStyle(self, value = None):
        self.__renderStyle = [value]
    def setRenderStyle(self, renderStyle = None):
        self.__renderStyle = [renderStyle]
        return self
    def addRenderStyle(self, renderStyle = None):
        if self.__renderStyle == None:            self.__renderStyle =  []
        self.__renderStyle +=  [renderStyle]
        return self
    def removeRenderStyle(self, renderStyle):
        self.__renderStyle = [x for x in self.__renderStyle if x not in renderStyle]
        return self.__renderStyle
    def getRenderStyle(self, renderStyle = None):
        return self.__renderStyle
    def renderStyle_changed(self, renderStyle = None):
        return self.__renderStyle
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ComposedVolumeStyle'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<renderStyle'
        if self.__renderStyle is not None:
           for s in self.__renderStyle:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__renderStyle is not None:
           for s in self.__renderStyle:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</renderStyle>'
        str += '</ComposedVolumeStyle>'
        return str


class Cone(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Cone, self).__init__(**kwargs)
        bottom  = kwargs.pop("bottom", True)
        self.__bottom = bottom
        bottomRadius  = kwargs.pop("bottomRadius", 1)
        if bottomRadius == None or bottomRadius  <=  0:
            return None
        self.__bottomRadius = bottomRadius
        height  = kwargs.pop("height", 2)
        if height == None or height  <=  0:
            return None
        self.__height = height
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        side  = kwargs.pop("side", True)
        self.__side = side
        solid  = kwargs.pop("solid", True)
        self.__solid = solid
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Cone'
        if self.__bottom is not None:
            if isinstance(self.__bottom, six.string_types):
                str += ' bottom="'+self.__bottom+'"'
            else:
                str += ' bottom="'+self.__bottom[0]+'"'
        if self.__bottomRadius is not None:
            if isinstance(self.__bottomRadius, six.string_types):
                str += ' bottomRadius="'+self.__bottomRadius+'"'
            else:
                str += ' bottomRadius="'+self.__bottomRadius[0]+'"'
        if self.__height is not None:
            if isinstance(self.__height, six.string_types):
                str += ' height="'+self.__height+'"'
            else:
                str += ' height="'+self.__height[0]+'"'
        if self.__side is not None:
            if isinstance(self.__side, six.string_types):
                str += ' side="'+self.__side+'"'
            else:
                str += ' side="'+self.__side[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Cone>'
        return str


class ConeEmitter(X3DParticleEmitterNode):
    def __init__(self, **kwargs):
        super(ConeEmitter, self).__init__(**kwargs)
        angle  = kwargs.pop("angle", 0.7854)
        if angle == None or angle  <  0:
            return None
        if angle == None or angle  >  3.1416:
            return None
        self.__angle = angle
        direction  = kwargs.pop("direction", [0, 1, 0])
        if direction == None or len(direction) <= 0 or min(direction)  <  -1:
            return None
        if direction == None or len(direction) <= 0 or max(direction)  >  1:
            return None
        self.__direction = direction
        mass  = kwargs.pop("mass", 0)
        if mass == None or mass  <  0:
            return None
        self.__mass = mass
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        position  = kwargs.pop("position", [0, 0, 0])
        self.__position = position
        speed  = kwargs.pop("speed", 0)
        if speed == None or speed  <  0:
            return None
        self.__speed = speed
        surfaceArea  = kwargs.pop("surfaceArea", 0)
        if surfaceArea == None or surfaceArea  <  0:
            return None
        self.__surfaceArea = surfaceArea
        variation  = kwargs.pop("variation", 0.25)
        if variation == None or variation  <  0:
            return None
        self.__variation = variation
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def angle(self):
        return self.__angle
    @angle.setter
    def angle(self, value = 0.7854):
        if value == None or value  <  0:
            return None
        if value == None or value  >  3.1416:
            return None
        self.__angle = [value]
    def setAngle(self, angle = 0.7854):
        if angle == None or angle  <  0:
            return None
        if angle == None or angle  >  3.1416:
            return None
        self.__angle = [angle]
        return self
    def addAngle(self, angle = 0.7854):
        if angle == None or angle  <  0:
            return None
        if angle == None or angle  >  3.1416:
            return None
        if self.__angle == None:            self.__angle =  []
        self.__angle +=  [angle]
        return self
    def removeAngle(self, angle):
        self.__angle = [x for x in self.__angle if x not in angle]
        return self.__angle
    def getAngle(self, angle = 0.7854):
        return self.__angle
    def angle_changed(self, angle = 0.7854):
        return self.__angle
    @property
    def direction(self):
        return self.__direction
    @direction.setter
    def direction(self, value = [0, 1, 0]):
        if value == None or len(value) <= 0 or min(value)  <  -1:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__direction = [value]
    def setDirection(self, direction = [0, 1, 0]):
        if direction == None or len(direction) <= 0 or min(direction)  <  -1:
            return None
        if direction == None or len(direction) <= 0 or max(direction)  >  1:
            return None
        self.__direction = [direction]
        return self
    def addDirection(self, direction = [0, 1, 0]):
        if direction == None or len(direction) <= 0 or min(direction)  <  -1:
            return None
        if direction == None or len(direction) <= 0 or max(direction)  >  1:
            return None
        if self.__direction == None:            self.__direction =  []
        self.__direction +=  [direction]
        return self
    def removeDirection(self, direction):
        self.__direction = [x for x in self.__direction if x not in direction]
        return self.__direction
    def getDirection(self, direction = [0, 1, 0]):
        return self.__direction
    def direction_changed(self, direction = [0, 1, 0]):
        return self.__direction
    @property
    def mass(self):
        return self.__mass
    @mass.setter
    def mass(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__mass = [value]
    def setMass(self, mass = 0):
        if mass == None or mass  <  0:
            return None
        self.__mass = [mass]
        return self
    def addMass(self, mass = 0):
        if mass == None or mass  <  0:
            return None
        if self.__mass == None:            self.__mass =  []
        self.__mass +=  [mass]
        return self
    def removeMass(self, mass):
        self.__mass = [x for x in self.__mass if x not in mass]
        return self.__mass
    def getMass(self, mass = 0):
        return self.__mass
    def mass_changed(self, mass = 0):
        return self.__mass
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def position(self):
        return self.__position
    @position.setter
    def position(self, value = [0, 0, 0]):
        self.__position = [value]
    def setPosition(self, position = [0, 0, 0]):
        self.__position = [position]
        return self
    def addPosition(self, position = [0, 0, 0]):
        if self.__position == None:            self.__position =  []
        self.__position +=  [position]
        return self
    def removePosition(self, position):
        self.__position = [x for x in self.__position if x not in position]
        return self.__position
    def getPosition(self, position = [0, 0, 0]):
        return self.__position
    def position_changed(self, position = [0, 0, 0]):
        return self.__position
    @property
    def speed(self):
        return self.__speed
    @speed.setter
    def speed(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__speed = [value]
    def setSpeed(self, speed = 0):
        if speed == None or speed  <  0:
            return None
        self.__speed = [speed]
        return self
    def addSpeed(self, speed = 0):
        if speed == None or speed  <  0:
            return None
        if self.__speed == None:            self.__speed =  []
        self.__speed +=  [speed]
        return self
    def removeSpeed(self, speed):
        self.__speed = [x for x in self.__speed if x not in speed]
        return self.__speed
    def getSpeed(self, speed = 0):
        return self.__speed
    def speed_changed(self, speed = 0):
        return self.__speed
    @property
    def variation(self):
        return self.__variation
    @variation.setter
    def variation(self, value = 0.25):
        if value == None or value  <  0:
            return None
        self.__variation = [value]
    def setVariation(self, variation = 0.25):
        if variation == None or variation  <  0:
            return None
        self.__variation = [variation]
        return self
    def addVariation(self, variation = 0.25):
        if variation == None or variation  <  0:
            return None
        if self.__variation == None:            self.__variation =  []
        self.__variation +=  [variation]
        return self
    def removeVariation(self, variation):
        self.__variation = [x for x in self.__variation if x not in variation]
        return self.__variation
    def getVariation(self, variation = 0.25):
        return self.__variation
    def variation_changed(self, variation = 0.25):
        return self.__variation
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ConeEmitter'
        if self.__angle is not None:
            if isinstance(self.__angle, six.string_types):
                str += ' angle="'+self.__angle+'"'
            else:
                str += ' angle="'+self.__angle[0]+'"'
        if self.__direction is not None:
            if isinstance(self.__direction, six.string_types):
                str += ' direction="'+self.__direction+'"'
            else:
                str += ' direction="'+self.__direction[0]+'"'
        if self.__mass is not None:
            if isinstance(self.__mass, six.string_types):
                str += ' mass="'+self.__mass+'"'
            else:
                str += ' mass="'+self.__mass[0]+'"'
        if self.__position is not None:
            if isinstance(self.__position, six.string_types):
                str += ' position="'+self.__position+'"'
            else:
                str += ' position="'+self.__position[0]+'"'
        if self.__speed is not None:
            if isinstance(self.__speed, six.string_types):
                str += ' speed="'+self.__speed+'"'
            else:
                str += ' speed="'+self.__speed[0]+'"'
        if self.__surfaceArea is not None:
            if isinstance(self.__surfaceArea, six.string_types):
                str += ' surfaceArea="'+self.__surfaceArea+'"'
            else:
                str += ' surfaceArea="'+self.__surfaceArea[0]+'"'
        if self.__variation is not None:
            if isinstance(self.__variation, six.string_types):
                str += ' variation="'+self.__variation+'"'
            else:
                str += ' variation="'+self.__variation[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ConeEmitter>'
        return str


class Contact(X3DNode):
    def __init__(self, **kwargs):
        super(Contact, self).__init__(**kwargs)
        appliedParameters  = kwargs.pop("appliedParameters", ["BOUNCE"])
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        self.__appliedParameters = appliedParameters
        body1  = kwargs.pop("body1", None)
        self.__body1 = body1
        body2  = kwargs.pop("body2", None)
        self.__body2 = body2
        bounce  = kwargs.pop("bounce", 0)
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        self.__bounce = bounce
        contactNormal  = kwargs.pop("contactNormal", [0, 1, 0])
        self.__contactNormal = contactNormal
        depth  = kwargs.pop("depth", 0)
        self.__depth = depth
        frictionCoefficients  = kwargs.pop("frictionCoefficients", [0, 0])
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        self.__frictionCoefficients = frictionCoefficients
        frictionDirection  = kwargs.pop("frictionDirection", [0, 1, 0])
        self.__frictionDirection = frictionDirection
        geometry1  = kwargs.pop("geometry1", None)
        self.__geometry1 = geometry1
        geometry2  = kwargs.pop("geometry2", None)
        self.__geometry2 = geometry2
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        minBounceSpeed  = kwargs.pop("minBounceSpeed", 0)
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        self.__minBounceSpeed = minBounceSpeed
        position  = kwargs.pop("position", [0, 0, 0])
        self.__position = position
        slipCoefficients  = kwargs.pop("slipCoefficients", [0, 0])
        self.__slipCoefficients = slipCoefficients
        softnessConstantForceMix  = kwargs.pop("softnessConstantForceMix", 0.0001)
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        self.__softnessConstantForceMix = softnessConstantForceMix
        softnessErrorCorrection  = kwargs.pop("softnessErrorCorrection", 0.8)
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        self.__softnessErrorCorrection = softnessErrorCorrection
        surfaceSpeed  = kwargs.pop("surfaceSpeed", [0, 0])
        self.__surfaceSpeed = surfaceSpeed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def appliedParameters(self):
        return self.__appliedParameters
    @appliedParameters.setter
    def appliedParameters(self, value = ["BOUNCE"]):
        if '"BOUNCE"' == value:
            pass
        elif '"USER_FRICTION"' == value:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == value:
            pass
        elif '"ERROR_REDUCTION"' == value:
            pass
        elif '"CONSTANT_FORCE"' == value:
            pass
        elif '"SPEED-1"' == value:
            pass
        elif '"SPEED-2"' == value:
            pass
        elif '"SLIP-1"' == value:
            pass
        elif '"SLIP-2"' == value:
            pass
        else:
            return None
        self.__appliedParameters = [value]
    def setAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        self.__appliedParameters = [appliedParameters]
        return self
    def addAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        if '"BOUNCE"' == appliedParameters:
            pass
        elif '"USER_FRICTION"' == appliedParameters:
            pass
        elif '"FRICTION_COEFFICIENT-2"' == appliedParameters:
            pass
        elif '"ERROR_REDUCTION"' == appliedParameters:
            pass
        elif '"CONSTANT_FORCE"' == appliedParameters:
            pass
        elif '"SPEED-1"' == appliedParameters:
            pass
        elif '"SPEED-2"' == appliedParameters:
            pass
        elif '"SLIP-1"' == appliedParameters:
            pass
        elif '"SLIP-2"' == appliedParameters:
            pass
        else:
            return None
        if self.__appliedParameters == None:            self.__appliedParameters =  []
        self.__appliedParameters +=  [appliedParameters]
        return self
    def removeAppliedParameters(self, appliedParameters):
        self.__appliedParameters = [x for x in self.__appliedParameters if x not in appliedParameters]
        return self.__appliedParameters
    def getAppliedParameters(self, appliedParameters = ["BOUNCE"]):
        return self.__appliedParameters
    def appliedParameters_changed(self, appliedParameters = ["BOUNCE"]):
        return self.__appliedParameters
    @property
    def body1(self):
        return self.__body1
    @body1.setter
    def body1(self, value = None):
        self.__body1 = [value]
    def setBody1(self, body1 = None):
        self.__body1 = [body1]
        return self
    def addBody1(self, body1 = None):
        if self.__body1 == None:            self.__body1 =  []
        self.__body1 +=  [body1]
        return self
    def removeBody1(self, body1):
        self.__body1 = [x for x in self.__body1 if x not in body1]
        return self.__body1
    def getBody1(self, body1 = None):
        return self.__body1
    def body1_changed(self, body1 = None):
        return self.__body1
    @property
    def body2(self):
        return self.__body2
    @body2.setter
    def body2(self, value = None):
        self.__body2 = [value]
    def setBody2(self, body2 = None):
        self.__body2 = [body2]
        return self
    def addBody2(self, body2 = None):
        if self.__body2 == None:            self.__body2 =  []
        self.__body2 +=  [body2]
        return self
    def removeBody2(self, body2):
        self.__body2 = [x for x in self.__body2 if x not in body2]
        return self.__body2
    def getBody2(self, body2 = None):
        return self.__body2
    def body2_changed(self, body2 = None):
        return self.__body2
    @property
    def bounce(self):
        return self.__bounce
    @bounce.setter
    def bounce(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__bounce = [value]
    def setBounce(self, bounce = 0):
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        self.__bounce = [bounce]
        return self
    def addBounce(self, bounce = 0):
        if bounce == None or bounce  <  0:
            return None
        if bounce == None or bounce  >  1:
            return None
        if self.__bounce == None:            self.__bounce =  []
        self.__bounce +=  [bounce]
        return self
    def removeBounce(self, bounce):
        self.__bounce = [x for x in self.__bounce if x not in bounce]
        return self.__bounce
    def getBounce(self, bounce = 0):
        return self.__bounce
    def bounce_changed(self, bounce = 0):
        return self.__bounce
    @property
    def contactNormal(self):
        return self.__contactNormal
    @contactNormal.setter
    def contactNormal(self, value = [0, 1, 0]):
        self.__contactNormal = [value]
    def setContactNormal(self, contactNormal = [0, 1, 0]):
        self.__contactNormal = [contactNormal]
        return self
    def addContactNormal(self, contactNormal = [0, 1, 0]):
        if self.__contactNormal == None:            self.__contactNormal =  []
        self.__contactNormal +=  [contactNormal]
        return self
    def removeContactNormal(self, contactNormal):
        self.__contactNormal = [x for x in self.__contactNormal if x not in contactNormal]
        return self.__contactNormal
    def getContactNormal(self, contactNormal = [0, 1, 0]):
        return self.__contactNormal
    def contactNormal_changed(self, contactNormal = [0, 1, 0]):
        return self.__contactNormal
    @property
    def depth(self):
        return self.__depth
    @depth.setter
    def depth(self, value = 0):
        self.__depth = [value]
    def setDepth(self, depth = 0):
        self.__depth = [depth]
        return self
    def addDepth(self, depth = 0):
        if self.__depth == None:            self.__depth =  []
        self.__depth +=  [depth]
        return self
    def removeDepth(self, depth):
        self.__depth = [x for x in self.__depth if x not in depth]
        return self.__depth
    def getDepth(self, depth = 0):
        return self.__depth
    def depth_changed(self, depth = 0):
        return self.__depth
    @property
    def frictionCoefficients(self):
        return self.__frictionCoefficients
    @frictionCoefficients.setter
    def frictionCoefficients(self, value = [0, 0]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        self.__frictionCoefficients = [value]
    def setFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        self.__frictionCoefficients = [frictionCoefficients]
        return self
    def addFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        if frictionCoefficients == None or len(frictionCoefficients) <= 0 or min(frictionCoefficients)  <  0:
            return None
        if self.__frictionCoefficients == None:            self.__frictionCoefficients =  []
        self.__frictionCoefficients +=  [frictionCoefficients]
        return self
    def removeFrictionCoefficients(self, frictionCoefficients):
        self.__frictionCoefficients = [x for x in self.__frictionCoefficients if x not in frictionCoefficients]
        return self.__frictionCoefficients
    def getFrictionCoefficients(self, frictionCoefficients = [0, 0]):
        return self.__frictionCoefficients
    def frictionCoefficients_changed(self, frictionCoefficients = [0, 0]):
        return self.__frictionCoefficients
    @property
    def frictionDirection(self):
        return self.__frictionDirection
    @frictionDirection.setter
    def frictionDirection(self, value = [0, 1, 0]):
        self.__frictionDirection = [value]
    def setFrictionDirection(self, frictionDirection = [0, 1, 0]):
        self.__frictionDirection = [frictionDirection]
        return self
    def addFrictionDirection(self, frictionDirection = [0, 1, 0]):
        if self.__frictionDirection == None:            self.__frictionDirection =  []
        self.__frictionDirection +=  [frictionDirection]
        return self
    def removeFrictionDirection(self, frictionDirection):
        self.__frictionDirection = [x for x in self.__frictionDirection if x not in frictionDirection]
        return self.__frictionDirection
    def getFrictionDirection(self, frictionDirection = [0, 1, 0]):
        return self.__frictionDirection
    def frictionDirection_changed(self, frictionDirection = [0, 1, 0]):
        return self.__frictionDirection
    @property
    def geometry1(self):
        return self.__geometry1
    @geometry1.setter
    def geometry1(self, value = None):
        self.__geometry1 = [value]
    def setGeometry1(self, geometry1 = None):
        self.__geometry1 = [geometry1]
        return self
    def addGeometry1(self, geometry1 = None):
        if self.__geometry1 == None:            self.__geometry1 =  []
        self.__geometry1 +=  [geometry1]
        return self
    def removeGeometry1(self, geometry1):
        self.__geometry1 = [x for x in self.__geometry1 if x not in geometry1]
        return self.__geometry1
    def getGeometry1(self, geometry1 = None):
        return self.__geometry1
    def geometry1_changed(self, geometry1 = None):
        return self.__geometry1
    @property
    def geometry2(self):
        return self.__geometry2
    @geometry2.setter
    def geometry2(self, value = None):
        self.__geometry2 = [value]
    def setGeometry2(self, geometry2 = None):
        self.__geometry2 = [geometry2]
        return self
    def addGeometry2(self, geometry2 = None):
        if self.__geometry2 == None:            self.__geometry2 =  []
        self.__geometry2 +=  [geometry2]
        return self
    def removeGeometry2(self, geometry2):
        self.__geometry2 = [x for x in self.__geometry2 if x not in geometry2]
        return self.__geometry2
    def getGeometry2(self, geometry2 = None):
        return self.__geometry2
    def geometry2_changed(self, geometry2 = None):
        return self.__geometry2
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def minBounceSpeed(self):
        return self.__minBounceSpeed
    @minBounceSpeed.setter
    def minBounceSpeed(self, value = 0):
        if value == None or value  <  0:
            return None
        self.__minBounceSpeed = [value]
    def setMinBounceSpeed(self, minBounceSpeed = 0):
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        self.__minBounceSpeed = [minBounceSpeed]
        return self
    def addMinBounceSpeed(self, minBounceSpeed = 0):
        if minBounceSpeed == None or minBounceSpeed  <  0:
            return None
        if self.__minBounceSpeed == None:            self.__minBounceSpeed =  []
        self.__minBounceSpeed +=  [minBounceSpeed]
        return self
    def removeMinBounceSpeed(self, minBounceSpeed):
        self.__minBounceSpeed = [x for x in self.__minBounceSpeed if x not in minBounceSpeed]
        return self.__minBounceSpeed
    def getMinBounceSpeed(self, minBounceSpeed = 0):
        return self.__minBounceSpeed
    def minBounceSpeed_changed(self, minBounceSpeed = 0):
        return self.__minBounceSpeed
    @property
    def position(self):
        return self.__position
    @position.setter
    def position(self, value = [0, 0, 0]):
        self.__position = [value]
    def setPosition(self, position = [0, 0, 0]):
        self.__position = [position]
        return self
    def addPosition(self, position = [0, 0, 0]):
        if self.__position == None:            self.__position =  []
        self.__position +=  [position]
        return self
    def removePosition(self, position):
        self.__position = [x for x in self.__position if x not in position]
        return self.__position
    def getPosition(self, position = [0, 0, 0]):
        return self.__position
    def position_changed(self, position = [0, 0, 0]):
        return self.__position
    @property
    def slipCoefficients(self):
        return self.__slipCoefficients
    @slipCoefficients.setter
    def slipCoefficients(self, value = [0, 0]):
        self.__slipCoefficients = [value]
    def setSlipCoefficients(self, slipCoefficients = [0, 0]):
        self.__slipCoefficients = [slipCoefficients]
        return self
    def addSlipCoefficients(self, slipCoefficients = [0, 0]):
        if self.__slipCoefficients == None:            self.__slipCoefficients =  []
        self.__slipCoefficients +=  [slipCoefficients]
        return self
    def removeSlipCoefficients(self, slipCoefficients):
        self.__slipCoefficients = [x for x in self.__slipCoefficients if x not in slipCoefficients]
        return self.__slipCoefficients
    def getSlipCoefficients(self, slipCoefficients = [0, 0]):
        return self.__slipCoefficients
    def slipCoefficients_changed(self, slipCoefficients = [0, 0]):
        return self.__slipCoefficients
    @property
    def softnessConstantForceMix(self):
        return self.__softnessConstantForceMix
    @softnessConstantForceMix.setter
    def softnessConstantForceMix(self, value = 0.0001):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__softnessConstantForceMix = [value]
    def setSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        self.__softnessConstantForceMix = [softnessConstantForceMix]
        return self
    def addSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        if softnessConstantForceMix == None or softnessConstantForceMix  <  0:
            return None
        if softnessConstantForceMix == None or softnessConstantForceMix  >  1:
            return None
        if self.__softnessConstantForceMix == None:            self.__softnessConstantForceMix =  []
        self.__softnessConstantForceMix +=  [softnessConstantForceMix]
        return self
    def removeSoftnessConstantForceMix(self, softnessConstantForceMix):
        self.__softnessConstantForceMix = [x for x in self.__softnessConstantForceMix if x not in softnessConstantForceMix]
        return self.__softnessConstantForceMix
    def getSoftnessConstantForceMix(self, softnessConstantForceMix = 0.0001):
        return self.__softnessConstantForceMix
    def softnessConstantForceMix_changed(self, softnessConstantForceMix = 0.0001):
        return self.__softnessConstantForceMix
    @property
    def softnessErrorCorrection(self):
        return self.__softnessErrorCorrection
    @softnessErrorCorrection.setter
    def softnessErrorCorrection(self, value = 0.8):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__softnessErrorCorrection = [value]
    def setSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        self.__softnessErrorCorrection = [softnessErrorCorrection]
        return self
    def addSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        if softnessErrorCorrection == None or softnessErrorCorrection  <  0:
            return None
        if softnessErrorCorrection == None or softnessErrorCorrection  >  1:
            return None
        if self.__softnessErrorCorrection == None:            self.__softnessErrorCorrection =  []
        self.__softnessErrorCorrection +=  [softnessErrorCorrection]
        return self
    def removeSoftnessErrorCorrection(self, softnessErrorCorrection):
        self.__softnessErrorCorrection = [x for x in self.__softnessErrorCorrection if x not in softnessErrorCorrection]
        return self.__softnessErrorCorrection
    def getSoftnessErrorCorrection(self, softnessErrorCorrection = 0.8):
        return self.__softnessErrorCorrection
    def softnessErrorCorrection_changed(self, softnessErrorCorrection = 0.8):
        return self.__softnessErrorCorrection
    @property
    def surfaceSpeed(self):
        return self.__surfaceSpeed
    @surfaceSpeed.setter
    def surfaceSpeed(self, value = [0, 0]):
        self.__surfaceSpeed = [value]
    def setSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        self.__surfaceSpeed = [surfaceSpeed]
        return self
    def addSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        if self.__surfaceSpeed == None:            self.__surfaceSpeed =  []
        self.__surfaceSpeed +=  [surfaceSpeed]
        return self
    def removeSurfaceSpeed(self, surfaceSpeed):
        self.__surfaceSpeed = [x for x in self.__surfaceSpeed if x not in surfaceSpeed]
        return self.__surfaceSpeed
    def getSurfaceSpeed(self, surfaceSpeed = [0, 0]):
        return self.__surfaceSpeed
    def surfaceSpeed_changed(self, surfaceSpeed = [0, 0]):
        return self.__surfaceSpeed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Contact'
        if self.__appliedParameters is not None:
            if isinstance(self.__appliedParameters, six.string_types):
                str += ' appliedParameters="'+self.__appliedParameters+'"'
            else:
                str += ' appliedParameters="'+self.__appliedParameters[0]+'"'
        if self.__bounce is not None:
            if isinstance(self.__bounce, six.string_types):
                str += ' bounce="'+self.__bounce+'"'
            else:
                str += ' bounce="'+self.__bounce[0]+'"'
        if self.__contactNormal is not None:
            if isinstance(self.__contactNormal, six.string_types):
                str += ' contactNormal="'+self.__contactNormal+'"'
            else:
                str += ' contactNormal="'+self.__contactNormal[0]+'"'
        if self.__depth is not None:
            if isinstance(self.__depth, six.string_types):
                str += ' depth="'+self.__depth+'"'
            else:
                str += ' depth="'+self.__depth[0]+'"'
        if self.__frictionCoefficients is not None:
            if isinstance(self.__frictionCoefficients, six.string_types):
                str += ' frictionCoefficients="'+self.__frictionCoefficients+'"'
            else:
                str += ' frictionCoefficients="'+self.__frictionCoefficients[0]+'"'
        if self.__frictionDirection is not None:
            if isinstance(self.__frictionDirection, six.string_types):
                str += ' frictionDirection="'+self.__frictionDirection+'"'
            else:
                str += ' frictionDirection="'+self.__frictionDirection[0]+'"'
        if self.__minBounceSpeed is not None:
            if isinstance(self.__minBounceSpeed, six.string_types):
                str += ' minBounceSpeed="'+self.__minBounceSpeed+'"'
            else:
                str += ' minBounceSpeed="'+self.__minBounceSpeed[0]+'"'
        if self.__position is not None:
            if isinstance(self.__position, six.string_types):
                str += ' position="'+self.__position+'"'
            else:
                str += ' position="'+self.__position[0]+'"'
        if self.__slipCoefficients is not None:
            if isinstance(self.__slipCoefficients, six.string_types):
                str += ' slipCoefficients="'+self.__slipCoefficients+'"'
            else:
                str += ' slipCoefficients="'+self.__slipCoefficients[0]+'"'
        if self.__softnessConstantForceMix is not None:
            if isinstance(self.__softnessConstantForceMix, six.string_types):
                str += ' softnessConstantForceMix="'+self.__softnessConstantForceMix+'"'
            else:
                str += ' softnessConstantForceMix="'+self.__softnessConstantForceMix[0]+'"'
        if self.__softnessErrorCorrection is not None:
            if isinstance(self.__softnessErrorCorrection, six.string_types):
                str += ' softnessErrorCorrection="'+self.__softnessErrorCorrection+'"'
            else:
                str += ' softnessErrorCorrection="'+self.__softnessErrorCorrection[0]+'"'
        if self.__surfaceSpeed is not None:
            if isinstance(self.__surfaceSpeed, six.string_types):
                str += ' surfaceSpeed="'+self.__surfaceSpeed+'"'
            else:
                str += ' surfaceSpeed="'+self.__surfaceSpeed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<body1'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body1 is not None:
           for s in self.__body1:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body1>'
        str += '<body2'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__body2 is not None:
           for s in self.__body2:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</body2>'
        str += '<geometry1'
        if self.__geometry1 is not None:
           for s in self.__geometry1:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__geometry1 is not None:
           for s in self.__geometry1:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</geometry1>'
        str += '<geometry2'
        if self.__geometry2 is not None:
           for s in self.__geometry2:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__geometry2 is not None:
           for s in self.__geometry2:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</geometry2>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Contact>'
        return str


class Contour2D(X3DNode):
    def __init__(self, **kwargs):
        super(Contour2D, self).__init__(**kwargs)
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        children  = kwargs.pop("children", None)
        self.__children = children
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        Children  = kwargs.pop("Children", None)
        self.__children = Children
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    def addChildren(self, Children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [Children]
        return self
    @property
    def children(self):
        return self.__children
    @children.setter
    def children(self, value = None):
        self.__children = [value]
    def setChildren(self, children = None):
        self.__children = [children]
        return self
    def addChildren(self, children = None):
        if self.__children == None:            self.__children =  []
        self.__children +=  [children]
        return self
    def removeChildren(self, children):
        self.__children = [x for x in self.__children if x not in children]
        return self.__children
    def getChildren(self, children = None):
        return self.__children
    def children_changed(self, children = None):
        return self.__children
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def Children(self):
        return self.__children
    @Children.setter
    def Children(self, value = None):
        self.__children = [value]
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Contour2D'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '<children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</children>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<Children'
        if self.__children is not None:
           for s in self.__children:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__children is not None:
           for s in self.__children:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</Children>'
        str += '</Contour2D>'
        return str


class ContourPolyline2D(X3DNurbsControlCurveNode):
    def __init__(self, **kwargs):
        super(ContourPolyline2D, self).__init__(**kwargs)
        controlPoint  = kwargs.pop("controlPoint", None)
        self.__controlPoint = controlPoint
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def controlPoint(self):
        return self.__controlPoint
    @controlPoint.setter
    def controlPoint(self, value = None):
        self.__controlPoint = [value]
    def setControlPoint(self, controlPoint = None):
        self.__controlPoint = [controlPoint]
        return self
    def addControlPoint(self, controlPoint = None):
        if self.__controlPoint == None:            self.__controlPoint =  []
        self.__controlPoint +=  [controlPoint]
        return self
    def removeControlPoint(self, controlPoint):
        self.__controlPoint = [x for x in self.__controlPoint if x not in controlPoint]
        return self.__controlPoint
    def getControlPoint(self, controlPoint = None):
        return self.__controlPoint
    def controlPoint_changed(self, controlPoint = None):
        return self.__controlPoint
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<ContourPolyline2D'
        if self.__controlPoint is not None:
            if isinstance(self.__controlPoint, six.string_types):
                str += ' controlPoint="'+self.__controlPoint+'"'
            else:
                str += ' controlPoint="'+self.__controlPoint[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</ContourPolyline2D>'
        return str


class Coordinate(X3DCoordinateNode):
    def __init__(self, **kwargs):
        super(Coordinate, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        point  = kwargs.pop("point", None)
        self.__point = point
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def point(self):
        return self.__point
    @point.setter
    def point(self, value = None):
        self.__point = [value]
    def setPoint(self, point = None):
        self.__point = [point]
        return self
    def addPoint(self, point = None):
        if self.__point == None:            self.__point =  []
        self.__point +=  [point]
        return self
    def removePoint(self, point):
        self.__point = [x for x in self.__point if x not in point]
        return self.__point
    def getPoint(self, point = None):
        return self.__point
    def point_changed(self, point = None):
        return self.__point
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Coordinate'
        if self.__point is not None:
            if isinstance(self.__point, six.string_types):
                str += ' point="'+self.__point+'"'
            else:
                str += ' point="'+self.__point[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Coordinate>'
        return str


class CoordinateChaser(X3DChaserNode):
    def __init__(self, **kwargs):
        super(CoordinateChaser, self).__init__(**kwargs)
        duration  = kwargs.pop("duration", 1)
        if duration == None or duration  <  0:
            return None
        self.__duration = duration
        initialDestination  = kwargs.pop("initialDestination", [0, 0, 0])
        self.__initialDestination = initialDestination
        initialValue  = kwargs.pop("initialValue", [0, 0, 0])
        self.__initialValue = initialValue
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        destination  = kwargs.pop("destination", None)
        self.__destination = destination
        value  = kwargs.pop("value", None)
        self.__value = value
        value_changed  = kwargs.pop("value_changed", None)
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def destination(self):
        return self.__destination
    @destination.setter
    def destination(self, value = None):
        self.__destination = [value]
    def set_destination(self, destination = None):
        self.__destination = [destination]
        return self
    @property
    def value(self):
        return self.__value
    @value.setter
    def value(self, value = None):
        self.__value = [value]
    def set_value(self, value = None):
        self.__value = [value]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CoordinateChaser'
        if self.__duration is not None:
            if isinstance(self.__duration, six.string_types):
                str += ' duration="'+self.__duration+'"'
            else:
                str += ' duration="'+self.__duration[0]+'"'
        if self.__initialDestination is not None:
            if isinstance(self.__initialDestination, six.string_types):
                str += ' initialDestination="'+self.__initialDestination+'"'
            else:
                str += ' initialDestination="'+self.__initialDestination[0]+'"'
        if self.__initialValue is not None:
            if isinstance(self.__initialValue, six.string_types):
                str += ' initialValue="'+self.__initialValue+'"'
            else:
                str += ' initialValue="'+self.__initialValue[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__destination is not None:
            if isinstance(self.__destination, six.string_types):
                str += ' destination="'+self.__destination+'"'
            else:
                str += ' destination="'+self.__destination[0]+'"'
        if self.__value is not None:
            if isinstance(self.__value, six.string_types):
                str += ' value="'+self.__value+'"'
            else:
                str += ' value="'+self.__value[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CoordinateChaser>'
        return str


class CoordinateDamper(X3DDamperNode):
    def __init__(self, **kwargs):
        super(CoordinateDamper, self).__init__(**kwargs)
        initialDestination  = kwargs.pop("initialDestination", [0, 0, 0])
        self.__initialDestination = initialDestination
        initialValue  = kwargs.pop("initialValue", [0, 0, 0])
        self.__initialValue = initialValue
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        order  = kwargs.pop("order", 3)
        if order == None or order  <  0:
            return None
        if order == None or order  >  5:
            return None
        self.__order = order
        destination  = kwargs.pop("destination", None)
        self.__destination = destination
        value  = kwargs.pop("value", None)
        self.__value = value
        tau  = kwargs.pop("tau", 0.3)
        if tau == None or tau  <  0:
            return None
        self.__tau = tau
        tolerance  = kwargs.pop("tolerance", -1)
        self.__tolerance = tolerance
        value_changed  = kwargs.pop("value_changed", None)
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def isActive(self, Active = None):
        return self.__Active
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def destination(self):
        return self.__destination
    @destination.setter
    def destination(self, value = None):
        self.__destination = [value]
    def set_destination(self, destination = None):
        self.__destination = [destination]
        return self
    @property
    def value(self):
        return self.__value
    @value.setter
    def value(self, value = None):
        self.__value = [value]
    def set_value(self, value = None):
        self.__value = [value]
        return self
    @property
    def tau(self):
        return self.__tau
    @tau.setter
    def tau(self, value = 0.3):
        if value == None or value  <  0:
            return None
        self.__tau = [value]
    def setTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        self.__tau = [tau]
        return self
    def addTau(self, tau = 0.3):
        if tau == None or tau  <  0:
            return None
        if self.__tau == None:            self.__tau =  []
        self.__tau +=  [tau]
        return self
    def removeTau(self, tau):
        self.__tau = [x for x in self.__tau if x not in tau]
        return self.__tau
    def getTau(self, tau = 0.3):
        return self.__tau
    def tau_changed(self, tau = 0.3):
        return self.__tau
    @property
    def tolerance(self):
        return self.__tolerance
    @tolerance.setter
    def tolerance(self, value = -1):
        self.__tolerance = [value]
    def setTolerance(self, tolerance = -1):
        self.__tolerance = [tolerance]
        return self
    def addTolerance(self, tolerance = -1):
        if self.__tolerance == None:            self.__tolerance =  []
        self.__tolerance +=  [tolerance]
        return self
    def removeTolerance(self, tolerance):
        self.__tolerance = [x for x in self.__tolerance if x not in tolerance]
        return self.__tolerance
    def getTolerance(self, tolerance = -1):
        return self.__tolerance
    def tolerance_changed(self, tolerance = -1):
        return self.__tolerance
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CoordinateDamper'
        if self.__initialDestination is not None:
            if isinstance(self.__initialDestination, six.string_types):
                str += ' initialDestination="'+self.__initialDestination+'"'
            else:
                str += ' initialDestination="'+self.__initialDestination[0]+'"'
        if self.__initialValue is not None:
            if isinstance(self.__initialValue, six.string_types):
                str += ' initialValue="'+self.__initialValue+'"'
            else:
                str += ' initialValue="'+self.__initialValue[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__order is not None:
            if isinstance(self.__order, six.string_types):
                str += ' order="'+self.__order+'"'
            else:
                str += ' order="'+self.__order[0]+'"'
        if self.__destination is not None:
            if isinstance(self.__destination, six.string_types):
                str += ' destination="'+self.__destination+'"'
            else:
                str += ' destination="'+self.__destination[0]+'"'
        if self.__value is not None:
            if isinstance(self.__value, six.string_types):
                str += ' value="'+self.__value+'"'
            else:
                str += ' value="'+self.__value[0]+'"'
        if self.__tau is not None:
            if isinstance(self.__tau, six.string_types):
                str += ' tau="'+self.__tau+'"'
            else:
                str += ' tau="'+self.__tau[0]+'"'
        if self.__tolerance is not None:
            if isinstance(self.__tolerance, six.string_types):
                str += ' tolerance="'+self.__tolerance+'"'
            else:
                str += ' tolerance="'+self.__tolerance[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CoordinateDamper>'
        return str


class CoordinateDouble(X3DCoordinateNode):
    def __init__(self, **kwargs):
        super(CoordinateDouble, self).__init__(**kwargs)
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        point  = kwargs.pop("point", None)
        self.__point = point
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def point(self):
        return self.__point
    @point.setter
    def point(self, value = None):
        self.__point = [value]
    def setPoint(self, point = None):
        self.__point = [point]
        return self
    def addPoint(self, point = None):
        if self.__point == None:            self.__point =  []
        self.__point +=  [point]
        return self
    def removePoint(self, point):
        self.__point = [x for x in self.__point if x not in point]
        return self.__point
    def getPoint(self, point = None):
        return self.__point
    def point_changed(self, point = None):
        return self.__point
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CoordinateDouble'
        if self.__point is not None:
            if isinstance(self.__point, six.string_types):
                str += ' point="'+self.__point+'"'
            else:
                str += ' point="'+self.__point[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CoordinateDouble>'
        return str


class CoordinateInterpolator(X3DInterpolatorNode):
    def __init__(self, **kwargs):
        super(CoordinateInterpolator, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        keyValue  = kwargs.pop("keyValue", None)
        self.__keyValue = keyValue
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        value_changed  = kwargs.pop("value_changed", None)
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def keyValue(self):
        return self.__keyValue
    @keyValue.setter
    def keyValue(self, value = None):
        self.__keyValue = [value]
    def setKeyValue(self, keyValue = None):
        self.__keyValue = [keyValue]
        return self
    def addKeyValue(self, keyValue = None):
        if self.__keyValue == None:            self.__keyValue =  []
        self.__keyValue +=  [keyValue]
        return self
    def removeKeyValue(self, keyValue):
        self.__keyValue = [x for x in self.__keyValue if x not in keyValue]
        return self.__keyValue
    def getKeyValue(self, keyValue = None):
        return self.__keyValue
    def keyValue_changed(self, keyValue = None):
        return self.__keyValue
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CoordinateInterpolator'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__keyValue is not None:
            if isinstance(self.__keyValue, six.string_types):
                str += ' keyValue="'+self.__keyValue+'"'
            else:
                str += ' keyValue="'+self.__keyValue[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CoordinateInterpolator>'
        return str


class CoordinateInterpolator2D(X3DInterpolatorNode):
    def __init__(self, **kwargs):
        super(CoordinateInterpolator2D, self).__init__(**kwargs)
        key  = kwargs.pop("key", None)
        self.__key = key
        keyValue  = kwargs.pop("keyValue", None)
        self.__keyValue = keyValue
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        fraction  = kwargs.pop("fraction", None)
        self.__fraction = fraction
        value_changed  = kwargs.pop("value_changed", None)
        self.__value_changed = value_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def key(self):
        return self.__key
    @key.setter
    def key(self, value = None):
        self.__key = [value]
    def setKey(self, key = None):
        self.__key = [key]
        return self
    def addKey(self, key = None):
        if self.__key == None:            self.__key =  []
        self.__key +=  [key]
        return self
    def removeKey(self, key):
        self.__key = [x for x in self.__key if x not in key]
        return self.__key
    def getKey(self, key = None):
        return self.__key
    def key_changed(self, key = None):
        return self.__key
    @property
    def keyValue(self):
        return self.__keyValue
    @keyValue.setter
    def keyValue(self, value = None):
        self.__keyValue = [value]
    def setKeyValue(self, keyValue = None):
        self.__keyValue = [keyValue]
        return self
    def addKeyValue(self, keyValue = None):
        if self.__keyValue == None:            self.__keyValue =  []
        self.__keyValue +=  [keyValue]
        return self
    def removeKeyValue(self, keyValue):
        self.__keyValue = [x for x in self.__keyValue if x not in keyValue]
        return self.__keyValue
    def getKeyValue(self, keyValue = None):
        return self.__keyValue
    def keyValue_changed(self, keyValue = None):
        return self.__keyValue
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def fraction(self):
        return self.__fraction
    @fraction.setter
    def fraction(self, value = None):
        self.__fraction = [value]
    def set_fraction(self, fraction = None):
        self.__fraction = [fraction]
        return self
    def removevalue_changed(self, value_changed):
        self.__value_changed = [x for x in self.__value_changed if x not in value_changed]
        return self.__value_changed
    def getvalue_changed(self, value_changed = None):
        return self.__value_changed
    def value_changed_changed(self, value_changed = None):
        return self.__value_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CoordinateInterpolator2D'
        if self.__key is not None:
            if isinstance(self.__key, six.string_types):
                str += ' key="'+self.__key+'"'
            else:
                str += ' key="'+self.__key[0]+'"'
        if self.__keyValue is not None:
            if isinstance(self.__keyValue, six.string_types):
                str += ' keyValue="'+self.__keyValue+'"'
            else:
                str += ' keyValue="'+self.__keyValue[0]+'"'
        if self.__fraction is not None:
            if isinstance(self.__fraction, six.string_types):
                str += ' fraction="'+self.__fraction+'"'
            else:
                str += ' fraction="'+self.__fraction[0]+'"'
        if self.__value_changed is not None:
            if isinstance(self.__value_changed, six.string_types):
                str += ' value_changed="'+self.__value_changed+'"'
            else:
                str += ' value_changed="'+self.__value_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CoordinateInterpolator2D>'
        return str


class Cylinder(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Cylinder, self).__init__(**kwargs)
        bottom  = kwargs.pop("bottom", True)
        self.__bottom = bottom
        height  = kwargs.pop("height", 2)
        if height == None or height  <=  0:
            return None
        self.__height = height
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        radius  = kwargs.pop("radius", 1)
        if radius == None or radius  <=  0:
            return None
        self.__radius = radius
        side  = kwargs.pop("side", True)
        self.__side = side
        solid  = kwargs.pop("solid", True)
        self.__solid = solid
        top  = kwargs.pop("top", True)
        self.__top = top
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def top(self):
        return self.__top
    @top.setter
    def top(self, value = True):
        self.__top = [value]
    def setTop(self, top = True):
        self.__top = [top]
        return self
    def addTop(self, top = True):
        if self.__top == None:            self.__top =  []
        self.__top +=  [top]
        return self
    def removeTop(self, top):
        self.__top = [x for x in self.__top if x not in top]
        return self.__top
    def isTop(self, top = True):
        return self.__top
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Cylinder'
        if self.__bottom is not None:
            if isinstance(self.__bottom, six.string_types):
                str += ' bottom="'+self.__bottom+'"'
            else:
                str += ' bottom="'+self.__bottom[0]+'"'
        if self.__height is not None:
            if isinstance(self.__height, six.string_types):
                str += ' height="'+self.__height+'"'
            else:
                str += ' height="'+self.__height[0]+'"'
        if self.__radius is not None:
            if isinstance(self.__radius, six.string_types):
                str += ' radius="'+self.__radius+'"'
            else:
                str += ' radius="'+self.__radius[0]+'"'
        if self.__side is not None:
            if isinstance(self.__side, six.string_types):
                str += ' side="'+self.__side+'"'
            else:
                str += ' side="'+self.__side[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__top is not None:
            if isinstance(self.__top, six.string_types):
                str += ' top="'+self.__top+'"'
            else:
                str += ' top="'+self.__top[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Cylinder>'
        return str


class CylinderSensor(X3DDragSensorNode):
    def __init__(self, **kwargs):
        super(CylinderSensor, self).__init__(**kwargs)
        autoOffset  = kwargs.pop("autoOffset", True)
        self.__autoOffset = autoOffset
        axisRotation  = kwargs.pop("axisRotation", [0, 1, 0, 0])
        self.__axisRotation = axisRotation
        description  = kwargs.pop("description", None)
        self.__description = description
        diskAngle  = kwargs.pop("diskAngle", 0.26179167)
        if diskAngle == None or diskAngle  <  0:
            return None
        if diskAngle == None or diskAngle  >  1.5708:
            return None
        self.__diskAngle = diskAngle
        enabled  = kwargs.pop("enabled", True)
        self.__enabled = enabled
        Active  = kwargs.pop("Active", None)
        self.__Active = Active
        Over  = kwargs.pop("Over", None)
        self.__Over = Over
        maxAngle  = kwargs.pop("maxAngle", -1)
        if maxAngle == None or maxAngle  <=  -6.2832:
            return None
        if maxAngle == None or maxAngle  >=  6.2832:
            return None
        self.__maxAngle = maxAngle
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        minAngle  = kwargs.pop("minAngle", 0)
        if minAngle == None or minAngle  <=  -6.2832:
            return None
        if minAngle == None or minAngle  >=  6.2832:
            return None
        self.__minAngle = minAngle
        offset  = kwargs.pop("offset", 0)
        self.__offset = offset
        rotation_changed  = kwargs.pop("rotation_changed", None)
        self.__rotation_changed = rotation_changed
        trackPoint_changed  = kwargs.pop("trackPoint_changed", None)
        self.__trackPoint_changed = trackPoint_changed
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def autoOffset(self):
        return self.__autoOffset
    @autoOffset.setter
    def autoOffset(self, value = True):
        self.__autoOffset = [value]
    def setAutoOffset(self, autoOffset = True):
        self.__autoOffset = [autoOffset]
        return self
    def addAutoOffset(self, autoOffset = True):
        if self.__autoOffset == None:            self.__autoOffset =  []
        self.__autoOffset +=  [autoOffset]
        return self
    def removeAutoOffset(self, autoOffset):
        self.__autoOffset = [x for x in self.__autoOffset if x not in autoOffset]
        return self.__autoOffset
    def isAutoOffset(self, autoOffset = True):
        return self.__autoOffset
    @property
    def axisRotation(self):
        return self.__axisRotation
    @axisRotation.setter
    def axisRotation(self, value = [0, 1, 0, 0]):
        self.__axisRotation = [value]
    def setAxisRotation(self, axisRotation = [0, 1, 0, 0]):
        self.__axisRotation = [axisRotation]
        return self
    def addAxisRotation(self, axisRotation = [0, 1, 0, 0]):
        if self.__axisRotation == None:            self.__axisRotation =  []
        self.__axisRotation +=  [axisRotation]
        return self
    def removeAxisRotation(self, axisRotation):
        self.__axisRotation = [x for x in self.__axisRotation if x not in axisRotation]
        return self.__axisRotation
    def getAxisRotation(self, axisRotation = [0, 1, 0, 0]):
        return self.__axisRotation
    def axisRotation_changed(self, axisRotation = [0, 1, 0, 0]):
        return self.__axisRotation
    @property
    def description(self):
        return self.__description
    @description.setter
    def description(self, value = None):
        self.__description = [value]
    def setDescription(self, description = None):
        self.__description = [description]
        return self
    def addDescription(self, description = None):
        if self.__description == None:            self.__description =  []
        self.__description +=  [description]
        return self
    def removeDescription(self, description):
        self.__description = [x for x in self.__description if x not in description]
        return self.__description
    def getDescription(self, description = None):
        return self.__description
    def description_changed(self, description = None):
        return self.__description
    @property
    def diskAngle(self):
        return self.__diskAngle
    @diskAngle.setter
    def diskAngle(self, value = 0.26179167):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1.5708:
            return None
        self.__diskAngle = [value]
    def setDiskAngle(self, diskAngle = 0.26179167):
        if diskAngle == None or diskAngle  <  0:
            return None
        if diskAngle == None or diskAngle  >  1.5708:
            return None
        self.__diskAngle = [diskAngle]
        return self
    def addDiskAngle(self, diskAngle = 0.26179167):
        if diskAngle == None or diskAngle  <  0:
            return None
        if diskAngle == None or diskAngle  >  1.5708:
            return None
        if self.__diskAngle == None:            self.__diskAngle =  []
        self.__diskAngle +=  [diskAngle]
        return self
    def removeDiskAngle(self, diskAngle):
        self.__diskAngle = [x for x in self.__diskAngle if x not in diskAngle]
        return self.__diskAngle
    def getDiskAngle(self, diskAngle = 0.26179167):
        return self.__diskAngle
    def diskAngle_changed(self, diskAngle = 0.26179167):
        return self.__diskAngle
    @property
    def enabled(self):
        return self.__enabled
    @enabled.setter
    def enabled(self, value = True):
        self.__enabled = [value]
    def setEnabled(self, enabled = True):
        self.__enabled = [enabled]
        return self
    def addEnabled(self, enabled = True):
        if self.__enabled == None:            self.__enabled =  []
        self.__enabled +=  [enabled]
        return self
    def removeEnabled(self, enabled):
        self.__enabled = [x for x in self.__enabled if x not in enabled]
        return self.__enabled
    def isEnabled(self, enabled = True):
        return self.__enabled
    def isActive(self, Active = None):
        return self.__Active
    def isOver(self, Over = None):
        return self.__Over
    @property
    def maxAngle(self):
        return self.__maxAngle
    @maxAngle.setter
    def maxAngle(self, value = -1):
        if value == None or value  <=  -6.2832:
            return None
        if value == None or value  >=  6.2832:
            return None
        self.__maxAngle = [value]
    def setMaxAngle(self, maxAngle = -1):
        if maxAngle == None or maxAngle  <=  -6.2832:
            return None
        if maxAngle == None or maxAngle  >=  6.2832:
            return None
        self.__maxAngle = [maxAngle]
        return self
    def addMaxAngle(self, maxAngle = -1):
        if maxAngle == None or maxAngle  <=  -6.2832:
            return None
        if maxAngle == None or maxAngle  >=  6.2832:
            return None
        if self.__maxAngle == None:            self.__maxAngle =  []
        self.__maxAngle +=  [maxAngle]
        return self
    def removeMaxAngle(self, maxAngle):
        self.__maxAngle = [x for x in self.__maxAngle if x not in maxAngle]
        return self.__maxAngle
    def getMaxAngle(self, maxAngle = -1):
        return self.__maxAngle
    def maxAngle_changed(self, maxAngle = -1):
        return self.__maxAngle
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def minAngle(self):
        return self.__minAngle
    @minAngle.setter
    def minAngle(self, value = 0):
        if value == None or value  <=  -6.2832:
            return None
        if value == None or value  >=  6.2832:
            return None
        self.__minAngle = [value]
    def setMinAngle(self, minAngle = 0):
        if minAngle == None or minAngle  <=  -6.2832:
            return None
        if minAngle == None or minAngle  >=  6.2832:
            return None
        self.__minAngle = [minAngle]
        return self
    def addMinAngle(self, minAngle = 0):
        if minAngle == None or minAngle  <=  -6.2832:
            return None
        if minAngle == None or minAngle  >=  6.2832:
            return None
        if self.__minAngle == None:            self.__minAngle =  []
        self.__minAngle +=  [minAngle]
        return self
    def removeMinAngle(self, minAngle):
        self.__minAngle = [x for x in self.__minAngle if x not in minAngle]
        return self.__minAngle
    def getMinAngle(self, minAngle = 0):
        return self.__minAngle
    def minAngle_changed(self, minAngle = 0):
        return self.__minAngle
    @property
    def offset(self):
        return self.__offset
    @offset.setter
    def offset(self, value = 0):
        self.__offset = [value]
    def setOffset(self, offset = 0):
        self.__offset = [offset]
        return self
    def addOffset(self, offset = 0):
        if self.__offset == None:            self.__offset =  []
        self.__offset +=  [offset]
        return self
    def removeOffset(self, offset):
        self.__offset = [x for x in self.__offset if x not in offset]
        return self.__offset
    def getOffset(self, offset = 0):
        return self.__offset
    def offset_changed(self, offset = 0):
        return self.__offset
    def removerotation_changed(self, rotation_changed):
        self.__rotation_changed = [x for x in self.__rotation_changed if x not in rotation_changed]
        return self.__rotation_changed
    def getrotation_changed(self, rotation_changed = None):
        return self.__rotation_changed
    def rotation_changed_changed(self, rotation_changed = None):
        return self.__rotation_changed
    def removetrackPoint_changed(self, trackPoint_changed):
        self.__trackPoint_changed = [x for x in self.__trackPoint_changed if x not in trackPoint_changed]
        return self.__trackPoint_changed
    def gettrackPoint_changed(self, trackPoint_changed = None):
        return self.__trackPoint_changed
    def trackPoint_changed_changed(self, trackPoint_changed = None):
        return self.__trackPoint_changed
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<CylinderSensor'
        if self.__autoOffset is not None:
            if isinstance(self.__autoOffset, six.string_types):
                str += ' autoOffset="'+self.__autoOffset+'"'
            else:
                str += ' autoOffset="'+self.__autoOffset[0]+'"'
        if self.__axisRotation is not None:
            if isinstance(self.__axisRotation, six.string_types):
                str += ' axisRotation="'+self.__axisRotation+'"'
            else:
                str += ' axisRotation="'+self.__axisRotation[0]+'"'
        if self.__description is not None:
            if isinstance(self.__description, six.string_types):
                str += ' description="'+self.__description+'"'
            else:
                str += ' description="'+self.__description[0]+'"'
        if self.__diskAngle is not None:
            if isinstance(self.__diskAngle, six.string_types):
                str += ' diskAngle="'+self.__diskAngle+'"'
            else:
                str += ' diskAngle="'+self.__diskAngle[0]+'"'
        if self.__enabled is not None:
            if isinstance(self.__enabled, six.string_types):
                str += ' enabled="'+self.__enabled+'"'
            else:
                str += ' enabled="'+self.__enabled[0]+'"'
        if self.__Active is not None:
            if isinstance(self.__Active, six.string_types):
                str += ' Active="'+self.__Active+'"'
            else:
                str += ' Active="'+self.__Active[0]+'"'
        if self.__Over is not None:
            if isinstance(self.__Over, six.string_types):
                str += ' Over="'+self.__Over+'"'
            else:
                str += ' Over="'+self.__Over[0]+'"'
        if self.__maxAngle is not None:
            if isinstance(self.__maxAngle, six.string_types):
                str += ' maxAngle="'+self.__maxAngle+'"'
            else:
                str += ' maxAngle="'+self.__maxAngle[0]+'"'
        if self.__minAngle is not None:
            if isinstance(self.__minAngle, six.string_types):
                str += ' minAngle="'+self.__minAngle+'"'
            else:
                str += ' minAngle="'+self.__minAngle[0]+'"'
        if self.__offset is not None:
            if isinstance(self.__offset, six.string_types):
                str += ' offset="'+self.__offset+'"'
            else:
                str += ' offset="'+self.__offset[0]+'"'
        if self.__rotation_changed is not None:
            if isinstance(self.__rotation_changed, six.string_types):
                str += ' rotation_changed="'+self.__rotation_changed+'"'
            else:
                str += ' rotation_changed="'+self.__rotation_changed[0]+'"'
        if self.__trackPoint_changed is not None:
            if isinstance(self.__trackPoint_changed, six.string_types):
                str += ' trackPoint_changed="'+self.__trackPoint_changed+'"'
            else:
                str += ' trackPoint_changed="'+self.__trackPoint_changed[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</CylinderSensor>'
        return str


class DirectionalLight(X3DLightNode):
    def __init__(self, **kwargs):
        super(DirectionalLight, self).__init__(**kwargs)
        ambientIntensity  = kwargs.pop("ambientIntensity", 0)
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        self.__ambientIntensity = ambientIntensity
        color  = kwargs.pop("color", [1, 1, 1])
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = color
        direction  = kwargs.pop("direction", [0, 0, -1])
        self.__direction = direction
        global_  = kwargs.pop("global_", False)
        self.__global_ = global_
        intensity  = kwargs.pop("intensity", 1)
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        self.__intensity = intensity
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        on  = kwargs.pop("on", True)
        self.__on = on
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def ambientIntensity(self):
        return self.__ambientIntensity
    @ambientIntensity.setter
    def ambientIntensity(self, value = 0):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__ambientIntensity = [value]
    def setAmbientIntensity(self, ambientIntensity = 0):
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        self.__ambientIntensity = [ambientIntensity]
        return self
    def addAmbientIntensity(self, ambientIntensity = 0):
        if ambientIntensity == None or ambientIntensity  <  0:
            return None
        if ambientIntensity == None or ambientIntensity  >  1:
            return None
        if self.__ambientIntensity == None:            self.__ambientIntensity =  []
        self.__ambientIntensity +=  [ambientIntensity]
        return self
    def removeAmbientIntensity(self, ambientIntensity):
        self.__ambientIntensity = [x for x in self.__ambientIntensity if x not in ambientIntensity]
        return self.__ambientIntensity
    def getAmbientIntensity(self, ambientIntensity = 0):
        return self.__ambientIntensity
    def ambientIntensity_changed(self, ambientIntensity = 0):
        return self.__ambientIntensity
    @property
    def color(self):
        return self.__color
    @color.setter
    def color(self, value = [1, 1, 1]):
        if value == None or len(value) <= 0 or min(value)  <  0:
            return None
        if value == None or len(value) <= 0 or max(value)  >  1:
            return None
        self.__color = [value]
    def setColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        self.__color = [color]
        return self
    def addColor(self, color = [1, 1, 1]):
        if color == None or len(color) <= 0 or min(color)  <  0:
            return None
        if color == None or len(color) <= 0 or max(color)  >  1:
            return None
        if self.__color == None:            self.__color =  []
        self.__color +=  [color]
        return self
    def removeColor(self, color):
        self.__color = [x for x in self.__color if x not in color]
        return self.__color
    def getColor(self, color = [1, 1, 1]):
        return self.__color
    def color_changed(self, color = [1, 1, 1]):
        return self.__color
    @property
    def direction(self):
        return self.__direction
    @direction.setter
    def direction(self, value = [0, 0, -1]):
        self.__direction = [value]
    def setDirection(self, direction = [0, 0, -1]):
        self.__direction = [direction]
        return self
    def addDirection(self, direction = [0, 0, -1]):
        if self.__direction == None:            self.__direction =  []
        self.__direction +=  [direction]
        return self
    def removeDirection(self, direction):
        self.__direction = [x for x in self.__direction if x not in direction]
        return self.__direction
    def getDirection(self, direction = [0, 0, -1]):
        return self.__direction
    def direction_changed(self, direction = [0, 0, -1]):
        return self.__direction
    @property
    def global_(self):
        return self.__global_
    @global_.setter
    def global_(self, value = False):
        self.__global_ = [value]
    def setGlobal(self, global_ = False):
        self.__global_ = [global_]
        return self
    def addGlobal(self, global_ = False):
        if self.__global_ == None:            self.__global_ =  []
        self.__global_ +=  [global_]
        return self
    def removeGlobal(self, global_):
        self.__global_ = [x for x in self.__global_ if x not in global_]
        return self.__global_
    def isGlobal(self, global_ = False):
        return self.__global_
    @property
    def intensity(self):
        return self.__intensity
    @intensity.setter
    def intensity(self, value = 1):
        if value == None or value  <  0:
            return None
        if value == None or value  >  1:
            return None
        self.__intensity = [value]
    def setIntensity(self, intensity = 1):
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        self.__intensity = [intensity]
        return self
    def addIntensity(self, intensity = 1):
        if intensity == None or intensity  <  0:
            return None
        if intensity == None or intensity  >  1:
            return None
        if self.__intensity == None:            self.__intensity =  []
        self.__intensity +=  [intensity]
        return self
    def removeIntensity(self, intensity):
        self.__intensity = [x for x in self.__intensity if x not in intensity]
        return self.__intensity
    def getIntensity(self, intensity = 1):
        return self.__intensity
    def intensity_changed(self, intensity = 1):
        return self.__intensity
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def on(self):
        return self.__on
    @on.setter
    def on(self, value = True):
        self.__on = [value]
    def setOn(self, on = True):
        self.__on = [on]
        return self
    def addOn(self, on = True):
        if self.__on == None:            self.__on =  []
        self.__on +=  [on]
        return self
    def removeOn(self, on):
        self.__on = [x for x in self.__on if x not in on]
        return self.__on
    def isOn(self, on = True):
        return self.__on
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    @property
    def IS(self):
        return self.__IS
    @IS.setter
    def IS(self, value = None):
        self.__IS = [value]
    def setIS(self, IS = None):
        self.__IS = [IS]
        return self
    def addIS(self, IS = None):
        if self.__IS == None:            self.__IS =  []
        self.__IS +=  [IS]
        return self
    def removeIS(self, IS):
        self.__IS = [x for x in self.__IS if x not in IS]
        return self.__IS
    def getIS(self, IS = None):
        return self.__IS
    def IS_changed(self, IS = None):
        return self.__IS
    def toXML(self):
        str = ''
        str += '<DirectionalLight'
        if self.__ambientIntensity is not None:
            if isinstance(self.__ambientIntensity, six.string_types):
                str += ' ambientIntensity="'+self.__ambientIntensity+'"'
            else:
                str += ' ambientIntensity="'+self.__ambientIntensity[0]+'"'
        if self.__color is not None:
            if isinstance(self.__color, six.string_types):
                str += ' color="'+self.__color+'"'
            else:
                str += ' color="'+self.__color[0]+'"'
        if self.__direction is not None:
            if isinstance(self.__direction, six.string_types):
                str += ' direction="'+self.__direction+'"'
            else:
                str += ' direction="'+self.__direction[0]+'"'
        if self.__global_ is not None:
            if isinstance(self.__global_, six.string_types):
                str += ' global_="'+self.__global_+'"'
            else:
                str += ' global_="'+self.__global_[0]+'"'
        if self.__intensity is not None:
            if isinstance(self.__intensity, six.string_types):
                str += ' intensity="'+self.__intensity+'"'
            else:
                str += ' intensity="'+self.__intensity[0]+'"'
        if self.__on is not None:
            if isinstance(self.__on, six.string_types):
                str += ' on="'+self.__on+'"'
            else:
                str += ' on="'+self.__on[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</DirectionalLight>'
        return str


class DISEntityManager(X3DChildNode):
    def __init__(self, **kwargs):
        super(DISEntityManager, self).__init__(**kwargs)
        EdEntities  = kwargs.pop("EdEntities", None)
        self.__EdEntities = EdEntities
        address  = kwargs.pop("address", "localhost")
        self.__address = address
        applicationID  = kwargs.pop("applicationID", 0)
        self.__applicationID = applicationID
        mapping  = kwargs.pop("mapping", None)
        self.__mapping = mapping
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        port  = kwargs.pop("port", 0)
        self.__port = port
        DEntities  = kwargs.pop("DEntities", None)
        self.__DEntities = DEntities
        siteID  = kwargs.pop("siteID", 0)
        self.__siteID = siteID
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    def removeAddedEntities(self, EdEntities):
        self.__EdEntities = [x for x in self.__EdEntities if x not in EdEntities]
        return self.__EdEntities
    def getAddedEntities(self, EdEntities = None):
        return self.__EdEntities
    def addedEntities_changed(self, EdEntities = None):
        return self.__EdEntities
    @property
    def address(self):
        return self.__address
    @address.setter
    def address(self, value = "localhost"):
        self.__address = [value]
    def address(self, address = "localhost"):
        if self.__address == None:            self.__address =  []
        self.__address +=  [address]
        return self
    def removeAddress(self, address):
        self.__address = [x for x in self.__address if x not in address]
        return self.__address
    def getAddress(self, address = "localhost"):
        return self.__address
    def address_changed(self, address = "localhost"):
        return self.__address
    @property
    def applicationID(self):
        return self.__applicationID
    @applicationID.setter
    def applicationID(self, value = 0):
        self.__applicationID = [value]
    def setApplicationID(self, applicationID = 0):
        self.__applicationID = [applicationID]
        return self
    def addApplicationID(self, applicationID = 0):
        if self.__applicationID == None:            self.__applicationID =  []
        self.__applicationID +=  [applicationID]
        return self
    def removeApplicationID(self, applicationID):
        self.__applicationID = [x for x in self.__applicationID if x not in applicationID]
        return self.__applicationID
    def getApplicationID(self, applicationID = 0):
        return self.__applicationID
    def applicationID_changed(self, applicationID = 0):
        return self.__applicationID
    @property
    def mapping(self):
        return self.__mapping
    @mapping.setter
    def mapping(self, value = None):
        self.__mapping = [value]
    def setMapping(self, mapping = None):
        self.__mapping = [mapping]
        return self
    def addMapping(self, mapping = None):
        if self.__mapping == None:            self.__mapping =  []
        self.__mapping +=  [mapping]
        return self
    def removeMapping(self, mapping):
        self.__mapping = [x for x in self.__mapping if x not in mapping]
        return self.__mapping
    def getMapping(self, mapping = None):
        return self.__mapping
    def mapping_changed(self, mapping = None):
        return self.__mapping
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def port(self):
        return self.__port
    @port.setter
    def port(self, value = 0):
        self.__port = [value]
    def setPort(self, port = 0):
        self.__port = [port]
        return self
    def addPort(self, port = 0):
        if self.__port == None:            self.__port =  []
        self.__port +=  [port]
        return self
    def removePort(self, port):
        self.__port = [x for x in self.__port if x not in port]
        return self.__port
    def getPort(self, port = 0):
        return self.__port
    def port_changed(self, port = 0):
        return self.__port
    def removeRemovedEntities(self, DEntities):
        self.__DEntities = [x for x in self.__DEntities if x not in DEntities]
        return self.__DEntities
    def getRemovedEntities(self, DEntities = None):
        return self.__DEntities
    def removedEntities_changed(self, DEntities = None):
        return self.__DEntities
    @property
    def siteID(self):
        return self.__siteID
    @siteID.setter
    def siteID(self, value = 0):
        self.__siteID = [value]
    def setSiteID(self, siteID = 0):
        self.__siteID = [siteID]
        return self
    def addSiteID(self, siteID = 0):
        if self.__siteID == None:            self.__siteID =  []
        self.__siteID +=  [siteID]
        return self
    def removeSiteID(self, siteID):
        self.__siteID = [x for x in self.__siteID if x not in siteID]
        return self.__siteID
    def getSiteID(self, siteID = 0):
        return self.__siteID
    def siteID_changed(self, siteID = 0):
        return self.__siteID
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<DISEntityManager'
        if self.__address is not None:
            if isinstance(self.__address, six.string_types):
                str += ' address="'+self.__address+'"'
            else:
                str += ' address="'+self.__address[0]+'"'
        if self.__applicationID is not None:
            if isinstance(self.__applicationID, six.string_types):
                str += ' applicationID="'+self.__applicationID+'"'
            else:
                str += ' applicationID="'+self.__applicationID[0]+'"'
        if self.__port is not None:
            if isinstance(self.__port, six.string_types):
                str += ' port="'+self.__port+'"'
            else:
                str += ' port="'+self.__port[0]+'"'
        if self.__siteID is not None:
            if isinstance(self.__siteID, six.string_types):
                str += ' siteID="'+self.__siteID+'"'
            else:
                str += ' siteID="'+self.__siteID[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<EdEntities'
        if self.__EdEntities is not None:
           for s in self.__EdEntities:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__EdEntities is not None:
           for s in self.__EdEntities:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</EdEntities>'
        str += '<mapping'
        if self.__mapping is not None:
           for s in self.__mapping:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__mapping is not None:
           for s in self.__mapping:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</mapping>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '<DEntities'
        if self.__DEntities is not None:
           for s in self.__DEntities:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__DEntities is not None:
           for s in self.__DEntities:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</DEntities>'
        str += '</DISEntityManager>'
        return str


class DISEntityTypeMapping(X3DUrlObject, X3DInfoNode):
    def __init__(self, **kwargs):
        super(DISEntityTypeMapping, self).__init__(**kwargs)
        category  = kwargs.pop("category", 0)
        if category == None or category  <  0:
            return None
        if category == None or category  >  255:
            return None
        self.__category = category
        country  = kwargs.pop("country", 0)
        if country == None or country  <  0:
            return None
        if country == None or country  >  65535:
            return None
        self.__country = country
        domain  = kwargs.pop("domain", 0)
        if domain == None or domain  <  0:
            return None
        if domain == None or domain  >  255:
            return None
        self.__domain = domain
        extra  = kwargs.pop("extra", 0)
        if extra == None or extra  <  0:
            return None
        if extra == None or extra  >  255:
            return None
        self.__extra = extra
        kind  = kwargs.pop("kind", 0)
        if kind == None or kind  <  0:
            return None
        if kind == None or kind  >  255:
            return None
        self.__kind = kind
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        specific  = kwargs.pop("specific", 0)
        if specific == None or specific  <  0:
            return None
        if specific == None or specific  >  255:
            return None
        self.__specific = specific
        subcategory  = kwargs.pop("subcategory", 0)
        if subcategory == None or subcategory  <  0:
            return None
        if subcategory == None or subcategory  >  255:
            return None
        self.__subcategory = subcategory
        url  = kwargs.pop("url", None)
        self.__url = url
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def url(self):
        return self.__url
    @url.setter
    def url(self, value = None):
        self.__url = [value]
    def setUrl(self, url = None):
        self.__url = [url]
        return self
    def addUrl(self, url = None):
        if self.__url == None:            self.__url =  []
        self.__url +=  [url]
        return self
    def removeUrl(self, url):
        self.__url = [x for x in self.__url if x not in url]
        return self.__url
    def getUrl(self, url = None):
        return self.__url
    def url_changed(self, url = None):
        return self.__url
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<DISEntityTypeMapping'
        if self.__category is not None:
            if isinstance(self.__category, six.string_types):
                str += ' category="'+self.__category+'"'
            else:
                str += ' category="'+self.__category[0]+'"'
        if self.__country is not None:
            if isinstance(self.__country, six.string_types):
                str += ' country="'+self.__country+'"'
            else:
                str += ' country="'+self.__country[0]+'"'
        if self.__domain is not None:
            if isinstance(self.__domain, six.string_types):
                str += ' domain="'+self.__domain+'"'
            else:
                str += ' domain="'+self.__domain[0]+'"'
        if self.__extra is not None:
            if isinstance(self.__extra, six.string_types):
                str += ' extra="'+self.__extra+'"'
            else:
                str += ' extra="'+self.__extra[0]+'"'
        if self.__kind is not None:
            if isinstance(self.__kind, six.string_types):
                str += ' kind="'+self.__kind+'"'
            else:
                str += ' kind="'+self.__kind[0]+'"'
        if self.__specific is not None:
            if isinstance(self.__specific, six.string_types):
                str += ' specific="'+self.__specific+'"'
            else:
                str += ' specific="'+self.__specific[0]+'"'
        if self.__subcategory is not None:
            if isinstance(self.__subcategory, six.string_types):
                str += ' subcategory="'+self.__subcategory+'"'
            else:
                str += ' subcategory="'+self.__subcategory[0]+'"'
        if self.__url is not None:
            if isinstance(self.__url, six.string_types):
                str += ' url="'+self.__url+'"'
            else:
                str += ' url="'+self.__url[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</DISEntityTypeMapping>'
        return str


class Disk2D(X3DGeometryNode):
    def __init__(self, **kwargs):
        super(Disk2D, self).__init__(**kwargs)
        innerRadius  = kwargs.pop("innerRadius", 0)
        if innerRadius == None or innerRadius  <  0:
            return None
        self.__innerRadius = innerRadius
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        outerRadius  = kwargs.pop("outerRadius", 1)
        if outerRadius == None or outerRadius  <=  0:
            return None
        self.__outerRadius = outerRadius
        solid  = kwargs.pop("solid", False)
        self.__solid = solid
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def metadata(self):
        return self.__metadata
    @metadata.setter
    def metadata(self, value = None):
        self.__metadata = [value]
    def setMetadata(self, metadata = None):
        self.__metadata = [metadata]
        return self
    def addMetadata(self, metadata = None):
        if self.__metadata == None:            self.__metadata =  []
        self.__metadata +=  [metadata]
        return self
    def removeMetadata(self, metadata):
        self.__metadata = [x for x in self.__metadata if x not in metadata]
        return self.__metadata
    def getMetadata(self, metadata = None):
        return self.__metadata
    def metadata_changed(self, metadata = None):
        return self.__metadata
    @property
    def DEF(self):
        return self.__DEF
    @DEF.setter
    def DEF(self, value = None):
        self.__DEF = [value]
    def setDEF(self, DEF = None):
        self.__DEF = [DEF]
        return self
    def addDEF(self, DEF = None):
        if self.__DEF == None:            self.__DEF =  []
        self.__DEF +=  [DEF]
        return self
    def removeDEF(self, DEF):
        self.__DEF = [x for x in self.__DEF if x not in DEF]
        return self.__DEF
    def getDEF(self, DEF = None):
        return self.__DEF
    def DEF_changed(self, DEF = None):
        return self.__DEF
    @property
    def USE(self):
        return self.__USE
    @USE.setter
    def USE(self, value = None):
        self.__USE = [value]
    def setUSE(self, USE = None):
        self.__USE = [USE]
        return self
    def addUSE(self, USE = None):
        if self.__USE == None:            self.__USE =  []
        self.__USE +=  [USE]
        return self
    def removeUSE(self, USE):
        self.__USE = [x for x in self.__USE if x not in USE]
        return self.__USE
    def getUSE(self, USE = None):
        return self.__USE
    def USE_changed(self, USE = None):
        return self.__USE
    @property
    def class_(self):
        return self.__class_
    @class_.setter
    def class_(self, value = None):
        self.__class_ = [value]
    def setClass(self, class_ = None):
        self.__class_ = [class_]
        return self
    def addClass(self, class_ = None):
        if self.__class_ == None:            self.__class_ =  []
        self.__class_ +=  [class_]
        return self
    def removeClass(self, class_):
        self.__class_ = [x for x in self.__class_ if x not in class_]
        return self.__class_
    def getClass(self, class_ = None):
        return self.__class_
    def class_changed(self, class_ = None):
        return self.__class_
    @property
    def comments(self):
        return self.__comments
    @comments.setter
    def comments(self, value = None):
        self.__comments = [value]
    def setComments(self, comments = None):
        self.__comments = [comments]
        return self
    def addComments(self, comments = None):
        if self.__comments == None:            self.__comments =  []
        self.__comments +=  [comments]
        return self
    def toXML(self):
        str = ''
        str += '<Disk2D'
        if self.__innerRadius is not None:
            if isinstance(self.__innerRadius, six.string_types):
                str += ' innerRadius="'+self.__innerRadius+'"'
            else:
                str += ' innerRadius="'+self.__innerRadius[0]+'"'
        if self.__outerRadius is not None:
            if isinstance(self.__outerRadius, six.string_types):
                str += ' outerRadius="'+self.__outerRadius+'"'
            else:
                str += ' outerRadius="'+self.__outerRadius[0]+'"'
        if self.__solid is not None:
            if isinstance(self.__solid, six.string_types):
                str += ' solid="'+self.__solid+'"'
            else:
                str += ' solid="'+self.__solid[0]+'"'
        if self.__DEF is not None:
            if isinstance(self.__DEF, six.string_types):
                str += ' DEF="'+self.__DEF+'"'
            else:
                str += ' DEF="'+self.__DEF[0]+'"'
        if self.__USE is not None:
            if isinstance(self.__USE, six.string_types):
                str += ' USE="'+self.__USE+'"'
            else:
                str += ' USE="'+self.__USE[0]+'"'
        if self.__class_ is not None:
            if isinstance(self.__class_, six.string_types):
                str += ' class_="'+self.__class_+'"'
            else:
                str += ' class_="'+self.__class_[0]+'"'
        str += '>'
        str += '<metadata'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) not in ['head', 'Scene']:
                   str += s.toXML()
        str += '>'
        if self.__metadata is not None:
           for s in self.__metadata:
               if type(s) in ['head', 'Scene']:
                   str += s.toXMLNode()
        str += '</metadata>'
        str += '</Disk2D>'
        return str


class DoubleAxisHingeJoint(X3DRigidJointNode):
    def __init__(self, **kwargs):
        super(DoubleAxisHingeJoint, self).__init__(**kwargs)
        anchorPoint  = kwargs.pop("anchorPoint", [0, 0, 0])
        self.__anchorPoint = anchorPoint
        axis1  = kwargs.pop("axis1", [0, 0, 0])
        self.__axis1 = axis1
        axis2  = kwargs.pop("axis2", [0, 0, 0])
        self.__axis2 = axis2
        body1  = kwargs.pop("body1", None)
        self.__body1 = body1
        body1AnchorPoint  = kwargs.pop("body1AnchorPoint", None)
        self.__body1AnchorPoint = body1AnchorPoint
        body1Axis  = kwargs.pop("body1Axis", None)
        self.__body1Axis = body1Axis
        body2  = kwargs.pop("body2", None)
        self.__body2 = body2
        body2AnchorPoint  = kwargs.pop("body2AnchorPoint", None)
        self.__body2AnchorPoint = body2AnchorPoint
        body2Axis  = kwargs.pop("body2Axis", None)
        self.__body2Axis = body2Axis
        desiredAngularVelocity1  = kwargs.pop("desiredAngularVelocity1", 0)
        self.__desiredAngularVelocity1 = desiredAngularVelocity1
        desiredAngularVelocity2  = kwargs.pop("desiredAngularVelocity2", 0)
        self.__desiredAngularVelocity2 = desiredAngularVelocity2
        forceOutput  = kwargs.pop("forceOutput", ["NONE"])
        self.__forceOutput = forceOutput
        hinge1Angle  = kwargs.pop("hinge1Angle", None)
        self.__hinge1Angle = hinge1Angle
        hinge1AngleRate  = kwargs.pop("hinge1AngleRate", None)
        self.__hinge1AngleRate = hinge1AngleRate
        hinge2Angle  = kwargs.pop("hinge2Angle", None)
        self.__hinge2Angle = hinge2Angle
        hinge2AngleRate  = kwargs.pop("hinge2AngleRate", None)
        self.__hinge2AngleRate = hinge2AngleRate
        maxAngle1  = kwargs.pop("maxAngle1", 3.141592653)
        self.__maxAngle1 = maxAngle1
        maxTorque1  = kwargs.pop("maxTorque1", 0)
        self.__maxTorque1 = maxTorque1
        maxTorque2  = kwargs.pop("maxTorque2", 0)
        self.__maxTorque2 = maxTorque2
        metadata  = kwargs.pop("metadata", None)
        self.__metadata = metadata
        minAngle1  = kwargs.pop("minAngle1", -3.141592653)
        self.__minAngle1 = minAngle1
        stop1Bounce  = kwargs.pop("stop1Bounce", 0)
        self.__stop1Bounce = stop1Bounce
        stop1ConstantForceMix  = kwargs.pop("stop1ConstantForceMix", 0.001)
        self.__stop1ConstantForceMix = stop1ConstantForceMix
        stop1ErrorCorrection  = kwargs.pop("stop1ErrorCorrection", 0.8)
        self.__stop1ErrorCorrection = stop1ErrorCorrection
        suspensionErrorCorrection  = kwargs.pop("suspensionErrorCorrection", 0.8)
        self.__suspensionErrorCorrection = suspensionErrorCorrection
        suspensionForce  = kwargs.pop("suspensionForce", 0)
        self.__suspensionForce = suspensionForce
        DEF  = kwargs.pop("DEF", None)
        self.__DEF = DEF
        USE  = kwargs.pop("USE", None)
        self.__USE = USE
        class_  = kwargs.pop("class_", None)
        self.__class_ = class_
    @property
    def anchorPoint(self):
        return self.__anchorPoint
    @anchorPoint.setter
    def anchorPoint(self, value = [0, 0, 0]):
        self.__anchorPoint = [value]
    def setAnchorPoint(self, anchorPoint = [0, 0, 0]):
        self.__anchorPoint = [anchorPoint]
        return self
    def addAnchorPoint(self, anchorPoint = [0, 0, 0]):
        if self.__anchorPoint == None:            self.__anchorPoint =  []
        self.__anchorPoint +=  [anchorPoint]
        return self
    def removeAnchorPoint(self, anchorPoint):
        self.__anchorPoint = [x for x in self.__anchorPoint if x not in anchorPoint]
        return self.__anchorPoint
    def getAnchorPoint(self, anchorPoint = [0, 0, 0]):
        return self.__anchorPoint
    def anchorPoint_changed(self, anchorPoint = [0, 0, 0]):
        return self.__anchorPoint
    @property
    def axis1(self):
        return self.__axis1
    @axis1.setter
    def axis1(self, value = [0, 0, 0]):
        self.__axis1 = [value]
    def setAxis1(self, axis1 = [0, 0, 0]):
        self.__axis1 = [axis1]
        return self
    def addAxis1(self, axis1 = [0, 0, 0]):
        if self.__axis1 == None:            self.__axis1 =  []
        self.__axis1 +=  [axis1]
        return self
    def removeAxis1(self, axis1):
        self.__axis1 = [x for x in self.__axis1 if x not in axis1]
        return self.__axis1
    def getAxis1(self, axis1 = [0, 0, 0]):
        return self.__axis1
    def axis1_changed(self, axis1 = [0, 0, 0]):
        return self.__axis1
    @property
    def axis2(self):
        return self.__axis2
    @axis2.setter
    def axis2(self, value = [0, 0, 0]):
        self.__axis2 = [value]
    def setAxis2(self, axis2 = [0, 0, 0]):
        self.__axis2 = [axis2]
        return self
    def addAxis2(self, axis2 = [0, 0, 0]):
        if self.__axis2 == None:            self.__axis2 =  []
        self.__axis2 +=  [axis2]
        return self
    def removeAxis2(self, axis2):
        self.__axis2 = [x for x in self.__axis2 if x not in axis2]
        return self.__axis2
    def getAxis2(self, axis2 = [0, 0, 0]):
        return self.__axis2
    def axis2_changed(self, axis2 = [0, 0, 0]):
        return self.__axis2
    @property
    def body1(self):
        return self.__body1
    @body1.setter
    def body1(self, value = None):
        self.__body1 = [value]
    def setBody1(self, body1 = None):
        self.__body1 = [body1]
        return self
    def addBody1(self, body1 = None):
        if self.__body1 == None:            self.__body1 =  []
        self.__body1 +=  [body1]
        return self
    def removeBody1(self, body1):
        self.__body1 = [x for x in self.__body1 if x not in body1]
        return self.__body1
    def getBody1(self, body1 = None):
        return self.__body1
    def body1_changed(self, body1 = None):
        return self.__body1
    def removeBody1AnchorPoint(self, body1AnchorPoint):
        self.__body1AnchorPoint = [x for x in self.__body1AnchorPoint if x not in body1AnchorPoint]
        return self.__body1AnchorPoint
    def getBody1AnchorPoint(self, body1AnchorPoint = None):
        return self.__body1AnchorPoint
    def body1AnchorPoint_changed(self, body1AnchorPoint = None):
        return self.__body1AnchorPoint
    def removeBody1Axis(self, body1Axis):
        self.__body1Axis = [x for x in self.__body1Axis if x not in body1Axis]
        return self.__body1Axis
    def getBody1Axis(self, body1Axis = None):
        return self.__body1Axis
    def body1Axis_changed(self, body1Axis = None):
        return self.__body1Axis
    @property
    def body2(self):
        return self.__body2
    @body2.setter
    def body2(self, value = None):
        self.__body2 = [value]
    def setBody2(self, body2 = None):
        self.__body2 = [body2]
        return self
    def addBody2(self, body2 = None):
        if self.__body2 == None:            self.__body2 =  []
        self.__body2 +=  [body2]
        return self
    def removeBody2(self, body2):
        self.__body2 = [x for x in self.__body2 if x not in body2]
        return self.__body2
    def getBody2(self, body2 = None):
        return self.__body2
    def body2_changed(self, body2 = None):
        return self.__body2
    def removeBody2AnchorPoint(self, body2AnchorPoint):
        self.__body2AnchorPoint = [x for x in self.__body2AnchorPoint if x not in body2AnchorPoint]
        return self.__body2AnchorPoint
    def getBody2AnchorPoint(self, body2AnchorPoint = None):
        return self.__body2AnchorPoint
    def body2AnchorPoint_changed(self, body2AnchorPoint = None):
        return self.__body2AnchorPoint
    def removeBody2Axis(self, body2Axis):
        self.__body2Axis = [x for x in self.__body2Axis if x not in body2Axis]
        return self.__body2Axis
    def getBody2Axis(self, body2Axis = None):
        return self.__body2Axis
    def body2Axis_changed(self, body2Axis = None):
        return self.__body2Axis
    @property
    def desiredAngularVelocity1(self):
        return self.__desiredAngularVelocity1
    @desiredAngularVelocity1.setter
    def desiredAngularVelocity1(self, value = 0):
        self.__desiredAngularVelocity1 = [value]
    def setDesiredAngularVelocity1(self, desiredAngularVelocity1 = 0):
        self.__desiredAngularVelocity1 = [desiredAngularVelocity1]
        return self
    def addDesiredAngularVelocity1(self, desiredAngularVelocity1 = 0):
        if self.__desiredAngularVelocity1 == None:            self.__desiredAngularVelocity1 =  []
        self.__desiredAngularVelocity1 +=  [desiredAngularVelocity1]
        return self
    def removeDesiredAngularVelocity1(self, desiredAngularVelocity1):
        self.__desiredAngularVelocity1 = [x for x in self.__desiredAngularVelocity1 if x not in desiredAngularVelocity1]
        return self.__desiredAngularVelocity1
    def getDesiredAngularVelocity1(self, desiredAngularVelocity1 = 0):
        return self.__desiredAngularVelocity1
    def desiredAngularVelocity1_changed(self, desiredAngularVelocity1 = 0):
        return self.__desiredAngularVelocity1
    @property
    def desiredAngularVelocity2(self):
        return self.__desiredAngularVelocity2
    @desiredAngularVelocity2.setter
    def desiredAngularVelocity2(self, value = 0):
        self.__desiredAngularVelocity2 = [value]
    def setDesiredAngularVelocity2(self, desiredAngularVelocity2 = 0):
        self.__desiredAngularVelocity2 = [desiredAngularVelocity2]
        return self
    def addDesiredAngularVelocity2(self, desiredAngularVelocity2 = 0):
        if self.__desiredAngularVelocity2 == None:            self.__desiredAngularVelocity2 =  []
        self.__desiredAngularVelocity2 +=  [desiredAngularVelocity2]
        return self
    def removeDesiredAngularVelocity2(self, desiredAngularVelocity2):
        self.__desiredAngularVelocity2 = [x for x in self.__desiredAngularVelocity2 if x not in desiredAngularVelocity2]
        return self.__desiredAngularVelocity2
    def getDesiredAngularVelocity2(self, desiredAngularVelocity2 = 0):
        return self.__desiredAngularVelocity2
    def desiredAngularVelocity2_changed(self, desiredAngularVelocity2 = 0):
        return self.__desiredAngularVelocity2
    @property
    def forceOutput(self):
        return self.__forceOutput
    @forceOutput.setter
    def forceOutput(self, value = ["NONE"]):
        self.__forceOutput = [value]
    def setForceOutput(self, forceOutput = ["NONE"]):
        self.__forceOutput = [forceOutput]
        return self
    def addForceOutput(self, forceOutput = ["NONE"]):
        if self.__forceOutput == None:            self.__forceOutput =  []
        self.__forceOutput +=  [forceOutput]
        return self
    def removeForceOutput(self, forceOutput):
        self.__forceOutput = [x for x in self.__forceOutput if x not in forceOutput]
        return self.__forceOutput
    def getForceOutput(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    def forceOutput_changed(self, forceOutput = ["NONE"]):
        return self.__forceOutput
    def removeHinge1Angle(self, hinge1Angle):
        self.__hinge1Angle = [x for x in self.__hinge1Angle if x not in hinge1Angle]
        return self.__hinge1Angle
    def getHinge1Angle(self, hinge1Angle = None):
        return self.__hinge1Angle
    def hinge1Angle_changed(self, hinge1Angle = None):
        return self.__hinge1Angle
    def removeHinge1AngleRate(self, hinge1AngleRate):
        self.__hinge1AngleRate = [x for x in self.__hinge1AngleRate if x not in hinge1AngleRate]
        return self.__hinge1AngleRate
    def getHinge1AngleRate(self, hinge1AngleRate = None):
        return self.__hinge1AngleRate
    def hinge1AngleRate_changed(self, hinge1AngleRate = None):
        return self.__hinge1AngleRate
    def removeHinge2Angle(self, hinge2Angle):
        self.__hinge2Angle = [x for x in self.__hinge2Angle if x not in hinge2Angle]
        return self.__hinge2Angle
    def getHinge2Angle(self, hinge2Angle = None):
        return self.__hinge2Angle
    def hinge2Angle_changed(self, hinge2Angle = None):
        return self.__hinge2Angle
    def removeHinge2AngleRate(self, hinge2AngleRate):
        self.__hinge2AngleRate = [x for x in self.__hinge2AngleRate if x not in hinge2AngleRate]
        return self.__hinge2AngleRate
    def getHinge2AngleRate(self, hinge2AngleRate = None):
        return self.__hinge2AngleRate
    def hinge2AngleRate_changed(self, hinge2AngleRate = None):
        return self.__hinge2AngleRate
    @property
    def maxAngle1(self):
        return self.__maxAngle1
    @maxAngle1.setter
    def maxAngle1(self, value = 3.141592653):
        self.__maxAngle1 = [value]
    def setMaxAngle1(self, maxAngle1 = 3.141592653):
        self.__maxAngle1 = [maxAngle1]
        return self
    def addMaxAngle1(self, maxAngle1 = 3.141592653):
        if self.__maxAngle1 == None:            self.__maxAngle1 =  []
        self.__maxAngle1 +=  [maxAngle1]
        return self
    def removeMaxAngle1(self, maxAngle1):
        self.__maxAngle1 = [x for x in self.__maxAngle1 if x not in maxAngle1]
        return self.__maxAngle1
    def getMaxAngle1(self, maxAngle1 = 3.141592653):
        return self.__maxAngle1
    def maxAngle1_changed(self, maxAngle1 = 3.141592653):
        return self.__maxAngle1
    @property
    def maxTorque1(self):
        return self.__maxTorque1
    @maxTorque1.setter
    def maxTorque1(self, value = 0):
        self.__maxTorque1 = [value]
    def setMaxTorque1(self, maxTorque1 = 0):
        self.__maxTorque1 = [maxTorque1]
        return self
    def addMaxTorque1(self, maxTorque1 = 0):
        if self.__maxTorque1 == None:            self.__maxTorque1 =  []
        self.__maxTorque1 +=  [maxTorque1]
        return self
    def removeMaxTorque1(self, maxTorque1):
        self.__maxTorque1 = [x for x in self.__maxTorque1 if x not in maxTorque1]
        return self.__maxTorque1
    def getMaxTorque1(self, maxTorque1 = 0):
        return self.__maxTorque1
    def maxTorque1_changed(self, maxTorque1 = 0):
        return self.__maxTorque1
    @property
    def maxTorque2(self):
        return self.__maxTorque2
    @maxTorque2.setter
    def maxTorque2(self, value = 0):
        self.__maxTorque2 = [value]
    def setMaxTorque2(self, maxTorque2 = 0):
        self.__maxTorque2 = [maxTorque2]
        return self
    def addMaxTorque2(self, maxTorque2 = 0):
        if self.__maxTorque2 == None:            self.__maxTorque2 =  []
        self.__maxTorque2 +=  [maxTorque2]
        return self
    def removeMaxTorque2(self, maxTorque2):
        self.__maxTorque2 =