/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.TextureProjection;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;

/**
 * TextureProjector is similar to a light that projects a texture into the scene, illuminating geometry that intersects the perspective projection volume.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 4.0 draft) [X3DTextureProjectorNode] TextureProjector is similar to a light that projects a texture into the scene, illuminating geometry that intersects the perspective projection volume.
Hint: &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Images/ptmperspective.png" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Images/ptmperspective.png&lt;/a&gt;
Warning: add textureTransform field?  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#TextureProjector" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/textureProjector.html#TextureProjector" target="blank">X3D Abstract Specification: TextureProjector</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#TextureProjector" target="_blank">X3D Tooltips: TextureProjector</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank">X3D Scene Authoring Hints: Images</a>
 */
public interface TextureProjector extends  org.web3d.x3d.sai.TextureProjection.X3DTextureProjectorNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Brightness of ambient (nondirectional background) emission from the light. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of ambientIntensity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=AmbientIntensity, $memberObjectName=ambientIntensity, $memberObjectName=ambientIntensity)

	public float getAmbientIntensity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Brightness of ambient (nondirectional background) emission from the light. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the ambientIntensity field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setAmbientIntensity(float newValue);

	/**
	 * Provide float value within allowed range of (0,infinity) from outputOnly SFFloat field named <i>aspectRatio</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  aspectRatio is the ratio of width and height that is projected.  * <br>

	 * @return value of aspectRatio field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=AspectRatio, $memberObjectName=aspectRatio, $memberObjectName=aspectRatio)

	public float getAspectRatio();
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>color</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] color of light, applied to colors of objects. Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;  * <br>

	 * @return value of color field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Color, $memberObjectName=color, $memberObjectName=color)

	public float[] getColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>color</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] color of light, applied to colors of objects. Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;  * <br>

	 * @param newValue is new value for the color field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setColor(float[] newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setDescription(String newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Direction for projection.  * <br>

	 * @return value of direction field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Direction, $memberObjectName=direction, $memberObjectName=direction)

	public float[] getDirection();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>direction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Direction for projection.  * <br>

	 * @param newValue is new value for the direction field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setDirection(float[] newValue);

	/**
	 * Provide float value within allowed range of [-1,infinity) from inputOutput SFFloat field named <i>farDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or (0,+infinity) maximum distance necessary for texture display.  * <br>

	 * @return value of farDistance field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=FarDistance, $memberObjectName=farDistance, $memberObjectName=farDistance)

	public float getFarDistance();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>farDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or (0,+infinity) maximum distance necessary for texture display.  * <br>

	 * @param newValue is new value for the farDistance field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setFarDistance(float newValue);

	/**
	 * Provide float value within allowed range of [0,3.1416] from inputOutput SFFloat field named <i>fieldOfView</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Preferred minimum viewing angle for this projection in radians, providing minimum height or minimum width (whichever is smaller). Small field of view roughly corresponds to a telephoto lens, large field of view roughly corresponds to a wide-angle lens. Warning: this field differs for TextureProjectorParallel and TextureProjector.  * <br>

	 * @return value of fieldOfView field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=FieldOfView, $memberObjectName=fieldOfView, $memberObjectName=fieldOfView)
	public float getFieldOfView();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>fieldOfView</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Preferred minimum viewing angle for this projection in radians, providing minimum height or minimum width (whichever is smaller). Small field of view roughly corresponds to a telephoto lens, large field of view roughly corresponds to a wide-angle lens. Warning: this field differs for TextureProjectorParallel and TextureProjector.  * <br>

	 * @param newValue is new value for the fieldOfView field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public TextureProjector setFieldOfView(float newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>global</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Global texture projection illuminates all objects within their volume of influence. Scoped texture projection (global false) only illuminates objects within the same transformation hierarchy.  * <br>

	 * @return value of global field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Global, $memberObjectName=global, $memberObjectName=global)

	public boolean getGlobal();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>global</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Global texture projection illuminates all objects within their volume of influence. Scoped texture projection (global false) only illuminates objects within the same transformation hierarchy.  * <br>

	 * @param newValue is new value for the global field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setGlobal(boolean newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Brightness of direct emission from the light.  * <br>

	 * @return value of intensity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Intensity, $memberObjectName=intensity, $memberObjectName=intensity)

	public float getIntensity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>intensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Brightness of direct emission from the light.  * <br>

	 * @param newValue is new value for the intensity field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setIntensity(float newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Position of center of texture projection relative to local coordinate system.  * <br>

	 * @return value of location field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Location, $memberObjectName=location, $memberObjectName=location)

	public float[] getLocation();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>location</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Position of center of texture projection relative to local coordinate system.  * <br>

	 * @param newValue is new value for the location field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setLocation(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [-1,infinity) from inputOutput SFFloat field named <i>nearDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or (0,+infinity) minimum distance necessary for texture display.  * <br>

	 * @return value of nearDistance field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=NearDistance, $memberObjectName=nearDistance, $memberObjectName=nearDistance)

	public float getNearDistance();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>nearDistance</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or (0,+infinity) minimum distance necessary for texture display.  * <br>

	 * @param newValue is new value for the nearDistance field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setNearDistance(float newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>on</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables this texture projection source.  * <br>

	 * @return value of on field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=On, $memberObjectName=on, $memberObjectName=on)

	public boolean getOn();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>on</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables this texture projection source.  * <br>

	 * @param newValue is new value for the on field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setOn(boolean newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>shadowIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] shadowIntensity field defines how much light is obscured by shapes that cast shadows, ranging from 0 (light not obscured, no visible shadows) to 1 (light completely obscured, full-intensity shadows).  * <br>

	 * @return value of shadowIntensity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=ShadowIntensity, $memberObjectName=shadowIntensity, $memberObjectName=shadowIntensity)

	public float getShadowIntensity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>shadowIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] shadowIntensity field defines how much light is obscured by shapes that cast shadows, ranging from 0 (light not obscured, no visible shadows) to 1 (light completely obscured, full-intensity shadows).  * <br>

	 * @param newValue is new value for the shadowIntensity field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setShadowIntensity(float newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>shadows</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  shadows field indicates whether or not this light casts a shadow behind illuminated X3DShapeNode geometry.  * <br>

	 * @return value of shadows field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Shadows, $memberObjectName=shadows, $memberObjectName=shadows)

	public boolean getShadows();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>shadows</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  shadows field indicates whether or not this light casts a shadow behind illuminated X3DShapeNode geometry.  * <br>

	 * @param newValue is new value for the shadows field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setShadows(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) from inputOutput SFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @return value of texture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=Texture, $memberObjectName=texture, $memberObjectName=texture)

	public  org.web3d.x3d.sai.Texturing.X3DTexture2DNode getTexture(); // acceptable node types #1: X3DTexture2DNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTexture2DNode instance (using a properly typed node) to inputOutput SFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @param newValue is new value for the texture field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public TextureProjector setTexture( org.web3d.x3d.sai.Texturing.X3DTexture2DNode newValue); // acceptable node types #2: X3DTexture2DNode

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>upVector</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  upVector describes the roll of the camera by saying which direction is up for the camera's orientation.  * <br>

	 * @return value of upVector field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureProjectorNode, $additionalInheritanceBaseType=, $thisClassName=TextureProjector, $CamelCaseName=UpVector, $memberObjectName=upVector, $memberObjectName=upVector)
	public float[] getUpVector();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>upVector</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  upVector describes the roll of the camera by saying which direction is up for the camera's orientation.  * <br>

	 * @param newValue is new value for the upVector field.
	 * @return {@link TextureProjector} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public TextureProjector setUpVector(float[] newValue);

}
