/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Shape.*;
// import org.web3d.x3d.sai.Shaders.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
import java.util.Arrays;

/**
 * Appearance specifies the visual properties of geometry by containing the Material, ImageTexture/MovieTexture/PixelTexture, FillProperties, LineProperties, programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) and TextureTransform nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DAppearanceNode] Appearance specifies the visual properties of geometry
by containing the Material, ImageTexture/MovieTexture/PixelTexture, FillProperties, LineProperties, programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) and TextureTransform nodes.
Hint: insert a Shape node before adding geometry or Appearance.
Interchange profile hint: only Material and ImageTexture children are allowed.
Hint: DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene.
Hint: 
Advanced uses can contain MultiTexture, MultiTextureTransform/TextureTransformMatrix3D/TextureTransform3D, ComposedShader/PackagedShader/ProgramShader, ComposedTexture3D/ImageTexture3D/PixelTexture3D, or ComposedCubeMapTexture/GeneratedCubeMapTexture/ImageCubeMapTexture.
Hint: X3D Architecture 12.2.2 Appearance node &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shape.html#Appearancenode" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shape.html#Appearancenode&lt;/a&gt;
Hint: X3D Architecture 17.2.2 Lighting model &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#Appearance" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#Appearance" target="blank">X3D Abstract Specification: Appearance</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Appearance" target="_blank">X3D Tooltips: Appearance</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface Appearance extends  org.web3d.x3d.sai.Shape.X3DAppearanceNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide  org.web3d.x3d.sai.Shape.AcousticProperties instance (using a properly typed node) from inputOutput SFNode field <i>acousticProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [AcousticProperties] Single contained acousticProperties node that can specify additional acoustic attributes applied to associated surface geometry.  * <br>

	 * @return value of acousticProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AcousticProperties, $memberObjectName=acousticProperties, $memberObjectName=acousticProperties)
	public  org.web3d.x3d.sai.Shape.AcousticProperties getAcousticProperties(); // acceptable node types #1: AcousticProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.AcousticProperties instance (using a properly typed node) to inputOutput SFNode field <i>acousticProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [AcousticProperties] Single contained acousticProperties node that can specify additional acoustic attributes applied to associated surface geometry.  * <br>

	 * @param newValue is new value for the acousticProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAcousticProperties( org.web3d.x3d.sai.Shape.AcousticProperties newValue); // acceptable node types #2: AcousticProperties

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>alphaCutoff</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Threshold value used for pixel rendering either transparent or opaque, used when alphaMode="MASK". Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @return value of alphaCutoff field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AlphaCutoff, $memberObjectName=alphaCutoff, $memberObjectName=alphaCutoff)
	public float getAlphaCutoff();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>alphaCutoff</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Threshold value used for pixel rendering either transparent or opaque, used when alphaMode="MASK". Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @param newValue is new value for the alphaCutoff field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAlphaCutoff(float newValue);

	/**
	 * Provide String enumeration value (baseType SFString) ["AUTO" | "OPAQUE" | "MASK" | "BLEND"] from inputOutput SFString field named <i>alphaMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Provides options for control of alpha transparency handling for textures. AUTO means Material transparency is applied to texture transparency for full backwards compatility with X3D3, OPAQUE means ignore alpha transparency to render texture as opaque, MASK means alpha-testing of pixels as fully transparent when alpha value is less than alphaCutoff and fully opaque when alpha value is greater than or equal to alphaCutoff, BLEND combines partial transparency of textures and materials. Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @return value of alphaMode field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AlphaMode, $memberObjectName=alphaMode, $memberObjectName=alphaMode)
	public String getAlphaMode();

	/**
	 * Accessor method to assign String enumeration value ("AUTO" | "OPAQUE" | "MASK" | "BLEND") to inputOutput SFString field named <i>alphaMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Provides options for control of alpha transparency handling for textures. AUTO means Material transparency is applied to texture transparency for full backwards compatility with X3D3, OPAQUE means ignore alpha transparency to render texture as opaque, MASK means alpha-testing of pixels as fully transparent when alpha value is less than alphaCutoff and fully opaque when alpha value is greater than or equal to alphaCutoff, BLEND combines partial transparency of textures and materials. Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @param newValue is new value for the alphaMode field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAlphaMode(String newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Shape.FillProperties instance (using a properly typed node) from inputOutput SFNode field <i>fillProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [FillProperties] Single contained FillProperties node that can specify additional visual attributes applied to polygonal areas of corresponding geometry, on top of whatever other appearance is already defined.  * <br>

	 * @return value of fillProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=FillProperties, $memberObjectName=fillProperties, $memberObjectName=fillProperties)
	public  org.web3d.x3d.sai.Shape.FillProperties getFillProperties(); // acceptable node types #1: FillProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.FillProperties instance (using a properly typed node) to inputOutput SFNode field <i>fillProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [FillProperties] Single contained FillProperties node that can specify additional visual attributes applied to polygonal areas of corresponding geometry, on top of whatever other appearance is already defined.  * <br>

	 * @param newValue is new value for the fillProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setFillProperties( org.web3d.x3d.sai.Shape.FillProperties newValue); // acceptable node types #2: FillProperties

	/**
	 * Provide  org.web3d.x3d.sai.Shape.LineProperties instance (using a properly typed node) from inputOutput SFNode field <i>lineProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained LineProperties node that can specify additional visual attributes applied to corresponding line geometry.  * <br>

	 * @return value of lineProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=LineProperties, $memberObjectName=lineProperties, $memberObjectName=lineProperties)
	public  org.web3d.x3d.sai.Shape.LineProperties getLineProperties(); // acceptable node types #1: LineProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.LineProperties instance (using a properly typed node) to inputOutput SFNode field <i>lineProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained LineProperties node that can specify additional visual attributes applied to corresponding line geometry.  * <br>

	 * @param newValue is new value for the lineProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setLineProperties( org.web3d.x3d.sai.Shape.LineProperties newValue); // acceptable node types #2: LineProperties

	/**
	 * Provide  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) from inputOutput SFNode field <i>material</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Single contained Material node that can specify visual attributes for lighting response (color types, transparency, etc.) applied to corresponding geometry. Warning: if material is NULL or unspecified, lighting is off (all lights ignored) for this Shape and unlit object color is (1, 1, 1).  * <br>

	 * @return value of material field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Material, $memberObjectName=material, $memberObjectName=material)
	public  org.web3d.x3d.sai.Shape.X3DMaterialNode getMaterial(); // acceptable node types #1: X3DMaterialNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) to inputOutput SFNode field <i>material</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Single contained Material node that can specify visual attributes for lighting response (color types, transparency, etc.) applied to corresponding geometry. Warning: if material is NULL or unspecified, lighting is off (all lights ignored) for this Shape and unlit object color is (1, 1, 1).  * <br>

	 * @param newValue is new value for the material field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setMaterial( org.web3d.x3d.sai.Shape.X3DMaterialNode newValue); // acceptable node types #2: X3DMaterialNode

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide  org.web3d.x3d.sai.Shape.PointProperties instance (using a properly typed node) from inputOutput SFNode field <i>pointProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained PointProperties node that can specify additional visual attributes applied to corresponding point geometry.  * <br>

	 * @return value of pointProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=PointProperties, $memberObjectName=pointProperties, $memberObjectName=pointProperties)
	public  org.web3d.x3d.sai.Shape.PointProperties getPointProperties(); // acceptable node types #1: PointProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.PointProperties instance (using a properly typed node) to inputOutput SFNode field <i>pointProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained PointProperties node that can specify additional visual attributes applied to corresponding point geometry.  * <br>

	 * @param newValue is new value for the pointProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setPointProperties( org.web3d.x3d.sai.Shape.PointProperties newValue); // acceptable node types #2: PointProperties

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>shaders</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DShaderNode] Zero or more contained programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) that specify, in order of preference, author-programmed rendering characteristics. Hint: X3D Architecture 31 Programmable shaders component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @see org.web3d.x3d.sai.Shaders.X3DShaderNode
	 * @return value of shaders field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Shaders, $memberObjectName=shaders, $memberObjectName=shaders)
	public org.web3d.x3d.sai.Core.X3DNode[] getShaders(); // acceptable node types #1: X3DShaderNode

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>shaders</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DShaderNode] Zero or more contained programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) that specify, in order of preference, author-programmed rendering characteristics. Hint: X3D Architecture 31 Programmable shaders component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @param newValue is new value for the shaders field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setShaders(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: X3DShaderNode

	/**
	 * Add array of child shaders nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @param newValue is new value array to be appended the shaders field.
	 */
	public void addShaders(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: X3DShaderNode
	/**
	 * Set single child shaders node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the shaders field
	 */
	public void setShaders(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: X3DShaderNode
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @return value of texture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Texture, $memberObjectName=texture, $memberObjectName=texture)
	public  org.web3d.x3d.sai.Texturing.X3DTextureNode getTexture(); // acceptable node types #1: X3DTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @param newValue is new value for the texture field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setTexture( org.web3d.x3d.sai.Texturing.X3DTextureNode newValue); // acceptable node types #2: X3DTextureNode

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode instance (using a properly typed node) from inputOutput SFNode field <i>textureTransform</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureTransformNode] Single contained TextureTransform node that defines 2D transformation applied to texture coordinates. Hint: Texture coordinates are reapplied (or else recomputed if textureTransform field initially NULL) whenever the corresponding vertex-based geometry changes. Hint: if textureTransform array is empty, then this field has no effect.  * <br>

	 * @return value of textureTransform field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=TextureTransform, $memberObjectName=textureTransform, $memberObjectName=textureTransform)
	public  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode getTextureTransform(); // acceptable node types #1: X3DTextureTransformNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode instance (using a properly typed node) to inputOutput SFNode field <i>textureTransform</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureTransformNode] Single contained TextureTransform node that defines 2D transformation applied to texture coordinates. Hint: Texture coordinates are reapplied (or else recomputed if textureTransform field initially NULL) whenever the corresponding vertex-based geometry changes. Hint: if textureTransform array is empty, then this field has no effect.  * <br>

	 * @param newValue is new value for the textureTransform field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setTextureTransform( org.web3d.x3d.sai.Texturing.X3DTextureTransformNode newValue); // acceptable node types #2: X3DTextureTransformNode

}
