/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shaders;
// import org.web3d.x3d.sai.Networking.X3DUrlObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * ShaderPart can contain a CDATA section of plain-text source code.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.1 or later) [X3DNode,X3DUrlObject] ShaderPart defines the source for a portion of source code used by a ComposedShader node.
The source is not required to be a complete shader for all of the vertex/fragment processing.
 Hint: ShaderPart can contain a CDATA block of plain-text source code.
Hint: embedded ecmascript: source can also be contained in the sourceCode pseudo-field without escape characters, equivalent to last entry in the url list, when using other API codebases and file encodings.
Warning: ShaderPart contains no field declarations.
Hint: insert an XML Character Data (CDATA) block within the Script node to contain source code embedded within an X3D scene, avoiding the need for escape characters.
Hint: a contained XML Character Data (CDATA) block for source code  protects whitespace, line breaks, and literal characters (such as &amp; for ampersand character, &amp;lt; for less-than-sign character, and &amp;gt; for greater-than-sign character) from unintended escape-character modifications by XML parsers.
Warning: strict order is required for contained constructs: first field declarations (if any), then IS/connect statements (if any), and finally CDATA source-code block.
Hint: ShaderPart subprograms are written in the same language, which is specified in the parent ComposedShader node.
Hint: when parent node is LoadSensor, apply containerField='children' (X3Dv4) or containerField='watchList' (X3Dv3). &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#ShaderPart" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shaders.html#ShaderPart" target="blank">X3D Abstract Specification: ShaderPart</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#ShaderPart" target="_blank">X3D Tooltips: ShaderPart</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface ShaderPart extends  org.web3d.x3d.sai.Core.X3DNode,  org.web3d.x3d.sai.Networking.X3DUrlObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefresh field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=AutoRefresh, $memberObjectName=autoRefresh, $memberObjectName=autoRefresh)

	public double getAutoRefresh();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setAutoRefresh(double newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefreshTimeLimit field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=AutoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit)

	public double getAutoRefreshTimeLimit();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setAutoRefreshTimeLimit(double newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setDescription(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @return value of load field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=Load, $memberObjectName=load, $memberObjectName=load)

	public boolean getLoad();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @param newValue is new value for the load field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setLoad(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide String value from inputOutput SFString field named <i>sourceCode</i>.
	 * @return value of sourceCode field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=SourceCode, $memberObjectName=sourceCode, $memberObjectName=sourceCode)
	public String getSourceCode();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>sourceCode</i>.
	 * @param newValue is new value for the sourceCode field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShaderPart setSourceCode(String newValue);

	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["VERTEX" | "FRAGMENT" | 'etc.'] from initializeOnly SFString field named <i>type</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  type indicates whether this ShaderProgram is a vertex or fragment (pixel) shader. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @return value of type field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=Type, $memberObjectName=type, $memberObjectName=type)
	public String getType();

	/**
	 * Accessor method to assign String enumeration value ("VERTEX" | "FRAGMENT") to initializeOnly SFString field named <i>type</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  type indicates whether this ShaderProgram is a vertex or fragment (pixel) shader. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @param newValue is new value for the type field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ShaderPart setType(String newValue);

	/**
	 * Provide array of String results from inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Location and filename of shader. Multiple locations are more reliable, and including a Web address lets e-mail attachments work. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt; Hint: embedded ecmascript: source can also be contained in the sourceCode pseudo-field without escape characters, equivalent to last entry in the url list, when using other API codebases and file encodings.  * <br>

	 * @return value of url field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=ShaderPart, $CamelCaseName=Url, $memberObjectName=url, $memberObjectName=url)

	public String[] getUrl();

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Location and filename of shader. Multiple locations are more reliable, and including a Web address lets e-mail attachments work. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt; Hint: embedded ecmascript: source can also be contained in the sourceCode pseudo-field without escape characters, equivalent to last entry in the url list, when using other API codebases and file encodings.  * <br>

	 * @param newValue is new value for the url field.
	 * @return {@link ShaderPart} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ShaderPart setUrl(String[] newValue);

}
