/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.ParticleSystems;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Rendering.*;

/**
 * SurfaceEmitter generates particles from the surface of an object.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.2 or later) [X3DParticleEmitterNode] SurfaceEmitter generates particles from the surface of an object. New particles are generated by first randomly choosing a face on the tessellated geometry and then a random position on that face. Particles are generated with an initial direction of the normal to that point (including any normal averaging due to normalPerVertex and creaseAngle field settings).
Hint: ff surface is not solid (solid=false), randomly choose from which side of the surface to emit, negating the normal direction when generating from the back side.
Warning: only valid geometry shall be used.  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#SurfaceEmitter" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/particleSystems.html#SurfaceEmitter" target="blank">X3D Abstract Specification: SurfaceEmitter</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#SurfaceEmitter" target="_blank">X3D Tooltips: SurfaceEmitter</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface SurfaceEmitter extends  org.web3d.x3d.sai.ParticleSystems.X3DParticleEmitterNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of int results within allowed range of [-1,infinity) from initializeOnly MFInt32 field named <i>coordIndex</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [-1,+infinity) coordIndex indices are applied to contained Coordinate values in order to define randomly generated initial geometry of the particles. Warning: coordIndex is required in order to connect contained coordinate point values.  * <br>

	 * @return value of coordIndex field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=CoordIndex, $memberObjectName=coordIndex, $memberObjectName=coordIndex)
	public int[] getCoordIndex();

	/**
	 * Accessor method to assign int array to initializeOnly MFInt32 field named <i>coordIndex</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [-1,+infinity) coordIndex indices are applied to contained Coordinate values in order to define randomly generated initial geometry of the particles. Warning: coordIndex is required in order to connect contained coordinate point values.  * <br>

	 * @param newValue is new value for the coordIndex field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SurfaceEmitter setCoordIndex(int[] newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>mass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Basic mass of each particle, defined in mass base units (default is kilograms). Hint: mass is needed if gravity or other force-related calculations are performed on a per-particle basis. Hint: &lt;a href="https://en.wikipedia.org/wiki/Kilogram" target="_blank"&gt;https://en.wikipedia.org/wiki/Kilogram&lt;/a&gt; Hint: X3D Architecture 4.3.6 Standard units and coordinate system &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates&lt;/a&gt;  * <br>

	 * @return value of mass field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=Mass, $memberObjectName=mass, $memberObjectName=mass)

	public float getMass();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>mass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Basic mass of each particle, defined in mass base units (default is kilograms). Hint: mass is needed if gravity or other force-related calculations are performed on a per-particle basis. Hint: &lt;a href="https://en.wikipedia.org/wiki/Kilogram" target="_blank"&gt;https://en.wikipedia.org/wiki/Kilogram&lt;/a&gt; Hint: X3D Architecture 4.3.6 Standard units and coordinate system &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates&lt;/a&gt;  * <br>

	 * @param newValue is new value for the mass field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setMass(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>on</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables production of particles from this emitter node. If operating when turned off, existing particles complete their rendering process.  * <br>

	 * @return value of on field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=On, $memberObjectName=on, $memberObjectName=on)

	public boolean getOn();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>on</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables production of particles from this emitter node. If operating when turned off, existing particles complete their rendering process.  * <br>

	 * @param newValue is new value for the on field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setOn(boolean newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>speed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Initial linear speed (default is m/s) imparted to all particles along their direction of movement.  * <br>

	 * @return value of speed field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=Speed, $memberObjectName=speed, $memberObjectName=speed)

	public float getSpeed();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>speed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Initial linear speed (default is m/s) imparted to all particles along their direction of movement.  * <br>

	 * @param newValue is new value for the speed field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setSpeed(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Rendering.X3DGeometryNode instance (using a properly typed node) from initializeOnly SFNode field <i>surface</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DGeometryNode] The geometry node provides geometry used as the emitting surface. Hint: If the surface is indicated as not being solid (solid field set to false), randomly choose from which side of the surface to emit, negating the normal direction when generating from the back side. Warning: only valid geometry shall be used.  * <br>

	 * @return value of surface field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=Surface, $memberObjectName=surface, $memberObjectName=surface)
	public  org.web3d.x3d.sai.Rendering.X3DGeometryNode getSurface(); // acceptable node types #1: X3DGeometryNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Rendering.X3DGeometryNode instance (using a properly typed node) to initializeOnly SFNode field <i>surface</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DGeometryNode] The geometry node provides geometry used as the emitting surface. Hint: If the surface is indicated as not being solid (solid field set to false), randomly choose from which side of the surface to emit, negating the normal direction when generating from the back side. Warning: only valid geometry shall be used.  * <br>

	 * @param newValue is new value for the surface field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SurfaceEmitter setSurface( org.web3d.x3d.sai.Rendering.X3DGeometryNode newValue); // acceptable node types #2: X3DGeometryNode

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>surfaceArea</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Particle surface area in area base units (default is meters squared). Surface area is used for calculations such as wind effects per particle. Hint: surfaceArea value represents average frontal area presented to the wind. Hint: assumes spherical model for each particle (i.e., surface area is the same regardless of direction).  * <br>

	 * @return value of surfaceArea field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=SurfaceArea, $memberObjectName=surfaceArea, $memberObjectName=surfaceArea)

	public float getSurfaceArea();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>surfaceArea</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Particle surface area in area base units (default is meters squared). Surface area is used for calculations such as wind effects per particle. Hint: surfaceArea value represents average frontal area presented to the wind. Hint: assumes spherical model for each particle (i.e., surface area is the same regardless of direction).  * <br>

	 * @param newValue is new value for the surfaceArea field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setSurfaceArea(float newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>variation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Multiplier for the randomness used to control the range of possible output values. The bigger the value, the more random the output and the bigger the range of possible initial values possible. Hint: variation of zero does not allow any randomness.  * <br>

	 * @return value of variation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParticleEmitterNode, $additionalInheritanceBaseType=, $thisClassName=SurfaceEmitter, $CamelCaseName=Variation, $memberObjectName=variation, $memberObjectName=variation)

	public float getVariation();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>variation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Multiplier for the randomness used to control the range of possible output values. The bigger the value, the more random the output and the bigger the range of possible initial values possible. Hint: variation of zero does not allow any randomness.  * <br>

	 * @param newValue is new value for the variation field.
	 * @return {@link SurfaceEmitter} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SurfaceEmitter setVariation(float newValue);

}
