/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Networking;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Networking.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * LoadSensor generates events as watchList child nodes are either loaded or fail to load.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DNetworkSensorNode] LoadSensor generates events as watchList child nodes are either loaded or fail to load. Changing watchlist child nodes restarts the LoadSensor.
Hint: use multiple LoadSensor nodes to track multiple loading nodes individually.
Hint: Background node is not sensed by LoadSensor due to node typing and  multiple-image ambiguity, alternatively utilize TextureBackground node with multiple ImageTexture nodes each referenced inside LoadSensor.
Warning: children (watchList) child nodes are not rendered, so normally USE copies of other nodes to sense load status.
Hint: use Inline 'load' field to prompt or defer loading.
Warning: new X3D node, not supported in VRML97.
Hint: example scenes and authoring assets at &lt;a href="https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter12EnvironmentSensorSound" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dForWebAuthors/Chapter12EnvironmentSensorSound&lt;/a&gt;
Warning: 'children' field originally named 'watchList' in X3Dv3. &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#LoadSensor" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/networking.html#LoadSensor" target="blank">X3D Abstract Specification: LoadSensor</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#LoadSensor" target="_blank">X3D Tooltips: LoadSensor</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface LoadSensor extends  org.web3d.x3d.sai.Networking.X3DNetworkSensorNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DUrlObject] The children field monitors one or more USE nodes that contain a valid url field. Warning: field originally named 'watchList' in X3Dv3. &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges&lt;/a&gt; Hint: if watchList contains multiple USE nodes, output events are only generated when all children have loaded successfully or at least one node has failed. Hint: if individual load status information is desired for different nodes, multiple LoadSensor nodes may be used, each with a single watchList element. Hint: Anchor nodes can be monitored for binding a target Viewpoint, loading a new scene, or loading a new scene in a new window.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DUrlObject.
	 * @see org.web3d.x3d.sai.Networking.X3DUrlObject
	 * @return value of children field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=Children, $memberObjectName=children, $memberObjectName=children)
	public org.web3d.x3d.sai.Core.X3DNode[] getChildren(); // acceptable node types #1: X3DUrlObject

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DUrlObject] The children field monitors one or more USE nodes that contain a valid url field. Warning: field originally named 'watchList' in X3Dv3. &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges&lt;/a&gt; Hint: if watchList contains multiple USE nodes, output events are only generated when all children have loaded successfully or at least one node has failed. Hint: if individual load status information is desired for different nodes, multiple LoadSensor nodes may be used, each with a single watchList element. Hint: Anchor nodes can be monitored for binding a target Viewpoint, loading a new scene, or loading a new scene in a new window.  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DUrlObject.
	 * @param newValue is new value for the children field.
	 * @return {@link LoadSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LoadSensor setChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: X3DUrlObject

	/**
	 * Add array of children nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DUrlObject.
	 * @param newValue is new value array to be appended the children field.
	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: X3DUrlObject
	/**
	 * Set single children node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the children field
	 */
	public void setChildren(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: X3DUrlObject
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link LoadSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LoadSensor setDescription(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link LoadSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LoadSensor setEnabled(boolean newValue);

	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isActive true/false events are sent when sensing starts/stops. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isActive field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isLoaded</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Notify when all watchList child nodes are loaded, or at least one has failed. Sends true on successfully loading all watchList child nodes. Sends false on timeOut of any watchList child nodes, failure of any watchList child nodes to load, or no local copies available and no network present. Hint: use multiple LoadSensor nodes to track multiple loading nodes individually. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isLoaded field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=IsLoaded, $memberObjectName=isLoaded, $memberObjectName=isLoaded)
	public boolean getIsLoaded();
	/**
	 * Provide double value in seconds from outputOnly SFTime field named <i>loadTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Time of successful load complete, not sent on failure. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of loadTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=LoadTime, $memberObjectName=loadTime, $memberObjectName=loadTime)
	public double getLoadTime();
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link LoadSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LoadSensor setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value from outputOnly SFFloat field named <i>progress</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Sends 0.0 on start and 1.0 on completion. Intermediate values are browser dependent and always increasing (may indicate fraction of bytes, fraction of expected time or another metric). Hint: only 0 and 1 events are guaranteed. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of progress field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=Progress, $memberObjectName=progress, $memberObjectName=progress)
	public float getProgress();
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>timeOut</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Time in seconds of maximum load duration prior to declaring failure. Default value zero means use browser defaults.  * <br>

	 * @return value of timeOut field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=, $thisClassName=LoadSensor, $CamelCaseName=TimeOut, $memberObjectName=timeOut, $memberObjectName=timeOut)
	public double getTimeOut();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>timeOut</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Time in seconds of maximum load duration prior to declaring failure. Default value zero means use browser defaults.  * <br>

	 * @param newValue is new value for the timeOut field.
	 * @return {@link LoadSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LoadSensor setTimeOut(double newValue);

}
