/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Layout;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * ScreenFontStyle is an X3DFontStyleNode defines the size, family, justification, and other styles used within a screen layout.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.2 or later) [X3DFontStyleNode] ScreenFontStyle is an X3DFontStyleNode defines the size, family, justification, and other styles used within a screen layout. ScreenFontStyle renders text so that it appears identical to typical 2D applications by specifying pointSize in points (as in 2D document layout) rather than size in meters. Each glyph of text is rendered as a quadrilateral with a texture applied.
Hint: first add a Text node as a parent.
Hint: Wikipedia &lt;a href="https://en.wikipedia.org/wiki/Font" target="_blank"&gt;https://en.wikipedia.org/wiki/Font&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#ScreenFontStyle" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/layout.html#ScreenFontStyle" target="blank">X3D Abstract Specification: ScreenFontStyle</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#ScreenFontStyle" target="_blank">X3D Tooltips: ScreenFontStyle</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface ScreenFontStyle extends  org.web3d.x3d.sai.Text.X3DFontStyleNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of String enumeration results (baseType MFString) ['"SANS"' | '"SERIF"' | '"TYPEWRITER"' | '"etc."'] from inputOutput MFString field named <i>family</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Array of quoted font family names in preference order, browsers use the first supported family. Hint: example family array might be "Times" "SERIF" Warning: font family support often varies. Hint: values with guaranteed support include "SERIF" "SANS" "TYPEWRITER". Hint: SERIF and SANS are variable-width fonts (for example, Times Roman and Arial). Hint: TYPEWRITER is a fixed-width font (for example, Courier). Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks". Hint: see 15.2.2.2 Font family and style &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of family field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Family, $memberObjectName=family, $memberObjectName=family)
	public String[] getFamily();

	/**
	 * Accessor method to assign String enumeration array (""SANS"" | ""SERIF"" | ""TYPEWRITER"") to inputOutput MFString field named <i>family</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Array of quoted font family names in preference order, browsers use the first supported family. Hint: example family array might be "Times" "SERIF" Warning: font family support often varies. Hint: values with guaranteed support include "SERIF" "SANS" "TYPEWRITER". Hint: SERIF and SANS are variable-width fonts (for example, Times Roman and Arial). Hint: TYPEWRITER is a fixed-width font (for example, Courier). Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks". Hint: see 15.2.2.2 Font family and style &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the family field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setFamily(String[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>horizontal</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is horizontal (true) or vertical (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of horizontal field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Horizontal, $memberObjectName=horizontal, $memberObjectName=horizontal)
	public boolean getHorizontal();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>horizontal</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is horizontal (true) or vertical (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the horizontal field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setHorizontal(boolean newValue);

	/**
	 * Provide array of String enumeration results (baseType MFString) ['"MIDDLE"' | '"MIDDLE" "BEGIN"' | '"MIDDLE" "END"' | '"MIDDLE" "FIRST"' | '"MIDDLE" "MIDDLE"' | '"BEGIN"' | '"BEGIN" "BEGIN"' | '"BEGIN" "END"' | '"BEGIN" "FIRST"' | '"BEGIN" "MIDDLE"' | '"END"' | '"END" "BEGIN"' | '"END" "END"' | '"END" "FIRST"' | '"END" "MIDDLE"' | '"FIRST"' | '"FIRST" "BEGIN"' | '"FIRST" "END"' | '"FIRST" "FIRST"' | '"FIRST" "MIDDLE"'] from inputOutput MFString field named <i>justify</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The justify field determines horizontal and vertical alignment of text layout, relative to the origin of the object coordinate system. Hint: preferred value is usually justify=' "MIDDLE" "MIDDLE" ' for centered justification horizontally and vertically. Warning: exactly two string values are provided for major and minor axis alignment. Warning: do not use illegal values such as LEFT RIGHT TOP BOTTOM or CENTER. Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks". Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of justify field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Justify, $memberObjectName=justify, $memberObjectName=justify)
	public String[] getJustify();

	/**
	 * Accessor method to assign String enumeration array (""MIDDLE"" | ""MIDDLE" "BEGIN"" | ""MIDDLE" "END"" | ""MIDDLE" "FIRST"" | ""MIDDLE" "MIDDLE"" | ""BEGIN"" | ""BEGIN" "BEGIN"" | ""BEGIN" "END"" | ""BEGIN" "FIRST"" | ""BEGIN" "MIDDLE"" | ""END"" | ""END" "BEGIN"" | ""END" "END"" | ""END" "FIRST"" | ""END" "MIDDLE"" | ""FIRST"" | ""FIRST" "BEGIN"" | ""FIRST" "END"" | ""FIRST" "FIRST"" | ""FIRST" "MIDDLE"") to inputOutput MFString field named <i>justify</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The justify field determines horizontal and vertical alignment of text layout, relative to the origin of the object coordinate system. Hint: preferred value is usually justify=' "MIDDLE" "MIDDLE" ' for centered justification horizontally and vertically. Warning: exactly two string values are provided for major and minor axis alignment. Warning: do not use illegal values such as LEFT RIGHT TOP BOTTOM or CENTER. Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks". Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the justify field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setJustify(String[] newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>language</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Language codes consist of a primary code and a (possibly empty) series of subcodes. [ language-code = primary-code ( "-" subcode )* ] Two-letter primary codes are reserved for language abbreviations. Two-letter primary codes include en (English), fr (French), de (German), it (Italian), nl (Dutch), el (Greek), es (Spanish), pt (Portuguese), ar (Arabic), he (Hebrew), ru (Russian), zh (Chinese), ja (Japanese), hi (Hindi), ur (Urdu), and sa (Sanskrit). Any two-letter subcode is understood to be a country code. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: see ISO639.2 Codes for the Representation of Names of Languages &lt;a href="http://www.loc.gov/standards/iso639-2/php/code_list.php" target="_blank"&gt;http://www.loc.gov/standards/iso639-2/php/code_list.php&lt;/a&gt; Hint: see RFC3066 Tags for the Identification of Languages &lt;a href="https://tools.ietf.org/html/rfc3066" target="_blank"&gt;https://tools.ietf.org/html/rfc3066&lt;/a&gt; Hint: see ISO3166 or &lt;a href="http://xml.coverpages.org/languageIdentifiers.html" target="_blank"&gt;http://xml.coverpages.org/languageIdentifiers.html&lt;/a&gt; Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of language field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Language, $memberObjectName=language, $memberObjectName=language)
	public String getLanguage();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>language</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Language codes consist of a primary code and a (possibly empty) series of subcodes. [ language-code = primary-code ( "-" subcode )* ] Two-letter primary codes are reserved for language abbreviations. Two-letter primary codes include en (English), fr (French), de (German), it (Italian), nl (Dutch), el (Greek), es (Spanish), pt (Portuguese), ar (Arabic), he (Hebrew), ru (Russian), zh (Chinese), ja (Japanese), hi (Hindi), ur (Urdu), and sa (Sanskrit). Any two-letter subcode is understood to be a country code. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: see ISO639.2 Codes for the Representation of Names of Languages &lt;a href="http://www.loc.gov/standards/iso639-2/php/code_list.php" target="_blank"&gt;http://www.loc.gov/standards/iso639-2/php/code_list.php&lt;/a&gt; Hint: see RFC3066 Tags for the Identification of Languages &lt;a href="https://tools.ietf.org/html/rfc3066" target="_blank"&gt;https://tools.ietf.org/html/rfc3066&lt;/a&gt; Hint: see ISO3166 or &lt;a href="http://xml.coverpages.org/languageIdentifiers.html" target="_blank"&gt;http://xml.coverpages.org/languageIdentifiers.html&lt;/a&gt; Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the language field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setLanguage(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>leftToRight</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is left-to-right (true) or right-to-left (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of leftToRight field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=LeftToRight, $memberObjectName=leftToRight, $memberObjectName=leftToRight)
	public boolean getLeftToRight();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>leftToRight</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is left-to-right (true) or right-to-left (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the leftToRight field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setLeftToRight(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public ScreenFontStyle setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of (0,infinity) from inputOutput SFFloat field named <i>pointSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) pointSize field specifies the size of text in points. Nominal height (in local coordinate system) of text glyphs, also sets default spacing between adjacent lines of text. Hint: pointSize replaces the size field of the FontStyle node. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of pointSize field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=PointSize, $memberObjectName=pointSize, $memberObjectName=pointSize)
	public float getPointSize();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>pointSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) pointSize field specifies the size of text in points. Nominal height (in local coordinate system) of text glyphs, also sets default spacing between adjacent lines of text. Hint: pointSize replaces the size field of the FontStyle node. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the pointSize field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setPointSize(float newValue);

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>spacing</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Adjustment factor for line spacing between adjacent lines of text. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of spacing field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Spacing, $memberObjectName=spacing, $memberObjectName=spacing)
	public float getSpacing();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>spacing</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Adjustment factor for line spacing between adjacent lines of text. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the spacing field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setSpacing(float newValue);

	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["PLAIN" | "BOLD" | "ITALIC" | "BOLDITALIC"] from inputOutput SFString field named <i>style</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Pick one of four values for text style (PLAIN|BOLD|ITALIC|BOLDITALIC). Warning: overloaded name for CSS style attribute. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: see 15.2.2.2 Font family and style &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle&lt;/a&gt; for details. Hint: overlapping functionality with CSS style attribute provides a "best of both worlds" approach. The style attribute provides an inline block of CSS source for element styling, reserved for use by Cascading Style Sheets (CSS) and XML stylesheets. Hint: X3D Architecture Annex L, HTML authoring guidelines, CSS considerations &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/htmlGuidelines.html#CSS" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/htmlGuidelines.html#CSS&lt;/a&gt; Hint: W3C Cascading Style Sheets &lt;a href="https://www.w3.org/Style/CSS" target="_blank"&gt;https://www.w3.org/Style/CSS&lt;/a&gt; Hint: CSS Snapshot &lt;a href="https://www.w3.org/TR/css-2018" target="_blank"&gt;https://www.w3.org/TR/css-2018&lt;/a&gt; Hint: &lt;a href="https://www.w3.org/TR/css-style-attr" target="_blank"&gt;https://www.w3.org/TR/css-style-attr&lt;/a&gt; Hint: Wikibooks, XML - Managing Data Exchange/XSLT and Style Sheets &lt;a href="https://en.wikibooks.org/wiki/XML_-_Managing_Data_Exchange/XSLT_and_Style_Sheets" target="_blank"&gt;https://en.wikibooks.org/wiki/XML_-_Managing_Data_Exchange/XSLT_and_Style_Sheets&lt;/a&gt;  * <br>

	 * @return value of style field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=Style, $memberObjectName=style, $memberObjectName=style)
	public String getStyle();

	/**
	 * Accessor method to assign String enumeration value ("PLAIN" | "BOLD" | "ITALIC" | "BOLDITALIC") to inputOutput SFString field named <i>style</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Pick one of four values for text style (PLAIN|BOLD|ITALIC|BOLDITALIC). Warning: overloaded name for CSS style attribute. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: see 15.2.2.2 Font family and style &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Fontfamilyandstyle&lt;/a&gt; for details. Hint: overlapping functionality with CSS style attribute provides a "best of both worlds" approach. The style attribute provides an inline block of CSS source for element styling, reserved for use by Cascading Style Sheets (CSS) and XML stylesheets. Hint: X3D Architecture Annex L, HTML authoring guidelines, CSS considerations &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/htmlGuidelines.html#CSS" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/htmlGuidelines.html#CSS&lt;/a&gt; Hint: W3C Cascading Style Sheets &lt;a href="https://www.w3.org/Style/CSS" target="_blank"&gt;https://www.w3.org/Style/CSS&lt;/a&gt; Hint: CSS Snapshot &lt;a href="https://www.w3.org/TR/css-2018" target="_blank"&gt;https://www.w3.org/TR/css-2018&lt;/a&gt; Hint: &lt;a href="https://www.w3.org/TR/css-style-attr" target="_blank"&gt;https://www.w3.org/TR/css-style-attr&lt;/a&gt; Hint: Wikibooks, XML - Managing Data Exchange/XSLT and Style Sheets &lt;a href="https://en.wikibooks.org/wiki/XML_-_Managing_Data_Exchange/XSLT_and_Style_Sheets" target="_blank"&gt;https://en.wikibooks.org/wiki/XML_-_Managing_Data_Exchange/XSLT_and_Style_Sheets&lt;/a&gt;  * <br>

	 * @param newValue is new value for the style field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setStyle(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>topToBottom</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is top-to-bottom (true) or bottom-to-top (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @return value of topToBottom field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DFontStyleNode, $additionalInheritanceBaseType=, $thisClassName=ScreenFontStyle, $CamelCaseName=TopToBottom, $memberObjectName=topToBottom, $memberObjectName=topToBottom)
	public boolean getTopToBottom();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>topToBottom</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether text direction is top-to-bottom (true) or bottom-to-top (false). Hint: see 15.2.2.3 Direction and justification &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/text.html#Directionandjustification&lt;/a&gt; for details. Hint: relates to Internationalization (i18n) &lt;a href="http://www.w3.org/standards/webdesign/i18n" target="_blank"&gt;http://www.w3.org/standards/webdesign/i18n&lt;/a&gt; Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and user accessibility.  * <br>

	 * @param newValue is new value for the topToBottom field.
	 * @return {@link ScreenFontStyle} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public ScreenFontStyle setTopToBottom(boolean newValue);

}
