/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Geometry3D;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * Extrusion is a geometry node that sequentially stretches a 2D cross section along a 3D-spine path in the local coordinate system, creating an outer hull.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DGeometryNode] Extrusion is a geometry node that sequentially stretches a 2D cross section along a 3D-spine path in the local coordinate system, creating an outer hull.
Scaling and rotating the crossSection 2D outline at each control point can modify the outer hull of the Extrusion to produce a wide variety of interesting shapes.
Warning: take care to avoid defining parameter combinations that create self-intersecting, impossible or inverted geometry.
Hint: Extrusion &lt;a href="https://en.wikipedia.org/wiki/Extrusion" target="_blank"&gt;https://en.wikipedia.org/wiki/Extrusion&lt;/a&gt;
Hint: insert a Shape node before adding geometry or Appearance.  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#Extrusion" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/geometry3D.html#Extrusion" target="blank">X3D Abstract Specification: Extrusion</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Extrusion" target="_blank">X3D Tooltips: Extrusion</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface Extrusion extends  org.web3d.x3d.sai.Rendering.X3DGeometryNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>beginCap</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether beginning cap is drawn (similar to Cylinder top cap). Warning: since this field has accessType initializeOnly, the value cannot be changed after initial creation.  * <br>

	 * @return value of beginCap field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=BeginCap, $memberObjectName=beginCap, $memberObjectName=beginCap)
	public boolean getBeginCap();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>beginCap</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether beginning cap is drawn (similar to Cylinder top cap). Warning: since this field has accessType initializeOnly, the value cannot be changed after initial creation.  * <br>

	 * @param newValue is new value for the beginCap field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setBeginCap(boolean newValue);

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>ccw</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The ccw field indicates counterclockwise ordering of vertex-coordinates orientation. Hint: a good debugging technique for problematic polygons is to try changing the value of ccw, which can reverse solid effects (single-sided backface culling) and normal-vector direction. Warning: consistent and correct ordering of left-handed or right-handed point sequences is important throughout the coord array of point values. Hint: clockwise &lt;a href="https://en.wikipedia.org/wiki/Clockwise" target="_blank"&gt;https://en.wikipedia.org/wiki/Clockwise&lt;/a&gt;  * <br>

	 * @return value of ccw field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Ccw, $memberObjectName=ccw, $memberObjectName=ccw)
	public boolean getCcw();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>ccw</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The ccw field indicates counterclockwise ordering of vertex-coordinates orientation. Hint: a good debugging technique for problematic polygons is to try changing the value of ccw, which can reverse solid effects (single-sided backface culling) and normal-vector direction. Warning: consistent and correct ordering of left-handed or right-handed point sequences is important throughout the coord array of point values. Hint: clockwise &lt;a href="https://en.wikipedia.org/wiki/Clockwise" target="_blank"&gt;https://en.wikipedia.org/wiki/Clockwise&lt;/a&gt;  * <br>

	 * @param newValue is new value for the ccw field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setCcw(boolean newValue);

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>convex</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The convex field is a hint to renderers whether all polygons in a shape are convex (true), or possibly concave (false). A convex polygon is planar, does not intersect itself, and has all interior angles &amp;lt; 180 degrees. Hint: concave is the opposite of convex. Warning: concave or inverted geometry may be invisible when using default value convex=true, since some renderers use more-efficient algorithms to perform tessellation that may inadvertently fail on concave geometry. Hint: select convex=false (i.e. concave) and solid=false (i.e. two-sided display) for greatest visibility of geometry. Hint: convex polygon &lt;a href="https://en.wikipedia.org/wiki/Convex_polygon" target="_blank"&gt;https://en.wikipedia.org/wiki/Convex_polygon&lt;/a&gt; Hint: tessellation &lt;a href="https://en.wikipedia.org/wiki/Tessellation" target="_blank"&gt;https://en.wikipedia.org/wiki/Tessellation&lt;/a&gt;  * <br>

	 * @return value of convex field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Convex, $memberObjectName=convex, $memberObjectName=convex)
	public boolean getConvex();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>convex</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The convex field is a hint to renderers whether all polygons in a shape are convex (true), or possibly concave (false). A convex polygon is planar, does not intersect itself, and has all interior angles &amp;lt; 180 degrees. Hint: concave is the opposite of convex. Warning: concave or inverted geometry may be invisible when using default value convex=true, since some renderers use more-efficient algorithms to perform tessellation that may inadvertently fail on concave geometry. Hint: select convex=false (i.e. concave) and solid=false (i.e. two-sided display) for greatest visibility of geometry. Hint: convex polygon &lt;a href="https://en.wikipedia.org/wiki/Convex_polygon" target="_blank"&gt;https://en.wikipedia.org/wiki/Convex_polygon&lt;/a&gt; Hint: tessellation &lt;a href="https://en.wikipedia.org/wiki/Tessellation" target="_blank"&gt;https://en.wikipedia.org/wiki/Tessellation&lt;/a&gt;  * <br>

	 * @param newValue is new value for the convex field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setConvex(boolean newValue);

	/**
	 * Provide float value unit axis, angle (in radians) within allowed range of [0,infinity) from initializeOnly SFFloat field named <i>creaseAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) creaseAngle defines angle (in radians) where adjacent polygons are drawn with sharp edges or smooth shading. If angle between normals of two adjacent polygons is less than creaseAngle, smooth shading is rendered across the shared line segment. Hint: creaseAngle=0 means render all edges sharply, creaseAngle=3.14159 means render all edges smoothly. Hint: radian units for angular measure &lt;a href="https://en.wikipedia.org/wiki/Radian" target="_blank"&gt;https://en.wikipedia.org/wiki/Radian&lt;/a&gt;  * <br>

	 * @return value of creaseAngle field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=CreaseAngle, $memberObjectName=creaseAngle, $memberObjectName=creaseAngle)
	public float getCreaseAngle();

	/**
	 * Accessor method to assign float value unit axis, angle (in radians) to initializeOnly SFFloat field named <i>creaseAngle</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) creaseAngle defines angle (in radians) where adjacent polygons are drawn with sharp edges or smooth shading. If angle between normals of two adjacent polygons is less than creaseAngle, smooth shading is rendered across the shared line segment. Hint: creaseAngle=0 means render all edges sharply, creaseAngle=3.14159 means render all edges smoothly. Hint: radian units for angular measure &lt;a href="https://en.wikipedia.org/wiki/Radian" target="_blank"&gt;https://en.wikipedia.org/wiki/Radian&lt;/a&gt;  * <br>

	 * @param newValue is new value for the creaseAngle field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setCreaseAngle(float newValue);

	/**
	 * Provide array of 2-tuple float results from initializeOnly MFVec2f field named <i>crossSection</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The crossSection array defines a silhouette outline of the outer Extrusion surface. crossSection is an ordered set of 2D points that draw a piecewise-linear curve which is extruded to form a series of connected vertices. Hint: the crossSection array can be open or closed (closed means that endpoints are coincident). Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Warning: if the order of crossSection point definition does not match clockwise/counterclockwise setting of ccw field, then self-intersecting, impossible or inverted geometry can result! Warning: avoid self-intersecting polygon line segments, otherwise defined geometry is irregular and rendering results are undefined (especially for end caps).  * <br>

	 * @return value of crossSection field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=CrossSection, $memberObjectName=crossSection, $memberObjectName=crossSection)
	public float[] getCrossSection();

	/**
	 * Accessor method to assign 2-tuple float array to initializeOnly MFVec2f field named <i>crossSection</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The crossSection array defines a silhouette outline of the outer Extrusion surface. crossSection is an ordered set of 2D points that draw a piecewise-linear curve which is extruded to form a series of connected vertices. Hint: the crossSection array can be open or closed (closed means that endpoints are coincident). Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Warning: if the order of crossSection point definition does not match clockwise/counterclockwise setting of ccw field, then self-intersecting, impossible or inverted geometry can result! Warning: avoid self-intersecting polygon line segments, otherwise defined geometry is irregular and rendering results are undefined (especially for end caps).  * <br>

	 * @param newValue is new value for the crossSection field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setCrossSection(float[] newValue);

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>endCap</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether end cap is drawn (similar to Cylinder bottom cap). Warning: since this field has accessType initializeOnly, the value cannot be changed after initial creation.  * <br>

	 * @return value of endCap field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=EndCap, $memberObjectName=endCap, $memberObjectName=endCap)
	public boolean getEndCap();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>endCap</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether end cap is drawn (similar to Cylinder bottom cap). Warning: since this field has accessType initializeOnly, the value cannot be changed after initial creation.  * <br>

	 * @param newValue is new value for the endCap field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setEndCap(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Extrusion setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide array of 4-tuple float results unit axis, angle (in radians) from inputOutput MFRotation field named <i>orientation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The orientation array is a list of axis-angle 4-tuple values applied at each spine-aligned cross-section plane. Hint: if the orientation array contains a single 4-tuple value, it is applied at all spine-aligned crossSection planes. Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values.  * <br>

	 * @return value of orientation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Orientation, $memberObjectName=orientation, $memberObjectName=orientation)
	public float[] getOrientation();

	/**
	 * Accessor method to assign 4-tuple float array unit axis, angle (in radians) to inputOutput MFRotation field named <i>orientation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The orientation array is a list of axis-angle 4-tuple values applied at each spine-aligned cross-section plane. Hint: if the orientation array contains a single 4-tuple value, it is applied at all spine-aligned crossSection planes. Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values.  * <br>

	 * @param newValue is new value for the orientation field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setOrientation(float[] newValue);

	/**
	 * Provide array of 2-tuple float results from inputOutput MFVec2f field named <i>scale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) scale is a list of 2D-scale parameters applied at each spine-aligned cross-section plane. Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Hint: if the scale array contains one value, it is applied at all spine-aligned crossSection planes. Warning: zero or negative scale values not allowed.  * <br>

	 * @return value of scale field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Scale, $memberObjectName=scale, $memberObjectName=scale)
	public float[] getScale();

	/**
	 * Accessor method to assign 2-tuple float array to inputOutput MFVec2f field named <i>scale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) scale is a list of 2D-scale parameters applied at each spine-aligned cross-section plane. Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Hint: if the scale array contains one value, it is applied at all spine-aligned crossSection planes. Warning: zero or negative scale values not allowed.  * <br>

	 * @param newValue is new value for the scale field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setScale(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>solid</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Setting solid true means draw only one side of polygons (backface culling on), setting solid false means draw both sides of polygons (backface culling off). Hint: mnemonic "this geometry is solid like a brick" (you don't render the inside of a brick). Warning: default value true can completely hide geometry if viewed from wrong side! Hint: if in doubt, use solid='false' for maximum visibility. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and visualization.  * <br>

	 * @return value of solid field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Solid, $memberObjectName=solid, $memberObjectName=solid)
	public boolean getSolid();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>solid</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Setting solid true means draw only one side of polygons (backface culling on), setting solid false means draw both sides of polygons (backface culling off). Hint: mnemonic "this geometry is solid like a brick" (you don't render the inside of a brick). Warning: default value true can completely hide geometry if viewed from wrong side! Hint: if in doubt, use solid='false' for maximum visibility. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and visualization.  * <br>

	 * @param newValue is new value for the solid field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setSolid(boolean newValue);

	/**
	 * Provide array of 3-tuple float results from initializeOnly MFVec3f field named <i>spine</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The spine array defines a center-line sequence of 3D points that define a piecewise-linear curve forming a series of connected vertices. The spine is set of points along which a 2D crossSection is extruded, scaled and oriented. Hint: the spine array can be open or closed (closed means that endpoints are coincident). Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Warning: special care is needed if creating loops or spirals since self-intersecting, impossible or inverted geometry can result! Warning: ensure that spine segments have non-zero length and are not coincident with each other. Hint: if a spine is closed (or nearly closed) then the inner diameter usually needs to be greater than the corresponding crossSection width.  * <br>

	 * @return value of spine field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DGeometryNode, $additionalInheritanceBaseType=, $thisClassName=Extrusion, $CamelCaseName=Spine, $memberObjectName=spine, $memberObjectName=spine)
	public float[] getSpine();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly MFVec3f field named <i>spine</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The spine array defines a center-line sequence of 3D points that define a piecewise-linear curve forming a series of connected vertices. The spine is set of points along which a 2D crossSection is extruded, scaled and oriented. Hint: the spine array can be open or closed (closed means that endpoints are coincident). Hint: number of values must all match for 3-tuple spine points, 2-tuple scale values, and 4-tuple orientation values. Warning: special care is needed if creating loops or spirals since self-intersecting, impossible or inverted geometry can result! Warning: ensure that spine segments have non-zero length and are not coincident with each other. Hint: if a spine is closed (or nearly closed) then the inner diameter usually needs to be greater than the corresponding crossSection width.  * <br>

	 * @param newValue is new value for the spine field.
	 * @return {@link Extrusion} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Extrusion setSpine(float[] newValue);

}
