/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.CubeMapTexturing;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;

/**
 * GeneratedCubeMapTexture is a texture node that defines a cubic environment map that sources its data from internally generated images.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.1 or later) [X3DEnvironmentTextureNode] GeneratedCubeMapTexture is a texture node that defines a cubic environment map that sources its data from internally generated images.
The viewpoint of the generated texture is the location and orientation of the associated geometry in world space.
Hint: can contain a single TextureProperties node.
Hint: typically a Box is used for applying the GeneratedCubeMapTexture.Warning: requires X3D profile='Full' or else include &amp;lt;component name='CubeMapTexturing' level='3'/&amp;gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#GeneratedCubeMapTexture" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/environmentalTexturing#GeneratedCubeMapTexture" target="blank">X3D Abstract Specification: GeneratedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#GeneratedCubeMapTexture" target="_blank">X3D Tooltips: GeneratedCubeMapTexture</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank">X3D Scene Authoring Hints: Images</a>
 */
public interface GeneratedCubeMapTexture extends  org.web3d.x3d.sai.CubeMapTexturing.X3DEnvironmentTextureNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=GeneratedCubeMapTexture, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link GeneratedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeneratedCubeMapTexture setDescription(String newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=GeneratedCubeMapTexture, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link GeneratedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public GeneratedCubeMapTexture setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide int value within allowed range of (0,infinity) from inputOutput SFInt32 field named <i>size</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) size indicates the resolution of the generated images in number of pixels per side.  * <br>

	 * @return value of size field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=GeneratedCubeMapTexture, $CamelCaseName=Size, $memberObjectName=size, $memberObjectName=size)
	public int getSize();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>size</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) size indicates the resolution of the generated images in number of pixels per side.  * <br>

	 * @param newValue is new value for the size field.
	 * @return {@link GeneratedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public GeneratedCubeMapTexture setSize(int newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) from initializeOnly SFNode field <i>textureProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.  * <br>

	 * @return value of textureProperties field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=GeneratedCubeMapTexture, $CamelCaseName=TextureProperties, $memberObjectName=textureProperties, $memberObjectName=textureProperties)
	public  org.web3d.x3d.sai.Texturing.TextureProperties getTextureProperties(); // acceptable node types #1: TextureProperties

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.TextureProperties instance (using a properly typed node) to initializeOnly SFNode field <i>textureProperties</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [TextureProperties] Single contained TextureProperties node that can specify additional visual attributes applied to corresponding texture images.  * <br>

	 * @param newValue is new value for the textureProperties field.
	 * @return {@link GeneratedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public GeneratedCubeMapTexture setTextureProperties( org.web3d.x3d.sai.Texturing.TextureProperties newValue); // acceptable node types #2: TextureProperties

	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["NONE" | "NEXT_FRAME_ONLY" | "ALWAYS"] from inputOutput SFString field named <i>update</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  update controls regeneration of the texture. Warning: An object trying to render itself in the scene graph can cause infinite loops. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @return value of update field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DEnvironmentTextureNode, $additionalInheritanceBaseType=, $thisClassName=GeneratedCubeMapTexture, $CamelCaseName=Update, $memberObjectName=update, $memberObjectName=update)
	public String getUpdate();

	/**
	 * Accessor method to assign String enumeration value ("NONE" | "NEXT_FRAME_ONLY" | "ALWAYS") to inputOutput SFString field named <i>update</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  update controls regeneration of the texture. Warning: An object trying to render itself in the scene graph can cause infinite loops. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @param newValue is new value for the update field.
	 * @return {@link GeneratedCubeMapTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public GeneratedCubeMapTexture setUpdate(String newValue);

}
