/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Texturing;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Texturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Texturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Texturing.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
import java.util.Arrays;

/**
 * MultiTexture applies several individual textures to a single geometry node, enabling a variety of visual effects that include light mapping and environment mapping.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DTextureNode] MultiTexture applies several individual textures to a single geometry node, enabling a variety of visual effects that include light mapping and environment mapping. MultiTexture can contain zero or more ImageTexture, MovieTexture, PixelTexture, ComposedCubeMapTexture, GeneratedCubeMapTexture, ImageCubeMapTexture, ComposedTexture3D, ImageTexture3D, and PixelTexture3D nodes.
Texture maps have a 2D coordinate system (s, t) horizontal and vertical, with (s, t) texture-coordinate values in range [0.0, 1.0] for opposite corners of the image.
Hint: insert Shape and Appearance nodes before adding texture.
Hint: Texture mapping &lt;a href="https://en.wikipedia.org/wiki/Texture_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Texture_mapping&lt;/a&gt;
Warning: the number of textures to be blended may have a significant impact on performance, depending on available graphics hardware capabilities.
Hint: multitexturing is accomplished using MultiTexture, MultiTextureCoordinate and MultiTextureTransform nodes.
Hint: Texture coordinates are reapplied (or else recomputed if textureTransform field initially NULL) whenever the corresponding vertex-based geometry changes.
Hint: X3D Texturing component Figure 18.2 Lightmap example, &lt;a href="https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/texturing.html#f-Lightmapexample" target="_blank"&gt;https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/texturing.html#f-Lightmapexample&lt;/a&gt;
Hint: X3D Texturing component Table 18.2: Comparison of single texture and multitexture attributes, &lt;a href="https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/texturing.html#t-SingleAndMultitextureAttrs" target="_blank"&gt;https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/texturing.html#t-SingleAndMultitextureAttrs&lt;/a&gt;
Hint: MultiTexture does not need to be included in LoadSensor watchList since any child ImageTexture and MovieTexture nodes of interest can be handled separately.
Warning: MultiTexture may not contain another MultiTexture node.  * <br>
 * <br>

 * <br>
 * Note that {@linkplain SFColor#ALICEBLUE SFColor} provides a variety of color constants.
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/texturing.html#MultiTexture" target="blank">X3D Abstract Specification: MultiTexture</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#MultiTexture" target="_blank">X3D Tooltips: MultiTexture</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank">X3D Scene Authoring Hints: Images</a>
 */
public class MultiTexture extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Texturing.MultiTexture
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=alpha, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=alpha, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float alpha; //  X3D field type: SFFloat

    /* @name=color, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=color, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] color; //  X3D field type: SFColor

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=function, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=function, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> function = new ArrayList<>(); //  X3D field type: MFString

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=mode, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=mode, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> mode = new ArrayList<>(); //  X3D field type: MFString

    /* @name=source, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=source, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> source = new ArrayList<>(); //  X3D field type: MFString

    /* @name=texture, @type=MFNode, $javaType=ArrayList< org.web3d.x3d.sai.Texturing.X3DSingleTextureNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList< org.web3d.x3d.sai.Texturing.X3DSingleTextureNode>, $normalizedMemberObjectName=texture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> texture = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: X3DSingleTextureNode or ProtoInstance

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean functionWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> Invert argument x as (1 - x).
	 * MFString field named <i>function</i> with X3DUOM simpleType <i>multiTextureFunctionValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"COMPLEMENT"</i> (Java syntax) or <i>'"COMPLEMENT"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureFunctionValues.html">XML Schema: multiTextureFunctionValues</a> */
	public static final String FUNCTION_COMPLEMENT = "COMPLEMENT";

	/** 
	 * <i>Tooltip:</i> Replicate alpha information to all color channels before operation completes.
	 * MFString field named <i>function</i> with X3DUOM simpleType <i>multiTextureFunctionValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ALPHAREPLICATE"</i> (Java syntax) or <i>'"ALPHAREPLICATE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureFunctionValues.html">XML Schema: multiTextureFunctionValues</a> */
	public static final String FUNCTION_ALPHAREPLICATE = "ALPHAREPLICATE";

	/** 
	 * <i>Tooltip:</i> No function is applied - empty SFString is allowed value within MFString array.
	 * MFString field named <i>function</i> with X3DUOM simpleType <i>multiTextureFunctionValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>""</i> (Java syntax) or <i>'""'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureFunctionValues.html">XML Schema: multiTextureFunctionValues</a> */
	public static final String FUNCTION_ = "";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean modeWarningAlreadyProvided = false;

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ADD"</i> (Java syntax) or <i>'"ADD"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_ADD = "ADD";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ADDSIGNED"</i> (Java syntax) or <i>'"ADDSIGNED"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_ADDSIGNED = "ADDSIGNED";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ADDSIGNED2X"</i> (Java syntax) or <i>'"ADDSIGNED2X"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_ADDSIGNED2X = "ADDSIGNED2X";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ADDSMOOTH"</i> (Java syntax) or <i>'"ADDSMOOTH"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_ADDSMOOTH = "ADDSMOOTH";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"BLENDCURRENTALPHA"</i> (Java syntax) or <i>'"BLENDCURRENTALPHA"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_BLENDCURRENTALPHA = "BLENDCURRENTALPHA";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"BLENDDIFFUSEALPHA"</i> (Java syntax) or <i>'"BLENDDIFFUSEALPHA"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_BLENDDIFFUSEALPHA = "BLENDDIFFUSEALPHA";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"BLENDFACTORALPHA"</i> (Java syntax) or <i>'"BLENDFACTORALPHA"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_BLENDFACTORALPHA = "BLENDFACTORALPHA";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"BLENDTEXTUREALPHA"</i> (Java syntax) or <i>'"BLENDTEXTUREALPHA"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_BLENDTEXTUREALPHA = "BLENDTEXTUREALPHA";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"DOTPRODUCT3"</i> (Java syntax) or <i>'"DOTPRODUCT3"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_DOTPRODUCT3 = "DOTPRODUCT3";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATE"</i> (Java syntax) or <i>'"MODULATE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATE = "MODULATE";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATE2X"</i> (Java syntax) or <i>'"MODULATE2X"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATE2X = "MODULATE2X";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATE4X"</i> (Java syntax) or <i>'"MODULATE4X"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATE4X = "MODULATE4X";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATEALPHA_ADDCOLOR"</i> (Java syntax) or <i>'"MODULATEALPHA_ADDCOLOR"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATEALPHA_ADDCOLOR = "MODULATEALPHA_ADDCOLOR";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATEINVALPHA_ADDCOLOR"</i> (Java syntax) or <i>'"MODULATEINVALPHA_ADDCOLOR"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATEINVALPHA_ADDCOLOR = "MODULATEINVALPHA_ADDCOLOR";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"MODULATEINVCOLOR_ADDALPHA"</i> (Java syntax) or <i>'"MODULATEINVCOLOR_ADDALPHA"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_MODULATEINVCOLOR_ADDALPHA = "MODULATEINVCOLOR_ADDALPHA";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"OFF"</i> (Java syntax) or <i>'"OFF"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_OFF = "OFF";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"REPLACE"</i> (Java syntax) or <i>'"REPLACE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_REPLACE = "REPLACE";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"SELECTARG1"</i> (Java syntax) or <i>'"SELECTARG1"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_SELECTARG1 = "SELECTARG1";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"SELECTARG2"</i> (Java syntax) or <i>'"SELECTARG2"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_SELECTARG2 = "SELECTARG2";

	/** MFString field named <i>mode</i> with X3DUOM simpleType <i>multiTextureModeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"SUBTRACT"</i> (Java syntax) or <i>'"SUBTRACT"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureModeValues.html">XML Schema: multiTextureModeValues</a> */
	public static final String MODE_SUBTRACT = "SUBTRACT";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean sourceWarningAlreadyProvided = false;

	/** MFString field named <i>source</i> with X3DUOM simpleType <i>multiTextureSourceValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"DIFFUSE"</i> (Java syntax) or <i>'"DIFFUSE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureSourceValues.html">XML Schema: multiTextureSourceValues</a> */
	public static final String SOURCE_DIFFUSE = "DIFFUSE";

	/** MFString field named <i>source</i> with X3DUOM simpleType <i>multiTextureSourceValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"FACTOR"</i> (Java syntax) or <i>'"FACTOR"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureSourceValues.html">XML Schema: multiTextureSourceValues</a> */
	public static final String SOURCE_FACTOR = "FACTOR";

	/** MFString field named <i>source</i> with X3DUOM simpleType <i>multiTextureSourceValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"SPECULAR"</i> (Java syntax) or <i>'"SPECULAR"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureSourceValues.html">XML Schema: multiTextureSourceValues</a> */
	public static final String SOURCE_SPECULAR = "SPECULAR";

	/** MFString field named <i>source</i> with X3DUOM simpleType <i>multiTextureSourceValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>""</i> (Java syntax) or <i>'""'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_multiTextureSourceValues.html">XML Schema: multiTextureSourceValues</a> */
	public static final String SOURCE_ = "";

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>MultiTexture</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "MultiTexture";

	/** Provides name of this element: <i>MultiTexture</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>MultiTexture</i> element: <i>Texturing</i> */
	public static final String COMPONENT = "Texturing";

	/** Defines X3D component for the <i>MultiTexture</i> element: <i>Texturing</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Texturing</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFFloat field named <i>alpha</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float ALPHA_DEFAULT_VALUE = 1f;

	/** SFColor field named <i>color</i> has default value <i>{1f,1f,1f}</i> (Java syntax) or <i>1 1 1</i> (XML syntax). */
	public static final float[] COLOR_DEFAULT_VALUE = {1f,1f,1f};

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** MFString field named <i>function</i> has default value equal to an empty list. */
	public static final ArrayList<String> FUNCTION_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList());

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** MFString field named <i>mode</i> has default value equal to an empty list. */
	public static final ArrayList<String> MODE_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList());

	/** MFString field named <i>source</i> has default value equal to an empty list. */
	public static final ArrayList<String> SOURCE_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList());

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "alpha":
				result = "SFFloat";
				break;
			case "color":
				result = "SFColor";
				break;
			case "description":
				result = "SFString";
				break;
			case "function":
				result = "MFString";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "mode":
				result = "MFString";
				break;
			case "source":
				result = "MFString";
				break;
			case "texture":
				result = "MFNode";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "alpha":
				result = "inputOutput";
				break;
			case "color":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "function":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "mode":
				result = "inputOutput";
				break;
			case "source":
				result = "inputOutput";
				break;
			case "texture":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "texture"; // type containerFieldChoicesX3DTexture2DNode
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFFloat field named <i>alpha</i>. */
	public static final String fromField_ALPHA = "alpha";

	/** toField ROUTE name for SFFloat field named <i>alpha</i>. */
	public static final String toField_ALPHA = "alpha";

	/** fromField ROUTE name for SFColor field named <i>color</i>. */
	public static final String fromField_COLOR = "color";

	/** toField ROUTE name for SFColor field named <i>color</i>. */
	public static final String toField_COLOR = "color";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for MFString field named <i>function</i>. */
	public static final String fromField_FUNCTION = "function";

	/** toField ROUTE name for MFString field named <i>function</i>. */
	public static final String toField_FUNCTION = "function";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for MFString field named <i>mode</i>. */
	public static final String fromField_MODE = "mode";

	/** toField ROUTE name for MFString field named <i>mode</i>. */
	public static final String toField_MODE = "mode";

	/** fromField ROUTE name for MFString field named <i>source</i>. */
	public static final String fromField_SOURCE = "source";

	/** toField ROUTE name for MFString field named <i>source</i>. */
	public static final String toField_SOURCE = "source";

	/** fromField ROUTE name for MFNode field named <i>texture</i>. */
	public static final String fromField_TEXTURE = "texture";

	/** toField ROUTE name for MFNode field named <i>texture</i>. */
	public static final String toField_TEXTURE = "texture";

	/** Constructor for MultiTexture to initialize member variables with default values. */
	public MultiTexture()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "texture" }; // type containerFieldChoicesX3DTexture2DNode

		alpha = ALPHA_DEFAULT_VALUE;
		color = COLOR_DEFAULT_VALUE;
		description = DESCRIPTION_DEFAULT_VALUE;
		function = new ArrayList<>(FUNCTION_DEFAULT_VALUE);
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		mode = new ArrayList<>(MODE_DEFAULT_VALUE);
		source = new ArrayList<>(SOURCE_DEFAULT_VALUE);
		texture = new ArrayList<>();

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>alpha</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] The alpha field defines the alpha (1-transparency) base value for mode operations.  * <br>

	 * @return value of alpha field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Alpha, $memberObjectName=alpha, $memberObjectName=alpha)

	public float getAlpha()
	{
		return alpha;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>alpha</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] The alpha field defines the alpha (1-transparency) base value for mode operations.  * <br>

	 * @param newValue is new value for the alpha field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setAlpha(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture alpha newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture alpha newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		alpha = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat alpha field, similar to {@link #setAlpha(float)}.
	 * @param newValue is new value for the alpha field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setAlpha(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAlpha(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setAlpha(float)}.
	 * @param newValue is new value for field
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setAlpha(double newValue)
	{
		return setAlpha((float) newValue);
	}
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>color</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] The color field defines the RGB base values for mode operations. Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;  * <br>

	 * @return value of color field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Color, $memberObjectName=color, $memberObjectName=color)

	public float[] getColor()
	{
		return color;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>color</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] The color field defines the RGB base values for mode operations. Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;  * <br>

	 * @param newValue is new value for the color field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture color newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture color newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture color newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		color = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor color field, similar to {@link #setColor(float[])}.
	 * @param newValue is new value for the color field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor color field, similar to {@link #setColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setColor(float red, float green, float blue)
	{
		setColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setColor(double red, double green, double blue)
	{
		return setColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setColor(float[])}.
	 * @param newArray is new value for field                  
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setColor(double[] newArray)
	{
		return setColor(new SFColor(newArray));
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of String enumeration results (baseType MFString) ['"COMPLEMENT"' | '"ALPHAREPLICATE"' | '""' | '"etc."'] from inputOutput MFString field named <i>function</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  function operators COMPLEMENT or ALPHAREPLICATE can be applied after the mode blending operation. Empty string value "" indicates that no function operation is applied for that stage. Hint: include the same number of function values as textures, otherwise the default of no function operation is applied for each remaining stage. Hint: X3D Architecture Table 18.5 Values for the function field &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForFunctionField" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForFunctionField&lt;/a&gt; for further details.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #FUNCTION_COMPLEMENT COMPLEMENT}, {@link #FUNCTION_ALPHAREPLICATE ALPHAREPLICATE}, {@link #FUNCTION_ }.
	 * @return value of function field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Function, $memberObjectName=function, $memberObjectName=function)

	public String[] getFunction()
	{
		final String[] valuesArray = new String[function.size()];
		int i = 0;
		for (String arrayElement : function) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString function field, similar to {@link #getFunction()}.
	 * @return value of function field
	 */
	public ArrayList<String> getFunctionList()
	{
		return function;
	}
	/**
	 * Utility method to get String value of MFString function field, similar to {@link #getFunction()}.
	 * @return value of function field
	 */
	public String getFunctionString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : function) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""COMPLEMENT"" | ""ALPHAREPLICATE"" | """") to inputOutput MFString field named <i>function</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #FUNCTION_COMPLEMENT COMPLEMENT}, {@link #FUNCTION_ALPHAREPLICATE ALPHAREPLICATE}, {@link #FUNCTION_ }).
	 * <br><br>
	 * <i>Tooltip:</i>  function operators COMPLEMENT or ALPHAREPLICATE can be applied after the mode blending operation. Empty string value "" indicates that no function operation is applied for that stage. Hint: include the same number of function values as textures, otherwise the default of no function operation is applied for each remaining stage. Hint: X3D Architecture Table 18.5 Values for the function field &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForFunctionField" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForFunctionField&lt;/a&gt; for further details.  * <br>

	 * @param newValue is new value for the function field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setFunction(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearFunction(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(FUNCTION_COMPLEMENT) ||
			newValue[i].toString().replace("\"","").equals(FUNCTION_ALPHAREPLICATE) ||
			newValue[i].toString().replace("\"","").equals(FUNCTION_)))
		{
			String warningMessage = "[info] MultiTexture function newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!functionWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"COMPLEMENT\", \"ALPHAREPLICATE\", \"\"";
			    functionWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearFunction(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearFunction(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			function.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString function field, similar to {@link #setFunction(String[])}.
	 * @param newValue is new value for the function field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setFunction(MFString newValue)
	{
		if (newValue == null)		{
			clearFunction(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setFunction(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString function field, similar to {@link #setFunction(String[])}.
	 * @param newValue is new value for the function field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setFunction(SFString newValue)
	{
		if (newValue == null)		{
			clearFunction(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setFunction(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearFunction(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(FUNCTION_COMPLEMENT) ||
			newValue.toString().replace("\"","").equals(FUNCTION_ALPHAREPLICATE) ||
			newValue.toString().replace("\"","").equals(FUNCTION_)))
		{
			String warningMessage = "[info] MultiTexture function newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!functionWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"COMPLEMENT\", \"ALPHAREPLICATE\", \"\"";
			    functionWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setFunction(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString function field, similar to {@link #setFunction(String[])}.
	 * @param newValue is new value for the function field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setFunction(String newValue)
	{
		if (newValue == null)		{
			clearFunction(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setFunction(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearFunction(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(FUNCTION_COMPLEMENT) ||
			newValue.toString().replace("\"","").equals(FUNCTION_ALPHAREPLICATE) ||
			newValue.toString().replace("\"","").equals(FUNCTION_)))
		{
			String warningMessage = "[info] MultiTexture function newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!functionWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"COMPLEMENT\", \"ALPHAREPLICATE\", \"\"";
			    functionWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setFunction(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString function field, similar to {@link #setFunction(String[])}.
	 * @param newValue is new value for the function field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setFunction(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearFunction(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearFunction(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(FUNCTION_COMPLEMENT) ||
			newValue.toString().replace("\"","").equals(FUNCTION_ALPHAREPLICATE) ||
			newValue.toString().replace("\"","").equals(FUNCTION_)))
		{
			String warningMessage = "[info] MultiTexture function newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!functionWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"COMPLEMENT\", \"ALPHAREPLICATE\", \"\"";
			    functionWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearFunction(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setFunction(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of function field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public MultiTexture clearFunction()
	{
		function.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString function field.
	 * @param newValue is new value to add to the function field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addFunction(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !function.contains(newValue))
            function.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString function field.
	 * @param newValue is new value to add to the function field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addFunction(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !function.contains(newValue.getValue()))
            function.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public MultiTexture clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public MultiTexture clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public MultiTexture setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide array of String enumeration results (baseType MFString) ['"ADD"' | '"ADDSIGNED"' | '"ADDSIGNED2X"' | '"ADDSMOOTH"' | '"BLENDCURRENTALPHA"' | '"BLENDDIFFUSEALPHA"' | '"BLENDFACTORALPHA"' | '"BLENDTEXTUREALPHA"' | '"DOTPRODUCT3"' | '"MODULATE"' | '"MODULATE2X"' | '"MODULATE4X"' | '"MODULATEALPHA_ADDCOLOR"' | '"MODULATEINVALPHA_ADDCOLOR"' | '"MODULATEINVCOLOR_ADDALPHA"' | '"OFF"' | '"REPLACE"' | '"SELECTARG1"' | '"SELECTARG2"' | '"SUBTRACT"' | '"etc."'] from inputOutput MFString field named <i>mode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  mode field indicates the type of blending operation, both for color and for alpha channel. Hint: include the same number of mode values as textures, otherwise the default value MODULATE is added for each remaining stage. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: X3D Architecture Table 18.3 Multitexture modes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-MultitextureModes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-MultitextureModes&lt;/a&gt; for further details.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #MODE_ADD ADD}, {@link #MODE_ADDSIGNED ADDSIGNED}, {@link #MODE_ADDSIGNED2X ADDSIGNED2X}, {@link #MODE_ADDSMOOTH ADDSMOOTH}, {@link #MODE_BLENDCURRENTALPHA BLENDCURRENTALPHA}, {@link #MODE_BLENDDIFFUSEALPHA BLENDDIFFUSEALPHA}, {@link #MODE_BLENDFACTORALPHA BLENDFACTORALPHA}, {@link #MODE_BLENDTEXTUREALPHA BLENDTEXTUREALPHA}, {@link #MODE_DOTPRODUCT3 DOTPRODUCT3}, {@link #MODE_MODULATE MODULATE}, {@link #MODE_MODULATE2X MODULATE2X}, {@link #MODE_MODULATE4X MODULATE4X}, {@link #MODE_MODULATEALPHA_ADDCOLOR MODULATEALPHA_ADDCOLOR}, {@link #MODE_MODULATEINVALPHA_ADDCOLOR MODULATEINVALPHA_ADDCOLOR}, {@link #MODE_MODULATEINVCOLOR_ADDALPHA MODULATEINVCOLOR_ADDALPHA}, {@link #MODE_OFF OFF}, {@link #MODE_REPLACE REPLACE}, {@link #MODE_SELECTARG1 SELECTARG1}, {@link #MODE_SELECTARG2 SELECTARG2}, {@link #MODE_SUBTRACT SUBTRACT}.
	 * @return value of mode field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Mode, $memberObjectName=mode, $memberObjectName=mode)

	public String[] getMode()
	{
		final String[] valuesArray = new String[mode.size()];
		int i = 0;
		for (String arrayElement : mode) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString mode field, similar to {@link #getMode()}.
	 * @return value of mode field
	 */
	public ArrayList<String> getModeList()
	{
		return mode;
	}
	/**
	 * Utility method to get String value of MFString mode field, similar to {@link #getMode()}.
	 * @return value of mode field
	 */
	public String getModeString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : mode) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""ADD"" | ""ADDSIGNED"" | ""ADDSIGNED2X"" | ""ADDSMOOTH"" | ""BLENDCURRENTALPHA"" | ""BLENDDIFFUSEALPHA"" | ""BLENDFACTORALPHA"" | ""BLENDTEXTUREALPHA"" | ""DOTPRODUCT3"" | ""MODULATE"" | ""MODULATE2X"" | ""MODULATE4X"" | ""MODULATEALPHA_ADDCOLOR"" | ""MODULATEINVALPHA_ADDCOLOR"" | ""MODULATEINVCOLOR_ADDALPHA"" | ""OFF"" | ""REPLACE"" | ""SELECTARG1"" | ""SELECTARG2"" | ""SUBTRACT"") to inputOutput MFString field named <i>mode</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #MODE_ADD ADD}, {@link #MODE_ADDSIGNED ADDSIGNED}, {@link #MODE_ADDSIGNED2X ADDSIGNED2X}, {@link #MODE_ADDSMOOTH ADDSMOOTH}, {@link #MODE_BLENDCURRENTALPHA BLENDCURRENTALPHA}, {@link #MODE_BLENDDIFFUSEALPHA BLENDDIFFUSEALPHA}, {@link #MODE_BLENDFACTORALPHA BLENDFACTORALPHA}, {@link #MODE_BLENDTEXTUREALPHA BLENDTEXTUREALPHA}, {@link #MODE_DOTPRODUCT3 DOTPRODUCT3}, {@link #MODE_MODULATE MODULATE}, {@link #MODE_MODULATE2X MODULATE2X}, {@link #MODE_MODULATE4X MODULATE4X}, {@link #MODE_MODULATEALPHA_ADDCOLOR MODULATEALPHA_ADDCOLOR}, {@link #MODE_MODULATEINVALPHA_ADDCOLOR MODULATEINVALPHA_ADDCOLOR}, {@link #MODE_MODULATEINVCOLOR_ADDALPHA MODULATEINVCOLOR_ADDALPHA}, {@link #MODE_OFF OFF}, {@link #MODE_REPLACE REPLACE}, {@link #MODE_SELECTARG1 SELECTARG1}, {@link #MODE_SELECTARG2 SELECTARG2}, {@link #MODE_SUBTRACT SUBTRACT}).
	 * <br><br>
	 * <i>Tooltip:</i>  mode field indicates the type of blending operation, both for color and for alpha channel. Hint: include the same number of mode values as textures, otherwise the default value MODULATE is added for each remaining stage. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Hint: X3D Architecture Table 18.3 Multitexture modes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-MultitextureModes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-MultitextureModes&lt;/a&gt; for further details.  * <br>

	 * @param newValue is new value for the mode field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setMode(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearMode(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(MODE_ADD) ||
			newValue[i].toString().replace("\"","").equals(MODE_ADDSIGNED) ||
			newValue[i].toString().replace("\"","").equals(MODE_ADDSIGNED2X) ||
			newValue[i].toString().replace("\"","").equals(MODE_ADDSMOOTH) ||
			newValue[i].toString().replace("\"","").equals(MODE_BLENDCURRENTALPHA) ||
			newValue[i].toString().replace("\"","").equals(MODE_BLENDDIFFUSEALPHA) ||
			newValue[i].toString().replace("\"","").equals(MODE_BLENDFACTORALPHA) ||
			newValue[i].toString().replace("\"","").equals(MODE_BLENDTEXTUREALPHA) ||
			newValue[i].toString().replace("\"","").equals(MODE_DOTPRODUCT3) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATE) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATE2X) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATE4X) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATEALPHA_ADDCOLOR) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATEINVALPHA_ADDCOLOR) ||
			newValue[i].toString().replace("\"","").equals(MODE_MODULATEINVCOLOR_ADDALPHA) ||
			newValue[i].toString().replace("\"","").equals(MODE_OFF) ||
			newValue[i].toString().replace("\"","").equals(MODE_REPLACE) ||
			newValue[i].toString().replace("\"","").equals(MODE_SELECTARG1) ||
			newValue[i].toString().replace("\"","").equals(MODE_SELECTARG2) ||
			newValue[i].toString().replace("\"","").equals(MODE_SUBTRACT)))
		{
			String warningMessage = "[info] MultiTexture mode newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!modeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ADD\", \"ADDSIGNED\", \"ADDSIGNED2X\", \"ADDSMOOTH\", \"BLENDCURRENTALPHA\", \"BLENDDIFFUSEALPHA\", \"BLENDFACTORALPHA\", \"BLENDTEXTUREALPHA\", \"DOTPRODUCT3\", \"MODULATE\", \"MODULATE2X\", \"MODULATE4X\", \"MODULATEALPHA_ADDCOLOR\", \"MODULATEINVALPHA_ADDCOLOR\", \"MODULATEINVCOLOR_ADDALPHA\", \"OFF\", \"REPLACE\", \"SELECTARG1\", \"SELECTARG2\", \"SUBTRACT\"";
			    modeWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearMode(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearMode(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			mode.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString mode field, similar to {@link #setMode(String[])}.
	 * @param newValue is new value for the mode field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setMode(MFString newValue)
	{
		if (newValue == null)		{
			clearMode(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setMode(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString mode field, similar to {@link #setMode(String[])}.
	 * @param newValue is new value for the mode field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setMode(SFString newValue)
	{
		if (newValue == null)		{
			clearMode(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setMode(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearMode(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(MODE_ADD) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED2X) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSMOOTH) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDCURRENTALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDDIFFUSEALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDFACTORALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDTEXTUREALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_DOTPRODUCT3) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE2X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE4X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVCOLOR_ADDALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_OFF) ||
			newValue.toString().replace("\"","").equals(MODE_REPLACE) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG1) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG2) ||
			newValue.toString().replace("\"","").equals(MODE_SUBTRACT)))
		{
			String warningMessage = "[info] MultiTexture mode newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!modeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ADD\", \"ADDSIGNED\", \"ADDSIGNED2X\", \"ADDSMOOTH\", \"BLENDCURRENTALPHA\", \"BLENDDIFFUSEALPHA\", \"BLENDFACTORALPHA\", \"BLENDTEXTUREALPHA\", \"DOTPRODUCT3\", \"MODULATE\", \"MODULATE2X\", \"MODULATE4X\", \"MODULATEALPHA_ADDCOLOR\", \"MODULATEINVALPHA_ADDCOLOR\", \"MODULATEINVCOLOR_ADDALPHA\", \"OFF\", \"REPLACE\", \"SELECTARG1\", \"SELECTARG2\", \"SUBTRACT\"";
			    modeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setMode(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString mode field, similar to {@link #setMode(String[])}.
	 * @param newValue is new value for the mode field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setMode(String newValue)
	{
		if (newValue == null)		{
			clearMode(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setMode(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearMode(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(MODE_ADD) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED2X) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSMOOTH) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDCURRENTALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDDIFFUSEALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDFACTORALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDTEXTUREALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_DOTPRODUCT3) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE2X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE4X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVCOLOR_ADDALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_OFF) ||
			newValue.toString().replace("\"","").equals(MODE_REPLACE) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG1) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG2) ||
			newValue.toString().replace("\"","").equals(MODE_SUBTRACT)))
		{
			String warningMessage = "[info] MultiTexture mode newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!modeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ADD\", \"ADDSIGNED\", \"ADDSIGNED2X\", \"ADDSMOOTH\", \"BLENDCURRENTALPHA\", \"BLENDDIFFUSEALPHA\", \"BLENDFACTORALPHA\", \"BLENDTEXTUREALPHA\", \"DOTPRODUCT3\", \"MODULATE\", \"MODULATE2X\", \"MODULATE4X\", \"MODULATEALPHA_ADDCOLOR\", \"MODULATEINVALPHA_ADDCOLOR\", \"MODULATEINVCOLOR_ADDALPHA\", \"OFF\", \"REPLACE\", \"SELECTARG1\", \"SELECTARG2\", \"SUBTRACT\"";
			    modeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setMode(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString mode field, similar to {@link #setMode(String[])}.
	 * @param newValue is new value for the mode field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setMode(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearMode(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearMode(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(MODE_ADD) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSIGNED2X) ||
			newValue.toString().replace("\"","").equals(MODE_ADDSMOOTH) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDCURRENTALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDDIFFUSEALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDFACTORALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_BLENDTEXTUREALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_DOTPRODUCT3) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE2X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATE4X) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVALPHA_ADDCOLOR) ||
			newValue.toString().replace("\"","").equals(MODE_MODULATEINVCOLOR_ADDALPHA) ||
			newValue.toString().replace("\"","").equals(MODE_OFF) ||
			newValue.toString().replace("\"","").equals(MODE_REPLACE) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG1) ||
			newValue.toString().replace("\"","").equals(MODE_SELECTARG2) ||
			newValue.toString().replace("\"","").equals(MODE_SUBTRACT)))
		{
			String warningMessage = "[info] MultiTexture mode newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!modeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ADD\", \"ADDSIGNED\", \"ADDSIGNED2X\", \"ADDSMOOTH\", \"BLENDCURRENTALPHA\", \"BLENDDIFFUSEALPHA\", \"BLENDFACTORALPHA\", \"BLENDTEXTUREALPHA\", \"DOTPRODUCT3\", \"MODULATE\", \"MODULATE2X\", \"MODULATE4X\", \"MODULATEALPHA_ADDCOLOR\", \"MODULATEINVALPHA_ADDCOLOR\", \"MODULATEINVCOLOR_ADDALPHA\", \"OFF\", \"REPLACE\", \"SELECTARG1\", \"SELECTARG2\", \"SUBTRACT\"";
			    modeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearMode(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setMode(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of mode field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public MultiTexture clearMode()
	{
		mode.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString mode field.
	 * @param newValue is new value to add to the mode field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addMode(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !mode.contains(newValue))
            mode.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString mode field.
	 * @param newValue is new value to add to the mode field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addMode(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !mode.contains(newValue.getValue()))
            mode.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide array of String enumeration results (baseType MFString) ['"DIFFUSE"' | '"FACTOR"' | '"SPECULAR"' | '""' | '"etc."'] from inputOutput MFString field named <i>source</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  source field determines whether each image source is treated as DIFFUSE, SPECULAR or a multiplicative FACTOR. Empty string value "" indicates that no source modifier is applied for that stage. Hint: include the same number of source values as textures, otherwise the default of no source interpretation is applied for each remaining stage. Hint: X3D Architecture Table 18.4 Values for the source field &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForSourceField" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForSourceField&lt;/a&gt; for further details.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #SOURCE_DIFFUSE DIFFUSE}, {@link #SOURCE_FACTOR FACTOR}, {@link #SOURCE_SPECULAR SPECULAR}, {@link #SOURCE_ }.
	 * @return value of source field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Source, $memberObjectName=source, $memberObjectName=source)

	public String[] getSource()
	{
		final String[] valuesArray = new String[source.size()];
		int i = 0;
		for (String arrayElement : source) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString source field, similar to {@link #getSource()}.
	 * @return value of source field
	 */
	public ArrayList<String> getSourceList()
	{
		return source;
	}
	/**
	 * Utility method to get String value of MFString source field, similar to {@link #getSource()}.
	 * @return value of source field
	 */
	public String getSourceString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : source) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""DIFFUSE"" | ""FACTOR"" | ""SPECULAR"" | """") to inputOutput MFString field named <i>source</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #SOURCE_DIFFUSE DIFFUSE}, {@link #SOURCE_FACTOR FACTOR}, {@link #SOURCE_SPECULAR SPECULAR}, {@link #SOURCE_ }).
	 * <br><br>
	 * <i>Tooltip:</i>  source field determines whether each image source is treated as DIFFUSE, SPECULAR or a multiplicative FACTOR. Empty string value "" indicates that no source modifier is applied for that stage. Hint: include the same number of source values as textures, otherwise the default of no source interpretation is applied for each remaining stage. Hint: X3D Architecture Table 18.4 Values for the source field &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForSourceField" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html#t-ValuesForSourceField&lt;/a&gt; for further details.  * <br>

	 * @param newValue is new value for the source field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setSource(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearSource(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(SOURCE_DIFFUSE) ||
			newValue[i].toString().replace("\"","").equals(SOURCE_FACTOR) ||
			newValue[i].toString().replace("\"","").equals(SOURCE_SPECULAR) ||
			newValue[i].toString().replace("\"","").equals(SOURCE_)))
		{
			String warningMessage = "[info] MultiTexture source newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!sourceWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"DIFFUSE\", \"FACTOR\", \"SPECULAR\", \"\"";
			    sourceWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearSource(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearSource(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			source.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString source field, similar to {@link #setSource(String[])}.
	 * @param newValue is new value for the source field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setSource(MFString newValue)
	{
		if (newValue == null)		{
			clearSource(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSource(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString source field, similar to {@link #setSource(String[])}.
	 * @param newValue is new value for the source field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setSource(SFString newValue)
	{
		if (newValue == null)		{
			clearSource(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setSource(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearSource(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(SOURCE_DIFFUSE) ||
			newValue.toString().replace("\"","").equals(SOURCE_FACTOR) ||
			newValue.toString().replace("\"","").equals(SOURCE_SPECULAR) ||
			newValue.toString().replace("\"","").equals(SOURCE_)))
		{
			String warningMessage = "[info] MultiTexture source newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!sourceWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"DIFFUSE\", \"FACTOR\", \"SPECULAR\", \"\"";
			    sourceWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setSource(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString source field, similar to {@link #setSource(String[])}.
	 * @param newValue is new value for the source field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setSource(String newValue)
	{
		if (newValue == null)		{
			clearSource(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setSource(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearSource(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(SOURCE_DIFFUSE) ||
			newValue.toString().replace("\"","").equals(SOURCE_FACTOR) ||
			newValue.toString().replace("\"","").equals(SOURCE_SPECULAR) ||
			newValue.toString().replace("\"","").equals(SOURCE_)))
		{
			String warningMessage = "[info] MultiTexture source newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!sourceWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"DIFFUSE\", \"FACTOR\", \"SPECULAR\", \"\"";
			    sourceWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setSource(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString source field, similar to {@link #setSource(String[])}.
	 * @param newValue is new value for the source field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setSource(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearSource(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearSource(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(SOURCE_DIFFUSE) ||
			newValue.toString().replace("\"","").equals(SOURCE_FACTOR) ||
			newValue.toString().replace("\"","").equals(SOURCE_SPECULAR) ||
			newValue.toString().replace("\"","").equals(SOURCE_)))
		{
			String warningMessage = "[info] MultiTexture source newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!sourceWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"DIFFUSE\", \"FACTOR\", \"SPECULAR\", \"\"";
			    sourceWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearSource(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setSource(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of source field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public MultiTexture clearSource()
	{
		source.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString source field.
	 * @param newValue is new value to add to the source field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addSource(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !source.contains(newValue))
            source.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString source field.
	 * @param newValue is new value to add to the source field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture addSource(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !source.contains(newValue.getValue()))
            source.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide array of  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] Contained texture nodes (ImageTexture, MovieTexture, PixelTexture) that map image(s) to surface geometry, defining each of the different texture channels. Warning: MultiTexture may not contain another MultiTexture node. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DSingleTextureNode.
	 * @see org.web3d.x3d.sai.Texturing.X3DSingleTextureNode
	 * @return value of texture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=Texture, $memberObjectName=texture, $memberObjectName=texture)

	public org.web3d.x3d.sai.Core.X3DNode[] getTexture()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[texture.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : texture) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode texture field, similar to {@link #getTexture()}.
	 * @return value of texture field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getTextureList()
	{
		return texture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>texture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] Contained texture nodes (ImageTexture, MovieTexture, PixelTexture) that map image(s) to surface geometry, defining each of the different texture channels. Warning: MultiTexture may not contain another MultiTexture node. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DSingleTextureNode.
	 * @param newValue is new value for the texture field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public MultiTexture setTexture(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)			// reset value field to empty array
		{
			clearTexture(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearTexture(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				texture.add((org.web3d.x3d.sai.Core.X3DNode)newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest12
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
		}
		return this;
	}

	/**
	 * Assign ArrayList value of MFNode texture field, similar to {@link #setTexture(org.web3d.x3d.sai.Core.X3DNode[])}.
	 * @param newValue is new value for the texture field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setTexture(ArrayList< org.web3d.x3d.sai.Texturing.X3DSingleTextureNode> newValue)
	{
		if (newValue == null)			// reset value field to empty array
		{
			clearTexture(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearTexture(); // reset
        else
        {
            org.web3d.x3d.sai.Core.X3DNode[] newArray = new org.web3d.x3d.sai.Core.X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setTexture(newArray);
        }
		for ( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode element : newValue)
		{
			texture.add((org.web3d.x3d.sai.Core.X3DNode) element);
			((X3DConcreteElement) element).setParent(this); // parentTest13
		}
		return this;
	}
	/**
	 * Add single child node to existing array of texture nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DSingleTextureNode and ProtoInstance.
	 * @param newValue is new value to be appended the texture field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public MultiTexture addTexture(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		texture.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest2
		return this;
	}
	/**
	 * Add single ProtoInstance (with appropriate node type and containerField value) to MFNode array for texture field.
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to ShaderPart and ProtoInstance.
	 * @param newValue is new value to be appended the parts field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public MultiTexture addTexture(ProtoInstance newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		texture.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest16
		return this;
	}
	/**
	 * Add array of child texture nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DSingleTextureNode.
	 * @param newValue is new value array to be appended the texture field.
	 */
	public void addTexture(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				texture.add(newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest6
				if (newValue[i] instanceof ProtoInstance)
					((ProtoInstance) newValue[i]).setContainerField("texture");
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
		}
	}

	/**
	 * Set single child texture node, replacing prior array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are restricted to X3DSingleTextureNode.
	 * @param newValue is new node for the texture field (restricted to X3DSingleTextureNode)
	 */
	/* @Override */
	public void setTexture(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null)
		{
			clearTexture(); // reset newValueNullClearsFieldReturnVoid
			return;
		}
		if  (newValue instanceof org.web3d.x3d.sai.Core.X3DNode)
		{
			for (org.web3d.x3d.sai.Core.X3DNode element : texture)
				((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
			clearTexture(); // reset
			((X3DConcreteElement) newValue).setParent(this); // parentTest8
			texture.add(newValue);
		}
		else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
}
	/**
	 * Utility method to clear MFNode value of texture field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public MultiTexture clearTexture()
	{
		for (org.web3d.x3d.sai.Core.X3DNode element : texture)
			((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
		texture.clear(); // reset MF field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput MFNode field <i>texture</i>.
	 * @return whether a properly typed node or ProtoInstance array or CommentsBlock is available.
	 * @see #getTexture()
	 */
	public boolean hasTexture()
	{
		return (!texture.isEmpty());
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final MultiTexture setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to MultiTexture DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final MultiTexture setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to MultiTexture USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("MultiTexture USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final MultiTexture setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final MultiTexture setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DTextureNode, $additionalInheritanceBaseType=, $thisClassName=MultiTexture, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final MultiTexture setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public MultiTexture setUSE(MultiTexture DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on MultiTexture" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public MultiTexture (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public MultiTexture addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public MultiTexture addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link MultiTexture} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public MultiTexture addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (!texture.isEmpty()) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<MultiTexture"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getAlpha() != ALPHA_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" alpha='").append(SFFloat.toString(getAlpha())).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getColor(), COLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" color='").append(SFColor.toString(getColor())).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if (((getFunction().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" function='").append(new MFString(getFunction()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getMode().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" mode='").append(new MFString(getMode()).toStringX3D()).append("'");
			}
			if (((getSource().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" source='").append(new MFString(getSource()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			for (org.web3d.x3d.sai.Core.X3DNode element : texture)
			{
				stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</MultiTexture>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=MultiTexture, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (!texture.isEmpty()) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("MultiTexture").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("alpha"))
						{
							stringClassicVRML.append(indentCharacter).append("alpha").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAlpha() != ALPHA_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("alpha ").append(SFFloat.toString(getAlpha())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("color"))
						{
							stringClassicVRML.append(indentCharacter).append("color").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getColor(), COLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("color ").append(SFColor.toString(getColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("function"))
						{
							stringClassicVRML.append(indentCharacter).append("function").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getFunction().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("function ").append("[ ").append(MFString.toString(getFunction())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("mode"))
						{
							stringClassicVRML.append(indentCharacter).append("mode").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getMode().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("mode ").append("[ ").append(MFString.toString(getMode())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("source"))
						{
							stringClassicVRML.append(indentCharacter).append("source").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getSource().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("source ").append("[ ").append(MFString.toString(getSource())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (texture.size() > 0)
			{
				stringClassicVRML.append(indentCharacter).append(indentCharacter).append("texture").append(" [").append("\n")
					.append(indent).append(indentCharacter).append(indentCharacter); // containerField for MFNode array
			for (org.web3d.x3d.sai.Core.X3DNode element : texture)
			{
				stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
			}
				stringClassicVRML.append(indent).append(indentCharacter).append(indentCharacter).append("]").append("\n")
					.append(indent); // end MFNode array
			}

			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : texture) // MFNode
		{
			if (element instanceof X3DConcreteElement)
			{
				referenceElement = ((X3DConcreteElement) element).findElementByNameValue(nameValue, elementName);
				if (referenceElement != null)
					return referenceElement;
			}
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : texture) // MFNode
		{
			if (element instanceof org.web3d.x3d.jsail.X3DConcreteNode)
			{
				referenceNode = ((X3DConcreteElement) element).findNodeByDEF(DEFvalue);
				if (referenceNode != null)
					return referenceNode;
			}
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setAlpha(getAlpha()); // exercise field checks, simple types
        
		setColor(getColor()); // exercise field checks, simple types
        
		setDescription(getDescription()); // exercise field checks, simple types
        
		setFunction(getFunction()); // exercise field checks, simple types
        
		setMode(getMode()); // exercise field checks, simple types
        
		setSource(getSource()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "MultiTexture USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "MultiTexture USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "MultiTexture USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "MultiTexture USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		for (org.web3d.x3d.sai.Core.X3DNode element : texture) // MFNode
		{
			try {
                            ((X3DConcreteElement) element).validate(); // exercise field checks, MFNode element
                            validationResult.append(((X3DConcreteElement) element).getValidationResult());
                        }
                        catch (Exception e)
                        {
                            String exceptionMessage = "[exception] during validation: " + e.getMessage();
                            validationResult.append(exceptionMessage);
                        //  System.err.println(exceptionMessage);
                            e.printStackTrace();
                        }
		}
		setTexture(getTexture()); // also test getter/setter validation, which also includes checks for acceptableNodeTypes (if applicable)

		if (hasUSE() && hasTexture()) // test USE restrictions
		{
			String errorNotice = "MultiTexture USE='" + getUSE() + "' is not allowed to have contained MFNode texture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'MultiTexture' node, ensure sufficient support by adding head statement <component name='Texturing' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Texturing\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
