/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Sound.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;

/**
 * BufferAudioSource node represents a memory-resident audio asset that can contain one or more channels.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 4.0 draft) [X3DSoundSourceNode] BufferAudioSource node represents a memory-resident audio asset that can contain one or more channels. Typically the length of the Pulse Coded Modulation (PCM) data is expected to be fairly short (usually somewhat less than a minute).
Warning: for longer sounds, such as music soundtracks, streaming such as StreamAudioSource should be used.
Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#AudioBufferSourceNode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#AudioBufferSourceNode&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/sound.html#BufferAudioSource" target="blank">X3D Abstract Specification: BufferAudioSource</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#BufferAudioSource" target="_blank">X3D Tooltips: BufferAudioSource</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class BufferAudioSource extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Sound.BufferAudioSource
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=autoRefresh, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=autoRefresh, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double autoRefresh; //  X3D field type: SFTime

    /* @name=autoRefreshTimeLimit, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=autoRefreshTimeLimit, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double autoRefreshTimeLimit; //  X3D field type: SFTime

    /* @name=buffer, @type=MFFloat, $javaType=ArrayList<Float>, $javaReferenceType=Float, $javaPrimitiveType=ArrayList<Float>, $normalizedMemberObjectName=buffer, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<Float> buffer = new ArrayList<>(); //  X3D field type: MFFloat

    /* @name=bufferDuration, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=bufferDuration, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double bufferDuration; //  X3D field type: SFTime

    /* @name=bufferlength, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=bufferlength, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int bufferlength; //  X3D field type: SFInt32

    /* @name=channelCount, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=channelCount, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int channelCount; //  X3D field type: SFInt32

    /* @name=channelCountMode, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=channelCountMode, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String channelCountMode = new String(); //  X3D field type: SFString

    /* @name=channelInterpretation, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=channelInterpretation, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String channelInterpretation = new String(); //  X3D field type: SFString

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=detune, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=detune, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float detune; //  X3D field type: SFFloat

    /* @name=elapsedTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=elapsedTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double elapsedTime; //  X3D field type: SFTime

    /* @name=enabled, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=enabled, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean enabled; //  X3D field type: SFBool

    /* @name=gain, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=gain, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float gain; //  X3D field type: SFFloat

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=isActive, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isActive, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isActive; //  X3D field type: SFBool

    /* @name=isPaused, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isPaused, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isPaused; //  X3D field type: SFBool

    /* @name=length, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=length, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int length; //  X3D field type: SFInt32

    /* @name=load, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=load, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean load; //  X3D field type: SFBool

    /* @name=loop, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=loop, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean loop; //  X3D field type: SFBool

    /* @name=loopEnd, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=loopEnd, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float loopEnd; //  X3D field type: SFFloat

    /* @name=loopStart, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=loopStart, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float loopStart; //  X3D field type: SFFloat

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=numberOfChannels, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=numberOfChannels, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int numberOfChannels; //  X3D field type: SFInt32

    /* @name=pauseTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=pauseTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double pauseTime; //  X3D field type: SFTime

    /* @name=playbackRate, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=playbackRate, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float playbackRate; //  X3D field type: SFFloat

    /* @name=resumeTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=resumeTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double resumeTime; //  X3D field type: SFTime

    /* @name=sampleRate, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=sampleRate, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float sampleRate; //  X3D field type: SFFloat

    /* @name=startTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=startTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double startTime; //  X3D field type: SFTime

    /* @name=stopTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=stopTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double stopTime; //  X3D field type: SFTime

    /* @name=url, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=url, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> url = new ArrayList<>(); //  X3D field type: MFString

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean channelCountModeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> X3D version of "max" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"MAX"</i> (Java syntax) or <i>MAX</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_MAX_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_MAX = "MAX";
	/** SFString SFString enumeration value "<i>MAX</i>" has alias "<i>max</i>"
	 * @see #CHANNELCOUNTMODE_MAX */
	public static final String CHANNELCOUNTMODE_MAX_ALIAS = "max";

	/** 
	 * <i>Tooltip:</i> X3D version of "clamped-max" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"CLAMPED_MAX"</i> (Java syntax) or <i>CLAMPED_MAX</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_CLAMPED_MAX = "CLAMPED_MAX";
	/** SFString SFString enumeration value "<i>CLAMPED_MAX</i>" has alias "<i>clamped-max</i>"
	 * @see #CHANNELCOUNTMODE_CLAMPED_MAX */
	public static final String CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS = "clamped-max";

	/** 
	 * <i>Tooltip:</i> X3D version of "explicit" in Web Audio API.
	 * SFString field named <i>channelCountMode</i> with X3DUOM simpleType <i>channelCountModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"EXPLICIT"</i> (Java syntax) or <i>EXPLICIT</i> (XML syntax).
	 * @see #CHANNELCOUNTMODE_EXPLICIT_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelCountModeChoices.html">XML Schema: channelCountModeChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelcountmode" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelcountmode</a>  */
	public static final String CHANNELCOUNTMODE_EXPLICIT = "EXPLICIT";
	/** SFString SFString enumeration value "<i>EXPLICIT</i>" has alias "<i>explicit</i>"
	 * @see #CHANNELCOUNTMODE_EXPLICIT */
	public static final String CHANNELCOUNTMODE_EXPLICIT_ALIAS = "explicit";

	// special enumeration utility methods

	/** Get alias for this channelCountMode
	 * @param channelCountModeValue of interest
	 * @return alias value, otherwise empty string if not found
	 */
	public static String getChannelCountModeAlias(String channelCountModeValue)
	{
		if      (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_MAX)) return CHANNELCOUNTMODE_MAX_ALIAS;
		else if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_CLAMPED_MAX)) return CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS;
		else if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_EXPLICIT)) return CHANNELCOUNTMODE_EXPLICIT_ALIAS;
		else return ""; // not found
	}
	/** Whether a alias exists for this channelCountMode
	 * @param channelCountMode of interest
	 * @return true if found
	 */
	public static boolean hasChannelCountModeAlias(String channelCountMode)
	{
		return !getChannelCountModeAlias(channelCountMode).isEmpty();
	}

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean channelInterpretationWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> X3D version of "speakers" in Web Audio API.
	 * SFString field named <i>channelInterpretation</i> with X3DUOM simpleType <i>channelInterpretationChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"SPEAKERS"</i> (Java syntax) or <i>SPEAKERS</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelInterpretationChoices.html">XML Schema: channelInterpretationChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation</a>  */
	public static final String CHANNELINTERPRETATION_SPEAKERS = "SPEAKERS";

	/** 
	 * <i>Tooltip:</i> X3D version of "discrete" in Web Audio API.
	 * SFString field named <i>channelInterpretation</i> with X3DUOM simpleType <i>channelInterpretationChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"DISCRETE"</i> (Java syntax) or <i>DISCRETE</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_channelInterpretationChoices.html">XML Schema: channelInterpretationChoices</a>
	 * @see  <a href="https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation" target="_blank">https://www.w3.org/TR/webaudio/#enumdef-channelinterpretation</a>  */
	public static final String CHANNELINTERPRETATION_DISCRETE = "DISCRETE";

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>BufferAudioSource</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "BufferAudioSource";

	/** Provides name of this element: <i>BufferAudioSource</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>BufferAudioSource</i> element: <i>Sound</i> */
	public static final String COMPONENT = "Sound";

	/** Defines X3D component for the <i>BufferAudioSource</i> element: <i>Sound</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Sound</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFTime field named <i>autoRefresh</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double AUTOREFRESH_DEFAULT_VALUE = 0;

	/** SFTime field named <i>autoRefreshTimeLimit</i> has default value <i>3600</i> (Java syntax) or <i>3600</i> (XML syntax). */
	public static final double AUTOREFRESHTIMELIMIT_DEFAULT_VALUE = 3600;

	/** MFFloat field named <i>buffer</i> has default value equal to an empty list. */
	public static final ArrayList<Float> BUFFER_DEFAULT_VALUE = new ArrayList<>(Arrays.asList());

	/** SFTime field named <i>bufferDuration</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double BUFFERDURATION_DEFAULT_VALUE = 0;

	/** SFString field named <i>channelCountMode</i> has default value <i>"MAX"</i> (Java syntax) or <i>MAX</i> (XML syntax). */
	public static final String CHANNELCOUNTMODE_DEFAULT_VALUE = "MAX";

	/** SFString field named <i>channelInterpretation</i> has default value <i>"SPEAKERS"</i> (Java syntax) or <i>SPEAKERS</i> (XML syntax). */
	public static final String CHANNELINTERPRETATION_DEFAULT_VALUE = "SPEAKERS";

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** SFFloat field named <i>detune</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float DETUNE_DEFAULT_VALUE = 0f;

	/** SFBool field named <i>enabled</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean ENABLED_DEFAULT_VALUE = true;

	/** SFFloat field named <i>gain</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float GAIN_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFBool field named <i>load</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean LOAD_DEFAULT_VALUE = true;

	/** SFBool field named <i>loop</i> has default value <i>false</i> (Java syntax) or <i>false</i> (XML syntax). */
	public static final boolean LOOP_DEFAULT_VALUE = false;

	/** SFFloat field named <i>loopEnd</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float LOOPEND_DEFAULT_VALUE = 0f;

	/** SFFloat field named <i>loopStart</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float LOOPSTART_DEFAULT_VALUE = 0f;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFInt32 field named <i>numberOfChannels</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final int NUMBEROFCHANNELS_DEFAULT_VALUE = 0;

	/** SFTime field named <i>pauseTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double PAUSETIME_DEFAULT_VALUE = 0;

	/** SFFloat field named <i>playbackRate</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float PLAYBACKRATE_DEFAULT_VALUE = 1f;

	/** SFTime field named <i>resumeTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double RESUMETIME_DEFAULT_VALUE = 0;

	/** SFFloat field named <i>sampleRate</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float SAMPLERATE_DEFAULT_VALUE = 0f;

	/** SFTime field named <i>startTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double STARTTIME_DEFAULT_VALUE = 0;

	/** SFTime field named <i>stopTime</i> has default value <i>0</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final double STOPTIME_DEFAULT_VALUE = 0;

	/** MFString field named <i>url</i> has default value equal to an empty list. */
	public static final ArrayList<String> URL_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList());

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "autoRefresh":
				result = "SFTime";
				break;
			case "autoRefreshTimeLimit":
				result = "SFTime";
				break;
			case "buffer":
				result = "MFFloat";
				break;
			case "bufferDuration":
				result = "SFTime";
				break;
			case "bufferlength":
				result = "SFInt32";
				break;
			case "channelCount":
				result = "SFInt32";
				break;
			case "channelCountMode":
				result = "SFString";
				break;
			case "channelInterpretation":
				result = "SFString";
				break;
			case "description":
				result = "SFString";
				break;
			case "detune":
				result = "SFFloat";
				break;
			case "elapsedTime":
				result = "SFTime";
				break;
			case "enabled":
				result = "SFBool";
				break;
			case "gain":
				result = "SFFloat";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "isActive":
				result = "SFBool";
				break;
			case "isPaused":
				result = "SFBool";
				break;
			case "length":
				result = "SFInt32";
				break;
			case "load":
				result = "SFBool";
				break;
			case "loop":
				result = "SFBool";
				break;
			case "loopEnd":
				result = "SFFloat";
				break;
			case "loopStart":
				result = "SFFloat";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "numberOfChannels":
				result = "SFInt32";
				break;
			case "pauseTime":
				result = "SFTime";
				break;
			case "playbackRate":
				result = "SFFloat";
				break;
			case "resumeTime":
				result = "SFTime";
				break;
			case "sampleRate":
				result = "SFFloat";
				break;
			case "startTime":
				result = "SFTime";
				break;
			case "stopTime":
				result = "SFTime";
				break;
			case "url":
				result = "MFString";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "autoRefresh":
				result = "inputOutput";
				break;
			case "autoRefreshTimeLimit":
				result = "inputOutput";
				break;
			case "buffer":
				result = "inputOutput";
				break;
			case "bufferDuration":
				result = "inputOutput";
				break;
			case "bufferlength":
				result = "outputOnly";
				break;
			case "channelCount":
				result = "outputOnly";
				break;
			case "channelCountMode":
				result = "inputOutput";
				break;
			case "channelInterpretation":
				result = "inputOutput";
				break;
			case "description":
				result = "inputOutput";
				break;
			case "detune":
				result = "inputOutput";
				break;
			case "elapsedTime":
				result = "outputOnly";
				break;
			case "enabled":
				result = "inputOutput";
				break;
			case "gain":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "isActive":
				result = "outputOnly";
				break;
			case "isPaused":
				result = "outputOnly";
				break;
			case "length":
				result = "outputOnly";
				break;
			case "load":
				result = "inputOutput";
				break;
			case "loop":
				result = "inputOutput";
				break;
			case "loopEnd":
				result = "inputOutput";
				break;
			case "loopStart":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "numberOfChannels":
				result = "inputOutput";
				break;
			case "pauseTime":
				result = "inputOutput";
				break;
			case "playbackRate":
				result = "inputOutput";
				break;
			case "resumeTime":
				result = "inputOutput";
				break;
			case "sampleRate":
				result = "inputOutput";
				break;
			case "startTime":
				result = "inputOutput";
				break;
			case "stopTime":
				result = "inputOutput";
				break;
			case "url":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "children"; // type containerFieldChoicesSoundSource
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFTime field named <i>autoRefresh</i>. */
	public static final String fromField_AUTOREFRESH = "autoRefresh";

	/** toField ROUTE name for SFTime field named <i>autoRefresh</i>. */
	public static final String toField_AUTOREFRESH = "autoRefresh";

	/** fromField ROUTE name for SFTime field named <i>autoRefreshTimeLimit</i>. */
	public static final String fromField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";

	/** toField ROUTE name for SFTime field named <i>autoRefreshTimeLimit</i>. */
	public static final String toField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";

	/** fromField ROUTE name for MFFloat field named <i>buffer</i>. */
	public static final String fromField_BUFFER = "buffer";

	/** toField ROUTE name for MFFloat field named <i>buffer</i>. */
	public static final String toField_BUFFER = "buffer";

	/** fromField ROUTE name for SFTime field named <i>bufferDuration</i>. */
	public static final String fromField_BUFFERDURATION = "bufferDuration";

	/** toField ROUTE name for SFTime field named <i>bufferDuration</i>. */
	public static final String toField_BUFFERDURATION = "bufferDuration";

	/** fromField ROUTE name for SFInt32 field named <i>bufferlength</i>. */
	public static final String fromField_BUFFERLENGTH = "bufferlength";

	/** fromField ROUTE name for SFInt32 field named <i>channelCount</i>. */
	public static final String fromField_CHANNELCOUNT = "channelCount";

	/** fromField ROUTE name for SFString field named <i>channelCountMode</i>. */
	public static final String fromField_CHANNELCOUNTMODE = "channelCountMode";

	/** toField ROUTE name for SFString field named <i>channelCountMode</i>. */
	public static final String toField_CHANNELCOUNTMODE = "channelCountMode";

	/** fromField ROUTE name for SFString field named <i>channelInterpretation</i>. */
	public static final String fromField_CHANNELINTERPRETATION = "channelInterpretation";

	/** toField ROUTE name for SFString field named <i>channelInterpretation</i>. */
	public static final String toField_CHANNELINTERPRETATION = "channelInterpretation";

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for SFFloat field named <i>detune</i>. */
	public static final String fromField_DETUNE = "detune";

	/** toField ROUTE name for SFFloat field named <i>detune</i>. */
	public static final String toField_DETUNE = "detune";

	/** fromField ROUTE name for SFTime field named <i>elapsedTime</i>. */
	public static final String fromField_ELAPSEDTIME = "elapsedTime";

	/** fromField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String fromField_ENABLED = "enabled";

	/** toField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String toField_ENABLED = "enabled";

	/** fromField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String fromField_GAIN = "gain";

	/** toField ROUTE name for SFFloat field named <i>gain</i>. */
	public static final String toField_GAIN = "gain";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFBool field named <i>isActive</i>. */
	public static final String fromField_ISACTIVE = "isActive";

	/** fromField ROUTE name for SFBool field named <i>isPaused</i>. */
	public static final String fromField_ISPAUSED = "isPaused";

	/** fromField ROUTE name for SFInt32 field named <i>length</i>. */
	public static final String fromField_LENGTH = "length";

	/** fromField ROUTE name for SFBool field named <i>load</i>. */
	public static final String fromField_LOAD = "load";

	/** toField ROUTE name for SFBool field named <i>load</i>. */
	public static final String toField_LOAD = "load";

	/** fromField ROUTE name for SFBool field named <i>loop</i>. */
	public static final String fromField_LOOP = "loop";

	/** toField ROUTE name for SFBool field named <i>loop</i>. */
	public static final String toField_LOOP = "loop";

	/** fromField ROUTE name for SFFloat field named <i>loopEnd</i>. */
	public static final String fromField_LOOPEND = "loopEnd";

	/** toField ROUTE name for SFFloat field named <i>loopEnd</i>. */
	public static final String toField_LOOPEND = "loopEnd";

	/** fromField ROUTE name for SFFloat field named <i>loopStart</i>. */
	public static final String fromField_LOOPSTART = "loopStart";

	/** toField ROUTE name for SFFloat field named <i>loopStart</i>. */
	public static final String toField_LOOPSTART = "loopStart";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFInt32 field named <i>numberOfChannels</i>. */
	public static final String fromField_NUMBEROFCHANNELS = "numberOfChannels";

	/** toField ROUTE name for SFInt32 field named <i>numberOfChannels</i>. */
	public static final String toField_NUMBEROFCHANNELS = "numberOfChannels";

	/** fromField ROUTE name for SFTime field named <i>pauseTime</i>. */
	public static final String fromField_PAUSETIME = "pauseTime";

	/** toField ROUTE name for SFTime field named <i>pauseTime</i>. */
	public static final String toField_PAUSETIME = "pauseTime";

	/** fromField ROUTE name for SFFloat field named <i>playbackRate</i>. */
	public static final String fromField_PLAYBACKRATE = "playbackRate";

	/** toField ROUTE name for SFFloat field named <i>playbackRate</i>. */
	public static final String toField_PLAYBACKRATE = "playbackRate";

	/** fromField ROUTE name for SFTime field named <i>resumeTime</i>. */
	public static final String fromField_RESUMETIME = "resumeTime";

	/** toField ROUTE name for SFTime field named <i>resumeTime</i>. */
	public static final String toField_RESUMETIME = "resumeTime";

	/** fromField ROUTE name for SFFloat field named <i>sampleRate</i>. */
	public static final String fromField_SAMPLERATE = "sampleRate";

	/** toField ROUTE name for SFFloat field named <i>sampleRate</i>. */
	public static final String toField_SAMPLERATE = "sampleRate";

	/** fromField ROUTE name for SFTime field named <i>startTime</i>. */
	public static final String fromField_STARTTIME = "startTime";

	/** toField ROUTE name for SFTime field named <i>startTime</i>. */
	public static final String toField_STARTTIME = "startTime";

	/** fromField ROUTE name for SFTime field named <i>stopTime</i>. */
	public static final String fromField_STOPTIME = "stopTime";

	/** toField ROUTE name for SFTime field named <i>stopTime</i>. */
	public static final String toField_STOPTIME = "stopTime";

	/** fromField ROUTE name for MFString field named <i>url</i>. */
	public static final String fromField_URL = "url";

	/** toField ROUTE name for MFString field named <i>url</i>. */
	public static final String toField_URL = "url";

	/** Constructor for BufferAudioSource to initialize member variables with default values. */
	public BufferAudioSource()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "children" }; // type containerFieldChoicesSoundSource

		autoRefresh = AUTOREFRESH_DEFAULT_VALUE;
		autoRefreshTimeLimit = AUTOREFRESHTIMELIMIT_DEFAULT_VALUE;
		buffer = new ArrayList<>();
		bufferDuration = BUFFERDURATION_DEFAULT_VALUE;
		channelCountMode = CHANNELCOUNTMODE_DEFAULT_VALUE;
		channelInterpretation = CHANNELINTERPRETATION_DEFAULT_VALUE;
		description = DESCRIPTION_DEFAULT_VALUE;
		detune = DETUNE_DEFAULT_VALUE;
		enabled = ENABLED_DEFAULT_VALUE;
		gain = GAIN_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		load = LOAD_DEFAULT_VALUE;
		loop = LOOP_DEFAULT_VALUE;
		loopEnd = LOOPEND_DEFAULT_VALUE;
		loopStart = LOOPSTART_DEFAULT_VALUE;
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		numberOfChannels = NUMBEROFCHANNELS_DEFAULT_VALUE;
		pauseTime = PAUSETIME_DEFAULT_VALUE;
		playbackRate = PLAYBACKRATE_DEFAULT_VALUE;
		resumeTime = RESUMETIME_DEFAULT_VALUE;
		sampleRate = SAMPLERATE_DEFAULT_VALUE;
		startTime = STARTTIME_DEFAULT_VALUE;
		stopTime = STOPTIME_DEFAULT_VALUE;
		url = new ArrayList<>(URL_DEFAULT_VALUE);

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefresh field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=AutoRefresh, $memberObjectName=autoRefresh, $memberObjectName=autoRefresh)

	public double getAutoRefresh()
	{
		return autoRefresh;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setAutoRefresh(double newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource autoRefresh newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		autoRefresh = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime autoRefresh field, similar to {@link #setAutoRefresh(double)}.
	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setAutoRefresh(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAutoRefresh(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefreshTimeLimit field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=AutoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit)

	public double getAutoRefreshTimeLimit()
	{
		return autoRefreshTimeLimit;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setAutoRefreshTimeLimit(double newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource autoRefreshTimeLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		autoRefreshTimeLimit = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime autoRefreshTimeLimit field, similar to {@link #setAutoRefreshTimeLimit(double)}.
	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setAutoRefreshTimeLimit(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAutoRefreshTimeLimit(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of Float results within allowed range of [-1,1] from inputOutput MFFloat field named <i>buffer</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  buffer is a memory-resident audio asset that can contain one or more channels. buffer data format is non-interleaved 32-bit floating-point linear PCM values with a normal range of [−1,1], but values are not limited to this range. Hint: Wikipedia Pulse-Code Modulation (PCM) &lt;a href="https://en.wikipedia.org/wiki/Pulse-code_modulation" target="_blank"&gt;https://en.wikipedia.org/wiki/Pulse-code_modulation&lt;/a&gt;  * <br>

	 * @return value of buffer field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Buffer, $memberObjectName=buffer, $memberObjectName=buffer)

	public float[] getBuffer()
	{
		final float[] valuesArray = new float[buffer.size()];
		int i = 0;
		for (Float arrayElement : buffer) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFFloat buffer field, similar to {@link #getBuffer()}.
	 * @return value of buffer field
	 */
	public ArrayList<Float> getBufferList()
	{
		return buffer;
	}
	/**
	 * Utility method to get String value of MFFloat buffer field, similar to {@link #getBuffer()}.
	 * @return value of buffer field
	 */
	public String getBufferString()
    {
        StringBuilder result = new StringBuilder();
		for (Float arrayElement : buffer) {
			result.append(arrayElement.toString());
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign Float array to inputOutput MFFloat field named <i>buffer</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  buffer is a memory-resident audio asset that can contain one or more channels. buffer data format is non-interleaved 32-bit floating-point linear PCM values with a normal range of [−1,1], but values are not limited to this range. Hint: Wikipedia Pulse-Code Modulation (PCM) &lt;a href="https://en.wikipedia.org/wiki/Pulse-code_modulation" target="_blank"&gt;https://en.wikipedia.org/wiki/Pulse-code_modulation&lt;/a&gt;  * <br>

	 * @param newValue is new value for the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setBuffer(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)		{
			clearBuffer(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearBuffer(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			buffer.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFFloat buffer field, similar to {@link #setBuffer(float[])}.
	 * @param newValue is new value for the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setBuffer(MFFloat newValue)
	{
		if (newValue == null)		{
			clearBuffer(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setBuffer(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign ArrayList value of MFFloat buffer field, similar to {@link #setBuffer(float[])}.
	 * @param newValue is new value for the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setBuffer(ArrayList<Float> newValue)
	{
		if (newValue == null)		{
			clearBuffer(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearBuffer(); // reset
        else
        {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setBuffer(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFFloat value of buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public BufferAudioSource clearBuffer()
	{
		buffer.clear(); // reset MF field
		return this;
	}
	/**
	 * Assign floating-point array value of MFFloat buffer field, similar to {@link #setBuffer(float[])}.
	 * @param newValue is new value for the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setBuffer(int[] newValue)
	{
		if (newValue == null)		{
			clearBuffer(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #5
		float[] holdArray = new float[newValue.length];
		for (int i = 0; i < newValue.length; i++)
		{
			holdArray[i] = (float)newValue[i];
		}
		setBuffer(holdArray);
		return this;
	}

	/**
	 * Add singleton float value to MFFloat buffer field.
	 * @param newValue is new value to add to the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource addBuffer(float newValue)
	{
		buffer.add(newValue); // add simple type if tupleSize = 1
		return this;
	}
	/**
	 * Add singleton SFFloat value to MFFloat buffer field.
	 * @param newValue is new value to add to the buffer field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource addBuffer(SFFloat newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		buffer.add(newValue.getPrimitiveValue());
		return this;
	}


	/**
	 * Utility method: double-precision set-array accessor for X3D floating-point type, similar to {@link #setBuffer(float[])}.
	 * @param newArray is new value for field                                 
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setBuffer(double[] newArray)
	{
		return setBuffer(new MFFloat(newArray));
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>bufferDuration</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) bufferDuration is duration in seconds to use from buffer field. Hint: duration is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of bufferDuration field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=BufferDuration, $memberObjectName=bufferDuration, $memberObjectName=bufferDuration)

	public double getBufferDuration()
	{
		return bufferDuration;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>bufferDuration</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) bufferDuration is duration in seconds to use from buffer field. Hint: duration is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the bufferDuration field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setBufferDuration(double newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource bufferDuration newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		bufferDuration = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime bufferDuration field, similar to {@link #setBufferDuration(double)}.
	 * @param newValue is new value for the bufferDuration field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setBufferDuration(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setBufferDuration(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide int value from outputOnly SFInt32 field named <i>bufferlength</i>.
	 * @return value of bufferlength field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Bufferlength, $memberObjectName=bufferlength, $memberObjectName=bufferlength)

	public int getBufferlength()
	{
		return bufferlength;
	}
	/**
	 * Provide int value from outputOnly SFInt32 field named <i>channelCount</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) channelCount reports number of channels provided by input nodes. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcount" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcount&lt;/a&gt;  * <br>

	 * @return value of channelCount field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=ChannelCount, $memberObjectName=channelCount, $memberObjectName=channelCount)

	public int getChannelCount()
	{
		return channelCount;
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["MAX" | "CLAMPED_MAX" | "EXPLICIT"] from inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode&lt;/a&gt;  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #CHANNELCOUNTMODE_MAX MAX}, {@link #CHANNELCOUNTMODE_CLAMPED_MAX CLAMPED_MAX}, {@link #CHANNELCOUNTMODE_EXPLICIT EXPLICIT}.
	 * @return value of channelCountMode field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=ChannelCountMode, $memberObjectName=channelCountMode, $memberObjectName=channelCountMode)

	public String getChannelCountMode()
	{
		return channelCountMode;
	}

	/**
	 * Accessor method to assign String enumeration value ("MAX" | "CLAMPED_MAX" | "EXPLICIT") to inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #CHANNELCOUNTMODE_MAX MAX}, {@link #CHANNELCOUNTMODE_CLAMPED_MAX CLAMPED_MAX}, {@link #CHANNELCOUNTMODE_EXPLICIT EXPLICIT}).
	 * <br><br>
	 * <i>Tooltip:</i>  channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode&lt;/a&gt;  * <br>

	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setChannelCountMode(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_MAX) ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_CLAMPED_MAX) ||
			newValue.toString().replace("\"","").equals(CHANNELCOUNTMODE_EXPLICIT)))
		{
			String warningMessage = "[warning] BufferAudioSource channelCountMode newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!channelCountModeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are MAX, CLAMPED_MAX, EXPLICIT";
			    channelCountModeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		channelCountMode = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString channelCountMode field, similar to {@link #setChannelCountMode(String)}.
	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setChannelCountMode(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setChannelCountMode(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["SPEAKERS" | "DISCRETE"] from inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation&lt;/a&gt;  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #CHANNELINTERPRETATION_SPEAKERS SPEAKERS}, {@link #CHANNELINTERPRETATION_DISCRETE DISCRETE}.
	 * @return value of channelInterpretation field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=ChannelInterpretation, $memberObjectName=channelInterpretation, $memberObjectName=channelInterpretation)

	public String getChannelInterpretation()
	{
		return channelInterpretation;
	}

	/**
	 * Accessor method to assign String enumeration value ("SPEAKERS" | "DISCRETE") to inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #CHANNELINTERPRETATION_SPEAKERS SPEAKERS}, {@link #CHANNELINTERPRETATION_DISCRETE DISCRETE}).
	 * <br><br>
	 * <i>Tooltip:</i>  channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation&lt;/a&gt;  * <br>

	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setChannelInterpretation(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(CHANNELINTERPRETATION_SPEAKERS) ||
			newValue.toString().replace("\"","").equals(CHANNELINTERPRETATION_DISCRETE)))
		{
			String warningMessage = "[warning] BufferAudioSource channelInterpretation newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!channelInterpretationWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are SPEAKERS, DISCRETE";
			    channelInterpretationWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		channelInterpretation = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString channelInterpretation field, similar to {@link #setChannelInterpretation(String)}.
	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setChannelInterpretation(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setChannelInterpretation(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>detune</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) The detune field forms a compound field together with playbackRate that together determine a computedPlaybackRate value. Hint: computedPlaybackRate(t) = playbackRate(t) * pow(2, detune(t) / 1200).  * <br>

	 * @return value of detune field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Detune, $memberObjectName=detune, $memberObjectName=detune)

	public float getDetune()
	{
		return detune;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>detune</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,+infinity) The detune field forms a compound field together with playbackRate that together determine a computedPlaybackRate value. Hint: computedPlaybackRate(t) = playbackRate(t) * pow(2, detune(t) / 1200).  * <br>

	 * @param newValue is new value for the detune field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setDetune(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource detune newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		detune = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat detune field, similar to {@link #setDetune(float)}.
	 * @param newValue is new value for the detune field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setDetune(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDetune(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setDetune(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setDetune(double newValue)
	{
		return setDetune((float) newValue);
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from outputOnly SFTime field named <i>elapsedTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Current elapsed time since AudioClip activated/running, cumulative in seconds, and not counting any paused time. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. Hint: elapsedTime is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of elapsedTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=ElapsedTime, $memberObjectName=elapsedTime, $memberObjectName=elapsedTime)

	public double getElapsedTime()
	{
		return elapsedTime;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled()
	{
		return enabled;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setEnabled(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		enabled = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool enabled field, similar to {@link #setEnabled(boolean)}.
	 * @param newValue is new value for the enabled field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setEnabled(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEnabled(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node. Warning: Decibel values shall not be used. Hint: Negative gain factors negate the input signal.  * <br>

	 * @return value of gain field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)

	public float getGain()
	{
		return gain;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node. Warning: Decibel values shall not be used. Hint: Negative gain factors negate the input signal.  * <br>

	 * @param newValue is new value for the gain field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setGain(float newValue)
	{
		// set-newValue-validity-checks #0.a
		gain = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat gain field, similar to {@link #setGain(float)}.
	 * @param newValue is new value for the gain field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setGain(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setGain(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setGain(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setGain(double newValue)
	{
		return setGain((float) newValue);
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public BufferAudioSource clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isActive true/false events are sent when playback starts/stops. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isActive field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive()
	{
		return isActive;
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isPaused</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isPaused true/false events are sent when AudioClip is paused/resumed. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isPaused field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=IsPaused, $memberObjectName=isPaused, $memberObjectName=isPaused)

	public boolean getIsPaused()
	{
		return isPaused;
	}
	/**
	 * Provide int value within allowed range of [0,infinity) from outputOnly SFInt32 field named <i>length</i>.
	 * @return value of length field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Length, $memberObjectName=length, $memberObjectName=length)

	public int getLength()
	{
		return length;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @return value of load field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Load, $memberObjectName=load, $memberObjectName=load)

	public boolean getLoad()
	{
		return load;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @param newValue is new value for the load field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setLoad(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		load = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool load field, similar to {@link #setLoad(boolean)}.
	 * @param newValue is new value for the load field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoad(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLoad(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>loop</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Repeat indefinitely when loop=true, repeat only once when loop=false.  * <br>

	 * @return value of loop field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Loop, $memberObjectName=loop, $memberObjectName=loop)

	public boolean getLoop()
	{
		return loop;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>loop</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Repeat indefinitely when loop=true, repeat only once when loop=false.  * <br>

	 * @param newValue is new value for the loop field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setLoop(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		loop = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool loop field, similar to {@link #setLoop(boolean)}.
	 * @param newValue is new value for the loop field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoop(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLoop(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>loopEnd</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) loopEnd field is optional playhead position where looping ends if loop=true. If loopEnd value is zero, or if loopEnd is greater than duration of buffer, looping ends at buffer end. Hint: loopEnd represents a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of loopEnd field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=LoopEnd, $memberObjectName=loopEnd, $memberObjectName=loopEnd)

	public float getLoopEnd()
	{
		return loopEnd;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>loopEnd</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) loopEnd field is optional playhead position where looping ends if loop=true. If loopEnd value is zero, or if loopEnd is greater than duration of buffer, looping ends at buffer end. Hint: loopEnd represents a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the loopEnd field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setLoopEnd(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource loopEnd newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		loopEnd = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat loopEnd field, similar to {@link #setLoopEnd(float)}.
	 * @param newValue is new value for the loopEnd field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoopEnd(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLoopEnd(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setLoopEnd(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoopEnd(double newValue)
	{
		return setLoopEnd((float) newValue);
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>loopStart</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) loopStart field is optional playhead position where looping begins if loop=true. If loopStart is greater than duration of buffer, looping starts at buffer end. Hint: loopStart represents a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of loopStart field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=LoopStart, $memberObjectName=loopStart, $memberObjectName=loopStart)

	public float getLoopStart()
	{
		return loopStart;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>loopStart</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) loopStart field is optional playhead position where looping begins if loop=true. If loopStart is greater than duration of buffer, looping starts at buffer end. Hint: loopStart represents a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the loopStart field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setLoopStart(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource loopStart newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		loopStart = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat loopStart field, similar to {@link #setLoopStart(float)}.
	 * @param newValue is new value for the loopStart field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoopStart(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLoopStart(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setLoopStart(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setLoopStart(double newValue)
	{
		return setLoopStart((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public BufferAudioSource clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public BufferAudioSource setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide int value within allowed range of [0,infinity) from inputOutput SFInt32 field named <i>numberOfChannels</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) numberOfChannels is number of audio channels found in this buffer source.  * <br>

	 * @return value of numberOfChannels field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=NumberOfChannels, $memberObjectName=numberOfChannels, $memberObjectName=numberOfChannels)

	public int getNumberOfChannels()
	{
		return numberOfChannels;
	}

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>numberOfChannels</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) numberOfChannels is number of audio channels found in this buffer source.  * <br>

	 * @param newValue is new value for the numberOfChannels field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setNumberOfChannels(int newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource numberOfChannels newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		numberOfChannels = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFInt32 numberOfChannels field, similar to {@link #setNumberOfChannels(int)}.
	 * @param newValue is new value for the numberOfChannels field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setNumberOfChannels(SFInt32 newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setNumberOfChannels(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of pauseTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=PauseTime, $memberObjectName=pauseTime, $memberObjectName=pauseTime)

	public double getPauseTime()
	{
		return pauseTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the pauseTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setPauseTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		pauseTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime pauseTime field, similar to {@link #setPauseTime(double)}.
	 * @param newValue is new value for the pauseTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setPauseTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setPauseTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>playbackRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) playbackRate field is speed at which to render the audio stream, and forms a compound field together with detune field Hint: negative values play in reverse.  * <br>

	 * @return value of playbackRate field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=PlaybackRate, $memberObjectName=playbackRate, $memberObjectName=playbackRate)

	public float getPlaybackRate()
	{
		return playbackRate;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>playbackRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) playbackRate field is speed at which to render the audio stream, and forms a compound field together with detune field Hint: negative values play in reverse.  * <br>

	 * @param newValue is new value for the playbackRate field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setPlaybackRate(float newValue)
	{
		// set-newValue-validity-checks #0.a
		playbackRate = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat playbackRate field, similar to {@link #setPlaybackRate(float)}.
	 * @param newValue is new value for the playbackRate field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setPlaybackRate(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setPlaybackRate(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setPlaybackRate(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setPlaybackRate(double newValue)
	{
		return setPlaybackRate((float) newValue);
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of resumeTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=ResumeTime, $memberObjectName=resumeTime, $memberObjectName=resumeTime)

	public double getResumeTime()
	{
		return resumeTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the resumeTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setResumeTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		resumeTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime resumeTime field, similar to {@link #setResumeTime(double)}.
	 * @param newValue is new value for the resumeTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setResumeTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setResumeTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>sampleRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) sampleRate field is sample-frames per second. Hint: sample-rate converters (variable speed processors) are not supported in real-time processing. Hint: Nyquist frequency is half this sampleRate value. Hint: Wikipedia Nyquist frequency &lt;a href="https://en.wikipedia.org/wiki/Nyquist_frequency" target="_blank"&gt;https://en.wikipedia.org/wiki/Nyquist_frequency&lt;/a&gt;  * <br>

	 * @return value of sampleRate field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=SampleRate, $memberObjectName=sampleRate, $memberObjectName=sampleRate)

	public float getSampleRate()
	{
		return sampleRate;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>sampleRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) sampleRate field is sample-frames per second. Hint: sample-rate converters (variable speed processors) are not supported in real-time processing. Hint: Nyquist frequency is half this sampleRate value. Hint: Wikipedia Nyquist frequency &lt;a href="https://en.wikipedia.org/wiki/Nyquist_frequency" target="_blank"&gt;https://en.wikipedia.org/wiki/Nyquist_frequency&lt;/a&gt;  * <br>

	 * @param newValue is new value for the sampleRate field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setSampleRate(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource sampleRate newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		sampleRate = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat sampleRate field, similar to {@link #setSampleRate(float)}.
	 * @param newValue is new value for the sampleRate field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setSampleRate(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSampleRate(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setSampleRate(float)}.
	 * @param newValue is new value for field
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setSampleRate(double newValue)
	{
		return setSampleRate((float) newValue);
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of startTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=StartTime, $memberObjectName=startTime, $memberObjectName=startTime)

	public double getStartTime()
	{
		return startTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the startTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setStartTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		startTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime startTime field, similar to {@link #setStartTime(double)}.
	 * @param newValue is new value for the startTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setStartTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setStartTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. Warning: An active TimeSensor node ignores set_cycleInterval and set_startTime events. Warning:An active TimeSensor node ignores set_stopTime event values less than or equal to startTime.  * <br>

	 * @return value of stopTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=StopTime, $memberObjectName=stopTime, $memberObjectName=stopTime)

	public double getStopTime()
	{
		return stopTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. Warning: An active TimeSensor node ignores set_cycleInterval and set_startTime events. Warning:An active TimeSensor node ignores set_stopTime event values less than or equal to startTime.  * <br>

	 * @param newValue is new value for the stopTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setStopTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
		stopTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime stopTime field, similar to {@link #setStopTime(double)}.
	 * @param newValue is new value for the stopTime field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setStopTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setStopTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of String results from inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Location and filename of sound file. Support for .wav format is required, .midi format is recommended, other formats are optional. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks. "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt;  * <br>

	 * @return value of url field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=Url, $memberObjectName=url, $memberObjectName=url)

	public String[] getUrl()
	{
		final String[] valuesArray = new String[url.size()];
		int i = 0;
		for (String arrayElement : url) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString url field, similar to {@link #getUrl()}.
	 * @return value of url field
	 */
	public ArrayList<String> getUrlList()
	{
		return url;
	}
	/**
	 * Utility method to get String value of MFString url field, similar to {@link #getUrl()}.
	 * @return value of url field
	 */
	public String getUrlString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : url) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Location and filename of sound file. Support for .wav format is required, .midi format is recommended, other formats are optional. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks. "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt;  * <br>

	 * @param newValue is new value for the url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public BufferAudioSource setUrl(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)		{
			clearUrl(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearUrl(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			url.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString url field, similar to {@link #setUrl(String[])}.
	 * @param newValue is new value for the url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUrl(MFString newValue)
	{
		if (newValue == null)		{
			clearUrl(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUrl(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString url field, similar to {@link #setUrl(String[])}.
	 * @param newValue is new value for the url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUrl(SFString newValue)
	{
		if (newValue == null)		{
			clearUrl(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setUrl(new MFString(newValue));
		// set-newValue-validity-checks #2
		setUrl(newValue.getValue());
		return this;
	}
	/**
	 * Assign singleton String value to MFString url field, similar to {@link #setUrl(String[])}.
	 * @param newValue is new value for the url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUrl(String newValue)
	{
		if (newValue == null)		{
			clearUrl(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setUrl(new MFString(newValue));
		// set-newValue-validity-checks #3
		clearUrl(); // reset
		url.add(newValue);
		return this;
	}
	/**
	 * Assign ArrayList value of MFString url field, similar to {@link #setUrl(String[])}.
	 * @param newValue is new value for the url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUrl(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearUrl(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearUrl(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setUrl(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of url field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public BufferAudioSource clearUrl()
	{
		url.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString url field.
	 * @param newValue is new value to add to the url field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource addUrl(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !url.contains(newValue))
            url.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString url field.
	 * @param newValue is new value to add to the url field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource addUrl(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !url.contains(newValue.getValue()))
            url.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final BufferAudioSource setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to BufferAudioSource DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final BufferAudioSource setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to BufferAudioSource USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("BufferAudioSource USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final BufferAudioSource setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final BufferAudioSource setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundSourceNode, $additionalInheritanceBaseType=X3DUrlObject, $thisClassName=BufferAudioSource, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final BufferAudioSource setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public BufferAudioSource setUSE(BufferAudioSource DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on BufferAudioSource" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public BufferAudioSource (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public BufferAudioSource addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public BufferAudioSource addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link BufferAudioSource} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public BufferAudioSource addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<BufferAudioSource"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getAutoRefresh() != AUTOREFRESH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" autoRefresh='").append(SFTime.toString(getAutoRefresh())).append("'");
			}
			if (((getAutoRefreshTimeLimit() != AUTOREFRESHTIMELIMIT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" autoRefreshTimeLimit='").append(SFTime.toString(getAutoRefreshTimeLimit())).append("'");
			}
			if (((getBuffer().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" buffer='").append(MFFloat.toString(getBuffer())).append("'");
			}
			if (((getBufferDuration() != BUFFERDURATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" bufferDuration='").append(SFTime.toString(getBufferDuration())).append("'");
			}
			if ((!getChannelCountMode().equals(CHANNELCOUNTMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" channelCountMode='").append(new SFString(getChannelCountMode()).toStringX3D()).append("'");
			}
			if ((!getChannelInterpretation().equals(CHANNELINTERPRETATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" channelInterpretation='").append(new SFString(getChannelInterpretation()).toStringX3D()).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if (((getDetune() != DETUNE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" detune='").append(SFFloat.toString(getDetune())).append("'");
			}
			if (((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" enabled='").append(SFBool.toString(getEnabled())).append("'");
			}
			if (((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" gain='").append(SFFloat.toString(getGain())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getLoad() != LOAD_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" load='").append(SFBool.toString(getLoad())).append("'");
			}
			if (((getLoop() != LOOP_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" loop='").append(SFBool.toString(getLoop())).append("'");
			}
			if (((getLoopEnd() != LOOPEND_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" loopEnd='").append(SFFloat.toString(getLoopEnd())).append("'");
			}
			if (((getLoopStart() != LOOPSTART_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" loopStart='").append(SFFloat.toString(getLoopStart())).append("'");
			}
			if (((getNumberOfChannels() != NUMBEROFCHANNELS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" numberOfChannels='").append(SFInt32.toString(getNumberOfChannels())).append("'");
			}
			if (((getPauseTime() != PAUSETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" pauseTime='").append(SFTime.toString(getPauseTime())).append("'");
			}
			if (((getPlaybackRate() != PLAYBACKRATE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" playbackRate='").append(SFFloat.toString(getPlaybackRate())).append("'");
			}
			if (((getResumeTime() != RESUMETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" resumeTime='").append(SFTime.toString(getResumeTime())).append("'");
			}
			if (((getSampleRate() != SAMPLERATE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" sampleRate='").append(SFFloat.toString(getSampleRate())).append("'");
			}
			if (((getStartTime() != STARTTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" startTime='").append(SFTime.toString(getStartTime())).append("'");
			}
			if (((getStopTime() != STOPTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" stopTime='").append(SFTime.toString(getStopTime())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getUrl().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" url='").append(new MFString(getUrl()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</BufferAudioSource>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=BufferAudioSource, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("BufferAudioSource").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("autoRefresh"))
						{
							stringClassicVRML.append(indentCharacter).append("autoRefresh").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAutoRefresh() != AUTOREFRESH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("autoRefresh ").append(SFTime.toString(getAutoRefresh())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("autoRefreshTimeLimit"))
						{
							stringClassicVRML.append(indentCharacter).append("autoRefreshTimeLimit").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAutoRefreshTimeLimit() != AUTOREFRESHTIMELIMIT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("autoRefreshTimeLimit ").append(SFTime.toString(getAutoRefreshTimeLimit())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("buffer"))
						{
							stringClassicVRML.append(indentCharacter).append("buffer").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getBuffer().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("buffer ").append("[ ").append(MFFloat.toString(getBuffer())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("bufferDuration"))
						{
							stringClassicVRML.append(indentCharacter).append("bufferDuration").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getBufferDuration() != BUFFERDURATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("bufferDuration ").append(SFTime.toString(getBufferDuration())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("channelCountMode"))
						{
							stringClassicVRML.append(indentCharacter).append("channelCountMode").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getChannelCountMode().equals(CHANNELCOUNTMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("channelCountMode ").append("\"").append(SFString.toString(getChannelCountMode())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("channelInterpretation"))
						{
							stringClassicVRML.append(indentCharacter).append("channelInterpretation").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getChannelInterpretation().equals(CHANNELINTERPRETATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("channelInterpretation ").append("\"").append(SFString.toString(getChannelInterpretation())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("detune"))
						{
							stringClassicVRML.append(indentCharacter).append("detune").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getDetune() != DETUNE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("detune ").append(SFFloat.toString(getDetune())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("enabled"))
						{
							stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("enabled ").append(SFBool.toString(getEnabled())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("gain"))
						{
							stringClassicVRML.append(indentCharacter).append("gain").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getGain() != GAIN_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("gain ").append(SFFloat.toString(getGain())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("load"))
						{
							stringClassicVRML.append(indentCharacter).append("load").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLoad() != LOAD_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("load ").append(SFBool.toString(getLoad())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("loop"))
						{
							stringClassicVRML.append(indentCharacter).append("loop").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLoop() != LOOP_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("loop ").append(SFBool.toString(getLoop())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("loopEnd"))
						{
							stringClassicVRML.append(indentCharacter).append("loopEnd").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLoopEnd() != LOOPEND_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("loopEnd ").append(SFFloat.toString(getLoopEnd())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("loopStart"))
						{
							stringClassicVRML.append(indentCharacter).append("loopStart").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLoopStart() != LOOPSTART_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("loopStart ").append(SFFloat.toString(getLoopStart())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("numberOfChannels"))
						{
							stringClassicVRML.append(indentCharacter).append("numberOfChannels").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getNumberOfChannels() != NUMBEROFCHANNELS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("numberOfChannels ").append(SFInt32.toString(getNumberOfChannels())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("pauseTime"))
						{
							stringClassicVRML.append(indentCharacter).append("pauseTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getPauseTime() != PAUSETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("pauseTime ").append(SFTime.toString(getPauseTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("playbackRate"))
						{
							stringClassicVRML.append(indentCharacter).append("playbackRate").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getPlaybackRate() != PLAYBACKRATE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("playbackRate ").append(SFFloat.toString(getPlaybackRate())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("resumeTime"))
						{
							stringClassicVRML.append(indentCharacter).append("resumeTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getResumeTime() != RESUMETIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("resumeTime ").append(SFTime.toString(getResumeTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("sampleRate"))
						{
							stringClassicVRML.append(indentCharacter).append("sampleRate").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getSampleRate() != SAMPLERATE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("sampleRate ").append(SFFloat.toString(getSampleRate())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("startTime"))
						{
							stringClassicVRML.append(indentCharacter).append("startTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getStartTime() != STARTTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("startTime ").append(SFTime.toString(getStartTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("stopTime"))
						{
							stringClassicVRML.append(indentCharacter).append("stopTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getStopTime() != STOPTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("stopTime ").append(SFTime.toString(getStopTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("url"))
						{
							stringClassicVRML.append(indentCharacter).append("url").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getUrl().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("url ").append("[ ").append(MFString.toString(getUrl())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setAutoRefresh(getAutoRefresh()); // exercise field checks, simple types
        
		setAutoRefreshTimeLimit(getAutoRefreshTimeLimit()); // exercise field checks, simple types
        
		setBuffer(getBuffer()); // exercise field checks, simple types
        
		setBufferDuration(getBufferDuration()); // exercise field checks, simple types
        
		setChannelCountMode(getChannelCountMode()); // exercise field checks, simple types
        
		setChannelInterpretation(getChannelInterpretation()); // exercise field checks, simple types
        
		setDescription(getDescription()); // exercise field checks, simple types
        
		setDetune(getDetune()); // exercise field checks, simple types
        
		setEnabled(getEnabled()); // exercise field checks, simple types
        
		setGain(getGain()); // exercise field checks, simple types
        
		setLoad(getLoad()); // exercise field checks, simple types
        
		setLoop(getLoop()); // exercise field checks, simple types
        
		setLoopEnd(getLoopEnd()); // exercise field checks, simple types
        
		setLoopStart(getLoopStart()); // exercise field checks, simple types
        
		setNumberOfChannels(getNumberOfChannels()); // exercise field checks, simple types
        
		setPauseTime(getPauseTime()); // exercise field checks, simple types
        
		setPlaybackRate(getPlaybackRate()); // exercise field checks, simple types
        
		setResumeTime(getResumeTime()); // exercise field checks, simple types
        
		setSampleRate(getSampleRate()); // exercise field checks, simple types
        
		setStartTime(getStartTime()); // exercise field checks, simple types
        
		setStopTime(getStopTime()); // exercise field checks, simple types
        
		setUrl(getUrl()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "BufferAudioSource USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "BufferAudioSource USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "BufferAudioSource USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "BufferAudioSource USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'BufferAudioSource' node, ensure sufficient support by adding head statement <component name='Sound' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Sound\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
