/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;

/**
 * LineProperties allows precise fine-grained control over the rendering style of lines and edges for associated geometry nodes inside the same Shape.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DAppearanceChildNode] LineProperties allows precise fine-grained control over the rendering style of lines and edges for associated geometry nodes inside the same Shape.
Hint: DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene.
Hint: LineProperties illustration model &lt;a href="https://X3dGraphics.com/examples/X3dForWebAuthors/Chapter05AppearanceMaterialTextures/LinePropertiesExampleIndex.html" target="_blank"&gt;https://X3dGraphics.com/examples/X3dForWebAuthors/Chapter05AppearanceMaterialTextures/LinePropertiesExampleIndex.html&lt;/a&gt;
Warning: requires X3D profile='Full' or else include &amp;lt;component name='Shape' level='2'/&amp;gt;  * <br>
 * <br>

 * <br>
 * Note that {@linkplain SFColor#ALICEBLUE SFColor} provides a variety of color constants.
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#LineProperties" target="blank">X3D Abstract Specification: LineProperties</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#LineProperties" target="_blank">X3D Tooltips: LineProperties</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class LineProperties extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Shape.LineProperties
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=applied, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=applied, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean applied; //  X3D field type: SFBool

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=linetype, @type=SFInt32, $javaType=int, $javaReferenceType=int, $javaPrimitiveType=int, $normalizedMemberObjectName=linetype, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private int linetype; //  X3D field type: SFInt32

    /* @name=linewidthScaleFactor, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=linewidthScaleFactor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float linewidthScaleFactor; //  X3D field type: SFFloat

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean linetypeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> Solid.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"1"</i> (Java syntax) or <i>1</i> (XML syntax).
	 * @see #LINETYPE_1_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_SOLID = "1";
	/** SFString SFInt32 enumeration value "<i>1</i>" has alias "<i>SOLID</i>"
	 * @see #LINETYPE_SOLID */
	public static final String LINETYPE_1_ALIAS = "SOLID";

	/** 
	 * <i>Tooltip:</i> Dashed.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"2"</i> (Java syntax) or <i>2</i> (XML syntax).
	 * @see #LINETYPE_2_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_DASHED = "2";
	/** SFString SFInt32 enumeration value "<i>2</i>" has alias "<i>DASHED</i>"
	 * @see #LINETYPE_DASHED */
	public static final String LINETYPE_2_ALIAS = "DASHED";

	/** 
	 * <i>Tooltip:</i> Dotted.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"3"</i> (Java syntax) or <i>3</i> (XML syntax).
	 * @see #LINETYPE_3_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_DOTTED = "3";
	/** SFString SFInt32 enumeration value "<i>3</i>" has alias "<i>DOTTED</i>"
	 * @see #LINETYPE_DOTTED */
	public static final String LINETYPE_3_ALIAS = "DOTTED";

	/** 
	 * <i>Tooltip:</i> Dashed-dotted.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"4"</i> (Java syntax) or <i>4</i> (XML syntax).
	 * @see #LINETYPE_4_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_DASHED_DOTTED = "4";
	/** SFString SFInt32 enumeration value "<i>4</i>" has alias "<i>DASHED_DOTTED</i>"
	 * @see #LINETYPE_DASHED_DOTTED */
	public static final String LINETYPE_4_ALIAS = "DASHED_DOTTED";

	/** 
	 * <i>Tooltip:</i> Dash-dot-dot.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"5"</i> (Java syntax) or <i>5</i> (XML syntax).
	 * @see #LINETYPE_5_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_DASHED_DOT_DOT = "5";
	/** SFString SFInt32 enumeration value "<i>5</i>" has alias "<i>DASHED_DOT_DOT</i>"
	 * @see #LINETYPE_DASHED_DOT_DOT */
	public static final String LINETYPE_5_ALIAS = "DASHED_DOT_DOT";

	/** 
	 * <i>Tooltip:</i> (single arrow).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"6"</i> (Java syntax) or <i>6</i> (XML syntax).
	 * @see #LINETYPE_6_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_SINGLE_ARROW = "6";
	/** SFString SFInt32 enumeration value "<i>6</i>" has alias "<i>SINGLE_ARROW</i>"
	 * @see #LINETYPE_SINGLE_ARROW */
	public static final String LINETYPE_6_ALIAS = "SINGLE_ARROW";

	/** 
	 * <i>Tooltip:</i> (single dot).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"7"</i> (Java syntax) or <i>7</i> (XML syntax).
	 * @see #LINETYPE_7_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_SINGLE_DOT = "7";
	/** SFString SFInt32 enumeration value "<i>7</i>" has alias "<i>SINGLE_DOT</i>"
	 * @see #LINETYPE_SINGLE_DOT */
	public static final String LINETYPE_7_ALIAS = "SINGLE_DOT";

	/** 
	 * <i>Tooltip:</i> (double arrow).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"8"</i> (Java syntax) or <i>8</i> (XML syntax).
	 * @see #LINETYPE_8_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_DOUBLE_ARROW = "8";
	/** SFString SFInt32 enumeration value "<i>8</i>" has alias "<i>DOUBLE_ARROW</i>"
	 * @see #LINETYPE_DOUBLE_ARROW */
	public static final String LINETYPE_8_ALIAS = "DOUBLE_ARROW";

	/** 
	 * <i>Tooltip:</i> (stitch line).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"9"</i> (Java syntax) or <i>9</i> (XML syntax).
	 * @see #LINETYPE_9_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_STITCH_LINE = "9";
	/** SFString SFInt32 enumeration value "<i>9</i>" has alias "<i>STITCH_LINE</i>"
	 * @see #LINETYPE_STITCH_LINE */
	public static final String LINETYPE_9_ALIAS = "STITCH_LINE";

	/** 
	 * <i>Tooltip:</i> (chain line).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"10"</i> (Java syntax) or <i>10</i> (XML syntax).
	 * @see #LINETYPE_10_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_CHAIN_LINE = "10";
	/** SFString SFInt32 enumeration value "<i>10</i>" has alias "<i>CHAIN_LINE</i>"
	 * @see #LINETYPE_CHAIN_LINE */
	public static final String LINETYPE_10_ALIAS = "CHAIN_LINE";

	/** 
	 * <i>Tooltip:</i> (center line).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"11"</i> (Java syntax) or <i>11</i> (XML syntax).
	 * @see #LINETYPE_11_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_CENTER_LINE = "11";
	/** SFString SFInt32 enumeration value "<i>11</i>" has alias "<i>CENTER_LINE</i>"
	 * @see #LINETYPE_CENTER_LINE */
	public static final String LINETYPE_11_ALIAS = "CENTER_LINE";

	/** 
	 * <i>Tooltip:</i> (hidden line).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"12"</i> (Java syntax) or <i>12</i> (XML syntax).
	 * @see #LINETYPE_12_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_HIDDEN_LINE = "12";
	/** SFString SFInt32 enumeration value "<i>12</i>" has alias "<i>HIDDEN_LINE</i>"
	 * @see #LINETYPE_HIDDEN_LINE */
	public static final String LINETYPE_12_ALIAS = "HIDDEN_LINE";

	/** 
	 * <i>Tooltip:</i> (phantom line).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"13"</i> (Java syntax) or <i>13</i> (XML syntax).
	 * @see #LINETYPE_13_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_PHANTOM_LINE = "13";
	/** SFString SFInt32 enumeration value "<i>13</i>" has alias "<i>PHANTOM_LINE</i>"
	 * @see #LINETYPE_PHANTOM_LINE */
	public static final String LINETYPE_13_ALIAS = "PHANTOM_LINE";

	/** 
	 * <i>Tooltip:</i> (break line - style 1).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"14"</i> (Java syntax) or <i>14</i> (XML syntax).
	 * @see #LINETYPE_14_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_BREAK_LINE_STYLE_1 = "14";
	/** SFString SFInt32 enumeration value "<i>14</i>" has alias "<i>BREAK_LINE_STYLE_1</i>"
	 * @see #LINETYPE_BREAK_LINE_STYLE_1 */
	public static final String LINETYPE_14_ALIAS = "BREAK_LINE_STYLE_1";

	/** 
	 * <i>Tooltip:</i> (break line - style 2).
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"15"</i> (Java syntax) or <i>15</i> (XML syntax).
	 * @see #LINETYPE_15_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_BREAK_LINE_STYLE_2 = "15";
	/** SFString SFInt32 enumeration value "<i>15</i>" has alias "<i>BREAK_LINE_STYLE_2</i>"
	 * @see #LINETYPE_BREAK_LINE_STYLE_2 */
	public static final String LINETYPE_15_ALIAS = "BREAK_LINE_STYLE_2";

	/** 
	 * <i>Tooltip:</i> User-specified dash pattern.
	 * SFInt32 field named <i>linetype</i> with X3DUOM simpleType <i>lineTypeValues</i> and with X3DUOM baseType <i>SFInt32</i> <i>"16"</i> (Java syntax) or <i>16</i> (XML syntax).
	 * @see #LINETYPE_16_ALIAS 
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_lineTypeValues.html">XML Schema: lineTypeValues</a> */
	public static final String LINETYPE_USER_SPECIFIED_DASH_PATTERN = "16";
	/** SFString SFInt32 enumeration value "<i>16</i>" has alias "<i>USER_SPECIFIED_DASH_PATTERN</i>"
	 * @see #LINETYPE_USER_SPECIFIED_DASH_PATTERN */
	public static final String LINETYPE_16_ALIAS = "USER_SPECIFIED_DASH_PATTERN";

	// special enumeration utility methods

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>LineProperties</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "LineProperties";

	/** Provides name of this element: <i>LineProperties</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>LineProperties</i> element: <i>Shape</i> */
	public static final String COMPONENT = "Shape";

	/** Defines X3D component for the <i>LineProperties</i> element: <i>Shape</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Shape</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFBool field named <i>applied</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean APPLIED_DEFAULT_VALUE = true;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFInt32 field named <i>linetype</i> has default value <i>1</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final int LINETYPE_DEFAULT_VALUE = 1;

	/** SFFloat field named <i>linewidthScaleFactor</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float LINEWIDTHSCALEFACTOR_DEFAULT_VALUE = 0f;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "applied":
				result = "SFBool";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "linetype":
				result = "SFInt32";
				break;
			case "linewidthScaleFactor":
				result = "SFFloat";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "applied":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "linetype":
				result = "inputOutput";
				break;
			case "linewidthScaleFactor":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "lineProperties"; // type xs:NMTOKEN
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFBool field named <i>applied</i>. */
	public static final String fromField_APPLIED = "applied";

	/** toField ROUTE name for SFBool field named <i>applied</i>. */
	public static final String toField_APPLIED = "applied";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFInt32 field named <i>linetype</i>. */
	public static final String fromField_LINETYPE = "linetype";

	/** toField ROUTE name for SFInt32 field named <i>linetype</i>. */
	public static final String toField_LINETYPE = "linetype";

	/** fromField ROUTE name for SFFloat field named <i>linewidthScaleFactor</i>. */
	public static final String fromField_LINEWIDTHSCALEFACTOR = "linewidthScaleFactor";

	/** toField ROUTE name for SFFloat field named <i>linewidthScaleFactor</i>. */
	public static final String toField_LINEWIDTHSCALEFACTOR = "linewidthScaleFactor";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** Constructor for LineProperties to initialize member variables with default values. */
	public LineProperties()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "lineProperties" }; // type xs:NMTOKEN

		applied = APPLIED_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		linetype = LINETYPE_DEFAULT_VALUE;
		linewidthScaleFactor = LINEWIDTHSCALEFACTOR_DEFAULT_VALUE;
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>applied</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not LineProperties are applied to associated geometry.  * <br>

	 * @return value of applied field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=Applied, $memberObjectName=applied, $memberObjectName=applied)

	public boolean getApplied()
	{
		return applied;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>applied</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not LineProperties are applied to associated geometry.  * <br>

	 * @param newValue is new value for the applied field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LineProperties setApplied(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		applied = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool applied field, similar to {@link #setApplied(boolean)}.
	 * @param newValue is new value for the applied field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setApplied(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setApplied(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public LineProperties clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide int enumeration value (baseType SFInt32) ["1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "10" | "11" | "12" | "13" | "14" | "15" | "16"] from inputOutput SFInt32 field named <i>linetype</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linetype selects a line pattern, with solid default if defined value isn't supported. Values with guaranteed support are 1 Solid, 2 Dashed, 3 Dotted, 4 Dashed-dotted, 5 Dash-dot-dot. Optionally supported values are 6 single-headed arrow (arrow tip occurs at last point of each individual list of points), 7 single dot, 8 double-headed arrow, 10 chain line, 11 center line, 12 hidden line, 13 phantom line, 14 break line 1, 15 break line 2, 16 User-specified dash pattern. Hint: detailed descriptions of lineType values are found at the ISO/IEC 9973 International Register of Graphical Items &lt;a href="https://www.iso.org/jtc1/sc24/register" target="_blank"&gt;https://www.iso.org/jtc1/sc24/register&lt;/a&gt; at &lt;a href="https://isotc.iso.org/livelink/livelink/fetch/-8916524/8916549/8916590/6208440/class_pages/linetype.html" target="_blank"&gt;https://isotc.iso.org/livelink/livelink/fetch/-8916524/8916549/8916590/6208440/class_pages/linetype.html&lt;/a&gt;  * <br>

	 * @return value of linetype field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=Linetype, $memberObjectName=linetype, $memberObjectName=linetype)

	public int getLinetype()
	{
		return linetype;
	}

	/**
	 * Accessor method to assign int enumeration value ("1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "10" | "11" | "12" | "13" | "14" | "15" | "16") to inputOutput SFInt32 field named <i>linetype</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linetype selects a line pattern, with solid default if defined value isn't supported. Values with guaranteed support are 1 Solid, 2 Dashed, 3 Dotted, 4 Dashed-dotted, 5 Dash-dot-dot. Optionally supported values are 6 single-headed arrow (arrow tip occurs at last point of each individual list of points), 7 single dot, 8 double-headed arrow, 10 chain line, 11 center line, 12 hidden line, 13 phantom line, 14 break line 1, 15 break line 2, 16 User-specified dash pattern. Hint: detailed descriptions of lineType values are found at the ISO/IEC 9973 International Register of Graphical Items &lt;a href="https://www.iso.org/jtc1/sc24/register" target="_blank"&gt;https://www.iso.org/jtc1/sc24/register&lt;/a&gt; at &lt;a href="https://isotc.iso.org/livelink/livelink/fetch/-8916524/8916549/8916590/6208440/class_pages/linetype.html" target="_blank"&gt;https://isotc.iso.org/livelink/livelink/fetch/-8916524/8916549/8916590/6208440/class_pages/linetype.html&lt;/a&gt;  * <br>

	 * @param newValue is new value for the linetype field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LineProperties setLinetype(int newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("LineProperties linetype newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		linetype = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFInt32 linetype field, similar to {@link #setLinetype(int)}.
	 * @param newValue is new value for the linetype field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setLinetype(SFInt32 newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLinetype(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value from inputOutput SFFloat field named <i>linewidthScaleFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linewidthScaleFactor is a scale factor multiplied by browser-dependent nominal linewidth, mapped to nearest available line width. Values zero or less provide minimum available line width.  * <br>

	 * @return value of linewidthScaleFactor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=LinewidthScaleFactor, $memberObjectName=linewidthScaleFactor, $memberObjectName=linewidthScaleFactor)

	public float getLinewidthScaleFactor()
	{
		return linewidthScaleFactor;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>linewidthScaleFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linewidthScaleFactor is a scale factor multiplied by browser-dependent nominal linewidth, mapped to nearest available line width. Values zero or less provide minimum available line width.  * <br>

	 * @param newValue is new value for the linewidthScaleFactor field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LineProperties setLinewidthScaleFactor(float newValue)
	{
		// set-newValue-validity-checks #0.a
		linewidthScaleFactor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat linewidthScaleFactor field, similar to {@link #setLinewidthScaleFactor(float)}.
	 * @param newValue is new value for the linewidthScaleFactor field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setLinewidthScaleFactor(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setLinewidthScaleFactor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setLinewidthScaleFactor(float)}.
	 * @param newValue is new value for field
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setLinewidthScaleFactor(double newValue)
	{
		return setLinewidthScaleFactor((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LineProperties setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public LineProperties clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public LineProperties setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LineProperties setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to LineProperties DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("LineProperties DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LineProperties setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to LineProperties USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("LineProperties USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LineProperties setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LineProperties setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=LineProperties, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LineProperties setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LineProperties setUSE(LineProperties DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on LineProperties" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public LineProperties (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public LineProperties addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public LineProperties addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link LineProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public LineProperties addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<LineProperties"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getApplied() != APPLIED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" applied='").append(SFBool.toString(getApplied())).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getLinetype() != LINETYPE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" linetype='").append(SFInt32.toString(getLinetype())).append("'");
			}
			if (((getLinewidthScaleFactor() != LINEWIDTHSCALEFACTOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" linewidthScaleFactor='").append(SFFloat.toString(getLinewidthScaleFactor())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</LineProperties>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=LineProperties, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("LineProperties").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("applied"))
						{
							stringClassicVRML.append(indentCharacter).append("applied").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getApplied() != APPLIED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("applied ").append(SFBool.toString(getApplied())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("linetype"))
						{
							stringClassicVRML.append(indentCharacter).append("linetype").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLinetype() != LINETYPE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("linetype ").append(SFInt32.toString(getLinetype())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("linewidthScaleFactor"))
						{
							stringClassicVRML.append(indentCharacter).append("linewidthScaleFactor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getLinewidthScaleFactor() != LINEWIDTHSCALEFACTOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("linewidthScaleFactor ").append(SFFloat.toString(getLinewidthScaleFactor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setApplied(getApplied()); // exercise field checks, simple types
        
		setLinetype(getLinetype()); // exercise field checks, simple types
        
		setLinewidthScaleFactor(getLinewidthScaleFactor()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "LineProperties USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "LineProperties USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "LineProperties USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "LineProperties USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'LineProperties' node, ensure sufficient support by adding head statement <component name='Shape' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Shape\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
