/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Shaders.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Shaders.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
import java.util.Arrays;

/**
 * Appearance specifies the visual properties of geometry by containing the Material, ImageTexture/MovieTexture/PixelTexture, FillProperties, LineProperties, programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) and TextureTransform nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DAppearanceNode] Appearance specifies the visual properties of geometry
by containing the Material, ImageTexture/MovieTexture/PixelTexture, FillProperties, LineProperties, programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) and TextureTransform nodes.
Hint: insert a Shape node before adding geometry or Appearance.
Interchange profile hint: only Material and ImageTexture children are allowed.
Hint: DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene.
Hint: 
Advanced uses can contain MultiTexture, MultiTextureTransform/TextureTransformMatrix3D/TextureTransform3D, ComposedShader/PackagedShader/ProgramShader, ComposedTexture3D/ImageTexture3D/PixelTexture3D, or ComposedCubeMapTexture/GeneratedCubeMapTexture/ImageCubeMapTexture.
Hint: X3D Architecture 12.2.2 Appearance node &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shape.html#Appearancenode" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shape.html#Appearancenode&lt;/a&gt;
Hint: X3D Architecture 17.2.2 Lighting model &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#Appearance" target="blank">X3D Abstract Specification: Appearance</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Appearance" target="_blank">X3D Tooltips: Appearance</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class Appearance extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Shape.Appearance
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=acousticProperties, @type=SFNode, $javaType= org.web3d.x3d.sai.Shape.AcousticProperties, $javaReferenceType= org.web3d.x3d.sai.Shape.AcousticProperties, $javaPrimitiveType= org.web3d.x3d.sai.Shape.AcousticProperties, $normalizedMemberObjectName=acousticProperties, $isX3dStatement=false, @acceptableNodeTypes=AcousticProperties */ 
    private  org.web3d.x3d.sai.Shape.AcousticProperties acousticProperties; //  X3D field type: SFNode acceptable node types: AcousticProperties or ProtoInstance
	private ProtoInstance acousticPropertiesProtoInstance; // allowed alternative for acousticProperties field

    /* @name=alphaCutoff, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=alphaCutoff, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float alphaCutoff; //  X3D field type: SFFloat

    /* @name=alphaMode, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=alphaMode, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String alphaMode = new String(); //  X3D field type: SFString

    /* @name=fillProperties, @type=SFNode, $javaType= org.web3d.x3d.sai.Shape.FillProperties, $javaReferenceType= org.web3d.x3d.sai.Shape.FillProperties, $javaPrimitiveType= org.web3d.x3d.sai.Shape.FillProperties, $normalizedMemberObjectName=fillProperties, $isX3dStatement=false, @acceptableNodeTypes=FillProperties */ 
    private  org.web3d.x3d.sai.Shape.FillProperties fillProperties; //  X3D field type: SFNode acceptable node types: FillProperties or ProtoInstance
	private ProtoInstance fillPropertiesProtoInstance; // allowed alternative for fillProperties field

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=lineProperties, @type=SFNode, $javaType= org.web3d.x3d.sai.Shape.LineProperties, $javaReferenceType= org.web3d.x3d.sai.Shape.LineProperties, $javaPrimitiveType= org.web3d.x3d.sai.Shape.LineProperties, $normalizedMemberObjectName=lineProperties, $isX3dStatement=false, @acceptableNodeTypes=LineProperties */ 
    private  org.web3d.x3d.sai.Shape.LineProperties lineProperties; //  X3D field type: SFNode acceptable node types: LineProperties or ProtoInstance
	private ProtoInstance linePropertiesProtoInstance; // allowed alternative for lineProperties field

    /* @name=material, @type=SFNode, $javaType= org.web3d.x3d.sai.Shape.X3DMaterialNode, $javaReferenceType= org.web3d.x3d.sai.Shape.X3DMaterialNode, $javaPrimitiveType= org.web3d.x3d.sai.Shape.X3DMaterialNode, $normalizedMemberObjectName=material, $isX3dStatement=false, @acceptableNodeTypes=X3DMaterialNode */ 
    private  org.web3d.x3d.sai.Shape.X3DMaterialNode material; //  X3D field type: SFNode acceptable node types: X3DMaterialNode or ProtoInstance
	private ProtoInstance materialProtoInstance; // allowed alternative for material field

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=pointProperties, @type=SFNode, $javaType= org.web3d.x3d.sai.Shape.PointProperties, $javaReferenceType= org.web3d.x3d.sai.Shape.PointProperties, $javaPrimitiveType= org.web3d.x3d.sai.Shape.PointProperties, $normalizedMemberObjectName=pointProperties, $isX3dStatement=false, @acceptableNodeTypes=PointProperties */ 
    private  org.web3d.x3d.sai.Shape.PointProperties pointProperties; //  X3D field type: SFNode acceptable node types: PointProperties or ProtoInstance
	private ProtoInstance pointPropertiesProtoInstance; // allowed alternative for pointProperties field

    /* @name=shaders, @type=MFNode, $javaType=ArrayList< org.web3d.x3d.sai.Shaders.X3DShaderNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList< org.web3d.x3d.sai.Shaders.X3DShaderNode>, $normalizedMemberObjectName=shaders, $isX3dStatement=false, @acceptableNodeTypes=X3DShaderNode */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> shaders = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: X3DShaderNode or ProtoInstance

    /* @name=texture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTextureNode, $normalizedMemberObjectName=texture, $isX3dStatement=false, @acceptableNodeTypes=X3DTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTextureNode texture; //  X3D field type: SFNode acceptable node types: X3DTextureNode or ProtoInstance
	private ProtoInstance textureProtoInstance; // allowed alternative for texture field

    /* @name=textureTransform, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DTextureTransformNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DTextureTransformNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DTextureTransformNode, $normalizedMemberObjectName=textureTransform, $isX3dStatement=false, @acceptableNodeTypes=X3DTextureTransformNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode textureTransform; //  X3D field type: SFNode acceptable node types: X3DTextureTransformNode or ProtoInstance
	private ProtoInstance textureTransformProtoInstance; // allowed alternative for textureTransform field

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean alphaModeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> Material transparency is applied to texture transparency.
	 * SFString field named <i>alphaMode</i> with X3DUOM simpleType <i>alphaModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"AUTO"</i> (Java syntax) or <i>AUTO</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_alphaModeChoices.html">XML Schema: alphaModeChoices</a> */
	public static final String ALPHAMODE_AUTO = "AUTO";

	/** 
	 * <i>Tooltip:</i> Ignore alpha channel texture transparency, opaque.
	 * SFString field named <i>alphaMode</i> with X3DUOM simpleType <i>alphaModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"OPAQUE"</i> (Java syntax) or <i>OPAQUE</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_alphaModeChoices.html">XML Schema: alphaModeChoices</a> */
	public static final String ALPHAMODE_OPAQUE = "OPAQUE";

	/** 
	 * <i>Tooltip:</i> Alpha-testing mode for transparent when alpha value less than 0.5 and opaque when greater than or equal to 0.5.
	 * SFString field named <i>alphaMode</i> with X3DUOM simpleType <i>alphaModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"MASK"</i> (Java syntax) or <i>MASK</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_alphaModeChoices.html">XML Schema: alphaModeChoices</a> */
	public static final String ALPHAMODE_MASK = "MASK";

	/** 
	 * <i>Tooltip:</i> Blend combines partial transparency of textures and materials.
	 * SFString field named <i>alphaMode</i> with X3DUOM simpleType <i>alphaModeChoices</i> and with X3DUOM baseType <i>SFString</i> can equal this value <i>"BLEND"</i> (Java syntax) or <i>BLEND</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_alphaModeChoices.html">XML Schema: alphaModeChoices</a> */
	public static final String ALPHAMODE_BLEND = "BLEND";

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>Appearance</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "Appearance";

	/** Provides name of this element: <i>Appearance</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>Appearance</i> element: <i>Shape</i> */
	public static final String COMPONENT = "Shape";

	/** Defines X3D component for the <i>Appearance</i> element: <i>Shape</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Shape</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFNode field named <i>acousticProperties</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Shape.AcousticProperties ACOUSTICPROPERTIES_DEFAULT_VALUE = null;

	/** SFFloat field named <i>alphaCutoff</i> has default value <i>0.5f</i> (Java syntax) or <i>0.5</i> (XML syntax). */
	public static final float ALPHACUTOFF_DEFAULT_VALUE = 0.5f;

	/** SFString field named <i>alphaMode</i> has default value <i>"AUTO"</i> (Java syntax) or <i>AUTO</i> (XML syntax). */
	public static final String ALPHAMODE_DEFAULT_VALUE = "AUTO";

	/** SFNode field named <i>fillProperties</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Shape.FillProperties FILLPROPERTIES_DEFAULT_VALUE = null;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>lineProperties</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Shape.LineProperties LINEPROPERTIES_DEFAULT_VALUE = null;

	/** SFNode field named <i>material</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Shape.X3DMaterialNode MATERIAL_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFNode field named <i>pointProperties</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Shape.PointProperties POINTPROPERTIES_DEFAULT_VALUE = null;

	/** SFNode field named <i>texture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTextureNode TEXTURE_DEFAULT_VALUE = null;

	/** SFNode field named <i>textureTransform</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode TEXTURETRANSFORM_DEFAULT_VALUE = null;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "acousticProperties":
				result = "SFNode";
				break;
			case "alphaCutoff":
				result = "SFFloat";
				break;
			case "alphaMode":
				result = "SFString";
				break;
			case "fillProperties":
				result = "SFNode";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "lineProperties":
				result = "SFNode";
				break;
			case "material":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "pointProperties":
				result = "SFNode";
				break;
			case "shaders":
				result = "MFNode";
				break;
			case "texture":
				result = "SFNode";
				break;
			case "textureTransform":
				result = "SFNode";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "acousticProperties":
				result = "inputOutput";
				break;
			case "alphaCutoff":
				result = "inputOutput";
				break;
			case "alphaMode":
				result = "inputOutput";
				break;
			case "fillProperties":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "lineProperties":
				result = "inputOutput";
				break;
			case "material":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "pointProperties":
				result = "inputOutput";
				break;
			case "shaders":
				result = "inputOutput";
				break;
			case "texture":
				result = "inputOutput";
				break;
			case "textureTransform":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "appearance"; // type xs:NMTOKEN
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFNode field named <i>acousticProperties</i>. */
	public static final String fromField_ACOUSTICPROPERTIES = "acousticProperties";

	/** toField ROUTE name for SFNode field named <i>acousticProperties</i>. */
	public static final String toField_ACOUSTICPROPERTIES = "acousticProperties";

	/** fromField ROUTE name for SFFloat field named <i>alphaCutoff</i>. */
	public static final String fromField_ALPHACUTOFF = "alphaCutoff";

	/** toField ROUTE name for SFFloat field named <i>alphaCutoff</i>. */
	public static final String toField_ALPHACUTOFF = "alphaCutoff";

	/** fromField ROUTE name for SFString field named <i>alphaMode</i>. */
	public static final String fromField_ALPHAMODE = "alphaMode";

	/** toField ROUTE name for SFString field named <i>alphaMode</i>. */
	public static final String toField_ALPHAMODE = "alphaMode";

	/** fromField ROUTE name for SFNode field named <i>fillProperties</i>. */
	public static final String fromField_FILLPROPERTIES = "fillProperties";

	/** toField ROUTE name for SFNode field named <i>fillProperties</i>. */
	public static final String toField_FILLPROPERTIES = "fillProperties";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>lineProperties</i>. */
	public static final String fromField_LINEPROPERTIES = "lineProperties";

	/** toField ROUTE name for SFNode field named <i>lineProperties</i>. */
	public static final String toField_LINEPROPERTIES = "lineProperties";

	/** fromField ROUTE name for SFNode field named <i>material</i>. */
	public static final String fromField_MATERIAL = "material";

	/** toField ROUTE name for SFNode field named <i>material</i>. */
	public static final String toField_MATERIAL = "material";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFNode field named <i>pointProperties</i>. */
	public static final String fromField_POINTPROPERTIES = "pointProperties";

	/** toField ROUTE name for SFNode field named <i>pointProperties</i>. */
	public static final String toField_POINTPROPERTIES = "pointProperties";

	/** fromField ROUTE name for MFNode field named <i>shaders</i>. */
	public static final String fromField_SHADERS = "shaders";

	/** toField ROUTE name for MFNode field named <i>shaders</i>. */
	public static final String toField_SHADERS = "shaders";

	/** fromField ROUTE name for SFNode field named <i>texture</i>. */
	public static final String fromField_TEXTURE = "texture";

	/** toField ROUTE name for SFNode field named <i>texture</i>. */
	public static final String toField_TEXTURE = "texture";

	/** fromField ROUTE name for SFNode field named <i>textureTransform</i>. */
	public static final String fromField_TEXTURETRANSFORM = "textureTransform";

	/** toField ROUTE name for SFNode field named <i>textureTransform</i>. */
	public static final String toField_TEXTURETRANSFORM = "textureTransform";

	/** Constructor for Appearance to initialize member variables with default values. */
	public Appearance()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "appearance" }; // type xs:NMTOKEN

		acousticProperties = null;              // clear out any prior node
		acousticPropertiesProtoInstance = null; // clear out any prior node
		alphaCutoff = ALPHACUTOFF_DEFAULT_VALUE;
		alphaMode = ALPHAMODE_DEFAULT_VALUE;
		fillProperties = null;              // clear out any prior node
		fillPropertiesProtoInstance = null; // clear out any prior node
		IS = null; // clear out any prior node
		lineProperties = null;              // clear out any prior node
		linePropertiesProtoInstance = null; // clear out any prior node
		material = null;              // clear out any prior node
		materialProtoInstance = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		pointProperties = null;              // clear out any prior node
		pointPropertiesProtoInstance = null; // clear out any prior node
		shaders = new ArrayList<>();
		texture = null;              // clear out any prior node
		textureProtoInstance = null; // clear out any prior node
		textureTransform = null;              // clear out any prior node
		textureTransformProtoInstance = null; // clear out any prior node

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide  org.web3d.x3d.sai.Shape.AcousticProperties instance (using a properly typed node) from inputOutput SFNode field <i>acousticProperties</i>.
	 * @see #getAcousticPropertiesProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [AcousticProperties] Single contained acousticProperties node that can specify additional acoustic attributes applied to associated surface geometry.  * <br>

	 * @return value of acousticProperties field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AcousticProperties, $memberObjectName=acousticProperties, $memberObjectName=acousticProperties)

	public  org.web3d.x3d.sai.Shape.AcousticProperties getAcousticProperties()
	{
		return acousticProperties;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.AcousticProperties instance (using a properly typed node) to inputOutput SFNode field <i>acousticProperties</i>.
	 * @see #setAcousticProperties(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [AcousticProperties] Single contained acousticProperties node that can specify additional acoustic attributes applied to associated surface geometry.  * <br>

	 * @param newValue is new value for the acousticProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setAcousticProperties( org.web3d.x3d.sai.Shape.AcousticProperties newValue)
	{
		// set-newValue-validity-checks #0.a
		acousticProperties = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) acousticProperties).setParent(this); // parentTest15.1
		}
		if (acousticPropertiesProtoInstance != null)
		{
			acousticPropertiesProtoInstance.setParent(null); // housekeeping, clear prior object
			acousticPropertiesProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of acousticProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearAcousticProperties()
	{
		((X3DConcreteElement) acousticProperties).clearParent(); // remove references to facilitate Java memory management
		acousticProperties = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>acousticProperties</i>.
	 * @see #setAcousticProperties( org.web3d.x3d.sai.Shape.AcousticProperties)
	 * @param newValue is new value for the acousticProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAcousticProperties(ProtoInstance newValue)
	{
		if (acousticPropertiesProtoInstance != null)
		{
			((X3DConcreteElement) acousticPropertiesProtoInstance).setParent(null); // parentTest15.5
	    }
		acousticPropertiesProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) acousticPropertiesProtoInstance).setParent(this); // parentTest15.6
            acousticPropertiesProtoInstance.setContainerField("acousticProperties");
	    }
		if (acousticProperties != null)
		{
			((X3DConcreteElement) acousticProperties).setParent(null); // housekeeping, clear prior object
			acousticProperties = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getAcousticPropertiesProtoInstance()
		{
			return acousticPropertiesProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>acousticProperties</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getAcousticProperties()
	 * @see #getAcousticPropertiesProtoInstance()
	 */
	public boolean hasAcousticProperties()
	{
		return (acousticProperties != null) || (acousticPropertiesProtoInstance != null);
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>alphaCutoff</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Threshold value used for pixel rendering either transparent or opaque, used when alphaMode="MASK". Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @return value of alphaCutoff field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AlphaCutoff, $memberObjectName=alphaCutoff, $memberObjectName=alphaCutoff)

	public float getAlphaCutoff()
	{
		return alphaCutoff;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>alphaCutoff</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Threshold value used for pixel rendering either transparent or opaque, used when alphaMode="MASK". Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @param newValue is new value for the alphaCutoff field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setAlphaCutoff(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Appearance alphaCutoff newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("Appearance alphaCutoff newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		alphaCutoff = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat alphaCutoff field, similar to {@link #setAlphaCutoff(float)}.
	 * @param newValue is new value for the alphaCutoff field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAlphaCutoff(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAlphaCutoff(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setAlphaCutoff(float)}.
	 * @param newValue is new value for field
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAlphaCutoff(double newValue)
	{
		return setAlphaCutoff((float) newValue);
	}
	/**
	 * Provide String enumeration value (baseType SFString) ["AUTO" | "OPAQUE" | "MASK" | "BLEND"] from inputOutput SFString field named <i>alphaMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Provides options for control of alpha transparency handling for textures. AUTO means Material transparency is applied to texture transparency for full backwards compatility with X3D3, OPAQUE means ignore alpha transparency to render texture as opaque, MASK means alpha-testing of pixels as fully transparent when alpha value is less than alphaCutoff and fully opaque when alpha value is greater than or equal to alphaCutoff, BLEND combines partial transparency of textures and materials. Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #ALPHAMODE_AUTO AUTO}, {@link #ALPHAMODE_OPAQUE OPAQUE}, {@link #ALPHAMODE_MASK MASK}, {@link #ALPHAMODE_BLEND BLEND}.
	 * @return value of alphaMode field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=AlphaMode, $memberObjectName=alphaMode, $memberObjectName=alphaMode)

	public String getAlphaMode()
	{
		return alphaMode;
	}

	/**
	 * Accessor method to assign String enumeration value ("AUTO" | "OPAQUE" | "MASK" | "BLEND") to inputOutput SFString field named <i>alphaMode</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #ALPHAMODE_AUTO AUTO}, {@link #ALPHAMODE_OPAQUE OPAQUE}, {@link #ALPHAMODE_MASK MASK}, {@link #ALPHAMODE_BLEND BLEND}).
	 * <br><br>
	 * <i>Tooltip:</i>  Provides options for control of alpha transparency handling for textures. AUTO means Material transparency is applied to texture transparency for full backwards compatility with X3D3, OPAQUE means ignore alpha transparency to render texture as opaque, MASK means alpha-testing of pixels as fully transparent when alpha value is less than alphaCutoff and fully opaque when alpha value is greater than or equal to alphaCutoff, BLEND combines partial transparency of textures and materials. Hint: glTF version 2 Alpha Coverage, &lt;a href="https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage" target="_blank"&gt;https://www.khronos.org/registry/glTF/specs/2.0/glTF-2.0.html#alpha-coverage&lt;/a&gt;  * <br>

	 * @param newValue is new value for the alphaMode field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setAlphaMode(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(ALPHAMODE_AUTO) ||
			newValue.toString().replace("\"","").equals(ALPHAMODE_OPAQUE) ||
			newValue.toString().replace("\"","").equals(ALPHAMODE_MASK) ||
			newValue.toString().replace("\"","").equals(ALPHAMODE_BLEND)))
		{
			String warningMessage = "[warning] Appearance alphaMode newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!alphaModeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are AUTO, OPAQUE, MASK, BLEND";
			    alphaModeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		alphaMode = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString alphaMode field, similar to {@link #setAlphaMode(String)}.
	 * @param newValue is new value for the alphaMode field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setAlphaMode(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAlphaMode(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Shape.FillProperties instance (using a properly typed node) from inputOutput SFNode field <i>fillProperties</i>.
	 * @see #getFillPropertiesProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [FillProperties] Single contained FillProperties node that can specify additional visual attributes applied to polygonal areas of corresponding geometry, on top of whatever other appearance is already defined.  * <br>

	 * @return value of fillProperties field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=FillProperties, $memberObjectName=fillProperties, $memberObjectName=fillProperties)

	public  org.web3d.x3d.sai.Shape.FillProperties getFillProperties()
	{
		return fillProperties;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.FillProperties instance (using a properly typed node) to inputOutput SFNode field <i>fillProperties</i>.
	 * @see #setFillProperties(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [FillProperties] Single contained FillProperties node that can specify additional visual attributes applied to polygonal areas of corresponding geometry, on top of whatever other appearance is already defined.  * <br>

	 * @param newValue is new value for the fillProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setFillProperties( org.web3d.x3d.sai.Shape.FillProperties newValue)
	{
		// set-newValue-validity-checks #0.a
		fillProperties = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) fillProperties).setParent(this); // parentTest15.1
		}
		if (fillPropertiesProtoInstance != null)
		{
			fillPropertiesProtoInstance.setParent(null); // housekeeping, clear prior object
			fillPropertiesProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of fillProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearFillProperties()
	{
		((X3DConcreteElement) fillProperties).clearParent(); // remove references to facilitate Java memory management
		fillProperties = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>fillProperties</i>.
	 * @see #setFillProperties( org.web3d.x3d.sai.Shape.FillProperties)
	 * @param newValue is new value for the fillProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setFillProperties(ProtoInstance newValue)
	{
		if (fillPropertiesProtoInstance != null)
		{
			((X3DConcreteElement) fillPropertiesProtoInstance).setParent(null); // parentTest15.5
	    }
		fillPropertiesProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) fillPropertiesProtoInstance).setParent(this); // parentTest15.6
            fillPropertiesProtoInstance.setContainerField("fillProperties");
	    }
		if (fillProperties != null)
		{
			((X3DConcreteElement) fillProperties).setParent(null); // housekeeping, clear prior object
			fillProperties = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getFillPropertiesProtoInstance()
		{
			return fillPropertiesProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>fillProperties</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getFillProperties()
	 * @see #getFillPropertiesProtoInstance()
	 */
	public boolean hasFillProperties()
	{
		return (fillProperties != null) || (fillPropertiesProtoInstance != null);
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Shape.LineProperties instance (using a properly typed node) from inputOutput SFNode field <i>lineProperties</i>.
	 * @see #getLinePropertiesProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained LineProperties node that can specify additional visual attributes applied to corresponding line geometry.  * <br>

	 * @return value of lineProperties field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=LineProperties, $memberObjectName=lineProperties, $memberObjectName=lineProperties)

	public  org.web3d.x3d.sai.Shape.LineProperties getLineProperties()
	{
		return lineProperties;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.LineProperties instance (using a properly typed node) to inputOutput SFNode field <i>lineProperties</i>.
	 * @see #setLineProperties(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained LineProperties node that can specify additional visual attributes applied to corresponding line geometry.  * <br>

	 * @param newValue is new value for the lineProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setLineProperties( org.web3d.x3d.sai.Shape.LineProperties newValue)
	{
		// set-newValue-validity-checks #0.a
		lineProperties = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) lineProperties).setParent(this); // parentTest15.1
		}
		if (linePropertiesProtoInstance != null)
		{
			linePropertiesProtoInstance.setParent(null); // housekeeping, clear prior object
			linePropertiesProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of lineProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearLineProperties()
	{
		((X3DConcreteElement) lineProperties).clearParent(); // remove references to facilitate Java memory management
		lineProperties = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>lineProperties</i>.
	 * @see #setLineProperties( org.web3d.x3d.sai.Shape.LineProperties)
	 * @param newValue is new value for the lineProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setLineProperties(ProtoInstance newValue)
	{
		if (linePropertiesProtoInstance != null)
		{
			((X3DConcreteElement) linePropertiesProtoInstance).setParent(null); // parentTest15.5
	    }
		linePropertiesProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) linePropertiesProtoInstance).setParent(this); // parentTest15.6
            linePropertiesProtoInstance.setContainerField("lineProperties");
	    }
		if (lineProperties != null)
		{
			((X3DConcreteElement) lineProperties).setParent(null); // housekeeping, clear prior object
			lineProperties = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getLinePropertiesProtoInstance()
		{
			return linePropertiesProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>lineProperties</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getLineProperties()
	 * @see #getLinePropertiesProtoInstance()
	 */
	public boolean hasLineProperties()
	{
		return (lineProperties != null) || (linePropertiesProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) from inputOutput SFNode field <i>material</i>.
	 * @see #getMaterialProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Single contained Material node that can specify visual attributes for lighting response (color types, transparency, etc.) applied to corresponding geometry. Warning: if material is NULL or unspecified, lighting is off (all lights ignored) for this Shape and unlit object color is (1, 1, 1).  * <br>

	 * @return value of material field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Material, $memberObjectName=material, $memberObjectName=material)

	public  org.web3d.x3d.sai.Shape.X3DMaterialNode getMaterial()
	{
		return material;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.X3DMaterialNode instance (using a properly typed node) to inputOutput SFNode field <i>material</i>.
	 * @see #setMaterial(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMaterialNode] Single contained Material node that can specify visual attributes for lighting response (color types, transparency, etc.) applied to corresponding geometry. Warning: if material is NULL or unspecified, lighting is off (all lights ignored) for this Shape and unlit object color is (1, 1, 1).  * <br>

	 * @param newValue is new value for the material field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setMaterial( org.web3d.x3d.sai.Shape.X3DMaterialNode newValue)
	{
		// set-newValue-validity-checks #0.a
		material = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) material).setParent(this); // parentTest15.1
		}
		if (materialProtoInstance != null)
		{
			materialProtoInstance.setParent(null); // housekeeping, clear prior object
			materialProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of material field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearMaterial()
	{
		((X3DConcreteElement) material).clearParent(); // remove references to facilitate Java memory management
		material = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>material</i>.
	 * @see #setMaterial( org.web3d.x3d.sai.Shape.X3DMaterialNode)
	 * @param newValue is new value for the material field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setMaterial(ProtoInstance newValue)
	{
		if (materialProtoInstance != null)
		{
			((X3DConcreteElement) materialProtoInstance).setParent(null); // parentTest15.5
	    }
		materialProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) materialProtoInstance).setParent(this); // parentTest15.6
            materialProtoInstance.setContainerField("material");
	    }
		if (material != null)
		{
			((X3DConcreteElement) material).setParent(null); // housekeeping, clear prior object
			material = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMaterialProtoInstance()
		{
			return materialProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>material</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMaterial()
	 * @see #getMaterialProtoInstance()
	 */
	public boolean hasMaterial()
	{
		return (material != null) || (materialProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public Appearance setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Shape.PointProperties instance (using a properly typed node) from inputOutput SFNode field <i>pointProperties</i>.
	 * @see #getPointPropertiesProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained PointProperties node that can specify additional visual attributes applied to corresponding point geometry.  * <br>

	 * @return value of pointProperties field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=PointProperties, $memberObjectName=pointProperties, $memberObjectName=pointProperties)

	public  org.web3d.x3d.sai.Shape.PointProperties getPointProperties()
	{
		return pointProperties;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shape.PointProperties instance (using a properly typed node) to inputOutput SFNode field <i>pointProperties</i>.
	 * @see #setPointProperties(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [LineProperties] Single contained PointProperties node that can specify additional visual attributes applied to corresponding point geometry.  * <br>

	 * @param newValue is new value for the pointProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setPointProperties( org.web3d.x3d.sai.Shape.PointProperties newValue)
	{
		// set-newValue-validity-checks #0.a
		pointProperties = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) pointProperties).setParent(this); // parentTest15.1
		}
		if (pointPropertiesProtoInstance != null)
		{
			pointPropertiesProtoInstance.setParent(null); // housekeeping, clear prior object
			pointPropertiesProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of pointProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearPointProperties()
	{
		((X3DConcreteElement) pointProperties).clearParent(); // remove references to facilitate Java memory management
		pointProperties = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>pointProperties</i>.
	 * @see #setPointProperties( org.web3d.x3d.sai.Shape.PointProperties)
	 * @param newValue is new value for the pointProperties field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setPointProperties(ProtoInstance newValue)
	{
		if (pointPropertiesProtoInstance != null)
		{
			((X3DConcreteElement) pointPropertiesProtoInstance).setParent(null); // parentTest15.5
	    }
		pointPropertiesProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) pointPropertiesProtoInstance).setParent(this); // parentTest15.6
            pointPropertiesProtoInstance.setContainerField("pointProperties");
	    }
		if (pointProperties != null)
		{
			((X3DConcreteElement) pointProperties).setParent(null); // housekeeping, clear prior object
			pointProperties = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getPointPropertiesProtoInstance()
		{
			return pointPropertiesProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>pointProperties</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getPointProperties()
	 * @see #getPointPropertiesProtoInstance()
	 */
	public boolean hasPointProperties()
	{
		return (pointProperties != null) || (pointPropertiesProtoInstance != null);
	}
	/**
	 * Provide array of  org.web3d.x3d.sai.Shaders.X3DShaderNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>shaders</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DShaderNode] Zero or more contained programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) that specify, in order of preference, author-programmed rendering characteristics. Hint: X3D Architecture 31 Programmable shaders component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @see org.web3d.x3d.sai.Shaders.X3DShaderNode
	 * @return value of shaders field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Shaders, $memberObjectName=shaders, $memberObjectName=shaders)

	public org.web3d.x3d.sai.Core.X3DNode[] getShaders()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[shaders.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : shaders) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode shaders field, similar to {@link #getShaders()}.
	 * @return value of shaders field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getShadersList()
	{
		return shaders;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Shaders.X3DShaderNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>shaders</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DShaderNode] Zero or more contained programmable shader nodes (ComposedShader, PackagedShader, ProgramShader) that specify, in order of preference, author-programmed rendering characteristics. Hint: X3D Architecture 31 Programmable shaders component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/shaders.html&lt;/a&gt;  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @param newValue is new value for the shaders field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setShaders(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)			// reset value field to empty array
		{
			clearShaders(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearShaders(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				shaders.add((org.web3d.x3d.sai.Core.X3DNode)newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest12
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
		}
		return this;
	}

	/**
	 * Assign ArrayList value of MFNode shaders field, similar to {@link #setShaders(org.web3d.x3d.sai.Core.X3DNode[])}.
	 * @param newValue is new value for the shaders field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setShaders(ArrayList< org.web3d.x3d.sai.Shaders.X3DShaderNode> newValue)
	{
		if (newValue == null)			// reset value field to empty array
		{
			clearShaders(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearShaders(); // reset
        else
        {
            org.web3d.x3d.sai.Core.X3DNode[] newArray = new org.web3d.x3d.sai.Core.X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setShaders(newArray);
        }
		for ( org.web3d.x3d.sai.Shaders.X3DShaderNode element : newValue)
		{
			shaders.add((org.web3d.x3d.sai.Core.X3DNode) element);
			((X3DConcreteElement) element).setParent(this); // parentTest13
		}
		return this;
	}
	/**
	 * Add single child node to existing array of shaders nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode and ProtoInstance.
	 * @param newValue is new value to be appended the shaders field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public Appearance addShaders(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		shaders.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest2
		return this;
	}
	/**
	 * Add single ProtoInstance (with appropriate node type and containerField value) to MFNode array for shaders field.
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to ShaderPart and ProtoInstance.
	 * @param newValue is new value to be appended the parts field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public Appearance addShaders(ProtoInstance newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		shaders.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest16
		return this;
	}
	/**
	 * Add array of child shaders nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DShaderNode.
	 * @param newValue is new value array to be appended the shaders field.
	 */
	public void addShaders(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				shaders.add(newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest6
				if (newValue[i] instanceof ProtoInstance)
					((ProtoInstance) newValue[i]).setContainerField("shaders");
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
		}
	}

	/**
	 * Set single child shaders node, replacing prior array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are restricted to X3DShaderNode.
	 * @param newValue is new node for the shaders field (restricted to X3DShaderNode)
	 */
	/* @Override */
	public void setShaders(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null)
		{
			clearShaders(); // reset newValueNullClearsFieldReturnVoid
			return;
		}
		if  (newValue instanceof org.web3d.x3d.sai.Core.X3DNode)
		{
			for (org.web3d.x3d.sai.Core.X3DNode element : shaders)
				((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
			clearShaders(); // reset
			((X3DConcreteElement) newValue).setParent(this); // parentTest8
			shaders.add(newValue);
		}
		else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
}
	/**
	 * Utility method to clear MFNode value of shaders field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public Appearance clearShaders()
	{
		for (org.web3d.x3d.sai.Core.X3DNode element : shaders)
			((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
		shaders.clear(); // reset MF field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput MFNode field <i>shaders</i>.
	 * @return whether a properly typed node or ProtoInstance array or CommentsBlock is available.
	 * @see #getShaders()
	 */
	public boolean hasShaders()
	{
		return (!shaders.isEmpty());
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>texture</i>.
	 * @see #getTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @return value of texture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=Texture, $memberObjectName=texture, $memberObjectName=texture)

	public  org.web3d.x3d.sai.Texturing.X3DTextureNode getTexture()
	{
		return texture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>texture</i>.
	 * @see #setTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureNode] Single contained texture node (ImageTexture, MovieTexture, PixelTexture, MultiTexture) that maps image(s) to surface geometry. Hint: if texture node is NULL or unspecified, corresponding Shape geometry for this Appearance is not textured. Hint: X3D Scene Authoring Hints, Images &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Images&lt;/a&gt; Hint: X3D Architecture 18 Texturing component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texturing.html&lt;/a&gt; Hint: X3D Architecture 33 Texturing3D component &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/texture3D.html&lt;/a&gt;  * <br>

	 * @param newValue is new value for the texture field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setTexture( org.web3d.x3d.sai.Texturing.X3DTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		texture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) texture).setParent(this); // parentTest15.1
		}
		if (textureProtoInstance != null)
		{
			textureProtoInstance.setParent(null); // housekeeping, clear prior object
			textureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of texture field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearTexture()
	{
		((X3DConcreteElement) texture).clearParent(); // remove references to facilitate Java memory management
		texture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>texture</i>.
	 * @see #setTexture( org.web3d.x3d.sai.Texturing.X3DTextureNode)
	 * @param newValue is new value for the texture field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setTexture(ProtoInstance newValue)
	{
		if (textureProtoInstance != null)
		{
			((X3DConcreteElement) textureProtoInstance).setParent(null); // parentTest15.5
	    }
		textureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) textureProtoInstance).setParent(this); // parentTest15.6
            textureProtoInstance.setContainerField("texture");
	    }
		if (texture != null)
		{
			((X3DConcreteElement) texture).setParent(null); // housekeeping, clear prior object
			texture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getTextureProtoInstance()
		{
			return textureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>texture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getTexture()
	 * @see #getTextureProtoInstance()
	 */
	public boolean hasTexture()
	{
		return (texture != null) || (textureProtoInstance != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode instance (using a properly typed node) from inputOutput SFNode field <i>textureTransform</i>.
	 * @see #getTextureTransformProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureTransformNode] Single contained TextureTransform node that defines 2D transformation applied to texture coordinates. Hint: Texture coordinates are reapplied (or else recomputed if textureTransform field initially NULL) whenever the corresponding vertex-based geometry changes. Hint: if textureTransform array is empty, then this field has no effect.  * <br>

	 * @return value of textureTransform field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=TextureTransform, $memberObjectName=textureTransform, $memberObjectName=textureTransform)

	public  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode getTextureTransform()
	{
		return textureTransform;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DTextureTransformNode instance (using a properly typed node) to inputOutput SFNode field <i>textureTransform</i>.
	 * @see #setTextureTransform(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DTextureTransformNode] Single contained TextureTransform node that defines 2D transformation applied to texture coordinates. Hint: Texture coordinates are reapplied (or else recomputed if textureTransform field initially NULL) whenever the corresponding vertex-based geometry changes. Hint: if textureTransform array is empty, then this field has no effect.  * <br>

	 * @param newValue is new value for the textureTransform field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Appearance setTextureTransform( org.web3d.x3d.sai.Texturing.X3DTextureTransformNode newValue)
	{
		// set-newValue-validity-checks #0.a
		textureTransform = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) textureTransform).setParent(this); // parentTest15.1
		}
		if (textureTransformProtoInstance != null)
		{
			textureTransformProtoInstance.setParent(null); // housekeeping, clear prior object
			textureTransformProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of textureTransform field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public Appearance clearTextureTransform()
	{
		((X3DConcreteElement) textureTransform).clearParent(); // remove references to facilitate Java memory management
		textureTransform = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>textureTransform</i>.
	 * @see #setTextureTransform( org.web3d.x3d.sai.Texturing.X3DTextureTransformNode)
	 * @param newValue is new value for the textureTransform field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setTextureTransform(ProtoInstance newValue)
	{
		if (textureTransformProtoInstance != null)
		{
			((X3DConcreteElement) textureTransformProtoInstance).setParent(null); // parentTest15.5
	    }
		textureTransformProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) textureTransformProtoInstance).setParent(this); // parentTest15.6
            textureTransformProtoInstance.setContainerField("textureTransform");
	    }
		if (textureTransform != null)
		{
			((X3DConcreteElement) textureTransform).setParent(null); // housekeeping, clear prior object
			textureTransform = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getTextureTransformProtoInstance()
		{
			return textureTransformProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>textureTransform</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getTextureTransform()
	 * @see #getTextureTransformProtoInstance()
	 */
	public boolean hasTextureTransform()
	{
		return (textureTransform != null) || (textureTransformProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Appearance setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to Appearance DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Appearance DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Appearance setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to Appearance USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("Appearance USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Appearance setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Appearance setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceNode, $additionalInheritanceBaseType=, $thisClassName=Appearance, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final Appearance setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Appearance setUSE(Appearance DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on Appearance" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public Appearance (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public Appearance addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public Appearance addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link Appearance} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public Appearance addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (acousticProperties != null) || (acousticPropertiesProtoInstance != null) || (fillProperties != null) || (fillPropertiesProtoInstance != null) || (IS != null) || (lineProperties != null) || (linePropertiesProtoInstance != null) || (material != null) || (materialProtoInstance != null) || (metadata != null) || (metadataProtoInstance != null) || (pointProperties != null) || (pointPropertiesProtoInstance != null) || (!shaders.isEmpty()) || (texture != null) || (textureProtoInstance != null) || (textureTransform != null) || (textureTransformProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<Appearance"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getAlphaCutoff() != ALPHACUTOFF_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" alphaCutoff='").append(SFFloat.toString(getAlphaCutoff())).append("'");
			}
			if ((!getAlphaMode().equals(ALPHAMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" alphaMode='").append(new SFString(getAlphaMode()).toStringX3D()).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (acousticProperties != null)
			{
				stringX3D.append(((X3DConcreteElement)acousticProperties).toStringX3D(indentLevel + indentIncrement));
			}
			else if (acousticPropertiesProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)acousticPropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (fillProperties != null)
			{
				stringX3D.append(((X3DConcreteElement)fillProperties).toStringX3D(indentLevel + indentIncrement));
			}
			else if (fillPropertiesProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)fillPropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (lineProperties != null)
			{
				stringX3D.append(((X3DConcreteElement)lineProperties).toStringX3D(indentLevel + indentIncrement));
			}
			else if (linePropertiesProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)linePropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (material != null)
			{
				stringX3D.append(((X3DConcreteElement)material).toStringX3D(indentLevel + indentIncrement));
			}
			else if (materialProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)materialProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (pointProperties != null)
			{
				stringX3D.append(((X3DConcreteElement)pointProperties).toStringX3D(indentLevel + indentIncrement));
			}
			else if (pointPropertiesProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)pointPropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			for (org.web3d.x3d.sai.Core.X3DNode element : shaders)
			{
				stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
			}
			if      (texture != null)
			{
				stringX3D.append(((X3DConcreteElement)texture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (textureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)textureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (textureTransform != null)
			{
				stringX3D.append(((X3DConcreteElement)textureTransform).toStringX3D(indentLevel + indentIncrement));
			}
			else if (textureTransformProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)textureTransformProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</Appearance>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=Appearance, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (acousticProperties != null) || (acousticPropertiesProtoInstance != null) || (fillProperties != null) || (fillPropertiesProtoInstance != null) || (IS != null) || (lineProperties != null) || (linePropertiesProtoInstance != null) || (material != null) || (materialProtoInstance != null) || (metadata != null) || (metadataProtoInstance != null) || (pointProperties != null) || (pointPropertiesProtoInstance != null) || (!shaders.isEmpty()) || (texture != null) || (textureProtoInstance != null) || (textureTransform != null) || (textureTransformProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("Appearance").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("alphaCutoff"))
						{
							stringClassicVRML.append(indentCharacter).append("alphaCutoff").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAlphaCutoff() != ALPHACUTOFF_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("alphaCutoff ").append(SFFloat.toString(getAlphaCutoff())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("alphaMode"))
						{
							stringClassicVRML.append(indentCharacter).append("alphaMode").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getAlphaMode().equals(ALPHAMODE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("alphaMode ").append("\"").append(SFString.toString(getAlphaMode())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (acousticProperties != null)
			{
				stringClassicVRML.append(indentCharacter).append("acousticProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) acousticProperties).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (acousticPropertiesProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("acousticProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) acousticPropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (fillProperties != null)
			{
				stringClassicVRML.append(indentCharacter).append("fillProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) fillProperties).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (fillPropertiesProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("fillProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) fillPropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (lineProperties != null)
			{
				stringClassicVRML.append(indentCharacter).append("lineProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) lineProperties).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (linePropertiesProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("lineProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) linePropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (material != null)
			{
				stringClassicVRML.append(indentCharacter).append("material").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) material).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (materialProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("material").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) materialProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (pointProperties != null)
			{
				stringClassicVRML.append(indentCharacter).append("pointProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) pointProperties).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (pointPropertiesProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("pointProperties").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) pointPropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (shaders.size() > 0)
			{
				stringClassicVRML.append(indentCharacter).append(indentCharacter).append("shaders").append(" [").append("\n")
					.append(indent).append(indentCharacter).append(indentCharacter); // containerField for MFNode array
			for (org.web3d.x3d.sai.Core.X3DNode element : shaders)
			{
				stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
			}
				stringClassicVRML.append(indent).append(indentCharacter).append(indentCharacter).append("]").append("\n")
					.append(indent); // end MFNode array
			}

			if (texture != null)
			{
				stringClassicVRML.append(indentCharacter).append("texture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) texture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (textureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("texture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) textureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (textureTransform != null)
			{
				stringClassicVRML.append(indentCharacter).append("textureTransform").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) textureTransform).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (textureTransformProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("textureTransform").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) textureTransformProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (acousticProperties != null)
		{
			referenceElement = ((X3DConcreteElement) acousticProperties).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (acousticPropertiesProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) acousticPropertiesProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (fillProperties != null)
		{
			referenceElement = ((X3DConcreteElement) fillProperties).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (fillPropertiesProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) fillPropertiesProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (lineProperties != null)
		{
			referenceElement = ((X3DConcreteElement) lineProperties).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (linePropertiesProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) linePropertiesProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (material != null)
		{
			referenceElement = ((X3DConcreteElement) material).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (materialProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) materialProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (pointProperties != null)
		{
			referenceElement = ((X3DConcreteElement) pointProperties).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (pointPropertiesProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) pointPropertiesProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : shaders) // MFNode
		{
			if (element instanceof X3DConcreteElement)
			{
				referenceElement = ((X3DConcreteElement) element).findElementByNameValue(nameValue, elementName);
				if (referenceElement != null)
					return referenceElement;
			}
		}
		if (texture != null)
		{
			referenceElement = ((X3DConcreteElement) texture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (textureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) textureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (textureTransform != null)
		{
			referenceElement = ((X3DConcreteElement) textureTransform).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (textureTransformProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) textureTransformProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (acousticProperties != null)
		{
			referenceNode = ((X3DConcreteElement) acousticProperties).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (acousticPropertiesProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) acousticPropertiesProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (fillProperties != null)
		{
			referenceNode = ((X3DConcreteElement) fillProperties).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (fillPropertiesProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) fillPropertiesProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (lineProperties != null)
		{
			referenceNode = ((X3DConcreteElement) lineProperties).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (linePropertiesProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) linePropertiesProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (material != null)
		{
			referenceNode = ((X3DConcreteElement) material).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (materialProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) materialProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (pointProperties != null)
		{
			referenceNode = ((X3DConcreteElement) pointProperties).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (pointPropertiesProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) pointPropertiesProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : shaders) // MFNode
		{
			if (element instanceof org.web3d.x3d.jsail.X3DConcreteNode)
			{
				referenceNode = ((X3DConcreteElement) element).findNodeByDEF(DEFvalue);
				if (referenceNode != null)
					return referenceNode;
			}
		}
		if (texture != null)
		{
			referenceNode = ((X3DConcreteElement) texture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (textureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) textureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (textureTransform != null)
		{
			referenceNode = ((X3DConcreteElement) textureTransform).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (textureTransformProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) textureTransformProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setAlphaCutoff(getAlphaCutoff()); // exercise field checks, simple types
        
		setAlphaMode(getAlphaMode()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (acousticProperties != null)
		{
			setAcousticProperties(getAcousticProperties());
			((X3DConcreteElement) acousticProperties).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) acousticProperties).getValidationResult());
		}
		if (acousticPropertiesProtoInstance != null)
		{
			setAcousticProperties(getAcousticPropertiesProtoInstance());
			((X3DConcreteElement) acousticPropertiesProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) acousticPropertiesProtoInstance).getValidationResult());
		}
		if ((acousticProperties != null) && (acousticPropertiesProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both acousticProperties and acousticPropertiesProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasAcousticProperties()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode acousticProperties";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (fillProperties != null)
		{
			setFillProperties(getFillProperties());
			((X3DConcreteElement) fillProperties).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) fillProperties).getValidationResult());
		}
		if (fillPropertiesProtoInstance != null)
		{
			setFillProperties(getFillPropertiesProtoInstance());
			((X3DConcreteElement) fillPropertiesProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) fillPropertiesProtoInstance).getValidationResult());
		}
		if ((fillProperties != null) && (fillPropertiesProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both fillProperties and fillPropertiesProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasFillProperties()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode fillProperties";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (lineProperties != null)
		{
			setLineProperties(getLineProperties());
			((X3DConcreteElement) lineProperties).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) lineProperties).getValidationResult());
		}
		if (linePropertiesProtoInstance != null)
		{
			setLineProperties(getLinePropertiesProtoInstance());
			((X3DConcreteElement) linePropertiesProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) linePropertiesProtoInstance).getValidationResult());
		}
		if ((lineProperties != null) && (linePropertiesProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both lineProperties and linePropertiesProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasLineProperties()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode lineProperties";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (material != null)
		{
			setMaterial(getMaterial());
			((X3DConcreteElement) material).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) material).getValidationResult());
		}
		if (materialProtoInstance != null)
		{
			setMaterial(getMaterialProtoInstance());
			((X3DConcreteElement) materialProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) materialProtoInstance).getValidationResult());
		}
		if ((material != null) && (materialProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both material and materialProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMaterial()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode material";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (pointProperties != null)
		{
			setPointProperties(getPointProperties());
			((X3DConcreteElement) pointProperties).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) pointProperties).getValidationResult());
		}
		if (pointPropertiesProtoInstance != null)
		{
			setPointProperties(getPointPropertiesProtoInstance());
			((X3DConcreteElement) pointPropertiesProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) pointPropertiesProtoInstance).getValidationResult());
		}
		if ((pointProperties != null) && (pointPropertiesProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both pointProperties and pointPropertiesProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasPointProperties()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode pointProperties";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		for (org.web3d.x3d.sai.Core.X3DNode element : shaders) // MFNode
		{
			try {
                            ((X3DConcreteElement) element).validate(); // exercise field checks, MFNode element
                            validationResult.append(((X3DConcreteElement) element).getValidationResult());
                        }
                        catch (Exception e)
                        {
                            String exceptionMessage = "[exception] during validation: " + e.getMessage();
                            validationResult.append(exceptionMessage);
                        //  System.err.println(exceptionMessage);
                            e.printStackTrace();
                        }
		}
		setShaders(getShaders()); // also test getter/setter validation, which also includes checks for acceptableNodeTypes (if applicable)

		if (hasUSE() && hasShaders()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained MFNode shaders";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}
		
		if (texture != null)
		{
			setTexture(getTexture());
			((X3DConcreteElement) texture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) texture).getValidationResult());
		}
		if (textureProtoInstance != null)
		{
			setTexture(getTextureProtoInstance());
			((X3DConcreteElement) textureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) textureProtoInstance).getValidationResult());
		}
		if ((texture != null) && (textureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both texture and textureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasTexture()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode texture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (textureTransform != null)
		{
			setTextureTransform(getTextureTransform());
			((X3DConcreteElement) textureTransform).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) textureTransform).getValidationResult());
		}
		if (textureTransformProtoInstance != null)
		{
			setTextureTransform(getTextureTransformProtoInstance());
			((X3DConcreteElement) textureTransformProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) textureTransformProtoInstance).getValidationResult());
		}
		if ((textureTransform != null) && (textureTransformProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both textureTransform and textureTransformProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasTextureTransform()) // test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained SFNode textureTransform";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "Appearance USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'Appearance' node, ensure sufficient support by adding head statement <component name='Shape' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Shape\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
