/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Picking;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Picking.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Picking.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Picking.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Picking.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Rendering.*;
import java.util.Arrays;

/**
 * LinePickSensor uses one or more pickingGeometry line segments to compute intersections with pickTarget shapes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.2 or later) [X3DPickSensorNode] LinePickSensor uses one or more pickingGeometry line segments to compute intersections with pickTarget shapes. As each line intersection generates a known point in space, useful event information is returned including normal, geometry and texCoord values.
Hint: sort order for line picking is based on each pair of coordinates that defining a line segment, with first declared vertex of the segment defined to be the start of the line to which the intersection points are closest.
Hint: when the picking line segment intersects a coplanar polygon, computed intersection point(s) are illustrated in Figure 38.1 &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/picking.html#f-LineIntersection" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/picking.html#f-LineIntersection&lt;/a&gt;
Hint: picking is performed between rendered frames of the event model. An author sets up the picking request in one frame by placing a LinePickSensor in the desired location. At the start of the next frame, any picking intersections are reported by the pick sensor.
Hint: picking notification is performed at the start of the frame for all enabled pick sensors once all other sensors are processed.
Hint: event timing details are explained in X3D Specification 4.4.8.3 Execution model &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#ExecutionModelWarning" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#ExecutionModelWarning&lt;/a&gt;: order of contained nodes is significant, single pickingGeometry node must precede pickTarget node array. Hint: IndexedLineSet or Lineset can be used for pickingGeometry node.  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/picking.html#LinePickSensor" target="blank">X3D Abstract Specification: LinePickSensor</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#LinePickSensor" target="_blank">X3D Tooltips: LinePickSensor</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class LinePickSensor extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Picking.LinePickSensor
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=description, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=description, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String description = new String(); //  X3D field type: SFString

    /* @name=enabled, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=enabled, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean enabled; //  X3D field type: SFBool

    /* @name=intersectionType, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=intersectionType, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String intersectionType = new String(); //  X3D field type: SFString

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=isActive, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isActive, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isActive; //  X3D field type: SFBool

    /* @name=matchCriterion, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=matchCriterion, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String matchCriterion = new String(); //  X3D field type: SFString

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=objectType, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=objectType, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> objectType = new ArrayList<>(); //  X3D field type: MFString

    /* @name=pickedGeometry, @type=MFNode, $javaType=ArrayList< org.web3d.x3d.sai.Core.X3DChildNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList< org.web3d.x3d.sai.Core.X3DChildNode>, $normalizedMemberObjectName=pickedGeometry, $isX3dStatement=false, @acceptableNodeTypes=X3DChildNode */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> pickedGeometry = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: X3DChildNode or ProtoInstance

    /* @name=pickedNormal, @type=MFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=pickedNormal, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] pickedNormal; //  X3D field type: MFVec3f

    /* @name=pickedPoint, @type=MFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=pickedPoint, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] pickedPoint; //  X3D field type: MFVec3f

    /* @name=pickedTextureCoordinate, @type=MFVec3f, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=pickedTextureCoordinate, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] pickedTextureCoordinate; //  X3D field type: MFVec3f

    /* @name=pickingGeometry, @type=SFNode, $javaType= org.web3d.x3d.sai.Rendering.X3DGeometryNode, $javaReferenceType= org.web3d.x3d.sai.Rendering.X3DGeometryNode, $javaPrimitiveType= org.web3d.x3d.sai.Rendering.X3DGeometryNode, $normalizedMemberObjectName=pickingGeometry, $isX3dStatement=false, @acceptableNodeTypes=X3DGeometryNode */ 
    private  org.web3d.x3d.sai.Rendering.X3DGeometryNode pickingGeometry; //  X3D field type: SFNode acceptable node types: X3DGeometryNode or ProtoInstance
	private ProtoInstance pickingGeometryProtoInstance; // allowed alternative for pickingGeometry field

    /* @name=pickTarget, @type=MFNode, $javaType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $javaReferenceType=org.web3d.x3d.sai.Core.X3DNode, $javaPrimitiveType=ArrayList<org.web3d.x3d.sai.Core.X3DNode>, $normalizedMemberObjectName=pickTarget, $isX3dStatement=false, @acceptableNodeTypes=X3DGroupingNode|X3DShapeNode|Inline */ 
    private ArrayList<org.web3d.x3d.sai.Core.X3DNode> pickTarget = new ArrayList<>(); //  X3D field type: MFNode acceptable node types: X3DGroupingNode|X3DShapeNode|Inline or ProtoInstance

    /* @name=sortOrder, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=sortOrder, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String sortOrder = new String(); //  X3D field type: SFString

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean intersectionTypeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> TODO undefined in X3D specification.
	 * SFString field named <i>intersectionType</i> with X3DUOM simpleType <i>intersectionTypeValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"BOUNDS"</i> (Java syntax) or <i>BOUNDS</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_intersectionTypeValues.html">XML Schema: intersectionTypeValues</a>
	 * @see  <a href="https://www.web3d.org/member-only/mantis/view.php" target="_blank">https://www.web3d.org/member-only/mantis/view.php</a>?id=1294  */
	public static final String INTERSECTIONTYPE_BOUNDS = "BOUNDS";

	/** 
	 * <i>Tooltip:</i> TODO undefined in X3D specification.
	 * SFString field named <i>intersectionType</i> with X3DUOM simpleType <i>intersectionTypeValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"GEOMETRY"</i> (Java syntax) or <i>GEOMETRY</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_intersectionTypeValues.html">XML Schema: intersectionTypeValues</a>
	 * @see  <a href="https://www.web3d.org/member-only/mantis/view.php" target="_blank">https://www.web3d.org/member-only/mantis/view.php</a>?id=1294  */
	public static final String INTERSECTIONTYPE_GEOMETRY = "GEOMETRY";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean matchCriterionWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> any match of objectType values is acceptable.
	 * SFString field named <i>matchCriterion</i> with X3DUOM simpleType <i>pickSensorMatchCriterionChoices</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"MATCH_ANY"</i> (Java syntax) or <i>MATCH_ANY</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorMatchCriterionChoices.html">XML Schema: pickSensorMatchCriterionChoices</a> */
	public static final String MATCHCRITERION_MATCH_ANY = "MATCH_ANY";

	/** 
	 * <i>Tooltip:</i> every objectType value in X3DPickSensorNode and X3DPickableObject shall match.
	 * SFString field named <i>matchCriterion</i> with X3DUOM simpleType <i>pickSensorMatchCriterionChoices</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"MATCH_EVERY"</i> (Java syntax) or <i>MATCH_EVERY</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorMatchCriterionChoices.html">XML Schema: pickSensorMatchCriterionChoices</a> */
	public static final String MATCHCRITERION_MATCH_EVERY = "MATCH_EVERY";

	/** 
	 * <i>Tooltip:</i> one and only one objectType value can match.
	 * SFString field named <i>matchCriterion</i> with X3DUOM simpleType <i>pickSensorMatchCriterionChoices</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"MATCH_ONLY_ONE"</i> (Java syntax) or <i>MATCH_ONLY_ONE</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorMatchCriterionChoices.html">XML Schema: pickSensorMatchCriterionChoices</a> */
	public static final String MATCHCRITERION_MATCH_ONLY_ONE = "MATCH_ONLY_ONE";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean objectTypeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> each node is available for picking.
	 * MFString field named <i>objectType</i> with X3DUOM simpleType <i>pickableObjectTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ALL"</i> (Java syntax) or <i>'"ALL"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickableObjectTypeValues.html">XML Schema: pickableObjectTypeValues</a> */
	public static final String OBJECTTYPE_ALL = "ALL";

	/** 
	 * <i>Tooltip:</i> no node is available for picking.
	 * MFString field named <i>objectType</i> with X3DUOM simpleType <i>pickableObjectTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"NONE"</i> (Java syntax) or <i>'"NONE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickableObjectTypeValues.html">XML Schema: pickableObjectTypeValues</a> */
	public static final String OBJECTTYPE_NONE = "NONE";

	/** 
	 * <i>Tooltip:</i> TERRAIN is an example value.
	 * MFString field named <i>objectType</i> with X3DUOM simpleType <i>pickableObjectTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"TERRAIN"</i> (Java syntax) or <i>'"TERRAIN"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickableObjectTypeValues.html">XML Schema: pickableObjectTypeValues</a> */
	public static final String OBJECTTYPE_TERRAIN = "TERRAIN";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean sortOrderWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> any single object that can satisfy picking conditions.
	 * SFString field named <i>sortOrder</i> with X3DUOM simpleType <i>pickSensorSortOrderValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"ANY"</i> (Java syntax) or <i>ANY</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorSortOrderValues.html">XML Schema: pickSensorSortOrderValues</a> */
	public static final String SORTORDER_ANY = "ANY";

	/** 
	 * <i>Tooltip:</i> return closest object by distance that satisfies conditions of this pick sensor.
	 * SFString field named <i>sortOrder</i> with X3DUOM simpleType <i>pickSensorSortOrderValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"CLOSEST"</i> (Java syntax) or <i>CLOSEST</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorSortOrderValues.html">XML Schema: pickSensorSortOrderValues</a> */
	public static final String SORTORDER_CLOSEST = "CLOSEST";

	/** 
	 * <i>Tooltip:</i> every object that satisfies picking conditions for this pick sensor is returned.
	 * SFString field named <i>sortOrder</i> with X3DUOM simpleType <i>pickSensorSortOrderValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"ALL"</i> (Java syntax) or <i>ALL</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorSortOrderValues.html">XML Schema: pickSensorSortOrderValues</a> */
	public static final String SORTORDER_ALL = "ALL";

	/** 
	 * <i>Tooltip:</i> every object that satisfies picking conditions for this pick sensor is returned, in sorted order.
	 * SFString field named <i>sortOrder</i> with X3DUOM simpleType <i>pickSensorSortOrderValues</i> and with X3DUOM baseType <i>xs:NMTOKEN</i> can equal this value <i>"ALL_SORTED"</i> (Java syntax) or <i>ALL_SORTED</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_pickSensorSortOrderValues.html">XML Schema: pickSensorSortOrderValues</a> */
	public static final String SORTORDER_ALL_SORTED = "ALL_SORTED";

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>LinePickSensor</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "LinePickSensor";

	/** Provides name of this element: <i>LinePickSensor</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>LinePickSensor</i> element: <i>Picking</i> */
	public static final String COMPONENT = "Picking";

	/** Defines X3D component for the <i>LinePickSensor</i> element: <i>Picking</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Picking</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFString field named <i>description</i> has default value equal to an empty string. */
	public static final String DESCRIPTION_DEFAULT_VALUE = "";

	/** SFBool field named <i>enabled</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean ENABLED_DEFAULT_VALUE = true;

	/** SFString field named <i>intersectionType</i> has default value <i>"BOUNDS"</i> (Java syntax) or <i>BOUNDS</i> (XML syntax). */
	public static final String INTERSECTIONTYPE_DEFAULT_VALUE = "BOUNDS";

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFString field named <i>matchCriterion</i> has default value <i>"MATCH_ANY"</i> (Java syntax) or <i>MATCH_ANY</i> (XML syntax). */
	public static final String MATCHCRITERION_DEFAULT_VALUE = "MATCH_ANY";

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** MFString field named <i>objectType</i> has default quoted value <i>new String[] {"ALL"}</i> (Java syntax) or quoted value <i>"ALL"</i> (XML syntax). */
	public static final ArrayList<String> OBJECTTYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList("ALL"));

	/** SFNode field named <i>pickingGeometry</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Rendering.X3DGeometryNode PICKINGGEOMETRY_DEFAULT_VALUE = null;

	/** SFString field named <i>sortOrder</i> has default value <i>"CLOSEST"</i> (Java syntax) or <i>CLOSEST</i> (XML syntax). */
	public static final String SORTORDER_DEFAULT_VALUE = "CLOSEST";

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "description":
				result = "SFString";
				break;
			case "enabled":
				result = "SFBool";
				break;
			case "intersectionType":
				result = "SFString";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "isActive":
				result = "SFBool";
				break;
			case "matchCriterion":
				result = "SFString";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "objectType":
				result = "MFString";
				break;
			case "pickedGeometry":
				result = "MFNode";
				break;
			case "pickedNormal":
				result = "MFVec3f";
				break;
			case "pickedPoint":
				result = "MFVec3f";
				break;
			case "pickedTextureCoordinate":
				result = "MFVec3f";
				break;
			case "pickingGeometry":
				result = "SFNode";
				break;
			case "pickTarget":
				result = "MFNode";
				break;
			case "sortOrder":
				result = "SFString";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "description":
				result = "inputOutput";
				break;
			case "enabled":
				result = "inputOutput";
				break;
			case "intersectionType":
				result = "initializeOnly";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "isActive":
				result = "outputOnly";
				break;
			case "matchCriterion":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "objectType":
				result = "inputOutput";
				break;
			case "pickedGeometry":
				result = "outputOnly";
				break;
			case "pickedNormal":
				result = "outputOnly";
				break;
			case "pickedPoint":
				result = "outputOnly";
				break;
			case "pickedTextureCoordinate":
				result = "outputOnly";
				break;
			case "pickingGeometry":
				result = "inputOutput";
				break;
			case "pickTarget":
				result = "inputOutput";
				break;
			case "sortOrder":
				result = "initializeOnly";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "children"; // type xs:NMTOKEN
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFString field named <i>description</i>. */
	public static final String fromField_DESCRIPTION = "description";

	/** toField ROUTE name for SFString field named <i>description</i>. */
	public static final String toField_DESCRIPTION = "description";

	/** fromField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String fromField_ENABLED = "enabled";

	/** toField ROUTE name for SFBool field named <i>enabled</i>. */
	public static final String toField_ENABLED = "enabled";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFBool field named <i>isActive</i>. */
	public static final String fromField_ISACTIVE = "isActive";

	/** fromField ROUTE name for SFString field named <i>matchCriterion</i>. */
	public static final String fromField_MATCHCRITERION = "matchCriterion";

	/** toField ROUTE name for SFString field named <i>matchCriterion</i>. */
	public static final String toField_MATCHCRITERION = "matchCriterion";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for MFString field named <i>objectType</i>. */
	public static final String fromField_OBJECTTYPE = "objectType";

	/** toField ROUTE name for MFString field named <i>objectType</i>. */
	public static final String toField_OBJECTTYPE = "objectType";

	/** fromField ROUTE name for MFNode field named <i>pickedGeometry</i>. */
	public static final String fromField_PICKEDGEOMETRY = "pickedGeometry";

	/** fromField ROUTE name for MFVec3f field named <i>pickedNormal</i>. */
	public static final String fromField_PICKEDNORMAL = "pickedNormal";

	/** fromField ROUTE name for MFVec3f field named <i>pickedPoint</i>. */
	public static final String fromField_PICKEDPOINT = "pickedPoint";

	/** fromField ROUTE name for MFVec3f field named <i>pickedTextureCoordinate</i>. */
	public static final String fromField_PICKEDTEXTURECOORDINATE = "pickedTextureCoordinate";

	/** fromField ROUTE name for SFNode field named <i>pickingGeometry</i>. */
	public static final String fromField_PICKINGGEOMETRY = "pickingGeometry";

	/** toField ROUTE name for SFNode field named <i>pickingGeometry</i>. */
	public static final String toField_PICKINGGEOMETRY = "pickingGeometry";

	/** fromField ROUTE name for MFNode field named <i>pickTarget</i>. */
	public static final String fromField_PICKTARGET = "pickTarget";

	/** toField ROUTE name for MFNode field named <i>pickTarget</i>. */
	public static final String toField_PICKTARGET = "pickTarget";

	/** Constructor for LinePickSensor to initialize member variables with default values. */
	public LinePickSensor()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "children" }; // type xs:NMTOKEN

		description = DESCRIPTION_DEFAULT_VALUE;
		enabled = ENABLED_DEFAULT_VALUE;
		intersectionType = INTERSECTIONTYPE_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		matchCriterion = MATCHCRITERION_DEFAULT_VALUE;
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		objectType = new ArrayList<>(OBJECTTYPE_DEFAULT_VALUE);
		pickingGeometry = null;              // clear out any prior node
		pickingGeometryProtoInstance = null; // clear out any prior node
		pickTarget = new ArrayList<>();
		sortOrder = SORTORDER_DEFAULT_VALUE;

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription()
	{
		return description;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setDescription(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		description = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString description field, similar to {@link #setDescription(String)}.
	 * @param newValue is new value for the description field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setDescription(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDescription(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled()
	{
		return enabled;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setEnabled(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		enabled = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool enabled field, similar to {@link #setEnabled(boolean)}.
	 * @param newValue is new value for the enabled field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setEnabled(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEnabled(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["BOUNDS" | "GEOMETRY" | 'etc.'] from initializeOnly SFString field named <i>intersectionType</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  intersectionType specifies precision of the collision computation. Hint: intersectionType constants may be extended by the browser to provide additional options. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #INTERSECTIONTYPE_BOUNDS BOUNDS}, {@link #INTERSECTIONTYPE_GEOMETRY GEOMETRY}.
	 * @return value of intersectionType field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=IntersectionType, $memberObjectName=intersectionType, $memberObjectName=intersectionType)

	public String getIntersectionType()
	{
		return intersectionType;
	}

	/**
	 * Accessor method to assign String enumeration value ("BOUNDS" | "GEOMETRY") to initializeOnly SFString field named <i>intersectionType</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #INTERSECTIONTYPE_BOUNDS BOUNDS}, {@link #INTERSECTIONTYPE_GEOMETRY GEOMETRY}).
	 * <br><br>
	 * <i>Tooltip:</i>  intersectionType specifies precision of the collision computation. Hint: intersectionType constants may be extended by the browser to provide additional options. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @param newValue is new value for the intersectionType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setIntersectionType(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(INTERSECTIONTYPE_BOUNDS) ||
			newValue.toString().replace("\"","").equals(INTERSECTIONTYPE_GEOMETRY)))
		{
			String warningMessage = "[info] LinePickSensor intersectionType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!intersectionTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are BOUNDS, GEOMETRY";
			    intersectionTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		intersectionType = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString intersectionType field, similar to {@link #setIntersectionType(String)}.
	 * @param newValue is new value for the intersectionType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setIntersectionType(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setIntersectionType(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public LinePickSensor clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isActive indicates when the intersecting object is picked by the picking geometry. Output event isActive=true gets sent once a picked item is found. Output event isActive=false gets sent once no picked item is found. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isActive field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive()
	{
		return isActive;
	}
	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["MATCH_ANY" | "MATCH_EVERY" | "MATCH_ONLY_ONE"] from inputOutput SFString field named <i>matchCriterion</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  defines whether the intersection test (i.e. pick) by this X3DPickSensorNode must match one or more objectType. Specifically MATCH_ANY means any match of objectType values is acceptable, MATCH_EVERY means that every objectType value in this node shall match an objectType value in the X3DPickableObject, and MATCH_ONLY_ONE means that one and only one objectType value can match.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #MATCHCRITERION_MATCH_ANY MATCH_ANY}, {@link #MATCHCRITERION_MATCH_EVERY MATCH_EVERY}, {@link #MATCHCRITERION_MATCH_ONLY_ONE MATCH_ONLY_ONE}.
	 * @return value of matchCriterion field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=MatchCriterion, $memberObjectName=matchCriterion, $memberObjectName=matchCriterion)

	public String getMatchCriterion()
	{
		return matchCriterion;
	}

	/**
	 * Accessor method to assign String enumeration value ("MATCH_ANY" | "MATCH_EVERY" | "MATCH_ONLY_ONE") to inputOutput SFString field named <i>matchCriterion</i>.
	 * <br><br>
	 * <i>Warning:</i> authors can only choose from a strict list of enumeration values ({@link #MATCHCRITERION_MATCH_ANY MATCH_ANY}, {@link #MATCHCRITERION_MATCH_EVERY MATCH_EVERY}, {@link #MATCHCRITERION_MATCH_ONLY_ONE MATCH_ONLY_ONE}).
	 * <br><br>
	 * <i>Tooltip:</i>  defines whether the intersection test (i.e. pick) by this X3DPickSensorNode must match one or more objectType. Specifically MATCH_ANY means any match of objectType values is acceptable, MATCH_EVERY means that every objectType value in this node shall match an objectType value in the X3DPickableObject, and MATCH_ONLY_ONE means that one and only one objectType value can match.  * <br>

	 * @param newValue is new value for the matchCriterion field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setMatchCriterion(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(MATCHCRITERION_MATCH_ANY) ||
			newValue.toString().replace("\"","").equals(MATCHCRITERION_MATCH_EVERY) ||
			newValue.toString().replace("\"","").equals(MATCHCRITERION_MATCH_ONLY_ONE)))
		{
			String warningMessage = "[warning] LinePickSensor matchCriterion newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
			if (!matchCriterionWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are MATCH_ANY, MATCH_EVERY, MATCH_ONLY_ONE";
			    matchCriterionWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);

            if (!newValue.isEmpty()) // @additionalEnumerationValuesAllowed='false'
            {
                throw new org.web3d.x3d.sai.InvalidFieldValueException(warningMessage);
            }
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		matchCriterion = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString matchCriterion field, similar to {@link #setMatchCriterion(String)}.
	 * @param newValue is new value for the matchCriterion field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setMatchCriterion(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setMatchCriterion(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public LinePickSensor clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public LinePickSensor setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide array of String enumeration results with quoted value(s) ["ALL","NONE","TERRAIN",...] from inputOutput MFString field named <i>objectType</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The objectType field specifies a set of labels used in the picking process. Each string specified is treated as an independent label that needs to be matched against the same type in one of the pick sensor instances. Example: labeling a PickableGroup with the objectType value "WATER" and then attempting to intersect a pick sensor with objectType value "GROUND" fails since the objectType values do not match. Example: the special value "ALL" means that each node is available for picking regardless of the type specified by the pick sensor. Example: the special value "NONE" effectively disables all picking for this node and is the equivalent of setting the pickable field of the corresponding PickableGroup to false. Hint: authors may define any value for objectType. Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks".  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #OBJECTTYPE_ALL ALL}, {@link #OBJECTTYPE_NONE NONE}, {@link #OBJECTTYPE_TERRAIN TERRAIN}.
	 * @return value of objectType field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=ObjectType, $memberObjectName=objectType, $memberObjectName=objectType)

	public String[] getObjectType()
	{
		final String[] valuesArray = new String[objectType.size()];
		int i = 0;
		for (String arrayElement : objectType) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString objectType field, similar to {@link #getObjectType()}.
	 * @return value of objectType field
	 */
	public ArrayList<String> getObjectTypeList()
	{
		return objectType;
	}
	/**
	 * Utility method to get String value of MFString objectType field, similar to {@link #getObjectType()}.
	 * @return value of objectType field
	 */
	public String getObjectTypeString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : objectType) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""ALL"" | ""NONE"" | ""TERRAIN"") to inputOutput MFString field named <i>objectType</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #OBJECTTYPE_ALL ALL}, {@link #OBJECTTYPE_NONE NONE}, {@link #OBJECTTYPE_TERRAIN TERRAIN}).
	 * <br><br>
	 * <i>Tooltip:</i>  The objectType field specifies a set of labels used in the picking process. Each string specified is treated as an independent label that needs to be matched against the same type in one of the pick sensor instances. Example: labeling a PickableGroup with the objectType value "WATER" and then attempting to intersect a pick sensor with objectType value "GROUND" fails since the objectType values do not match. Example: the special value "ALL" means that each node is available for picking regardless of the type specified by the pick sensor. Example: the special value "NONE" effectively disables all picking for this node and is the equivalent of setting the pickable field of the corresponding PickableGroup to false. Hint: authors may define any value for objectType. Hint: MFString arrays can have multiple values, so "separate each individual string" "by using quote marks".  * <br>

	 * @param newValue is new value for the objectType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setObjectType(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearObjectType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(OBJECTTYPE_ALL) ||
			newValue[i].toString().replace("\"","").equals(OBJECTTYPE_NONE) ||
			newValue[i].toString().replace("\"","").equals(OBJECTTYPE_TERRAIN)))
		{
			String warningMessage = "[info] LinePickSensor objectType newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!objectTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
			    objectTypeWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearObjectType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearObjectType(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			objectType.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString objectType field, similar to {@link #setObjectType(String[])}.
	 * @param newValue is new value for the objectType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setObjectType(MFString newValue)
	{
		if (newValue == null)		{
			clearObjectType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setObjectType(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString objectType field, similar to {@link #setObjectType(String[])}.
	 * @param newValue is new value for the objectType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setObjectType(SFString newValue)
	{
		if (newValue == null)		{
			clearObjectType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setObjectType(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearObjectType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_ALL) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_NONE) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_TERRAIN)))
		{
			String warningMessage = "[info] LinePickSensor objectType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!objectTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
			    objectTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setObjectType(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString objectType field, similar to {@link #setObjectType(String[])}.
	 * @param newValue is new value for the objectType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setObjectType(String newValue)
	{
		if (newValue == null)		{
			clearObjectType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setObjectType(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearObjectType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_ALL) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_NONE) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_TERRAIN)))
		{
			String warningMessage = "[info] LinePickSensor objectType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!objectTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
			    objectTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setObjectType(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString objectType field, similar to {@link #setObjectType(String[])}.
	 * @param newValue is new value for the objectType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setObjectType(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearObjectType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearObjectType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_ALL) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_NONE) ||
			newValue.toString().replace("\"","").equals(OBJECTTYPE_TERRAIN)))
		{
			String warningMessage = "[info] LinePickSensor objectType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!objectTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
			    objectTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearObjectType(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setObjectType(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of objectType field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public LinePickSensor clearObjectType()
	{
		objectType.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString objectType field.
	 * @param newValue is new value to add to the objectType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor addObjectType(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !objectType.contains(newValue))
            objectType.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString objectType field.
	 * @param newValue is new value to add to the objectType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor addObjectType(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !objectType.contains(newValue.getValue()))
            objectType.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide array of  org.web3d.x3d.sai.Core.X3DChildNode results (using an array consisting of properly typed nodes or ProtoInstances) from outputOnly MFNode field <i>pickedGeometry</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Output event containing the node or nodes that have been found to intersect with the picking geometry from the last time this node performed a picking operation, given in the local coordinate system. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DChildNode.
	 * @see org.web3d.x3d.sai.Core.X3DChildNode
	 * @return value of pickedGeometry field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickedGeometry, $memberObjectName=pickedGeometry, $memberObjectName=pickedGeometry)

	public org.web3d.x3d.sai.Core.X3DNode[] getPickedGeometry()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[pickedGeometry.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : pickedGeometry) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode pickedGeometry field, similar to {@link #getPickedGeometry()}.
	 * @return value of pickedGeometry field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getPickedGeometryList()
	{
		return pickedGeometry;
	}
	/**
	 * Provide array of 3-tuple float results from outputOnly MFVec3f field named <i>pickedNormal</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Output event containing surface normal vectors computed by the picking intersection computations. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of pickedNormal field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickedNormal, $memberObjectName=pickedNormal, $memberObjectName=pickedNormal)

	public float[] getPickedNormal()
	{
		return pickedNormal;
	}
	/**
	 * Provide array of 3-tuple float results from outputOnly MFVec3f field named <i>pickedPoint</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Output event containing 3D points on surface of underlying pickingGeometry computed by the picking intersection computations, given in the local coordinate system. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of pickedPoint field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickedPoint, $memberObjectName=pickedPoint, $memberObjectName=pickedPoint)

	public float[] getPickedPoint()
	{
		return pickedPoint;
	}
	/**
	 * Provide array of 3-tuple float results from outputOnly MFVec3f field named <i>pickedTextureCoordinate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Output event containing 3D texture coordinates of surfaces computed by the picking intersection computations. Picked texture coordinates are in three dimensions. If the target texture coordinate has two dimensions, the third coordinate (z component of an SFVec3f) shall be zero. Warning: if the target object has multiple textures defined, only texture coordinates for the first texture are returned and all other textures are ignored. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of pickedTextureCoordinate field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickedTextureCoordinate, $memberObjectName=pickedTextureCoordinate, $memberObjectName=pickedTextureCoordinate)

	public float[] getPickedTextureCoordinate()
	{
		return pickedTextureCoordinate;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Rendering.X3DGeometryNode instance (using a properly typed node) from inputOutput SFNode field <i>pickingGeometry</i>.
	 * @see #getPickingGeometryProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [IndexedLineSet|LineSet] pickingGeometry specifies the exact geometry coordinates that are used to perform the intersection testing of the picking operation.  * <br>

	 * @return value of pickingGeometry field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickingGeometry, $memberObjectName=pickingGeometry, $memberObjectName=pickingGeometry)

	public  org.web3d.x3d.sai.Rendering.X3DGeometryNode getPickingGeometry()
	{
		return pickingGeometry;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Rendering.X3DGeometryNode instance (using a properly typed node) to inputOutput SFNode field <i>pickingGeometry</i>.
	 * @see #setPickingGeometry(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [IndexedLineSet|LineSet] pickingGeometry specifies the exact geometry coordinates that are used to perform the intersection testing of the picking operation.  * <br>

	 * @param newValue is new value for the pickingGeometry field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setPickingGeometry( org.web3d.x3d.sai.Rendering.X3DGeometryNode newValue)
	{
		// set-newValue-validity-checks #0.a
		pickingGeometry = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) pickingGeometry).setParent(this); // parentTest15.1
		}
		if (pickingGeometryProtoInstance != null)
		{
			pickingGeometryProtoInstance.setParent(null); // housekeeping, clear prior object
			pickingGeometryProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of pickingGeometry field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public LinePickSensor clearPickingGeometry()
	{
		((X3DConcreteElement) pickingGeometry).clearParent(); // remove references to facilitate Java memory management
		pickingGeometry = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>pickingGeometry</i>.
	 * @see #setPickingGeometry( org.web3d.x3d.sai.Rendering.X3DGeometryNode)
	 * @param newValue is new value for the pickingGeometry field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setPickingGeometry(ProtoInstance newValue)
	{
		if (pickingGeometryProtoInstance != null)
		{
			((X3DConcreteElement) pickingGeometryProtoInstance).setParent(null); // parentTest15.5
	    }
		pickingGeometryProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) pickingGeometryProtoInstance).setParent(this); // parentTest15.6
            pickingGeometryProtoInstance.setContainerField("pickingGeometry");
	    }
		if (pickingGeometry != null)
		{
			((X3DConcreteElement) pickingGeometry).setParent(null); // housekeeping, clear prior object
			pickingGeometry = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getPickingGeometryProtoInstance()
		{
			return pickingGeometryProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>pickingGeometry</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getPickingGeometry()
	 * @see #getPickingGeometryProtoInstance()
	 */
	public boolean hasPickingGeometry()
	{
		return (pickingGeometry != null) || (pickingGeometryProtoInstance != null);
	}
	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) with acceptable node types limited to X3DGroupingNode|X3DShapeNode|Inline, from inputOutput MFNode field <i>pickTarget</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DGroupingNode|X3DShapeNode|Inline] pickTarget specifies the list of nodes against which picking operations are performed. All nodes declared in this field and their descendents are evaluated for intersections.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DGroupingNode|X3DShapeNode|Inline.
	 * @see org.web3d.x3d.sai.Grouping.X3DGroupingNode
	 * @see org.web3d.x3d.sai.Shape.X3DShapeNode
	 * @see org.web3d.x3d.jsail.Networking.Inline
	 * @return value of pickTarget field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=PickTarget, $memberObjectName=pickTarget, $memberObjectName=pickTarget)

	public org.web3d.x3d.sai.Core.X3DNode[] getPickTarget()
	{
		final org.web3d.x3d.sai.Core.X3DNode[] valuesArray = new org.web3d.x3d.sai.Core.X3DNode[pickTarget.size()];
		int i = 0;
		for (org.web3d.x3d.sai.Core.X3DNode arrayElement : pickTarget) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFNode pickTarget field, similar to {@link #getPickTarget()}.
	 * @return value of pickTarget field
	 */
	public ArrayList<org.web3d.x3d.sai.Core.X3DNode> getPickTargetList()
	{
		return pickTarget;
	}

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>pickTarget</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DGroupingNode|X3DShapeNode|Inline] pickTarget specifies the list of nodes against which picking operations are performed. All nodes declared in this field and their descendents are evaluated for intersections.  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DGroupingNode|X3DShapeNode|Inline.
	 * @param newValue is new value for the pickTarget field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setPickTarget(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)			// reset value field to empty array
		{
			clearPickTarget(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(((X3DConcreteNode)newValue[i]) instanceof  org.web3d.x3d.sai.Grouping.X3DGroupingNode) || 
				(((X3DConcreteNode)newValue[i]) instanceof  org.web3d.x3d.sai.Shape.X3DShapeNode) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Networking.Inline);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes X3DGroupingNode|X3DShapeNode|Inline; newValue["+i+"]=" + newValue[i]);
			}
		}
		clearPickTarget(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				pickTarget.add((org.web3d.x3d.sai.Core.X3DNode)newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest12
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
		}
		return this;
	}

	/**
	 * Assign ArrayList value of MFNode pickTarget field, similar to {@link #setPickTarget(org.web3d.x3d.sai.Core.X3DNode[])}.
	 * @param newValue is new value for the pickTarget field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setPickTarget(ArrayList<org.web3d.x3d.sai.Core.X3DNode> newValue)
	{
		if (newValue == null)			// reset value field to empty array
		{
			clearPickTarget(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4

		// newValueArrayListAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #3
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			boolean isNodeTypeAllowed = 
				(element instanceof  org.web3d.x3d.sai.Grouping.X3DGroupingNode) || 
				(element instanceof  org.web3d.x3d.sai.Shape.X3DShapeNode) || 
				(element instanceof org.web3d.x3d.jsail.Networking.Inline);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] element is not instanceof " +
					"acceptableNodeTypes X3DGroupingNode|X3DShapeNode|Inline; element=" + element);
			}
		}
        if (newValue.isEmpty())
            clearPickTarget(); // reset
        else
        {
            org.web3d.x3d.sai.Core.X3DNode[] newArray = new org.web3d.x3d.sai.Core.X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setPickTarget(newArray);
        }
		for (org.web3d.x3d.sai.Core.X3DNode element : newValue)
		{
			pickTarget.add(element);
			((X3DConcreteElement) element).setParent(this); // parentTest13
		}
		return this;
	}
	/**
	 * Add single child node to existing array of pickTarget nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DGroupingNode|X3DShapeNode|Inline and ProtoInstance.
	 * @param newValue is new value to be appended the pickTarget field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public LinePickSensor addPickTarget(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.sai.Grouping.X3DGroupingNode) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.sai.Shape.X3DShapeNode) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Networking.Inline);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes X3DGroupingNode|X3DShapeNode|Inline; newValue=" + newValue);
		}
		pickTarget.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest2
		return this;
	}
	/**
	 * Add single ProtoInstance (with appropriate node type and containerField value) to MFNode array for pickTarget field.
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to ShaderPart and ProtoInstance.
	 * @param newValue is new value to be appended the parts field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).	 */
	public LinePickSensor addPickTarget(ProtoInstance newValue)
	{
		if (newValue == null) return this; // newValueNullReturnThis
		pickTarget.add(newValue);
		((X3DConcreteElement) newValue).setParent(this); // parentTest16
		return this;
	}
	/**
	 * Add array of child pickTarget nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DGroupingNode|X3DShapeNode|Inline.
	 * @param newValue is new value array to be appended the pickTarget field.
	 */
	public void addPickTarget(org.web3d.x3d.sai.Core.X3DNode[] newValue)
	{
		if (newValue == null) return; // newValueNullReturnSelf

		// newValueArrayAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #2
		for (int i = 0; i < newValue.length; i++)
		{
			boolean isNodeTypeAllowed = 
				(((X3DConcreteNode)newValue[i]) instanceof  org.web3d.x3d.sai.Grouping.X3DGroupingNode) || 
				(((X3DConcreteNode)newValue[i]) instanceof  org.web3d.x3d.sai.Shape.X3DShapeNode) || 
				(((X3DConcreteNode)newValue[i]) instanceof org.web3d.x3d.jsail.Networking.Inline);
			if  (!isNodeTypeAllowed)
			{
				throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode[] newValue["+i+"] is not instanceof " +
					"acceptableNodeTypes X3DGroupingNode|X3DShapeNode|Inline; newValue["+i+"]=" + newValue[i]);
			}
		}
		for (int i = 0; i < newValue.length; i++)
		{
			if  ((newValue[i] instanceof org.web3d.x3d.sai.Core.X3DNode) || (newValue[i] instanceof ProtoInstance))
			{
				pickTarget.add(newValue[i]);
				((X3DConcreteElement) newValue[i]).setParent(this); // parentTest6
				if (newValue[i] instanceof ProtoInstance)
					((ProtoInstance) newValue[i]).setContainerField("pickTarget");
			}
			else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue["+i+"] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
		}
	}

	/**
	 * Set single child pickTarget node, replacing prior array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are restricted to X3DGroupingNode|X3DShapeNode|Inline.
	 * @param newValue is new node for the pickTarget field (restricted to X3DGroupingNode|X3DShapeNode|Inline)
	 */
	/* @Override */
	public void setPickTarget(org.web3d.x3d.sai.Core.X3DNode newValue)
	{
		if (newValue == null)
		{
			clearPickTarget(); // reset newValueNullClearsFieldReturnVoid
			return;
		}

		// newValueInstanceAcceptableNodeTypesTest checks are needed for methods that override/subset X3DNode interfaces #1
		boolean isNodeTypeAllowed =
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.sai.Grouping.X3DGroupingNode) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.sai.Shape.X3DShapeNode) || 
				(((X3DConcreteNode)newValue) instanceof org.web3d.x3d.jsail.Networking.Inline);
		if  (!isNodeTypeAllowed)
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("X3DNode newValue is not instanceof " +
				"acceptableNodeTypes X3DGroupingNode|X3DShapeNode|Inline; newValue=" + newValue);
		}
		if  (newValue instanceof org.web3d.x3d.sai.Core.X3DNode)
		{
			for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget)
				((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
			clearPickTarget(); // reset
			((X3DConcreteElement) newValue).setParent(this); // parentTest8
			pickTarget.add(newValue);
		}
		else throw new org.web3d.x3d.sai.InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
}
	/**
	 * Utility method to clear MFNode value of pickTarget field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public LinePickSensor clearPickTarget()
	{
		for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget)
			((X3DConcreteElement) element).clearParent(); // remove references to facilitate Java memory management
		pickTarget.clear(); // reset MF field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput MFNode field <i>pickTarget</i>.
	 * @return whether a properly typed node or ProtoInstance array or CommentsBlock is available.
	 * @see #getPickTarget()
	 */
	public boolean hasPickTarget()
	{
		return (!pickTarget.isEmpty());
	}
	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["ANY" | "CLOSEST" | "ALL" | "ALL_SORTED" | 'etc.'] from initializeOnly SFString field named <i>sortOrder</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The sortOrder field determines the order provided for picked output events. Example: ANY means any single object that can satisfy picking conditions for this pick sensor. Consistency of results is not guaranteed. Example: ALL means that every object that satisfies the picking conditions for this pick sensor shall be returned. Example: ALL_SORTED means that every object that satisfies the picking conditions for this pick sensor shall be returned with the order of the output fields provided in a distance-sorted order from closest to farthest away. The exact algorithm for sorting is defined by the individual node definitions. Example: CLOSEST means that the closest object by distance that satisfies the conditions of this pick sensor. *The exact algorithm for distance determination shall be defined by individual node definitions*. Hint: browser implementations may define additional values and algorithms beyond these four required values. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #SORTORDER_ANY ANY}, {@link #SORTORDER_CLOSEST CLOSEST}, {@link #SORTORDER_ALL ALL}, {@link #SORTORDER_ALL_SORTED ALL_SORTED}.
	 * @return value of sortOrder field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=SortOrder, $memberObjectName=sortOrder, $memberObjectName=sortOrder)

	public String getSortOrder()
	{
		return sortOrder;
	}

	/**
	 * Accessor method to assign String enumeration value ("ANY" | "CLOSEST" | "ALL" | "ALL_SORTED") to initializeOnly SFString field named <i>sortOrder</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #SORTORDER_ANY ANY}, {@link #SORTORDER_CLOSEST CLOSEST}, {@link #SORTORDER_ALL ALL}, {@link #SORTORDER_ALL_SORTED ALL_SORTED}).
	 * <br><br>
	 * <i>Tooltip:</i>  The sortOrder field determines the order provided for picked output events. Example: ANY means any single object that can satisfy picking conditions for this pick sensor. Consistency of results is not guaranteed. Example: ALL means that every object that satisfies the picking conditions for this pick sensor shall be returned. Example: ALL_SORTED means that every object that satisfies the picking conditions for this pick sensor shall be returned with the order of the output fields provided in a distance-sorted order from closest to farthest away. The exact algorithm for sorting is defined by the individual node definitions. Example: CLOSEST means that the closest object by distance that satisfies the conditions of this pick sensor. *The exact algorithm for distance determination shall be defined by individual node definitions*. Hint: browser implementations may define additional values and algorithms beyond these four required values. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values.  * <br>

	 * @param newValue is new value for the sortOrder field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public LinePickSensor setSortOrder(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
		{
                    newValue = new String(); // null string check
		}
		newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue); // handle potential enumeration value
                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(SORTORDER_ANY) ||
			newValue.toString().replace("\"","").equals(SORTORDER_CLOSEST) ||
			newValue.toString().replace("\"","").equals(SORTORDER_ALL) ||
			newValue.toString().replace("\"","").equals(SORTORDER_ALL_SORTED)))
		{
			String warningMessage = "[info] LinePickSensor sortOrder newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!sortOrderWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are ANY, CLOSEST, ALL, ALL_SORTED";
			    sortOrderWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		sortOrder = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString sortOrder field, similar to {@link #setSortOrder(String)}.
	 * @param newValue is new value for the sortOrder field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setSortOrder(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSortOrder(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LinePickSensor setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to LinePickSensor DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("LinePickSensor DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LinePickSensor setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to LinePickSensor USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("LinePickSensor USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LinePickSensor setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LinePickSensor setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DPickSensorNode, $additionalInheritanceBaseType=, $thisClassName=LinePickSensor, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final LinePickSensor setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public LinePickSensor setUSE(LinePickSensor DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on LinePickSensor" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public LinePickSensor (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public LinePickSensor addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public LinePickSensor addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link LinePickSensor} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public LinePickSensor addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (pickingGeometry != null) || (pickingGeometryProtoInstance != null) || (!pickTarget.isEmpty()) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<LinePickSensor"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" description='").append(new SFString(getDescription()).toStringX3D()).append("'");
			}
			if (((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" enabled='").append(SFBool.toString(getEnabled())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if ((!getIntersectionType().equals(INTERSECTIONTYPE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" intersectionType='").append(new SFString(getIntersectionType()).toStringX3D()).append("'");
			}
			if ((!getMatchCriterion().equals(MATCHCRITERION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" matchCriterion='").append(new SFString(getMatchCriterion()).toStringX3D()).append("'");
			}
			if (((getObjectType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" objectType='").append(new MFString(getObjectType()).toStringX3D()).append("'");
			}
			if ((!getSortOrder().equals(SORTORDER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" sortOrder='").append(new SFString(getSortOrder()).toStringX3D()).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget)
			{
				stringX3D.append(((X3DConcreteElement)element).toStringX3D(indentLevel + indentIncrement));
			}
			if      (pickingGeometry != null)
			{
				stringX3D.append(((X3DConcreteElement)pickingGeometry).toStringX3D(indentLevel + indentIncrement));
			}
			else if (pickingGeometryProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)pickingGeometryProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</LinePickSensor>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=LinePickSensor, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (pickingGeometry != null) || (pickingGeometryProtoInstance != null) || (!pickTarget.isEmpty()) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("LinePickSensor").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("description"))
						{
							stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("description ").append("\"").append(SFString.toString(getDescription())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("enabled"))
						{
							stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getEnabled() != ENABLED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("enabled ").append(SFBool.toString(getEnabled())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("intersectionType"))
						{
							stringClassicVRML.append(indentCharacter).append("intersectionType").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getIntersectionType().equals(INTERSECTIONTYPE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("intersectionType ").append("\"").append(SFString.toString(getIntersectionType())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("matchCriterion"))
						{
							stringClassicVRML.append(indentCharacter).append("matchCriterion").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getMatchCriterion().equals(MATCHCRITERION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("matchCriterion ").append("\"").append(SFString.toString(getMatchCriterion())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("objectType"))
						{
							stringClassicVRML.append(indentCharacter).append("objectType").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getObjectType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("objectType ").append("[ ").append(MFString.toString(getObjectType())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("sortOrder"))
						{
							stringClassicVRML.append(indentCharacter).append("sortOrder").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getSortOrder().equals(SORTORDER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("sortOrder ").append("\"").append(SFString.toString(getSortOrder())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (pickTarget.size() > 0)
			{
				stringClassicVRML.append(indentCharacter).append(indentCharacter).append("pickTarget").append(" [").append("\n")
					.append(indent).append(indentCharacter).append(indentCharacter); // containerField for MFNode array
			for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget)
			{
				stringClassicVRML.append(((X3DConcreteElement)element).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
			}
				stringClassicVRML.append(indent).append(indentCharacter).append(indentCharacter).append("]").append("\n")
					.append(indent); // end MFNode array
			}

			if (pickingGeometry != null)
			{
				stringClassicVRML.append(indentCharacter).append("pickingGeometry").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) pickingGeometry).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (pickingGeometryProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("pickingGeometry").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) pickingGeometryProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (pickingGeometry != null)
		{
			referenceElement = ((X3DConcreteElement) pickingGeometry).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (pickingGeometryProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) pickingGeometryProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget) // MFNode
		{
			if (element instanceof X3DConcreteElement)
			{
				referenceElement = ((X3DConcreteElement) element).findElementByNameValue(nameValue, elementName);
				if (referenceElement != null)
					return referenceElement;
			}
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (pickingGeometry != null)
		{
			referenceNode = ((X3DConcreteElement) pickingGeometry).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (pickingGeometryProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) pickingGeometryProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget) // MFNode
		{
			if (element instanceof org.web3d.x3d.jsail.X3DConcreteNode)
			{
				referenceNode = ((X3DConcreteElement) element).findNodeByDEF(DEFvalue);
				if (referenceNode != null)
					return referenceNode;
			}
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setDescription(getDescription()); // exercise field checks, simple types
        
		setEnabled(getEnabled()); // exercise field checks, simple types
        
		setIntersectionType(getIntersectionType()); // exercise field checks, simple types
        
		setMatchCriterion(getMatchCriterion()); // exercise field checks, simple types
        
		setObjectType(getObjectType()); // exercise field checks, simple types
        
		setSortOrder(getSortOrder()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (pickingGeometry != null)
		{
			setPickingGeometry(getPickingGeometry());
			((X3DConcreteElement) pickingGeometry).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) pickingGeometry).getValidationResult());
		}
		if (pickingGeometryProtoInstance != null)
		{
			setPickingGeometry(getPickingGeometryProtoInstance());
			((X3DConcreteElement) pickingGeometryProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) pickingGeometryProtoInstance).getValidationResult());
		}
		if ((pickingGeometry != null) && (pickingGeometryProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both pickingGeometry and pickingGeometryProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasPickingGeometry()) // test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained SFNode pickingGeometry";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		for (org.web3d.x3d.sai.Core.X3DNode element : pickTarget) // MFNode
		{
			try {
                            ((X3DConcreteElement) element).validate(); // exercise field checks, MFNode element
                            validationResult.append(((X3DConcreteElement) element).getValidationResult());
                        }
                        catch (Exception e)
                        {
                            String exceptionMessage = "[exception] during validation: " + e.getMessage();
                            validationResult.append(exceptionMessage);
                        //  System.err.println(exceptionMessage);
                            e.printStackTrace();
                        }
		}
		setPickTarget(getPickTarget()); // also test getter/setter validation, which also includes checks for acceptableNodeTypes (if applicable)

		if (hasUSE() && hasPickTarget()) // test USE restrictions
		{
			String errorNotice = "LinePickSensor USE='" + getUSE() + "' is not allowed to have contained MFNode pickTarget";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}
		
		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'LinePickSensor' node, ensure sufficient support by adding head statement <component name='Picking' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Picking\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
