/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Sound;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * Delay causes a time delay between the arrival of input data and subsequent propagation to the output.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 4.0 draft) [X3DSoundProcessingNode] Delay causes a time delay between the arrival of input data and subsequent propagation to the output.
Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#DelayNode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#DelayNode&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#Delay" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/sound.html#Delay" target="blank">X3D Abstract Specification: Delay</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Delay" target="_blank">X3D Tooltips: Delay</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface Delay extends  org.web3d.x3d.sai.Sound.X3DSoundProcessingNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide int value from outputOnly SFInt32 field named <i>channelCount</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) channelCount reports number of channels provided by input nodes. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcount" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcount&lt;/a&gt;  * <br>

	 * @return value of channelCount field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=ChannelCount, $memberObjectName=channelCount, $memberObjectName=channelCount)

	public int getChannelCount();
	/**
	 * Provide String enumeration value (baseType SFString) ["MAX" | "CLAMPED_MAX" | "EXPLICIT"] from inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode&lt;/a&gt;  * <br>

	 * @return value of channelCountMode field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=ChannelCountMode, $memberObjectName=channelCountMode, $memberObjectName=channelCountMode)

	public String getChannelCountMode();

	/**
	 * Accessor method to assign String enumeration value ("MAX" | "CLAMPED_MAX" | "EXPLICIT") to inputOutput SFString field named <i>channelCountMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelCountMode determines how individual channels are counted when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelcountmode&lt;/a&gt;  * <br>

	 * @param newValue is new value for the channelCountMode field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setChannelCountMode(String newValue);

	/**
	 * Provide String enumeration value (baseType SFString) ["SPEAKERS" | "DISCRETE"] from inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation&lt;/a&gt;  * <br>

	 * @return value of channelInterpretation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=ChannelInterpretation, $memberObjectName=channelInterpretation, $memberObjectName=channelInterpretation)

	public String getChannelInterpretation();

	/**
	 * Accessor method to assign String enumeration value ("SPEAKERS" | "DISCRETE") to inputOutput SFString field named <i>channelInterpretation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  channelInterpretation determines how individual channels are treated when up-mixing and down-mixing connections to any inputs. Hint: W3C Web Audio API &lt;a href="https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation" target="_blank"&gt;https://www.w3.org/TR/webaudio/#dom-audionode-channelinterpretation&lt;/a&gt;  * <br>

	 * @param newValue is new value for the channelInterpretation field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setChannelInterpretation(String newValue);

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) with acceptable node types limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper, from inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation. Warning: contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. Hint: can be original (DEF) or referenced (USE) nodes.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @see org.web3d.x3d.jsail.Sound.Analyser
	 * @see org.web3d.x3d.jsail.Sound.AudioClip
	 * @see org.web3d.x3d.jsail.Sound.AudioDestination
	 * @see org.web3d.x3d.jsail.Sound.BiquadFilter
	 * @see org.web3d.x3d.jsail.Sound.BufferAudioSource
	 * @see org.web3d.x3d.jsail.Sound.ChannelMerger
	 * @see org.web3d.x3d.jsail.Sound.ChannelSelector
	 * @see org.web3d.x3d.jsail.Sound.ChannelSplitter
	 * @see org.web3d.x3d.jsail.Sound.Convolver
	 * @see org.web3d.x3d.jsail.Sound.Delay
	 * @see org.web3d.x3d.jsail.Sound.DynamicsCompressor
	 * @see org.web3d.x3d.jsail.Sound.Gain
	 * @see org.web3d.x3d.jsail.Sound.ListenerPointSource
	 * @see org.web3d.x3d.jsail.Sound.MicrophoneSource
	 * @see org.web3d.x3d.jsail.Texturing.MovieTexture
	 * @see org.web3d.x3d.jsail.Sound.OscillatorSource
	 * @see org.web3d.x3d.jsail.Sound.Sound
	 * @see org.web3d.x3d.jsail.Sound.SpatialSound
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioDestination
	 * @see org.web3d.x3d.jsail.Sound.StreamAudioSource
	 * @see org.web3d.x3d.jsail.Sound.WaveShaper
	 * @return value of children field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=Children, $memberObjectName=children, $memberObjectName=children)
	public org.web3d.x3d.sai.Core.X3DNode[] getChildren(); // acceptable node types #1: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>children</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSoundChannelNode|X3DSoundProcessingNode|X3DSoundSourceNode] The children field specifies audio-graph sound sources providing input signals for this node. If multiple input signals are provided by the inputs children field, all channels are mixed together and merged prior to presentation. Warning: contained AudioClip or MovieTexture nodes must have containerField='children' to override otherwise-incorrect defaults. Hint: can be original (DEF) or referenced (USE) nodes.  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value for the children field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Delay setChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper

	/**
	 * Add array of children nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper.
	 * @param newValue is new value array to be appended the children field.
	 */
	public void addChildren(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper
	/**
	 * Set single children node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the children field
	 */
	public void setChildren(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: Analyser|AudioClip|AudioDestination|BiquadFilter|BufferAudioSource|ChannelMerger|ChannelSelector|ChannelSplitter|Convolver|Delay|DynamicsCompressor|Gain|ListenerPointSource|MicrophoneSource|MovieTexture|OscillatorSource|Sound|SpatialSound|StreamAudioDestination|StreamAudioSource|WaveShaper
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>delayTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) delayTime is duration of delay (in seconds) to apply.  * <br>

	 * @return value of delayTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=DelayTime, $memberObjectName=delayTime, $memberObjectName=delayTime)
	public double getDelayTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>delayTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) delayTime is duration of delay (in seconds) to apply.  * <br>

	 * @param newValue is new value for the delayTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Delay setDelayTime(double newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setDescription(String newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from outputOnly SFTime field named <i>elapsedTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Current elapsed time since AudioClip activated/running, cumulative in seconds, and not counting any paused time. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events. Hint: elapsedTime is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of elapsedTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=ElapsedTime, $memberObjectName=elapsedTime, $memberObjectName=elapsedTime)

	public double getElapsedTime();
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setEnabled(boolean newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node. Warning: Decibel values shall not be used. Hint: Negative gain factors negate the input signal.  * <br>

	 * @return value of gain field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=Gain, $memberObjectName=gain, $memberObjectName=gain)

	public float getGain();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>gain</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (-infinity,+infinity) The gain field is a factor that represents the amount of linear amplification to apply to the output of the node. Warning: Decibel values shall not be used. Hint: Negative gain factors negate the input signal.  * <br>

	 * @param newValue is new value for the gain field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setGain(float newValue);

	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isActive true/false events are sent when playback starts/stops. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isActive field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isPaused</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  isPaused true/false events are sent when AudioClip is paused/resumed. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isPaused field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=IsPaused, $memberObjectName=isPaused, $memberObjectName=isPaused)

	public boolean getIsPaused();
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>maxDelayTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDelayTime is duration of maximum amount of delay (in seconds) that can be applied.  * <br>

	 * @return value of maxDelayTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=MaxDelayTime, $memberObjectName=maxDelayTime, $memberObjectName=maxDelayTime)
	public double getMaxDelayTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>maxDelayTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) maxDelayTime is duration of maximum amount of delay (in seconds) that can be applied.  * <br>

	 * @param newValue is new value for the maxDelayTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Delay setMaxDelayTime(double newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of pauseTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=PauseTime, $memberObjectName=pauseTime, $memberObjectName=pauseTime)

	public double getPauseTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>pauseTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When time now &amp;gt;= pauseTime, isPaused becomes true and AudioClip becomes paused. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the pauseTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setPauseTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of resumeTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=ResumeTime, $memberObjectName=resumeTime, $memberObjectName=resumeTime)

	public double getResumeTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>resumeTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  When resumeTime becomes &amp;lt;= time now, isPaused becomes false and AudioClip becomes active. Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the resumeTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setResumeTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @return value of startTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=StartTime, $memberObjectName=startTime, $memberObjectName=startTime)

	public double getStartTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>startTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime.  * <br>

	 * @param newValue is new value for the startTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setStartTime(double newValue);

	/**
	 * Provide double value in seconds from inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. Warning: An active TimeSensor node ignores set_cycleInterval and set_startTime events. Warning:An active TimeSensor node ignores set_stopTime event values less than or equal to startTime.  * <br>

	 * @return value of stopTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=StopTime, $memberObjectName=stopTime, $memberObjectName=stopTime)

	public double getStopTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>stopTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Absolute time: number of seconds since January 1, 1970, 00:00:00 GMT. Hint: ROUTE a time value matching system clock to this field, such as output event from TouchSensor touchTime or TimeTrigger triggerTime. Warning: An active TimeSensor node ignores set_cycleInterval and set_startTime events. Warning:An active TimeSensor node ignores set_stopTime event values less than or equal to startTime.  * <br>

	 * @param newValue is new value for the stopTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setStopTime(double newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>tailTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) tailTime is duration of time that a node continues to provide output signal after the input signal becomes silent.  * <br>

	 * @return value of tailTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DSoundProcessingNode, $additionalInheritanceBaseType=, $thisClassName=Delay, $CamelCaseName=TailTime, $memberObjectName=tailTime, $memberObjectName=tailTime)

	public double getTailTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>tailTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) tailTime is duration of time that a node continues to provide output signal after the input signal becomes silent.  * <br>

	 * @param newValue is new value for the tailTime field.
	 * @return {@link Delay} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Delay setTailTime(double newValue);

}
