/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;
// import org.web3d.x3d.sai.Texturing.*;

/**
 * Material specifies surface rendering properties for associated geometry nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DOneSidedMaterialNode] Material specifies surface rendering properties for associated geometry nodes.
Material attributes are used by the X3D lighting equations during rendering.
Hint: insert Shape and Appearance nodes before adding material.
Hint: DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene.
Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;
Hint: X3D Example Archives, Basic, Universal Media Materials &lt;a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials&lt;/a&gt;
Hint: X3D Architecture 17.2.2 Lighting model &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel&lt;/a&gt;
Hint: Rendering &lt;a href="https://en.wikipedia.org/wiki/Rendering_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Rendering_(computer_graphics)&lt;/a&gt;
Hint: 3D rendering &lt;a href="https://en.wikipedia.org/wiki/3D_rendering" target="_blank"&gt;https://en.wikipedia.org/wiki/3D_rendering&lt;/a&gt;
Hint: Physically based rendering (PBR) &lt;a href="https://en.wikipedia.org/wiki/Physically_based_rendering" target="_blank"&gt;https://en.wikipedia.org/wiki/Physically_based_rendering&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#Material" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#Material" target="blank">X3D Abstract Specification: Material</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Material" target="_blank">X3D Tooltips: Material</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface Material extends  org.web3d.x3d.sai.Shape.X3DOneSidedMaterialNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much ambient omnidirectional light is reflected from all light sources. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of ambientIntensity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientIntensity, $memberObjectName=ambientIntensity, $memberObjectName=ambientIntensity)
	public float getAmbientIntensity();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>ambientIntensity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much ambient omnidirectional light is reflected from all light sources. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the ambientIntensity field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientIntensity(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>ambientTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying ambientIntensity for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='ambientTexture'.  * <br>

	 * @return value of ambientTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientTexture, $memberObjectName=ambientTexture, $memberObjectName=ambientTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getAmbientTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>ambientTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying ambientIntensity for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='ambientTexture'.  * <br>

	 * @param newValue is new value for the ambientTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>ambientTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of ambientTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=AmbientTextureMapping, $memberObjectName=ambientTextureMapping, $memberObjectName=ambientTextureMapping)
	public String getAmbientTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>ambientTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the ambientTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setAmbientTextureMapping(String newValue);

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>diffuseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much direct, angle-dependent light is reflected from all light sources. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet.  * <br>

	 * @return value of diffuseColor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseColor, $memberObjectName=diffuseColor, $memberObjectName=diffuseColor)
	public float[] getDiffuseColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>diffuseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much direct, angle-dependent light is reflected from all light sources. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet.  * <br>

	 * @param newValue is new value for the diffuseColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseColor(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>diffuseTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying diffuseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='diffuseTexture'.  * <br>

	 * @return value of diffuseTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseTexture, $memberObjectName=diffuseTexture, $memberObjectName=diffuseTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getDiffuseTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>diffuseTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying diffuseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='diffuseTexture'.  * <br>

	 * @param newValue is new value for the diffuseTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>diffuseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of diffuseTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=DiffuseTextureMapping, $memberObjectName=diffuseTextureMapping, $memberObjectName=diffuseTextureMapping)
	public String getDiffuseTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>diffuseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the diffuseTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setDiffuseTextureMapping(String newValue);

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much glowing light is emitted from this object. Hint: emissiveColors glow even when all lights are off. Hint: reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet. Warning: bright emissiveColor values can wash out other colors and some textures.  * <br>

	 * @return value of emissiveColor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveColor, $memberObjectName=emissiveColor, $memberObjectName=emissiveColor)
	public float[] getEmissiveColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much glowing light is emitted from this object. Hint: emissiveColors glow even when all lights are off. Hint: reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet. Warning: bright emissiveColor values can wash out other colors and some textures.  * <br>

	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveColor(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>emissiveTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='emissiveTexture'.  * <br>

	 * @return value of emissiveTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveTexture, $memberObjectName=emissiveTexture, $memberObjectName=emissiveTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getEmissiveTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='emissiveTexture'.  * <br>

	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of emissiveTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=EmissiveTextureMapping, $memberObjectName=emissiveTextureMapping, $memberObjectName=emissiveTextureMapping)

	public String getEmissiveTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setEmissiveTextureMapping(String newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material. Hint: normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt;  * <br>

	 * @return value of normalScale field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalScale, $memberObjectName=normalScale, $memberObjectName=normalScale)

	public float getNormalScale();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material. Hint: normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt;  * <br>

	 * @param newValue is new value for the normalScale field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setNormalScale(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>normalTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt; Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='normalTexture'  * <br>

	 * @return value of normalTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalTexture, $memberObjectName=normalTexture, $memberObjectName=normalTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getNormalTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt; Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='normalTexture'  * <br>

	 * @param newValue is new value for the normalTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of normalTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=NormalTextureMapping, $memberObjectName=normalTextureMapping, $memberObjectName=normalTextureMapping)

	public String getNormalTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Material setNormalTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting. Hint: only the Red channel of the texture is used for occlusion computations, other channels are ignored. Hint: &lt;a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank"&gt;https://en.wikipedia.org/wiki/Ambient_occlusion&lt;/a&gt;  * <br>

	 * @return value of occlusionStrength field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionStrength, $memberObjectName=occlusionStrength, $memberObjectName=occlusionStrength)
	public float getOcclusionStrength();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting. Hint: only the Red channel of the texture is used for occlusion computations, other channels are ignored. Hint: &lt;a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank"&gt;https://en.wikipedia.org/wiki/Ambient_occlusion&lt;/a&gt;  * <br>

	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionStrength(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>occlusionTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='occlusionTexture'.  * <br>

	 * @return value of occlusionTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionTexture, $memberObjectName=occlusionTexture, $memberObjectName=occlusionTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getOcclusionTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='occlusionTexture'.  * <br>

	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of occlusionTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=OcclusionTextureMapping, $memberObjectName=occlusionTextureMapping, $memberObjectName=occlusionTextureMapping)
	public String getOcclusionTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setOcclusionTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>shininess</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Lower shininess values provide soft specular glows, while higher values result in sharper, smaller highlights. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of shininess field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Shininess, $memberObjectName=shininess, $memberObjectName=shininess)
	public float getShininess();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>shininess</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] Lower shininess values provide soft specular glows, while higher values result in sharper, smaller highlights. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the shininess field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininess(float newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>shininessTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying shininess for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='shininessTexture'.  * <br>

	 * @return value of shininessTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=ShininessTexture, $memberObjectName=shininessTexture, $memberObjectName=shininessTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getShininessTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>shininessTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying shininess for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='shininessTexture'.  * <br>

	 * @param newValue is new value for the shininessTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>shininessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of shininessTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=ShininessTextureMapping, $memberObjectName=shininessTextureMapping, $memberObjectName=shininessTextureMapping)
	public String getShininessTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>shininessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the shininessTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setShininessTextureMapping(String newValue);

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>specularColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specular highlights are brightness reflections (example: shiny spots on an apple). Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of specularColor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularColor, $memberObjectName=specularColor, $memberObjectName=specularColor)
	public float[] getSpecularColor();

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>specularColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specular highlights are brightness reflections (example: shiny spots on an apple). Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the specularColor field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularColor(float[] newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>specularTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying specularColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='specularTexture'.  * <br>

	 * @return value of specularTexture field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularTexture, $memberObjectName=specularTexture, $memberObjectName=specularTexture)
	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getSpecularTexture(); // acceptable node types #1: X3DSingleTextureNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>specularTexture</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying specularColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='specularTexture'.  * <br>

	 * @param newValue is new value for the specularTexture field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue); // acceptable node types #2: X3DSingleTextureNode

	/**
	 * Provide String value from inputOutput SFString field named <i>specularTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of specularTextureMapping field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=SpecularTextureMapping, $memberObjectName=specularTextureMapping, $memberObjectName=specularTextureMapping)
	public String getSpecularTextureMapping();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>specularTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the specularTextureMapping field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setSpecularTextureMapping(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile hint: transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent.  * <br>

	 * @return value of transparency field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=Material, $CamelCaseName=Transparency, $memberObjectName=transparency, $memberObjectName=transparency)
	public float getTransparency();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile hint: transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent.  * <br>

	 * @param newValue is new value for the transparency field.
	 * @return {@link Material} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Material setTransparency(float newValue);

}
