/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * AcousticProperties specifies the interaction of sound waves with characteristics of geometric objects in the scene.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 4.0 draft) [X3DAppearanceChildNode] AcousticProperties specifies the interaction of sound waves with characteristics of geometric objects in the scene. Acoustic coefficient values are expected to fully account for physical and structural characteristics of associated geometry such as width, height, thickness, shape, softness and/or hardness, and density variations.
Hint: AcousticProperties must have a parent Appearance node, and only affects geometry within the same Shape.
Hint: proxy geometry for acoustic response can be far simpler than geometry needed for visual rendering.
Hint: X3D Architecture Figure 16.2 Sound Propagation Phenomena &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/sound.html#f-SoundPropagationPhenomena" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/sound.html#f-SoundPropagationPhenomena&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#AcousticProperties" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#AcousticProperties" target="blank">X3D Abstract Specification: AcousticProperties</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#AcousticProperties" target="_blank">X3D Tooltips: AcousticProperties</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface AcousticProperties extends  org.web3d.x3d.sai.Shape.X3DAppearanceChildNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>absorption</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specifies the sound absorption coefficient of a surface, meaning the ratio of sound intensity not reflected by a surface.  * <br>

	 * @return value of absorption field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Absorption, $memberObjectName=absorption, $memberObjectName=absorption)
	public float getAbsorption();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>absorption</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specifies the sound absorption coefficient of a surface, meaning the ratio of sound intensity not reflected by a surface.  * <br>

	 * @param newValue is new value for the absorption field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setAbsorption(float newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)
	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setDescription(String newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>diffuse</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] diffuse coefficient of sound reflection indicates how much of the incident sound energy is reflected back in multiple directions.  * <br>

	 * @return value of diffuse field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Diffuse, $memberObjectName=diffuse, $memberObjectName=diffuse)
	public float getDiffuse();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>diffuse</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] diffuse coefficient of sound reflection indicates how much of the incident sound energy is reflected back in multiple directions.  * <br>

	 * @param newValue is new value for the diffuse field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setDiffuse(float newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)
	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setEnabled(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public AcousticProperties setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>refraction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] sound refraction coefficient of a medium, which determines change in propagation direction of sound wave when obliquely crossing boundary between two mediums where its speed is different. Hint: relationships described by Snell's Law &lt;a href="https://en.wikipedia.org/wiki/Snell%27s_law" target="_blank"&gt;https://en.wikipedia.org/wiki/Snell%27s_law&lt;/a&gt;  * <br>

	 * @return value of refraction field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Refraction, $memberObjectName=refraction, $memberObjectName=refraction)
	public float getRefraction();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>refraction</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] sound refraction coefficient of a medium, which determines change in propagation direction of sound wave when obliquely crossing boundary between two mediums where its speed is different. Hint: relationships described by Snell's Law &lt;a href="https://en.wikipedia.org/wiki/Snell%27s_law" target="_blank"&gt;https://en.wikipedia.org/wiki/Snell%27s_law&lt;/a&gt;  * <br>

	 * @param newValue is new value for the refraction field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setRefraction(float newValue);

	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>specular</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specular coefficient of sound reflection striking a plane surface, directly reflected back into space, where angle of reflection equals angle of incidence.  * <br>

	 * @return value of specular field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DAppearanceChildNode, $additionalInheritanceBaseType=, $thisClassName=AcousticProperties, $CamelCaseName=Specular, $memberObjectName=specular, $memberObjectName=specular)
	public float getSpecular();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>specular</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] specular coefficient of sound reflection striking a plane surface, directly reflected back into space, where angle of reflection equals angle of incidence.  * <br>

	 * @param newValue is new value for the specular field.
	 * @return {@link AcousticProperties} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public AcousticProperties setSpecular(float newValue);

}
