/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.RigidBodyPhysics;
// import org.web3d.x3d.sai.Grouping.X3DBoundedObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.RigidBodyPhysics.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
import java.util.Arrays;

/**
 * RigidBody describes a collection of shapes with a mass distribution that is affected by the physics model.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 3.2 or later) [X3DChildNode] RigidBody describes a collection of shapes with a mass distribution that is affected by the physics model.
Contains a Sphere, Box, or Cone (containerField='massDensityModel') and multiple CollidableOffset or CollidableShape nodes (containerField='geometry') for animating collidable geometry.  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#RigidBody" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/rigidBodyPhysics.html#RigidBody" target="blank">X3D Abstract Specification: RigidBody</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#RigidBody" target="_blank">X3D Tooltips: RigidBody</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface RigidBody extends  org.web3d.x3d.sai.Core.X3DChildNode,  org.web3d.x3d.sai.Grouping.X3DBoundedObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide float value from inputOutput SFFloat field named <i>angularDampingFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] angularDampingFactor automatically damps a portion of body motion over time.  * <br>

	 * @return value of angularDampingFactor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=AngularDampingFactor, $memberObjectName=angularDampingFactor, $memberObjectName=angularDampingFactor)
	public float getAngularDampingFactor();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>angularDampingFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] angularDampingFactor automatically damps a portion of body motion over time.  * <br>

	 * @param newValue is new value for the angularDampingFactor field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setAngularDampingFactor(float newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>angularVelocity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  angularVelocity sets constant velocity value to object every frame, and reports updates by physics model. Hint: initial value only applied during first frame if forces applied. Warning: instantaneous velocity changes may lead to numerical instability.  * <br>

	 * @return value of angularVelocity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=AngularVelocity, $memberObjectName=angularVelocity, $memberObjectName=angularVelocity)
	public float[] getAngularVelocity();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>angularVelocity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  angularVelocity sets constant velocity value to object every frame, and reports updates by physics model. Hint: initial value only applied during first frame if forces applied. Warning: instantaneous velocity changes may lead to numerical instability.  * <br>

	 * @param newValue is new value for the angularVelocity field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setAngularVelocity(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>autoDamp</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoDamp enables/disables angularDampingFactor and linearDampingFactor.  * <br>

	 * @return value of autoDamp field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=AutoDamp, $memberObjectName=autoDamp, $memberObjectName=autoDamp)
	public boolean getAutoDamp();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>autoDamp</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoDamp enables/disables angularDampingFactor and linearDampingFactor.  * <br>

	 * @param newValue is new value for the autoDamp field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setAutoDamp(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>autoDisable</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoDisable toggles operation of disableAngularSpeed, disableLinearSpeed, disableTime.  * <br>

	 * @return value of autoDisable field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=AutoDisable, $memberObjectName=autoDisable, $memberObjectName=autoDisable)
	public boolean getAutoDisable();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>autoDisable</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoDisable toggles operation of disableAngularSpeed, disableLinearSpeed, disableTime.  * <br>

	 * @param newValue is new value for the autoDisable field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setAutoDisable(boolean newValue);

	/**
	 * Provide array of 3-tuple float results from initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxCenter field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=BboxCenter, $memberObjectName=bboxCenter, $memberObjectName=bboxCenter)

	public float[] getBboxCenter();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxCenter field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public RigidBody setBboxCenter(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @return value of bboxDisplay field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=BboxDisplay, $memberObjectName=bboxDisplay, $memberObjectName=bboxDisplay)

	public boolean getBboxDisplay();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @param newValue is new value for the bboxDisplay field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public RigidBody setBboxDisplay(boolean newValue);

	/**
	 * Provide array of 3-tuple float results within allowed range of [0,infinity), or default value [-1 -1 -1], from initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxSize field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=BboxSize, $memberObjectName=bboxSize, $memberObjectName=bboxSize)

	public float[] getBboxSize();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxSize field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public RigidBody setBboxSize(float[] newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>centerOfMass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  centerOfMass defines local center of mass for physics calculations.  * <br>

	 * @return value of centerOfMass field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=CenterOfMass, $memberObjectName=centerOfMass, $memberObjectName=centerOfMass)
	public float[] getCenterOfMass();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>centerOfMass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  centerOfMass defines local center of mass for physics calculations.  * <br>

	 * @param newValue is new value for the centerOfMass field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setCenterOfMass(float[] newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>disableAngularSpeed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableAngularSpeed defines lower-limit tolerance value when body is considered at rest and not part of rigid body calculations, reducing numeric instabilities. Hint: only activated if autoDisable='true'.  * <br>

	 * @return value of disableAngularSpeed field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=DisableAngularSpeed, $memberObjectName=disableAngularSpeed, $memberObjectName=disableAngularSpeed)
	public float getDisableAngularSpeed();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>disableAngularSpeed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableAngularSpeed defines lower-limit tolerance value when body is considered at rest and not part of rigid body calculations, reducing numeric instabilities. Hint: only activated if autoDisable='true'.  * <br>

	 * @param newValue is new value for the disableAngularSpeed field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setDisableAngularSpeed(float newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>disableLinearSpeed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableLinearSpeed defines lower-limit tolerance value when body is considered at rest and not part of rigid body calculation, reducing numeric instabilitiess. Hint: only activated if autoDisable='true'.  * <br>

	 * @return value of disableLinearSpeed field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=DisableLinearSpeed, $memberObjectName=disableLinearSpeed, $memberObjectName=disableLinearSpeed)
	public float getDisableLinearSpeed();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>disableLinearSpeed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableLinearSpeed defines lower-limit tolerance value when body is considered at rest and not part of rigid body calculation, reducing numeric instabilitiess. Hint: only activated if autoDisable='true'.  * <br>

	 * @param newValue is new value for the disableLinearSpeed field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setDisableLinearSpeed(float newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>disableTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableTime defines interval when body becomes at rest and not part of rigid body calculations, reducing numeric instabilities. Hint: only activated if autoDisable='true' Hint: disableTime is an SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of disableTime field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=DisableTime, $memberObjectName=disableTime, $memberObjectName=disableTime)
	public double getDisableTime();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>disableTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) disableTime defines interval when body becomes at rest and not part of rigid body calculations, reducing numeric instabilities. Hint: only activated if autoDisable='true' Hint: disableTime is an SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the disableTime field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setDisableTime(double newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)
	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables node operation.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setEnabled(boolean newValue);

	/**
	 * Provide array of 3-tuple float results unit axis, angle (in radians) from inputOutput SFVec3f field named <i>finiteRotationAxis</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  finiteRotationAxis specifies vector around which the object rotates.  * <br>

	 * @return value of finiteRotationAxis field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=FiniteRotationAxis, $memberObjectName=finiteRotationAxis, $memberObjectName=finiteRotationAxis)
	public float[] getFiniteRotationAxis();

	/**
	 * Accessor method to assign 3-tuple float array unit axis, angle (in radians) to inputOutput SFVec3f field named <i>finiteRotationAxis</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  finiteRotationAxis specifies vector around which the object rotates.  * <br>

	 * @param newValue is new value for the finiteRotationAxis field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setFiniteRotationAxis(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>fixed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  fixed indicates whether body is able to move. Hint: fixed is useful for indicating objects that do not move: walls, ground, etc.  * <br>

	 * @return value of fixed field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Fixed, $memberObjectName=fixed, $memberObjectName=fixed)
	public boolean getFixed();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>fixed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  fixed indicates whether body is able to move. Hint: fixed is useful for indicating objects that do not move: walls, ground, etc.  * <br>

	 * @param newValue is new value for the fixed field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setFixed(boolean newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput MFVec3f field named <i>forces</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  forces defines linear force values applied to the object every frame.  * <br>

	 * @return value of forces field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Forces, $memberObjectName=forces, $memberObjectName=forces)
	public float[] getForces();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput MFVec3f field named <i>forces</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  forces defines linear force values applied to the object every frame.  * <br>

	 * @param newValue is new value for the forces field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setForces(float[] newValue);

	/**
	 * Provide array of org.web3d.x3d.sai.Core.X3DNode results (using an array consisting of properly typed nodes or ProtoInstances) from inputOutput MFNode field <i>geometry</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DNBodyCollidableNode] The geometry field is used to connect the body modelled by the physics engine implementation to the real geometry of the scene through the use of collidable nodes. This allows the geometry to be connected directly to the physics model as well as collision detection. Collidable nodes have their location set to the same location as the body instance in which they are located.  * <br>

	 * <br><br>
	 * <i>Warning:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNBodyCollidableNode.
	 * @see org.web3d.x3d.sai.RigidBodyPhysics.X3DNBodyCollidableNode
	 * @return value of geometry field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Geometry, $memberObjectName=geometry, $memberObjectName=geometry)
	public org.web3d.x3d.sai.Core.X3DNode[] getGeometry(); // acceptable node types #1: X3DNBodyCollidableNode

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode array (using an array consisting of properly typed nodes or ProtoInstances) to inputOutput MFNode field <i>geometry</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DNBodyCollidableNode] The geometry field is used to connect the body modelled by the physics engine implementation to the real geometry of the scene through the use of collidable nodes. This allows the geometry to be connected directly to the physics model as well as collision detection. Collidable nodes have their location set to the same location as the body instance in which they are located.  * <br>

	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNBodyCollidableNode.
	 * @param newValue is new value for the geometry field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setGeometry(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #2: X3DNBodyCollidableNode

	/**
	 * Add array of child geometry nodes to array of existing nodes (if any).
	 * <br><br>
	 * <i>Note:</i> according to X3D Unified Object Model (X3DUOM), acceptable node types are limited to X3DNBodyCollidableNode.
	 * @param newValue is new value array to be appended the geometry field.
	 */
	public void addGeometry(org.web3d.x3d.sai.Core.X3DNode[] newValue); // acceptable node types #3: X3DNBodyCollidableNode
	/**
	 * Set single child geometry node, replacing prior array of existing nodes (if any).
	 * @param newValue is new node for the geometry field
	 */
	public void setGeometry(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #5: X3DNBodyCollidableNode
	/**
	 * Provide array of float results from inputOutput SFMatrix3f field named <i>inertia</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  inertia matrix defines a 3x2 inertia tensor matrix. Warning: only the first 6 values are used.  * <br>

	 * @return value of inertia field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Inertia, $memberObjectName=inertia, $memberObjectName=inertia)
	public float[] getInertia();

	/**
	 * Accessor method to assign float array to inputOutput SFMatrix3f field named <i>inertia</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  inertia matrix defines a 3x2 inertia tensor matrix. Warning: only the first 6 values are used.  * <br>

	 * @param newValue is new value for the inertia field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setInertia(float[] newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>linearDampingFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] linearDampingFactor automatically damps a portion of body motion over time.  * <br>

	 * @return value of linearDampingFactor field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=LinearDampingFactor, $memberObjectName=linearDampingFactor, $memberObjectName=linearDampingFactor)
	public float getLinearDampingFactor();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>linearDampingFactor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] linearDampingFactor automatically damps a portion of body motion over time.  * <br>

	 * @param newValue is new value for the linearDampingFactor field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setLinearDampingFactor(float newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>linearVelocity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linearVelocity sets constant velocity value to object every frame, and reports updates by physics model. Hint: initial value only applied during first frame if forces applied. Warning: instantaneous velocity changes may lead to numerical instability.  * <br>

	 * @return value of linearVelocity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=LinearVelocity, $memberObjectName=linearVelocity, $memberObjectName=linearVelocity)
	public float[] getLinearVelocity();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>linearVelocity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  linearVelocity sets constant velocity value to object every frame, and reports updates by physics model. Hint: initial value only applied during first frame if forces applied. Warning: instantaneous velocity changes may lead to numerical instability.  * <br>

	 * @param newValue is new value for the linearVelocity field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setLinearVelocity(float[] newValue);

	/**
	 * Provide float value from inputOutput SFFloat field named <i>mass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,1] mass of the body in kilograms. Warning: mass must be greater than 0. Hint: &lt;a href="https://en.wikipedia.org/wiki/Kilogram" target="_blank"&gt;https://en.wikipedia.org/wiki/Kilogram&lt;/a&gt; Hint: X3D Architecture 4.3.6 Standard units and coordinate system &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates&lt;/a&gt;  * <br>

	 * @return value of mass field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Mass, $memberObjectName=mass, $memberObjectName=mass)
	public float getMass();

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>mass</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  (0,1] mass of the body in kilograms. Warning: mass must be greater than 0. Hint: &lt;a href="https://en.wikipedia.org/wiki/Kilogram" target="_blank"&gt;https://en.wikipedia.org/wiki/Kilogram&lt;/a&gt; Hint: X3D Architecture 4.3.6 Standard units and coordinate system &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/concepts.html#Standardunitscoordinates&lt;/a&gt;  * <br>

	 * @param newValue is new value for the mass field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setMass(float newValue);

	/**
	 * Provide org.web3d.x3d.sai.Core.X3DNode instance (using a properly typed node) with acceptable node types limited to Sphere|Box|Cone, from inputOutput SFNode field <i>massDensityModel</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [Sphere,Box,Cone] The massDensityModel field is used to describe the geometry type and dimensions used to calculate the mass density in the physics model. It is not rendered, nor modified by the physics model.  * <br>

	 * @return value of massDensityModel field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=MassDensityModel, $memberObjectName=massDensityModel, $memberObjectName=massDensityModel)
	public org.web3d.x3d.sai.Core.X3DNode getMassDensityModel(); // acceptable node types #1: Sphere|Box|Cone

	/**
	 * Accessor method to assign org.web3d.x3d.sai.Core.X3DNode instance (using a properly typed node) to inputOutput SFNode field <i>massDensityModel</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [Sphere,Box,Cone] The massDensityModel field is used to describe the geometry type and dimensions used to calculate the mass density in the physics model. It is not rendered, nor modified by the physics model.  * <br>

	 * @param newValue is new value for the massDensityModel field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setMassDensityModel(org.web3d.x3d.sai.Core.X3DNode newValue); // acceptable node types #2: Sphere|Box|Cone

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public RigidBody setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide array of 4-tuple float results unit axis, angle (in radians) from inputOutput SFRotation field named <i>orientation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  orientation sets body direction in world space, then reports physics updates.  * <br>

	 * @return value of orientation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Orientation, $memberObjectName=orientation, $memberObjectName=orientation)
	public float[] getOrientation();

	/**
	 * Accessor method to assign 4-tuple float array unit axis, angle (in radians) to inputOutput SFRotation field named <i>orientation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  orientation sets body direction in world space, then reports physics updates.  * <br>

	 * @param newValue is new value for the orientation field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setOrientation(float[] newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput SFVec3f field named <i>position</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  position sets body location in world space, then reports physics updates.  * <br>

	 * @return value of position field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Position, $memberObjectName=position, $memberObjectName=position)
	public float[] getPosition();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput SFVec3f field named <i>position</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  position sets body location in world space, then reports physics updates.  * <br>

	 * @param newValue is new value for the position field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setPosition(float[] newValue);

	/**
	 * Provide array of 3-tuple float results from inputOutput MFVec3f field named <i>torques</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  torques defines rotational force values applied to the object every frame.  * <br>

	 * @return value of torques field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Torques, $memberObjectName=torques, $memberObjectName=torques)
	public float[] getTorques();

	/**
	 * Accessor method to assign 3-tuple float array to inputOutput MFVec3f field named <i>torques</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  torques defines rotational force values applied to the object every frame.  * <br>

	 * @param newValue is new value for the torques field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setTorques(float[] newValue);

	/**
	 * Provide boolean value unit axis, angle (in radians) from inputOutput SFBool field named <i>useFiniteRotation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  useFiniteRotation enables/disables higher-resolution, higher-cost computational method for calculating rotations.  * <br>

	 * @return value of useFiniteRotation field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=UseFiniteRotation, $memberObjectName=useFiniteRotation, $memberObjectName=useFiniteRotation)
	public boolean getUseFiniteRotation();

	/**
	 * Accessor method to assign boolean value unit axis, angle (in radians) to inputOutput SFBool field named <i>useFiniteRotation</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  useFiniteRotation enables/disables higher-resolution, higher-cost computational method for calculating rotations.  * <br>

	 * @param newValue is new value for the useFiniteRotation field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setUseFiniteRotation(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>useGlobalGravity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  useGlobalGravity indicates whether this particular body is influenced by parent RigidBodyCollection's gravity setting. Hint: contained sub-bodies are not affected by this setting.  * <br>

	 * @return value of useGlobalGravity field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=UseGlobalGravity, $memberObjectName=useGlobalGravity, $memberObjectName=useGlobalGravity)
	public boolean getUseGlobalGravity();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>useGlobalGravity</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  useGlobalGravity indicates whether this particular body is influenced by parent RigidBodyCollection's gravity setting. Hint: contained sub-bodies are not affected by this setting.  * <br>

	 * @param newValue is new value for the useGlobalGravity field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public RigidBody setUseGlobalGravity(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @return value of visible field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=RigidBody, $CamelCaseName=Visible, $memberObjectName=visible, $memberObjectName=visible)

	public boolean getVisible();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @param newValue is new value for the visible field.
	 * @return {@link RigidBody} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public RigidBody setVisible(boolean newValue);

}
