/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.Networking;
// import org.web3d.x3d.sai.Grouping.X3DBoundedObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * Inline can load another X3D or VRML model into the current scene via url.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DGroupingNode,X3DBoundedObject,X3DUrlObject,X3DVisibleObject] Inline can load another X3D or VRML model into the current scene via url. Inline is an X3DBoundedObject node that has bounding-box dimensions.
Hint: (X3D version 4.0 draft) support includes .gltf and .glb &lt;a href="https://www.khronos.org/gltf" target="_blank"&gt;https://www.khronos.org/gltf&lt;/a&gt; &lt;a href="https://en.wikipedia.org/wiki/glTF" target="_blank"&gt;https://en.wikipedia.org/wiki/glTF&lt;/a&gt; 
Hint: you cannot ROUTE values into an Inline scene,
use IMPORT/EXPORT (or ExternProtoDeclare and ProtoInstance) instead.
Hint: X3D Scene Authoring Hints, Inlines and Prototypes &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#InlinesPrototypes" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#InlinesPrototypes&lt;/a&gt;
Hint: when parent node is LoadSensor, apply containerField='children' (X3Dv4) or containerField='watchList' (X3Dv3). &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#Inline" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/networking.html#Inline" target="blank">X3D Abstract Specification: Inline</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#Inline" target="_blank">X3D Tooltips: Inline</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#InlinesPrototypes" target="_blank">X3D Scene Authoring Hints: InlinesPrototypes</a>
 */
public interface Inline extends  org.web3d.x3d.sai.Core.X3DChildNode,  org.web3d.x3d.sai.Grouping.X3DBoundedObject,  org.web3d.x3d.sai.Networking.X3DUrlObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefresh field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=AutoRefresh, $memberObjectName=autoRefresh, $memberObjectName=autoRefresh)

	public double getAutoRefresh();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefresh</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefresh defines interval in seconds before automatic reload of current url asset is performed. Hint: if preceding file loading fails or load field is false, no refresh is performed. Hint: repeated refresh attempts to reload currently loaded entry of url list. If that fails, the browser retries other entries in the url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefresh field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setAutoRefresh(double newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @return value of autoRefreshTimeLimit field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=AutoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit, $memberObjectName=autoRefreshTimeLimit)

	public double getAutoRefreshTimeLimit();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>autoRefreshTimeLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  autoRefreshTimeLimit defines maximum duration that automatic refresh activity can occur. Hint: Automatic refresh is different than query and response timeouts performed by a networking library while sequentially attempting to retrieve addressed content from a url list. Warning: automatically reloading content has security considerations and needs to be considered carefully.  * <br>

	 * @param newValue is new value for the autoRefreshTimeLimit field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setAutoRefreshTimeLimit(double newValue);

	/**
	 * Provide array of 3-tuple float results from initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxCenter field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=BboxCenter, $memberObjectName=bboxCenter, $memberObjectName=bboxCenter)

	public float[] getBboxCenter();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxCenter field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setBboxCenter(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @return value of bboxDisplay field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=BboxDisplay, $memberObjectName=bboxDisplay, $memberObjectName=bboxDisplay)

	public boolean getBboxDisplay();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @param newValue is new value for the bboxDisplay field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setBboxDisplay(boolean newValue);

	/**
	 * Provide array of 3-tuple float results within allowed range of [0,infinity), or default value [-1 -1 -1], from initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxSize field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=BboxSize, $memberObjectName=bboxSize, $memberObjectName=bboxSize)

	public float[] getBboxSize();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxSize field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setBboxSize(float[] newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the url asset. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setDescription(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>global</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The global field controls potential external scoping effects of lights found within an Inline scene. Global lights illuminate all objects within their volume of lighting influence. Scoped lights only illuminate objects within the same transformation hierarchy. Hint: X3D Architecture, 17.2.1.2 Scoping of lights &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#ScopingOfLights" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#ScopingOfLights&lt;/a&gt;  * <br>

	 * @return value of global field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Global, $memberObjectName=global, $memberObjectName=global)
	public boolean getGlobal();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>global</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The global field controls potential external scoping effects of lights found within an Inline scene. Global lights illuminate all objects within their volume of lighting influence. Scoped lights only illuminate objects within the same transformation hierarchy. Hint: X3D Architecture, 17.2.1.2 Scoping of lights &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#ScopingOfLights" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#ScopingOfLights&lt;/a&gt;  * <br>

	 * @param newValue is new value for the global field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public Inline setGlobal(boolean newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @return value of load field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Load, $memberObjectName=load, $memberObjectName=load)

	public boolean getLoad();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>load</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  load=true means load immediately, load=false means defer loading or else unload a previously loaded scene. Hint: allows author to design when Inline loading occurs via user interaction, event chains or scripting. Hint: use a separate LoadSensor node to detect when loading is complete.  * <br>

	 * @param newValue is new value for the load field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setLoad(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide array of String results from inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Address of X3D world to load Inline with current scene, retrieved either from local system or an online address. Browser support for X3D model support can include allowed file formats for XML .x3d, ClassicVRML .x3dv, X3D Binary .x3db, X3D JSON .json, and Virtual Reality Modeling Language (VRML97) .wrl. Hint: (X3D version 4.0 draft) support includes .gltf and .glb &lt;a href="https://www.khronos.org/gltf" target="_blank"&gt;https://www.khronos.org/gltf&lt;/a&gt; &lt;a href="https://en.wikipedia.org/wiki/glTF" target="_blank"&gt;https://en.wikipedia.org/wiki/glTF&lt;/a&gt; Hint: future work planned for PLY format &lt;a href="https://en.wikipedia.org/wiki/PLY_(file_format)" target="_blank"&gt;https://en.wikipedia.org/wiki/PLY_(file_format)&lt;/a&gt; Hint: future work planned for STL format &lt;a href="https://en.wikipedia.org/wiki/STL_(file_format)" target="_blank"&gt;https://en.wikipedia.org/wiki/STL_(file_format)&lt;/a&gt; Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt;  * <br>

	 * @return value of url field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Url, $memberObjectName=url, $memberObjectName=url)

	public String[] getUrl();

	/**
	 * Accessor method to assign String array to inputOutput MFString field named <i>url</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Address of X3D world to load Inline with current scene, retrieved either from local system or an online address. Browser support for X3D model support can include allowed file formats for XML .x3d, ClassicVRML .x3dv, X3D Binary .x3db, X3D JSON .json, and Virtual Reality Modeling Language (VRML97) .wrl. Hint: (X3D version 4.0 draft) support includes .gltf and .glb &lt;a href="https://www.khronos.org/gltf" target="_blank"&gt;https://www.khronos.org/gltf&lt;/a&gt; &lt;a href="https://en.wikipedia.org/wiki/glTF" target="_blank"&gt;https://en.wikipedia.org/wiki/glTF&lt;/a&gt; Hint: future work planned for PLY format &lt;a href="https://en.wikipedia.org/wiki/PLY_(file_format)" target="_blank"&gt;https://en.wikipedia.org/wiki/PLY_(file_format)&lt;/a&gt; Hint: future work planned for STL format &lt;a href="https://en.wikipedia.org/wiki/STL_(file_format)" target="_blank"&gt;https://en.wikipedia.org/wiki/STL_(file_format)&lt;/a&gt; Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." Hint: alternative XML encoding for quotation mark " is &amp;quot; (which is an example of a character entity). Warning: strictly match directory and filename capitalization for http links! This is important for portability. Some operating systems are forgiving of capitalization mismatches, but http/https url addresses and paths in Unix-based operating systems are all case sensitive and intolerant of uppercase/lowercase mismatches. Hint: can replace embedded blank(s) in url queries with %20 for each blank character. Hint: X3D Scene Authoring Hints, urls &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#urls&lt;/a&gt;  * <br>

	 * @param newValue is new value for the url field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setUrl(String[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @return value of visible field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DChildNode, $additionalInheritanceBaseType=X3DBoundedObject X3DUrlObject, $thisClassName=Inline, $CamelCaseName=Visible, $memberObjectName=visible, $memberObjectName=visible)

	public boolean getVisible();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @param newValue is new value for the visible field.
	 * @return {@link Inline} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public Inline setVisible(boolean newValue);

}
