/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.NURBS;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.NURBS.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.NURBS.*;

/**
 * NurbsSweptSurface uses a trajectoryCurve path to describe a generalized surface that is swept by a crossSectionCurve.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DParametricGeometryNode] NurbsSweptSurface uses a trajectoryCurve path to describe a generalized surface that is swept by a crossSectionCurve.
Hint: conceptually it is the NURBS equivalent of Extrusion but permits the use of non-closed cross sections.  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#NurbsSweptSurface" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/nurbs.html#NurbsSweptSurface" target="blank">X3D Abstract Specification: NurbsSweptSurface</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#NurbsSweptSurface" target="_blank">X3D Tooltips: NurbsSweptSurface</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface NurbsSweptSurface extends  org.web3d.x3d.sai.NURBS.X3DParametricGeometryNode
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide boolean value from initializeOnly SFBool field named <i>ccw</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  ccw defines clockwise/counterclockwise ordering of vertex coordinates, which in turn defines front/back orientation of polygon normals according to Right-Hand Rule (RHR). Hint: a good debugging technique for problematic polygons is to try changing the value of ccw, which can reverse solid effects (single-sided backface culling) and normal-vector direction. Warning: consistent and correct ordering of left-handed or right-handed point sequences is important throughout the coord array of point values. Hint: clockwise &lt;a href="https://en.wikipedia.org/wiki/Clockwise" target="_blank"&gt;https://en.wikipedia.org/wiki/Clockwise&lt;/a&gt;  * <br>

	 * @return value of ccw field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParametricGeometryNode, $additionalInheritanceBaseType=, $thisClassName=NurbsSweptSurface, $CamelCaseName=Ccw, $memberObjectName=ccw, $memberObjectName=ccw)
	public boolean getCcw();

	/**
	 * Accessor method to assign boolean value to initializeOnly SFBool field named <i>ccw</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  ccw defines clockwise/counterclockwise ordering of vertex coordinates, which in turn defines front/back orientation of polygon normals according to Right-Hand Rule (RHR). Hint: a good debugging technique for problematic polygons is to try changing the value of ccw, which can reverse solid effects (single-sided backface culling) and normal-vector direction. Warning: consistent and correct ordering of left-handed or right-handed point sequences is important throughout the coord array of point values. Hint: clockwise &lt;a href="https://en.wikipedia.org/wiki/Clockwise" target="_blank"&gt;https://en.wikipedia.org/wiki/Clockwise&lt;/a&gt;  * <br>

	 * @param newValue is new value for the ccw field.
	 * @return {@link NurbsSweptSurface} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NurbsSweptSurface setCcw(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.NURBS.X3DNurbsControlCurveNode instance (using a properly typed node) from inputOutput SFNode field <i>crossSectionCurve</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DNurbsControlCurveNode] defines cross-section of the surface traced about the trajectoryCurve axis.  * <br>

	 * @return value of crossSectionCurve field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParametricGeometryNode, $additionalInheritanceBaseType=, $thisClassName=NurbsSweptSurface, $CamelCaseName=CrossSectionCurve, $memberObjectName=crossSectionCurve, $memberObjectName=crossSectionCurve)
	public  org.web3d.x3d.sai.NURBS.X3DNurbsControlCurveNode getCrossSectionCurve(); // acceptable node types #1: X3DNurbsControlCurveNode

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.NURBS.X3DNurbsControlCurveNode instance (using a properly typed node) to inputOutput SFNode field <i>crossSectionCurve</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DNurbsControlCurveNode] defines cross-section of the surface traced about the trajectoryCurve axis.  * <br>

	 * @param newValue is new value for the crossSectionCurve field.
	 * @return {@link NurbsSweptSurface} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NurbsSweptSurface setCrossSectionCurve( org.web3d.x3d.sai.NURBS.X3DNurbsControlCurveNode newValue); // acceptable node types #2: X3DNurbsControlCurveNode

	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParametricGeometryNode, $additionalInheritanceBaseType=, $thisClassName=NurbsSweptSurface, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link NurbsSweptSurface} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NurbsSweptSurface setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>solid</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Setting solid true means draw only one side of polygons (backface culling on), setting solid false means draw both sides of polygons (backface culling off). Hint: mnemonic "this geometry is solid like a brick" (you don't render the inside of a brick). Warning: default value true can completely hide geometry if viewed from wrong side! Hint: if in doubt, use solid='false' for maximum visibility. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and visualization.  * <br>

	 * @return value of solid field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParametricGeometryNode, $additionalInheritanceBaseType=, $thisClassName=NurbsSweptSurface, $CamelCaseName=Solid, $memberObjectName=solid, $memberObjectName=solid)
	public boolean getSolid();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>solid</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Setting solid true means draw only one side of polygons (backface culling on), setting solid false means draw both sides of polygons (backface culling off). Hint: mnemonic "this geometry is solid like a brick" (you don't render the inside of a brick). Warning: default value true can completely hide geometry if viewed from wrong side! Hint: if in doubt, use solid='false' for maximum visibility. Hint: (X3D version 4.0 draft) accessType relaxed to inputOutput in order to support animation and visualization.  * <br>

	 * @param newValue is new value for the solid field.
	 * @return {@link NurbsSweptSurface} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NurbsSweptSurface setSolid(boolean newValue);

	/**
	 * Provide  org.web3d.x3d.sai.NURBS.NurbsCurve instance (using a properly typed node) from inputOutput SFNode field <i>trajectoryCurve</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [NurbsCurve] describes the center-line path using a NurbsCurve node, oriented so that it is defined counterclockwise when looking down the −Y axis, thus defining a concept of inside and outside.  * <br>

	 * @return value of trajectoryCurve field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DParametricGeometryNode, $additionalInheritanceBaseType=, $thisClassName=NurbsSweptSurface, $CamelCaseName=TrajectoryCurve, $memberObjectName=trajectoryCurve, $memberObjectName=trajectoryCurve)
	public  org.web3d.x3d.sai.NURBS.NurbsCurve getTrajectoryCurve(); // acceptable node types #1: NurbsCurve

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.NURBS.NurbsCurve instance (using a properly typed node) to inputOutput SFNode field <i>trajectoryCurve</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [NurbsCurve] describes the center-line path using a NurbsCurve node, oriented so that it is defined counterclockwise when looking down the −Y axis, thus defining a concept of inside and outside.  * <br>

	 * @param newValue is new value for the trajectoryCurve field.
	 * @return {@link NurbsSweptSurface} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NurbsSweptSurface setTrajectoryCurve( org.web3d.x3d.sai.NURBS.NurbsCurve newValue); // acceptable node types #2: NurbsCurve

}
