/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.sai.DIS;
// import org.web3d.x3d.sai.Grouping.X3DBoundedObject;

import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
// import org.web3d.x3d.sai.Core.*;
// import org.web3d.x3d.sai.Core.*;

/**
 * SignalPdu is a networked Protocol Data Unit (PDU) information node that communicates the transmission of voice, audio or other data modeled in a simulation.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DNetworkSensorNode,X3DBoundedObject,X3DVisibleObject] SignalPdu is a networked Protocol Data Unit (PDU) information node that communicates the transmission of voice, audio or other data modeled in a simulation.
Hint: SignalPdu packets use the IEEE Distributed Interactive Simulation (DIS) protocol.
Hint: Savage Developers Guide on DIS &lt;a href="https://savage.nps.edu/Savage/developers.html#DIS" target="_blank"&gt;https://savage.nps.edu/Savage/developers.html#DIS&lt;/a&gt;
Hint: X3D for Advanced Modeling (X3D4AM) slideset &lt;a href="https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/DistributedInteractiveSimulation.pdf" target="_blank"&gt;https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/DistributedInteractiveSimulation.pdf&lt;/a&gt;
Warning: requires X3D profile='Full' or else include &amp;lt;component name='DIS' level='1'/&amp;gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This interface is defined by the X3D Java Language Binding Specification for the Scene Authoring Interface (SAI).
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/documents/specifications/19777-2/V3.3/Part2/concretes.html#SignalPdu" target="_blank">SAI Java Specification</a>
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/dis.html#SignalPdu" target="blank">X3D Abstract Specification: SignalPdu</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#SignalPdu" target="_blank">X3D Tooltips: SignalPdu</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public interface SignalPdu extends  org.web3d.x3d.sai.Networking.X3DNetworkSensorNode,  org.web3d.x3d.sai.Grouping.X3DBoundedObject
{
	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide String value from inputOutput SFString field named <i>address</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Multicast network address, or else 'localhost'. Example: 224.2.181.145.  * <br>

	 * @return value of address field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Address, $memberObjectName=address, $memberObjectName=address)
	public String getAddress();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>address</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Multicast network address, or else 'localhost'. Example: 224.2.181.145.  * <br>

	 * @param newValue is new value for the address field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setAddress(String newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>applicationID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Each simulation application that can respond to simulation management PDUs needs to have a unique applicationID.  * <br>

	 * @return value of applicationID field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=ApplicationID, $memberObjectName=applicationID, $memberObjectName=applicationID)
	public int getApplicationID();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>applicationID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Each simulation application that can respond to simulation management PDUs needs to have a unique applicationID.  * <br>

	 * @param newValue is new value for the applicationID field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setApplicationID(int newValue);

	/**
	 * Provide array of 3-tuple float results from initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxCenter field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=BboxCenter, $memberObjectName=bboxCenter, $memberObjectName=bboxCenter)

	public float[] getBboxCenter();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxCenter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Bounding box center accompanies bboxSize and provides an optional hint for bounding box position offset from origin of local coordinate system. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxCenter field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setBboxCenter(float[] newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @return value of bboxDisplay field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=BboxDisplay, $memberObjectName=bboxDisplay, $memberObjectName=bboxDisplay)

	public boolean getBboxDisplay();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>bboxDisplay</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether to display bounding box for associated geometry, aligned with world coordinates. Hint: the bounding box is displayed regardless of whether contained content is visible.  * <br>

	 * @param newValue is new value for the bboxDisplay field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setBboxDisplay(boolean newValue);

	/**
	 * Provide array of 3-tuple float results within allowed range of [0,infinity), or default value [-1 -1 -1], from initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @return value of bboxSize field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=BboxSize, $memberObjectName=bboxSize, $memberObjectName=bboxSize)

	public float[] getBboxSize();

	/**
	 * Accessor method to assign 3-tuple float array to initializeOnly SFVec3f field named <i>bboxSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  or [0,+infinity) Bounding box size is usually omitted, and can easily be calculated automatically by an X3D player at scene-loading time with minimal computational cost. Bounding box size can also be defined as an optional authoring hint that suggests an optimization or constraint. Hint: can be useful for collision computations or inverse-kinematics (IK) engines. Hint: precomputation and inclusion of bounding box information can speed up the initialization of large detailed models, with a corresponding cost of increased file size. Hint: X3D Architecture, 10.2.2 Bounding boxes &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#BoundingBoxes&lt;/a&gt; Hint: X3D Architecture, 10.3.1 X3DBoundedObject &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/grouping.html#X3DBoundedObject&lt;/a&gt;  * <br>

	 * @param newValue is new value for the bboxSize field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setBboxSize(float[] newValue);

	/**
	 * Provide array of int results from inputOutput MFInt32 field named <i>data</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Holds audio or digital data conveyed by the radio transmission. Interpretation of the field depends on values of encodingScheme and tdlType fields.  * <br>

	 * @return value of data field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Data, $memberObjectName=data, $memberObjectName=data)
	public int[] getData();

	/**
	 * Accessor method to assign int array to inputOutput MFInt32 field named <i>data</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Holds audio or digital data conveyed by the radio transmission. Interpretation of the field depends on values of encodingScheme and tdlType fields.  * <br>

	 * @param newValue is new value for the data field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setData(int[] newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>dataLength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  number of bits of digital voice audio or digital data being sent in the Signal PDU. If the Encoding Class is database index, then dataLength field is set to 96.  * <br>

	 * @return value of dataLength field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=DataLength, $memberObjectName=dataLength, $memberObjectName=dataLength)
	public int getDataLength();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>dataLength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  number of bits of digital voice audio or digital data being sent in the Signal PDU. If the Encoding Class is database index, then dataLength field is set to 96.  * <br>

	 * @param newValue is new value for the dataLength field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setDataLength(int newValue);

	/**
	 * Provide String value from inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @return value of description field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Description, $memberObjectName=description, $memberObjectName=description)

	public String getDescription();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>description</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Author-provided prose that describes intended purpose of the node. Hint: many XML tools substitute XML character references for special characters automatically if needed within an attribute value (such as &amp;#38; for &amp; ampersand character, or &amp;#34; for " quotation-mark character).  * <br>

	 * @param newValue is new value for the description field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setDescription(String newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables the sensor node.  * <br>

	 * @return value of enabled field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Enabled, $memberObjectName=enabled, $memberObjectName=enabled)

	public boolean getEnabled();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>enabled</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enables/disables the sensor node.  * <br>

	 * @param newValue is new value for the enabled field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setEnabled(boolean newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>encodingScheme</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  designates both Encoding Class and Encoding Type. Encoding Class enumerated value (2 most significant bits): 0 = Encoded Voice; 1 = Raw Binary Data; 2 = Application-Specific Data; 3 = Database Index. Encoding Type enumerated value (14 least significant bits): 1 = 8-bit mu-law; 2 = CVSD per MIL-STD-188-113; 3 = ADPCM per CCITT G.721; 4 = 16-bit linear PCM; 5 = 8-bit linear PCM; 6 = Vector Quantization.  * <br>

	 * @return value of encodingScheme field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=EncodingScheme, $memberObjectName=encodingScheme, $memberObjectName=encodingScheme)
	public int getEncodingScheme();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>encodingScheme</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  designates both Encoding Class and Encoding Type. Encoding Class enumerated value (2 most significant bits): 0 = Encoded Voice; 1 = Raw Binary Data; 2 = Application-Specific Data; 3 = Database Index. Encoding Type enumerated value (14 least significant bits): 1 = 8-bit mu-law; 2 = CVSD per MIL-STD-188-113; 3 = ADPCM per CCITT G.721; 4 = 16-bit linear PCM; 5 = 8-bit linear PCM; 6 = Vector Quantization.  * <br>

	 * @param newValue is new value for the encodingScheme field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setEncodingScheme(int newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>entityID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  EntityID unique ID for entity within that application.  * <br>

	 * @return value of entityID field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=EntityID, $memberObjectName=entityID, $memberObjectName=entityID)
	public int getEntityID();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>entityID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  EntityID unique ID for entity within that application.  * <br>

	 * @param newValue is new value for the entityID field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setEntityID(int newValue);

	/**
	 * Provide array of 3-tuple double results from inputOutput SFVec3d field named <i>geoCoords</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Geographic location (specified in current geoSystem coordinates) for children geometry (specified in relative coordinate system, in meters). Hint: X3D for Advanced Modeling (X3D4AM) slideset &lt;a href="https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf" target="_blank"&gt;https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf&lt;/a&gt; Warning: requires X3D profile='Full' or else include &amp;lt;component name='Geospatial' level='1'/&amp;gt;  * <br>

	 * @return value of geoCoords field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=GeoCoords, $memberObjectName=geoCoords, $memberObjectName=geoCoords)
	public double[] getGeoCoords();

	/**
	 * Accessor method to assign 3-tuple double array to inputOutput SFVec3d field named <i>geoCoords</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Geographic location (specified in current geoSystem coordinates) for children geometry (specified in relative coordinate system, in meters). Hint: X3D for Advanced Modeling (X3D4AM) slideset &lt;a href="https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf" target="_blank"&gt;https://x3dgraphics.com/slidesets/X3dForAdvancedModeling/GeospatialComponentX3dEarth.pdf&lt;/a&gt; Warning: requires X3D profile='Full' or else include &amp;lt;component name='Geospatial' level='1'/&amp;gt;  * <br>

	 * @param newValue is new value for the geoCoords field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setGeoCoords(double[] newValue);

	/**
	 * Provide array of String results from initializeOnly MFString field named <i>geoSystem</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Identifies spatial reference frame: Geodetic (GD), Geocentric (GC), Universal Transverse Mercator (UTM). Supported values: "GD" "UTM" or "GC" followed by additional quoted string parameters as appropriate for the type. Hint: X3D Architecture 25.2.2 Spatial reference frames &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Spatialreferenceframes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Spatialreferenceframes&lt;/a&gt; Hint: X3D Architecture 25.2.4 Specifying geospatial coordinates &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Specifyinggeospatialcoords" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Specifyinggeospatialcoords&lt;/a&gt; Hint: UTM is Universal Transverse Mercator coordinate system &lt;a href="https://en.wikipedia.org/wiki/Universal_Transverse_Mercator_coordinate_system" target="_blank"&gt;https://en.wikipedia.org/wiki/Universal_Transverse_Mercator_coordinate_system&lt;/a&gt; Warning: deprecated values are GDC (replaced by GD) and GCC (replaced by GC).  * <br>

	 * @return value of geoSystem field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=GeoSystem, $memberObjectName=geoSystem, $memberObjectName=geoSystem)
	public String[] getGeoSystem();

	/**
	 * Accessor method to assign String array to initializeOnly MFString field named <i>geoSystem</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Identifies spatial reference frame: Geodetic (GD), Geocentric (GC), Universal Transverse Mercator (UTM). Supported values: "GD" "UTM" or "GC" followed by additional quoted string parameters as appropriate for the type. Hint: X3D Architecture 25.2.2 Spatial reference frames &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Spatialreferenceframes" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Spatialreferenceframes&lt;/a&gt; Hint: X3D Architecture 25.2.4 Specifying geospatial coordinates &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Specifyinggeospatialcoords" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/geospatial.html#Specifyinggeospatialcoords&lt;/a&gt; Hint: UTM is Universal Transverse Mercator coordinate system &lt;a href="https://en.wikipedia.org/wiki/Universal_Transverse_Mercator_coordinate_system" target="_blank"&gt;https://en.wikipedia.org/wiki/Universal_Transverse_Mercator_coordinate_system&lt;/a&gt; Warning: deprecated values are GDC (replaced by GD) and GCC (replaced by GC).  * <br>

	 * @param newValue is new value for the geoSystem field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setGeoSystem(String[] newValue);

	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isActive</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  confirm whether there has been a recent network update. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isActive field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=IsActive, $memberObjectName=isActive, $memberObjectName=isActive)

	public boolean getIsActive();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isNetworkReader</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether networkMode='remote' (listen to network as copy of remote entity). Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isNetworkReader field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=IsNetworkReader, $memberObjectName=isNetworkReader, $memberObjectName=isNetworkReader)
	public boolean getIsNetworkReader();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isNetworkWriter</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether networkMode='master' (output to network as master entity at writeInterval). Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isNetworkWriter field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=IsNetworkWriter, $memberObjectName=isNetworkWriter, $memberObjectName=isNetworkWriter)
	public boolean getIsNetworkWriter();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isRtpHeaderHeard</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether incoming DIS packets have an RTP header prepended. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isRtpHeaderHeard field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=IsRtpHeaderHeard, $memberObjectName=isRtpHeaderHeard, $memberObjectName=isRtpHeaderHeard)
	public boolean getIsRtpHeaderHeard();
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isStandAlone</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether networkMode='local' (ignore network but still respond to local events). Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isStandAlone field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=IsStandAlone, $memberObjectName=isStandAlone, $memberObjectName=isStandAlone)
	public boolean getIsStandAlone();
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata(); // acceptable node types #1: X3DMetadataObject

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue); // acceptable node types #2: X3DMetadataObject

	/**
	 * Provide String value from inputOutput SFString field named <i>multicastRelayHost</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Fallback server address if multicast not available locally. For example: track.nps.edu.  * <br>

	 * @return value of multicastRelayHost field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=MulticastRelayHost, $memberObjectName=multicastRelayHost, $memberObjectName=multicastRelayHost)
	public String getMulticastRelayHost();

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>multicastRelayHost</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Fallback server address if multicast not available locally. For example: track.nps.edu.  * <br>

	 * @param newValue is new value for the multicastRelayHost field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setMulticastRelayHost(String newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>multicastRelayPort</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Fallback server port if multicast not available locally. For example: 8010.  * <br>

	 * @return value of multicastRelayPort field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=MulticastRelayPort, $memberObjectName=multicastRelayPort, $memberObjectName=multicastRelayPort)
	public int getMulticastRelayPort();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>multicastRelayPort</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Fallback server port if multicast not available locally. For example: 8010.  * <br>

	 * @param newValue is new value for the multicastRelayPort field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setMulticastRelayPort(int newValue);

	/**
	 * Provide String enumeration value (baseType xs:NMTOKEN) ["standAlone" | "networkReader" | "networkWriter"] from inputOutput SFString field named <i>networkMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether this entity is ignoring the network, sending DIS packets to the network, or receiving DIS packets from the network. (1) standAlone: ignore network but still respond to events in local scene. (2) networkReader: listen to network and read PDU packets at readInterval, act as remotely linked copy of entity. (3) networkWriter: send PDU packets to network at writeInterval, act as master entity. Default value "standAlone" ensures that DIS network activation within a scene as networkReader or networkWriter is intentional. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Warning: network activity may have associated security issues.  * <br>

	 * @return value of networkMode field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=NetworkMode, $memberObjectName=networkMode, $memberObjectName=networkMode)
	public String getNetworkMode();

	/**
	 * Accessor method to assign String enumeration value ("standAlone" | "networkReader" | "networkWriter") to inputOutput SFString field named <i>networkMode</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether this entity is ignoring the network, sending DIS packets to the network, or receiving DIS packets from the network. (1) standAlone: ignore network but still respond to events in local scene. (2) networkReader: listen to network and read PDU packets at readInterval, act as remotely linked copy of entity. (3) networkWriter: send PDU packets to network at writeInterval, act as master entity. Default value "standAlone" ensures that DIS network activation within a scene as networkReader or networkWriter is intentional. Warning: do not wrap extra quotation marks around these SFString enumeration values, since "quotation" "marks" are only used for MFString values. Warning: network activity may have associated security issues.  * <br>

	 * @param newValue is new value for the networkMode field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setNetworkMode(String newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>port</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Multicast network port, for example: 3000.  * <br>

	 * @return value of port field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Port, $memberObjectName=port, $memberObjectName=port)
	public int getPort();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>port</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Multicast network port, for example: 3000.  * <br>

	 * @param newValue is new value for the port field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setPort(int newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>radioID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Identifies a particular radio within a given entity.  * <br>

	 * @return value of radioID field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=RadioID, $memberObjectName=radioID, $memberObjectName=radioID)
	public int getRadioID();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>radioID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Identifies a particular radio within a given entity.  * <br>

	 * @param newValue is new value for the radioID field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setRadioID(int newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>readInterval</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Seconds between read updates, 0 means no reading. Hint: readInterval is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of readInterval field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=ReadInterval, $memberObjectName=readInterval, $memberObjectName=readInterval)
	public double getReadInterval();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>readInterval</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Seconds between read updates, 0 means no reading. Hint: readInterval is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the readInterval field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setReadInterval(double newValue);

	/**
	 * Provide boolean value from inputOutput SFBool field named <i>rtpHeaderExpected</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether RTP headers are prepended to DIS PDUs.  * <br>

	 * @return value of rtpHeaderExpected field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=RtpHeaderExpected, $memberObjectName=rtpHeaderExpected, $memberObjectName=rtpHeaderExpected)
	public boolean getRtpHeaderExpected();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>rtpHeaderExpected</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether RTP headers are prepended to DIS PDUs.  * <br>

	 * @param newValue is new value for the rtpHeaderExpected field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setRtpHeaderExpected(boolean newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>sampleRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  sampleRate gives either (1) sample rate in samples per second if Encoding Class is encoded audio, or (2) data rate in bits per second for data transmissions. If Encoding Class is database index, sampleRate is set to zero. Hint: Wikipedia Nyquist frequency &lt;a href="https://en.wikipedia.org/wiki/Nyquist_frequency" target="_blank"&gt;https://en.wikipedia.org/wiki/Nyquist_frequency&lt;/a&gt;  * <br>

	 * @return value of sampleRate field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=SampleRate, $memberObjectName=sampleRate, $memberObjectName=sampleRate)
	public int getSampleRate();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>sampleRate</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  sampleRate gives either (1) sample rate in samples per second if Encoding Class is encoded audio, or (2) data rate in bits per second for data transmissions. If Encoding Class is database index, sampleRate is set to zero. Hint: Wikipedia Nyquist frequency &lt;a href="https://en.wikipedia.org/wiki/Nyquist_frequency" target="_blank"&gt;https://en.wikipedia.org/wiki/Nyquist_frequency&lt;/a&gt;  * <br>

	 * @param newValue is new value for the sampleRate field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setSampleRate(int newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>samples</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Number of samples in the PDU if the Encoding Class is encoded voice, otherwise the field is set to zero.  * <br>

	 * @return value of samples field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Samples, $memberObjectName=samples, $memberObjectName=samples)
	public int getSamples();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>samples</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Number of samples in the PDU if the Encoding Class is encoded voice, otherwise the field is set to zero.  * <br>

	 * @param newValue is new value for the samples field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setSamples(int newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>siteID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Simulation/exercise siteID of the participating LAN or organization.  * <br>

	 * @return value of siteID field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=SiteID, $memberObjectName=siteID, $memberObjectName=siteID)
	public int getSiteID();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>siteID</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Simulation/exercise siteID of the participating LAN or organization.  * <br>

	 * @param newValue is new value for the siteID field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setSiteID(int newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>tdlType</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Tactical Data Link (TDL) type as an enumerated value when the Encoding Class is voice, raw binary, application-specific, or database index representation of a TDL message.  * <br>

	 * @return value of tdlType field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=TdlType, $memberObjectName=tdlType, $memberObjectName=tdlType)
	public int getTdlType();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>tdlType</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Tactical Data Link (TDL) type as an enumerated value when the Encoding Class is voice, raw binary, application-specific, or database index representation of a TDL message.  * <br>

	 * @param newValue is new value for the tdlType field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setTdlType(int newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from outputOnly SFTime field named <i>timestamp</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DIS timestamp in X3D units (value 0.0 matches 1 January 1970) in seconds. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of timestamp field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Timestamp, $memberObjectName=timestamp, $memberObjectName=timestamp)
	public double getTimestamp();
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @return value of visible field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=Visible, $memberObjectName=visible, $memberObjectName=visible)

	public boolean getVisible();

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>visible</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Whether or not renderable content within this node is visually displayed. Hint: the visible field has no effect on animation behaviors, event passing or other non-visual characteristics. Hint: content must be visible to be collidable and to be pickable.  * <br>

	 * @param newValue is new value for the visible field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public SignalPdu setVisible(boolean newValue);

	/**
	 * Provide int value from inputOutput SFInt32 field named <i>whichGeometry</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Select geometry to render: -1 for no geometry, 0 for text trace, 1 for default geometry, (optional) higher values to render different states.  * <br>

	 * @return value of whichGeometry field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=WhichGeometry, $memberObjectName=whichGeometry, $memberObjectName=whichGeometry)
	public int getWhichGeometry();

	/**
	 * Accessor method to assign int value to inputOutput SFInt32 field named <i>whichGeometry</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Select geometry to render: -1 for no geometry, 0 for text trace, 1 for default geometry, (optional) higher values to render different states.  * <br>

	 * @param newValue is new value for the whichGeometry field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setWhichGeometry(int newValue);

	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>writeInterval</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Seconds between write updates, 0 means no writing (sending). Hint: writeInterval is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @return value of writeInterval field
	 */
	// ($isInterface=true, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DNetworkSensorNode, $additionalInheritanceBaseType=X3DBoundedObject, $thisClassName=SignalPdu, $CamelCaseName=WriteInterval, $memberObjectName=writeInterval, $memberObjectName=writeInterval)
	public double getWriteInterval();

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>writeInterval</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Seconds between write updates, 0 means no writing (sending). Hint: writeInterval is a nonnegative SFTime duration interval, not an absolute clock time.  * <br>

	 * @param newValue is new value for the writeInterval field.
	 * @return {@link SignalPdu} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public SignalPdu setWriteInterval(double newValue);

}
