/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Shape;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;
// import org.web3d.x3d.jsail.Shape.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Texturing.*;

/**
 * PhysicalMaterial specifies surface rendering properties for associated geometry nodes.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  (X3D version 4.0 draft) [X3DOneSidedMaterialNode] PhysicalMaterial specifies surface rendering properties for associated geometry nodes.
Material attributes are used by the X3D lighting equations during rendering.
Hint: insert Shape and Appearance nodes before adding material.
Hint: DEF/USE copies of a single node can provide a similar "look + feel" style for related shapes in a scene.
Hint: X3D Scene Authoring Hints, Color &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Color&lt;/a&gt;
Hint: X3D Example Archives, Basic, Universal Media Materials &lt;a href="https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials&lt;/a&gt;
Hint: X3D Architecture 17.2.2 Lighting model &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/lighting.html#Lightingmodel&lt;/a&gt;
Hint: Rendering &lt;a href="https://en.wikipedia.org/wiki/Rendering_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Rendering_(computer_graphics)&lt;/a&gt;
Hint: 3D rendering &lt;a href="https://en.wikipedia.org/wiki/3D_rendering" target="_blank"&gt;https://en.wikipedia.org/wiki/3D_rendering&lt;/a&gt;
Hint: Physically based rendering (PBR) &lt;a href="https://en.wikipedia.org/wiki/Physically_based_rendering" target="_blank"&gt;https://en.wikipedia.org/wiki/Physically_based_rendering&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * Note that {@linkplain SFColor#ALICEBLUE SFColor} provides a variety of color constants.
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/shape.html#PhysicalMaterial" target="blank">X3D Abstract Specification: PhysicalMaterial</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#PhysicalMaterial" target="_blank">X3D Tooltips: PhysicalMaterial</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 */
public class PhysicalMaterial extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Shape.PhysicalMaterial
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=baseColor, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=baseColor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] baseColor; //  X3D field type: SFColor

    /* @name=baseTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=baseTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode baseTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance baseTextureProtoInstance; // allowed alternative for baseTexture field

    /* @name=baseTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=baseTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String baseTextureMapping = new String(); //  X3D field type: SFString

    /* @name=emissiveColor, @type=SFColor, $javaType=float[], $javaReferenceType=float[], $javaPrimitiveType=float[], $normalizedMemberObjectName=emissiveColor, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float[] emissiveColor; //  X3D field type: SFColor

    /* @name=emissiveTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=emissiveTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode emissiveTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance emissiveTextureProtoInstance; // allowed alternative for emissiveTexture field

    /* @name=emissiveTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=emissiveTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String emissiveTextureMapping = new String(); //  X3D field type: SFString

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=metallic, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=metallic, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float metallic; //  X3D field type: SFFloat

    /* @name=metallicRoughnessTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=metallicRoughnessTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode metallicRoughnessTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance metallicRoughnessTextureProtoInstance; // allowed alternative for metallicRoughnessTexture field

    /* @name=metallicRoughnessTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=metallicRoughnessTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String metallicRoughnessTextureMapping = new String(); //  X3D field type: SFString

    /* @name=normalScale, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=normalScale, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float normalScale; //  X3D field type: SFFloat

    /* @name=normalTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=normalTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode normalTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance normalTextureProtoInstance; // allowed alternative for normalTexture field

    /* @name=normalTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=normalTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String normalTextureMapping = new String(); //  X3D field type: SFString

    /* @name=occlusionStrength, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=occlusionStrength, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float occlusionStrength; //  X3D field type: SFFloat

    /* @name=occlusionTexture, @type=SFNode, $javaType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaReferenceType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $javaPrimitiveType= org.web3d.x3d.sai.Texturing.X3DSingleTextureNode, $normalizedMemberObjectName=occlusionTexture, $isX3dStatement=false, @acceptableNodeTypes=X3DSingleTextureNode */ 
    private  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode occlusionTexture; //  X3D field type: SFNode acceptable node types: X3DSingleTextureNode or ProtoInstance
	private ProtoInstance occlusionTextureProtoInstance; // allowed alternative for occlusionTexture field

    /* @name=occlusionTextureMapping, @type=SFString, $javaType=String, $javaReferenceType=String, $javaPrimitiveType=String, $normalizedMemberObjectName=occlusionTextureMapping, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private String occlusionTextureMapping = new String(); //  X3D field type: SFString

    /* @name=roughness, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=roughness, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float roughness; //  X3D field type: SFFloat

    /* @name=transparency, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=transparency, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float transparency; //  X3D field type: SFFloat

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>PhysicalMaterial</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "PhysicalMaterial";

	/** Provides name of this element: <i>PhysicalMaterial</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>PhysicalMaterial</i> element: <i>Shape</i> */
	public static final String COMPONENT = "Shape";

	/** Defines X3D component for the <i>PhysicalMaterial</i> element: <i>Shape</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Shape</i> component level for this element: <i>2</i> */
	public static final int LEVEL = 2;

	/** Provides default X3D component level for this element: <i>2</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** SFColor field named <i>baseColor</i> has default value <i>{1f,1f,1f}</i> (Java syntax) or <i>1 1 1</i> (XML syntax). */
	public static final float[] BASECOLOR_DEFAULT_VALUE = {1f,1f,1f};

	/** SFNode field named <i>baseTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode BASETEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>baseTextureMapping</i> has default value equal to an empty string. */
	public static final String BASETEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFColor field named <i>emissiveColor</i> has default value <i>{0f,0f,0f}</i> (Java syntax) or <i>0 0 0</i> (XML syntax). */
	public static final float[] EMISSIVECOLOR_DEFAULT_VALUE = {0f,0f,0f};

	/** SFNode field named <i>emissiveTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode EMISSIVETEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>emissiveTextureMapping</i> has default value equal to an empty string. */
	public static final String EMISSIVETEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFFloat field named <i>metallic</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float METALLIC_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>metallicRoughnessTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode METALLICROUGHNESSTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>metallicRoughnessTextureMapping</i> has default value equal to an empty string. */
	public static final String METALLICROUGHNESSTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>normalScale</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float NORMALSCALE_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>normalTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode NORMALTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>normalTextureMapping</i> has default value equal to an empty string. */
	public static final String NORMALTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>occlusionStrength</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float OCCLUSIONSTRENGTH_DEFAULT_VALUE = 1f;

	/** SFNode field named <i>occlusionTexture</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode OCCLUSIONTEXTURE_DEFAULT_VALUE = null;

	/** SFString field named <i>occlusionTextureMapping</i> has default value equal to an empty string. */
	public static final String OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE = "";

	/** SFFloat field named <i>roughness</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float ROUGHNESS_DEFAULT_VALUE = 1f;

	/** SFFloat field named <i>transparency</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float TRANSPARENCY_DEFAULT_VALUE = 0f;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "baseColor":
				result = "SFColor";
				break;
			case "baseTexture":
				result = "SFNode";
				break;
			case "baseTextureMapping":
				result = "SFString";
				break;
			case "emissiveColor":
				result = "SFColor";
				break;
			case "emissiveTexture":
				result = "SFNode";
				break;
			case "emissiveTextureMapping":
				result = "SFString";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "metallic":
				result = "SFFloat";
				break;
			case "metallicRoughnessTexture":
				result = "SFNode";
				break;
			case "metallicRoughnessTextureMapping":
				result = "SFString";
				break;
			case "normalScale":
				result = "SFFloat";
				break;
			case "normalTexture":
				result = "SFNode";
				break;
			case "normalTextureMapping":
				result = "SFString";
				break;
			case "occlusionStrength":
				result = "SFFloat";
				break;
			case "occlusionTexture":
				result = "SFNode";
				break;
			case "occlusionTextureMapping":
				result = "SFString";
				break;
			case "roughness":
				result = "SFFloat";
				break;
			case "transparency":
				result = "SFFloat";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "baseColor":
				result = "inputOutput";
				break;
			case "baseTexture":
				result = "inputOutput";
				break;
			case "baseTextureMapping":
				result = "inputOutput";
				break;
			case "emissiveColor":
				result = "inputOutput";
				break;
			case "emissiveTexture":
				result = "inputOutput";
				break;
			case "emissiveTextureMapping":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "metallic":
				result = "inputOutput";
				break;
			case "metallicRoughnessTexture":
				result = "inputOutput";
				break;
			case "metallicRoughnessTextureMapping":
				result = "inputOutput";
				break;
			case "normalScale":
				result = "inputOutput";
				break;
			case "normalTexture":
				result = "inputOutput";
				break;
			case "normalTextureMapping":
				result = "inputOutput";
				break;
			case "occlusionStrength":
				result = "inputOutput";
				break;
			case "occlusionTexture":
				result = "inputOutput";
				break;
			case "occlusionTextureMapping":
				result = "inputOutput";
				break;
			case "roughness":
				result = "inputOutput";
				break;
			case "transparency":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "material"; // type xs:NMTOKEN
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for SFColor field named <i>baseColor</i>. */
	public static final String fromField_BASECOLOR = "baseColor";

	/** toField ROUTE name for SFColor field named <i>baseColor</i>. */
	public static final String toField_BASECOLOR = "baseColor";

	/** fromField ROUTE name for SFNode field named <i>baseTexture</i>. */
	public static final String fromField_BASETEXTURE = "baseTexture";

	/** toField ROUTE name for SFNode field named <i>baseTexture</i>. */
	public static final String toField_BASETEXTURE = "baseTexture";

	/** fromField ROUTE name for SFString field named <i>baseTextureMapping</i>. */
	public static final String fromField_BASETEXTUREMAPPING = "baseTextureMapping";

	/** toField ROUTE name for SFString field named <i>baseTextureMapping</i>. */
	public static final String toField_BASETEXTUREMAPPING = "baseTextureMapping";

	/** fromField ROUTE name for SFColor field named <i>emissiveColor</i>. */
	public static final String fromField_EMISSIVECOLOR = "emissiveColor";

	/** toField ROUTE name for SFColor field named <i>emissiveColor</i>. */
	public static final String toField_EMISSIVECOLOR = "emissiveColor";

	/** fromField ROUTE name for SFNode field named <i>emissiveTexture</i>. */
	public static final String fromField_EMISSIVETEXTURE = "emissiveTexture";

	/** toField ROUTE name for SFNode field named <i>emissiveTexture</i>. */
	public static final String toField_EMISSIVETEXTURE = "emissiveTexture";

	/** fromField ROUTE name for SFString field named <i>emissiveTextureMapping</i>. */
	public static final String fromField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";

	/** toField ROUTE name for SFString field named <i>emissiveTextureMapping</i>. */
	public static final String toField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** fromField ROUTE name for SFFloat field named <i>metallic</i>. */
	public static final String fromField_METALLIC = "metallic";

	/** toField ROUTE name for SFFloat field named <i>metallic</i>. */
	public static final String toField_METALLIC = "metallic";

	/** fromField ROUTE name for SFNode field named <i>metallicRoughnessTexture</i>. */
	public static final String fromField_METALLICROUGHNESSTEXTURE = "metallicRoughnessTexture";

	/** toField ROUTE name for SFNode field named <i>metallicRoughnessTexture</i>. */
	public static final String toField_METALLICROUGHNESSTEXTURE = "metallicRoughnessTexture";

	/** fromField ROUTE name for SFString field named <i>metallicRoughnessTextureMapping</i>. */
	public static final String fromField_METALLICROUGHNESSTEXTUREMAPPING = "metallicRoughnessTextureMapping";

	/** toField ROUTE name for SFString field named <i>metallicRoughnessTextureMapping</i>. */
	public static final String toField_METALLICROUGHNESSTEXTUREMAPPING = "metallicRoughnessTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>normalScale</i>. */
	public static final String fromField_NORMALSCALE = "normalScale";

	/** toField ROUTE name for SFFloat field named <i>normalScale</i>. */
	public static final String toField_NORMALSCALE = "normalScale";

	/** fromField ROUTE name for SFNode field named <i>normalTexture</i>. */
	public static final String fromField_NORMALTEXTURE = "normalTexture";

	/** toField ROUTE name for SFNode field named <i>normalTexture</i>. */
	public static final String toField_NORMALTEXTURE = "normalTexture";

	/** fromField ROUTE name for SFString field named <i>normalTextureMapping</i>. */
	public static final String fromField_NORMALTEXTUREMAPPING = "normalTextureMapping";

	/** toField ROUTE name for SFString field named <i>normalTextureMapping</i>. */
	public static final String toField_NORMALTEXTUREMAPPING = "normalTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>occlusionStrength</i>. */
	public static final String fromField_OCCLUSIONSTRENGTH = "occlusionStrength";

	/** toField ROUTE name for SFFloat field named <i>occlusionStrength</i>. */
	public static final String toField_OCCLUSIONSTRENGTH = "occlusionStrength";

	/** fromField ROUTE name for SFNode field named <i>occlusionTexture</i>. */
	public static final String fromField_OCCLUSIONTEXTURE = "occlusionTexture";

	/** toField ROUTE name for SFNode field named <i>occlusionTexture</i>. */
	public static final String toField_OCCLUSIONTEXTURE = "occlusionTexture";

	/** fromField ROUTE name for SFString field named <i>occlusionTextureMapping</i>. */
	public static final String fromField_OCCLUSIONTEXTUREMAPPING = "occlusionTextureMapping";

	/** toField ROUTE name for SFString field named <i>occlusionTextureMapping</i>. */
	public static final String toField_OCCLUSIONTEXTUREMAPPING = "occlusionTextureMapping";

	/** fromField ROUTE name for SFFloat field named <i>roughness</i>. */
	public static final String fromField_ROUGHNESS = "roughness";

	/** toField ROUTE name for SFFloat field named <i>roughness</i>. */
	public static final String toField_ROUGHNESS = "roughness";

	/** fromField ROUTE name for SFFloat field named <i>transparency</i>. */
	public static final String fromField_TRANSPARENCY = "transparency";

	/** toField ROUTE name for SFFloat field named <i>transparency</i>. */
	public static final String toField_TRANSPARENCY = "transparency";

	/** Constructor for PhysicalMaterial to initialize member variables with default values. */
	public PhysicalMaterial()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "material" }; // type xs:NMTOKEN

		baseColor = BASECOLOR_DEFAULT_VALUE;
		baseTexture = null;              // clear out any prior node
		baseTextureProtoInstance = null; // clear out any prior node
		baseTextureMapping = BASETEXTUREMAPPING_DEFAULT_VALUE;
		emissiveColor = EMISSIVECOLOR_DEFAULT_VALUE;
		emissiveTexture = null;              // clear out any prior node
		emissiveTextureProtoInstance = null; // clear out any prior node
		emissiveTextureMapping = EMISSIVETEXTUREMAPPING_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		metallic = METALLIC_DEFAULT_VALUE;
		metallicRoughnessTexture = null;              // clear out any prior node
		metallicRoughnessTextureProtoInstance = null; // clear out any prior node
		metallicRoughnessTextureMapping = METALLICROUGHNESSTEXTUREMAPPING_DEFAULT_VALUE;
		normalScale = NORMALSCALE_DEFAULT_VALUE;
		normalTexture = null;              // clear out any prior node
		normalTextureProtoInstance = null; // clear out any prior node
		normalTextureMapping = NORMALTEXTUREMAPPING_DEFAULT_VALUE;
		occlusionStrength = OCCLUSIONSTRENGTH_DEFAULT_VALUE;
		occlusionTexture = null;              // clear out any prior node
		occlusionTextureProtoInstance = null; // clear out any prior node
		occlusionTextureMapping = OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE;
		roughness = ROUGHNESS_DEFAULT_VALUE;
		transparency = TRANSPARENCY_DEFAULT_VALUE;

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>baseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] similar to diffuseColor, TODO define more precisely.  * <br>

	 * @return value of baseColor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseColor, $memberObjectName=baseColor, $memberObjectName=baseColor)

	public float[] getBaseColor()
	{
		return baseColor;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>baseColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] similar to diffuseColor, TODO define more precisely.  * <br>

	 * @param newValue is new value for the baseColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setBaseColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial baseColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial baseColor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial baseColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		baseColor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor baseColor field, similar to {@link #setBaseColor(float[])}.
	 * @param newValue is new value for the baseColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setBaseColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor baseColor field, similar to {@link #setBaseColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseColor(float red, float green, float blue)
	{
		setBaseColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setBaseColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseColor(double red, double green, double blue)
	{
		return setBaseColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setBaseColor(float[])}.
	 * @param newArray is new value for field                  
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseColor(double[] newArray)
	{
		return setBaseColor(new SFColor(newArray));
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>baseTexture</i>.
	 * @see #getBaseTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying baseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='baseTexture'.  * <br>

	 * @return value of baseTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseTexture, $memberObjectName=baseTexture, $memberObjectName=baseTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getBaseTexture()
	{
		return baseTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>baseTexture</i>.
	 * @see #setBaseTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying baseColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='baseTexture'.  * <br>

	 * @param newValue is new value for the baseTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setBaseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		baseTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) baseTexture).setParent(this); // parentTest15.1
		}
		if (baseTextureProtoInstance != null)
		{
			baseTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			baseTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of baseTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearBaseTexture()
	{
		((X3DConcreteElement) baseTexture).clearParent(); // remove references to facilitate Java memory management
		baseTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>baseTexture</i>.
	 * @see #setBaseTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the baseTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseTexture(ProtoInstance newValue)
	{
		if (baseTextureProtoInstance != null)
		{
			((X3DConcreteElement) baseTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		baseTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) baseTextureProtoInstance).setParent(this); // parentTest15.6
            baseTextureProtoInstance.setContainerField("baseTexture");
	    }
		if (baseTexture != null)
		{
			((X3DConcreteElement) baseTexture).setParent(null); // housekeeping, clear prior object
			baseTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getBaseTextureProtoInstance()
		{
			return baseTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>baseTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getBaseTexture()
	 * @see #getBaseTextureProtoInstance()
	 */
	public boolean hasBaseTexture()
	{
		return (baseTexture != null) || (baseTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>baseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of baseTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=BaseTextureMapping, $memberObjectName=baseTextureMapping, $memberObjectName=baseTextureMapping)

	public String getBaseTextureMapping()
	{
		return baseTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>baseTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the baseTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setBaseTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		baseTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString baseTextureMapping field, similar to {@link #setBaseTextureMapping(String)}.
	 * @param newValue is new value for the baseTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setBaseTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setBaseTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of 3-tuple float results using RGB values [0..1] using RGB values [0..1] from inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much glowing light is emitted from this object. Hint: emissiveColors glow even when all lights are off. Hint: reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet. Warning: bright emissiveColor values can wash out other colors and some textures.  * <br>

	 * @return value of emissiveColor field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveColor, $memberObjectName=emissiveColor, $memberObjectName=emissiveColor)

	public float[] getEmissiveColor()
	{
		return emissiveColor;
	}

	/**
	 * Accessor method to assign 3-tuple float array using RGB values [0..1] to inputOutput SFColor field named <i>emissiveColor</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how much glowing light is emitted from this object. Hint: emissiveColors glow even when all lights are off. Hint: reset diffuseColor from default (.8 .8 .8) to (0 0 0) to avoid washout. Hint: only emissiveColor affects IndexedLineSet, LineSet and PointSet. Warning: bright emissiveColor values can wash out other colors and some textures.  * <br>

	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setEmissiveColor(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new float[0];
		// Check that newValue parameter has legal size before assigning to scene graph
		if (newValue.length != 3) // 3-tuple check
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial emissiveColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
		}
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if ((newValue[0] < 0) || (newValue[1] < 0) || (newValue[2] < 0)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial emissiveColor newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if ((newValue[0] > 1f) || (newValue[1] > 1f) || (newValue[2] > 1f)) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial emissiveColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		emissiveColor = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFColor emissiveColor field, similar to {@link #setEmissiveColor(float[])}.
	 * @param newValue is new value for the emissiveColor field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveColor(SFColor newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEmissiveColor(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Assign values to SFColor emissiveColor field, similar to {@link #setEmissiveColor(float[])}.

	 * @param red first component
	 * @param green second component
	 * @param blue third component

	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveColor(float red, float green, float blue)
	{
		setEmissiveColor(new float[] {red, green, blue});
		return this;
	}

	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setEmissiveColor(float[])}.
	 * @param red first component [0..1]
	 * @param green second component [0..1]
	 * @param blue third component [0..1]
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveColor(double red, double green, double blue)
	{
		return setEmissiveColor((float) red, (float) green, (float) blue);
	}
	/**
	 * Utility method: double-precision set-parameters accessor for X3D floating-point type, similar to {@link #setEmissiveColor(float[])}.
	 * @param newArray is new value for field                  
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveColor(double[] newArray)
	{
		return setEmissiveColor(new SFColor(newArray));
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #getEmissiveTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='emissiveTexture'.  * <br>

	 * @return value of emissiveTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveTexture, $memberObjectName=emissiveTexture, $memberObjectName=emissiveTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getEmissiveTexture()
	{
		return emissiveTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #setEmissiveTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying emissiveColor for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='emissiveTexture'.  * <br>

	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		emissiveTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) emissiveTexture).setParent(this); // parentTest15.1
		}
		if (emissiveTextureProtoInstance != null)
		{
			emissiveTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			emissiveTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of emissiveTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearEmissiveTexture()
	{
		((X3DConcreteElement) emissiveTexture).clearParent(); // remove references to facilitate Java memory management
		emissiveTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>emissiveTexture</i>.
	 * @see #setEmissiveTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the emissiveTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveTexture(ProtoInstance newValue)
	{
		if (emissiveTextureProtoInstance != null)
		{
			((X3DConcreteElement) emissiveTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		emissiveTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) emissiveTextureProtoInstance).setParent(this); // parentTest15.6
            emissiveTextureProtoInstance.setContainerField("emissiveTexture");
	    }
		if (emissiveTexture != null)
		{
			((X3DConcreteElement) emissiveTexture).setParent(null); // housekeeping, clear prior object
			emissiveTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getEmissiveTextureProtoInstance()
		{
			return emissiveTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>emissiveTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getEmissiveTexture()
	 * @see #getEmissiveTextureProtoInstance()
	 */
	public boolean hasEmissiveTexture()
	{
		return (emissiveTexture != null) || (emissiveTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of emissiveTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=EmissiveTextureMapping, $memberObjectName=emissiveTextureMapping, $memberObjectName=emissiveTextureMapping)

	public String getEmissiveTextureMapping()
	{
		return emissiveTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>emissiveTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setEmissiveTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		emissiveTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString emissiveTextureMapping field, similar to {@link #setEmissiveTextureMapping(String)}.
	 * @param newValue is new value for the emissiveTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setEmissiveTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setEmissiveTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public PhysicalMaterial setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>metallic</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] metallic is a PBR parameter (TODO elaborate).  * <br>

	 * @return value of metallic field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Metallic, $memberObjectName=metallic, $memberObjectName=metallic)

	public float getMetallic()
	{
		return metallic;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>metallic</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] metallic is a PBR parameter (TODO elaborate).  * <br>

	 * @param newValue is new value for the metallic field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setMetallic(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial metallic newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial metallic newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		metallic = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat metallic field, similar to {@link #setMetallic(float)}.
	 * @param newValue is new value for the metallic field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallic(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setMetallic(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setMetallic(float)}.
	 * @param newValue is new value for field
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallic(double newValue)
	{
		return setMetallic((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * @see #getMetallicRoughnessTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying metallic for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='metallicRoughnessTexture'.  * <br>

	 * @return value of metallicRoughnessTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=MetallicRoughnessTexture, $memberObjectName=metallicRoughnessTexture, $memberObjectName=metallicRoughnessTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getMetallicRoughnessTexture()
	{
		return metallicRoughnessTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * @see #setMetallicRoughnessTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying metallic for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='metallicRoughnessTexture'.  * <br>

	 * @param newValue is new value for the metallicRoughnessTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setMetallicRoughnessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		metallicRoughnessTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metallicRoughnessTexture).setParent(this); // parentTest15.1
		}
		if (metallicRoughnessTextureProtoInstance != null)
		{
			metallicRoughnessTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			metallicRoughnessTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metallicRoughnessTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearMetallicRoughnessTexture()
	{
		((X3DConcreteElement) metallicRoughnessTexture).clearParent(); // remove references to facilitate Java memory management
		metallicRoughnessTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * @see #setMetallicRoughnessTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the metallicRoughnessTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallicRoughnessTexture(ProtoInstance newValue)
	{
		if (metallicRoughnessTextureProtoInstance != null)
		{
			((X3DConcreteElement) metallicRoughnessTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		metallicRoughnessTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metallicRoughnessTextureProtoInstance).setParent(this); // parentTest15.6
            metallicRoughnessTextureProtoInstance.setContainerField("metallicRoughnessTexture");
	    }
		if (metallicRoughnessTexture != null)
		{
			((X3DConcreteElement) metallicRoughnessTexture).setParent(null); // housekeeping, clear prior object
			metallicRoughnessTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetallicRoughnessTextureProtoInstance()
		{
			return metallicRoughnessTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metallicRoughnessTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetallicRoughnessTexture()
	 * @see #getMetallicRoughnessTextureProtoInstance()
	 */
	public boolean hasMetallicRoughnessTexture()
	{
		return (metallicRoughnessTexture != null) || (metallicRoughnessTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>metallicRoughnessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of metallicRoughnessTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=MetallicRoughnessTextureMapping, $memberObjectName=metallicRoughnessTextureMapping, $memberObjectName=metallicRoughnessTextureMapping)

	public String getMetallicRoughnessTextureMapping()
	{
		return metallicRoughnessTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>metallicRoughnessTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the metallicRoughnessTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setMetallicRoughnessTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		metallicRoughnessTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString metallicRoughnessTextureMapping field, similar to {@link #setMetallicRoughnessTextureMapping(String)}.
	 * @param newValue is new value for the metallicRoughnessTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setMetallicRoughnessTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setMetallicRoughnessTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material. Hint: normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt;  * <br>

	 * @return value of normalScale field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalScale, $memberObjectName=normalScale, $memberObjectName=normalScale)

	public float getNormalScale()
	{
		return normalScale;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>normalScale</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,infinity] normalScale controls the degree to which normalTexture RGB values apply XYZ-normal bump mapping to pixels in the parent material. Hint: normalScale only affects computation of normalTexture modulations that affect lighting of characteristics of the parent Material and has no relation to normal vectors defined by corresponding geometry. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt;  * <br>

	 * @param newValue is new value for the normalScale field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setNormalScale(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial normalScale newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		normalScale = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat normalScale field, similar to {@link #setNormalScale(float)}.
	 * @param newValue is new value for the normalScale field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setNormalScale(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setNormalScale(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setNormalScale(float)}.
	 * @param newValue is new value for field
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setNormalScale(double newValue)
	{
		return setNormalScale((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>normalTexture</i>.
	 * @see #getNormalTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt; Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='normalTexture'  * <br>

	 * @return value of normalTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalTexture, $memberObjectName=normalTexture, $memberObjectName=normalTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getNormalTexture()
	{
		return normalTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * @see #setNormalTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying normalScale for this material node, the contained texture modulates the texture across the surface. Hint: normalTexture techniques apply Bump mapping &lt;a href="https://en.wikipedia.org/wiki/Bump_mapping" target="_blank"&gt;https://en.wikipedia.org/wiki/Bump_mapping&lt;/a&gt; Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='normalTexture'  * <br>

	 * @param newValue is new value for the normalTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		normalTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) normalTexture).setParent(this); // parentTest15.1
		}
		if (normalTextureProtoInstance != null)
		{
			normalTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			normalTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of normalTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearNormalTexture()
	{
		((X3DConcreteElement) normalTexture).clearParent(); // remove references to facilitate Java memory management
		normalTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>normalTexture</i>.
	 * @see #setNormalTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the normalTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setNormalTexture(ProtoInstance newValue)
	{
		if (normalTextureProtoInstance != null)
		{
			((X3DConcreteElement) normalTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		normalTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) normalTextureProtoInstance).setParent(this); // parentTest15.6
            normalTextureProtoInstance.setContainerField("normalTexture");
	    }
		if (normalTexture != null)
		{
			((X3DConcreteElement) normalTexture).setParent(null); // housekeeping, clear prior object
			normalTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getNormalTextureProtoInstance()
		{
			return normalTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>normalTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getNormalTexture()
	 * @see #getNormalTextureProtoInstance()
	 */
	public boolean hasNormalTexture()
	{
		return (normalTexture != null) || (normalTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of normalTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=NormalTextureMapping, $memberObjectName=normalTextureMapping, $memberObjectName=normalTextureMapping)

	public String getNormalTextureMapping()
	{
		return normalTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>normalTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setNormalTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		normalTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString normalTextureMapping field, similar to {@link #setNormalTextureMapping(String)}.
	 * @param newValue is new value for the normalTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setNormalTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setNormalTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting. Hint: only the Red channel of the texture is used for occlusion computations, other channels are ignored. Hint: &lt;a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank"&gt;https://en.wikipedia.org/wiki/Ambient_occlusion&lt;/a&gt;  * <br>

	 * @return value of occlusionStrength field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionStrength, $memberObjectName=occlusionStrength, $memberObjectName=occlusionStrength)

	public float getOcclusionStrength()
	{
		return occlusionStrength;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>occlusionStrength</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] occlusionStrength indicates areas of indirect lighting, typically called ambient occlusion. Higher values indicate areas that should receive full indirect lighting and lower values indicate no indirect lighting. Hint: only the Red channel of the texture is used for occlusion computations, other channels are ignored. Hint: &lt;a href="https://en.wikipedia.org/wiki/Ambient_occlusion" target="_blank"&gt;https://en.wikipedia.org/wiki/Ambient_occlusion&lt;/a&gt;  * <br>

	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setOcclusionStrength(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial occlusionStrength newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial occlusionStrength newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		occlusionStrength = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat occlusionStrength field, similar to {@link #setOcclusionStrength(float)}.
	 * @param newValue is new value for the occlusionStrength field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionStrength(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setOcclusionStrength(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setOcclusionStrength(float)}.
	 * @param newValue is new value for field
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionStrength(double newValue)
	{
		return setOcclusionStrength((float) newValue);
	}
	/**
	 * Provide  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) from inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #getOcclusionTextureProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='occlusionTexture'.  * <br>

	 * @return value of occlusionTexture field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionTexture, $memberObjectName=occlusionTexture, $memberObjectName=occlusionTexture)

	public  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode getOcclusionTexture()
	{
		return occlusionTexture;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Texturing.X3DSingleTextureNode instance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #setOcclusionTexture(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DSingleTextureNode] When applying occlusionStrength for this material node, the contained texture provides Physically Based Rendering (PBR) modulation for each pixel. Hint: if texture node is NULL or unspecified, no effect is applied to material values. Hint: contained texture node must include containerField='occlusionTexture'.  * <br>

	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode newValue)
	{
		// set-newValue-validity-checks #0.a
		occlusionTexture = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) occlusionTexture).setParent(this); // parentTest15.1
		}
		if (occlusionTextureProtoInstance != null)
		{
			occlusionTextureProtoInstance.setParent(null); // housekeeping, clear prior object
			occlusionTextureProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of occlusionTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public PhysicalMaterial clearOcclusionTexture()
	{
		((X3DConcreteElement) occlusionTexture).clearParent(); // remove references to facilitate Java memory management
		occlusionTexture = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>occlusionTexture</i>.
	 * @see #setOcclusionTexture( org.web3d.x3d.sai.Texturing.X3DSingleTextureNode)
	 * @param newValue is new value for the occlusionTexture field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionTexture(ProtoInstance newValue)
	{
		if (occlusionTextureProtoInstance != null)
		{
			((X3DConcreteElement) occlusionTextureProtoInstance).setParent(null); // parentTest15.5
	    }
		occlusionTextureProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) occlusionTextureProtoInstance).setParent(this); // parentTest15.6
            occlusionTextureProtoInstance.setContainerField("occlusionTexture");
	    }
		if (occlusionTexture != null)
		{
			((X3DConcreteElement) occlusionTexture).setParent(null); // housekeeping, clear prior object
			occlusionTexture = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getOcclusionTextureProtoInstance()
		{
			return occlusionTextureProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>occlusionTexture</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getOcclusionTexture()
	 * @see #getOcclusionTextureProtoInstance()
	 */
	public boolean hasOcclusionTexture()
	{
		return (occlusionTexture != null) || (occlusionTextureProtoInstance != null);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @return value of occlusionTextureMapping field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=OcclusionTextureMapping, $memberObjectName=occlusionTextureMapping, $memberObjectName=occlusionTextureMapping)

	public String getOcclusionTextureMapping()
	{
		return occlusionTextureMapping;
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>occlusionTextureMapping</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  The mapping label identifies which texture coordinates and transformations are used to compute texture effects from corresponding geometry on a given material. Hint: TODO support planned to perform multiple-node mapping validation checks using X3D Schematron or X3D Validator &lt;a href="https://savage.nps.edu/X3dValidator" target="_blank"&gt;https://savage.nps.edu/X3dValidator&lt;/a&gt;  * <br>

	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setOcclusionTextureMapping(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		occlusionTextureMapping = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFString occlusionTextureMapping field, similar to {@link #setOcclusionTextureMapping(String)}.
	 * @param newValue is new value for the occlusionTextureMapping field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setOcclusionTextureMapping(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setOcclusionTextureMapping(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>roughness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] roughness is a PBR parameter (TODO elaborate).  * <br>

	 * @return value of roughness field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Roughness, $memberObjectName=roughness, $memberObjectName=roughness)

	public float getRoughness()
	{
		return roughness;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>roughness</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] roughness is a PBR parameter (TODO elaborate).  * <br>

	 * @param newValue is new value for the roughness field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setRoughness(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial roughness newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial roughness newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		roughness = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat roughness field, similar to {@link #setRoughness(float)}.
	 * @param newValue is new value for the roughness field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setRoughness(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setRoughness(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setRoughness(float)}.
	 * @param newValue is new value for field
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setRoughness(double newValue)
	{
		return setRoughness((float) newValue);
	}
	/**
	 * Provide float value within allowed range of [0,1] from inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile hint: transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent.  * <br>

	 * @return value of transparency field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=Transparency, $memberObjectName=transparency, $memberObjectName=transparency)

	public float getTransparency()
	{
		return transparency;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>transparency</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,1] how "clear" an object is: 1.0 is completely transparent, 0.0 is completely opaque. Interchange profile hint: transparency &amp;lt; .5 opaque, transparency &amp;gt; .5 transparent.  * <br>

	 * @param newValue is new value for the transparency field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public PhysicalMaterial setTransparency(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial transparency newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial transparency newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
            }
		transparency = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat transparency field, similar to {@link #setTransparency(float)}.
	 * @param newValue is new value for the transparency field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setTransparency(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setTransparency(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setTransparency(float)}.
	 * @param newValue is new value for field
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setTransparency(double newValue)
	{
		return setTransparency((float) newValue);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final PhysicalMaterial setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to PhysicalMaterial DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final PhysicalMaterial setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to PhysicalMaterial USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("PhysicalMaterial USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final PhysicalMaterial setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final PhysicalMaterial setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DOneSidedMaterialNode, $additionalInheritanceBaseType=, $thisClassName=PhysicalMaterial, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final PhysicalMaterial setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public PhysicalMaterial setUSE(PhysicalMaterial DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on PhysicalMaterial" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public PhysicalMaterial (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public PhysicalMaterial addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public PhysicalMaterial addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link PhysicalMaterial} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public PhysicalMaterial addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (baseTexture != null) || (baseTextureProtoInstance != null) || (emissiveTexture != null) || (emissiveTextureProtoInstance != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (metallicRoughnessTexture != null) || (metallicRoughnessTextureProtoInstance != null) || (normalTexture != null) || (normalTextureProtoInstance != null) || (occlusionTexture != null) || (occlusionTextureProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<PhysicalMaterial"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if ((!Arrays.equals(getBaseColor(), BASECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" baseColor='").append(SFColor.toString(getBaseColor())).append("'");
			}
			if ((!getBaseTextureMapping().equals(BASETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" baseTextureMapping='").append(new SFString(getBaseTextureMapping()).toStringX3D()).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if ((!Arrays.equals(getEmissiveColor(), EMISSIVECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* (string-length(@default) > 0) */ && !hasUSE())
			{
				stringX3D.append(" emissiveColor='").append(SFColor.toString(getEmissiveColor())).append("'");
			}
			if ((!getEmissiveTextureMapping().equals(EMISSIVETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" emissiveTextureMapping='").append(new SFString(getEmissiveTextureMapping()).toStringX3D()).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getMetallic() != METALLIC_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" metallic='").append(SFFloat.toString(getMetallic())).append("'");
			}
			if ((!getMetallicRoughnessTextureMapping().equals(METALLICROUGHNESSTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" metallicRoughnessTextureMapping='").append(new SFString(getMetallicRoughnessTextureMapping()).toStringX3D()).append("'");
			}
			if (((getNormalScale() != NORMALSCALE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" normalScale='").append(SFFloat.toString(getNormalScale())).append("'");
			}
			if ((!getNormalTextureMapping().equals(NORMALTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" normalTextureMapping='").append(new SFString(getNormalTextureMapping()).toStringX3D()).append("'");
			}
			if (((getOcclusionStrength() != OCCLUSIONSTRENGTH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" occlusionStrength='").append(SFFloat.toString(getOcclusionStrength())).append("'");
			}
			if ((!getOcclusionTextureMapping().equals(OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" occlusionTextureMapping='").append(new SFString(getOcclusionTextureMapping()).toStringX3D()).append("'");
			}
			if (((getRoughness() != ROUGHNESS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" roughness='").append(SFFloat.toString(getRoughness())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getTransparency() != TRANSPARENCY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" transparency='").append(SFFloat.toString(getTransparency())).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			if      (baseTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)baseTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (baseTextureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)baseTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (emissiveTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)emissiveTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (emissiveTextureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)emissiveTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (metallicRoughnessTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)metallicRoughnessTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metallicRoughnessTextureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metallicRoughnessTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (normalTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)normalTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (normalTextureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)normalTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (occlusionTexture != null)
			{
				stringX3D.append(((X3DConcreteElement)occlusionTexture).toStringX3D(indentLevel + indentIncrement));
			}
			else if (occlusionTextureProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)occlusionTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</PhysicalMaterial>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=PhysicalMaterial, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (baseTexture != null) || (baseTextureProtoInstance != null) || (emissiveTexture != null) || (emissiveTextureProtoInstance != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || (metallicRoughnessTexture != null) || (metallicRoughnessTextureProtoInstance != null) || (normalTexture != null) || (normalTextureProtoInstance != null) || (occlusionTexture != null) || (occlusionTextureProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("PhysicalMaterial").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("baseColor"))
						{
							stringClassicVRML.append(indentCharacter).append("baseColor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getBaseColor(), BASECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("baseColor ").append(SFColor.toString(getBaseColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("baseTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("baseTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getBaseTextureMapping().equals(BASETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("baseTextureMapping ").append("\"").append(SFString.toString(getBaseTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("emissiveColor"))
						{
							stringClassicVRML.append(indentCharacter).append("emissiveColor").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!Arrays.equals(getEmissiveColor(), EMISSIVECOLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("emissiveColor ").append(SFColor.toString(getEmissiveColor())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("emissiveTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("emissiveTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getEmissiveTextureMapping().equals(EMISSIVETEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("emissiveTextureMapping ").append("\"").append(SFString.toString(getEmissiveTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("metallic"))
						{
							stringClassicVRML.append(indentCharacter).append("metallic").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getMetallic() != METALLIC_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("metallic ").append(SFFloat.toString(getMetallic())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("metallicRoughnessTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("metallicRoughnessTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getMetallicRoughnessTextureMapping().equals(METALLICROUGHNESSTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("metallicRoughnessTextureMapping ").append("\"").append(SFString.toString(getMetallicRoughnessTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("normalScale"))
						{
							stringClassicVRML.append(indentCharacter).append("normalScale").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getNormalScale() != NORMALSCALE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("normalScale ").append(SFFloat.toString(getNormalScale())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("normalTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("normalTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getNormalTextureMapping().equals(NORMALTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("normalTextureMapping ").append("\"").append(SFString.toString(getNormalTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("occlusionStrength"))
						{
							stringClassicVRML.append(indentCharacter).append("occlusionStrength").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getOcclusionStrength() != OCCLUSIONSTRENGTH_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("occlusionStrength ").append(SFFloat.toString(getOcclusionStrength())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("occlusionTextureMapping"))
						{
							stringClassicVRML.append(indentCharacter).append("occlusionTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getOcclusionTextureMapping().equals(OCCLUSIONTEXTUREMAPPING_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("occlusionTextureMapping ").append("\"").append(SFString.toString(getOcclusionTextureMapping())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("roughness"))
						{
							stringClassicVRML.append(indentCharacter).append("roughness").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getRoughness() != ROUGHNESS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("roughness ").append(SFFloat.toString(getRoughness())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("transparency"))
						{
							stringClassicVRML.append(indentCharacter).append("transparency").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getTransparency() != TRANSPARENCY_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("transparency ").append(SFFloat.toString(getTransparency())).append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (baseTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("baseTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) baseTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (baseTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("baseTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) baseTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (emissiveTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) emissiveTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (emissiveTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) emissiveTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (metallicRoughnessTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("metallicRoughnessTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metallicRoughnessTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metallicRoughnessTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metallicRoughnessTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metallicRoughnessTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (normalTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("normalTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) normalTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (normalTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("normalTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) normalTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (occlusionTexture != null)
			{
				stringClassicVRML.append(indentCharacter).append("occlusionTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) occlusionTexture).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (occlusionTextureProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("occlusionTexture").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) occlusionTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (baseTexture != null)
		{
			referenceElement = ((X3DConcreteElement) baseTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (baseTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) baseTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (emissiveTexture != null)
		{
			referenceElement = ((X3DConcreteElement) emissiveTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (emissiveTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) emissiveTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metallicRoughnessTexture != null)
		{
			referenceElement = ((X3DConcreteElement) metallicRoughnessTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metallicRoughnessTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metallicRoughnessTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (normalTexture != null)
		{
			referenceElement = ((X3DConcreteElement) normalTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (normalTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) normalTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (occlusionTexture != null)
		{
			referenceElement = ((X3DConcreteElement) occlusionTexture).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (occlusionTextureProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) occlusionTextureProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (baseTexture != null)
		{
			referenceNode = ((X3DConcreteElement) baseTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (baseTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) baseTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (emissiveTexture != null)
		{
			referenceNode = ((X3DConcreteElement) emissiveTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (emissiveTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) emissiveTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metallicRoughnessTexture != null)
		{
			referenceNode = ((X3DConcreteElement) metallicRoughnessTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metallicRoughnessTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metallicRoughnessTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (normalTexture != null)
		{
			referenceNode = ((X3DConcreteElement) normalTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (normalTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) normalTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (occlusionTexture != null)
		{
			referenceNode = ((X3DConcreteElement) occlusionTexture).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (occlusionTextureProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) occlusionTextureProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setBaseColor(getBaseColor()); // exercise field checks, simple types
        
		setBaseTextureMapping(getBaseTextureMapping()); // exercise field checks, simple types
        
		setEmissiveColor(getEmissiveColor()); // exercise field checks, simple types
        
		setEmissiveTextureMapping(getEmissiveTextureMapping()); // exercise field checks, simple types
        
		setMetallic(getMetallic()); // exercise field checks, simple types
        
		setMetallicRoughnessTextureMapping(getMetallicRoughnessTextureMapping()); // exercise field checks, simple types
        
		setNormalScale(getNormalScale()); // exercise field checks, simple types
        
		setNormalTextureMapping(getNormalTextureMapping()); // exercise field checks, simple types
        
		setOcclusionStrength(getOcclusionStrength()); // exercise field checks, simple types
        
		setOcclusionTextureMapping(getOcclusionTextureMapping()); // exercise field checks, simple types
        
		setRoughness(getRoughness()); // exercise field checks, simple types
        
		setTransparency(getTransparency()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (baseTexture != null)
		{
			setBaseTexture(getBaseTexture());
			((X3DConcreteElement) baseTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) baseTexture).getValidationResult());
		}
		if (baseTextureProtoInstance != null)
		{
			setBaseTexture(getBaseTextureProtoInstance());
			((X3DConcreteElement) baseTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) baseTextureProtoInstance).getValidationResult());
		}
		if ((baseTexture != null) && (baseTextureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both baseTexture and baseTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasBaseTexture()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode baseTexture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (emissiveTexture != null)
		{
			setEmissiveTexture(getEmissiveTexture());
			((X3DConcreteElement) emissiveTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) emissiveTexture).getValidationResult());
		}
		if (emissiveTextureProtoInstance != null)
		{
			setEmissiveTexture(getEmissiveTextureProtoInstance());
			((X3DConcreteElement) emissiveTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) emissiveTextureProtoInstance).getValidationResult());
		}
		if ((emissiveTexture != null) && (emissiveTextureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both emissiveTexture and emissiveTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasEmissiveTexture()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode emissiveTexture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metallicRoughnessTexture != null)
		{
			setMetallicRoughnessTexture(getMetallicRoughnessTexture());
			((X3DConcreteElement) metallicRoughnessTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metallicRoughnessTexture).getValidationResult());
		}
		if (metallicRoughnessTextureProtoInstance != null)
		{
			setMetallicRoughnessTexture(getMetallicRoughnessTextureProtoInstance());
			((X3DConcreteElement) metallicRoughnessTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metallicRoughnessTextureProtoInstance).getValidationResult());
		}
		if ((metallicRoughnessTexture != null) && (metallicRoughnessTextureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metallicRoughnessTexture and metallicRoughnessTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetallicRoughnessTexture()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode metallicRoughnessTexture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (normalTexture != null)
		{
			setNormalTexture(getNormalTexture());
			((X3DConcreteElement) normalTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) normalTexture).getValidationResult());
		}
		if (normalTextureProtoInstance != null)
		{
			setNormalTexture(getNormalTextureProtoInstance());
			((X3DConcreteElement) normalTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) normalTextureProtoInstance).getValidationResult());
		}
		if ((normalTexture != null) && (normalTextureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both normalTexture and normalTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasNormalTexture()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode normalTexture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (occlusionTexture != null)
		{
			setOcclusionTexture(getOcclusionTexture());
			((X3DConcreteElement) occlusionTexture).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) occlusionTexture).getValidationResult());
		}
		if (occlusionTextureProtoInstance != null)
		{
			setOcclusionTexture(getOcclusionTextureProtoInstance());
			((X3DConcreteElement) occlusionTextureProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) occlusionTextureProtoInstance).getValidationResult());
		}
		if ((occlusionTexture != null) && (occlusionTextureProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both occlusionTexture and occlusionTextureProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasOcclusionTexture()) // test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained SFNode occlusionTexture";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "PhysicalMaterial USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'PhysicalMaterial' node, ensure sufficient support by adding head statement <component name='Shape' level='2'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Shape\").setLevel(2);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
