/*
Copyright (c) 1995-2023 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the Web3D Consortium (https://www.web3D.org)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package org.web3d.x3d.jsail.Navigation;
import java.util.*;
// import org.web3d.x3d.sai.*;      // making sure #2
// import org.web3d.x3d.sai.Core.*;  // making sure #2
import org.web3d.x3d.sai.InvalidFieldValueException;  // making sure #2
import org.web3d.x3d.jsail.fields.*; // making sure #4
// import org.web3d.x3d.jsail.Navigation.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;
// import org.web3d.x3d.jsail.Navigation.*; // interfaces for this component
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
// import org.web3d.x3d.jsail.Shape.*;
// import org.web3d.x3d.jsail.Networking.*;
// import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.*; // again making sure #4

import org.web3d.x3d.jsail.Core.*;

/**
 * NavigationInfo describes the user's viewing model, user navigation-interaction modalities, and also dimensional characteristics of the user's (typically invisible) avatar.
 * 
 * <br><br>
 *
 * <i>Warning:</i> this is an abstract interface that cannot be instantiated as a concrete object.
 * Java programmers typically only need to use concrete objects provided by the <code>org.web3d.x3d.jsail</code> classes.
 * <i>X3D node tooltip</i>:  [X3DBindableNode] NavigationInfo describes the user's viewing model, user navigation-interaction modalities, and also dimensional characteristics of the user's (typically invisible) avatar.
Hint: for inspection of simple objects, usability often improves with type="EXAMINE" "ANY"
Hint: Background, Fog, GeoViewpoint, NavigationInfo, OrthoViewpoint, TextureBackground and Viewpoint are bindable nodes, meaning that no more than one of each node type can be active at a given time.
Hint: NavigationInfo types '"WALK" "FLY"' support camera-to-object collision detection.
Warning: results are undefined if a bindable node (Background, Fog, NavigationInfo, OrthoViewpoint, TextureBackground, Viewpoint) is a contained descendant node of either LOD or Switch. Avoid this authoring pattern.
Hint: Regardless of viewpoint jump value at bind time, the relative viewing transformation between user's view and defined position/orientation is stored for later use when un-jumping (returning to the viewpoint when subsequent viewpoint is unbound).
Hint: customizable design pattern for dedicated Viewpoint/NavigationInfo pair: &amp;lt;Viewpoint DEF='SpecialView'/&amp;gt; &amp;lt;NavigationInfo DEF='SpecialNav'/&amp;gt; &amp;lt;ROUTE fromNode='SpecialView' fromField='isBound' toNode='SpecialNav' toField='set_bind'/&amp;gt;
Hint: X3D Scene Authoring Hints, Viewpoints &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Viewpoints" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Viewpoints&lt;/a&gt;  * <br>
 * <br>

 * <br>
 * <i>Package hint:</i>  This org.web3d.x3d.jsail concrete class is used for implementing a standalone X3D object as a <a href="https://en.wikipedia.org/wiki/Plain_old_Java_object" target="_blank">Plain Old Java Object (POJO)</a>.
 * If you are writing Java code for use inside an X3D Script node, compile separate code using only the <i>org.web3d.x3d.sai</i> package instead.
 * @author Don Brutzman and Roy Walmsley
 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/navigation.html#NavigationInfo" target="blank">X3D Abstract Specification: NavigationInfo</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html#NavigationInfo" target="_blank">X3D Tooltips: NavigationInfo</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Viewpoints" target="_blank">X3D Scene Authoring Hints: Viewpoints</a>
 */
public class NavigationInfo extends org.web3d.x3d.jsail.X3DConcreteNode implements org.web3d.x3d.sai.Navigation.NavigationInfo
{
    /** required by internal interface, empty list provided since no children array present in this class */
    private ArrayList<String> commentsList; 

    // Member value declarations are encapsulated and private, using preferred Java types for concretes library

    /* @name=avatarSize, @type=MFFloat, $javaType=ArrayList<Float>, $javaReferenceType=Float, $javaPrimitiveType=ArrayList<Float>, $normalizedMemberObjectName=avatarSize, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<Float> avatarSize = new ArrayList<>(); //  X3D field type: MFFloat

    /* @name=bindTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=bindTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double bindTime; //  X3D field type: SFTime

    /* @name=headlight, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=headlight, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean headlight; //  X3D field type: SFBool

    /* @name=IS, @type=SFNode, $javaType=IS, $javaReferenceType=IS, $javaPrimitiveType=IS, $normalizedMemberObjectName=IS, $isX3dStatement=true, @acceptableNodeTypes=IS */ 
    private IS IS; //  X3D field type: SFNode acceptable node types: IS

    /* @name=isBound, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=isBound, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean isBound; //  X3D field type: SFBool

    /* @name=metadata, @type=SFNode, $javaType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaReferenceType= org.web3d.x3d.sai.Core.X3DMetadataObject, $javaPrimitiveType= org.web3d.x3d.sai.Core.X3DMetadataObject, $normalizedMemberObjectName=metadata, $isX3dStatement=false, @acceptableNodeTypes=X3DMetadataObject */ 
    private  org.web3d.x3d.sai.Core.X3DMetadataObject metadata; //  X3D field type: SFNode acceptable node types: X3DMetadataObject or ProtoInstance
	private ProtoInstance metadataProtoInstance; // allowed alternative for metadata field

    /* @name=set_bind, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=bind, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean bind; //  X3D field type: SFBool

    /* @name=speed, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=speed, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float speed; //  X3D field type: SFFloat

    /* @name=transitionComplete, @type=SFBool, $javaType=boolean, $javaReferenceType=boolean, $javaPrimitiveType=boolean, $normalizedMemberObjectName=transitionComplete, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private boolean transitionComplete; //  X3D field type: SFBool

    /* @name=transitionTime, @type=SFTime, $javaType=double, $javaReferenceType=double, $javaPrimitiveType=double, $normalizedMemberObjectName=transitionTime, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private double transitionTime; //  X3D field type: SFTime

    /* @name=transitionType, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=transitionType, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> transitionType = new ArrayList<>(); //  X3D field type: MFString

    /* @name=type, @type=MFString, $javaType=ArrayList<String>, $javaReferenceType=String, $javaPrimitiveType=ArrayList<String>, $normalizedMemberObjectName=type, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private ArrayList<String> type = new ArrayList<>(); //  X3D field type: MFString

    /* @name=visibilityLimit, @type=SFFloat, $javaType=float, $javaReferenceType=float, $javaPrimitiveType=float, $normalizedMemberObjectName=visibilityLimit, $isX3dStatement=false, @acceptableNodeTypes= */ 
    private float visibilityLimit; //  X3D field type: SFFloat

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean transitionTypeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> immediate transition.
	 * MFString field named <i>transitionType</i> with X3DUOM simpleType <i>navigationTransitionTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"TELEPORT"</i> (Java syntax) or <i>'"TELEPORT"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTransitionTypeValues.html">XML Schema: navigationTransitionTypeValues</a> */
	public static final String TRANSITIONTYPE_TELEPORT = "TELEPORT";

	/** 
	 * <i>Tooltip:</i> transition may proceed directly through intervening objects.
	 * MFString field named <i>transitionType</i> with X3DUOM simpleType <i>navigationTransitionTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"LINEAR"</i> (Java syntax) or <i>'"LINEAR"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTransitionTypeValues.html">XML Schema: navigationTransitionTypeValues</a> */
	public static final String TRANSITIONTYPE_LINEAR = "LINEAR";

	/** 
	 * <i>Tooltip:</i> rowser-specific transition.
	 * MFString field named <i>transitionType</i> with X3DUOM simpleType <i>navigationTransitionTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ANIMATE"</i> (Java syntax) or <i>'"ANIMATE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTransitionTypeValues.html">XML Schema: navigationTransitionTypeValues</a> */
	public static final String TRANSITIONTYPE_ANIMATE = "ANIMATE";

	// ==== String constants for enumeration values ensure correct syntax and avoid run-time errors ====

	/** Reduce excessive warning information for this attribute. */ 
	static boolean typeWarningAlreadyProvided = false;

	/** 
	 * <i>Tooltip:</i> browser can offer any type for user to choose.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"ANY"</i> (Java syntax) or <i>'"ANY"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_ANY = "ANY";

	/** 
	 * <i>Tooltip:</i> free navigation, avatar remains on ground, collision detection.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"WALK"</i> (Java syntax) or <i>'"WALK"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_WALK = "WALK";

	/** 
	 * <i>Tooltip:</i> view an individual object by rotating view about center.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"EXAMINE"</i> (Java syntax) or <i>'"EXAMINE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_EXAMINE = "EXAMINE";

	/** 
	 * <i>Tooltip:</i> free navigation, collision detection.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"FLY"</i> (Java syntax) or <i>'"FLY"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_FLY = "FLY";

	/** 
	 * <i>Tooltip:</i> navigate to particular object.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"LOOKAT"</i> (Java syntax) or <i>'"LOOKAT"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_LOOKAT = "LOOKAT";

	/** 
	 * <i>Tooltip:</i> disables all navigation interfaces.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"NONE"</i> (Java syntax) or <i>'"NONE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_NONE = "NONE";

	/** 
	 * <i>Tooltip:</i> consistent keystroke navigation for both geospatial and Cartesian modes.
	 * MFString field named <i>type</i> with X3DUOM simpleType <i>navigationTypeValues</i> and with X3DUOM baseType <i>MFString</i> is an array that can include this quoted enumeration value (and also may include alternate values) <i>"EXPLORE"</i> (Java syntax) or <i>'"EXPLORE"'</i> (XML syntax).
	 * @see <a href="https://web3d.org/specifications/X3dSchemaDocumentation4.0/x3d-4.0_navigationTypeValues.html">XML Schema: navigationTypeValues</a> */
	public static final String TYPE_EXPLORE = "EXPLORE";

	// String constants for default field values match X3D Schema definitions

	/** String constant <i>NAME</i> provides name of this element: <i>NavigationInfo</i>. */
	@SuppressWarnings("FieldNameHidesFieldInSuperclass")
	public static final String NAME = "NavigationInfo";

	/** Provides name of this element: <i>NavigationInfo</i>
	 * @return name of this element
	 */
	/* @Override */
	public final String getElementName()
	{
		return NAME;
	}

	/** String constant <i>COMPONENT</i> defines X3D component for the <i>NavigationInfo</i> element: <i>Navigation</i> */
	public static final String COMPONENT = "Navigation";

	/** Defines X3D component for the <i>NavigationInfo</i> element: <i>Navigation</i>
	 * @return X3D component for this element
	 */
	/* @Override */
	public final String getComponent()
	{
		return COMPONENT;
	}

	/** Integer constant <i>LEVEL</i> provides default X3D <i>Navigation</i> component level for this element: <i>1</i> */
	public static final int LEVEL = 1;

	/** Provides default X3D component level for this element: <i>1</i>
	 * @return default X3D component level for this element
	 */
	/* @Override */
	public final int getComponentLevel()
	{
		return LEVEL;
	}

            // DEFAULT_VALUE declarations

	/** MFFloat field named <i>avatarSize</i> has default value <i>{0.25f,1.6f,0.75f}</i> (Java syntax) or <i>0.25 1.6 0.75</i> (XML syntax). */
	public static final ArrayList<Float> AVATARSIZE_DEFAULT_VALUE = new ArrayList<>(Arrays.asList(0.25f,1.6f,0.75f));

	/** SFBool field named <i>headlight</i> has default value <i>true</i> (Java syntax) or <i>true</i> (XML syntax). */
	public static final boolean HEADLIGHT_DEFAULT_VALUE = true;

	/** SFNode field named <i>IS</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final IS IS_DEFAULT_VALUE = null;

	/** SFNode field named <i>metadata</i> has default value <i>null</i> (Java syntax) or <i>NULL</i> (XML syntax). */
	public static final  org.web3d.x3d.sai.Core.X3DMetadataObject METADATA_DEFAULT_VALUE = null;

	/** SFFloat field named <i>speed</i> has default value <i>1f</i> (Java syntax) or <i>1</i> (XML syntax). */
	public static final float SPEED_DEFAULT_VALUE = 1f;

	/** SFTime field named <i>transitionTime</i> has default value <i>1.0</i> (Java syntax) or <i>1.0</i> (XML syntax). */
	public static final double TRANSITIONTIME_DEFAULT_VALUE = 1.0;

	/** MFString field named <i>transitionType</i> has default quoted value <i>new String[] {"LINEAR"}</i> (Java syntax) or quoted value <i>"LINEAR"</i> (XML syntax). */
	public static final ArrayList<String> TRANSITIONTYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList("LINEAR"));

	/** MFString field named <i>type</i> has default quoted value <i>new String[] {"EXAMINE","ANY"}</i> (Java syntax) or quoted value <i>"EXAMINE" "ANY"</i> (XML syntax). */
	public static final ArrayList<String> TYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.<String>asList("EXAMINE","ANY"));

	/** SFFloat field named <i>visibilityLimit</i> has default value <i>0f</i> (Java syntax) or <i>0</i> (XML syntax). */
	public static final float VISIBILITYLIMIT_DEFAULT_VALUE = 0f;

	/** Indicate type corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_TYPE
	 * @return X3D type (SFvec3f etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE if not recognized
	 */
	/* @Override */		
	public String getFieldType(String fieldName)
	{
		String result;

		switch (fieldName)
		{
			// String constants for exact field type values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing type-matching checks
											
			case "containerField":
				result = "SFString";
				break;
			case "avatarSize":
				result = "MFFloat";
				break;
			case "bindTime":
				result = "SFTime";
				break;
			case "headlight":
				result = "SFBool";
				break;
			case "IS":
				result = "SFNode";
				break;
			case "isBound":
				result = "SFBool";
				break;
			case "metadata":
				result = "SFNode";
				break;
			case "bind":
				result = "SFBool";
				break;
			case "speed":
				result = "SFFloat";
				break;
			case "transitionComplete":
				result = "SFBool";
				break;
			case "transitionTime":
				result = "SFTime";
				break;
			case "transitionType":
				result = "MFString";
				break;
			case "type":
				result = "MFString";
				break;
			case "visibilityLimit":
				result = "SFFloat";
				break;
			case "DEF":
				result = "SFString";
				break;
			case "USE":
				result = "SFString";
				break;
			case "class":
				result = "SFString";
				break;
			case "id":
				result = "SFString";
				break;
			case "style":
				result = "SFString";
				break;
			default:
			{
				// if fieldName has a prefix "set_" prepended (or a suffix "_changed" appended) then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getFieldType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_TYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** Indicate accessType corresponding to given fieldName.
	 * @param fieldName name of field in this X3D node
	 * @see ConfigurationProperties#ERROR_UNKNOWN_FIELD_ACCESSTYPE
	 * @return X3D accessType (inputOnly etc.), otherwise ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE if not recognized
	 */
	/* @Override */
	public String getAccessType(String fieldName)
	{
		String result; // set by following checks
		switch (fieldName)
		{
			// String constants for field accessType values matching X3D Schema definitions,
			// thus avoiding spelling errors and allowing accessType-matching checks
			case "avatarSize":
				result = "inputOutput";
				break;
			case "bindTime":
				result = "outputOnly";
				break;
			case "headlight":
				result = "inputOutput";
				break;
			case "IS":
				result = "inputOutput";
				break;
			case "isBound":
				result = "outputOnly";
				break;
			case "metadata":
				result = "inputOutput";
				break;
			case "set_bind":
				result = "inputOnly";
				break;
			case "speed":
				result = "inputOutput";
				break;
			case "transitionComplete":
				result = "outputOnly";
				break;
			case "transitionTime":
				result = "inputOutput";
				break;
			case "transitionType":
				result = "inputOutput";
				break;
			case "type":
				result = "inputOutput";
				break;
			case "visibilityLimit":
				result = "inputOutput";
				break;
			case "DEF":
				result = "inputOutput";
				break;
			case "USE":
				result = "inputOutput";
				break;
			case "class":
				result = "inputOutput";
				break;
			case "id":
				result = "inputOutput";
				break;
			case "style":
				result = "inputOutput";
				break;
			default:
			{
				// if user has added a prefix "set_" or suffix "_changed" then try again by stripping it and recursing once
				if      (fieldName.trim().startsWith("set_"))
						 result = getAccessType(fieldName.trim().substring(4)); // after "set_"
				else if (fieldName.trim().endsWith("_changed"))
						 result = getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)); // before "_changed"
				else     result = ConfigurationProperties.ERROR_UNKNOWN_FIELD_ACCESSTYPE; // unique return value avoids mistaken matches
			}
		}
		return result;
	}

	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
	 */
	public static final String containerField_DEFAULT_VALUE = "children"; // type xs:NMTOKEN
	/** containerField describes typical field relationship of a node to its parent.
	 * Usage is not ordinarily needed when using this API, default value is provided for informational purposes.
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#containerField">X3D Scene Authoring Hints: containerField</a>
	 * @see <a href="https://www.web3d.org/specifications/X3DUOM.html">X3D Unified Object Model (X3DUOM)</a>
     * @return default containerField value            
	 */
    /* @Override */
    public final String getContainerFieldDefault()
    {
        return containerField_DEFAULT_VALUE;
    }

	// String constants for field names usable in ROUTE statements

	/** fromField ROUTE name for MFFloat field named <i>avatarSize</i>. */
	public static final String fromField_AVATARSIZE = "avatarSize";

	/** toField ROUTE name for MFFloat field named <i>avatarSize</i>. */
	public static final String toField_AVATARSIZE = "avatarSize";

	/** fromField ROUTE name for SFTime field named <i>bindTime</i>. */
	public static final String fromField_BINDTIME = "bindTime";

	/** fromField ROUTE name for SFBool field named <i>headlight</i>. */
	public static final String fromField_HEADLIGHT = "headlight";

	/** toField ROUTE name for SFBool field named <i>headlight</i>. */
	public static final String toField_HEADLIGHT = "headlight";

	/** fromField ROUTE name for SFNode field named <i>IS</i>. */
	public static final String fromField_IS = "IS";

	/** fromField ROUTE name for SFBool field named <i>isBound</i>. */
	public static final String fromField_ISBOUND = "isBound";

	/** fromField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String fromField_METADATA = "metadata";

	/** toField ROUTE name for SFNode field named <i>metadata</i>. */
	public static final String toField_METADATA = "metadata";

	/** toField ROUTE name for SFBool field named <i>set_bind</i>. */
	public static final String toField_SET_BIND = "set_bind";

	/** fromField ROUTE name for SFFloat field named <i>speed</i>. */
	public static final String fromField_SPEED = "speed";

	/** toField ROUTE name for SFFloat field named <i>speed</i>. */
	public static final String toField_SPEED = "speed";

	/** fromField ROUTE name for SFBool field named <i>transitionComplete</i>. */
	public static final String fromField_TRANSITIONCOMPLETE = "transitionComplete";

	/** fromField ROUTE name for SFTime field named <i>transitionTime</i>. */
	public static final String fromField_TRANSITIONTIME = "transitionTime";

	/** toField ROUTE name for SFTime field named <i>transitionTime</i>. */
	public static final String toField_TRANSITIONTIME = "transitionTime";

	/** fromField ROUTE name for MFString field named <i>transitionType</i>. */
	public static final String fromField_TRANSITIONTYPE = "transitionType";

	/** toField ROUTE name for MFString field named <i>transitionType</i>. */
	public static final String toField_TRANSITIONTYPE = "transitionType";

	/** fromField ROUTE name for MFString field named <i>type</i>. */
	public static final String fromField_TYPE = "type";

	/** toField ROUTE name for MFString field named <i>type</i>. */
	public static final String toField_TYPE = "type";

	/** fromField ROUTE name for SFFloat field named <i>visibilityLimit</i>. */
	public static final String fromField_VISIBILITYLIMIT = "visibilityLimit";

	/** toField ROUTE name for SFFloat field named <i>visibilityLimit</i>. */
	public static final String toField_VISIBILITYLIMIT = "visibilityLimit";

	/** Constructor for NavigationInfo to initialize member variables with default values. */
	public NavigationInfo()
	{
		super(); // constructor invocation and corresponding initialize()
		initialize();
	}

	/** Initialize all member variables to default values. */
	@Override
	public final void initialize()
	{
		super.initialize();

        setContainerFieldOverride(""); // ensuring default value used
	containerField_ALTERNATE_VALUES = new String[] { "children" }; // type xs:NMTOKEN

		avatarSize = AVATARSIZE_DEFAULT_VALUE;
		headlight = HEADLIGHT_DEFAULT_VALUE;
		IS = null; // clear out any prior node
		metadata = null;              // clear out any prior node
		metadataProtoInstance = null; // clear out any prior node
		speed = SPEED_DEFAULT_VALUE;
		transitionTime = TRANSITIONTIME_DEFAULT_VALUE;
		transitionType = new ArrayList<>(TRANSITIONTYPE_DEFAULT_VALUE);
		type = new ArrayList<>(TYPE_DEFAULT_VALUE);
		visibilityLimit = VISIBILITYLIMIT_DEFAULT_VALUE;

		commentsList = new ArrayList<>(); // instantiate, initialize
	}

	// ==== Accessor methods: strongly typed get/set methods for compile-time strictness

	/**
	 * Provide array of Float results within allowed range of [0,infinity) from inputOutput MFFloat field named <i>avatarSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  avatarSize triplet values define three separate parameters: (a) collisionDistance between user and geometry, i.e. near clipping plane of view frustrum, default 0.25m, (b) viewer height above terrain, default 1.6m, and (c) tallest height viewer can WALK over, default 0.75m. Hint: X3D specification recommends that browsers set near clipping plane to one-half of avatarSize.CollisionDistance value. Warning: important design thumbrule is to keep (visibilityLimit / avatarSize.CollisionDistance) &amp;lt; 10,000 to avoid aliasing artifacts (i.e. polygon "tearing"). Hint: Aliasing &lt;a href="https://en.wikipedia.org/wiki/Aliasing" target="_blank"&gt;https://en.wikipedia.org/wiki/Aliasing&lt;/a&gt; and Clipping &lt;a href="https://en.wikipedia.org/wiki/Clipping_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Clipping_(computer_graphics)&lt;/a&gt; Interchange profile hint: this field may be ignored, applying the default value regardless. Hint: transformation hierarchy of currently bound Viewpoint node scales avatarSize, but translations and rotations have no effect. Hint: content must be visible to be collidable and to be pickable. Warning: data type is MFFloat rather than SFVec3f, be sure that three values are provided in the array since validation tools are typically unable to detect erroneous data prior to run time.  * <br>

	 * @return value of avatarSize field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=AvatarSize, $memberObjectName=avatarSize, $memberObjectName=avatarSize)

	public float[] getAvatarSize()
	{
		final float[] valuesArray = new float[avatarSize.size()];
		int i = 0;
		for (Float arrayElement : avatarSize) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFFloat avatarSize field, similar to {@link #getAvatarSize()}.
	 * @return value of avatarSize field
	 */
	public ArrayList<Float> getAvatarSizeList()
	{
		return avatarSize;
	}
	/**
	 * Utility method to get String value of MFFloat avatarSize field, similar to {@link #getAvatarSize()}.
	 * @return value of avatarSize field
	 */
	public String getAvatarSizeString()
    {
        StringBuilder result = new StringBuilder();
		for (Float arrayElement : avatarSize) {
			result.append(arrayElement.toString());
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign Float array to inputOutput MFFloat field named <i>avatarSize</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  avatarSize triplet values define three separate parameters: (a) collisionDistance between user and geometry, i.e. near clipping plane of view frustrum, default 0.25m, (b) viewer height above terrain, default 1.6m, and (c) tallest height viewer can WALK over, default 0.75m. Hint: X3D specification recommends that browsers set near clipping plane to one-half of avatarSize.CollisionDistance value. Warning: important design thumbrule is to keep (visibilityLimit / avatarSize.CollisionDistance) &amp;lt; 10,000 to avoid aliasing artifacts (i.e. polygon "tearing"). Hint: Aliasing &lt;a href="https://en.wikipedia.org/wiki/Aliasing" target="_blank"&gt;https://en.wikipedia.org/wiki/Aliasing&lt;/a&gt; and Clipping &lt;a href="https://en.wikipedia.org/wiki/Clipping_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Clipping_(computer_graphics)&lt;/a&gt; Interchange profile hint: this field may be ignored, applying the default value regardless. Hint: transformation hierarchy of currently bound Viewpoint node scales avatarSize, but translations and rotations have no effect. Hint: content must be visible to be collidable and to be pickable. Warning: data type is MFFloat rather than SFVec3f, be sure that three values are provided in the array since validation tools are typically unable to detect erroneous data prior to run time.  * <br>

	 * @param newValue is new value for the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setAvatarSize(float[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)		{
			clearAvatarSize(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearAvatarSize(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			avatarSize.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFFloat avatarSize field, similar to {@link #setAvatarSize(float[])}.
	 * @param newValue is new value for the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setAvatarSize(MFFloat newValue)
	{
		if (newValue == null)		{
			clearAvatarSize(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setAvatarSize(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign ArrayList value of MFFloat avatarSize field, similar to {@link #setAvatarSize(float[])}.
	 * @param newValue is new value for the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setAvatarSize(ArrayList<Float> newValue)
	{
		if (newValue == null)		{
			clearAvatarSize(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
        if (newValue.isEmpty())
            clearAvatarSize(); // reset
        else
        {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setAvatarSize(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFFloat value of avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public NavigationInfo clearAvatarSize()
	{
		avatarSize.clear(); // reset MF field
		return this;
	}
	/**
	 * Assign floating-point array value of MFFloat avatarSize field, similar to {@link #setAvatarSize(float[])}.
	 * @param newValue is new value for the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setAvatarSize(int[] newValue)
	{
		if (newValue == null)		{
			clearAvatarSize(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #5
		float[] holdArray = new float[newValue.length];
		for (int i = 0; i < newValue.length; i++)
		{
			holdArray[i] = (float)newValue[i];
		}
		setAvatarSize(holdArray);
		return this;
	}

	/**
	 * Add singleton float value to MFFloat avatarSize field.
	 * @param newValue is new value to add to the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addAvatarSize(float newValue)
	{
		avatarSize.add(newValue); // add simple type if tupleSize = 1
		return this;
	}
	/**
	 * Add singleton SFFloat value to MFFloat avatarSize field.
	 * @param newValue is new value to add to the avatarSize field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addAvatarSize(SFFloat newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		avatarSize.add(newValue.getPrimitiveValue());
		return this;
	}


	/**
	 * Utility method: double-precision set-array accessor for X3D floating-point type, similar to {@link #setAvatarSize(float[])}.
	 * @param newArray is new value for field                                 
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setAvatarSize(double[] newArray)
	{
		return setAvatarSize(new MFFloat(newArray));
	}
	/**
	 * Provide double value in seconds from outputOnly SFTime field named <i>bindTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Event sent reporting timestamp when node becomes active/inactive. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of bindTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=BindTime, $memberObjectName=bindTime, $memberObjectName=bindTime)

	public double getBindTime()
	{
		return bindTime;
	}
	/**
	 * Provide boolean value from inputOutput SFBool field named <i>headlight</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enable/disable directional light that always points in the direction the user is looking.  * <br>

	 * @return value of headlight field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=Headlight, $memberObjectName=headlight, $memberObjectName=headlight)

	public boolean getHeadlight()
	{
		return headlight;
	}

	/**
	 * Accessor method to assign boolean value to inputOutput SFBool field named <i>headlight</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enable/disable directional light that always points in the direction the user is looking.  * <br>

	 * @param newValue is new value for the headlight field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setHeadlight(boolean newValue)
	{
		// set-newValue-validity-checks #0.a
		headlight = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFBool headlight field, similar to {@link #setHeadlight(boolean)}.
	 * @param newValue is new value for the headlight field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setHeadlight(SFBool newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHeadlight(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide IS instance (using a properly typed node) from inputOutput SFNode field <i>IS</i>.
	 * @return value of IS field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=true, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=IS, $memberObjectName=IS, $memberObjectName=IS)
	public IS getIS()
	{
		return IS;
	}

	/**
	 * Accessor method to assign IS instance (using a properly typed node) to inputOutput SFNode field <i>IS</i>.
	 * @param newValue is new value for the IS field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setIS(IS newValue)
	{
		// set-newValue-validity-checks #0.a
		IS = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) IS).setParent(this); // parentTest15.1
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of IS field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public NavigationInfo clearIS()
	{
		((X3DConcreteElement) IS).clearParent(); // remove references to facilitate Java memory management
		IS = null; // reset SFNode field
		return this;
	}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>IS</i>.
	 * @return whether a concrete statement or CommentsBlock is available.
	 * @see #getIS()
	 */
	public boolean hasIS()
	{
		return (IS != null);
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>isBound</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Output event true gets sent when node becomes bound and activated, otherwise output event false gets sent when node becomes unbound and deactivated. Hint: paired node operations can be established by connecting set_bind and isBound fields of corresponding bindable nodes. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of isBound field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=IsBound, $memberObjectName=isBound, $memberObjectName=isBound)

	public boolean getIsBound()
	{
		return isBound;
	}
	/**
	 * Provide  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) from inputOutput SFNode field <i>metadata</i>.
	 * @see #getMetadataProtoInstance()
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @return value of metadata field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=Metadata, $memberObjectName=metadata, $memberObjectName=metadata)

	public  org.web3d.x3d.sai.Core.X3DMetadataObject getMetadata()
	{
		return metadata;
	}

	/**
	 * Accessor method to assign  org.web3d.x3d.sai.Core.X3DMetadataObject instance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata(ProtoInstance)
	 * <br><br>
	 * <i>Tooltip:</i>  [X3DMetadataObject] Information about this node can be contained in a MetadataBoolean, MetadataDouble, MetadataFloat, MetadataInteger, MetadataString or MetadataSet node. Hint: X3D Architecture 7.2.4 Metadata &lt;a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata" target="_blank"&gt;https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof//Part01/components/core.html#Metadata&lt;/a&gt;  * <br>

	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 * @param newValue is new value for the metadata field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject newValue)
	{
		// set-newValue-validity-checks #0.a
		metadata = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadata).setParent(this); // parentTest15.1
			// change X3D4 MetadataSet default 'value' back to 'metadata' if parent is not another Metadata* node */
			if (metadata instanceof org.web3d.x3d.jsail.Core.MetadataSet)
{
				((X3DConcreteNode) metadata).setContainerFieldOverride("metadata");
}
		}
		if (metadataProtoInstance != null)
		{
			metadataProtoInstance.setParent(null); // housekeeping, clear prior object
			metadataProtoInstance = null;
		}
		return this;
	}

	/**
	 * Utility method to clear SFNode value of metadata field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).	 */
	public NavigationInfo clearMetadata()
	{
		((X3DConcreteElement) metadata).clearParent(); // remove references to facilitate Java memory management
		metadata = null; // reset SFNode field
		return this;
	}
	/**
	 * Assign ProtoInstance (using a properly typed node) to inputOutput SFNode field <i>metadata</i>.
	 * @see #setMetadata( org.web3d.x3d.sai.Core.X3DMetadataObject)
	 * @param newValue is new value for the metadata field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public NavigationInfo setMetadata(ProtoInstance newValue)
	{
		if (metadataProtoInstance != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(null); // parentTest15.5
	    }
		metadataProtoInstance = newValue;
		if (newValue != null)
		{
			((X3DConcreteElement) metadataProtoInstance).setParent(this); // parentTest15.6
            metadataProtoInstance.setContainerField("metadata");
	    }
		if (metadata != null)
		{
			((X3DConcreteElement) metadata).setParent(null); // housekeeping, clear prior object
			metadata = null;
		}
	    return this;
	}

		/** Private utility method to access SFNode ProtoInstance field **/
		private ProtoInstance getMetadataProtoInstance()
		{
			return metadataProtoInstance;
		}

	/**
	 * Indicate whether an object is available for inputOutput SFNode field <i>metadata</i>.
	 * @return whether a properly typed node or ProtoInstance or CommentsBlock is available.
	 * @see #getMetadata()
	 * @see #getMetadataProtoInstance()
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#Metadata" target="_blank">X3D Scene Authoring Hints: Metadata Nodes</a>
	 */
	public boolean hasMetadata()
	{
		return (metadata != null) || (metadataProtoInstance != null);
	}
	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>speed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Default rate at which viewer travels through scene, meters/second. Warning: default 1 m/s usually seems slow for ordinary navigation. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of speed field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=Speed, $memberObjectName=speed, $memberObjectName=speed)

	public float getSpeed()
	{
		return speed;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>speed</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  [0,+infinity) Default rate at which viewer travels through scene, meters/second. Warning: default 1 m/s usually seems slow for ordinary navigation. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the speed field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setSpeed(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("NavigationInfo speed newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		speed = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat speed field, similar to {@link #setSpeed(float)}.
	 * @param newValue is new value for the speed field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setSpeed(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setSpeed(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setSpeed(float)}.
	 * @param newValue is new value for field
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setSpeed(double newValue)
	{
		return setSpeed((float) newValue);
	}
	/**
	 * Provide boolean value from outputOnly SFBool field named <i>transitionComplete</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Event signaling viewpoint transition complete. Interchange profile hint: this field may be ignored. Warning: it is an error to define this transient outputOnly field in an X3D file, instead only use it a source for ROUTE events.  * <br>

	 * @return value of transitionComplete field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=TransitionComplete, $memberObjectName=transitionComplete, $memberObjectName=transitionComplete)

	public boolean getTransitionComplete()
	{
		return transitionComplete;
	}
	/**
	 * Provide double value in seconds within allowed range of [0,infinity) from inputOutput SFTime field named <i>transitionTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  transitionTime defines the expected duration of viewpoint transition in seconds. Hint: If transitionType is "ANIMATE", transitionTime provides browser-dependent animation parameters. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of transitionTime field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=TransitionTime, $memberObjectName=transitionTime, $memberObjectName=transitionTime)

	public double getTransitionTime()
	{
		return transitionTime;
	}

	/**
	 * Accessor method to assign double value in seconds to inputOutput SFTime field named <i>transitionTime</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  transitionTime defines the expected duration of viewpoint transition in seconds. Hint: If transitionType is "ANIMATE", transitionTime provides browser-dependent animation parameters. Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the transitionTime field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setTransitionTime(double newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("NavigationInfo transitionTime newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		transitionTime = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFTime transitionTime field, similar to {@link #setTransitionTime(double)}.
	 * @param newValue is new value for the transitionTime field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setTransitionTime(SFTime newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setTransitionTime(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide array of String enumeration results with quoted value(s) ["TELEPORT","LINEAR","ANIMATE",...] from inputOutput MFString field named <i>transitionType</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Camera transition between viewpoints. Enter one or more quoted SFString values: "ANIMATE" "TELEPORT" "LINEAR". Hint: "ANIMATE" behavior is browser-specific, "TELEPORT" is immediate, and "LINEAR" may proceed directly through intervening objects.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #TRANSITIONTYPE_TELEPORT TELEPORT}, {@link #TRANSITIONTYPE_LINEAR LINEAR}, {@link #TRANSITIONTYPE_ANIMATE ANIMATE}.
	 * @return value of transitionType field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=TransitionType, $memberObjectName=transitionType, $memberObjectName=transitionType)

	public String[] getTransitionType()
	{
		final String[] valuesArray = new String[transitionType.size()];
		int i = 0;
		for (String arrayElement : transitionType) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString transitionType field, similar to {@link #getTransitionType()}.
	 * @return value of transitionType field
	 */
	public ArrayList<String> getTransitionTypeList()
	{
		return transitionType;
	}
	/**
	 * Utility method to get String value of MFString transitionType field, similar to {@link #getTransitionType()}.
	 * @return value of transitionType field
	 */
	public String getTransitionTypeString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : transitionType) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""TELEPORT"" | ""LINEAR"" | ""ANIMATE"") to inputOutput MFString field named <i>transitionType</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #TRANSITIONTYPE_TELEPORT TELEPORT}, {@link #TRANSITIONTYPE_LINEAR LINEAR}, {@link #TRANSITIONTYPE_ANIMATE ANIMATE}).
	 * <br><br>
	 * <i>Tooltip:</i>  Camera transition between viewpoints. Enter one or more quoted SFString values: "ANIMATE" "TELEPORT" "LINEAR". Hint: "ANIMATE" behavior is browser-specific, "TELEPORT" is immediate, and "LINEAR" may proceed directly through intervening objects.  * <br>

	 * @param newValue is new value for the transitionType field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setTransitionType(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearTransitionType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(TRANSITIONTYPE_TELEPORT) ||
			newValue[i].toString().replace("\"","").equals(TRANSITIONTYPE_LINEAR) ||
			newValue[i].toString().replace("\"","").equals(TRANSITIONTYPE_ANIMATE)))
		{
			String warningMessage = "[info] NavigationInfo transitionType newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!transitionTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"TELEPORT\", \"LINEAR\", \"ANIMATE\"";
			    transitionTypeWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearTransitionType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearTransitionType(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			transitionType.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString transitionType field, similar to {@link #setTransitionType(String[])}.
	 * @param newValue is new value for the transitionType field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setTransitionType(MFString newValue)
	{
		if (newValue == null)		{
			clearTransitionType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setTransitionType(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString transitionType field, similar to {@link #setTransitionType(String[])}.
	 * @param newValue is new value for the transitionType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setTransitionType(SFString newValue)
	{
		if (newValue == null)		{
			clearTransitionType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setTransitionType(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearTransitionType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_TELEPORT) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_LINEAR) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_ANIMATE)))
		{
			String warningMessage = "[info] NavigationInfo transitionType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!transitionTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"TELEPORT\", \"LINEAR\", \"ANIMATE\"";
			    transitionTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setTransitionType(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString transitionType field, similar to {@link #setTransitionType(String[])}.
	 * @param newValue is new value for the transitionType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setTransitionType(String newValue)
	{
		if (newValue == null)		{
			clearTransitionType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setTransitionType(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearTransitionType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_TELEPORT) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_LINEAR) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_ANIMATE)))
		{
			String warningMessage = "[info] NavigationInfo transitionType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!transitionTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"TELEPORT\", \"LINEAR\", \"ANIMATE\"";
			    transitionTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setTransitionType(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString transitionType field, similar to {@link #setTransitionType(String[])}.
	 * @param newValue is new value for the transitionType field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setTransitionType(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearTransitionType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearTransitionType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_TELEPORT) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_LINEAR) ||
			newValue.toString().replace("\"","").equals(TRANSITIONTYPE_ANIMATE)))
		{
			String warningMessage = "[info] NavigationInfo transitionType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!transitionTypeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"TELEPORT\", \"LINEAR\", \"ANIMATE\"";
			    transitionTypeWarningAlreadyProvided = true;
			}
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearTransitionType(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setTransitionType(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of transitionType field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public NavigationInfo clearTransitionType()
	{
		transitionType.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString transitionType field.
	 * @param newValue is new value to add to the transitionType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addTransitionType(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !transitionType.contains(newValue))
            transitionType.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString transitionType field.
	 * @param newValue is new value to add to the transitionType field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addTransitionType(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !transitionType.contains(newValue.getValue()))
            transitionType.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide array of String enumeration results with quoted value(s) ["ANY","WALK","EXAMINE","FLY","LOOKAT","NONE","EXPLORE",...] from inputOutput MFString field named <i>type</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Enter one or more quoted SFString values: "EXAMINE" "WALK" "FLY" "LOOKAT" "EXPLORE" "ANY" "NONE". Hint: for inspection of simple objects, usability often improves with type="EXAMINE" "ANY". Hint: types WALK and FLY force strict camera-to-object collision detection. Hint: see Collision node for further details on camera-to-object collision detection. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." ] Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * <br><br>
	 * Available enumeration values for string comparison: {@link #TYPE_ANY ANY}, {@link #TYPE_WALK WALK}, {@link #TYPE_EXAMINE EXAMINE}, {@link #TYPE_FLY FLY}, {@link #TYPE_LOOKAT LOOKAT}, {@link #TYPE_NONE NONE}, {@link #TYPE_EXPLORE EXPLORE}.
	 * @return value of type field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=Type, $memberObjectName=type, $memberObjectName=type)

	public String[] getType()
	{
		final String[] valuesArray = new String[type.size()];
		int i = 0;
		for (String arrayElement : type) {
			valuesArray[i++] = arrayElement;
		}
		return valuesArray;
	}
	/**
	 * Utility method to get ArrayList value of MFString type field, similar to {@link #getType()}.
	 * @return value of type field
	 */
	public ArrayList<String> getTypeList()
	{
		return type;
	}
	/**
	 * Utility method to get String value of MFString type field, similar to {@link #getType()}.
	 * @return value of type field
	 */
	public String getTypeString()
    {
        StringBuilder result = new StringBuilder();
		for (String arrayElement : type) {
			result.append("\"");
			result.append(arrayElement);
			result.append("\"");
			result.append(" ");
		}
		return result.toString().trim();
	}

	/**
	 * Accessor method to assign String enumeration array (""ANY"" | ""WALK"" | ""EXAMINE"" | ""FLY"" | ""LOOKAT"" | ""NONE"" | ""EXPLORE"") to inputOutput MFString field named <i>type</i>.
	 * <br><br>
	 * <i>Hint:</i> authors have option to choose from an extendible list of predefined enumeration values ({@link #TYPE_ANY ANY}, {@link #TYPE_WALK WALK}, {@link #TYPE_EXAMINE EXAMINE}, {@link #TYPE_FLY FLY}, {@link #TYPE_LOOKAT LOOKAT}, {@link #TYPE_NONE NONE}, {@link #TYPE_EXPLORE EXPLORE}).
	 * <br><br>
	 * <i>Tooltip:</i>  Enter one or more quoted SFString values: "EXAMINE" "WALK" "FLY" "LOOKAT" "EXPLORE" "ANY" "NONE". Hint: for inspection of simple objects, usability often improves with type="EXAMINE" "ANY". Hint: types WALK and FLY force strict camera-to-object collision detection. Hint: see Collision node for further details on camera-to-object collision detection. Hint: MFString arrays can have multiple values, so separate each individual string by quote marks "&lt;a href="https://www.web3d.org" target="_blank"&gt;https://www.web3d.org&lt;/a&gt;" "&lt;a href="https://www.web3d.org/about" target="_blank"&gt;https://www.web3d.org/about&lt;/a&gt;" "etc." ] Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the type field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setType(String[] newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
                {
                    clearType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph

        for (int i = 0; i < newValue.length; i++)
        {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || (newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"")) ||
                !newValue[i].trim().equals(priorValue))
            {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose())
                    System.out.println ("trimmed MFString newValue[" + i + "]=" + newValue[i]); // debug diagnostic

                // unquote quoted strings before comparison
                boolean reduced = false;
                if (newValue[i].startsWith("\""))
                {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\""))
                {
                    newValue[i] = newValue[i].substring(1, newValue[i].length()-1);
                    reduced = true;
                }
                if (reduced)
                    if (ConfigurationProperties.isConsoleOutputVerbose())
                        System.out.println ("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + 
                            " from prior value \"" + priorValue + "\""); // debug diagnostic
            }
		if (!(
			(newValue.length == 0) ||
			newValue[i].toString().replace("\"","").equals(TYPE_ANY) ||
			newValue[i].toString().replace("\"","").equals(TYPE_WALK) ||
			newValue[i].toString().replace("\"","").equals(TYPE_EXAMINE) ||
			newValue[i].toString().replace("\"","").equals(TYPE_FLY) ||
			newValue[i].toString().replace("\"","").equals(TYPE_LOOKAT) ||
			newValue[i].toString().replace("\"","").equals(TYPE_NONE) ||
			newValue[i].toString().replace("\"","").equals(TYPE_EXPLORE)))
		{
			String warningMessage = "[info] NavigationInfo type newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
			if (!typeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ANY\", \"WALK\", \"EXAMINE\", \"FLY\", \"LOOKAT\", \"NONE\", \"EXPLORE\"";
			    typeWarningAlreadyProvided = true;
			}
			if (newValue[i].contains(" "))
                            warningMessage += " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
                        warningMessage += "\n[warning] trace: NavigationInfo type MFString  newValue=" + newValue + " with newValue.getClass().getTypeName()=" + newValue.getClass().getTypeName();
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        }
		if (newValue == null)		{
			clearType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		clearType(); // reset
		for (int i = 0; i < newValue.length; i++)
		{
			type.add(newValue[i]);
		}

		return this;
	}

	/**
	 * Assign typed object value to MFString type field, similar to {@link #setType(String[])}.
	 * @param newValue is new value for the type field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setType(MFString newValue)
	{
		if (newValue == null)		{
			clearType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setType(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Assign single SFString object value to MFString type field, similar to {@link #setType(String[])}.
	 * @param newValue is new value for the type field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setType(SFString newValue)
	{
		if (newValue == null)		{
			clearType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast SFString value to MFString value if needed
                if ((newValue.getValue().length() - newValue.getValue().replace("\"", "").length()) > 2) // more than two quotation marks
                    return setType(new MFString(newValue));
		// set-newValue-validity-checks #2
		if (newValue == null)
                {
                    clearType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.getValue().isEmpty() ||
			newValue.toString().replace("\"","").equals(TYPE_ANY) ||
			newValue.toString().replace("\"","").equals(TYPE_WALK) ||
			newValue.toString().replace("\"","").equals(TYPE_EXAMINE) ||
			newValue.toString().replace("\"","").equals(TYPE_FLY) ||
			newValue.toString().replace("\"","").equals(TYPE_LOOKAT) ||
			newValue.toString().replace("\"","").equals(TYPE_NONE) ||
			newValue.toString().replace("\"","").equals(TYPE_EXPLORE)))
		{
			String warningMessage = "[info] NavigationInfo type newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!typeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ANY\", \"WALK\", \"EXAMINE\", \"FLY\", \"LOOKAT\", \"NONE\", \"EXPLORE\"";
			    typeWarningAlreadyProvided = true;
			}
                        warningMessage += "\n[warning] trace: NavigationInfo type MFString  newValue=" + newValue + " with newValue.getClass().getTypeName()=" + newValue.getClass().getTypeName();
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setType(MFString.cleanupEnumerationValues(newValue.toString())); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign singleton String value to MFString type field, similar to {@link #setType(String[])}.
	 * @param newValue is new value for the type field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setType(String newValue)
	{
		if (newValue == null)		{
			clearType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}

                // cast String value to MFString if needed
                if ((newValue.length() - newValue.replace("\"", "").length()) > 2) // more than two quotation marks
                    return setType(new MFString(newValue));
		// set-newValue-validity-checks #3
		if (newValue == null)
                {
                    clearType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			newValue.isEmpty() ||
			newValue.toString().replace("\"","").equals(TYPE_ANY) ||
			newValue.toString().replace("\"","").equals(TYPE_WALK) ||
			newValue.toString().replace("\"","").equals(TYPE_EXAMINE) ||
			newValue.toString().replace("\"","").equals(TYPE_FLY) ||
			newValue.toString().replace("\"","").equals(TYPE_LOOKAT) ||
			newValue.toString().replace("\"","").equals(TYPE_NONE) ||
			newValue.toString().replace("\"","").equals(TYPE_EXPLORE)))
		{
			String warningMessage = "[info] NavigationInfo type newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!typeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ANY\", \"WALK\", \"EXAMINE\", \"FLY\", \"LOOKAT\", \"NONE\", \"EXPLORE\"";
			    typeWarningAlreadyProvided = true;
			}
                        warningMessage += "\n[warning] trace: NavigationInfo type MFString  newValue=" + newValue + " with newValue.getClass().getTypeName()=" + newValue.getClass().getTypeName();
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
		setType(MFString.cleanupEnumerationValues(newValue)); // handle potential enumeration values
		return this;
	}
	/**
	 * Assign ArrayList value of MFString type field, similar to {@link #setType(String[])}.
	 * @param newValue is new value for the type field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setType(ArrayList<String> newValue)
	{
		if (newValue == null)		{
			clearType(); // newValueNullSetDEFAULT_VALUE
			return this;
		}
		// set-newValue-validity-checks #4
		if (newValue == null)
                {
                    clearType(); // null string check
                    return this;
                }

                // TODO check if SFString parameter has a multistring value, then split it
                // Check that newValue parameter has one of the allowed legal values before assigning to scene graph
		if (!(
			(newValue.size() == 0) ||
			newValue.toString().replace("\"","").equals(TYPE_ANY) ||
			newValue.toString().replace("\"","").equals(TYPE_WALK) ||
			newValue.toString().replace("\"","").equals(TYPE_EXAMINE) ||
			newValue.toString().replace("\"","").equals(TYPE_FLY) ||
			newValue.toString().replace("\"","").equals(TYPE_LOOKAT) ||
			newValue.toString().replace("\"","").equals(TYPE_NONE) ||
			newValue.toString().replace("\"","").equals(TYPE_EXPLORE)))
		{
			String warningMessage = "[info] NavigationInfo type newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
			if (!typeWarningAlreadyProvided)
			{
			    warningMessage += "\n" + "      Supported values are \"ANY\", \"WALK\", \"EXAMINE\", \"FLY\", \"LOOKAT\", \"NONE\", \"EXPLORE\"";
			    typeWarningAlreadyProvided = true;
			}
                        warningMessage += "\n[warning] trace: NavigationInfo type MFString  newValue=" + newValue + " with newValue.getClass().getTypeName()=" + newValue.getClass().getTypeName();
			if (ConfigurationProperties.isConsoleOutputVerbose())
			    System.out.println(warningMessage);
		}
        if (newValue.isEmpty())
            clearType(); // reset
        else
        {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); i++)
                newArray[i] = newValue.get(i);
            setType(newArray);
        }
		return this;
	}
	/**
	 * Utility method to clear MFString value of type field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	public NavigationInfo clearType()
	{
		type.clear(); // reset MF field
		return this;
	}

	/**
	 * Add singleton String value to MFString type field.
	 * @param newValue is new value to add to the type field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addType(String newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
        newValue = MFString.cleanupEnumerationValue(newValue); // handle potential enumeration value
		if (!newValue.isEmpty() && !type.contains(newValue))
            type.add(newValue); // only add if not already present

		return this;
	}
	/**
	 * Add singleton SFString value to MFString type field.
	 * @param newValue is new value to add to the type field.
	 * @see MFString#cleanupEnumerationValues(String)
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo addType(SFString newValue)
	{
		if (newValue == null)
		{
			return this; // nothing to do
		}
		
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue())); // handle potential enumeration value
		if (!newValue.getValue().isEmpty() && !type.contains(newValue.getValue()))
            type.add(newValue.getValue()); // only add if not already present

		return this;
	}

	/**
	 * Provide float value within allowed range of [0,infinity) from inputOutput SFFloat field named <i>visibilityLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Geometry beyond the visibilityLimit may not be rendered (far clipping plane of the view frustrum). Hint: visibilityLimit=0.0 indicates an infinite visibility limit (no far clipping plane). Hint: set visibilityLimit to appropriate positive value in meters to define far culling plane of view frustum. Hint: X3D specification recommends that browsers set near clipping plane to one-half of avatarSize.CollisionDistance value. Warning: important design thumbrule is to keep (visibilityLimit / avatarSize.CollisionDistance) &amp;lt; 10,000 to avoid aliasing artifacts (i.e. polygon "tearing"). Hint: Aliasing &lt;a href="https://en.wikipedia.org/wiki/Aliasing" target="_blank"&gt;https://en.wikipedia.org/wiki/Aliasing&lt;/a&gt; and Clipping &lt;a href="https://en.wikipedia.org/wiki/Clipping_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Clipping_(computer_graphics)&lt;/a&gt; Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @return value of visibilityLimit field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=VisibilityLimit, $memberObjectName=visibilityLimit, $memberObjectName=visibilityLimit)

	public float getVisibilityLimit()
	{
		return visibilityLimit;
	}

	/**
	 * Accessor method to assign float value to inputOutput SFFloat field named <i>visibilityLimit</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  Geometry beyond the visibilityLimit may not be rendered (far clipping plane of the view frustrum). Hint: visibilityLimit=0.0 indicates an infinite visibility limit (no far clipping plane). Hint: set visibilityLimit to appropriate positive value in meters to define far culling plane of view frustum. Hint: X3D specification recommends that browsers set near clipping plane to one-half of avatarSize.CollisionDistance value. Warning: important design thumbrule is to keep (visibilityLimit / avatarSize.CollisionDistance) &amp;lt; 10,000 to avoid aliasing artifacts (i.e. polygon "tearing"). Hint: Aliasing &lt;a href="https://en.wikipedia.org/wiki/Aliasing" target="_blank"&gt;https://en.wikipedia.org/wiki/Aliasing&lt;/a&gt; and Clipping &lt;a href="https://en.wikipedia.org/wiki/Clipping_(computer_graphics)" target="_blank"&gt;https://en.wikipedia.org/wiki/Clipping_(computer_graphics)&lt;/a&gt; Interchange profile hint: this field may be ignored, applying the default value regardless.  * <br>

	 * @param newValue is new value for the visibilityLimit field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public NavigationInfo setVisibilityLimit(float newValue)
	{
		// set-newValue-validity-checks #0.a
        // Check that newValue parameter has legal value(s) before assigning to scene graph
        if (newValue < 0f) {
            throw new org.web3d.x3d.sai.InvalidFieldValueException("NavigationInfo visibilityLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
		visibilityLimit = newValue;
		return this;
	}

	/**
	 * Assign typed object value to SFFloat visibilityLimit field, similar to {@link #setVisibilityLimit(float)}.
	 * @param newValue is new value for the visibilityLimit field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setVisibilityLimit(SFFloat newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setVisibilityLimit(newValue.getPrimitiveValue());
			return this;
	}

	/**
	 * Utility method: double-precision set-parameter accessor for X3D floating-point type, similar to {@link #setVisibilityLimit(float)}.
	 * @param newValue is new value for field
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setVisibilityLimit(double newValue)
	{
		return setVisibilityLimit((float) newValue);
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * @return value of DEF field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=DEF, $memberObjectName=DEF, $memberObjectName=DEF)

	public String getDEF()
	{
		// override abstract method in X3DConcreteNode
		return super.getDEF();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>DEF</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  DEF defines a unique ID name for this node, referenceable by other nodes. Hint: descriptive DEF names improve clarity and help document a model. Hint: well-defined names can simplify design and debugging through improved author understanding. Hint: X3D Scene Authoring Hints, Naming Conventions &lt;a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions" target="_blank"&gt;https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#NamingConventions&lt;/a&gt;  * <br>

	 * <br><br>
	 *  Note that setting the DEF value clears the USE value.
	 * @param newValue is new value for the DEF field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final NavigationInfo setDEF(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to NavigationInfo DEF
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("NavigationInfo DEF newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteUSE(""); // ensure that no previous USE value remains
		setConcreteDEF(newValue); // private superclass methods
		return this;
	}

	/**
	 * Assign typed object value to SFString DEF field, similar to {@link #setDEF(String)}.
	 * @param newValue is new value for the DEF field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setDEF(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setDEF(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * @return value of USE field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=USE, $memberObjectName=USE, $memberObjectName=USE)

	public String getUSE()
	{
		// override abstract method in X3DConcreteNode
		return super.getUSE();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>USE</i>.
	 * <br><br>
	 * <i>Tooltip:</i>  USE means reuse an already DEF-ed node ID, excluding all child nodes and all other attributes (except for containerField, which can have a different value). Hint: USE references to previously defined DEF geometry (instead of duplicating nodes) can improve performance. Warning: do NOT include any child nodes, a DEF attribute, or any other attribute values (except for containerField) when defining a USE attribute. Warning: each USE value must match a corresponding DEF value that is defined earlier in the scene.  * <br>

	 * <br><br>
	 * <i>Note:</i> each <code>USE</code> node is still an independent object, with the <code>USE</code> value matching the <code>DEF</code> value in the preceding object. 
	 * <br><br>
	 * <i>Warning:</i> invoking the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.<br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param newValue is new value for the USE field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final NavigationInfo setUSE(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String();
		// Check that newValue parameter meets naming requirements before assigning to NavigationInfo USE
		if (!newValue.isEmpty() && !org.web3d.x3d.jsail.fields.SFString.isNMTOKEN(newValue))
		{
			throw new org.web3d.x3d.sai.InvalidFieldValueException("NavigationInfo USE newValue='" + newValue + "'" + 
				" has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string" + 
				" (with legal characters and no embedded whitespace).");
		}
		setConcreteDEF(""); // ensure that no previous DEF value remains
		setConcreteUSE(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString USE field, similar to {@link #setUSE(String)}.
	 * @param newValue is new value for the USE field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setUSE(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setUSE(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>class</i>.
	 * @return value of class field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=CssClass, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssClass()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssClass();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>class</i>.
	 * @param newValue is new value for the class field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final NavigationInfo setCssClass(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssClass(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssClass(String)}.
	 * @param newValue is new value for the class field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setCssClass(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssClass(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>id</i>.
	 * @return value of id field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=HtmlID, $memberObjectName=HtmlID, $memberObjectName=HtmlID)

	public String getHtmlID()
	{
		// override abstract method in X3DConcreteNode
		return super.getHtmlID();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>id</i>.
	 * @param newValue is new value for the id field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final NavigationInfo setHtmlID(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteHtmlID(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString HtmlID field, similar to {@link #setHtmlID(String)}.
	 * @param newValue is new value for the id field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setHtmlID(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setHtmlID(newValue.getPrimitiveValue());
			return this;
	}
	/**
	 * Provide String value from inputOutput SFString field named <i>style</i>.
	 * @return value of style field
	 */
	// ($isInterface=false, $isException=false, $isServiceInterface=false, $isX3dStatement=false, $isClassX3dStatement=false, preceding-sibling::Inheritance=, $baseType=X3DBindableNode, $additionalInheritanceBaseType=, $thisClassName=NavigationInfo, $CamelCaseName=CssStyle, $memberObjectName=cssClass, $memberObjectName=cssClass)

	public String getCssStyle()
	{
		// override abstract method in X3DConcreteNode
		return super.getCssStyle();
	}

	/**
	 * Accessor method to assign String value to inputOutput SFString field named <i>style</i>.
	 * @param newValue is new value for the style field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */

	public final NavigationInfo setCssStyle(String newValue)
	{
		// set-newValue-validity-checks #0.a
		if (newValue == null)
			newValue = new String(); // Principle of Least Astonishment (POLA) #5
			// https://en.wikipedia.org/wiki/Principle_of_least_astonishment
		setConcreteCssStyle(newValue); // private superclass method
		return this;
	}

	/**
	 * Assign typed object value to SFString cssClass field, similar to {@link #setCssStyle(String)}.
	 * @param newValue is new value for the style field.
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setCssStyle(SFString newValue)
	{
			// set-newValue-validity-checks #1 gets handled by set-primitive method
			setCssStyle(newValue.getPrimitiveValue());
			return this;
	}

	// Additional utility methods for this class ==============================

	/**
	 * Assign a USE reference to another DEF node of same node type, similar to {@link #setUSE(String)}.
	 * <br ><br >
	 * <i>Warning:</i> note that the <code>setUSE()</code> method on this node resets all other fields to their default values (except for containerField) and also releases all child nodes.
	 * <br><br>
	 * <i>Warning:</i> no other operations can be performed to modify a USE node other than setting an alternate containerField value.
	 * @param DEFnode must have a DEF value defined
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	public NavigationInfo setUSE(NavigationInfo DEFnode)
	{
		if (DEFnode.getDEF().isEmpty())
		{
			String errorNotice = "setUSE(DEFnode) invoked on NavigationInfo" +
				" that has no DEF name defined, thus a copy cannot be referenced as a USE node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		setUSE(DEFnode.getDEF());
		return this;
	}
	/**
	 * Utility constructor that assigns DEF label after initializing member variables with default values.
	 * @param DEFlabel unique DEF name for this X3D node
	 */
	public NavigationInfo (String DEFlabel)
	{
		initialize();
		setDEF(DEFlabel); // apply checks
	}

	/**
	 * Add comment as String to contained commentsList.
	 * @param newComment initial value
	 * @see <a href="https://www.web3d.org/specifications/X3Dv4Draft/ISO-IEC19775-1v4-IS.proof/Part01/components/core.html#Organization">X3D Architecture, clause 7.2.5.1 Organization</a>
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive method invocations on the same object).
	 */
	/* @Override */
	public NavigationInfo addComments (String newComment)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(\"" + newComment + "\")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.add(newComment);
		return this;
	}
	/**
	 * Add comments as String[] array to contained commentsList.
	 * @param newComments array of comments
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public NavigationInfo addComments (String[] newComments)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(" + Arrays.toString(newComments) + ")" + "\n" +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(Arrays.asList(newComments));
		return this;
	}
	/**
	 * Add CommentsBlock to contained commentsList.
	 * @param newCommentsBlock block of comments to add
	 * @return {@link NavigationInfo} - namely <i>this</i> same object to allow sequential method pipelining (i.e. consecutive
setAttribute method invocations).
	 */
	/* @Override */
	public NavigationInfo addComments (CommentsBlock newCommentsBlock)
	{
		if (hasUSE())
		{
			String errorNotice = "addComments(CommentsBlock) " +
					"cannot be applied to a USE node (USE='" + getUSE() + "') which only contains a reference to a DEF node";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
								
		commentsList.addAll(newCommentsBlock.toStringList());
		return this;
	}
	/**
	 * Utility method to adjust field synonyms
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#fieldNameChanges">X3D Scene Authoring Hints: X3D4 Field name changes for improved consistency</a>
     */
    private void handleFieldSynonyms()
    {
            // no synonyms to handle
	}
		
	/**
	 * Recursive method to provide X3D string serialization of this model subgraph, utilizing XML encoding and conforming to X3D Canonical Form.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_X3D
	 * @see X3D#FILE_EXTENSION_XML
	 * @see X3D#toStringXML()
	 * @see X3D#toFileXML(String)
	 * @see X3D#toFileX3D(String)
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/X3D_XML.html">X3D XML Encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-3/V3.3/Part03/concepts.html#X3DCanonicalForm" target="blank">X3D Compressed Binary Encoding: X3D Canonical Form</a>
	 * @see <a href="https://www.web3d.org/x3d/tools/canonical/doc/x3dTools.htm">X3D Canonicalization (C14N) Tool</a>
	 * @return X3D string
	 */
	@Override
	public String toStringX3D(int indentLevel)
	{
		boolean hasAttributes = true; // TODO check for non-default attribute values
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
			hasChild = false; // USE nodes only include attributes for USE and non-default containerField
		handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder indent = new StringBuilder();
		int  indentIncrement = ConfigurationProperties.getIndentIncrement();
		char indentCharacter = ConfigurationProperties.getIndentCharacter();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		StringBuilder stringX3D = new StringBuilder();

		stringX3D.append(indent).append("<NavigationInfo"); // start opening tag
		if (hasAttributes)
		{
			if (!getDEF().equals(DEF_DEFAULT_VALUE) && !hasUSE())
			{
				stringX3D.append(" DEF='").append(SFString.toString(getDEF())).append("'");
			}
			
			if (!getUSE().equals(USE_DEFAULT_VALUE))
			{
				stringX3D.append(" USE='").append(SFString.toString(getUSE())).append("'");
			}
			
            // containerField is critical for ProtoInstance relationship to parent node
            if (!getContainerFieldOverride().isEmpty() && !getContainerFieldOverride().equals(this.getContainerFieldDefault())) // output if not default ProtoInstance containerField
            {
                    stringX3D.append(" containerField='").append(getContainerFieldOverride()).append("'");
            }

            // test attributes

			if (((getAvatarSize().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" avatarSize='").append(MFFloat.toString(getAvatarSize())).append("'");
			}
			if ((!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" class='").append(new SFString(getCssClass()).toStringX3D()).append("'");
			}
			if (((getHeadlight() != HEADLIGHT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" headlight='").append(SFBool.toString(getHeadlight())).append("'");
			}
			if ((!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" id='").append(new SFString(getHtmlID()).toStringX3D()).append("'");
			}
			if (((getSpeed() != SPEED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" speed='").append(SFFloat.toString(getSpeed())).append("'");
			}
			if ((!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* isSingleValueType */ && !hasUSE())
			{
				stringX3D.append(" style='").append(new SFString(getCssStyle()).toStringX3D()).append("'");
			}
			if (((getTransitionTime() != TRANSITIONTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" transitionTime='").append(SFTime.toString(getTransitionTime())).append("'");
			}
			if (((getTransitionType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" transitionType='").append(new MFString(getTransitionType()).toStringX3D()).append("'");
			}
			if (((getType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes()) /* ArrayList */ && !hasUSE())
			{
				stringX3D.append(" type='").append(new MFString(getType()).toStringX3D()).append("'");
			}
			if (((getVisibilityLimit() != VISIBILITYLIMIT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) /* simple type */ && !hasUSE())
			{
				stringX3D.append(" visibilityLimit='").append(SFFloat.toString(getVisibilityLimit())).append("'");
			}
		}
		if ((hasChild) && !hasUSE()) // has contained node(s), comment(s), IS/connect and/or source code
		{
			stringX3D.append(">").append("\n"); // finish opening tag

			// recursively iterate over child elements
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
			}
			if      (metadata != null)
			{
				stringX3D.append(((X3DConcreteElement)metadata).toStringX3D(indentLevel + indentIncrement));
			}
			else if (metadataProtoInstance != null)
			{
					 stringX3D.append(((X3DConcreteElement)metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
			}
			if      (IS != null)
			{
				stringX3D.append(((X3DConcreteElement)IS).toStringX3D(indentLevel + indentIncrement));
			}
			stringX3D.append(indent).append("</NavigationInfo>").append("\n"); // finish closing tag
		}
		else
		{
			stringX3D.append("/>").append("\n"); // otherwise finish singleton tag
		}
		return stringX3D.toString();
	}
// ($name=NavigationInfo, isX3dStatement=false, isClassX3dStatement=false, $hasChild=true, $hasAttributes=true
	/**
	 * Recursive method to provide ClassicVRML string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_CLASSICVRML
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/X3D_ClassicVRML.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/19776-2/V3.3/Part02/grammar.html">Extensible 3D (X3D) encodings Part 2: Classic VRML encoding, Annex A: Grammar</a>
	 * @return ClassicVRML string
	 */
	@Override     
	public String toStringClassicVRML(int indentLevel)
	{
		StringBuilder stringClassicVRML = new StringBuilder();
		boolean hasAttributes = true; // TODO further refinement
		boolean      hasChild = (IS != null) || (IS != null) || (metadata != null) || (metadataProtoInstance != null) || !commentsList.isEmpty();
		if (hasUSE())
		{
			hasAttributes = false;
			hasChild      = false; // USE nodes include no other fields
		}
        if (!serializingVRML97output)
            handleFieldSynonyms(); // adjust containerField values for X3D3 differences, if any
		StringBuilder  indent = new StringBuilder();
		char  indentCharacter = ConfigurationProperties.getIndentCharacter();
		int   indentIncrement = ConfigurationProperties.getIndentIncrement();
		for (int i = 0; i < indentLevel; i++)
			indent.append(indentCharacter); // level of indentation for this level

		if (!getDEF().equals(DEF_DEFAULT_VALUE))
		{
			stringClassicVRML.append("DEF ").append(SFString.toString(getDEF())).append(" ");
		}
		if (!getUSE().equals(USE_DEFAULT_VALUE))
		{
			 stringClassicVRML.append("USE ").append(SFString.toString(getUSE())).append("\n");
		}
		else // only have further output if not a USE node
		{
			stringClassicVRML.append("NavigationInfo").append(" { "); // define node name, node content follows

			if (hasAttributes || hasChild)
			{
				stringClassicVRML.append("\n").append(indent).append(indentCharacter); // fields for this node follow
			}
			if (hasAttributes)
			{
				boolean hasISconnect = (getIS() != null) && !getIS().getConnectList().isEmpty();
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("avatarSize"))
						{
							stringClassicVRML.append(indentCharacter).append("avatarSize").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getAvatarSize().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("avatarSize ").append("[ ").append(MFFloat.toString(getAvatarSize())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("class"))
						{
							stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssClass().equals(CLASS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(getCssClass())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("headlight"))
						{
							stringClassicVRML.append(indentCharacter).append("headlight").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getHeadlight() != HEADLIGHT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("headlight ").append(SFBool.toString(getHeadlight())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("id"))
						{
							stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getHtmlID().equals(ID_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(getHtmlID())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("speed"))
						{
							stringClassicVRML.append(indentCharacter).append("speed").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getSpeed() != SPEED_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("speed ").append(SFFloat.toString(getSpeed())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("style"))
						{
							stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if (!getCssStyle().equals(STYLE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(getCssStyle())).append("\"").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("transitionTime"))
						{
							stringClassicVRML.append(indentCharacter).append("transitionTime").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getTransitionTime() != TRANSITIONTIME_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("transitionTime ").append(SFTime.toString(getTransitionTime())).append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("transitionType"))
						{
							stringClassicVRML.append(indentCharacter).append("transitionType").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getTransitionType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("transitionType ").append("[ ").append(MFString.toString(getTransitionType())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("type"))
						{
							stringClassicVRML.append(indentCharacter).append("type").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getType().length > 0) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("type ").append("[ ").append(MFString.toString(getType())).append(" ]").append("\n").append(indent).append(indentCharacter);
				}
				if (hasISconnect)
				{
					for (connect element : getIS().getConnectList())
					{
						if (element.getNodeField().equals("visibilityLimit"))
						{
							stringClassicVRML.append(indentCharacter).append("visibilityLimit").append(" IS ").append(element.getProtoField()).append("\n").append(indent).append(indentCharacter); // found matching connect
						}
					}
				}
				else 
				if ((getVisibilityLimit() != VISIBILITYLIMIT_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes())
				{
					stringClassicVRML.append("visibilityLimit ").append(SFFloat.toString(getVisibilityLimit())).append("\n").append(indent).append(indentCharacter);
				}
			}
		}
		if (hasChild) // has contained node(s), comment(s), IS/connect and/or source code
		{
			// recursively iterate over child elements
			if (metadata != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadata).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode
			}
			else if (metadataProtoInstance != null)
			{
				stringClassicVRML.append(indentCharacter).append("metadata").append(" "); // containerField for SFNode
				stringClassicVRML.append(((X3DConcreteElement) metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
				stringClassicVRML.append(indent); // end SFNode ProtoInstance
			}
			if (IS != null)
			{
				stringClassicVRML.append(((X3DConcreteElement) IS).toStringClassicVRML(indentLevel)); // end X3D statement
			}
			if (!commentsList.isEmpty())
			{
				CommentsBlock commentsBlock = new CommentsBlock(commentsList);
				stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
				stringClassicVRML.append(indent); // end SFNode
			}
		}
		if (hasAttributes || hasChild)
		{
			stringClassicVRML.append("}").append("\n"); // finish node content
		}
		return stringClassicVRML.toString();
	}

    
    private boolean serializingVRML97output = false; // whether to avoid handling field name synonyms
                                
	/**
	 * Recursive method to provide VRML97 string serialization.
	 * @param indentLevel number of levels of indentation for this element
	 * @see X3D#FILE_EXTENSION_VRML97
	 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#VRML">X3D Resources: Virtual Reality Modeling Language (VRML) 97</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772/V2.0/index.html">Virtual Reality Modeling Language (VRML) 97 specification</a>
	 * @see <a href="https://www.web3d.org/documents/specifications/14772-1/V2.1/index.html">VRML 97 v2.1 Amendment</a>
	 * @return VRML97 string
	 */
	@Override
	public String toStringVRML97(int indentLevel)
	{
        serializingVRML97output = true;
        String result = toStringClassicVRML(indentLevel);
        serializingVRML97output = false;
                                
		return result;
	}

	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue)
	{
		return findElementByNameValue(nameValue, ""); // empty string is wildcard, any element match is allowed
	}
								
	/**
	 * Recursive method to provide object reference to node or statement by name attribute, if found as part of this element or in a contained element.
	 * Elements with name fields include meta, Metadata* nodes, field/fieldValue, ProtoDeclare/ExternProtoDeclare/ProtoInstance, CAD and HAnim nodes.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same name, this method does not handle that case.
	 * @see #findNodeByDEF(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @return object reference to found element, null otherwise
	 */
	/* @Override */
	public X3DConcreteElement findElementByNameValue(String nameValue, String elementName)
	{
		if ((nameValue == null) || nameValue.isEmpty())
		{
			String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		// no name field available for this element
		X3DConcreteElement referenceElement;
		if (IS != null)
		{
			referenceElement = ((X3DConcreteElement) IS).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadata != null)
		{
			referenceElement = ((X3DConcreteElement) metadata).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		if (metadataProtoInstance != null)
		{
			referenceElement = ((X3DConcreteElement) metadataProtoInstance).findElementByNameValue(nameValue, elementName);
			if (referenceElement != null)
				return referenceElement;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node or statement with given name attribute is found, meaning both objects are attached to same scene graph.
	 * @param nameValue is value of the name field being searched for in this element and child elements(if any)
	 * @param elementName identifies the element of interest (meta MetadataString ProtoDeclare CADassembly ProtoInstance HAnimHumanoid etc.)
	 * @see #findElementByNameValue(String, String)
	 * @return whether node is found
	 */
	public boolean hasElementByNameValue(String nameValue, String elementName)
	{
		return (findElementByNameValue(nameValue, elementName) != null);
	}

	/**
	 * Recursive method to provide object reference to node by DEF, if found as this node or in a contained node.
	 * <br ><br >
	 * <i>Warning:</i> first start with findAncestorScene() to check entire scene graph, or findAncestorX3D() to check entire model document.
	 * <br ><br >
	 * <i>Warning:</i> more than one element may be found that has the same DEF, this method does not handle that case.
	 * @see #findElementByNameValue(String)
	 * @see X3DConcreteElement#hasAncestorScene()
	 * @see org.web3d.x3d.jsail.X3DConcreteElement#findAncestorX3D()
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @return object reference to found node, null otherwise
	 */
	/* @Override */
	public X3DConcreteNode findNodeByDEF(String DEFvalue)
	{
		if ((DEFvalue == null) || DEFvalue.isEmpty())
		{
			String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldValueException(errorNotice);
		}
		if (getDEF().equals(DEFvalue))
			return this;
		X3DConcreteNode referenceNode;
		if (IS != null)
		{
			referenceNode = ((X3DConcreteElement) IS).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadata != null)
		{
			referenceNode = ((X3DConcreteElement) metadata).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		if (metadataProtoInstance != null)
		{
			referenceNode = ((X3DConcreteElement) metadataProtoInstance).findNodeByDEF(DEFvalue);
			if (referenceNode != null)
				return referenceNode;
		}
		return null; // not found
	}
	/**
	 * Recursive method to determine whether node with DEFvalue is found, meaning both objects are attached to same scene graph.
	 * @param DEFvalue is value of the name field being searched for in this element and child elements(if any)
	 * @see #findNodeByDEF(String)
	 * @return whether node is found
	 */
	public boolean hasNodeByDEF(String DEFvalue)
	{
		return (findNodeByDEF(DEFvalue) != null);
	}

		
	/**
	 * Recursive method to validate this element plus all contained nodes and statements, 
	 * using both datatype-specification value checks and regular expression (regex) checking of corresponding string values.
	 * @return validation results (if any)
	 */
	@Override
	public String validate()
	{
		validationResult = new StringBuilder(); // prepare for updated results

		setAvatarSize(getAvatarSize()); // exercise field checks, simple types
        
		setHeadlight(getHeadlight()); // exercise field checks, simple types
        
		setSpeed(getSpeed()); // exercise field checks, simple types
        
		setTransitionTime(getTransitionTime()); // exercise field checks, simple types
        
		setTransitionType(getTransitionType()); // exercise field checks, simple types
        
		setType(getType()); // exercise field checks, simple types
        
		setVisibilityLimit(getVisibilityLimit()); // exercise field checks, simple types
        
		if (!hasUSE()) // be careful! setting DEF via setDEF() method will reset USE value
			setDEF(getDEF()); // exercise field checks, simple types
        
		if (hasUSE()) // be careful! setting USE via setUSE() method resets all attributes to default values and wipes out all children
			setUSE(getUSE()); // exercise field checks, simple types
        
		setCssClass(getCssClass()); // exercise field checks, simple types
        
		setHtmlID(getHtmlID()); // exercise field checks, simple types
        
		setCssStyle(getCssStyle()); // exercise field checks, simple types
        
		if (IS != null)
		{
			setIS(getIS());
			((X3DConcreteElement) IS).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) IS).getValidationResult());
		}
		if (hasUSE() && hasIS()) // test USE restrictions
		{
			String errorNotice = "NavigationInfo USE='" + getUSE() + "' is not allowed to have contained SFNode IS";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "NavigationInfo USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (metadata != null)
		{
			setMetadata(getMetadata());
			((X3DConcreteElement) metadata).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadata).getValidationResult());
		}
		if (metadataProtoInstance != null)
		{
			setMetadata(getMetadataProtoInstance());
			((X3DConcreteElement) metadataProtoInstance).validate(); // exercise field checks, SFNode
			validationResult.append(((X3DConcreteElement) metadataProtoInstance).getValidationResult());
		}
		if ((metadata != null) && (metadataProtoInstance != null))
		{
			String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
			validationResult.append(errorNotice);
			throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
		}
		if (hasUSE() && hasMetadata()) // test USE restrictions
		{
			String errorNotice = "NavigationInfo USE='" + getUSE() + "' is not allowed to have contained SFNode metadata";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error
		}
		
		if (hasUSE() && !commentsList.isEmpty())// test USE restrictions
		{
			String errorNotice = "NavigationInfo USE='" + getUSE() + "' is not allowed to have contained comments";
			validationResult.append(errorNotice);
			throw new InvalidFieldValueException(errorNotice); // report error		
		}

		if (getIS() != null)
		{
			if (getIS().getConnectList().isEmpty())
			{
				String errorNotice = "IS statement present, but contains no connect statements";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidProtoException(errorNotice); // report error
			}				
			// TODO also check that this node has ancestor ProtoBody, and that a field with same name also exists, so that IS is legal
		}
		if (!getContainerFieldOverride().isEmpty() &&
			!Arrays.asList(containerField_ALTERNATE_VALUES).contains(getContainerFieldOverride()))
		{
			String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
				": illegal value encountered, containerField='" + getContainerFieldOverride() +
				"' but allowed values are containerField_ALTERNATE_VALUES='" + 
				new MFString(containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
			validationResult.append(errorNotice).append("\n");
			throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
		}

		// profile validation test, if connected to full scene
		if (findAncestorX3D() != null)
		{
			String     modelProfile = findAncestorX3D().getProfile();

			// check whether model has a satisfactory profile for this node
			boolean hasSatisfactorySupport = findAncestorX3D().supportsX3dProfile   (modelProfile) ||
                                             findAncestorX3D().supportsX3dComponent (COMPONENT, LEVEL);
                        
			if (!hasSatisfactorySupport)
			{
				String errorNotice = ConfigurationProperties.ERROR_ILLEGAL_VALUE + 
					" insufficient X3D profile='" + modelProfile +
					"' for current X3D model containing 'NavigationInfo' node, ensure sufficient support by adding head statement <component name='Navigation' level='1'/>\n" +
					"or Java source-code assignment: " +
					" findAncestorX3D().getHead().addComponent(\"Navigation\").setLevel(1);";
				validationResult.append(errorNotice).append("\n");
				throw new org.web3d.x3d.sai.InvalidFieldException(errorNotice); // report error
			}
		}
		return validationResult.toString();
	}
}
