/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.tests;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.MFBool;
import org.web3d.x3d.jsail.fields.MFColor;
import org.web3d.x3d.jsail.fields.MFColorRGBA;
import org.web3d.x3d.jsail.fields.MFDouble;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFImage;
import org.web3d.x3d.jsail.fields.MFInt32;
import org.web3d.x3d.jsail.fields.MFMatrix3d;
import org.web3d.x3d.jsail.fields.MFMatrix3f;
import org.web3d.x3d.jsail.fields.MFMatrix4d;
import org.web3d.x3d.jsail.fields.MFMatrix4f;
import org.web3d.x3d.jsail.fields.MFRotation;
import org.web3d.x3d.jsail.fields.MFTime;
import org.web3d.x3d.jsail.fields.MFVec2d;
import org.web3d.x3d.jsail.fields.MFVec2f;
import org.web3d.x3d.jsail.fields.MFVec3d;
import org.web3d.x3d.jsail.fields.MFVec3f;
import org.web3d.x3d.jsail.fields.MFVec4d;
import org.web3d.x3d.jsail.fields.MFVec4f;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFColor;
import org.web3d.x3d.jsail.fields.SFColorRGBA;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFImage;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFMatrix3d;
import org.web3d.x3d.jsail.fields.SFMatrix3f;
import org.web3d.x3d.jsail.fields.SFMatrix4d;
import org.web3d.x3d.jsail.fields.SFMatrix4f;
import org.web3d.x3d.jsail.fields.SFRotation;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.jsail.fields.SFVec2d;
import org.web3d.x3d.jsail.fields.SFVec2f;
import org.web3d.x3d.jsail.fields.SFVec3d;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.jsail.fields.SFVec4d;
import org.web3d.x3d.jsail.fields.SFVec4f;

class FieldObjectTests {
    FieldObjectTests() {
    }

    @Test
    @DisplayName(value="Test initialization of all X3D SF/MF field objects")
    void fieldObjectInitializationsTest() {
        System.out.println("FieldObjectTests.fieldObjectInitializationsTest() start...");
        System.out.println("Preliminary tests...");
        Assertions.assertTrue((boolean)true, (String)"this test should explicitly pass");
        Assertions.assertFalse((boolean)false, (String)"this test should explicitly fail");
        this.SFBoolTests();
        this.MFBoolTests();
        this.SFImageTests();
        this.MFImageTests();
        this.SFInt32Tests();
        this.MFInt32Tests();
        this.SFFloatTests();
        this.SFDoubleTests();
        this.SFTimeTests();
        this.MFFloatTests();
        this.MFDoubleTests();
        this.MFTimeTests();
        this.SFVec2fTests();
        this.SFVec2dTests();
        this.MFVec2fTests();
        this.MFVec2dTests();
        this.SFVec3fTests();
        this.SFVec3fBboxSizeTests();
        this.SFVec3dTests();
        this.MFVec3fTests();
        this.MFVec3dTests();
        this.SFVec4fTests();
        this.SFVec4dTests();
        this.MFVec4fTests();
        this.MFVec4dTests();
        this.SFColorTests();
        this.MFColorTests();
        this.SFColorRGBATests();
        this.MFColorRGBATests();
        this.SFRotationTests();
        this.MFRotationTests();
        this.SFMatrix3fTests();
        this.SFMatrix3dTests();
        this.MFMatrix3fTests();
        this.MFMatrix3dTests();
        this.SFMatrix4fTests();
        this.SFMatrix4dTests();
        this.MFMatrix4fTests();
        this.MFMatrix4dTests();
        System.out.println("FieldObjectTests.fieldObjectInitializationsTest() complete");
    }

    @Test
    @DisplayName(value="Test SFBool single-field boolean")
    void SFBoolTests() {
        System.out.println("SFBoolTests...");
        Assertions.assertTrue((false == new SFBool().setValueByString("false").getPrimitiveValue() ? 1 : 0) != 0, (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFBool testSFBool = new SFBool();
        Assertions.assertFalse((boolean)false, (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)testSFBool.matches(), (String)"testSFBool.matches() tests that object initialization correctly matches regex");
        Assertions.assertTrue((boolean)SFBool.matches("false"), (String)"SFBool.matches(SFBool.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFBool.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(true|false)\\s*".contains("^") && !"\\s*(true|false)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFBool.REGEX does not contain anchor characters ^ or $");
        testSFBool.setValue(true);
        Assertions.assertTrue((boolean)testSFBool.getValue(), (String)"tests setting object value to true results in value of true");
        testSFBool.setValue(false);
        Assertions.assertFalse((boolean)testSFBool.getValue(), (String)"tests setting object value to false results in value of false");
        Assertions.assertTrue((boolean)SFBool.matches("true"), (String)"SFBool.matches(\"true\")  tests correct string value");
        Assertions.assertTrue((boolean)SFBool.matches("false"), (String)"SFBool.matches(\"false\") tests correct string value");
        Assertions.assertTrue((boolean)SFBool.matches("  true "), (String)"SFBool.matches(\"  true \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFBool.matches(" false "), (String)"SFBool.matches(\" false \") tests correct string value, including external whitespace");
        Assertions.assertFalse((boolean)SFBool.matches(""), (String)"SFBool.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFBool.matches(","), (String)"SFBool.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFBool.matches("true,"), (String)"SFBool.matches(\"true,\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFBool.matches(",false"), (String)"SFBool.matches(\",false\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFBool.matches("TRUE"), (String)"SFBool.matches(\"TRUE\")  tests incorrect case of string value");
        Assertions.assertFalse((boolean)SFBool.matches("FALSE"), (String)"SFBool.matches(\"FALSE\") tests incorrect case of string value");
        Assertions.assertFalse((boolean)SFBool.matches("rtue"), (String)"SFBool.matches(\"rtue\") tests incorrect ordering of characters in string value");
        Assertions.assertFalse((boolean)SFBool.matches("aflse"), (String)"SFBool.matches(\"aflse\") tests incorrect ordering of characters in string value");
        Assertions.assertFalse((boolean)SFBool.matches("blah"), (String)"SFBool.matches(\"blah\")  tests incorrect string value");
        Assertions.assertFalse((boolean)SFBool.matches("NaN"), (String)"SFBool.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFBool multiple-field boolean")
    void MFBoolTests() {
        System.out.println("MFBoolTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFBool.DEFAULT_VALUE, new MFBool().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFBool testMFBool = new MFBool();
        boolean[] emptyArray = new boolean[]{};
        boolean[] singleTrueArray = new boolean[]{true};
        boolean[] singleFalseArray = new boolean[]{false};
        boolean[] trueTrueArray = new boolean[]{true, true};
        boolean[] trueFalseArray = new boolean[]{true, false};
        boolean[] falseTrueArray = new boolean[]{false, true};
        boolean[] falseFalseArray = new boolean[]{false, false};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFBool.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)testMFBool.matches(), (String)"testMFBool.matches() tests that object initialization correctly matches regex");
        Assertions.assertTrue((boolean)MFBool.matches(""), (String)"MFBool.matches(MFBool.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFBool.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((true|false)\\s*,?\\s*)*".contains("^") && !"\\s*((true|false)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFBool.REGEX does not contain anchor characters ^ or $");
        testMFBool.setValue(true);
        Assertions.assertTrue((boolean)Arrays.equals(singleTrueArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean true results in same value");
        Assertions.assertTrue((boolean)testMFBool.get1Value(0), (String)"tests setting object value to true results in get1Value(index 0) of true");
        testMFBool.setValue(false);
        Assertions.assertTrue((boolean)Arrays.equals(singleFalseArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean false results in same value");
        Assertions.assertFalse((boolean)testMFBool.get1Value(0), (String)"tests setting object value to false results in get1Value(index 0) of false");
        testMFBool.setValue(singleTrueArray);
        Assertions.assertTrue((boolean)Arrays.equals(singleTrueArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { true } results in same value");
        testMFBool.setValue(false);
        Assertions.assertTrue((boolean)Arrays.equals(singleFalseArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean true results in same value");
        testMFBool.setValue(singleFalseArray);
        Assertions.assertTrue((boolean)Arrays.equals(singleFalseArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { false } results in same value");
        testMFBool.setValue(trueTrueArray);
        Assertions.assertTrue((boolean)Arrays.equals(trueTrueArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { true, true } results in same value");
        testMFBool.setValue(trueFalseArray);
        Assertions.assertTrue((boolean)Arrays.equals(trueFalseArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { true, false } results in same value");
        testMFBool.setValue(falseTrueArray);
        Assertions.assertTrue((boolean)Arrays.equals(falseTrueArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { false, true } results in same value");
        testMFBool.setValue(falseFalseArray);
        Assertions.assertTrue((boolean)Arrays.equals(falseFalseArray, testMFBool.getPrimitiveValue()), (String)"tests setting object value to boolean[] array { false, false } results in same value");
        Assertions.assertTrue((boolean)MFBool.matches(""), (String)"MFBool.matches(\"\") tests correct empty string value");
        Assertions.assertTrue((boolean)MFBool.matches("true"), (String)"MFBool.matches(\"true\")  tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("false"), (String)"MFBool.matches(\"false\") tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("true true"), (String)"MFBool.matches(\"true true\")   tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("true false"), (String)"MFBool.matches(\"true false\")  tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("false true"), (String)"MFBool.matches(\"false true\")  tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("false false"), (String)"MFBool.matches(\"false false\") tests correct string value");
        Assertions.assertTrue((boolean)MFBool.matches("  true "), (String)"MFBool.matches(\"  true \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFBool.matches(" false "), (String)"MFBool.matches(\" false \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFBool.matches("  true  true  "), (String)"MFBool.matches(\"  true \") tests correct string value, including whitespace");
        Assertions.assertTrue((boolean)MFBool.matches(" false  false "), (String)"MFBool.matches(\" false  false \") tests correct string value, including whitespace");
        Assertions.assertTrue((boolean)MFBool.matches("  false , true  "), (String)"MFBool.matches(\"  false , true \") tests correct string value, including whitespace and commas");
        Assertions.assertTrue((boolean)MFBool.matches(" true,  false "), (String)"MFBool.matches(\" true,  false \") tests correct string value, including whitespace and commas");
        Assertions.assertTrue((boolean)MFBool.matches(" true,  false , "), (String)"MFBool.matches(\" true,  false , \") tests correct string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFBool.matches(","), (String)"MFBool.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFBool.matches("TRUE"), (String)"MFBool.matches(\"TRUE\")  tests incorrect case of string value");
        Assertions.assertFalse((boolean)MFBool.matches("FALSE"), (String)"MFBool.matches(\"FALSE\") tests incorrect case of string value");
        Assertions.assertFalse((boolean)MFBool.matches("rtue"), (String)"MFBool.matches(\"rtue\") tests incorrect ordering of characters in string value");
        Assertions.assertFalse((boolean)MFBool.matches("aflse"), (String)"MFBool.matches(\"aflse\") tests incorrect ordering of characters in string value");
        Assertions.assertFalse((boolean)MFBool.matches("blah"), (String)"MFBool.matches(\"blah\")  tests incorrect string value");
        Assertions.assertFalse((boolean)MFBool.matches("NaN"), (String)"MFBool.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
        Assertions.assertFalse((boolean)MFBool.matches("true TRUE"), (String)"MFBool.matches(\"true TRUE\")  tests incorrect case of string value");
        Assertions.assertFalse((boolean)MFBool.matches("false FALSE"), (String)"MFBool.matches(\"false FALSE\") tests incorrect case of string value");
    }

    @Test
    @DisplayName(value="Test SFImage single-field variable-length integer/hexadecimal array")
    void SFImageTests() {
        System.out.println("SFImageTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFImage.DEFAULT_VALUE, new SFImage().setValueByString("0 0 0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFImage testSFImage = new SFImage();
        Assertions.assertTrue((boolean)testSFImage.matches(), (String)"testSFImage.matches() tests that object initialization correctly matches regex");
        int[] emptyArray = new int[]{};
        int[] defaultValueArray = new int[]{0, 0, 0};
        int[] singleValueArray = new int[]{1, 1, 1, 0};
        int[] doubleValueArray = new int[]{1, 2, 2, 65280, 65280};
        int[] tripleValueArray = new int[]{1, 3, 3, 0xFF0000, 65280, 255};
        int[] quadrupleValueArray = new int[]{2, 2, 2, 65280, 255, 61680, 255};
        int[] rgbaValueArray = new int[]{1, 3, 4, -16777080, 0xFF0088, 65416};
        Assertions.assertTrue((boolean)Arrays.equals(defaultValueArray, SFImage.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFImage.matches("0 0 0"), (String)"SFImage.matches(SFImage.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFImage.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*".contains("^") && !"\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFImage.REGEX does not contain anchor characters ^ or $");
        Assertions.assertFalse((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*"), (String)"test SFVec2f.REGEX.equals(SFImage.REGEX) returns false");
        testSFImage.setValue(0, 0, 0, emptyArray);
        Assertions.assertTrue((boolean)Arrays.equals(defaultValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (0, 0, 0, emptyArray) results in default singleton array with same value");
        testSFImage.setValue(defaultValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(defaultValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (defaultValueArray) results in default singleton array with same value");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"", (String)"tests defaultValueArray.getPixelsString()");
        testSFImage.setValue(singleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (singleValueArray) results in equivalent getPrimitiveValue()");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"0x00", (String)"tests singleValueArray.getPixelsString()");
        testSFImage.setValue(doubleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(doubleValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (doubleValueArray) results in equivalent getPrimitiveValue()");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"0xFF00 0xFF00", (String)"tests doubleValueArray.getPixelsString()");
        testSFImage.setValue(tripleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(tripleValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (tripleValueArray) results in equivalent getPrimitiveValue()");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"0xFF0000 0x00FF00 0x0000FF", (String)"tests tripleValueArray.getPixelsString()");
        testSFImage.setValue(quadrupleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(quadrupleValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (quadrupleValueArray) results in equivalent getPrimitiveValue()");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"0xFF00 0x00FF 0xF0F0 0x00FF", (String)"tests quadrupleValueArray.getPixelsString()");
        testSFImage.setValue(rgbaValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(rgbaValueArray, testSFImage.getPrimitiveValue()), (String)"tests setting object value to (rgbaValueArray) results in equivalent getPrimitiveValue()");
        Assertions.assertEquals((Object)testSFImage.getPixelsString(), (Object)"0xFF000088 0x00FF0088 0x0000FF88", (String)"tests rgbaValueArray.getPixelsString()");
        Assertions.assertTrue((boolean)SFImage.matches("0 0 0"), (String)"SFImage.matches( \"0 0 0\")   tests correct string value");
        String valueHexadecimalInput = " 1 2 3 0x040404 0x050505 ";
        String valueHexadecimalString = "1 2 3 0x40404 0x50505";
        String valueDecimalString = "1 2 3 263172 328965";
        Assertions.assertTrue((boolean)SFImage.matches(valueHexadecimalInput), (String)("SFImage.matches( \"" + valueHexadecimalInput + "\")   tests correct string value"));
        Assertions.assertTrue((boolean)testSFImage.setValueByString(valueHexadecimalInput).matches(), (String)"testSFImage.setValueByString(\" 1 2 3 0x040404 0x050505 \").matches() tests correct string value");
        Assertions.assertTrue((boolean)testSFImage.toStringHexadecimal().equals(valueHexadecimalString), (String)"testSFImage.toStringHexadecimal() tests correct string output");
        ConfigurationProperties.setSFImagePixelOutputHexadecimal(false);
        Assertions.assertFalse((boolean)ConfigurationProperties.isSFImagePixelOutputHexadecimal(), (String)"test ConfigurationProperties.setSFImagePixelOutputHexadecimal(false)");
        Assertions.assertTrue((boolean)testSFImage.toStringDecimal().equals(valueDecimalString), (String)"testSFImage.toStringDecimal() tests correct string output");
        Assertions.assertTrue((boolean)testSFImage.toString().equals(testSFImage.toStringDecimal()), (String)"testSFImage.toString() checks Decimal string output");
        ConfigurationProperties.setSFImagePixelOutputHexadecimal(true);
        Assertions.assertTrue((boolean)ConfigurationProperties.isSFImagePixelOutputHexadecimal(), (String)"test ConfigurationProperties.setSFImagePixelOutputHexadecimal(true)");
        Assertions.assertTrue((boolean)testSFImage.toString().equals(testSFImage.toStringHexadecimal()), (String)"testSFImage.toString() checks Hexadecimal string output");
        Assertions.assertFalse((boolean)SFImage.matches(""), (String)"SFImage.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFImage.matches(","), (String)"SFImage.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFImage.matches("true false"), (String)"SFImage.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFImage.matches("blah"), (String)"SFImage.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFImage.matches("NaN NaN"), (String)"SFImage.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFImage multi-field variable-length integer/hexadecimal array")
    void MFImageTests() {
        System.out.println("MFImageTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFImage.DEFAULT_VALUE, new MFImage().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFImage testMFImage = new MFImage();
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests that object initialization correctly matches regex");
        int[] emptyArray = new int[]{};
        int[] defaultValueArray = new int[]{0, 0, 0};
        int[] singleValueArray = new int[]{1, 1, 1, 0};
        int[] doubleValueArray = new int[]{1, 2, 2, 65280, 65280};
        int[] tripleValueArray = new int[]{1, 3, 3, 0xFF0000, 65280, 255};
        int[] quadrupleValueArray = new int[]{2, 2, 2, 65280, 255, 61680, 255};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFImage.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFImage.matches(""), (String)"MFImage.matches(MFImage.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFImage.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*".contains("^") && !"\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFImage.REGEX does not contain anchor characters ^ or $");
        Assertions.assertFalse((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*"), (String)"test MFVec2f.REGEX.equals(MFImage.REGEX) returns false");
        testMFImage.setValue(emptyArray);
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests emptyArray initialization correctly matches regex");
        testMFImage.setValue(defaultValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(defaultValueArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to defaultValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests defaultValueArray correctly matches regex");
        testMFImage.setValue(singleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests singleValueArray correctly matches regex");
        testMFImage.setValue(doubleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(doubleValueArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests doubleValueArray correctly matches regex");
        testMFImage.setValue(tripleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(tripleValueArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests tripleValueArray correctly matches regex");
        testMFImage.setValue(quadrupleValueArray);
        Assertions.assertTrue((boolean)Arrays.equals(quadrupleValueArray, testMFImage.getPrimitiveValue()), (String)"tests setting object value to quadrupleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFImage.matches(), (String)"testMFImage.matches() tests quadrupleValueArray correctly matches regex");
        String valueHexadecimalInput = " 1 2 3 0x040404 0x050505 ";
        String valueHexadecimalString = "1 2 3 0x40404 0x50505";
        String valueDecimalString = "1 2 3 263172 328965";
        Assertions.assertTrue((boolean)SFImage.matches(valueHexadecimalInput), (String)("SFImage.matches( \"" + valueHexadecimalInput + "\")   tests correct string value"));
        Assertions.assertTrue((boolean)testMFImage.setValueByString(valueHexadecimalInput).matches(), (String)"testMFImage.setValueByString(\" 1 2 3 0x040404 0x050505 \").matches() tests correct string value");
        Assertions.assertTrue((boolean)testMFImage.toStringHexadecimal().equals(valueHexadecimalString), (String)"testMFImage.toStringHexadecimal() tests correct string output");
        ConfigurationProperties.setSFImagePixelOutputHexadecimal(false);
        Assertions.assertFalse((boolean)ConfigurationProperties.isSFImagePixelOutputHexadecimal(), (String)"test ConfigurationProperties.setSFImagePixelOutputHexadecimal(false)");
        Assertions.assertTrue((boolean)testMFImage.toStringDecimal().equals(valueDecimalString), (String)"testMFImage.toStringDecimal() tests correct string output");
        Assertions.assertTrue((boolean)testMFImage.toString().equals(testMFImage.toStringDecimal()), (String)"testMFImage.toString() checks Decimal string output");
        ConfigurationProperties.setSFImagePixelOutputHexadecimal(true);
        Assertions.assertTrue((boolean)ConfigurationProperties.isSFImagePixelOutputHexadecimal(), (String)"test ConfigurationProperties.setSFImagePixelOutputHexadecimal(true)");
        Assertions.assertTrue((boolean)testMFImage.toString().equals(testMFImage.toStringHexadecimal()), (String)"testMFImage.toString() checks Hexadecimal string output");
        Assertions.assertTrue((boolean)MFImage.matches(""), (String)"MFImage.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFImage.matches(","), (String)"MFImage.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFImage.matches("true false"), (String)"MFImage.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFImage.matches("blah"), (String)"MFImage.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFImage.matches("NaN NaN"), (String)"MFImage.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFInt32 single-field 32-bit integer")
    void SFInt32Tests() {
        System.out.println("SFInt32Tests...");
        Assertions.assertTrue((0 == new SFInt32().setValueByString("0").getPrimitiveValue() ? 1 : 0) != 0, (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFInt32 testSFInt32 = new SFInt32();
        Assertions.assertTrue((boolean)testSFInt32.matches(), (String)"testSFInt32.matches() tests that object initialization correctly matches regex");
        Assertions.assertEquals((int)0, (int)0, (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFInt32.matches("0"), (String)"SFInt32.matches(SFInt32.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFInt32.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*[+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*".contains("^") && !"\\s*[+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFInt32.REGEX does not contain anchor characters ^ or $");
        testSFInt32.setValue(10);
        Assertions.assertTrue((boolean)testSFInt32.toStringHexadecimal().equalsIgnoreCase("0xA"), (String)"test SFInt32.toStringHexadecimal().equalsIgnoreCase(\"A\") tests hexadecimal output");
        testSFInt32.setValue(1);
        Assertions.assertEquals((int)1, (int)testSFInt32.getValue(), (String)"tests setting object value to 1 results in value of 1");
        testSFInt32.setValue(-1);
        Assertions.assertEquals((int)-1, (int)testSFInt32.getValue(), (String)"tests setting object value to -1 results in value of -1");
        Assertions.assertTrue((boolean)SFInt32.matches("0"), (String)"SFInt32.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)SFInt32.matches("1"), (String)"SFInt32.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFInt32.matches("-1"), (String)"SFInt32.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFInt32.matches("  3 "), (String)"SFInt32.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFInt32.matches(" -3 "), (String)"SFInt32.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFInt32.matches("  12E45  "), (String)"SFInt32.matches(\"  12E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFInt32.matches(" +12E+45 "), (String)"SFInt32.matches(\" +12E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFInt32.matches(" -12E-45 "), (String)"SFInt32.matches(\" -12E-45 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFInt32.matches(""), (String)"SFInt32.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFInt32.matches(","), (String)"SFInt32.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFInt32.matches("true"), (String)"SFInt32.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFInt32.matches("blah"), (String)"SFInt32.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFInt32.matches("0 1"), (String)"SFInt32.matches(\"0 1\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFInt32.matches("NaN"), (String)"SFInt32.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFInt32 multi-field 32-bit integer array")
    void MFInt32Tests() {
        System.out.println("MFInt32Tests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFInt32.DEFAULT_VALUE, new MFInt32().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFInt32 testMFInt32 = new MFInt32();
        Assertions.assertTrue((boolean)testMFInt32.matches(), (String)"testMFInt32.matches() tests that object initialization correctly matches regex");
        int[] emptyArray = new int[]{};
        int[] singleValueArray = new int[]{0};
        int[] doubleValueArray = new int[]{-1, -2};
        int[] tripleValueArray = new int[]{3, 4, 5};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFInt32.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)MFInt32.matches(""), (String)"MFInt32.matches(MFInt32.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFInt32.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*([+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*,?\\s*)*".contains("^") && !"\\s*([+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFInt32.REGEX does not contain anchor characters ^ or $");
        testMFInt32.setValue(0);
        Assertions.assertEquals((int)0, (int)testMFInt32.get1Value(0), (String)"tests setting object value to 0 results in get1Value(index 0) of 0");
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testMFInt32.getPrimitiveValue()), (String)"tests setting object value to 0 results in singleton array with same value");
        testMFInt32.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFInt32.getPrimitiveValue(), (String)"tests setting object value to emptyArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFInt32.matches(), (String)"testMFInt32.matches() tests emptyArray initialization correctly matches regex");
        testMFInt32.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFInt32.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFInt32.matches(), (String)"testMFInt32.matches() tests singleValueArray initialization correctly matches regex");
        testMFInt32.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFInt32.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFInt32.matches(), (String)"testMFInt32.matches() tests doubleValueArray initialization correctly matches regex");
        testMFInt32.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFInt32.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFInt32.matches(), (String)"testMFInt32.matches() tests tripleValueArray initialization correctly matches regex");
        Assertions.assertTrue((boolean)MFInt32.matches(""), (String)"MFInt32.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFInt32.matches(","), (String)"MFInt32.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFInt32.matches("0"), (String)"MFInt32.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFInt32.matches("1"), (String)"MFInt32.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFInt32.matches("-1"), (String)"MFInt32.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFInt32.matches("  3 "), (String)"MFInt32.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFInt32.matches(" -3 "), (String)"MFInt32.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFInt32.matches(" 0  12E45  "), (String)"MFInt32.matches(\" 0  12E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFInt32.matches("+0 +12E+45 "), (String)"MFInt32.matches(\"+0 +12E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFInt32.matches("-0,-12E-45 "), (String)"MFInt32.matches(\"-0,-12E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFInt32.matches("0 1"), (String)"MFInt32.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFInt32.matches("0, 1"), (String)"MFInt32.matches(\"0, 1\")  tests correct array as string value, including whitespace and comma");
        Assertions.assertTrue((boolean)MFInt32.matches("0 , 1 , "), (String)"MFInt32.matches(\"0 , 1 , \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFInt32.matches("true"), (String)"MFInt32.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFInt32.matches("blah"), (String)"MFInt32.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFInt32.matches("NaN"), (String)"MFInt32.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFFloat single-field single-precision floating-point number")
    void SFFloatTests() {
        System.out.println("SFFloatTests...");
        Assertions.assertTrue((0.0f == new SFFloat().setValueByString("0.0").getPrimitiveValue() ? 1 : 0) != 0, (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFFloat testSFFloat = new SFFloat();
        Assertions.assertTrue((boolean)testSFFloat.matches(), (String)"testSFFloat.matches() tests that object initialization correctly matches regex");
        Assertions.assertEquals((float)0.0f, (float)0.0f, (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFFloat.matches("0.0"), (String)"SFFloat.matches(SFFloat.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFFloat.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFFloat.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFTime.REGEX) returns true");
        testSFFloat.setValue(1);
        Assertions.assertEquals((float)1.0f, (float)testSFFloat.getValue(), (String)"tests setting object value to 1 results in value of 1.0f");
        testSFFloat.setValue(1.0f);
        Assertions.assertEquals((float)1.0f, (float)testSFFloat.getValue(), (String)"tests setting object value to 1.0f results in value of 1.0f");
        testSFFloat.setValue(1.0);
        Assertions.assertEquals((float)1.0f, (float)testSFFloat.getValue(), (String)"tests setting object value to 1.0d results in value of 1.0f");
        testSFFloat.setValue(-1);
        Assertions.assertEquals((float)-1.0f, (float)testSFFloat.getValue(), (String)"tests setting object value to -1 results in value of -1.0f");
        Assertions.assertTrue((boolean)SFFloat.matches("0"), (String)"SFFloat.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("1"), (String)"SFFloat.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("-1"), (String)"SFFloat.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("0.0"), (String)"SFFloat.matches( \"0.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("1.0"), (String)"SFFloat.matches( \"1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("-1.0"), (String)"SFFloat.matches(\"-1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFFloat.matches("  3 "), (String)"SFFloat.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFFloat.matches(" -3 "), (String)"SFFloat.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFFloat.matches(" 12.3E45 "), (String)"SFFloat.matches(\" 12.3E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFFloat.matches("+12.3E+45"), (String)"SFFloat.matches(\"+12.3E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFFloat.matches("-12.3E-45"), (String)"SFFloat.matches(\"-12.3E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFFloat.matches(".6"), (String)"SFFloat.matches( \".6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFFloat.matches("-.6"), (String)"SFFloat.matches(\"-.6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFFloat.matches(".6e7"), (String)"SFFloat.matches( \".6e7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)SFFloat.matches("-.6e-7"), (String)"SFFloat.matches(\"-.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFFloat.matches(""), (String)"SFFloat.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFFloat.matches(","), (String)"SFFloat.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFFloat.matches("true"), (String)"SFFloat.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFFloat.matches("blah"), (String)"SFFloat.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFFloat.matches("0 1"), (String)"SFFloat.matches(\"0 1\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFFloat.matches("0.0 1.0"), (String)"SFFloat.matches(\"0.0 1.0\") tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFFloat.matches("NaN"), (String)"SFFloat.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFFloat multi-field single-precision floating-point array")
    void MFFloatTests() {
        System.out.println("MFFloatTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFFloat.DEFAULT_VALUE, new MFFloat().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFFloat testMFFloat = new MFFloat();
        Assertions.assertTrue((boolean)testMFFloat.matches(), (String)"testMFFloat.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f};
        float[] doubleValueArray = new float[]{-1.0f, -2.0f};
        float[] tripleValueArray = new float[]{3.0f, 4.0f, 5.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFFloat.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)MFFloat.matches(""), (String)"MFFloat.matches(MFFloat.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFFloat.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFFloat.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFTime.REGEX) returns true");
        testMFFloat.setValue(0.0f);
        Assertions.assertEquals((float)0.0f, (float)testMFFloat.get1Value(0), (String)"tests setting object value to 0.0f results in get1Value(index 0) of 0");
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testMFFloat.getPrimitiveValue()), (String)"tests setting object value to 0.0f results in singleton array with same value");
        testMFFloat.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFFloat.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFFloat.matches(), (String)"testMFFloat.matches() tests emptyArray initialization correctly matches regex");
        testMFFloat.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFFloat.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        testMFFloat.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFFloat.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        testMFFloat.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFFloat.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)MFFloat.matches(""), (String)"MFFloat.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFFloat.matches(","), (String)"MFFloat.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFFloat.matches("0"), (String)"MFFloat.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("1"), (String)"MFFloat.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("-1"), (String)"MFFloat.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("  3 "), (String)"MFFloat.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFFloat.matches(" -3 "), (String)"MFFloat.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFFloat.matches(" 0  12E45 "), (String)"MFFloat.matches(\"0  12E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("+0,+12E+45"), (String)"MFFloat.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("-0,-12E-45"), (String)"MFFloat.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("0.0"), (String)"MFFloat.matches( \"0.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("1.0"), (String)"MFFloat.matches( \"1.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("-1.0"), (String)"MFFloat.matches(\"-1.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFFloat.matches("  3.0 "), (String)"MFFloat.matches(\"  3.0 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFFloat.matches(" -3.0 "), (String)"MFFloat.matches(\" -3.0 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFFloat.matches("0 1"), (String)"MFFloat.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFFloat.matches("0.0 1.0"), (String)"MFFloat.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFFloat.matches(" 0.0  12.3E45  "), (String)"MFFloat.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("+0.0 +12.3E+45 "), (String)"MFFloat.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("-0.0,-12.3E-45 "), (String)"MFFloat.matches(\"-0.0,-12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches(".6 -.6 .6e7 -.6e-7"), (String)"MFFloat.matches(\".6 -.6 .6e7 -.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFFloat.matches("0 , 1 , "), (String)"MFFloat.matches(\"0 , 1 , \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFFloat.matches("true"), (String)"MFFloat.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFFloat.matches("blah"), (String)"MFFloat.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFFloat.matches("NaN"), (String)"MFFloat.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFDouble single-field double-precision floating-point number")
    void SFDoubleTests() {
        System.out.println("SFDoubleTests...");
        Assertions.assertTrue((0.0 == new SFDouble().setValueByString("0.0").getPrimitiveValue() ? 1 : 0) != 0, (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFDouble testSFDouble = new SFDouble();
        Assertions.assertTrue((boolean)testSFDouble.matches(), (String)"testSFDouble.matches() tests that object initialization correctly matches regex");
        Assertions.assertEquals((double)0.0, (double)0.0, (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFDouble.matches("0.0"), (String)"SFDouble.matches(SFDouble.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFDouble.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFDouble.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFTime.REGEX) returns true");
        testSFDouble.setValue(1);
        Assertions.assertEquals((double)1.0, (double)testSFDouble.getValue(), (String)"tests setting object value to 1 results in value of 1.0d");
        testSFDouble.setValue(1.0);
        Assertions.assertEquals((double)1.0, (double)testSFDouble.getValue(), (String)"tests setting object value to 1.0d results in value of 1.0d");
        testSFDouble.setValue(1.0);
        Assertions.assertEquals((double)1.0, (double)testSFDouble.getValue(), (String)"tests setting object value to 1.0d results in value of 1.0d");
        testSFDouble.setValue(-1);
        Assertions.assertEquals((double)-1.0, (double)testSFDouble.getValue(), (String)"tests setting object value to -1 results in value of -1.0d");
        Assertions.assertTrue((boolean)SFDouble.matches("0"), (String)"SFDouble.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("1"), (String)"SFDouble.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("-1"), (String)"SFDouble.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("0.0"), (String)"SFDouble.matches( \"0.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("1.0"), (String)"SFDouble.matches( \"1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("-1.0"), (String)"SFDouble.matches(\"-1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFDouble.matches("  3 "), (String)"SFDouble.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFDouble.matches(" -3 "), (String)"SFDouble.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFDouble.matches(".6"), (String)"SFDouble.matches( \".6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFDouble.matches("-.6"), (String)"SFDouble.matches(\"-.6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFDouble.matches(".6e7"), (String)"SFDouble.matches( \".6e7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)SFDouble.matches("-.6e-7"), (String)"SFDouble.matches(\"-.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFDouble.matches(" 0.0  12.3E45  "), (String)"SFDouble.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFDouble.matches("+0.0 +12.3E+45 "), (String)"SFDouble.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFDouble.matches("-0.0,-12.3E-45 "), (String)"SFDouble.matches(\"-0.0,-12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFDouble.matches(""), (String)"SFDouble.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFDouble.matches(","), (String)"SFDouble.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFDouble.matches("true"), (String)"SFDouble.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFDouble.matches("blah"), (String)"SFDouble.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFDouble.matches("0 1"), (String)"SFDouble.matches(\"0 1\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFDouble.matches("0.0 1.0"), (String)"SFDouble.matches(\"0.0 1.0\") tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFDouble.matches("NaN"), (String)"SFDouble.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFDouble multi-field double-precision floating-point array")
    void MFDoubleTests() {
        System.out.println("MFDoubleTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFDouble.DEFAULT_VALUE, new MFDouble().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFDouble testMFDouble = new MFDouble();
        Assertions.assertTrue((boolean)testMFDouble.matches(), (String)"testMFDouble.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0};
        double[] doubleValueArray = new double[]{-1.0, -2.0};
        double[] tripleValueArray = new double[]{3.0, 4.0, 5.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFDouble.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)MFDouble.matches(""), (String)"MFDouble.matches(MFDouble.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFDouble.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFDouble.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFTime.REGEX) returns true");
        testMFDouble.setValue(0.0);
        Assertions.assertEquals((double)0.0, (double)testMFDouble.get1Value(0), (String)"tests setting object value to 0.0 results in get1Value(index 0) of 0");
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testMFDouble.getPrimitiveValue()), (String)"tests setting object value to 0.0 results in singleton array with same value");
        testMFDouble.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFDouble.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFDouble.matches(), (String)"testMFDouble.matches() tests emptyArray initialization correctly matches regex");
        testMFDouble.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFDouble.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        testMFDouble.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFDouble.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        testMFDouble.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFDouble.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)MFDouble.matches(""), (String)"MFDouble.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFDouble.matches(","), (String)"MFDouble.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFDouble.matches("0"), (String)"MFDouble.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("1"), (String)"MFDouble.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("-1"), (String)"MFDouble.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("  3 "), (String)"MFDouble.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFDouble.matches(" -3 "), (String)"MFDouble.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFDouble.matches(" 0  12E45 "), (String)"MFDouble.matches(\" 0  12E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("+0 +12E+45 "), (String)"MFDouble.matches(\"+0 +12E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("-0,-12E-45 "), (String)"MFDouble.matches(\"-0,-12E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("0.0"), (String)"MFDouble.matches( \"0.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("1.0"), (String)"MFDouble.matches( \"1.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("-1.0"), (String)"MFDouble.matches(\"-1.0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFDouble.matches("  3.0 "), (String)"MFDouble.matches(\"  3.0 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFDouble.matches(" -3.0 "), (String)"MFDouble.matches(\" -3.0 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFDouble.matches("0 1"), (String)"MFDouble.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFDouble.matches("0.0 1.0"), (String)"MFDouble.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFDouble.matches(" 0.0  12.3E45  "), (String)"MFDouble.matches(\" 0.0  12.3E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("+0.0 +12.3E+45 "), (String)"MFDouble.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("-0.0,-12.3E-45 "), (String)"MFDouble.matches(\"-0.0,-12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches(".6 -.6 .6e7 -.6e-7"), (String)"MFDouble.matches(\".6 -.6 .6e7 -.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFDouble.matches("0 , 1 , "), (String)"MFDouble.matches(\"0 , 1 , \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFDouble.matches("true"), (String)"MFDouble.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFDouble.matches("blah"), (String)"MFDouble.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFDouble.matches("NaN"), (String)"MFDouble.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFTime single-field double-precision floating-point number")
    void SFTimeTests() {
        System.out.println("SFTimeTests...");
        Assertions.assertTrue((-1.0 == new SFTime().setValueByString("-1.0").getPrimitiveValue() ? 1 : 0) != 0, (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFTime testSFTime = new SFTime();
        Assertions.assertTrue((boolean)testSFTime.matches(), (String)"testSFTime.matches() tests that object initialization correctly matches regex");
        Assertions.assertEquals((double)-1.0, (double)-1.0, (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFTime.matches("-1.0"), (String)"SFTime.matches(SFTime.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFTime.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFTime.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFFloat.REGEX.equals(SFTime.REGEX) returns true");
        testSFTime.setValue(1);
        Assertions.assertEquals((double)1.0, (double)testSFTime.getValue(), (String)"tests setting object value to 1 results in value of 1.0d");
        testSFTime.setValue(1.0);
        Assertions.assertEquals((double)1.0, (double)testSFTime.getValue(), (String)"tests setting object value to 1.0d results in value of 1.0d");
        testSFTime.setValue(1.0);
        Assertions.assertEquals((double)1.0, (double)testSFTime.getValue(), (String)"tests setting object value to 1.0d results in value of 1.0d");
        testSFTime.setValue(-1);
        Assertions.assertEquals((double)-1.0, (double)testSFTime.getValue(), (String)"tests setting object value to -1 results in value of -1.0d");
        testSFTime.setValue(-2);
        Assertions.assertEquals((double)-2.0, (double)testSFTime.getValue(), (String)"tests setting object value to -2 results in value of -2.0d, a legal negative time value");
        Assertions.assertFalse((boolean)SFTime.matches(""), (String)"SFTime.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFTime.matches(","), (String)"SFTime.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)SFTime.matches("0"), (String)"SFTime.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("1"), (String)"SFTime.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("-1"), (String)"SFTime.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("0.0"), (String)"SFTime.matches( \"0.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("1.0"), (String)"SFTime.matches( \"1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("-1.0"), (String)"SFTime.matches(\"-1.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFTime.matches("-2.0"), (String)"SFTime.matches(\"-2.0\") tests correct string value, a legal negative time value");
        Assertions.assertTrue((boolean)SFTime.matches("  3 "), (String)"SFTime.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFTime.matches(" -3 "), (String)"SFTime.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFTime.matches(".6"), (String)"SFTime.matches( \".6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFTime.matches("-.6"), (String)"SFTime.matches(\"-.6\") tests correct string value, no leading digit before decimal point");
        Assertions.assertTrue((boolean)SFTime.matches(".6e7"), (String)"SFTime.matches( \".6e7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)SFTime.matches("-.6e-7"), (String)"SFTime.matches(\"-.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFTime.matches("true"), (String)"SFTime.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFTime.matches("blah"), (String)"SFTime.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFTime.matches("0 1"), (String)"SFTime.matches(\"0 1\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFTime.matches("0.0 1.0"), (String)"SFTime.matches(\"0.0 1.0\") tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFTime.matches("NaN"), (String)"SFTime.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFTime multi-field double-precision floating-point array")
    void MFTimeTests() {
        System.out.println("MFTimeTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFTime.DEFAULT_VALUE, new MFTime().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFTime testMFTime = new MFTime();
        Assertions.assertTrue((boolean)testMFTime.matches(), (String)"testMFTime.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0};
        double[] doubleValueArray = new double[]{-1.0, -2.0};
        double[] tripleValueArray = new double[]{3.0, 4.0, 5.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFTime.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)MFTime.matches(""), (String)"MFTime.matches(MFTime.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFTime.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFTime.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFDouble.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFFloat.REGEX.equals(MFTime.REGEX) returns true");
        testMFTime.setValue(0.0);
        Assertions.assertEquals((double)0.0, (double)testMFTime.get1Value(0), (String)"tests setting object value to 0.0 results in get1Value(index 0) of 0");
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testMFTime.getPrimitiveValue()), (String)"tests setting object value to 0.0 results in singleton array with same value");
        testMFTime.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFTime.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFTime.matches(), (String)"testMFTime.matches() tests emptyArray initialization correctly matches regex");
        testMFTime.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFTime.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        testMFTime.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFTime.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        testMFTime.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFTime.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)MFTime.matches(""), (String)"MFTime.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFTime.matches(","), (String)"MFTime.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFTime.matches("0"), (String)"MFTime.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("1"), (String)"MFTime.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("-1"), (String)"MFTime.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("  3 "), (String)"MFTime.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFTime.matches(" -3 "), (String)"MFTime.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFTime.matches(" 0 12E45  "), (String)"MFTime.matches(\"0  12E45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("+0,+12E+45"), (String)"MFTime.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("-0,-12E-45"), (String)"MFTime.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("0.0"), (String)"MFTime.matches( \"0\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("1.0"), (String)"MFTime.matches( \"1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("-1.0"), (String)"MFTime.matches(\"-1\")   tests correct string value");
        Assertions.assertTrue((boolean)MFTime.matches("  3.0 "), (String)"MFTime.matches(\"  3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFTime.matches(" -3.0 "), (String)"MFTime.matches(\" -3 \") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFTime.matches("0 1"), (String)"MFTime.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFTime.matches("0.0 1.0"), (String)"MFTime.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFTime.matches(" 0.0  12.3E45  "), (String)"MFTime.matches(\" 0.0  12.3E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("+0.0,+12.3E+45 "), (String)"MFTime.matches(\"+0.0,+12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("-0.0,-12.3E-45 "), (String)"MFTime.matches(\"-0.0,-12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches(".6 -.6 .6e7 -.6e-7"), (String)"MFTime.matches(\".6 -.6 .6e7 -.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFTime.matches("0 , 1 , "), (String)"MFTime.matches(\"0 , 1 , \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFTime.matches("true"), (String)"MFTime.matches(\"true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFTime.matches("blah"), (String)"MFTime.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFTime.matches("NaN"), (String)"MFTime.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec2f single-field 2-tuple single-precision floating-point array")
    void SFVec2fTests() {
        System.out.println("SFVec2fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec2f.DEFAULT_VALUE, new SFVec2f().setValueByString("0.0 0.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec2f testSFVec2f = new SFVec2f();
        Assertions.assertTrue((boolean)testSFVec2f.matches(), (String)"testSFVec2f.matches() tests that object initialization correctly matches regex");
        float[] singleValueArray = new float[]{0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec2f.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec2f.matches("0.0 0.0"), (String)"SFVec2f.matches(SFVec2f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec2f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec2f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec2f.REGEX.equals(SFVec2d.REGEX) returns true");
        testSFVec2f.setValue(0.0f, 0.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec2f.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec2f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec2f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec2f.matches("0 1"), (String)"SFVec2f.matches( \"0 1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec2f.matches("2 3"), (String)"SFVec2f.matches( \"2 3\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec2f.matches("-1 -2"), (String)"SFVec2f.matches(\"-1 -2\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec2f.matches(" 0  12E45 "), (String)"SFVec2f.matches(\"0  12E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2f.matches("+0 +12E+45"), (String)"SFVec2f.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2f.matches("-0 -12E-45"), (String)"SFVec2f.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2f.matches(" 0.0  1.0 "), (String)"SFVec2f.matches(\" 0.0  1.0 \") tests correct string value");
        Assertions.assertTrue((boolean)SFVec2f.matches("-1.0 -3.0"), (String)"SFVec2f.matches(\"-1.0 -3.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec2f.matches("0 1"), (String)"SFVec2f.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec2f.matches("0.0 1.0"), (String)"SFVec2f.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec2f.matches(" 0.0  12.3E45  "), (String)"SFVec2f.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2f.matches("+0.0 +12.3E+45 "), (String)"SFVec2f.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2f.matches("-0.0 -12.3E-45 "), (String)"SFVec2f.matches(\"-0.0 -12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec2f.matches(""), (String)"SFVec2f.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec2f.matches(","), (String)"SFVec2f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec2f.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFVec2f.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec2f.matches("true false"), (String)"SFVec2f.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec2f.matches("blah"), (String)"SFVec2f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec2f.matches("NaN NaN"), (String)"SFVec2f.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFVec2f multi-field 2-tuple single-precision floating-point array")
    void MFVec2fTests() {
        System.out.println("MFVec2fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec2f.DEFAULT_VALUE, new MFVec2f().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec2f testMFVec2f = new MFVec2f();
        Assertions.assertTrue((boolean)testMFVec2f.matches(), (String)"testMFVec2f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f};
        float[] doubleValueArray = new float[]{0.0f, 1.0f, -2.0f, -3.0f};
        float[] tripleValueArray = new float[]{0.0f, 1.0f, -2.0f, -3.0f, 4.0f, 5.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec2f.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec2f.matches(""), (String)"MFVec2f.matches(MFVec2f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec2f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec2f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec2f.REGEX.equals(MFVec2d.REGEX) returns true");
        testMFVec2f.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec2f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2f.matches(), (String)"testMFVec2f.matches() tests emptyArray initialization correctly matches regex");
        testMFVec2f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec2f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2f.matches(), (String)"testMFVec2f.matches() tests singleValueArray correctly matches regex");
        testMFVec2f.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec2f.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2f.matches(), (String)"testMFVec2f.matches() tests doubleValueArray correctly matches regex");
        testMFVec2f.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec2f.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2f.matches(), (String)"testMFVec2f.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec2f.matches("0 1  2 3"), (String)"MFVec2f.matches( \"0 1  2 3\")    tests correct string value");
        Assertions.assertTrue((boolean)MFVec2f.matches("0 1, 2 3"), (String)"MFVec2f.matches( \"0 1, 2 33\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec2f.matches("-1 -2, -3 -4"), (String)"MFVec2f.matches(\"-1 -2, -3 -4\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec2f.matches(" 0  12E45 "), (String)"MFVec2f.matches(\"0  12E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches("+0 +12E+45"), (String)"MFVec2f.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches("-0 -12E-45"), (String)"MFVec2f.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches(""), (String)"MFVec2f.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFVec2f.matches(","), (String)"MFVec2f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFVec2f.matches(" 0.0  1.0 "), (String)"MFVec2f.matches(\" 0.0  1.0 \") tests correct string value");
        Assertions.assertTrue((boolean)MFVec2f.matches("-1.0 -3.0"), (String)"MFVec2f.matches(\"-1.0 -3.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec2f.matches("0 1"), (String)"MFVec2f.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec2f.matches("0.0 1.0"), (String)"MFVec2f.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec2f.matches(" 0.0  12.3E45  "), (String)"MFVec2f.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches("+0.0 +12.3E+45 "), (String)"MFVec2f.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches("-0.0 -12.3E-45 "), (String)"MFVec2f.matches(\"-0.0 -12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches(".6 -.6 .6e7 -.6e-7"), (String)"MFVec2f.matches(\".6 -.6 .6e7 -.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec2f.matches("0 0, 1 1, "), (String)"MFVec2f.matches(\"0 0, 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec2f.matches("true false"), (String)"MFVec2f.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec2f.matches("blah"), (String)"MFVec2f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec2f.matches("NaN NaN"), (String)"MFVec2f.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec2d single-field 2-tuple double-precision floating-point array")
    void SFVec2dTests() {
        System.out.println("SFVec2dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec2d.DEFAULT_VALUE, new SFVec2d().setValueByString("0.0 0.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec2d testSFVec2d = new SFVec2d();
        Assertions.assertTrue((boolean)testSFVec2d.matches(), (String)"testSFVec2d.matches() tests that object initialization correctly matches regex");
        double[] singleValueArray = new double[]{0.0, 0.0};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec2d.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec2d.matches("0.0 0.0"), (String)"SFVec2d.matches(SFVec2d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec2d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec2d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec2f.REGEX.equals(SFVec2d.REGEX) returns true");
        testSFVec2d.setValue(0.0, 0.0);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec2d.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec2d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec2d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec2d.matches("0 1"), (String)"SFVec2d.matches( \"0 1\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec2d.matches("2 3"), (String)"SFVec2d.matches( \"2 3\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec2d.matches("-1 -2"), (String)"SFVec2d.matches(\"-1 -2\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec2d.matches(" 0  12E45 "), (String)"SFVec2d.matches(\"0  12E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2d.matches("+0 +12E+45"), (String)"SFVec2d.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2d.matches("-0 -12E-45"), (String)"SFVec2d.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2d.matches(" 0.0  1.0 "), (String)"SFVec2d.matches(\" 0.0  1.0 \") tests correct string value");
        Assertions.assertTrue((boolean)SFVec2d.matches("-1.0 -3.0"), (String)"SFVec2d.matches(\"-1.0 -3.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec2d.matches("0 1"), (String)"SFVec2d.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec2d.matches("0.0 1.0"), (String)"SFVec2d.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec2d.matches(" 0.0  12.3E45  "), (String)"SFVec2d.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2d.matches("+0.0 +12.3E+45 "), (String)"SFVec2d.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec2d.matches("-0.0 -12.3E-45 "), (String)"SFVec2d.matches(\"-0.0 -12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec2d.matches(""), (String)"SFVec2d.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec2d.matches(","), (String)"SFVec2d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec2d.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFVec2d.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec2d.matches("true false"), (String)"SFVec2d.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec2d.matches("blah"), (String)"SFVec2d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec2d.matches("NaN NaN"), (String)"SFVec2d.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFVec2d multi-field 2-tuple double-precision floating-point array")
    void MFVec2dTests() {
        System.out.println("MFVec2dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec2d.DEFAULT_VALUE, new MFVec2d().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec2d testMFVec2d = new MFVec2d();
        Assertions.assertTrue((boolean)testMFVec2d.matches(), (String)"testMFVec2d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0};
        double[] doubleValueArray = new double[]{0.0, 1.0, -2.0, -3.0};
        double[] tripleValueArray = new double[]{0.0, 1.0, -2.0, -3.0, 4.0, 5.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec2d.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec2d.matches(""), (String)"MFVec2d.matches(MFVec2d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec2d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec2d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec2f.REGEX.equals(MFVec2d.REGEX) returns true");
        testMFVec2d.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec2d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2d.matches(), (String)"testMFVec2d.matches() tests emptyArray initialization correctly matches regex");
        testMFVec2d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec2d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2d.matches(), (String)"testMFVec2d.matches() tests singleValueArray correctly matches regex");
        testMFVec2d.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec2d.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2d.matches(), (String)"testMFVec2d.matches() tests doubleValueArray correctly matches regex");
        testMFVec2d.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec2d.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec2d.matches(), (String)"testMFVec2d.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec2d.matches("0 1  2 3"), (String)"MFVec2d.matches( \"0 1  2 3\")    tests correct string value");
        Assertions.assertTrue((boolean)MFVec2d.matches("0 1, 2 3"), (String)"MFVec2d.matches( \"0 1, 2 33\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec2d.matches("-1 -2, -3 -4"), (String)"MFVec2d.matches(\"-1 -2, -3 -4\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec2d.matches(" 0  12E45 "), (String)"MFVec2d.matches(\"0  12E45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches("+0 +12E+45"), (String)"MFVec2d.matches(\"+0,+12E+45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches("-0 -12E-45"), (String)"MFVec2d.matches(\"-0,-12E-45\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches(""), (String)"MFVec2d.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFVec2d.matches(","), (String)"MFVec2d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFVec2d.matches(" 0.0  1.0 "), (String)"MFVec2d.matches(\" 0.0  1.0 \") tests correct string value");
        Assertions.assertTrue((boolean)MFVec2d.matches("-1.0 -3.0"), (String)"MFVec2d.matches(\"-1.0 -3.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec2d.matches("0 1"), (String)"MFVec2d.matches(\"0 1\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec2d.matches("0.0 1.0"), (String)"MFVec2d.matches(\"0.0 1.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec2d.matches(" 0.0  12.3E45  "), (String)"MFVec2d.matches(\" 0.0  12.3E45  \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches("+0.0 +12.3E+45 "), (String)"MFVec2d.matches(\"+0.0 +12.3E+45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches("-0.0 -12.3E-45 "), (String)"MFVec2d.matches(\"-0.0 -12.3E-45 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches(".6 -.6 .6e7 -.6e-7"), (String)"MFVec2d.matches(\".6 -.6 .6e7 -.6e-7\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec2d.matches("0 0, 1 1, "), (String)"MFVec2d.matches(\"0 0, 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec2d.matches("true false"), (String)"MFVec2d.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec2d.matches("blah"), (String)"MFVec2d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec2d.matches("NaN NaN"), (String)"MFVec2d.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec3f single-field 3-tuple single-precision floating-point array")
    void SFVec3fTests() {
        System.out.println("SFVec3fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec3f.DEFAULT_VALUE, new SFVec3f().setValueByString("0.0 0.0 0.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec3f testSFVec3f = new SFVec3f();
        Assertions.assertTrue((boolean)testSFVec3f.matches(), (String)"testSFVec3f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec3f.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec3f.matches("0.0 0.0 0.0"), (String)"SFVec3f.matches(SFVec3f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec3f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec3f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec3f.REGEX.equals(SFVec3d.REGEX) returns true");
        testSFVec3f.setValue(0.0f, 0.0f, 0.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec3f.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec3f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec3f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec3f.matches("0 1 2"), (String)"SFVec3f.matches( \"0 1 2\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec3f.matches("2 3 4"), (String)"SFVec3f.matches( \"2 3 4\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec3f.matches("-1 -2 -3"), (String)"SFVec3f.matches(\"-1 -2 -3\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec3f.matches(" 0  12E45  0"), (String)"SFVec3f.matches(\" 0  12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matches("+0 +12E+45 0"), (String)"SFVec3f.matches(\"+0 +12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matches("-0 -12E-45 0"), (String)"SFVec3f.matches(\"-0 -12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matches(" 0.0  1.0 2.0 "), (String)"SFVec3f.matches(\" 0.0  1.0 2.0 \") tests correct string value");
        Assertions.assertTrue((boolean)SFVec3f.matches("-1.0 -2.0 -3.0"), (String)"SFVec3f.matches(\"-1.0 -2.0 -3.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec3f.matches("0 1 2"), (String)"SFVec3f.matches(\"0 1 2\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec3f.matches("0.0 1.0 2.0"), (String)"SFVec3f.matches(\"0.0 1.0 2.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec3f.matches(" 0.0  12.3E45  0"), (String)"SFVec3f.matches(\" 0.0  12.3E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matches("+0.0 +12.3E+45 0"), (String)"SFVec3f.matches(\"+0.0 +12.3E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matches("-0.0 -12.3E-45 0"), (String)"SFVec3f.matches(\"-0.0 -12.3E-45 0\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec3f.matches(""), (String)"SFVec3f.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec3f.matches(","), (String)"SFVec3f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec3f.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFVec3f.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec3f.matches("true false false"), (String)"SFVec3f.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec3f.matches("blah"), (String)"SFVec3f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec3f.matches("NaN NaN NaN"), (String)"SFVec3f.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec3f bboxSizeType checks on single-field 3-tuple single-precision floating-point array")
    void SFVec3fBboxSizeTests() {
        System.out.println("SFVec3fBboxSizeTests for bounding box (bbox) constraints...");
        float[] defaultBboxSizeArray = new float[]{-1.0f, -1.0f, -1.0f};
        Assertions.assertTrue((boolean)Arrays.equals(SFVec3f.DEFAULT_VALUE_BBOXSIZETYPE, new SFVec3f().setValueByString("-1 -1 -1").getPrimitiveValue()), (String)"test DEFAULT_VALUE_BBOXSIZETYPE matches DEFAULT_VALUE_BBOXSIZETYPE_STRING for this field object");
        SFVec3f testSFVec3fBboxSize = new SFVec3f(SFVec3f.DEFAULT_VALUE_BBOXSIZETYPE);
        Assertions.assertTrue((boolean)testSFVec3fBboxSize.matches(), (String)"testSFVec3fBboxSize.matches() tests that object initialization correctly matches regex");
        Assertions.assertTrue((boolean)Arrays.equals(defaultBboxSizeArray, SFVec3f.DEFAULT_VALUE_BBOXSIZETYPE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec3f.matches("-1 -1 -1"), (String)"SFVec3f.matches(SFVec3f.DEFAULT_VALUE_BBOXSIZETYPE_STRING) tests object initialization correctly matches regex");
        Assertions.assertFalse((boolean)testSFVec3fBboxSize.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+]?(((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*)|((\\-1(\\.(0)*)?([Ee][+-]?[0]+)?\\s+){2}\\-1(\\.(0)*)?([Ee][+-]?[0]+)?)\\s*)?".contains("^") && !"\\s*((([+]?(((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*)|((\\-1(\\.(0)*)?([Ee][+-]?[0]+)?\\s+){2}\\-1(\\.(0)*)?([Ee][+-]?[0]+)?)\\s*)?".contains("$") ? 1 : 0) != 0, (String)"test SFVec3f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertFalse((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*((([+]?(((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*)|((\\-1(\\.(0)*)?([Ee][+-]?[0]+)?\\s+){2}\\-1(\\.(0)*)?([Ee][+-]?[0]+)?)\\s*)?"), (String)"test SFVec3f.REGEX.equals(SFVec3f.REGEX_BBOXSIZETYPE) returns false");
        testSFVec3fBboxSize.setValue(-1.0f, -1.0f, -1.0f);
        Assertions.assertTrue((boolean)Arrays.equals(defaultBboxSizeArray, testSFVec3fBboxSize.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f 0.0f results in singleton array with same value");
        testSFVec3fBboxSize.setValue(defaultBboxSizeArray);
        Assertions.assertEquals((Object)defaultBboxSizeArray, (Object)testSFVec3fBboxSize.getPrimitiveValue(), (String)"tests setting object value to default-value array results in equivalent getPrimitiveValue()");
        Assertions.assertFalse((boolean)SFVec3f.matches(""), (String)"tests empty string \"\" fails SFVec3f.matches(value), illegal value");
        Assertions.assertTrue((boolean)SFVec3f.matchesBboxSizeType(""), (String)"tests empty string \"\" passes SFVec3f.matchesBboxSizeType(value), legal value");
        Assertions.assertFalse((boolean)testSFVec3fBboxSize.setValue(-2.0f, -2.0f, -2.0f).matchesBboxSizeType(), (String)"tests setting object value to -2.0f -2.0f -2.0f fails");
        Assertions.assertFalse((boolean)testSFVec3fBboxSize.setValueByString("-2.0   -2.0   -2.0").matchesBboxSizeType(), (String)"tests setting object value to \"-2.0   -2.0   -2.0\" fails");
        Assertions.assertFalse((boolean)testSFVec3fBboxSize.setValue(-2.0f, -2.0f, -2.0f).matchesBboxSizeType(), (String)"tests setting object value to -2.0f -2.0f -2.0f fails");
        Assertions.assertTrue((boolean)SFVec3f.matches("-2.0 -2.0 -2.0"), (String)"tests \"-2.0 -2.0 -2.0\" passes SFVec3f.matches(value)");
        Assertions.assertFalse((boolean)SFVec3f.matchesBboxSizeType("-2.0 -2.0 -2.0"), (String)"tests \"-2.0 -2.0 -2.0\" fails  SFVec3f.matchesBboxSizeType(value)");
        Assertions.assertTrue((boolean)SFVec3f.matches(" 2.0  2.0  2.0"), (String)"tests \" 2.0  2.0  2.0\" passes SFVec3f.matches(value)");
        Assertions.assertTrue((boolean)SFVec3f.matchesBboxSizeType(" 2.0  2.0  2.0"), (String)"tests \" 2.0  2.0  2.0\" passes SFVec3f.matchesBboxSizeType(value)");
        Assertions.assertTrue((boolean)SFVec3f.matchesBboxSizeType(" -1e+00 -1e00 -1e-00 "), (String)"tests \" -1e+00 -1e00 -1e-00 \" passes SFVec3f.matchesBboxSizeType(value) for sentinel with scientific notation");
        Assertions.assertTrue((boolean)SFVec3f.matchesBboxSizeType(" 0.0  0.0  0.0"), (String)"tests \" 0.0  0.0  0.0\" passes SFVec3f.matchesBboxSizeType(value)");
        Assertions.assertFalse((boolean)SFVec3f.matchesBboxSizeType(" 0.0  0.0  0.0  0.0"), (String)"tests \" 0.0  0.0  0.0  0.0\" fails SFVec3f.matchesBboxSizeType(value), too many values");
        Assertions.assertFalse((boolean)SFVec3f.matchesBboxSizeType(" 0.0  0.0"), (String)"tests \" 0.0  0.0\" fails SFVec3f.matchesBboxSizeType(value), insufficient values");
    }

    @Test
    @DisplayName(value="Test MFVec3f multi-field 3-tuple single-precision floating-point array")
    void MFVec3fTests() {
        System.out.println("MFVec3fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec3f.DEFAULT_VALUE, new MFVec3f().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec3f testMFVec3f = new MFVec3f();
        Assertions.assertTrue((boolean)testMFVec3f.matches(), (String)"testMFVec3f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f};
        float[] doubleValueArray = new float[]{0.0f, 1.0f, -2.0f, -3.0f, -4.0f, -5.0f};
        float[] tripleValueArray = new float[]{0.0f, 1.0f, -2.0f, -3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec3f.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec3f.matches(""), (String)"MFVec3f.matches(MFVec3f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec3f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec3f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec3f.REGEX.equals(MFVec3d.REGEX) returns true");
        testMFVec3f.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec3f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3f.matches(), (String)"testMFVec3f.matches() tests emptyArray initialization correctly matches regex");
        testMFVec3f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec3f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3f.matches(), (String)"testMFVec3f.matches() tests singleValueArray correctly matches regex");
        testMFVec3f.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec3f.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3f.matches(), (String)"testMFVec3f.matches() tests doubleValueArray correctly matches regex");
        testMFVec3f.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec3f.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3f.matches(), (String)"testMFVec3f.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec3f.matches(" 0  1  2   3  4  5"), (String)"MFVec3f.matches( \" 0  1  2   3  4  5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec3f.matches(" 0  1  2,  3  4  5"), (String)"MFVec3f.matches( \" 0  1  2,  3  4  5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec3f.matches("-0 -1 -2, -3 -4 -5"), (String)"MFVec3f.matches(\"-0 -1 -2, -3 -4 -5\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec3f.matches(" 0  12E45  0"), (String)"MFVec3f.matches(\"0   12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches("+0 +12E+45 0"), (String)"MFVec3f.matches(\"+0 +12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches("-0 -12E-45 0"), (String)"MFVec3f.matches(\"-0 -12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches(""), (String)"MFVec3f.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFVec3f.matches(","), (String)"MFVec3f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFVec3f.matches(" 0.0  1.0 2.0"), (String)"MFVec3f.matches(\" 0.0  1.0 2.0\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec3f.matches("-1.0 -3.0 2.0"), (String)"MFVec3f.matches(\"-1.0 -3.0 2.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec3f.matches("0 1 2"), (String)"MFVec3f.matches(\"0 1 2\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec3f.matches("0.0 1.0 2.0"), (String)"MFVec3f.matches(\"0.0 1.0 2.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec3f.matches(" 0.0  12.3E45  0"), (String)"MFVec3f.matches(\" 0.0  12.3E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches("+0.0 +12.3E+45 0"), (String)"MFVec3f.matches(\"+0.0 +12.3E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches("-0.0 -12.3E-45 0"), (String)"MFVec3f.matches(\"-0.0 -12.3E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches(".6 -.6 0 .6e7 -.6e-7 0"), (String)"MFVec3f.matches(\".6 -.6 0 .6e7 -.6e-7 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec3f.matches("0 0 0, 1 1 1, "), (String)"MFVec3f.matches(\"0 0 0, 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec3f.matches("true false"), (String)"MFVec3f.matches(\"true false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec3f.matches("blah"), (String)"MFVec3f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec3f.matches("NaN NaN"), (String)"MFVec3f.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFColor single-field 3-tuple single-precision floating-point array")
    void SFColorTests() {
        System.out.println("SFColorTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFColor.DEFAULT_VALUE, new SFColor().setValueByString("0 0 0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFColor testSFColor = new SFColor();
        Assertions.assertTrue((boolean)testSFColor.matches(), (String)"testSFColor.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFColor.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFColor.matches("0 0 0"), (String)"SFColor.matches(SFColor.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFColor.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFColor.REGEX does not contain anchor characters ^ or $");
        testSFColor.setValue(0.0f, 0.0f, 0.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFColor.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFColor.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFColor.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFColor.matches("1 0 0"), (String)"SFColor.matches( \"1 0 0\")   tests correct string value");
        Assertions.assertTrue((boolean)SFColor.matches("0.2 0.3 0.4"), (String)"SFColor.matches( \"0.2 0.3 0.4\")   tests correct string value");
        Assertions.assertTrue((boolean)SFColor.matches("0 0 0"), (String)"SFColor.matches(\"-0 0 0\")  tests correct string value");
        Assertions.assertTrue((boolean)SFColor.matches("1 1 1"), (String)"SFColor.matches(\"1 1 1\")  tests correct string value");
        Assertions.assertTrue((boolean)SFColor.matches(" 0  0.12E45  0"), (String)"SFColor.matches(\" 0  0.12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColor.matches("+0 +0.12E+45 0"), (String)"SFColor.matches(\"+0 +0.12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColor.matches(" 0  0.12E-45 0"), (String)"SFColor.matches(\" 0  0.12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColor.matches(" 0.0  1.0 0.0 "), (String)"SFColor.matches(\" 0.0  1.0 0.0 \") tests correct string value");
        Assertions.assertFalse((boolean)SFColor.matches(""), (String)"SFColor.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFColor.matches(","), (String)"SFColor.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFColor.matches("0 1 2"), (String)"SFColor.matches(\"0 1 2\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFColor.matches("0.0 1.0 2.0"), (String)"SFColor.matches(\"0.0 1.0 2.0\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFColor.matches("-1.0 -2.0 -3.0"), (String)"SFColor.matches(\"-1.0 -2.0 -3.0\") tests incorrect string value, including external whitespace");
        Assertions.assertFalse((boolean)SFColor.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFColor.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFColor.matches("true false false"), (String)"SFColor.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFColor.matches("blah"), (String)"SFColor.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFColor.matches("NaN NaN NaN"), (String)"SFColor.matches(\"NaN\") tests Not A Number (NaN) which is not an allowed string value");
        Assertions.assertEquals((Object)SFColor.toStringHTML(0.0f, 0.5f, 1.0f), (Object)"#007fff", (String)"SFColor.toStringHTML(0.0f, 0.5f, 1.0f) tests HTML export as \"#007fff\"");
        Assertions.assertEquals((Object)SFColor.toStringCSS(0.0f, 0.5f, 1.0f), (Object)"color:(0,127,255)", (String)"SFColor.toStringCSS (0.0f, 0.5f, 1.0f) tests CSS export as \"color:(0,127,255)\"");
    }

    @Test
    @DisplayName(value="Test MFColor multi-field 3-tuple single-precision floating-point array")
    void MFColorTests() {
        System.out.println("MFColorTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFColor.DEFAULT_VALUE, new MFColor().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFColor testMFColor = new MFColor();
        Assertions.assertTrue((boolean)testMFColor.matches(), (String)"testMFColor.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.8f, 0.8f, 0.8f};
        float[] doubleValueArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        float[] tripleValueArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFColor.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFColor.matches(""), (String)"MFColor.matches(MFColor.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFColor.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFColor.REGEX does not contain anchor characters ^ or $");
        testMFColor.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFColor.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColor.matches(), (String)"testMFColor.matches() tests emptyArray initialization correctly matches regex");
        testMFColor.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFColor.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColor.matches(), (String)"testMFColor.matches() tests singleValueArray correctly matches regex");
        testMFColor.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFColor.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColor.matches(), (String)"testMFColor.matches() tests doubleValueArray correctly matches regex");
        testMFColor.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFColor.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColor.matches(), (String)"testMFColor.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFColor.matches(" 0  1  .2  .3  .4 .5"), (String)"MFColor.matches( \" 0  1  .2  .3  .4 .5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFColor.matches(" 0  1  .2, .3  .4 .5"), (String)"MFColor.matches( \" 0  1  .2, .3  .4 .5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFColor.matches(" 0  0.12E45  0"), (String)"MFColor.matches(\"0   0.12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColor.matches("+0 +0.12E+45 0"), (String)"MFColor.matches(\"+0 +0.12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColor.matches(" 0  0.12E-45 0"), (String)"MFColor.matches(\" 0  0.12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColor.matches(""), (String)"MFColor.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFColor.matches(","), (String)"MFColor.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFColor.matches(" 0.0  1.0 2.0"), (String)"MFColor.matches(\" 0.0  1.0 2.0\") tests incorrect string value");
        Assertions.assertFalse((boolean)MFColor.matches("-1.0 -3.0 2.0"), (String)"MFColor.matches(\"-1.0 -3.0 2.0\") tests incorrect string value, including external whitespace");
        Assertions.assertFalse((boolean)MFColor.matches("0 1 2"), (String)"MFColor.matches(\"0 1 2\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFColor.matches(".6 -.6 0 .6e7 -.6e-7 0"), (String)"MFColor.matches(\".6 -.6 0 .6e7 -.6e-7 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFColor.matches("0 0 0, 1 1 1, "), (String)"MFColor.matches(\"0 0 0, 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFColor.matches("true false false"), (String)"MFColor.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFColor.matches("blah"), (String)"MFColor.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFColor.matches("NaN NaN NaN NaN NaN NaN"), (String)"MFColor.matches(\"NaN NaN NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFColorRGBA single-field 4-tuple single-precision floating-point array")
    void SFColorRGBATests() {
        System.out.println("SFColorRGBATests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFColorRGBA.DEFAULT_VALUE, new SFColorRGBA().setValueByString("0 0 0 0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFColorRGBA testSFColorRGBA = new SFColorRGBA();
        Assertions.assertTrue((boolean)testSFColorRGBA.matches(), (String)"testSFColorRGBA.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFColorRGBA.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("0 0 0 0"), (String)"SFColorRGBA.matches(SFColorRGBA.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFColorRGBA.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFColorRGBA.REGEX does not contain anchor characters ^ or $");
        testSFColorRGBA.setValue(0.0f, 0.0f, 0.0f, 0.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFColorRGBA.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFColorRGBA.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFColorRGBA.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("1 0 0 0.5"), (String)"SFColorRGBA.matches( \"1 0 0 0.5\")   tests correct string value");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("0.2 0.3 0.4 0.5"), (String)"SFColorRGBA.matches( \"0.2 0.3 0.4 0.5\")   tests correct string value");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("0 0 0 0.5"), (String)"SFColorRGBA.matches(\"-0 0 0\")  tests correct string value");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("1 1 1 0.5"), (String)"SFColorRGBA.matches(\"1 1 1\")  tests correct string value");
        Assertions.assertTrue((boolean)SFColorRGBA.matches(" 0  0.12E45  0 0.5e0"), (String)"SFColorRGBA.matches(\" 0  0.12E45  0 0.5e0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColorRGBA.matches("+0 +0.12E+45 0 0.5e0"), (String)"SFColorRGBA.matches(\"+0 +0.12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColorRGBA.matches(" 0  0.12E-45 0 0.5e0"), (String)"SFColorRGBA.matches(\" 0  0.12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFColorRGBA.matches(" 0.0  1.0 0.0 0.5"), (String)"SFColorRGBA.matches(\" 0.0  1.0 0.0 0.5\") tests correct string value");
        Assertions.assertTrue((boolean)SFColorRGBA.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFColorRGBA.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFColorRGBA.matches(""), (String)"SFColorRGBA.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFColorRGBA.matches(","), (String)"SFColorRGBA.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("0 1 2"), (String)"SFColorRGBA.matches(\"0 1 2\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("0.0 1.0 2.0 0.5"), (String)"SFColorRGBA.matches(\"0.0 1.0 2.0 0.5\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("-1.0 -2.0 -3.0 0.5"), (String)"SFColorRGBA.matches(\"-1.0 -2.0 -3.0 0.5\") tests incorrect string value, including external whitespace");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("true false false false"), (String)"SFColorRGBA.matches(\"true false false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("blah"), (String)"SFColorRGBA.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFColorRGBA.matches("NaN NaN NaN NaN"), (String)"SFColorRGBA.matches(\"NaN NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFColorRGBA multi-field 4-tuple single-precision floating-point array")
    void MFColorRGBATests() {
        System.out.println("MFColorRGBATests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFColorRGBA.DEFAULT_VALUE, new MFColorRGBA().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFColorRGBA testMFColorRGBA = new MFColorRGBA();
        Assertions.assertTrue((boolean)testMFColorRGBA.matches(), (String)"testMFColorRGBA.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] doubleValueArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        float[] tripleValueArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.6f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFColorRGBA.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(""), (String)"MFColorRGBA.matches(MFColorRGBA.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFColorRGBA.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFColorRGBA.REGEX does not contain anchor characters ^ or $");
        testMFColorRGBA.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFColorRGBA.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColorRGBA.matches(), (String)"testMFColorRGBA.matches() tests emptyArray initialization correctly matches regex");
        testMFColorRGBA.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFColorRGBA.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColorRGBA.matches(), (String)"testMFColorRGBA.matches() tests singleValueArray correctly matches regex");
        testMFColorRGBA.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFColorRGBA.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColorRGBA.matches(), (String)"testMFColorRGBA.matches() tests doubleValueArray correctly matches regex");
        testMFColorRGBA.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFColorRGBA.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFColorRGBA.matches(), (String)"testMFColorRGBA.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(" 0  1  .2 0.5  .3  .4 .5 0.5"), (String)"MFColorRGBA.matches( \" 0  1  .2 0.5  .3  .4 .5 0.5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(" 0  1  .2 0.5, .3  .4 .5 0.5"), (String)"MFColorRGBA.matches( \" 0  1  .2 0.5, .3  .4 .5 0.5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(" 0  0.12E45  0 0.5"), (String)"MFColorRGBA.matches(\"0   0.12E45  0 0.5\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColorRGBA.matches("+0 +0.12E+45 0 0.5"), (String)"MFColorRGBA.matches(\"+0 +0.12E+45 0 0.5\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(" 0  0.12E-45 0 0.5"), (String)"MFColorRGBA.matches(\" 0  0.12E-45 0 0.5\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFColorRGBA.matches(""), (String)"MFColorRGBA.matches(\"\") tests correct empty string value");
        Assertions.assertTrue((boolean)MFColorRGBA.matches("0 0 0 0, 1 1 1 1, "), (String)"MFColorRGBA.matches(\"0 0 0 0, 1 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFColorRGBA.matches(","), (String)"MFColorRGBA.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFColorRGBA.matches(" 0.0  1.0 2.0 0.5"), (String)"MFColorRGBA.matches(\" 0.0  1.0 2.0 0.5\") tests incorrect string value");
        Assertions.assertFalse((boolean)MFColorRGBA.matches("-1.0 -3.0 2.0 0.5"), (String)"MFColorRGBA.matches(\"-1.0 -3.0 2.0 0.5\") tests incorrect string value, including external whitespace");
        Assertions.assertFalse((boolean)MFColorRGBA.matches("0 1 2 0.5"), (String)"MFColorRGBA.matches(\"0 1 2 0.5\")  tests incorrect array as string value");
        Assertions.assertFalse((boolean)MFColorRGBA.matches(".6 -.6 0 .6e7 -.6e-7 0"), (String)"MFColorRGBA.matches(\".6 -.6 0 .6e7 -.6e-7 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)MFColorRGBA.matches("true false false false"), (String)"MFColorRGBA.matches(\"true false false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFColorRGBA.matches("blah"), (String)"MFColorRGBA.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFColorRGBA.matches("NaN NaN NaN NaN NaN NaN NaN NaN"), (String)"MFColorRGBA.matches(\"NaN NaN NaN NaN NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec3d single-field 3-tuple double-precision floating-point array")
    void SFVec3dTests() {
        System.out.println("SFVec3dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec3d.DEFAULT_VALUE, new SFVec3d().setValueByString("0.0 0.0 0.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec3d testSFVec3d = new SFVec3d();
        Assertions.assertTrue((boolean)testSFVec3d.matches(), (String)"testSFVec3d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec3d.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec3d.matches("0.0 0.0 0.0"), (String)"SFVec3d.matches(SFVec3d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec3d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec3d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec3f.REGEX.equals(SFVec3d.REGEX) returns true");
        testSFVec3d.setValue(0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec3d.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec3d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec3d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec3d.matches("0 1 2"), (String)"SFVec3d.matches( \"0 1 2\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec3d.matches("2 3 4"), (String)"SFVec3d.matches( \"2 3 4\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec3d.matches("-1 -2 -3"), (String)"SFVec3d.matches(\"-1 -2 -3\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec3d.matches(" 0  12E45  0"), (String)"SFVec3d.matches(\" 0  12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3d.matches("+0 +12E+45 0"), (String)"SFVec3d.matches(\"+0 +12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3d.matches("-0 -12E-45 0"), (String)"SFVec3d.matches(\"-0 -12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3d.matches(" 0.0  1.0 0"), (String)"SFVec3d.matches(\" 0.0  1.0 0\") tests correct string value");
        Assertions.assertTrue((boolean)SFVec3d.matches("-1.0 -3.0 0"), (String)"SFVec3d.matches(\"-1.0 -3.0 0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec3d.matches("0 1 2"), (String)"SFVec3d.matches(\"0 1 2\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec3d.matches("0.0 1.0 0"), (String)"SFVec3d.matches(\"0.0 1.0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec3d.matches(" 0.0  12.3E45  0"), (String)"SFVec3d.matches(\" 0.0  12.3E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3d.matches("+0.0 +12.3E+45 0"), (String)"SFVec3d.matches(\"+0.0 +12.3E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec3d.matches("-0.0 -12.3E-45 0"), (String)"SFVec3d.matches(\"-0.0 -12.3E-45 0\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec3d.matches(""), (String)"SFVec3d.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec3d.matches(","), (String)"SFVec3d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec3d.matches(".6 -.6 .6e7 -.6e-7"), (String)"SFVec3d.matches(\".6 -.6 .6e7 -.6e-7\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec3d.matches("true false false"), (String)"SFVec3d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec3d.matches("blah"), (String)"SFVec3d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec3d.matches("NaN NaN NaN"), (String)"SFVec3d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFVec3d multi-field 3-tuple double-precision floating-point array")
    void MFVec3dTests() {
        System.out.println("MFVec3dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec3d.DEFAULT_VALUE, new MFVec3d().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec3d testMFVec3d = new MFVec3d();
        Assertions.assertTrue((boolean)testMFVec3d.matches(), (String)"testMFVec3d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0};
        double[] doubleValueArray = new double[]{0.0, 1.0, -2.0, -3.0, -4.0, 5.0};
        double[] tripleValueArray = new double[]{0.0, 1.0, -2.0, -3.0, 4.0, 5.0, -6.0, 7.0, 8.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec3d.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec3d.matches(""), (String)"MFVec3d.matches(MFVec3d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec3d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec3d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec3f.REGEX.equals(MFVec3d.REGEX) returns true");
        testMFVec3d.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec3d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3d.matches(), (String)"testMFVec3d.matches() tests emptyArray initialization correctly matches regex");
        testMFVec3d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec3d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3d.matches(), (String)"testMFVec3d.matches() tests singleValueArray correctly matches regex");
        testMFVec3d.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec3d.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3d.matches(), (String)"testMFVec3d.matches() tests doubleValueArray correctly matches regex");
        testMFVec3d.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec3d.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec3d.matches(), (String)"testMFVec3d.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec3d.matches(" 0  1  2   3  4  5"), (String)"MFVec3d.matches( \" 0  1  2   3  4  5\")    tests correct string value");
        Assertions.assertTrue((boolean)MFVec3d.matches(" 0  1  2,  3  4  5"), (String)"MFVec3d.matches( \" 0  1  2,  3  4  5\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec3d.matches("-1 -2 -3, -4 -5 -6"), (String)"MFVec3d.matches(\"-1 -2, -3 -4\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec3d.matches(" 0  12E45  0"), (String)"MFVec3d.matches(\" 0  12E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches("+0 +12E+45 0"), (String)"MFVec3d.matches(\"+0,+12E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches("-0 -12E-45 0"), (String)"MFVec3d.matches(\"-0,-12E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches(""), (String)"MFVec3d.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFVec3d.matches(","), (String)"MFVec3d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFVec3d.matches(" 0.0  1.0 2.0"), (String)"MFVec3d.matches(\" 0.0  1.0 2.0\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec3d.matches("-1.0 -3.0 -0"), (String)"MFVec3d.matches(\"-1.0 -3.0 -0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec3d.matches("0 1 0"), (String)"MFVec3d.matches(\"0 1 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec3d.matches("0.0 1.0 0"), (String)"MFVec3d.matches(\"0.0 1.0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec3d.matches(" 0.0  12.3E45  0 "), (String)"MFVec3d.matches(\" 0.0  12.3E45  0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches("+0.0 +12.3E+45 0 "), (String)"MFVec3d.matches(\"+0.0 +12.3E+45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches("-0.0 -12.3E-45 0 "), (String)"MFVec3d.matches(\"-0.0 -12.3E-45 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches(".6 -.6 0 .6e7 -.6e-7 0"), (String)"MFVec3d.matches(\".6 -.6 0 .6e7 -.6e-7 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec3d.matches("0 0 0, 1 1 1, "), (String)"MFVec3d.matches(\"0 0 0, 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec3d.matches("true false false"), (String)"MFVec3d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec3d.matches("blah"), (String)"MFVec3d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec3d.matches("NaN NaN NaN"), (String)"MFVec3d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec4f single-field 4-tuple single-precision floating-point array")
    void SFVec4fTests() {
        System.out.println("SFVec4fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec4f.DEFAULT_VALUE, new SFVec4f().setValueByString("0.0 0.0 0.0 1.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec4f testSFVec4f = new SFVec4f();
        Assertions.assertTrue((boolean)testSFVec4f.matches(), (String)"testSFVec4f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec4f.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec4f.matches("0.0 0.0 0.0 1.0"), (String)"SFVec4f.matches(SFVec4f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec4f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec4f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec4f.REGEX.equals(SFVec4d.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec4f.REGEX.equals(SFRotation.REGEX) returns true");
        testSFVec4f.setValue(0.0f, 0.0f, 0.0f, 1.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec4f.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec4f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec4f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec4f.matches("0 1 2 3"), (String)"SFVec4f.matches( \"0 1 2 3\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec4f.matches("2 3 4 5"), (String)"SFVec4f.matches( \"2 3 4 5\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec4f.matches("-1 -2 -3 -4"), (String)"SFVec4f.matches(\"-1 -2 -3 -4\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec4f.matches(" 0  12E45  0 0"), (String)"SFVec4f.matches(\" 0  12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4f.matches("+0 +12E+45 0 0"), (String)"SFVec4f.matches(\"+0 +12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4f.matches("-0 -12E-45 0 0"), (String)"SFVec4f.matches(\"-0 -12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4f.matches(" 0.0  1.0 2.0 3.0"), (String)"SFVec4f.matches(\" 0.0  1.0 2.0 3.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFVec4f.matches("-1.0 -2.0 -3.0 -4.0"), (String)"SFVec4f.matches(\"-1.0 -2.0 -3.0 -4.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec4f.matches("0 1 2 3"), (String)"SFVec4f.matches(\"0 1 2 3\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec4f.matches("0.0 1.0 2.0 3.0"), (String)"SFVec4f.matches(\"0.0 1.0 2.0 3.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec4f.matches(" 0.0  12.3E45  0 0"), (String)"SFVec4f.matches(\" 0.0  12.3E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4f.matches("+0.0 +12.3E+45 0 0"), (String)"SFVec4f.matches(\"+0.0 +12.3E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4f.matches("-0.0 -12.3E-45 0 0"), (String)"SFVec4f.matches(\"-0.0 -12.3E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec4f.matches(""), (String)"SFVec4f.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec4f.matches(","), (String)"SFVec4f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec4f.matches(".6 -.6 .6e7 -.6e-7 0"), (String)"SFVec4f.matches(\".6 -.6 .6e7 -.6e-7 0\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec4f.matches("true false false true"), (String)"SFVec4f.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec4f.matches("blah"), (String)"SFVec4f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec4f.matches("NaN NaN NaN NaN"), (String)"SFVec4f.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFVec4f multi-field 4-tuple single-precision floating-point array")
    void MFVec4fTests() {
        System.out.println("MFVec4fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec4f.DEFAULT_VALUE, new MFVec4f().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec4f testMFVec4f = new MFVec4f();
        Assertions.assertTrue((boolean)testMFVec4f.matches(), (String)"testMFVec4f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] doubleValueArray = new float[]{0.0f, 1.0f, -2.0f, 3.0f, -4.0f, -5.0f, -6.0f, -7.0f};
        float[] tripleValueArray = new float[]{0.0f, 1.0f, -2.0f, 3.0f, -4.0f, -5.0f, -6.0f, -7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec4f.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec4f.matches(""), (String)"MFVec4f.matches(MFVec4f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec4f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec4f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec4f.REGEX.equals(MFVec4d.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec4f.REGEX.equals(MFRotation.REGEX) returns true");
        testMFVec4f.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec4f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4f.matches(), (String)"testMFVec4f.matches() tests emptyArray initialization correctly matches regex");
        testMFVec4f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec4f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4f.matches(), (String)"testMFVec4f.matches() tests singleValueArray correctly matches regex");
        testMFVec4f.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec4f.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4f.matches(), (String)"testMFVec4f.matches() tests doubleValueArray correctly matches regex");
        testMFVec4f.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec4f.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4f.matches(), (String)"testMFVec4f.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec4f.matches(" 0  1  2  3   4  5  6  7"), (String)"MFVec4f.matches(\" 0  1  2  3   4  5  6  7\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec4f.matches(" 0  1  2  3,  4  5  6  7"), (String)"MFVec4f.matches(\" 0  1  2  3,  4  5  6  7\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec4f.matches("-0 -1 -2 -3, -4 -5 -6 -7"), (String)"MFVec4f.matches(\"-0 -1 -2 -3, -4 -5 -6 -7\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec4f.matches(" 0  12E45  0 0"), (String)"MFVec4f.matches(\"0   12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches("+0 +12E+45 0 0"), (String)"MFVec4f.matches(\"+0 +12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches("-0 -12E-45 0 0"), (String)"MFVec4f.matches(\"-0 -12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches(""), (String)"MFVec4f.matches(\"\") tests correct empty string value");
        Assertions.assertTrue((boolean)MFVec4f.matches(" 0.0  1.0 2.0 0"), (String)"MFVec4f.matches(\" 0.0  1.0 2.0 0\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec4f.matches("-1.0 -3.0 2.0 0"), (String)"MFVec4f.matches(\"-1.0 -3.0 2.0 0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec4f.matches("0 1 2 3"), (String)"MFVec4f.matches(\"0 1 2 3\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec4f.matches("0.0 1.0 2.0 0"), (String)"MFVec4f.matches(\"0.0 1.0 2.0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec4f.matches(" 0.0  12.3E45  0 0"), (String)"MFVec4f.matches(\" 0.0  12.3E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches("+0.0 +12.3E+45 0 0"), (String)"MFVec4f.matches(\"+0.0 +12.3E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches("-0.0 -12.3E-45 0 0"), (String)"MFVec4f.matches(\"-0.0 -12.3E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches(".6 -.6 0 .6e7 -.6e-7 0 0 0"), (String)"MFVec4f.matches(\".6 -.6 0 .6e7 -.6e-7 0 0 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec4f.matches("0 0 0 0, 1 1 1 1, "), (String)"MFVec4f.matches(\"0 0 0 0, 1 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec4f.matches(","), (String)"MFVec4f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFVec4f.matches("true false false true"), (String)"MFVec4f.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec4f.matches("blah"), (String)"MFVec4f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec4f.matches("NaN NaN NaN NaN"), (String)"MFVec4f.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFRotation single-field 4-tuple single-precision floating-point array")
    void SFRotationTests() {
        System.out.println("SFRotationTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFRotation.DEFAULT_VALUE, new SFRotation().setValueByString("0 0 1 0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFRotation testSFRotation = new SFRotation();
        Assertions.assertTrue((boolean)testSFRotation.matches(), (String)"testSFRotation.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFRotation.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFRotation.matches("0 0 1 0"), (String)"SFRotation.matches(SFRotation.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFRotation.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFRotation.REGEX does not contain anchor characters ^ or $");
        testSFRotation.setValue(0.0f, 0.0f, 1.0f, 0.0f);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFRotation.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec4f.REGEX.equals(SFVec4d.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec4f.REGEX.equals(SFRotation.REGEX) returns true");
        testSFRotation.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFRotation.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFRotation.matches("0 1 2 3"), (String)"SFRotation.matches( \"0 1 2 3\")   tests correct string value");
        Assertions.assertTrue((boolean)SFRotation.matches("2 3 4 5"), (String)"SFRotation.matches( \"2 3 4 5\")   tests correct string value");
        Assertions.assertTrue((boolean)SFRotation.matches("-1 -2 -3 -4"), (String)"SFRotation.matches(\"-1 -2 -3 -4\")  tests correct string value");
        Assertions.assertTrue((boolean)SFRotation.matches(" 0  12E45  0 0"), (String)"SFRotation.matches(\" 0  12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFRotation.matches("+0 +12E+45 0 0"), (String)"SFRotation.matches(\"+0 +12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFRotation.matches("-0 -12E-45 0 0"), (String)"SFRotation.matches(\"-0 -12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFRotation.matches(" 0.0  1.0 2.0 3.0"), (String)"SFRotation.matches(\" 0.0  1.0 2.0 3.0\") tests correct string value");
        Assertions.assertTrue((boolean)SFRotation.matches("-1.0 -2.0 -3.0 -4.0"), (String)"SFRotation.matches(\"-1.0 -2.0 -3.0 -4.0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFRotation.matches("0 1 2 3"), (String)"SFRotation.matches(\"0 1 2 3\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFRotation.matches("0.0 1.0 2.0 3.0"), (String)"SFRotation.matches(\"0.0 1.0 2.0 3.0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFRotation.matches(" 0.0  12.3E45  0 0"), (String)"SFRotation.matches(\" 0.0  12.3E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFRotation.matches("+0.0 +12.3E+45 0 0"), (String)"SFRotation.matches(\"+0.0 +12.3E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFRotation.matches("-0.0 -12.3E-45 0 0"), (String)"SFRotation.matches(\"-0.0 -12.3E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFRotation.matches(""), (String)"SFRotation.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFRotation.matches(","), (String)"SFRotation.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFRotation.matches(".6 -.6 .6e7 -.6e-7 0"), (String)"SFRotation.matches(\".6 -.6 .6e7 -.6e-7 0\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFRotation.matches("true false false true"), (String)"SFRotation.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFRotation.matches("blah"), (String)"SFRotation.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFRotation.matches("NaN NaN NaN NaN"), (String)"SFRotation.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFRotation multi-field 4-tuple single-precision floating-point array")
    void MFRotationTests() {
        System.out.println("MFRotationTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFRotation.DEFAULT_VALUE, new MFRotation().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFRotation testMFRotation = new MFRotation();
        Assertions.assertTrue((boolean)testMFRotation.matches(), (String)"testMFRotation.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        float[] doubleValueArray = new float[]{0.0f, 1.0f, -2.0f, 3.0f, -4.0f, -5.0f, -6.0f, -7.0f};
        float[] tripleValueArray = new float[]{0.0f, 1.0f, -2.0f, 3.0f, -4.0f, -5.0f, -6.0f, -7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFRotation.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFRotation.matches(""), (String)"MFRotation.matches(MFRotation.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFRotation.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFRotation.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec4f.REGEX.equals(MFVec4d.REGEX) returns true");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec4f.REGEX.equals(MFRotation.REGEX) returns true");
        testMFRotation.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFRotation.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFRotation.matches(), (String)"testMFRotation.matches() tests emptyArray initialization correctly matches regex");
        testMFRotation.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFRotation.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFRotation.matches(), (String)"testMFRotation.matches() tests singleValueArray correctly matches regex");
        testMFRotation.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFRotation.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFRotation.matches(), (String)"testMFRotation.matches() tests doubleValueArray correctly matches regex");
        testMFRotation.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFRotation.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFRotation.matches(), (String)"testMFRotation.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFRotation.matches(" 0  1  2  3   4  5  6  7"), (String)"MFRotation.matches(\" 0  1  2  3   4  5  6  7\")   tests correct string value");
        Assertions.assertTrue((boolean)MFRotation.matches(" 0  1  2  3,  4  5  6  7"), (String)"MFRotation.matches(\" 0  1  2  3,  4  5  6  7\")   tests correct string value");
        Assertions.assertTrue((boolean)MFRotation.matches("-0 -1 -2 -3, -4 -5 -6 -7"), (String)"MFRotation.matches(\"-0 -1 -2 -3, -4 -5 -6 -7\") tests correct string value");
        Assertions.assertTrue((boolean)MFRotation.matches(" 0  12E45  0 0"), (String)"MFRotation.matches(\"0   12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches("+0 +12E+45 0 0"), (String)"MFRotation.matches(\"+0 +12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches("-0 -12E-45 0 0"), (String)"MFRotation.matches(\"-0 -12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches(""), (String)"MFRotation.matches(\"\") tests correct empty string value");
        Assertions.assertTrue((boolean)MFRotation.matches(" 0.0  1.0 2.0 0"), (String)"MFRotation.matches(\" 0.0  1.0 2.0 0\") tests correct string value");
        Assertions.assertTrue((boolean)MFRotation.matches("-1.0 -3.0 2.0 0"), (String)"MFRotation.matches(\"-1.0 -3.0 2.0 0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFRotation.matches("0 1 2 3"), (String)"MFRotation.matches(\"0 1 2 3\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFRotation.matches("0.0 1.0 2.0 0"), (String)"MFRotation.matches(\"0.0 1.0 2.0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFRotation.matches(" 0.0  12.3E45  0 0"), (String)"MFRotation.matches(\" 0.0  12.3E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches("+0.0 +12.3E+45 0 0"), (String)"MFRotation.matches(\"+0.0 +12.3E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches("-0.0 -12.3E-45 0 0"), (String)"MFRotation.matches(\"-0.0 -12.3E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches(".6 -.6 0 .6e7 -.6e-7 0 0 0"), (String)"MFRotation.matches(\".6 -.6 0 .6e7 -.6e-7 0 0 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFRotation.matches("0 0 0 0, 1 1 1 1, "), (String)"MFRotation.matches(\"0 0 0 0, 1 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFRotation.matches(","), (String)"MFRotation.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)MFRotation.matches("true false false true"), (String)"MFRotation.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFRotation.matches("blah"), (String)"MFRotation.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFRotation.matches("NaN NaN NaN NaN"), (String)"MFRotation.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFVec4d single-field 4-tuple double-precision floating-point array")
    void SFVec4dTests() {
        System.out.println("SFVec4dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFVec4d.DEFAULT_VALUE, new SFVec4d().setValueByString("0.0 0.0 0.0 1.0").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFVec4d testSFVec4d = new SFVec4d();
        Assertions.assertTrue((boolean)testSFVec4d.matches(), (String)"testSFVec4d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 1.0};
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, SFVec4d.DEFAULT_VALUE), (String)"test correct default value for this field object");
        Assertions.assertTrue((boolean)SFVec4d.matches("0.0 0.0 0.0 1.0"), (String)"SFVec4d.matches(SFVec4d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFVec4d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFVec4d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFVec4f.REGEX.equals(SFVec4d.REGEX) returns true");
        testSFVec4d.setValue(0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)Arrays.equals(singleValueArray, testSFVec4d.getPrimitiveValue()), (String)"tests setting object value to 0.0f 0.0f results in singleton array with same value");
        testSFVec4d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFVec4d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)SFVec4d.matches("0 1 2 3"), (String)"SFVec4d.matches( \"0 1 2 3\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec4d.matches("2 3 4 5"), (String)"SFVec4d.matches( \"2 3 4 5\")   tests correct string value");
        Assertions.assertTrue((boolean)SFVec4d.matches("-1 -2 -3 -4"), (String)"SFVec4d.matches(\"-1 -2 -3 -4\")  tests correct string value");
        Assertions.assertTrue((boolean)SFVec4d.matches(" 0  12E45  0 0"), (String)"SFVec4d.matches(\" 0  12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4d.matches("+0 +12E+45 0 0"), (String)"SFVec4d.matches(\"+0 +12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4d.matches("-0 -12E-45 0 0"), (String)"SFVec4d.matches(\"-0 -12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4d.matches(" 0.0  1.0 0 0"), (String)"SFVec4d.matches(\" 0.0  1.0 0 0\") tests correct string value");
        Assertions.assertTrue((boolean)SFVec4d.matches("-1.0 -3.0 0 0"), (String)"SFVec4d.matches(\"-1.0 -3.0 0 0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFVec4d.matches("0 1 2 3"), (String)"SFVec4d.matches(\"0 1 2 3\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec4d.matches("0.0 1.0 0 0"), (String)"SFVec4d.matches(\"0.0 1.0 0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFVec4d.matches(" 0.0  12.3E45  0 0"), (String)"SFVec4d.matches(\" 0.0  12.3E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4d.matches("+0.0 +12.3E+45 0 0"), (String)"SFVec4d.matches(\"+0.0 +12.3E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFVec4d.matches("-0.0 -12.3E-45 0 0"), (String)"SFVec4d.matches(\"-0.0 -12.3E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFVec4d.matches(""), (String)"SFVec4d.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFVec4d.matches(","), (String)"SFVec4d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertFalse((boolean)SFVec4d.matches(".6 -.6 .6e7 -.6e-7 0"), (String)"SFVec4d.matches(\".6 -.6 .6e7 -.6e-7 0\") tests incorrect string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFVec4d.matches("true false false true"), (String)"SFVec4d.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFVec4d.matches("blah"), (String)"SFVec4d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFVec4d.matches("NaN NaN NaN NaN"), (String)"SFVec4d.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFVec4d multi-field 4-tuple double-precision floating-point array")
    void MFVec4dTests() {
        System.out.println("MFVec4dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFVec4d.DEFAULT_VALUE, new MFVec4d().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFVec4d testMFVec4d = new MFVec4d();
        Assertions.assertTrue((boolean)testMFVec4d.matches(), (String)"testMFVec4d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] doubleValueArray = new double[]{0.0, 1.0, -2.0, 3.0, -4.0, -5.0, -6.0, -7.0};
        double[] tripleValueArray = new double[]{0.0, 1.0, -2.0, 3.0, -4.0, -5.0, -6.0, -7.0, 8.0, 9.0, 10.0, 11.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFVec4d.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFVec4d.matches(""), (String)"MFVec4d.matches(MFVec4d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFVec4d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFVec4d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFVec4f.REGEX.equals(MFVec4d.REGEX) returns true");
        testMFVec4d.setValue(emptyArray);
        Assertions.assertEquals((Object)emptyArray, (Object)testMFVec4d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4d.matches(), (String)"testMFVec4d.matches() tests emptyArray initialization correctly matches regex");
        testMFVec4d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFVec4d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4d.matches(), (String)"testMFVec4d.matches() tests singleValueArray correctly matches regex");
        testMFVec4d.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFVec4d.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4d.matches(), (String)"testMFVec4d.matches() tests doubleValueArray correctly matches regex");
        testMFVec4d.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFVec4d.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFVec4d.matches(), (String)"testMFVec4d.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFVec4d.matches(" 0  1  2  3   4  5  7  8"), (String)"MFVec4d.matches( \" 0  1  2  3   4  5  7  8\")    tests correct string value");
        Assertions.assertTrue((boolean)MFVec4d.matches(" 0  1  2  3,  4  5  7  8"), (String)"MFVec4d.matches( \" 0  1  2  3,  4  5  7  8\")   tests correct string value");
        Assertions.assertTrue((boolean)MFVec4d.matches("-1 -2 -3 -4, -5 -6 -7 -8"), (String)"MFVec4d.matches(\"-1 -2 -3 -4, -5 -6 -7 -8\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec4d.matches(" 0  12E45  0 0"), (String)"MFVec4d.matches(\" 0  12E45  0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches("+0 +12E+45 0 0"), (String)"MFVec4d.matches(\"+0,+12E+45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches("-0 -12E-45 0 0"), (String)"MFVec4d.matches(\"-0,-12E-45 0 0\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches(""), (String)"MFVec4d.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFVec4d.matches(","), (String)"MFVec4d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFVec4d.matches(" 0.0  1.0 2.0 0"), (String)"MFVec4d.matches(\" 0.0  1.0 2.0 0\") tests correct string value");
        Assertions.assertTrue((boolean)MFVec4d.matches("-1.0 -3.0 -0  0"), (String)"MFVec4d.matches(\"-1.0 -3.0 -0  0\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFVec4d.matches("0 1 0 0"), (String)"MFVec4d.matches(\"0 1 0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec4d.matches("0.0 1.0 0 0"), (String)"MFVec4d.matches(\"0.0 1.0 0 0\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFVec4d.matches(" 0.0  12.3E45  0 0 "), (String)"MFVec4d.matches(\" 0.0  12.3E45  0 0 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches("+0.0 +12.3E+45 0 0 "), (String)"MFVec4d.matches(\"+0.0 +12.3E+45 0 0 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches("-0.0 -12.3E-45 0 0 "), (String)"MFVec4d.matches(\"-0.0 -12.3E-45 0 0 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches(".6 -.6 0 .6e7 -.6e-7 0 0 0"), (String)"MFVec4d.matches(\".6 -.6 0 .6e7 -.6e-7 0 0 0\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertTrue((boolean)MFVec4d.matches("0 0 0 0, 1 1 1 1, "), (String)"MFVec4d.matches(\"0 0 0 0, 1 1 1 1, \")  tests correct array as string value, including whitespace and commas, with allowed trailing comma");
        Assertions.assertFalse((boolean)MFVec4d.matches("true false false true"), (String)"MFVec4d.matches(\"true false false true\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFVec4d.matches("blah"), (String)"MFVec4d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFVec4d.matches("NaN NaN NaN"), (String)"MFVec4d.matches(\"NaN NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFMatrix3f single-field 9-tuple single-precision floating-point array")
    void SFMatrix3fTests() {
        System.out.println("SFMatrix3fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFMatrix3f.DEFAULT_VALUE, new SFMatrix3f().setValueByString("1 0 0 0 1 0 0 0 1").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFMatrix3f testSFMatrix3f = new SFMatrix3f();
        Assertions.assertTrue((boolean)testSFMatrix3f.matches(), (String)"testSFMatrix3f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] identityArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, SFMatrix3f.DEFAULT_VALUE), (String)"test correct default value is identity array for this MF field object");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("1 0 0 0 1 0 0 0 1"), (String)"SFMatrix3f.matches(SFMatrix3f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFMatrix3f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFMatrix3f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFMatrix3f.REGEX.equals(SFMatrix3d.REGEX) returns true");
        testSFMatrix3f = new SFMatrix3f();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix3f.getPrimitiveValue()), (String)"tests setting object value to emptyArray results in identityArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix3f.matches(), (String)"testSFMatrix3f.matches() tests emptyArray initialization correctly matches regex");
        testSFMatrix3f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFMatrix3f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix3f.matches(), (String)"testSFMatrix3f.matches() tests singleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)SFMatrix3f.matches(" 0  1  2   3  4  5  6 7 8 "), (String)"SFMatrix3f.matches( \" 0  1  2   3  4  5  6 7 8 \") tests correct string value");
        Assertions.assertFalse((boolean)SFMatrix3f.matches(" 0  1  2,  3  4  5, 6 7 8 "), (String)"SFMatrix3f.matches( \" 0  1  2,  3  4  5, 6 7 8 \") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("-1 -2 -3  -4 -5 -6  7 8 9 "), (String)"SFMatrix3f.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 \") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix3f.matches(" 0  12E45  0 4 5 6 7 8 9 "), (String)"SFMatrix3f.matches(\" 0  12E45  0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("+0 +12E+45 0 4 5 6 7 8 9 "), (String)"SFMatrix3f.matches(\"+0,+12E+45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("-0 -12E-45 0 4 5 6 7 8 9 "), (String)"SFMatrix3f.matches(\"-0,-12E-45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix3f.matches(""), (String)"SFMatrix3f.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFMatrix3f.matches(","), (String)"SFMatrix3f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)SFMatrix3f.matches(" 0.0  1.0 2.0 3 4 5 6 7 8"), (String)"SFMatrix3f.matches(\" 0.0  1.0 2.0 3 4 5 6 7 8\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("-1.0 -3.0 -0  3 4 5 6 7 8"), (String)"SFMatrix3f.matches(\"-1.0 -3.0 -0  3 4 5 6 7 8\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("0 1 0  3 4 5 6 7 8"), (String)"SFMatrix3f.matches(\"0 1 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("0.0 1.0 0  3 4 5 6 7 8"), (String)"SFMatrix3f.matches(\"0.0 1.0 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix3f.matches(" 0.0  12.3E45  0  3 4 5 6 7 8 "), (String)"SFMatrix3f.matches(\" 0.0  12.3E45  0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("+0.0 +12.3E+45 0  3 4 5 6 7 8 "), (String)"SFMatrix3f.matches(\"+0.0 +12.3E+45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3f.matches("-0.0 -12.3E-45 0  3 4 5 6 7 8 "), (String)"SFMatrix3f.matches(\"-0.0 -12.3E-45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3f.matches(".6 -.6 0 .6e7 -.6e-7 0 6 7 8 "), (String)"SFMatrix3f.matches(\".6 -.6 0 .6e7 -.6e-7 0 6 7 8 \") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix3f.matches("0 0 0, 1 1 1, 2 2 2, "), (String)"SFMatrix3f.matches(\"0 0 0, 1 1 1, 2 2 2, \")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)SFMatrix3f.matches("true false false"), (String)"SFMatrix3f.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFMatrix3f.matches("blah"), (String)"SFMatrix3f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFMatrix3f.matches("NaN NaN NaN"), (String)"SFMatrix3f.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFMatrix3d single-field 9-tuple double-precision floating-point array")
    void SFMatrix3dTests() {
        System.out.println("SFMatrix3dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFMatrix3d.DEFAULT_VALUE, new SFMatrix3d().setValueByString("1 0 0 0 1 0 0 0 1").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFMatrix3d testSFMatrix3d = new SFMatrix3d();
        Assertions.assertTrue((boolean)testSFMatrix3d.matches(), (String)"testSFMatrix3d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] identityArray = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, SFMatrix3d.DEFAULT_VALUE), (String)"test correct default value is identity array for this MF field object");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("1 0 0 0 1 0 0 0 1"), (String)"SFMatrix3d.matches(SFMatrix3d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFMatrix3d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFMatrix3d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFMatrix3f.REGEX.equals(SFMatrix3d.REGEX) returns true");
        testSFMatrix3d = new SFMatrix3d();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix3d.getPrimitiveValue()), (String)"tests setting object value to emptyArray results in identityArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix3d.matches(), (String)"testSFMatrix3d.matches() tests emptyArray initialization correctly matches regex");
        testSFMatrix3d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFMatrix3d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix3d.matches(), (String)"testSFMatrix3d.matches() tests singleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)SFMatrix3d.matches(" 0  1  2   3  4  5  6 7 8 "), (String)"SFMatrix3d.matches( \" 0  1  2   3  4  5  6 7 8 \") tests correct string value");
        Assertions.assertFalse((boolean)SFMatrix3d.matches(" 0  1  2,  3  4  5, 6 7 8 "), (String)"SFMatrix3d.matches( \" 0  1  2,  3  4  5, 6 7 8 \") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("-1 -2 -3  -4 -5 -6  7 8 9 "), (String)"SFMatrix3d.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 \") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix3d.matches(" 0  12E45  0 4 5 6 7 8 9 "), (String)"SFMatrix3d.matches(\" 0  12E45  0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("+0 +12E+45 0 4 5 6 7 8 9 "), (String)"SFMatrix3d.matches(\"+0,+12E+45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("-0 -12E-45 0 4 5 6 7 8 9 "), (String)"SFMatrix3d.matches(\"-0,-12E-45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix3d.matches(""), (String)"SFMatrix3d.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFMatrix3d.matches(","), (String)"SFMatrix3d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)SFMatrix3d.matches(" 0.0  1.0 2.0 3 4 5 6 7 8"), (String)"SFMatrix3d.matches(\" 0.0  1.0 2.0 3 4 5 6 7 8\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("-1.0 -3.0 -0  3 4 5 6 7 8"), (String)"SFMatrix3d.matches(\"-1.0 -3.0 -0  3 4 5 6 7 8\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("0 1 0  3 4 5 6 7 8"), (String)"SFMatrix3d.matches(\"0 1 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("0.0 1.0 0  3 4 5 6 7 8"), (String)"SFMatrix3d.matches(\"0.0 1.0 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix3d.matches(" 0.0  12.3E45  0  3 4 5 6 7 8 "), (String)"SFMatrix3d.matches(\" 0.0  12.3E45  0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("+0.0 +12.3E+45 0  3 4 5 6 7 8 "), (String)"SFMatrix3d.matches(\"+0.0 +12.3E+45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3d.matches("-0.0 -12.3E-45 0  3 4 5 6 7 8 "), (String)"SFMatrix3d.matches(\"-0.0 -12.3E-45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix3d.matches(".6 -.6 0 .6e7 -.6e-7 0 6 7 8 "), (String)"SFMatrix3d.matches(\".6 -.6 0 .6e7 -.6e-7 0 6 7 8 \") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix3d.matches("0 0 0, 1 1 1, 2 2 2, "), (String)"SFMatrix3d.matches(\"0 0 0, 1 1 1, 2 2 2, \")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)SFMatrix3d.matches("true false false"), (String)"SFMatrix3d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFMatrix3d.matches("blah"), (String)"SFMatrix3d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFMatrix3d.matches("NaN NaN NaN"), (String)"SFMatrix3d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFMatrix3f multiple-field 9-tuple single-precision floating-point array")
    void MFMatrix3fTests() {
        System.out.println("MFMatrix3fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFMatrix3f.DEFAULT_VALUE, new MFMatrix3f().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFMatrix3f testMFMatrix3f = new MFMatrix3f();
        Assertions.assertTrue((boolean)testMFMatrix3f.matches(), (String)"testMFMatrix3f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] doubleValueArray = new float[]{1.0f, -2.0f, -3.0f, -4.0f, 5.0f, -6.0f, 7.0f, 8.0f, 9.0f, 11.0f, -12.0f, -13.0f, -14.0f, 15.0f, -16.0f, 17.0f, 18.0f, 19.0f};
        float[] tripleValueArray = new float[]{1.0f, -2.0f, -3.0f, 4.0f, 5.0f, -6.0f, 7.0f, 8.0f, 9.0f, 11.0f, -12.0f, -13.0f, -14.0f, 15.0f, -16.0f, 17.0f, 18.0f, 19.0f, 21.0f, -22.0f, -23.0f, -24.0f, 25.0f, -26.0f, 27.0f, 28.0f, 29.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFMatrix3f.DEFAULT_VALUE), (String)"test correct default value is emptyArray for this MF field object");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(""), (String)"MFMatrix3f.matches(MFMatrix3f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFMatrix3f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFMatrix3f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFMatrix3f.REGEX.equals(MFMatrix3d.REGEX) returns true");
        testMFMatrix3f = new MFMatrix3f();
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, testMFMatrix3f.getPrimitiveValue()), (String)"tests default object value is emptyArray and results in emptyArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3f.matches(), (String)"testMFMatrix3f.matches() tests emptyArray initialization correctly matches regex");
        testMFMatrix3f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFMatrix3f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3f.matches(), (String)"testMFMatrix3f.matches() tests singleValueArray correctly matches regex");
        testMFMatrix3f.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFMatrix3f.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3f.matches(), (String)"testMFMatrix3f.matches() tests doubleValueArray correctly matches regex");
        testMFMatrix3f.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFMatrix3f.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3f.matches(), (String)"testMFMatrix3f.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(" 0  1  2   3  4  5  6 7 8 "), (String)"MFMatrix3f.matches( \" 0  1  2   3  4  5  6 7 8 \") tests correct string value");
        Assertions.assertFalse((boolean)MFMatrix3f.matches(" 0  1  2,  3  4  5, 6 7 8 "), (String)"MFMatrix3f.matches( \" 0  1  2,  3  4  5, 6 7 8 \") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("-1 -2 -3  -4 -5 -6  7 8 9 "), (String)"MFMatrix3f.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 \") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(" 0  12E45  0 4 5 6 7 8 9 "), (String)"MFMatrix3f.matches(\" 0  12E45  0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("+0 +12E+45 0 4 5 6 7 8 9 "), (String)"MFMatrix3f.matches(\"+0,+12E+45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("-0 -12E-45 0 4 5 6 7 8 9 "), (String)" MFMatrix3f.matches(\"-0,-12E-45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(""), (String)"MFMatrix3f.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFMatrix3f.matches(","), (String)"MFMatrix3f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(" 0.0  1.0 2.0 3 4 5 6 7 8"), (String)"MFMatrix3f.matches(\" 0.0  1.0 2.0 3 4 5 6 7 8\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("-1.0 -3.0 -0  3 4 5 6 7 8"), (String)"MFMatrix3f.matches(\"-1.0 -3.0 -0  3 4 5 6 7 8\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("0 1 0  3 4 5 6 7 8"), (String)"MFMatrix3f.matches(\"0 1 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("0.0 1.0 0  3 4 5 6 7 8"), (String)"MFMatrix3f.matches(\"0.0 1.0 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(" 0.0  12.3E45  0  3 4 5 6 7 8 "), (String)"MFMatrix3f.matches(\" 0.0  12.3E45  0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("+0.0 +12.3E+45 0  3 4 5 6 7 8 "), (String)"MFMatrix3f.matches(\"+0.0 +12.3E+45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches("-0.0 -12.3E-45 0  3 4 5 6 7 8 "), (String)"MFMatrix3f.matches(\"-0.0 -12.3E-45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3f.matches(".6 -.6 0 .6e7 -.6e-7 0 6 7 8 "), (String)"MFMatrix3f.matches(\".6 -.6 0 .6e7 -.6e-7 0 6 7 8 \") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)MFMatrix3f.matches("0 0 0, 1 1 1, 2 2 2, "), (String)"MFMatrix3f.matches(\"0 0 0, 1 1 1, 2 2 2, \")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)MFMatrix3f.matches("true false false"), (String)"MFMatrix3f.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFMatrix3f.matches("blah"), (String)"MFMatrix3f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFMatrix3f.matches("NaN NaN NaN"), (String)"MFMatrix3f.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFMatrix3d multiple-field 9-tuple double-precision floating-point array")
    void MFMatrix3dTests() {
        System.out.println("MFMatrix3dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFMatrix3d.DEFAULT_VALUE, new MFMatrix3d().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFMatrix3d testMFMatrix3d = new MFMatrix3d();
        Assertions.assertTrue((boolean)testMFMatrix3d.matches(), (String)"testMFMatrix3d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] doubleValueArray = new double[]{1.0, -2.0, -3.0, -4.0, 5.0, -6.0, 7.0, 8.0, 9.0, 11.0, -12.0, -13.0, -14.0, 15.0, -16.0, 17.0, 18.0, 19.0};
        double[] tripleValueArray = new double[]{1.0, -2.0, -3.0, 4.0, 5.0, -6.0, 7.0, 8.0, 9.0, 11.0, -12.0, -13.0, -14.0, 15.0, -16.0, 17.0, 18.0, 19.0, 21.0, -22.0, -23.0, -24.0, 25.0, -26.0, 27.0, 28.0, 29.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFMatrix3d.DEFAULT_VALUE), (String)"test correct default value is emptyArray for this MF field object");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(""), (String)"MFMatrix3d.matches(MFMatrix3d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFMatrix3d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFMatrix3d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFMatrix3f.REGEX.equals(MFMatrix3d.REGEX) returns true");
        testMFMatrix3d = new MFMatrix3d();
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, testMFMatrix3d.getPrimitiveValue()), (String)"tests setting object value is emptyArray and results in emptyArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3d.matches(), (String)"testMFMatrix3d.matches() tests emptyArray initialization correctly matches regex");
        testMFMatrix3d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFMatrix3d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3d.matches(), (String)"testMFMatrix3d.matches() tests singleValueArray correctly matches regex");
        testMFMatrix3d.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFMatrix3d.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3d.matches(), (String)"testMFMatrix3d.matches() tests doubleValueArray correctly matches regex");
        testMFMatrix3d.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFMatrix3d.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix3d.matches(), (String)"testMFMatrix3d.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(" 0  1  2   3  4  5  6 7 8 "), (String)"MFMatrix3d.matches( \" 0  1  2   3  4  5  6 7 8 \") tests correct string value");
        Assertions.assertFalse((boolean)MFMatrix3d.matches(" 0  1  2,  3  4  5, 6 7 8 "), (String)"MFMatrix3d.matches( \" 0  1  2,  3  4  5, 6 7 8 \") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("-1 -2 -3  -4 -5 -6  7 8 9 "), (String)"MFMatrix3d.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 \") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(" 0  12E45  0 4 5 6 7 8 9 "), (String)"MFMatrix3d.matches(\" 0  12E45  0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("+0 +12E+45 0 4 5 6 7 8 9 "), (String)"MFMatrix3d.matches(\"+0,+12E+45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("-0 -12E-45 0 4 5 6 7 8 9 "), (String)"MFMatrix3d.matches(\"-0,-12E-45 0 4 5 6 7 8 9 \") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(""), (String)"MFMatrix3d.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFMatrix3d.matches(","), (String)"MFMatrix3d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(" 0.0  1.0 2.0 3 4 5 6 7 8"), (String)"MFMatrix3d.matches(\" 0.0  1.0 2.0 3 4 5 6 7 8\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("-1.0 -3.0 -0  3 4 5 6 7 8"), (String)"MFMatrix3d.matches(\"-1.0 -3.0 -0  3 4 5 6 7 8\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("0 1 0  3 4 5 6 7 8"), (String)"MFMatrix3d.matches(\"0 1 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("0.0 1.0 0  3 4 5 6 7 8"), (String)"MFMatrix3d.matches(\"0.0 1.0 0  3 4 5 6 7 8\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(" 0.0  12.3E45  0  3 4 5 6 7 8 "), (String)"MFMatrix3d.matches(\" 0.0  12.3E45  0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("+0.0 +12.3E+45 0  3 4 5 6 7 8 "), (String)"MFMatrix3d.matches(\"+0.0 +12.3E+45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches("-0.0 -12.3E-45 0  3 4 5 6 7 8 "), (String)"MFMatrix3d.matches(\"-0.0 -12.3E-45 0  3 4 5 6 7 8\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix3d.matches(".6 -.6 0 .6e7 -.6e-7 0 6 7 8 "), (String)"MFMatrix3d.matches(\".6 -.6 0 .6e7 -.6e-7 0 6 7 8 \") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)MFMatrix3d.matches("0 0 0, 1 1 1, 2 2 2, "), (String)"MFMatrix3d.matches(\"0 0 0, 1 1 1, 2 2 2, \")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)MFMatrix3d.matches("true false false"), (String)"MFMatrix3d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFMatrix3d.matches("blah"), (String)"MFMatrix3d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFMatrix3d.matches("NaN NaN NaN"), (String)"MFMatrix3d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFMatrix4f single-field 16-tuple single-precision floating-point array")
    void SFMatrix4fTests() {
        System.out.println("SFMatrix4fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFMatrix4f.DEFAULT_VALUE, new SFMatrix4f().setValueByString("1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFMatrix4f testSFMatrix4f = new SFMatrix4f();
        Assertions.assertTrue((boolean)testSFMatrix4f.matches(), (String)"testSFMatrix4f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] identityArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, SFMatrix4f.DEFAULT_VALUE), (String)"test correct default value is identity array for this MF field object");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1"), (String)"SFMatrix4f.matches(SFMatrix4f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFMatrix4f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFMatrix4f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFMatrix4f.REGEX.equals(SFMatrix4d.REGEX) returns true");
        testSFMatrix4f = new SFMatrix4f();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix4f.getPrimitiveValue()), (String)"tests setting default object value results in identityArray for equivalent getPrimitiveValue()");
        testSFMatrix4f.setIdentity();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix4f.getPrimitiveValue()), (String)"tests setting object value using setIdentity() results in identityArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix4f.matches(), (String)"testSFMatrix4f.matches() tests setIdentity() initialization correctly matches regex");
        testSFMatrix4f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFMatrix4f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix4f.matches(), (String)"testSFMatrix4f.matches() tests singleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)SFMatrix4f.matches(" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15"), (String)"SFMatrix4f.matches(\" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15\") tests correct string value");
        Assertions.assertFalse((boolean)SFMatrix4f.matches(" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15"), (String)"SFMatrix4f.matches(\" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15\") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix4f.matches(" 0  12E45  0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\" 0  12E45  0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("+0 +12E+45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"+0,+12E+45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("-0 -12E-45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"-0,-12E-45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix4f.matches(""), (String)"SFMatrix4f.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFMatrix4f.matches(","), (String)"SFMatrix4f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)SFMatrix4f.matches(" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix4f.matches(" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4f.matches("-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\"-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4f.matches(" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4f.matches(\" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix4f.matches("0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3"), (String)"SFMatrix4f.matches(\"0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3\")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)SFMatrix4f.matches("true false false"), (String)"SFMatrix4f.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFMatrix4f.matches("blah"), (String)"SFMatrix4f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFMatrix4f.matches("NaN NaN NaN"), (String)"SFMatrix4f.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test SFMatrix4d single-field 16-tuple double-precision floating-point array")
    void SFMatrix4dTests() {
        System.out.println("SFMatrix4dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(SFMatrix4d.DEFAULT_VALUE, new SFMatrix4d().setValueByString("1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        SFMatrix4d testSFMatrix4d = new SFMatrix4d();
        Assertions.assertTrue((boolean)testSFMatrix4d.matches(), (String)"testSFMatrix4d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] identityArray = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, SFMatrix4d.DEFAULT_VALUE), (String)"test correct default value is identity array for this MF field object");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1"), (String)"SFMatrix4d.matches(SFMatrix4d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testSFMatrix4d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("^") && !"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".contains("$") ? 1 : 0) != 0, (String)"test SFMatrix4d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*".equals("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*"), (String)"test SFMatrix4d.REGEX.equals(SFMatrix4d.REGEX) returns true");
        testSFMatrix4d = new SFMatrix4d();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix4d.getPrimitiveValue()), (String)"tests setting default object value results in identityArray for equivalent getPrimitiveValue()");
        testSFMatrix4d.setIdentity();
        Assertions.assertTrue((boolean)Arrays.equals(identityArray, testSFMatrix4d.getPrimitiveValue()), (String)"tests setting object value using setIdentity() results in identityArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix4d.matches(), (String)"testSFMatrix4d.matches() tests setIdentity() initialization correctly matches regex");
        testSFMatrix4d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testSFMatrix4d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testSFMatrix4d.matches(), (String)"testSFMatrix4d.matches() tests singleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)SFMatrix4d.matches(" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15"), (String)"SFMatrix4d.matches( \" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15\") tests correct string value");
        Assertions.assertFalse((boolean)SFMatrix4d.matches(" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15"), (String)"SFMatrix4d.matches( \" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15\") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix4d.matches(" 0  12E45  0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\" 0  12E45  0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("+0 +12E+45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"+0,+12E+45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("-0 -12E-45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"-0,-12E-45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix4d.matches(""), (String)"SFMatrix4d.matches(\"\") tests incorrect empty string value");
        Assertions.assertFalse((boolean)SFMatrix4d.matches(","), (String)"SFMatrix4d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)SFMatrix4d.matches(" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)SFMatrix4d.matches(" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4d.matches("-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\"-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)SFMatrix4d.matches(" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16"), (String)"SFMatrix4d.matches(\" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)SFMatrix4d.matches("0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3"), (String)"SFMatrix4d.matches(\"0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3\")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)SFMatrix4d.matches("true false false"), (String)"SFMatrix4d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)SFMatrix4d.matches("blah"), (String)"SFMatrix4d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)SFMatrix4d.matches("NaN NaN NaN"), (String)"SFMatrix4d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFMatrix4f multiple-field 16-tuple single-precision floating-point array")
    void MFMatrix4fTests() {
        System.out.println("MFMatrix4fTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFMatrix4f.DEFAULT_VALUE, new MFMatrix4f().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFMatrix4f testMFMatrix4f = new MFMatrix4f();
        Assertions.assertTrue((boolean)testMFMatrix4f.matches(), (String)"testMFMatrix4f.matches() tests that object initialization correctly matches regex");
        float[] emptyArray = new float[]{};
        float[] singleValueArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] doubleValueArray = new float[]{1.0f, -2.0f, -3.0f, -4.0f, 5.0f, -6.0f, 7.0f, 8.0f, 9.0f, 10.0f, -11.0f, -12.0f, -13.0f, -14.0f, 15.0f, -16.0f, 17.0f, 18.0f, 19.0f, 20.0f, 21.0f, -22.0f, -23.0f, -24.0f, 25.0f, -26.0f, 27.0f, 28.0f, 29.0f, 30.0f, 31.0f, 32.0f};
        float[] tripleValueArray = new float[]{1.0f, -2.0f, -3.0f, -4.0f, 5.0f, -6.0f, 7.0f, 8.0f, 9.0f, 10.0f, -11.0f, -12.0f, -13.0f, -14.0f, 15.0f, -16.0f, 17.0f, 18.0f, 19.0f, 20.0f, 21.0f, -22.0f, -23.0f, -24.0f, 25.0f, -26.0f, 27.0f, 28.0f, 29.0f, 30.0f, 31.0f, 32.0f, 33.0f, 34.0f, 35.0f, 36.0f, 37.0f, -38.0f, -39.0f, -40.0f, 41.0f, -42.0f, 43.0f, 44.0f, 45.0f, 46.0f, 47.0f, 48.0f};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFMatrix4f.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(""), (String)"MFMatrix4f.matches(MFMatrix4f.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFMatrix4f.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFMatrix4f.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFMatrix4f.REGEX.equals(MFMatrix4d.REGEX) returns true");
        testMFMatrix4f = new MFMatrix4f();
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, testMFMatrix4f.getPrimitiveValue()), (String)"tests setting object value to default object results in emptyArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4f.matches(), (String)"testMFMatrix4f.matches() tests emptyArray initialization correctly matches regex");
        testMFMatrix4f.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFMatrix4f.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4f.matches(), (String)"testMFMatrix4f.matches() tests singleValueArray correctly matches regex");
        testMFMatrix4f.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFMatrix4f.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4f.matches(), (String)"testMFMatrix4f.matches() tests doubleValueArray correctly matches regex");
        testMFMatrix4f.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFMatrix4f.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4f.matches(), (String)"testMFMatrix4f.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15"), (String)"MFMatrix4f.matches( \" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15\") tests correct string value");
        Assertions.assertFalse((boolean)MFMatrix4f.matches(" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15"), (String)"MFMatrix4f.matches( \" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15\") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches( \"-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(" 0  12E45  0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\" 0  12E45  0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("+0 +12E+45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"+0,+12E+45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("-0 -12E-45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"-0,-12E-45 0 4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(""), (String)"MFMatrix4f.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFMatrix4f.matches(","), (String)"MFMatrix4f.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches("-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\"-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4f.matches(" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4f.matches(\" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)MFMatrix4f.matches("0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3"), (String)"MFMatrix4f.matches(\"0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3\")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)MFMatrix4f.matches("true false false"), (String)"MFMatrix4f.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFMatrix4f.matches("blah"), (String)"MFMatrix4f.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFMatrix4f.matches("NaN NaN NaN"), (String)"MFMatrix4f.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    @Test
    @DisplayName(value="Test MFMatrix4d multiple-field 16-tuple double-precision floating-point array")
    void MFMatrix4dTests() {
        System.out.println("MFMatrix4dTests...");
        Assertions.assertTrue((boolean)Arrays.equals(MFMatrix4d.DEFAULT_VALUE, new MFMatrix4d().setValueByString("").getPrimitiveValue()), (String)"test DEFAULT_VALUE matches DEFAULT_VALUE_STRING for this field object");
        MFMatrix4d testMFMatrix4d = new MFMatrix4d();
        Assertions.assertTrue((boolean)testMFMatrix4d.matches(), (String)"testMFMatrix4d.matches() tests that object initialization correctly matches regex");
        double[] emptyArray = new double[]{};
        double[] singleValueArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] doubleValueArray = new double[]{1.0, -2.0, -3.0, -4.0, 5.0, -6.0, 7.0, 8.0, 9.0, 10.0, -11.0, -12.0, -13.0, -14.0, 15.0, -16.0, 17.0, 18.0, 19.0, 20.0, 21.0, -22.0, -23.0, -24.0, 25.0, -26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0};
        double[] tripleValueArray = new double[]{1.0, -2.0, -3.0, -4.0, 5.0, -6.0, 7.0, 8.0, 9.0, 10.0, -11.0, -12.0, -13.0, -14.0, 15.0, -16.0, 17.0, 18.0, 19.0, 20.0, 21.0, -22.0, -23.0, -24.0, 25.0, -26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, -38.0, -39.0, -40.0, 41.0, -42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0};
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, MFMatrix4d.DEFAULT_VALUE), (String)"test correct default value is empty array for this MF field object");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(""), (String)"MFMatrix4d.matches(MFMatrix4d.DEFAULT_VALUE_STRING) tests object initialization correctly matches regex");
        Assertions.assertTrue((boolean)testMFMatrix4d.isDefaultValue(), (String)"test initialized field object isDefaultValue() returns true");
        Assertions.assertTrue((!"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("^") && !"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".contains("$") ? 1 : 0) != 0, (String)"test MFMatrix4d.REGEX does not contain anchor characters ^ or $");
        Assertions.assertTrue((boolean)"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*".equals("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*"), (String)"test MFMatrix4d.REGEX.equals(MFMatrix4d.REGEX) returns true");
        testMFMatrix4d = new MFMatrix4d();
        Assertions.assertTrue((boolean)Arrays.equals(emptyArray, testMFMatrix4d.getPrimitiveValue()), (String)"tests setting object value to default object results in emptyArray for equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4d.matches(), (String)"testMFMatrix4d.matches() tests emptyArray initialization correctly matches regex");
        testMFMatrix4d.setValue(singleValueArray);
        Assertions.assertEquals((Object)singleValueArray, (Object)testMFMatrix4d.getPrimitiveValue(), (String)"tests setting object value to singleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4d.matches(), (String)"testMFMatrix4d.matches() tests singleValueArray correctly matches regex");
        testMFMatrix4d.setValue(doubleValueArray);
        Assertions.assertEquals((Object)doubleValueArray, (Object)testMFMatrix4d.getPrimitiveValue(), (String)"tests setting object value to doubleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4d.matches(), (String)"testMFMatrix4d.matches() tests doubleValueArray correctly matches regex");
        testMFMatrix4d.setValue(tripleValueArray);
        Assertions.assertEquals((Object)tripleValueArray, (Object)testMFMatrix4d.getPrimitiveValue(), (String)"tests setting object value to tripleValueArray results in equivalent getPrimitiveValue()");
        Assertions.assertTrue((boolean)testMFMatrix4d.matches(), (String)"testMFMatrix4d.matches() tests tripleValueArray correctly matches regex");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15"), (String)"MFMatrix4d.matches(\" 0  1  2   3  4  5  6 7 8  9 10 11 12 13 14 15\") tests correct string value");
        Assertions.assertFalse((boolean)MFMatrix4d.matches(" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15"), (String)"MFMatrix4d.matches(\" 0  1  2,  3  4  5, 6 7 8  9 10 11 12 13 14 15\") tests incorrect string value, no commas allowed");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"-1 -2 -3  -4 -5 -6  7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(" 0  12E45  0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\" 0  12E45  0 4 5 6  7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("+0 +12E+45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"+0 +12E+45 0 4 5 6  7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("-0 -12E-45 0 4 5 6  7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"-0 -12E-45 0 4 5 6  7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(""), (String)"MFMatrix4d.matches(\"\") tests correct empty string value");
        Assertions.assertFalse((boolean)MFMatrix4d.matches(","), (String)"MFMatrix4d.matches(\",\") tests incorrect inclusion of comma as whitespace");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\" 0.0  1.0 2.0       4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"-1.0 -3.0 -0        4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, including external whitespace");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"0   1   0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"0.0 1.0 0           4 5 6 7 8 9 10 11 12 13 14 15 16\")  tests correct array as string value");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\" 0.0  12.3E45  0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"+0.0 +12.3E+45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches("-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\"-0.0 -12.3E-45 0    4 5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, scientific notation");
        Assertions.assertTrue((boolean)MFMatrix4d.matches(" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16"), (String)"MFMatrix4d.matches(\" .6 -.6 .6e7 -.6e-7   5 6 7 8 9 10 11 12 13 14 15 16\") tests correct string value, no leading digit before decimal point, scientific notation");
        Assertions.assertFalse((boolean)MFMatrix4d.matches("0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3"), (String)"MFMatrix4d.matches(\"0 0 0 0, 1 1 1 1, 2 2 2 2, 3 3 3 3\")  tests incorrect array as string value, including whitespace and commas, with trailing comma");
        Assertions.assertFalse((boolean)MFMatrix4d.matches("true false false"), (String)"MFMatrix4d.matches(\"true false false\") tests incorrect boolean string value");
        Assertions.assertFalse((boolean)MFMatrix4d.matches("blah"), (String)"MFMatrix4d.matches(\"blah\") tests incorrect alphabetic string value");
        Assertions.assertFalse((boolean)MFMatrix4d.matches("NaN NaN NaN"), (String)"MFMatrix4d.matches(\"NaN NaN NaN\") tests Not A Number (NaN) which is not an allowed string value");
    }

    public static void main(String[] args) {
        System.out.println("FieldObjectTests start...");
        FieldObjectTests thisFieldTestSet = new FieldObjectTests();
        thisFieldTestSet.fieldObjectInitializationsTest();
        System.out.println("FieldObjectTests complete");
    }
}

