/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFVec2d
extends X3DConcreteField
implements org.web3d.x3d.sai.SFVec2d {
    public static final String NAME = "SFVec2d";
    public static final double[] DEFAULT_VALUE = new double[]{0.0, 0.0};
    public static final String DEFAULT_VALUE_STRING = "0.0 0.0";
    public static final int TUPLE_SIZE = 2;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] SFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFVec2d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFVec2d comparisonSFVec2d) {
        return this.getPrimitiveValue() == comparisonSFVec2d.getPrimitiveValue();
    }

    public final String validate() {
        SFVec2d tempHold = new SFVec2d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFVec2d validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new SFVec2d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec2d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec2d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFVec2d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFVec2d.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new SFVec2d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 2) {
                String errorNotice = "illegal number of values in initialization string, new SFVec2d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFVec2d[0] = Double.parseDouble(newValues[0]);
            this.SFVec2d[1] = Double.parseDouble(newValues[1]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFVec2d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFVec2d(SFVec2d newValue) {
        if (newValue == null) {
            this.SFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFVec2d = newValue.getPrimitiveValue();
    }

    public SFVec2d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "Illegal SFVec2d newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec2d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec2d = newValue;
    }

    public SFVec2d(double x, double y) {
        this.SFVec2d[0] = x;
        this.SFVec2d[1] = y;
    }

    public SFVec2d normalize() {
        double length = Math.sqrt(this.SFVec2d[0] * this.SFVec2d[0] + this.SFVec2d[1] * this.SFVec2d[1]);
        if (length > 0.0) {
            this.SFVec2d[0] = this.SFVec2d[0] / length;
            this.SFVec2d[1] = this.SFVec2d[1] / length;
        }
        return this;
    }

    public SFVec2d(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.SFVec2d;
    }

    public double[] getPrimitiveValue() {
        return this.SFVec2d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFVec2d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.SFVec2d[i]));
            } else {
                result.append(this.SFVec2d[i]);
            }
            if (i >= this.SFVec2d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(double[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "Illegal SFVec2d newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec2d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec2d = newValue;
    }

    public SFVec2d setValueArray(double[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFVec2d setValue(float[] newValue) {
        double[] newDoubleArray = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            newDoubleArray[i] = newValue[i];
        }
        this.setValue(newDoubleArray);
        return this;
    }

    public SFVec2d setValue(double x, double y) {
        this.SFVec2d[0] = x;
        this.SFVec2d[1] = y;
        return this;
    }

    public double[] toDoubleArray() {
        return this.SFVec2d;
    }

    public SFVec2d setValue(SFVec2d newValue) {
        if (newValue == null) {
            this.SFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFVec2d = newValue.getPrimitiveValue();
        return this;
    }

    public SFVec2d multiply(double scaleFactor) {
        this.SFVec2d[0] = this.SFVec2d[0] * scaleFactor;
        this.SFVec2d[1] = this.SFVec2d[1] * scaleFactor;
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFVec2d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFVec2d(DEFAULT_VALUE).matches()) {
                System.out.println("SFVec2d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFVec2d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

