/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFRotation
extends X3DConcreteField
implements org.web3d.x3d.sai.SFRotation {
    public static final String NAME = "SFRotation";
    public static final float[] DEFAULT_VALUE = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static final float[] DEFAULT_VALUE_PREFERRED = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    public static final String DEFAULT_VALUE_STRING = "0 0 1 0";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFRotation() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFRotation comparisonSFRotation) {
        return this.getPrimitiveValue() == comparisonSFRotation.getPrimitiveValue();
    }

    public final String validate() {
        SFRotation tempHold = new SFRotation(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFRotation validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new SFRotation PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFRotation";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFRotation";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFRotation setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFRotation.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new SFRotation(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 4) {
                String errorNotice = "illegal number of values in initialization string, new SFRotation(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFRotation[0] = Float.parseFloat(newValues[0]);
            this.SFRotation[1] = Float.parseFloat(newValues[1]);
            this.SFRotation[2] = Float.parseFloat(newValues[2]);
            this.SFRotation[3] = Float.parseFloat(newValues[3]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFRotation(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFRotation(SFRotation newValue) {
        if (newValue == null) {
            this.SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFRotation = newValue.getPrimitiveValue();
    }

    public SFRotation(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "Illegal SFRotation newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFRotation.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFRotation = newValue;
    }

    public static float degreesToRadians(float angleDegrees) {
        return (float)((double)angleDegrees * Math.PI / 180.0);
    }

    public static float degreesToRadians(int angleDegrees) {
        return (float)((double)angleDegrees * Math.PI / 180.0);
    }

    public static float degreesToRadians(double angleDegrees) {
        return (float)(angleDegrees * Math.PI / 180.0);
    }

    public static float radiansToDegrees(float angleRadians) {
        return (float)((double)angleRadians * 180.0 / Math.PI);
    }

    public static float radiansToDegrees(double angleRadians) {
        return (float)(angleRadians * 180.0 / Math.PI);
    }

    public SFRotation(float x, float y, float z, float angleRadians) {
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            String errorNotice = "Illegal SFRotation value (" + x + "," + y + "," + z + "," + angleRadians + ") since (x,y,z) axis vector must have a direction and cannot be (0,0,0)";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if ((double)Math.abs(angleRadians) > Math.PI * 2) {
            System.out.println("SFRotation constructor: questionable |angleRadians| = " + Math.abs(angleRadians) + " > 2pi");
        }
        this.SFRotation[0] = x;
        this.SFRotation[1] = y;
        this.SFRotation[2] = z;
        this.SFRotation[3] = angleRadians;
    }

    public SFRotation(double x, double y, double z, double angleRadians) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            String errorNotice = "Illegal SFRotation value (" + x + "," + y + "," + z + "," + angleRadians + ") since (x,y,z) axis vector must have a direction and cannot be (0,0,0)";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (Math.abs(angleRadians) > Math.PI * 2) {
            System.out.println("SFRotation constructor: questionable |angleRadians| = " + Math.abs(angleRadians) + " > 2pi");
        }
        this.SFRotation[0] = (float)x;
        this.SFRotation[1] = (float)y;
        this.SFRotation[2] = (float)z;
        this.SFRotation[3] = (float)angleRadians;
    }

    public SFRotation(int x, int y, int z, float angleRadians) {
        if (x == 0 && y == 0 && z == 0) {
            String errorNotice = "Illegal SFRotation value (" + x + "," + y + "," + z + "," + angleRadians + ") since (x,y,z) axis vector must have a direction and cannot be (0,0,0)";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if ((double)Math.abs(angleRadians) > Math.PI * 2) {
            System.out.println("SFRotation constructor: questionable |angleRadians| = " + Math.abs(angleRadians) + " > 2pi");
        }
        this.SFRotation[0] = x;
        this.SFRotation[1] = y;
        this.SFRotation[2] = z;
        this.SFRotation[3] = angleRadians;
    }

    public SFRotation normalize() {
        float length = (float)Math.sqrt(this.SFRotation[0] * this.SFRotation[0] + this.SFRotation[1] * this.SFRotation[1] + this.SFRotation[2] * this.SFRotation[2]);
        if (length == 0.0f) {
            this.SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            System.out.println("SFRotation.normalize(): zero-length axis encountered, reset entire SFRotation to DEFAULT_VALUE: " + String.valueOf(DEFAULT_VALUE));
        } else {
            this.SFRotation[0] = this.SFRotation[0] / length;
            this.SFRotation[1] = this.SFRotation[1] / length;
            this.SFRotation[2] = this.SFRotation[2] / length;
            while (this.SFRotation[3] < 0.0f) {
                this.SFRotation[3] = (float)((double)this.SFRotation[3] + Math.PI * 2);
            }
            while ((double)this.SFRotation[3] >= Math.PI * 2) {
                this.SFRotation[3] = (float)((double)this.SFRotation[3] - Math.PI * 2);
            }
        }
        return this;
    }

    public SFRotation setValue(float x, float y, float z, float angleRadians) {
        float[] floatArray = new float[]{x, y, z, angleRadians};
        this.setValue(floatArray);
        return this;
    }

    public SFRotation setValue(double x, double y, double z, double angleRadians) {
        this.setValue((float)x, (float)y, (float)z, (float)angleRadians);
        return this;
    }

    public SFRotation setValue(double[] newValue) {
        float x = (float)newValue[0];
        float y = (float)newValue[1];
        float z = (float)newValue[2];
        float angleRadians = (float)newValue[3];
        this.setValue(x, y, z, angleRadians);
        return this;
    }

    public SFRotation(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.SFRotation;
    }

    public float[] getPrimitiveValue() {
        return this.SFRotation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFRotation.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFRotation[i]));
            } else {
                result.append(this.SFRotation[i]);
            }
            if (i >= this.SFRotation.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(float[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "Illegal SFRotation newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFRotation.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        float x = newValue[0];
        float y = newValue[1];
        float z = newValue[2];
        float angleRadians = newValue[3];
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            String errorNotice = "Illegal SFRotation value (" + x + "," + y + "," + z + "," + angleRadians + ") since (x,y,z) axis vector must have a direction and cannot be (0,0,0)";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if ((double)Math.abs(angleRadians) > Math.PI * 2) {
            System.out.println("SFRotation constructor: questionable |angleRadians| = " + Math.abs(angleRadians) + " > 2pi");
        }
        this.SFRotation = newValue;
    }

    public SFRotation setValueArray(float[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public float[] toFloatArray() {
        return this.SFRotation;
    }

    public SFRotation setValue(SFRotation newValue) {
        if (newValue == null) {
            this.SFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFRotation = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFRotation, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFRotation(DEFAULT_VALUE).matches()) {
                System.out.println("SFRotation.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFRotation initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

