/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix4;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3f;

public class SFMatrix4f
extends X3DConcreteField
implements org.web3d.x3d.sai.SFMatrix4f {
    public static final String NAME = "SFMatrix4f";
    public static final float[] DEFAULT_VALUE = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public static final String DEFAULT_VALUE_STRING = "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1";
    public static final int TUPLE_SIZE = 16;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFMatrix4f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFMatrix4f comparisonSFMatrix4f) {
        return this.getPrimitiveValue() == comparisonSFMatrix4f.getPrimitiveValue();
    }

    public final String validate() {
        SFMatrix4f tempHold = new SFMatrix4f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFMatrix4f validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new SFMatrix4f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix4f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix4f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFMatrix4f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFMatrix4f.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new SFMatrix4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 16) {
                String errorNotice = "illegal number of values in initialization string";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFMatrix4f[0] = Float.parseFloat(newValues[0]);
            this.SFMatrix4f[1] = Float.parseFloat(newValues[1]);
            this.SFMatrix4f[2] = Float.parseFloat(newValues[2]);
            this.SFMatrix4f[3] = Float.parseFloat(newValues[3]);
            this.SFMatrix4f[4] = Float.parseFloat(newValues[4]);
            this.SFMatrix4f[5] = Float.parseFloat(newValues[5]);
            this.SFMatrix4f[6] = Float.parseFloat(newValues[6]);
            this.SFMatrix4f[7] = Float.parseFloat(newValues[7]);
            this.SFMatrix4f[8] = Float.parseFloat(newValues[8]);
            this.SFMatrix4f[9] = Float.parseFloat(newValues[9]);
            this.SFMatrix4f[10] = Float.parseFloat(newValues[10]);
            this.SFMatrix4f[11] = Float.parseFloat(newValues[11]);
            this.SFMatrix4f[12] = Float.parseFloat(newValues[12]);
            this.SFMatrix4f[13] = Float.parseFloat(newValues[13]);
            this.SFMatrix4f[14] = Float.parseFloat(newValues[14]);
            this.SFMatrix4f[15] = Float.parseFloat(newValues[15]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFMatrix4f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFMatrix4f(SFMatrix4f newValue) {
        if (newValue == null) {
            this.SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFMatrix4f = newValue.getPrimitiveValue();
    }

    public SFMatrix4f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 16) {
            String errorNotice = "Illegal SFMatrix4f newValue array length=" + newValue.length + ", must equal 16 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFMatrix4f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix4f = newValue;
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public float[] getPrimitiveValue() {
        return this.SFMatrix4f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFMatrix4f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFMatrix4f[i]));
            } else {
                result.append(this.SFMatrix4f[i]);
            }
            if (i >= this.SFMatrix4f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public SFMatrix4f setValue(float[] newValue) {
        if (newValue == null) {
            this.SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length != 16) {
            String errorNotice = "Illegal array newValue=" + String.valueOf(newValue) + " must have base length 16 for setValue() on SFMatrix4f";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix4f = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.SFMatrix4f = DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "Illegal SFMatrix4f[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.SFMatrix4f[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale, SFRotation scaleOrientation, SFVec3f center) {
    }

    @Override
    public void getTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale) {
    }

    @Override
    public Matrix4 inverse() {
        return null;
    }

    @Override
    public Matrix4 transpose() {
        return null;
    }

    @Override
    public Matrix4 multiplyLeft(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRight(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRowVector(SFVec3f vector3f) {
        return null;
    }

    @Override
    public Matrix4 multiplyColVector(SFVec3f vector3f) {
        return null;
    }

    public float[] toFloatArray() {
        return this.SFMatrix4f;
    }

    public SFMatrix4f setValue(SFMatrix4f newValue) {
        if (newValue == null) {
            this.SFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFMatrix4f = newValue.getPrimitiveValue();
        return this;
    }

    public SFMatrix4f multiply(float scaleFactor) {
        int i = 0;
        while (i < this.SFMatrix4f.length) {
            int n = i++;
            this.SFMatrix4f[n] = this.SFMatrix4f[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFMatrix4f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFMatrix4f(DEFAULT_VALUE).matches()) {
                System.out.println("SFMatrix4f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFMatrix4f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

