/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFBool
extends X3DConcreteField
implements org.web3d.x3d.sai.SFBool {
    public static final String NAME = "SFBool";
    public static final boolean DEFAULT_VALUE = false;
    public static final String DEFAULT_VALUE_STRING = "false";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*(true|false)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(true|false)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    public static String TRUE = "true";
    public static String FALSE = "false";
    private boolean SFBool = false;

    public static final boolean isArray() {
        return false;
    }

    public SFBool() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFBool = false;
    }

    public boolean equals(SFBool comparisonSFBool) {
        return this.getPrimitiveValue() == comparisonSFBool.getPrimitiveValue();
    }

    public final String validate() {
        SFBool tempHold = new SFBool(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFBool validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new SFBool PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFBool";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFBool";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFBool setValueByString(String newValue) throws InvalidFieldValueException {
        String errorNotice;
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFBool.matches(newValue)) {
            errorNotice = "[error] Regular expression (regex) failure, new SFBool(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFBool = false;
            return this;
        }
        if (!newValue.equals("true") && !newValue.equals(DEFAULT_VALUE_STRING)) {
            errorNotice = "illegal boolean value, must be 'true' or 'false' (case sensitive), new SFBool(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFBool = Boolean.parseBoolean(newValue);
        return this;
    }

    public SFBool(SFBool newValue) {
        if (newValue == null) {
            this.SFBool = false;
            return;
        }
        this.SFBool = newValue.getPrimitiveValue();
    }

    public SFBool(boolean newValue) {
        this.SFBool = newValue;
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    @Override
    public boolean getValue() {
        return this.SFBool;
    }

    public boolean getPrimitiveValue() {
        return this.SFBool;
    }

    public String toString() {
        return String.valueOf(this.SFBool);
    }

    @Override
    public void setValue(boolean newValue) {
        this.SFBool = newValue;
    }

    public SFBool negate() {
        this.SFBool = !this.SFBool;
        return this;
    }

    public SFBool setValue(SFBool newValue) {
        if (newValue == null) {
            this.SFBool = false;
            return this;
        }
        this.SFBool = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return !this.SFBool;
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFBool(false).matches()) {
                System.out.println("SFBool.initialize() problem: failed to match DEFAULT_VALUE=false");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFBool initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(true|false)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

