/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFVec3f
extends X3DConcreteField
implements org.web3d.x3d.sai.MFVec3f {
    public static final String NAME = "MFVec3f";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 3;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFVec3f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFVec3f comparisonMFVec3f) {
        return this.getPrimitiveValue() == comparisonMFVec3f.getPrimitiveValue();
    }

    public final String validate() {
        MFVec3f tempHold = new MFVec3f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFVec3f validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFVec3f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec3f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec3f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFVec3f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFVec3f.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFVec3f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 3 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 3 when declaring new MFVec3f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFVec3f = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFVec3f[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFVec3f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFVec3f(MFVec3f newValue) {
        if (newValue == null) {
            this.MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFVec3f = newValue.getPrimitiveValue();
    }

    public MFVec3f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 3 != 0) {
            String errorNotice = "Illegal MFVec3f newValue array length=" + newValue.length + ", must be multiple of 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec3f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFVec3f = newValue;
    }

    public MFVec3f normalize() {
        int index = 0;
        while (index + 3 < this.MFVec3f.length) {
            float length = (float)Math.sqrt(this.MFVec3f[index + 0] * this.MFVec3f[index + 0] + this.MFVec3f[index + 1] * this.MFVec3f[index + 1] + this.MFVec3f[index + 2] * this.MFVec3f[index + 2]);
            if (length > 0.0f) {
                this.MFVec3f[index + 0] = this.MFVec3f[index + 0] / length;
                this.MFVec3f[index + 1] = this.MFVec3f[index + 1] / length;
                this.MFVec3f[index + 2] = this.MFVec3f[index + 2] / length;
            }
            index += 3;
        }
        return this;
    }

    public MFVec3f(SFVec3f newValue) {
        this.setValue(newValue);
    }

    public MFVec3f(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFVec3f;
    }

    public float[] getPrimitiveValue() {
        return this.MFVec3f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFVec3f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFVec3f[i]));
            } else {
                result.append(this.MFVec3f[i]);
            }
            if (i >= this.MFVec3f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, float[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec3f.length / 3) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3f array length=" + this.MFVec3f.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFVec3f, index * 3, index * 3 + 3 - 1);
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFVec3f = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(float[][] valueDestination) {
    }

    @Override
    public void setValue(int size, float[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFVec3f = new float[newValue.length];
        this.MFVec3f = newValue;
    }

    public MFVec3f setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFVec3f = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec3f[i] = (float)newValue[i];
        }
        return this;
    }

    public MFVec3f setValue(SFVec3f newValue) {
        if (newValue == null) {
            this.MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toFloatArray());
        return this;
    }

    @Override
    public void set1Value(int index, float[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 3) {
            String errorNotice = "Illegal MFVec3f newValue array length=" + newValue.length + ", must equal 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec3f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec3f.length / 3) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3f array length=" + this.MFVec3f.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFVec3f[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public void append(float[] newValue) {
        if (newValue.length % 3 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 3 when declaring new MFVec3f(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFVec3f.length;
        this.MFVec3f = Arrays.copyOf(this.MFVec3f, this.MFVec3f.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec3f[originalLength + i] = newValue[i];
        }
    }

    public MFVec3f append(SFVec3f newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFVec3f append(MFVec3f newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 3) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 3 for MFVec3finsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec3f.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3f array length=" + this.MFVec3f.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFVec3f.length - index;
        this.MFVec3f = Arrays.copyOf(this.MFVec3f, this.MFVec3f.length + 3);
        System.arraycopy(this.MFVec3f, index, this.MFVec3f, index + 3, sliceLength);
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFVec3f[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFVec3f.length;
    }

    @Override
    public void clear() {
        this.MFVec3f = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec3f.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3f array length=" + this.MFVec3f.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFVec3f.length - (index + 1) * 3;
        System.arraycopy(this.MFVec3f, (index + 1) * 3, this.MFVec3f, index * 3, offsetLength);
        this.MFVec3f = Arrays.copyOfRange(this.MFVec3f, 0, this.MFVec3f.length - 3);
    }

    public float[] toFloatArray() {
        return this.MFVec3f;
    }

    public MFVec3f setValue(MFVec3f newValue) {
        if (newValue == null) {
            this.MFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFVec3f = newValue.getPrimitiveValue();
        return this;
    }

    public MFVec3f multiply(float scaleFactor) {
        int i = 0;
        while (i < this.MFVec3f.length) {
            int n = i++;
            this.MFVec3f[n] = this.MFVec3f[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFVec3f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFVec3f(DEFAULT_VALUE).matches()) {
                System.out.println("MFVec3f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFVec3f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

