/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFVec2f;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFVec2f
extends X3DConcreteField
implements org.web3d.x3d.sai.MFVec2f {
    public static final String NAME = "MFVec2f";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 2;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFVec2f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFVec2f comparisonMFVec2f) {
        return this.getPrimitiveValue() == comparisonMFVec2f.getPrimitiveValue();
    }

    public final String validate() {
        MFVec2f tempHold = new MFVec2f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFVec2f validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFVec2f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec2f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec2f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFVec2f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFVec2f.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFVec2f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 2 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 2 when declaring new MFVec2f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFVec2f = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFVec2f[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFVec2f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFVec2f(MFVec2f newValue) {
        if (newValue == null) {
            this.MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFVec2f = newValue.getPrimitiveValue();
    }

    public MFVec2f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 2 != 0) {
            String errorNotice = "Illegal MFVec2f newValue array length=" + newValue.length + ", must be multiple of 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec2f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFVec2f = newValue;
    }

    public MFVec2f normalize() {
        int index = 0;
        while (index + 2 < this.MFVec2f.length) {
            float length = (float)Math.sqrt(this.MFVec2f[index + 0] * this.MFVec2f[index + 0] + this.MFVec2f[index + 1] * this.MFVec2f[index + 1]);
            if (length > 0.0f) {
                this.MFVec2f[index + 0] = this.MFVec2f[index + 0] / length;
                this.MFVec2f[index + 1] = this.MFVec2f[index + 1] / length;
            }
            index += 2;
        }
        return this;
    }

    public MFVec2f(SFVec2f newValue) {
        this.setValue(newValue);
    }

    public MFVec2f(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFVec2f;
    }

    public float[] getPrimitiveValue() {
        return this.MFVec2f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFVec2f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFVec2f[i]));
            } else {
                result.append(this.MFVec2f[i]);
            }
            if (i >= this.MFVec2f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, float[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec2f.length / 2) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2f array length=" + this.MFVec2f.length / 2;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFVec2f, index * 2, index * 2 + 2 - 1);
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFVec2f = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(float[][] valueDestination) {
    }

    @Override
    public void setValue(int size, float[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFVec2f = new float[newValue.length];
        this.MFVec2f = newValue;
    }

    public MFVec2f setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFVec2f = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec2f[i] = (float)newValue[i];
        }
        return this;
    }

    public MFVec2f setValue(SFVec2f newValue) {
        if (newValue == null) {
            this.MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toFloatArray());
        return this;
    }

    @Override
    public void set1Value(int index, float[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "Illegal MFVec2f newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec2f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec2f.length / 2) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2f array length=" + this.MFVec2f.length / 2;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFVec2f[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public void append(float[] newValue) {
        if (newValue.length % 2 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 2 when declaring new MFVec2f(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFVec2f.length;
        this.MFVec2f = Arrays.copyOf(this.MFVec2f, this.MFVec2f.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec2f[originalLength + i] = newValue[i];
        }
    }

    public MFVec2f append(SFVec2f newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFVec2f append(MFVec2f newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 2) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 2 for MFVec2finsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec2f.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2f array length=" + this.MFVec2f.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFVec2f.length - index;
        this.MFVec2f = Arrays.copyOf(this.MFVec2f, this.MFVec2f.length + 2);
        System.arraycopy(this.MFVec2f, index, this.MFVec2f, index + 2, sliceLength);
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFVec2f[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFVec2f.length;
    }

    @Override
    public void clear() {
        this.MFVec2f = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2f.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec2f.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2f array length=" + this.MFVec2f.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFVec2f.length - (index + 1) * 2;
        System.arraycopy(this.MFVec2f, (index + 1) * 2, this.MFVec2f, index * 2, offsetLength);
        this.MFVec2f = Arrays.copyOfRange(this.MFVec2f, 0, this.MFVec2f.length - 2);
    }

    public float[] toFloatArray() {
        return this.MFVec2f;
    }

    public MFVec2f setValue(MFVec2f newValue) {
        if (newValue == null) {
            this.MFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFVec2f = newValue.getPrimitiveValue();
        return this;
    }

    public MFVec2f multiply(float scaleFactor) {
        int i = 0;
        while (i < this.MFVec2f.length) {
            int n = i++;
            this.MFVec2f[n] = this.MFVec2f[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFVec2f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFVec2f(DEFAULT_VALUE).matches()) {
                System.out.println("MFVec2f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFVec2f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

