/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFVec2d;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFVec2d
extends X3DConcreteField
implements org.web3d.x3d.sai.MFVec2d {
    public static final String NAME = "MFVec2d";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 2;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFVec2d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFVec2d comparisonMFVec2d) {
        return this.getPrimitiveValue() == comparisonMFVec2d.getPrimitiveValue();
    }

    public final String validate() {
        MFVec2d tempHold = new MFVec2d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFVec2d validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFVec2d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec2d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec2d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFVec2d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFVec2d.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFVec2d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 2 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 2 when declaring new MFVec2d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFVec2d = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFVec2d[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFVec2d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFVec2d(MFVec2d newValue) {
        if (newValue == null) {
            this.MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFVec2d = newValue.getPrimitiveValue();
    }

    public MFVec2d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 2 != 0) {
            String errorNotice = "Illegal MFVec2d newValue array length=" + newValue.length + ", must be multiple of 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec2d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFVec2d = newValue;
    }

    public MFVec2d normalize() {
        int index = 0;
        while (index + 2 < this.MFVec2d.length) {
            double length = Math.sqrt(this.MFVec2d[index + 0] * this.MFVec2d[index + 0] + this.MFVec2d[index + 1] * this.MFVec2d[index + 1]);
            if (length > 0.0) {
                this.MFVec2d[index + 0] = this.MFVec2d[index + 0] / length;
                this.MFVec2d[index + 1] = this.MFVec2d[index + 1] / length;
            }
            index += 2;
        }
        return this;
    }

    public MFVec2d(SFVec2d newValue) {
        this.setValue(newValue);
    }

    public MFVec2d(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.MFVec2d;
    }

    public double[] getPrimitiveValue() {
        return this.MFVec2d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFVec2d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFVec2d[i]));
            } else {
                result.append(this.MFVec2d[i]);
            }
            if (i >= this.MFVec2d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, double[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec2d.length / 2) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2d array length=" + this.MFVec2d.length / 2;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFVec2d, index * 2, index * 2 + 2 - 1);
    }

    @Override
    public void setValue(int size, double[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFVec2d = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(double[][] valueDestination) {
    }

    @Override
    public void setValue(int size, double[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFVec2d = new double[newValue.length];
        this.MFVec2d = newValue;
    }

    public MFVec2d setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFVec2d = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec2d[i] = newValue[i];
        }
        return this;
    }

    public MFVec2d setValue(SFVec2d newValue) {
        if (newValue == null) {
            this.MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toDoubleArray());
        return this;
    }

    @Override
    public void set1Value(int index, double[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "Illegal MFVec2d newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec2d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec2d.length / 2) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2d array length=" + this.MFVec2d.length / 2;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec2d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public void append(double[] newValue) {
        if (newValue.length % 2 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 2 when declaring new MFVec2d(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFVec2d.length;
        this.MFVec2d = Arrays.copyOf(this.MFVec2d, this.MFVec2d.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec2d[originalLength + i] = newValue[i];
        }
    }

    public MFVec2d append(SFVec2d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFVec2d append(MFVec2d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, double[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 2) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 2 for MFVec2dinsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec2d.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2d array length=" + this.MFVec2d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFVec2d.length - index;
        this.MFVec2d = Arrays.copyOf(this.MFVec2d, this.MFVec2d.length + 2);
        System.arraycopy(this.MFVec2d, index, this.MFVec2d, index + 2, sliceLength);
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec2d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFVec2d.length;
    }

    @Override
    public void clear() {
        this.MFVec2d = new double[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec2d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec2d.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec2d array length=" + this.MFVec2d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFVec2d.length - (index + 1) * 2;
        System.arraycopy(this.MFVec2d, (index + 1) * 2, this.MFVec2d, index * 2, offsetLength);
        this.MFVec2d = Arrays.copyOfRange(this.MFVec2d, 0, this.MFVec2d.length - 2);
    }

    public double[] toDoubleArray() {
        return this.MFVec2d;
    }

    public MFVec2d setValue(MFVec2d newValue) {
        if (newValue == null) {
            this.MFVec2d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFVec2d = newValue.getPrimitiveValue();
        return this;
    }

    public MFVec2d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFVec2d.length) {
            int n = i++;
            this.MFVec2d[n] = this.MFVec2d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFVec2d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFVec2d(DEFAULT_VALUE).matches()) {
                System.out.println("MFVec2d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFVec2d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

