/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFRotation;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFRotation
extends X3DConcreteField
implements org.web3d.x3d.sai.MFRotation {
    public static final String NAME = "MFRotation";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFRotation() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFRotation comparisonMFRotation) {
        return this.getPrimitiveValue() == comparisonMFRotation.getPrimitiveValue();
    }

    public final String validate() {
        MFRotation tempHold = new MFRotation(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFRotation validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFRotation PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFRotation array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFRotation array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFRotation setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFRotation.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFRotation(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 4 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 4 when declaring new MFRotation(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFRotation = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFRotation[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFRotation(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFRotation(MFRotation newValue) {
        if (newValue == null) {
            this.MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFRotation = newValue.getPrimitiveValue();
    }

    public MFRotation(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 4 != 0) {
            String errorNotice = "Illegal MFRotation newValue array length=" + newValue.length + ", must be multiple of 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFRotation.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFRotation = newValue;
    }

    public MFRotation(SFRotation newValue) {
        this.setValue(newValue);
    }

    public MFRotation(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFRotation;
    }

    public float[] getPrimitiveValue() {
        return this.MFRotation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFRotation.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFRotation[i]));
            } else {
                result.append(this.MFRotation[i]);
            }
            if (i >= this.MFRotation.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, float[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFRotation.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFRotation.length / 4) {
            String errorNotice = "Provided array index=" + index + " must be less than MFRotation array length=" + this.MFRotation.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFRotation, index * 4, index * 4 + 4 - 1);
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFRotation = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(float[][] valueDestination) {
    }

    @Override
    public void setValue(int size, float[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFRotation = new float[newValue.length];
        this.MFRotation = newValue;
    }

    public MFRotation setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFRotation = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFRotation[i] = (float)newValue[i];
        }
        return this;
    }

    public MFRotation setValue(SFRotation newValue) {
        if (newValue == null) {
            this.MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toFloatArray());
        return this;
    }

    @Override
    public void set1Value(int index, float[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFRotation.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "Illegal MFRotation newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFRotation.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFRotation.length / 4) {
            String errorNotice = "Provided array index=" + index + " must be less than MFRotation array length=" + this.MFRotation.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFRotation[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public void append(float[] newValue) {
        if (newValue.length % 4 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFRotation(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFRotation.length;
        this.MFRotation = Arrays.copyOf(this.MFRotation, this.MFRotation.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFRotation[originalLength + i] = newValue[i];
        }
    }

    public MFRotation append(SFRotation newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFRotation append(MFRotation newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 4) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 4 for MFRotationinsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFRotation.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFRotation array length=" + this.MFRotation.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFRotation.length - index;
        this.MFRotation = Arrays.copyOf(this.MFRotation, this.MFRotation.length + 4);
        System.arraycopy(this.MFRotation, index, this.MFRotation, index + 4, sliceLength);
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFRotation[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFRotation.length;
    }

    @Override
    public void clear() {
        this.MFRotation = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFRotation.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFRotation.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFRotation array length=" + this.MFRotation.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFRotation.length - (index + 1) * 4;
        System.arraycopy(this.MFRotation, (index + 1) * 4, this.MFRotation, index * 4, offsetLength);
        this.MFRotation = Arrays.copyOfRange(this.MFRotation, 0, this.MFRotation.length - 4);
    }

    public float[] toFloatArray() {
        return this.MFRotation;
    }

    public MFRotation setValue(MFRotation newValue) {
        if (newValue == null) {
            this.MFRotation = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFRotation = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFRotation, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFRotation(DEFAULT_VALUE).matches()) {
                System.out.println("MFRotation.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFRotation initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

