/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFMatrix4f;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix4;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3f;

public class MFMatrix4f
extends X3DConcreteField
implements org.web3d.x3d.sai.MFMatrix4f {
    public static final String NAME = "MFMatrix4f";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 16;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFMatrix4f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFMatrix4f comparisonMFMatrix4f) {
        return this.getPrimitiveValue() == comparisonMFMatrix4f.getPrimitiveValue();
    }

    public final String validate() {
        MFMatrix4f tempHold = new MFMatrix4f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFMatrix4f validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix4f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix4f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix4f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFMatrix4f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFMatrix4f.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 16 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 16 when declaring new MFMatrix4f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFMatrix4f = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFMatrix4f[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFMatrix4f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFMatrix4f(MFMatrix4f newValue) {
        if (newValue == null) {
            this.MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFMatrix4f = newValue.getPrimitiveValue();
    }

    public MFMatrix4f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 16 != 0) {
            String errorNotice = "Illegal MFMatrix4f newValue array length=" + newValue.length + ", must be multiple of 16 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFMatrix4f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix4f = newValue;
    }

    public MFMatrix4f(SFMatrix4f newValue) {
        this.setValue(newValue);
    }

    public MFMatrix4f setValue(SFMatrix4f newValue) {
        this.setValue(newValue.getPrimitiveValue());
        return this;
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public float[] getPrimitiveValue() {
        return this.MFMatrix4f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFMatrix4f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFMatrix4f[i]));
            } else {
                result.append(this.MFMatrix4f[i]);
            }
            if (i >= this.MFMatrix4f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public MFMatrix4f setValue(float[] newValue) {
        if (newValue == null) {
            this.MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length % 16 != 0) {
            String errorNotice = "Illegal array newValue=" + String.valueOf(newValue) + " must have base length 16 for setValue() on MFMatrix4f";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix4f = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.MFMatrix4f = SFMatrix4f.DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "Illegal MFMatrix4f[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.MFMatrix4f[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale, SFRotation scaleOrientation, SFVec3f center) {
    }

    @Override
    public void getTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale) {
    }

    @Override
    public Matrix4 inverse() {
        return null;
    }

    @Override
    public Matrix4 transpose() {
        return null;
    }

    @Override
    public Matrix4 multiplyLeft(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRight(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRowVector(SFVec3f vector3f) {
        return null;
    }

    @Override
    public Matrix4 multiplyColVector(SFVec3f vector3f) {
        return null;
    }

    public float[] toFloatArray() {
        return this.MFMatrix4f;
    }

    public MFMatrix4f setValue(MFMatrix4f newValue) {
        if (newValue == null) {
            this.MFMatrix4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFMatrix4f = newValue.getPrimitiveValue();
        return this;
    }

    public MFMatrix4f multiply(float scaleFactor) {
        int i = 0;
        while (i < this.MFMatrix4f.length) {
            int n = i++;
            this.MFMatrix4f[n] = this.MFMatrix4f[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFMatrix4f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFMatrix4f(DEFAULT_VALUE).matches()) {
                System.out.println("MFMatrix4f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFMatrix4f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

