/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFMatrix3f;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix3;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3f;

public class MFMatrix3f
extends X3DConcreteField
implements org.web3d.x3d.sai.MFMatrix3f {
    public static final String NAME = "MFMatrix3f";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 9;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFMatrix3f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFMatrix3f comparisonMFMatrix3f) {
        return this.getPrimitiveValue() == comparisonMFMatrix3f.getPrimitiveValue();
    }

    public final String validate() {
        MFMatrix3f tempHold = new MFMatrix3f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFMatrix3f validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix3f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix3f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix3f array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFMatrix3f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFMatrix3f.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix3f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 9 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 9 when declaring new MFMatrix3f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFMatrix3f = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFMatrix3f[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFMatrix3f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFMatrix3f(MFMatrix3f newValue) {
        if (newValue == null) {
            this.MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFMatrix3f = newValue.getPrimitiveValue();
    }

    public MFMatrix3f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 9 != 0) {
            String errorNotice = "Illegal MFMatrix3f newValue array length=" + newValue.length + ", must be multiple of 9 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFMatrix3f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix3f = newValue;
    }

    public MFMatrix3f(SFMatrix3f newValue) {
        this.setValue(newValue);
    }

    public MFMatrix3f setValue(SFMatrix3f newValue) {
        this.setValue(newValue.getPrimitiveValue());
        return this;
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public float[] getPrimitiveValue() {
        return this.MFMatrix3f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFMatrix3f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFMatrix3f[i]));
            } else {
                result.append(this.MFMatrix3f[i]);
            }
            if (i >= this.MFMatrix3f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public MFMatrix3f setValue(float[] newValue) {
        if (newValue == null) {
            this.MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length % 9 != 0) {
            String errorNotice = "Illegal array newValue=" + String.valueOf(newValue) + " must have base length 9 for setValue() on MFMatrix3f";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix3f = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.MFMatrix3f = SFMatrix3f.DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "Illegal MFMatrix3f[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.MFMatrix3f[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale, SFRotation scaleOrientation, SFVec3f center) {
    }

    @Override
    public void getTransform(SFVec3f translation, SFRotation rotation, SFVec3f scale) {
    }

    @Override
    public Matrix3 inverse() {
        return null;
    }

    @Override
    public Matrix3 transpose() {
        return null;
    }

    @Override
    public Matrix3 multiplyLeft(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRight(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRowVector(SFVec3f vector3f) {
        return null;
    }

    @Override
    public Matrix3 multiplyColVector(SFVec3f vector3f) {
        return null;
    }

    public float[] toFloatArray() {
        return this.MFMatrix3f;
    }

    public MFMatrix3f setValue(MFMatrix3f newValue) {
        if (newValue == null) {
            this.MFMatrix3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFMatrix3f = newValue.getPrimitiveValue();
        return this;
    }

    public MFMatrix3f multiply(float scaleFactor) {
        int i = 0;
        while (i < this.MFMatrix3f.length) {
            int n = i++;
            this.MFMatrix3f[n] = this.MFMatrix3f[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFMatrix3f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFMatrix3f(DEFAULT_VALUE).matches()) {
                System.out.println("MFMatrix3f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFMatrix3f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

