/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFMatrix3d;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix3;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3d;

public class MFMatrix3d
extends X3DConcreteField
implements org.web3d.x3d.sai.MFMatrix3d {
    public static final String NAME = "MFMatrix3d";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 9;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFMatrix3d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFMatrix3d comparisonMFMatrix3d) {
        return this.getPrimitiveValue() == comparisonMFMatrix3d.getPrimitiveValue();
    }

    public final String validate() {
        MFMatrix3d tempHold = new MFMatrix3d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFMatrix3d validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix3d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix3d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix3d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFMatrix3d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFMatrix3d.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFMatrix3d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 9 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 9 when declaring new MFMatrix3d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFMatrix3d = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFMatrix3d[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFMatrix3d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFMatrix3d(MFMatrix3d newValue) {
        if (newValue == null) {
            this.MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFMatrix3d = newValue.getPrimitiveValue();
    }

    public MFMatrix3d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 9 != 0) {
            String errorNotice = "Illegal MFMatrix3d newValue array length=" + newValue.length + ", must be multiple of 9 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFMatrix3d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix3d = newValue;
    }

    public MFMatrix3d(SFMatrix3d newValue) {
        this.setValue(newValue);
    }

    public MFMatrix3d setValue(SFMatrix3d newValue) {
        this.setValue(newValue.getPrimitiveValue());
        return this;
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public double[] getPrimitiveValue() {
        return this.MFMatrix3d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFMatrix3d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFMatrix3d[i]));
            } else {
                result.append(this.MFMatrix3d[i]);
            }
            if (i >= this.MFMatrix3d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public MFMatrix3d setValue(double[] newValue) {
        if (newValue == null) {
            this.MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length % 9 != 0) {
            String errorNotice = "Illegal array newValue=" + String.valueOf(newValue) + " must have base length 9 for setValue() on MFMatrix3d";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix3d = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.MFMatrix3d = SFMatrix3d.DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "Illegal MFMatrix3d[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return (float)this.MFMatrix3d[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale, SFRotation scaleOrientation, SFVec3d center) {
    }

    @Override
    public void getTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale) {
    }

    @Override
    public Matrix3 inverse() {
        return null;
    }

    @Override
    public Matrix3 transpose() {
        return null;
    }

    @Override
    public Matrix3 multiplyLeft(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRight(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRowVector(SFVec3d vector3d) {
        return null;
    }

    @Override
    public Matrix3 multiplyColVector(SFVec3d vector3d) {
        return null;
    }

    public double[] toDoubleArray() {
        return this.MFMatrix3d;
    }

    public MFMatrix3d setValue(MFMatrix3d newValue) {
        if (newValue == null) {
            this.MFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFMatrix3d = newValue.getPrimitiveValue();
        return this;
    }

    public MFMatrix3d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFMatrix3d.length) {
            int n = i++;
            this.MFMatrix3d[n] = this.MFMatrix3d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFMatrix3d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFMatrix3d(DEFAULT_VALUE).matches()) {
                System.out.println("MFMatrix3d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFMatrix3d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

