/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFImage;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFImage
extends X3DConcreteField
implements org.web3d.x3d.sai.MFImage {
    public static final String NAME = "MFImage";
    public static final int[] DEFAULT_VALUE = new int[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private int[] MFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFImage() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFImage comparisonMFImage) {
        return this.getPrimitiveValue() == comparisonMFImage.getPrimitiveValue();
    }

    public final String validate() {
        MFImage tempHold = new MFImage(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFImage validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFImage PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFImage array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFImage array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFImage setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFImage.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFImage(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            this.MFImage = new int[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFImage[i] = newValues[i].startsWith("0x") ? Integer.decode(newValues[i]) : Integer.parseInt(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFImage(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFImage(MFImage newValue) {
        if (newValue == null) {
            this.MFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFImage = newValue.getPrimitiveValue();
    }

    public MFImage(int[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFImage = newValue;
    }

    public MFImage(SFImage newValue) {
        this.setValue(newValue);
    }

    public static String toString(int[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public int[] getPrimitiveValue() {
        return this.MFImage;
    }

    public String toString() {
        if (ConfigurationProperties.isSFImagePixelOutputHexadecimal()) {
            return this.toStringHexadecimal();
        }
        return this.toStringDecimal();
    }

    public String toStringDecimal() {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.MFImage.length; ++i) {
            resultBuilder.append(this.MFImage[i]);
            if (i >= this.MFImage.length - 1) continue;
            resultBuilder.append(" ");
        }
        return resultBuilder.toString();
    }

    public String toStringHexadecimal() {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.MFImage.length; ++i) {
            if (i < 3) {
                resultBuilder.append(this.MFImage[i]);
            } else {
                resultBuilder.append("0x").append(Integer.toHexString(this.MFImage[i]));
            }
            if (i >= this.MFImage.length - 1) continue;
            resultBuilder.append(" ");
        }
        return resultBuilder.toString();
    }

    @Override
    public int getWidth(int imageIndex) {
        return 0;
    }

    @Override
    public int getHeight(int imageIndex) {
        return 0;
    }

    @Override
    public int getNumberComponents(int imageIndex) {
        return 0;
    }

    @Override
    public void getPixels(int imageIndex, int[] pixels) {
    }

    @Override
    public WritableRenderedImage getImage(int imageIndex) {
        return null;
    }

    @Override
    public void setImage(int imageIndex, RenderedImage image) {
    }

    @Override
    public void setSubImage(int imageIndex, RenderedImage image, int sourceWidth, int sourceHeight, int sourceXOffset, int sourceYOffset, int destinationXOffset, int destinationYOffset) {
    }

    @Override
    public void set1Value(int imageIndex, int newValue) {
    }

    @Override
    public void set1Value(int imageIndex, int width, int height, int components, int[] pixels) {
    }

    @Override
    public void setValue(int[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        SFImage newSFImage = new SFImage(newValue);
        this.MFImage = newValue;
    }

    public void setValue(SFImage newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        this.MFImage = newValue.getPrimitiveValue();
    }

    @Override
    public void setImage(RenderedImage[] image) {
    }

    @Override
    public void append(RenderedImage[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
    }

    @Override
    public void insertValue(int index, RenderedImage newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFImage.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFImage array length=" + this.MFImage.length;
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
    }

    @Override
    public void clear() {
        this.MFImage = new int[0];
    }

    @Override
    public int size() {
        return this.MFImage.length;
    }

    public MFImage setValue(MFImage newValue) {
        if (newValue == null) {
            this.MFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFImage = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFImage, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFImage(DEFAULT_VALUE).matches()) {
                System.out.println("MFImage.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFImage initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

