/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFFloat
extends X3DConcreteField
implements org.web3d.x3d.sai.MFFloat {
    public static final String NAME = "MFFloat";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFFloat() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFFloat comparisonMFFloat) {
        return this.getPrimitiveValue() == comparisonMFFloat.getPrimitiveValue();
    }

    public final String validate() {
        MFFloat tempHold = new MFFloat(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFFloat validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFFloat PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFFloat array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFFloat array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFFloat setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFFloat.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFFloat(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            this.MFFloat = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFFloat[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFFloat(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFFloat(float newValue) {
        this.setValue(new SFFloat(newValue));
    }

    public MFFloat(SFFloat newValue) {
        if (newValue == null) {
            this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFFloat = new float[1];
        this.MFFloat[0] = newValue.getValue();
    }

    public MFFloat(MFFloat newValue) {
        if (newValue == null) {
            this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFFloat = newValue.getPrimitiveValue();
    }

    public MFFloat(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFFloat = newValue;
    }

    public MFFloat(double newValue) {
        this.setValue(new SFFloat(newValue));
    }

    public MFFloat(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFFloat;
    }

    public float[] getPrimitiveValue() {
        return this.MFFloat;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFFloat.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFFloat[i]));
            } else {
                result.append(this.MFFloat[i]);
            }
            if (i >= this.MFFloat.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public float get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFFloat.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFFloat.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFFloat array length=" + this.MFFloat.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFFloat[index];
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFFloat = Arrays.copyOf(newValue, size);
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFFloat = new float[newValue.length];
        this.MFFloat = newValue;
    }

    public MFFloat setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFFloat = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFFloat[i] = (float)newValue[i];
        }
        return this;
    }

    public void setValue(float newValue) {
        this.MFFloat = new float[1];
        this.MFFloat[0] = newValue;
    }

    public MFFloat setValue(SFFloat newValue) {
        if (newValue == null) {
            this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFFloat = new float[1];
        this.MFFloat[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, float newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFFloat.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFFloat.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFFloat array length=" + this.MFFloat.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFFloat[index] = newValue;
    }

    @Override
    public void append(float newValue) {
        this.MFFloat = Arrays.copyOf(this.MFFloat, this.MFFloat.length + 1);
        this.MFFloat[this.MFFloat.length - 1] = newValue;
    }

    public void append(float[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFFloat.length;
        this.MFFloat = Arrays.copyOf(this.MFFloat, this.MFFloat.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFFloat[originalLength + i] = newValue[i];
        }
    }

    public MFFloat append(SFFloat newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFFloat append(MFFloat newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFFloat.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFFloat array length=" + this.MFFloat.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFFloat.length - index;
        this.MFFloat = Arrays.copyOf(this.MFFloat, this.MFFloat.length + 1);
        System.arraycopy(this.MFFloat, index, this.MFFloat, index + 1, sliceLength);
        this.MFFloat[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFFloat.length;
    }

    @Override
    public void clear() {
        this.MFFloat = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFFloat.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFFloat.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFFloat array length=" + this.MFFloat.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFFloat.length - (index + 1) * 1;
        System.arraycopy(this.MFFloat, (index + 1) * 1, this.MFFloat, index * 1, offsetLength);
        this.MFFloat = Arrays.copyOfRange(this.MFFloat, 0, this.MFFloat.length - 1);
    }

    public float[] toFloatArray() {
        return this.MFFloat;
    }

    public MFFloat setValue(MFFloat newValue) {
        if (newValue == null) {
            this.MFFloat = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFFloat = newValue.getPrimitiveValue();
        return this;
    }

    public MFFloat multiply(float scaleFactor) {
        int i = 0;
        while (i < this.MFFloat.length) {
            int n = i++;
            this.MFFloat[n] = this.MFFloat[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFFloat, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFFloat(DEFAULT_VALUE).matches()) {
                System.out.println("MFFloat.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFFloat initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

