/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFColorRGBA;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFColorRGBA
extends X3DConcreteField
implements org.web3d.x3d.sai.MFColorRGBA {
    public static final String NAME = "MFColorRGBA";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFColorRGBA() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFColorRGBA comparisonMFColorRGBA) {
        return this.getPrimitiveValue() == comparisonMFColorRGBA.getPrimitiveValue();
    }

    public final String validate() {
        MFColorRGBA tempHold = new MFColorRGBA(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFColorRGBA validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "[error] Regular expression (regex) failure, new MFColorRGBA PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFColorRGBA array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFColorRGBA array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFColorRGBA setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFColorRGBA.matches(newValue)) {
            String errorNotice = "[error] Regular expression (regex) failure, new MFColorRGBA(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 4 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 4 when declaring new MFColorRGBA(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFColorRGBA = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFColorRGBA[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFColorRGBA(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFColorRGBA(MFColorRGBA newValue) {
        if (newValue == null) {
            this.MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFColorRGBA = newValue.getPrimitiveValue();
    }

    public MFColorRGBA(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 4 != 0) {
            String errorNotice = "Illegal MFColorRGBA newValue array length=" + newValue.length + ", must be multiple of 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFColorRGBA.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFColorRGBA = newValue;
    }

    public MFColorRGBA set1Value(int index, int hexColorValue, float alpha) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColorRGBA.length / 4) {
            String errorNotice = "Provided array index=" + index + " (for 4-tuples) must be less than MFColor array length=" + this.MFColorRGBA.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        float red = (float)(hexColorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColorValue & 0xFF) / 255.0f;
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "Illegal SFColorRGBA value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFColorRGBA[4 * index + 0] = red;
        this.MFColorRGBA[4 * index + 1] = green;
        this.MFColorRGBA[4 * index + 2] = blue;
        this.MFColorRGBA[4 * index + 3] = alpha;
        return this;
    }

    public MFColorRGBA complementRGB() {
        int index = 0;
        while (index + 3 < this.MFColorRGBA.length) {
            this.MFColorRGBA[4 * index + 0] = 1.0f - this.MFColorRGBA[4 * index + 0];
            this.MFColorRGBA[4 * index + 1] = 1.0f - this.MFColorRGBA[4 * index + 1];
            this.MFColorRGBA[4 * index + 2] = 1.0f - this.MFColorRGBA[4 * index + 2];
            index += 4;
        }
        return this;
    }

    public MFColorRGBA complementAlpha() {
        int index = 0;
        while (index + 3 < this.MFColorRGBA.length) {
            this.MFColorRGBA[4 * index + 3] = 1.0f - this.MFColorRGBA[4 * index + 3];
            index += 4;
        }
        return this;
    }

    public MFColorRGBA normalizeClip() {
        int index = 0;
        while (index + 3 < this.MFColorRGBA.length) {
            if (this.MFColorRGBA[4 * index + 0] < 0.0f) {
                this.MFColorRGBA[4 * index + 0] = 0.0f;
            }
            if (this.MFColorRGBA[4 * index + 1] < 0.0f) {
                this.MFColorRGBA[4 * index + 1] = 0.0f;
            }
            if (this.MFColorRGBA[4 * index + 2] < 0.0f) {
                this.MFColorRGBA[4 * index + 2] = 0.0f;
            }
            if (this.MFColorRGBA[4 * index + 3] < 0.0f) {
                this.MFColorRGBA[4 * index + 3] = 0.0f;
            }
            if (this.MFColorRGBA[4 * index + 0] > 1.0f) {
                this.MFColorRGBA[4 * index + 0] = 1.0f;
            }
            if (this.MFColorRGBA[4 * index + 1] > 1.0f) {
                this.MFColorRGBA[4 * index + 1] = 1.0f;
            }
            if (this.MFColorRGBA[4 * index + 2] > 1.0f) {
                this.MFColorRGBA[4 * index + 2] = 1.0f;
            }
            if (this.MFColorRGBA[4 * index + 3] > 1.0f) {
                this.MFColorRGBA[4 * index + 3] = 1.0f;
            }
            index += 4;
        }
        return this;
    }

    public MFColorRGBA(SFColorRGBA newValue) {
        this.setValue(newValue);
    }

    public MFColorRGBA(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFColorRGBA;
    }

    public float[] getPrimitiveValue() {
        return this.MFColorRGBA;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFColorRGBA.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFColorRGBA[i]));
            } else {
                result.append(this.MFColorRGBA[i]);
            }
            if (i >= this.MFColorRGBA.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, float[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColorRGBA.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColorRGBA.length / 4) {
            String errorNotice = "Provided array index=" + index + " must be less than MFColorRGBA array length=" + this.MFColorRGBA.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFColorRGBA, index * 4, index * 4 + 4 - 1);
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFColorRGBA = Arrays.copyOf(newValue, size);
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFColorRGBA = new float[newValue.length];
        this.MFColorRGBA = newValue;
    }

    public MFColorRGBA setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFColorRGBA = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFColorRGBA[i] = (float)newValue[i];
        }
        return this;
    }

    public MFColorRGBA setValue(SFColorRGBA newValue) {
        if (newValue == null) {
            this.MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toFloatArray());
        return this;
    }

    @Override
    public void set1Value(int index, float[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColorRGBA.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "Illegal MFColorRGBA newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFColorRGBA.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFColorRGBA.length / 4) {
            String errorNotice = "Provided array index=" + index + " must be less than MFColorRGBA array length=" + this.MFColorRGBA.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFColorRGBA[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public void append(float[] newValue) {
        if (newValue.length % 4 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFColorRGBA(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFColorRGBA.length;
        this.MFColorRGBA = Arrays.copyOf(this.MFColorRGBA, this.MFColorRGBA.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFColorRGBA[originalLength + i] = newValue[i];
        }
    }

    public MFColorRGBA append(SFColorRGBA newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFColorRGBA append(MFColorRGBA newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 4) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 4 for MFColorRGBAinsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFColorRGBA.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFColorRGBA array length=" + this.MFColorRGBA.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFColorRGBA.length - index;
        this.MFColorRGBA = Arrays.copyOf(this.MFColorRGBA, this.MFColorRGBA.length + 4);
        System.arraycopy(this.MFColorRGBA, index, this.MFColorRGBA, index + 4, sliceLength);
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFColorRGBA[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFColorRGBA.length;
    }

    @Override
    public void clear() {
        this.MFColorRGBA = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColorRGBA.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColorRGBA.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFColorRGBA array length=" + this.MFColorRGBA.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFColorRGBA.length - (index + 1) * 4;
        System.arraycopy(this.MFColorRGBA, (index + 1) * 4, this.MFColorRGBA, index * 4, offsetLength);
        this.MFColorRGBA = Arrays.copyOfRange(this.MFColorRGBA, 0, this.MFColorRGBA.length - 4);
    }

    @Override
    public void getValue(float[][] valueDestination) {
    }

    @Override
    public void setValue(int size, float[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public float[] toFloatArray() {
        return this.MFColorRGBA;
    }

    public MFColorRGBA setValue(MFColorRGBA newValue) {
        if (newValue == null) {
            this.MFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFColorRGBA = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFColorRGBA, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFColorRGBA(DEFAULT_VALUE).matches()) {
                System.out.println("MFColorRGBA.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFColorRGBA initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

