/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.VolumeRendering;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode;
import org.web3d.x3d.sai.VolumeRendering.X3DVolumeRenderStyleNode;

public class IsoSurfaceVolumeData
extends X3DConcreteNode
implements org.web3d.x3d.sai.VolumeRendering.IsoSurfaceVolumeData {
    private ArrayList<String> commentsList;
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private float contourStepSize;
    private float[] dimensions;
    private X3DTexture3DNode gradients;
    private ProtoInstance gradientsProtoInstance;
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private ArrayList<X3DNode> renderStyle = new ArrayList();
    private float surfaceTolerance;
    private ArrayList<Float> surfaceValues = new ArrayList();
    private boolean visible;
    private X3DTexture3DNode voxels;
    private ProtoInstance voxelsProtoInstance;
    public static final String NAME = "IsoSurfaceVolumeData";
    public static final String COMPONENT = "VolumeRendering";
    public static final int LEVEL = 2;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final float CONTOURSTEPSIZE_DEFAULT_VALUE = 0.0f;
    public static final float[] DIMENSIONS_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final X3DTexture3DNode GRADIENTS_DEFAULT_VALUE = null;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float SURFACETOLERANCE_DEFAULT_VALUE = 0.0f;
    public static final ArrayList<Float> SURFACEVALUES_DEFAULT_VALUE = new ArrayList<Float>(Arrays.asList(new Float[0]));
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final X3DTexture3DNode VOXELS_DEFAULT_VALUE = null;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_CONTOURSTEPSIZE = "contourStepSize";
    public static final String toField_CONTOURSTEPSIZE = "contourStepSize";
    public static final String fromField_DIMENSIONS = "dimensions";
    public static final String toField_DIMENSIONS = "dimensions";
    public static final String fromField_GRADIENTS = "gradients";
    public static final String toField_GRADIENTS = "gradients";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_RENDERSTYLE = "renderStyle";
    public static final String toField_RENDERSTYLE = "renderStyle";
    public static final String fromField_SURFACETOLERANCE = "surfaceTolerance";
    public static final String toField_SURFACETOLERANCE = "surfaceTolerance";
    public static final String fromField_SURFACEVALUES = "surfaceValues";
    public static final String toField_SURFACEVALUES = "surfaceValues";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    public static final String fromField_VOXELS = "voxels";
    public static final String toField_VOXELS = "voxels";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "bboxCenter" -> "SFVec3f";
            case "bboxDisplay" -> "SFBool";
            case "bboxSize" -> "SFVec3f";
            case "contourStepSize" -> "SFFloat";
            case "dimensions" -> "SFVec3f";
            case "gradients" -> "SFNode";
            case fromField_IS -> "SFNode";
            case "metadata" -> "SFNode";
            case "renderStyle" -> "MFNode";
            case "surfaceTolerance" -> "SFFloat";
            case "surfaceValues" -> "MFFloat";
            case "visible" -> "SFBool";
            case "voxels" -> "SFNode";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "bboxCenter" -> "initializeOnly";
            case "bboxDisplay" -> "inputOutput";
            case "bboxSize" -> "initializeOnly";
            case "contourStepSize" -> "inputOutput";
            case "dimensions" -> "inputOutput";
            case "gradients" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "renderStyle" -> "inputOutput";
            case "surfaceTolerance" -> "inputOutput";
            case "surfaceValues" -> "inputOutput";
            case "visible" -> "inputOutput";
            case "voxels" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public IsoSurfaceVolumeData() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.bboxCenter = BBOXCENTER_DEFAULT_VALUE;
        this.bboxDisplay = false;
        this.bboxSize = BBOXSIZE_DEFAULT_VALUE;
        this.contourStepSize = 0.0f;
        this.dimensions = DIMENSIONS_DEFAULT_VALUE;
        this.gradients = null;
        this.gradientsProtoInstance = null;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.renderStyle = new ArrayList();
        this.surfaceTolerance = 0.0f;
        this.surfaceValues = new ArrayList();
        this.visible = true;
        this.voxels = null;
        this.voxelsProtoInstance = null;
        this.commentsList = new ArrayList();
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public IsoSurfaceVolumeData setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public IsoSurfaceVolumeData setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public IsoSurfaceVolumeData setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public IsoSurfaceVolumeData setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public IsoSurfaceVolumeData setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public IsoSurfaceVolumeData setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public IsoSurfaceVolumeData setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public float getContourStepSize() {
        return this.contourStepSize;
    }

    @Override
    public IsoSurfaceVolumeData setContourStepSize(float newValue) {
        this.contourStepSize = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setContourStepSize(SFFloat newValue) {
        this.setContourStepSize(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setContourStepSize(double newValue) {
        return this.setContourStepSize((float)newValue);
    }

    @Override
    public float[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public IsoSurfaceVolumeData setDimensions(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData dimensions newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] <= 0.0f || newValue[1] <= 0.0f || newValue[2] <= 0.0f) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData dimensions newValue=" + String.valueOf(newValue) + " has component value less than (or equal to) restriction minExclusive=0");
        }
        this.dimensions = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setDimensions(SFVec3f newValue) {
        this.setDimensions(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setDimensions(float x, float y, float z) {
        this.setDimensions(new float[]{x, y, z});
        return this;
    }

    public IsoSurfaceVolumeData setDimensions(double x, double y, double z) {
        return this.setDimensions(new SFVec3f(x, y, z));
    }

    public IsoSurfaceVolumeData setDimensions(double[] newArray) {
        return this.setDimensions(new SFVec3f(newArray));
    }

    @Override
    public X3DTexture3DNode getGradients() {
        return this.gradients;
    }

    @Override
    public IsoSurfaceVolumeData setGradients(X3DTexture3DNode newValue) {
        this.gradients = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.gradients)).setParent(this);
        }
        if (this.gradientsProtoInstance != null) {
            this.gradientsProtoInstance.setParent(null);
            this.gradientsProtoInstance = null;
        }
        return this;
    }

    public IsoSurfaceVolumeData clearGradients() {
        ((X3DConcreteElement)((Object)this.gradients)).clearParent();
        this.gradients = null;
        return this;
    }

    public IsoSurfaceVolumeData setGradients(ProtoInstance newValue) {
        if (this.gradientsProtoInstance != null) {
            this.gradientsProtoInstance.setParent(null);
        }
        this.gradientsProtoInstance = newValue;
        if (newValue != null) {
            this.gradientsProtoInstance.setParent(this);
            this.gradientsProtoInstance.setContainerField("gradients");
        }
        if (this.gradients != null) {
            ((X3DConcreteElement)((Object)this.gradients)).setParent(null);
            this.gradients = null;
        }
        return this;
    }

    private ProtoInstance getGradientsProtoInstance() {
        return this.gradientsProtoInstance;
    }

    public boolean hasGradients() {
        return this.gradients != null || this.gradientsProtoInstance != null;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public IsoSurfaceVolumeData setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public IsoSurfaceVolumeData clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public IsoSurfaceVolumeData setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public IsoSurfaceVolumeData clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public IsoSurfaceVolumeData setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public X3DNode[] getRenderStyle() {
        X3DNode[] valuesArray = new X3DNode[this.renderStyle.size()];
        int i = 0;
        for (X3DNode arrayElement : this.renderStyle) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getRenderStyleList() {
        return this.renderStyle;
    }

    @Override
    public IsoSurfaceVolumeData setRenderStyle(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return this;
        }
        this.clearRenderStyle();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.renderStyle.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public IsoSurfaceVolumeData setRenderStyle(ArrayList<X3DVolumeRenderStyleNode> newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearRenderStyle();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setRenderStyle(newArray);
        }
        for (X3DVolumeRenderStyleNode element : newValue) {
            this.renderStyle.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public IsoSurfaceVolumeData addRenderStyle(X3DNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.renderStyle.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    public IsoSurfaceVolumeData addRenderStyle(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.renderStyle.add(newValue);
        newValue.setParent(this);
        return this;
    }

    @Override
    public void addRenderStyle(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.renderStyle.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("renderStyle");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setRenderStyle(X3DNode newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.renderStyle) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + String.valueOf(newValue));
        }
        this.clearRenderStyle();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.renderStyle.add(newValue);
    }

    public IsoSurfaceVolumeData clearRenderStyle() {
        for (X3DNode element : this.renderStyle) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.renderStyle.clear();
        return this;
    }

    public boolean hasRenderStyle() {
        return !this.renderStyle.isEmpty();
    }

    @Override
    public float getSurfaceTolerance() {
        return this.surfaceTolerance;
    }

    @Override
    public IsoSurfaceVolumeData setSurfaceTolerance(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData surfaceTolerance newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.surfaceTolerance = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceTolerance(SFFloat newValue) {
        this.setSurfaceTolerance(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceTolerance(double newValue) {
        return this.setSurfaceTolerance((float)newValue);
    }

    @Override
    public float[] getSurfaceValues() {
        float[] valuesArray = new float[this.surfaceValues.size()];
        int i = 0;
        for (Float arrayElement : this.surfaceValues) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getSurfaceValuesList() {
        return this.surfaceValues;
    }

    public String getSurfaceValuesString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.surfaceValues) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public IsoSurfaceVolumeData setSurfaceValues(float[] newValue) {
        if (newValue == null) {
            this.clearSurfaceValues();
            return this;
        }
        this.clearSurfaceValues();
        for (int i = 0; i < newValue.length; ++i) {
            this.surfaceValues.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceValues(MFFloat newValue) {
        if (newValue == null) {
            this.clearSurfaceValues();
            return this;
        }
        this.setSurfaceValues(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceValues(ArrayList<Float> newValue) {
        if (newValue == null) {
            this.clearSurfaceValues();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearSurfaceValues();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setSurfaceValues(newArray);
        }
        return this;
    }

    public IsoSurfaceVolumeData clearSurfaceValues() {
        this.surfaceValues.clear();
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceValues(int[] newValue) {
        if (newValue == null) {
            this.clearSurfaceValues();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setSurfaceValues(holdArray);
        return this;
    }

    public IsoSurfaceVolumeData addSurfaceValues(float newValue) {
        this.surfaceValues.add(Float.valueOf(newValue));
        return this;
    }

    public IsoSurfaceVolumeData addSurfaceValues(SFFloat newValue) {
        if (newValue == null) {
            return this;
        }
        this.surfaceValues.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public IsoSurfaceVolumeData setSurfaceValues(double[] newArray) {
        return this.setSurfaceValues(new MFFloat(newArray));
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public IsoSurfaceVolumeData setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public IsoSurfaceVolumeData setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DTexture3DNode getVoxels() {
        return this.voxels;
    }

    @Override
    public IsoSurfaceVolumeData setVoxels(X3DTexture3DNode newValue) {
        this.voxels = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(this);
        }
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
            this.voxelsProtoInstance = null;
        }
        return this;
    }

    public IsoSurfaceVolumeData clearVoxels() {
        ((X3DConcreteElement)((Object)this.voxels)).clearParent();
        this.voxels = null;
        return this;
    }

    public IsoSurfaceVolumeData setVoxels(ProtoInstance newValue) {
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
        }
        this.voxelsProtoInstance = newValue;
        if (newValue != null) {
            this.voxelsProtoInstance.setParent(this);
            this.voxelsProtoInstance.setContainerField("voxels");
        }
        if (this.voxels != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(null);
            this.voxels = null;
        }
        return this;
    }

    private ProtoInstance getVoxelsProtoInstance() {
        return this.voxelsProtoInstance;
    }

    public boolean hasVoxels() {
        return this.voxels != null || this.voxelsProtoInstance != null;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final IsoSurfaceVolumeData setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public IsoSurfaceVolumeData setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final IsoSurfaceVolumeData setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IsoSurfaceVolumeData USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public IsoSurfaceVolumeData setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final IsoSurfaceVolumeData setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public IsoSurfaceVolumeData setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final IsoSurfaceVolumeData setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public IsoSurfaceVolumeData setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final IsoSurfaceVolumeData setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public IsoSurfaceVolumeData setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public IsoSurfaceVolumeData setUSE(IsoSurfaceVolumeData DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on IsoSurfaceVolumeData that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public IsoSurfaceVolumeData(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public IsoSurfaceVolumeData addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public IsoSurfaceVolumeData addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public IsoSurfaceVolumeData addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.gradients != null || this.gradientsProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.renderStyle.isEmpty() || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<IsoSurfaceVolumeData");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(!this.getBboxDisplay() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getContourStepSize() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" contourStepSize='").append(SFFloat.toString(this.getContourStepSize())).append("'");
            }
            if (!(Arrays.equals(this.getDimensions(), DIMENSIONS_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" dimensions='").append(SFVec3f.toString(this.getDimensions())).append("'");
            }
            if (!(this.getHtmlID().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getCssStyle().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getSurfaceTolerance() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" surfaceTolerance='").append(SFFloat.toString(this.getSurfaceTolerance())).append("'");
            }
            if (!(this.getSurfaceValues().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" surfaceValues='").append(MFFloat.toString(this.getSurfaceValues())).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.gradients != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.gradients)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.gradientsProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.gradientsProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.renderStyle) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.voxels != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.voxels)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.voxelsProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</IsoSurfaceVolumeData>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.gradients != null || this.gradientsProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.renderStyle.isEmpty() || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toString(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("contourStepSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("contourStepSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getContourStepSize() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("contourStepSize ").append(SFFloat.toString(this.getContourStepSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("dimensions")) continue;
                        stringClassicVRML.append(indentCharacter).append("dimensions").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getDimensions(), DIMENSIONS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("dimensions ").append(SFVec3f.toString(this.getDimensions())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("surfaceTolerance")) continue;
                        stringClassicVRML.append(indentCharacter).append("surfaceTolerance").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSurfaceTolerance() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("surfaceTolerance ").append(SFFloat.toString(this.getSurfaceTolerance())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("surfaceValues")) continue;
                        stringClassicVRML.append(indentCharacter).append("surfaceValues").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSurfaceValues().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("surfaceValues ").append("[ ").append(MFFloat.toString(this.getSurfaceValues())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.gradients != null) {
                stringClassicVRML.append(indentCharacter).append("gradients").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.gradients)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.gradientsProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("gradients").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.gradientsProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.renderStyle.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("renderStyle").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.renderStyle) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
            if (this.voxels != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.voxels)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.voxelsProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.gradients != null && (referenceElement = ((X3DConcreteElement)((Object)this.gradients)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.gradientsProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.gradientsProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        for (X3DNode element : this.renderStyle) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.voxels != null && (referenceElement = ((X3DConcreteElement)((Object)this.voxels)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.voxelsProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.voxelsProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.gradients != null && (referenceNode = ((X3DConcreteElement)((Object)this.gradients)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.gradientsProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.gradientsProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        for (X3DNode element : this.renderStyle) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.voxels != null && (referenceNode = ((X3DConcreteElement)((Object)this.voxels)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.voxelsProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.voxelsProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice9;
        this.validationResult = new StringBuilder();
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setContourStepSize(this.getContourStepSize());
        this.setDimensions(this.getDimensions());
        this.setSurfaceTolerance(this.getSurfaceTolerance());
        this.setSurfaceValues(this.getSurfaceValues());
        this.setVisible(this.getVisible());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.gradients != null) {
            this.setGradients(this.getGradients());
            ((X3DConcreteElement)((Object)this.gradients)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.gradients)).getValidationResult());
        }
        if (this.gradientsProtoInstance != null) {
            this.setGradients(this.getGradientsProtoInstance());
            ((X3DConcreteElement)this.gradientsProtoInstance).validate();
            this.validationResult.append(this.gradientsProtoInstance.getValidationResult());
        }
        if (this.gradients != null && this.gradientsProtoInstance != null) {
            String errorNotice2 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both gradients and gradientsProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice2);
            throw new InvalidProtoException(errorNotice2);
        }
        if (this.hasUSE() && this.hasGradients()) {
            String errorNotice3 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode gradients";
            this.validationResult.append(errorNotice3);
            throw new InvalidFieldValueException(errorNotice3);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice4 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice4);
            throw new InvalidFieldValueException(errorNotice4);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice5 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice5);
            throw new InvalidFieldValueException(errorNotice5);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice6 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice6);
            throw new InvalidFieldValueException(errorNotice6);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice7 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice7);
            throw new InvalidProtoException(errorNotice7);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice8 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice8);
            throw new InvalidFieldValueException(errorNotice8);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice9 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice9);
            throw new InvalidFieldValueException(errorNotice9);
        }
        for (X3DNode element : this.renderStyle) {
            try {
                ((X3DConcreteElement)((Object)element)).validate();
                this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setRenderStyle(this.getRenderStyle());
        if (this.hasUSE() && this.hasRenderStyle()) {
            errorNotice9 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained MFNode renderStyle";
            this.validationResult.append((String)errorNotice9);
            throw new InvalidFieldValueException((String)errorNotice9);
        }
        if (this.voxels != null) {
            this.setVoxels(this.getVoxels());
            ((X3DConcreteElement)((Object)this.voxels)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.voxels)).getValidationResult());
        }
        if (this.voxelsProtoInstance != null) {
            this.setVoxels(this.getVoxelsProtoInstance());
            ((X3DConcreteElement)this.voxelsProtoInstance).validate();
            this.validationResult.append(this.voxelsProtoInstance.getValidationResult());
        }
        if (this.voxels != null && this.voxelsProtoInstance != null) {
            errorNotice9 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both voxels and voxelsProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice9);
            throw new InvalidProtoException((String)errorNotice9);
        }
        if (this.hasUSE() && this.hasVoxels()) {
            errorNotice9 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode voxels";
            this.validationResult.append((String)errorNotice9);
            throw new InvalidFieldValueException((String)errorNotice9);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            errorNotice9 = "IsoSurfaceVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice9);
            throw new InvalidFieldValueException((String)errorNotice9);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice9 = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice9).append("\n");
            throw new InvalidProtoException((String)errorNotice9);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice9 = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice9).append("\n");
            throw new InvalidFieldException((String)errorNotice9);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice10 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'IsoSurfaceVolumeData' node, ensure sufficient support by adding head statement <component name='VolumeRendering' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"VolumeRendering\").setLevel(2);";
                this.validationResult.append(errorNotice10).append("\n");
                throw new InvalidFieldException(errorNotice10);
            }
        }
        return this.validationResult.toString();
    }
}

