/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.TextureProjection;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFColor;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing.X3DTexture2DNode;

public class TextureProjector
extends X3DConcreteNode
implements org.web3d.x3d.sai.TextureProjection.TextureProjector {
    private ArrayList<String> commentsList;
    private float ambientIntensity;
    private float aspectRatio;
    private float[] color;
    private String description = new String();
    private float[] direction;
    private float farDistance;
    private float fieldOfView;
    private boolean global;
    private float intensity;
    private IS IS;
    private float[] location;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float nearDistance;
    private boolean on;
    private float shadowIntensity;
    private boolean shadows;
    private X3DTexture2DNode texture;
    private ProtoInstance textureProtoInstance;
    private float[] upVector;
    public static final String NAME = "TextureProjector";
    public static final String COMPONENT = "TextureProjection";
    public static final int LEVEL = 2;
    public static final float AMBIENTINTENSITY_DEFAULT_VALUE = 0.0f;
    public static final float[] COLOR_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final float[] DIRECTION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 1.0f};
    public static final float FARDISTANCE_DEFAULT_VALUE = -1.0f;
    public static final float FIELDOFVIEW_DEFAULT_VALUE = 0.7854f;
    public static final boolean GLOBAL_DEFAULT_VALUE = true;
    public static final float INTENSITY_DEFAULT_VALUE = 1.0f;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final float[] LOCATION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float NEARDISTANCE_DEFAULT_VALUE = -1.0f;
    public static final boolean ON_DEFAULT_VALUE = true;
    public static final float SHADOWINTENSITY_DEFAULT_VALUE = 1.0f;
    public static final boolean SHADOWS_DEFAULT_VALUE = false;
    public static final X3DTexture2DNode TEXTURE_DEFAULT_VALUE = null;
    public static final float[] UPVECTOR_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 1.0f};
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AMBIENTINTENSITY = "ambientIntensity";
    public static final String toField_AMBIENTINTENSITY = "ambientIntensity";
    public static final String fromField_ASPECTRATIO = "aspectRatio";
    public static final String fromField_COLOR = "color";
    public static final String toField_COLOR = "color";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_DIRECTION = "direction";
    public static final String toField_DIRECTION = "direction";
    public static final String fromField_FARDISTANCE = "farDistance";
    public static final String toField_FARDISTANCE = "farDistance";
    public static final String fromField_FIELDOFVIEW = "fieldOfView";
    public static final String toField_FIELDOFVIEW = "fieldOfView";
    public static final String fromField_GLOBAL = "global";
    public static final String toField_GLOBAL = "global";
    public static final String fromField_INTENSITY = "intensity";
    public static final String toField_INTENSITY = "intensity";
    public static final String fromField_IS = "IS";
    public static final String fromField_LOCATION = "location";
    public static final String toField_LOCATION = "location";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_NEARDISTANCE = "nearDistance";
    public static final String toField_NEARDISTANCE = "nearDistance";
    public static final String fromField_ON = "on";
    public static final String toField_ON = "on";
    public static final String fromField_SHADOWINTENSITY = "shadowIntensity";
    public static final String toField_SHADOWINTENSITY = "shadowIntensity";
    public static final String fromField_SHADOWS = "shadows";
    public static final String toField_SHADOWS = "shadows";
    public static final String fromField_TEXTURE = "texture";
    public static final String toField_TEXTURE = "texture";
    public static final String fromField_UPVECTOR = "upVector";
    public static final String toField_UPVECTOR = "upVector";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "ambientIntensity" -> "SFFloat";
            case fromField_ASPECTRATIO -> "SFFloat";
            case "color" -> "SFColor";
            case "description" -> "SFString";
            case "direction" -> "SFVec3f";
            case "farDistance" -> "SFFloat";
            case "fieldOfView" -> "SFFloat";
            case "global" -> "SFBool";
            case "intensity" -> "SFFloat";
            case fromField_IS -> "SFNode";
            case "location" -> "SFVec3f";
            case "metadata" -> "SFNode";
            case "nearDistance" -> "SFFloat";
            case "on" -> "SFBool";
            case "shadowIntensity" -> "SFFloat";
            case "shadows" -> "SFBool";
            case "texture" -> "SFNode";
            case "upVector" -> "SFVec3f";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "ambientIntensity" -> "inputOutput";
            case fromField_ASPECTRATIO -> "outputOnly";
            case "color" -> "inputOutput";
            case "description" -> "inputOutput";
            case "direction" -> "inputOutput";
            case "farDistance" -> "inputOutput";
            case "fieldOfView" -> "inputOutput";
            case "global" -> "inputOutput";
            case "intensity" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "location" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "nearDistance" -> "inputOutput";
            case "on" -> "inputOutput";
            case "shadowIntensity" -> "inputOutput";
            case "shadows" -> "inputOutput";
            case "texture" -> "inputOutput";
            case "upVector" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public TextureProjector() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.ambientIntensity = 0.0f;
        this.color = COLOR_DEFAULT_VALUE;
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.direction = DIRECTION_DEFAULT_VALUE;
        this.farDistance = -1.0f;
        this.fieldOfView = 0.7854f;
        this.global = true;
        this.intensity = 1.0f;
        this.IS = null;
        this.location = LOCATION_DEFAULT_VALUE;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.nearDistance = -1.0f;
        this.on = true;
        this.shadowIntensity = 1.0f;
        this.shadows = false;
        this.texture = null;
        this.textureProtoInstance = null;
        this.upVector = UPVECTOR_DEFAULT_VALUE;
        this.commentsList = new ArrayList();
    }

    @Override
    public float getAmbientIntensity() {
        return this.ambientIntensity;
    }

    @Override
    public TextureProjector setAmbientIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("TextureProjector ambientIntensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("TextureProjector ambientIntensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.ambientIntensity = newValue;
        return this;
    }

    public TextureProjector setAmbientIntensity(SFFloat newValue) {
        this.setAmbientIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setAmbientIntensity(double newValue) {
        return this.setAmbientIntensity((float)newValue);
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public float[] getColor() {
        return this.color;
    }

    @Override
    public TextureProjector setColor(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("TextureProjector color newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) {
            throw new InvalidFieldValueException("TextureProjector color newValue=" + String.valueOf(newValue) + " has component value less than restriction minInclusive=0");
        }
        if (newValue[0] > 1.0f || newValue[1] > 1.0f || newValue[2] > 1.0f) {
            throw new InvalidFieldValueException("TextureProjector color newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.color = newValue;
        return this;
    }

    public TextureProjector setColor(SFColor newValue) {
        this.setColor(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setColor(float red, float green, float blue) {
        this.setColor(new float[]{red, green, blue});
        return this;
    }

    public TextureProjector setColor(double red, double green, double blue) {
        return this.setColor((float)red, (float)green, (float)blue);
    }

    public TextureProjector setColor(double[] newArray) {
        return this.setColor(new SFColor(newArray));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TextureProjector setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public TextureProjector setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getDirection() {
        return this.direction;
    }

    @Override
    public TextureProjector setDirection(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("TextureProjector direction newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.direction = newValue;
        return this;
    }

    public TextureProjector setDirection(SFVec3f newValue) {
        this.setDirection(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setDirection(float x, float y, float z) {
        this.setDirection(new float[]{x, y, z});
        return this;
    }

    public TextureProjector setDirection(double x, double y, double z) {
        return this.setDirection(new SFVec3f(x, y, z));
    }

    public TextureProjector setDirection(double[] newArray) {
        return this.setDirection(new SFVec3f(newArray));
    }

    @Override
    public float getFarDistance() {
        return this.farDistance;
    }

    @Override
    public TextureProjector setFarDistance(float newValue) {
        if (newValue < -1.0f) {
            throw new InvalidFieldValueException("TextureProjector farDistance newValue=" + newValue + " has component value less than restriction minInclusive=-1");
        }
        this.farDistance = newValue;
        return this;
    }

    public TextureProjector setFarDistance(SFFloat newValue) {
        this.setFarDistance(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setFarDistance(double newValue) {
        return this.setFarDistance((float)newValue);
    }

    @Override
    public float getFieldOfView() {
        return this.fieldOfView;
    }

    @Override
    public TextureProjector setFieldOfView(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("TextureProjector fieldOfView newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 3.1416f) {
            throw new InvalidFieldValueException("TextureProjector fieldOfView newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=3.1416");
        }
        this.fieldOfView = newValue;
        return this;
    }

    public TextureProjector setFieldOfView(SFFloat newValue) {
        this.setFieldOfView(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setFieldOfView(double newValue) {
        return this.setFieldOfView((float)newValue);
    }

    @Override
    public boolean getGlobal() {
        return this.global;
    }

    @Override
    public TextureProjector setGlobal(boolean newValue) {
        this.global = newValue;
        return this;
    }

    public TextureProjector setGlobal(SFBool newValue) {
        this.setGlobal(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getIntensity() {
        return this.intensity;
    }

    @Override
    public TextureProjector setIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("TextureProjector intensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.intensity = newValue;
        return this;
    }

    public TextureProjector setIntensity(SFFloat newValue) {
        this.setIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setIntensity(double newValue) {
        return this.setIntensity((float)newValue);
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public TextureProjector setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public TextureProjector clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public float[] getLocation() {
        return this.location;
    }

    @Override
    public TextureProjector setLocation(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("TextureProjector location newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.location = newValue;
        return this;
    }

    public TextureProjector setLocation(SFVec3f newValue) {
        this.setLocation(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setLocation(float x, float y, float z) {
        this.setLocation(new float[]{x, y, z});
        return this;
    }

    public TextureProjector setLocation(double x, double y, double z) {
        return this.setLocation(new SFVec3f(x, y, z));
    }

    public TextureProjector setLocation(double[] newArray) {
        return this.setLocation(new SFVec3f(newArray));
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public TextureProjector setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public TextureProjector clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public TextureProjector setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float getNearDistance() {
        return this.nearDistance;
    }

    @Override
    public TextureProjector setNearDistance(float newValue) {
        if (newValue < -1.0f) {
            throw new InvalidFieldValueException("TextureProjector nearDistance newValue=" + newValue + " has component value less than restriction minInclusive=-1");
        }
        this.nearDistance = newValue;
        return this;
    }

    public TextureProjector setNearDistance(SFFloat newValue) {
        this.setNearDistance(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setNearDistance(double newValue) {
        return this.setNearDistance((float)newValue);
    }

    @Override
    public boolean getOn() {
        return this.on;
    }

    @Override
    public TextureProjector setOn(boolean newValue) {
        this.on = newValue;
        return this;
    }

    public TextureProjector setOn(SFBool newValue) {
        this.setOn(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getShadowIntensity() {
        return this.shadowIntensity;
    }

    @Override
    public TextureProjector setShadowIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("TextureProjector shadowIntensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("TextureProjector shadowIntensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.shadowIntensity = newValue;
        return this;
    }

    public TextureProjector setShadowIntensity(SFFloat newValue) {
        this.setShadowIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setShadowIntensity(double newValue) {
        return this.setShadowIntensity((float)newValue);
    }

    @Override
    public boolean getShadows() {
        return this.shadows;
    }

    @Override
    public TextureProjector setShadows(boolean newValue) {
        this.shadows = newValue;
        return this;
    }

    public TextureProjector setShadows(SFBool newValue) {
        this.setShadows(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DTexture2DNode getTexture() {
        return this.texture;
    }

    @Override
    public TextureProjector setTexture(X3DTexture2DNode newValue) {
        this.texture = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.texture)).setParent(this);
        }
        if (this.textureProtoInstance != null) {
            this.textureProtoInstance.setParent(null);
            this.textureProtoInstance = null;
        }
        return this;
    }

    public TextureProjector clearTexture() {
        ((X3DConcreteElement)((Object)this.texture)).clearParent();
        this.texture = null;
        return this;
    }

    public TextureProjector setTexture(ProtoInstance newValue) {
        if (this.textureProtoInstance != null) {
            this.textureProtoInstance.setParent(null);
        }
        this.textureProtoInstance = newValue;
        if (newValue != null) {
            this.textureProtoInstance.setParent(this);
            this.textureProtoInstance.setContainerField("texture");
        }
        if (this.texture != null) {
            ((X3DConcreteElement)((Object)this.texture)).setParent(null);
            this.texture = null;
        }
        return this;
    }

    private ProtoInstance getTextureProtoInstance() {
        return this.textureProtoInstance;
    }

    public boolean hasTexture() {
        return this.texture != null || this.textureProtoInstance != null;
    }

    @Override
    public float[] getUpVector() {
        return this.upVector;
    }

    @Override
    public TextureProjector setUpVector(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("TextureProjector upVector newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.upVector = newValue;
        return this;
    }

    public TextureProjector setUpVector(SFVec3f newValue) {
        this.setUpVector(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setUpVector(float x, float y, float z) {
        this.setUpVector(new float[]{x, y, z});
        return this;
    }

    public TextureProjector setUpVector(double x, double y, double z) {
        return this.setUpVector(new SFVec3f(x, y, z));
    }

    public TextureProjector setUpVector(double[] newArray) {
        return this.setUpVector(new SFVec3f(newArray));
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final TextureProjector setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("TextureProjector DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public TextureProjector setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final TextureProjector setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("TextureProjector USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public TextureProjector setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final TextureProjector setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public TextureProjector setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final TextureProjector setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public TextureProjector setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final TextureProjector setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public TextureProjector setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProjector setUSE(TextureProjector DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on TextureProjector that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public TextureProjector(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public TextureProjector addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public TextureProjector addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public TextureProjector addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.texture != null || this.textureProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<TextureProjector");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAmbientIntensity() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" ambientIntensity='").append(SFFloat.toString(this.getAmbientIntensity())).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getColor(), COLOR_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" color='").append(SFColor.toString(this.getColor())).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getDirection(), DIRECTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" direction='").append(SFVec3f.toString(this.getDirection())).append("'");
            }
            if (!(this.getFarDistance() == -1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" farDistance='").append(SFFloat.toString(this.getFarDistance())).append("'");
            }
            if (!(this.getFieldOfView() == 0.7854f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" fieldOfView='").append(SFFloat.toString(this.getFieldOfView())).append("'");
            }
            if (!(this.getGlobal() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" global='").append(SFBool.toString(this.getGlobal())).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getIntensity() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" intensity='").append(SFFloat.toString(this.getIntensity())).append("'");
            }
            if (!(Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" location='").append(SFVec3f.toString(this.getLocation())).append("'");
            }
            if (!(this.getNearDistance() == -1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" nearDistance='").append(SFFloat.toString(this.getNearDistance())).append("'");
            }
            if (!(this.getOn() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" on='").append(SFBool.toString(this.getOn())).append("'");
            }
            if (!(this.getShadowIntensity() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" shadowIntensity='").append(SFFloat.toString(this.getShadowIntensity())).append("'");
            }
            if (!(!this.getShadows() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" shadows='").append(SFBool.toString(this.getShadows())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getUpVector(), UPVECTOR_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" upVector='").append(SFVec3f.toString(this.getUpVector())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.texture != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.texture)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.textureProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.textureProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</TextureProjector>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.texture != null || this.textureProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("ambientIntensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("ambientIntensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAmbientIntensity() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("ambientIntensity ").append(SFFloat.toString(this.getAmbientIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("color")) continue;
                        stringClassicVRML.append(indentCharacter).append("color").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getColor(), COLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("color ").append(SFColor.toString(this.getColor())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("direction")) continue;
                        stringClassicVRML.append(indentCharacter).append("direction").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getDirection(), DIRECTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("direction ").append(SFVec3f.toString(this.getDirection())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("farDistance")) continue;
                        stringClassicVRML.append(indentCharacter).append("farDistance").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getFarDistance() != -1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("farDistance ").append(SFFloat.toString(this.getFarDistance())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("fieldOfView")) continue;
                        stringClassicVRML.append(indentCharacter).append("fieldOfView").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getFieldOfView() != 0.7854f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("fieldOfView ").append(SFFloat.toString(this.getFieldOfView())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("global")) continue;
                        stringClassicVRML.append(indentCharacter).append("global").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getGlobal() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("global ").append(SFBool.toString(this.getGlobal())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("intensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("intensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getIntensity() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("intensity ").append(SFFloat.toString(this.getIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("location")) continue;
                        stringClassicVRML.append(indentCharacter).append("location").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("location ").append(SFVec3f.toString(this.getLocation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("nearDistance")) continue;
                        stringClassicVRML.append(indentCharacter).append("nearDistance").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getNearDistance() != -1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("nearDistance ").append(SFFloat.toString(this.getNearDistance())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("on")) continue;
                        stringClassicVRML.append(indentCharacter).append("on").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getOn() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("on ").append(SFBool.toString(this.getOn())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("shadowIntensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("shadowIntensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getShadowIntensity() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("shadowIntensity ").append(SFFloat.toString(this.getShadowIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("shadows")) continue;
                        stringClassicVRML.append(indentCharacter).append("shadows").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getShadows() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("shadows ").append(SFBool.toString(this.getShadows())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("upVector")) continue;
                        stringClassicVRML.append(indentCharacter).append("upVector").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getUpVector(), UPVECTOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("upVector ").append(SFVec3f.toString(this.getUpVector())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.texture != null) {
                stringClassicVRML.append(indentCharacter).append("texture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.texture)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.textureProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("texture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.textureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.texture != null && (referenceElement = ((X3DConcreteElement)((Object)this.texture)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.textureProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.textureProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.texture != null && (referenceNode = ((X3DConcreteElement)((Object)this.texture)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.textureProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.textureProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAmbientIntensity(this.getAmbientIntensity());
        this.setColor(this.getColor());
        this.setDescription(this.getDescription());
        this.setDirection(this.getDirection());
        this.setFarDistance(this.getFarDistance());
        this.setFieldOfView(this.getFieldOfView());
        this.setGlobal(this.getGlobal());
        this.setIntensity(this.getIntensity());
        this.setLocation(this.getLocation());
        this.setNearDistance(this.getNearDistance());
        this.setOn(this.getOn());
        this.setShadowIntensity(this.getShadowIntensity());
        this.setShadows(this.getShadows());
        this.setUpVector(this.getUpVector());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.texture != null) {
            this.setTexture(this.getTexture());
            ((X3DConcreteElement)((Object)this.texture)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.texture)).getValidationResult());
        }
        if (this.textureProtoInstance != null) {
            this.setTexture(this.getTextureProtoInstance());
            ((X3DConcreteElement)this.textureProtoInstance).validate();
            this.validationResult.append(this.textureProtoInstance.getValidationResult());
        }
        if (this.texture != null && this.textureProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both texture and textureProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasTexture()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained SFNode texture";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "TextureProjector USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'TextureProjector' node, ensure sufficient support by adding head statement <component name='TextureProjection' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"TextureProjection\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

