/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Sound;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.Texturing.MovieTexture;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Sound.X3DSoundSourceNode;

public class Sound
extends X3DConcreteNode
implements org.web3d.x3d.sai.Sound.Sound {
    private ArrayList<String> commentsList;
    private String description = new String();
    private float[] direction;
    private boolean enabled;
    private float intensity;
    private IS IS;
    private float[] location;
    private float maxBack;
    private float maxFront;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float minBack;
    private float minFront;
    private float priority;
    private X3DSoundSourceNode source;
    private ProtoInstance sourceProtoInstance;
    private boolean spatialize;
    public static final String NAME = "Sound";
    public static final String COMPONENT = "Sound";
    public static final int LEVEL = 1;
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final float[] DIRECTION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 1.0f};
    public static final boolean ENABLED_DEFAULT_VALUE = true;
    public static final float INTENSITY_DEFAULT_VALUE = 1.0f;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final float[] LOCATION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final float MAXBACK_DEFAULT_VALUE = 10.0f;
    public static final float MAXFRONT_DEFAULT_VALUE = 10.0f;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float MINBACK_DEFAULT_VALUE = 1.0f;
    public static final float MINFRONT_DEFAULT_VALUE = 1.0f;
    public static final float PRIORITY_DEFAULT_VALUE = 0.0f;
    public static final X3DSoundSourceNode SOURCE_DEFAULT_VALUE = null;
    public static final boolean SPATIALIZE_DEFAULT_VALUE = true;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_DIRECTION = "direction";
    public static final String toField_DIRECTION = "direction";
    public static final String fromField_ENABLED = "enabled";
    public static final String toField_ENABLED = "enabled";
    public static final String fromField_INTENSITY = "intensity";
    public static final String toField_INTENSITY = "intensity";
    public static final String fromField_IS = "IS";
    public static final String fromField_LOCATION = "location";
    public static final String toField_LOCATION = "location";
    public static final String fromField_MAXBACK = "maxBack";
    public static final String toField_MAXBACK = "maxBack";
    public static final String fromField_MAXFRONT = "maxFront";
    public static final String toField_MAXFRONT = "maxFront";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_MINBACK = "minBack";
    public static final String toField_MINBACK = "minBack";
    public static final String fromField_MINFRONT = "minFront";
    public static final String toField_MINFRONT = "minFront";
    public static final String fromField_PRIORITY = "priority";
    public static final String toField_PRIORITY = "priority";
    public static final String fromField_SOURCE = "source";
    public static final String toField_SOURCE = "source";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return "Sound";
    }

    @Override
    public final String getComponent() {
        return "Sound";
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "description" -> "SFString";
            case "direction" -> "SFVec3f";
            case "enabled" -> "SFBool";
            case "intensity" -> "SFFloat";
            case fromField_IS -> "SFNode";
            case "location" -> "SFVec3f";
            case "maxBack" -> "SFFloat";
            case "maxFront" -> "SFFloat";
            case "metadata" -> "SFNode";
            case "minBack" -> "SFFloat";
            case "minFront" -> "SFFloat";
            case "priority" -> "SFFloat";
            case "source" -> "SFNode";
            case "spatialize" -> "SFBool";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "description" -> "inputOutput";
            case "direction" -> "inputOutput";
            case "enabled" -> "inputOutput";
            case "intensity" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "location" -> "inputOutput";
            case "maxBack" -> "inputOutput";
            case "maxFront" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "minBack" -> "inputOutput";
            case "minFront" -> "inputOutput";
            case "priority" -> "inputOutput";
            case "source" -> "inputOutput";
            case "spatialize" -> "initializeOnly";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public Sound() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.direction = DIRECTION_DEFAULT_VALUE;
        this.enabled = true;
        this.intensity = 1.0f;
        this.IS = null;
        this.location = LOCATION_DEFAULT_VALUE;
        this.maxBack = 10.0f;
        this.maxFront = 10.0f;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.minBack = 1.0f;
        this.minFront = 1.0f;
        this.priority = 0.0f;
        this.source = null;
        this.sourceProtoInstance = null;
        this.spatialize = true;
        this.commentsList = new ArrayList();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Sound setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public Sound setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getDirection() {
        return this.direction;
    }

    @Override
    public Sound setDirection(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("Sound direction newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.direction = newValue;
        return this;
    }

    public Sound setDirection(SFVec3f newValue) {
        this.setDirection(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setDirection(float x, float y, float z) {
        this.setDirection(new float[]{x, y, z});
        return this;
    }

    public Sound setDirection(double x, double y, double z) {
        return this.setDirection(new SFVec3f(x, y, z));
    }

    public Sound setDirection(double[] newArray) {
        return this.setDirection(new SFVec3f(newArray));
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public Sound setEnabled(boolean newValue) {
        this.enabled = newValue;
        return this;
    }

    public Sound setEnabled(SFBool newValue) {
        this.setEnabled(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getIntensity() {
        return this.intensity;
    }

    @Override
    public Sound setIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound intensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("Sound intensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.intensity = newValue;
        return this;
    }

    public Sound setIntensity(SFFloat newValue) {
        this.setIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setIntensity(double newValue) {
        return this.setIntensity((float)newValue);
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public Sound setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public Sound clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public float[] getLocation() {
        return this.location;
    }

    @Override
    public Sound setLocation(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("Sound location newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.location = newValue;
        return this;
    }

    public Sound setLocation(SFVec3f newValue) {
        this.setLocation(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setLocation(float x, float y, float z) {
        this.setLocation(new float[]{x, y, z});
        return this;
    }

    public Sound setLocation(double x, double y, double z) {
        return this.setLocation(new SFVec3f(x, y, z));
    }

    public Sound setLocation(double[] newArray) {
        return this.setLocation(new SFVec3f(newArray));
    }

    @Override
    public float getMaxBack() {
        return this.maxBack;
    }

    @Override
    public Sound setMaxBack(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound maxBack newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.maxBack = newValue;
        return this;
    }

    public Sound setMaxBack(SFFloat newValue) {
        this.setMaxBack(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setMaxBack(double newValue) {
        return this.setMaxBack((float)newValue);
    }

    @Override
    public float getMaxFront() {
        return this.maxFront;
    }

    @Override
    public Sound setMaxFront(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound maxFront newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.maxFront = newValue;
        return this;
    }

    public Sound setMaxFront(SFFloat newValue) {
        this.setMaxFront(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setMaxFront(double newValue) {
        return this.setMaxFront((float)newValue);
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Sound setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public Sound clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public Sound setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float getMinBack() {
        return this.minBack;
    }

    @Override
    public Sound setMinBack(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound minBack newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.minBack = newValue;
        return this;
    }

    public Sound setMinBack(SFFloat newValue) {
        this.setMinBack(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setMinBack(double newValue) {
        return this.setMinBack((float)newValue);
    }

    @Override
    public float getMinFront() {
        return this.minFront;
    }

    @Override
    public Sound setMinFront(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound minFront newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.minFront = newValue;
        return this;
    }

    public Sound setMinFront(SFFloat newValue) {
        this.setMinFront(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setMinFront(double newValue) {
        return this.setMinFront((float)newValue);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Override
    public Sound setPriority(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Sound priority newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("Sound priority newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.priority = newValue;
        return this;
    }

    public Sound setPriority(SFFloat newValue) {
        this.setPriority(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setPriority(double newValue) {
        return this.setPriority((float)newValue);
    }

    @Override
    public X3DSoundSourceNode getSource() {
        return this.source;
    }

    @Override
    public Sound setSource(X3DSoundSourceNode newValue) {
        this.source = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.source)).setParent(this);
            if (this.source instanceof MovieTexture) {
                ((X3DConcreteNode)((Object)this.source)).setContainerFieldOverride("source");
            }
        }
        if (this.sourceProtoInstance != null) {
            this.sourceProtoInstance.setParent(null);
            this.sourceProtoInstance = null;
        }
        return this;
    }

    public Sound clearSource() {
        ((X3DConcreteElement)((Object)this.source)).clearParent();
        this.source = null;
        return this;
    }

    public Sound setSource(ProtoInstance newValue) {
        if (this.sourceProtoInstance != null) {
            this.sourceProtoInstance.setParent(null);
        }
        this.sourceProtoInstance = newValue;
        if (newValue != null) {
            this.sourceProtoInstance.setParent(this);
            this.sourceProtoInstance.setContainerField("source");
        }
        if (this.source != null) {
            ((X3DConcreteElement)((Object)this.source)).setParent(null);
            this.source = null;
        }
        return this;
    }

    private ProtoInstance getSourceProtoInstance() {
        return this.sourceProtoInstance;
    }

    public boolean hasSource() {
        return this.source != null || this.sourceProtoInstance != null;
    }

    @Override
    public boolean getSpatialize() {
        return this.spatialize;
    }

    @Override
    public Sound setSpatialize(boolean newValue) {
        this.spatialize = newValue;
        return this;
    }

    public Sound setSpatialize(SFBool newValue) {
        this.setSpatialize(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final Sound setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("Sound DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public Sound setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final Sound setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("Sound USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public Sound setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final Sound setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public Sound setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final Sound setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public Sound setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final Sound setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public Sound setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public Sound setUSE(Sound DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on Sound that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public Sound(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public Sound addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public Sound addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public Sound addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.source != null || this.sourceProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<Sound");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getDirection(), DIRECTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" direction='").append(SFVec3f.toString(this.getDirection())).append("'");
            }
            if (!(this.getEnabled() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" enabled='").append(SFBool.toString(this.getEnabled())).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getIntensity() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" intensity='").append(SFFloat.toString(this.getIntensity())).append("'");
            }
            if (!(Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" location='").append(SFVec3f.toString(this.getLocation())).append("'");
            }
            if (!(this.getMaxBack() == 10.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" maxBack='").append(SFFloat.toString(this.getMaxBack())).append("'");
            }
            if (!(this.getMaxFront() == 10.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" maxFront='").append(SFFloat.toString(this.getMaxFront())).append("'");
            }
            if (!(this.getMinBack() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" minBack='").append(SFFloat.toString(this.getMinBack())).append("'");
            }
            if (!(this.getMinFront() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" minFront='").append(SFFloat.toString(this.getMinFront())).append("'");
            }
            if (!(this.getPriority() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" priority='").append(SFFloat.toString(this.getPriority())).append("'");
            }
            if (!(this.getSpatialize() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" spatialize='").append(SFBool.toString(this.getSpatialize())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.source != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.source)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.sourceProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.sourceProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</Sound>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.source != null || this.sourceProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append("Sound").append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("direction")) continue;
                        stringClassicVRML.append(indentCharacter).append("direction").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getDirection(), DIRECTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("direction ").append(SFVec3f.toString(this.getDirection())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("enabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEnabled() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("enabled ").append(SFBool.toString(this.getEnabled())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("intensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("intensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getIntensity() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("intensity ").append(SFFloat.toString(this.getIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("location")) continue;
                        stringClassicVRML.append(indentCharacter).append("location").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("location ").append(SFVec3f.toString(this.getLocation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("maxBack")) continue;
                        stringClassicVRML.append(indentCharacter).append("maxBack").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMaxBack() != 10.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("maxBack ").append(SFFloat.toString(this.getMaxBack())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("maxFront")) continue;
                        stringClassicVRML.append(indentCharacter).append("maxFront").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMaxFront() != 10.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("maxFront ").append(SFFloat.toString(this.getMaxFront())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("minBack")) continue;
                        stringClassicVRML.append(indentCharacter).append("minBack").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMinBack() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("minBack ").append(SFFloat.toString(this.getMinBack())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("minFront")) continue;
                        stringClassicVRML.append(indentCharacter).append("minFront").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMinFront() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("minFront ").append(SFFloat.toString(this.getMinFront())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("priority")) continue;
                        stringClassicVRML.append(indentCharacter).append("priority").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getPriority() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("priority ").append(SFFloat.toString(this.getPriority())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("spatialize")) continue;
                        stringClassicVRML.append(indentCharacter).append("spatialize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getSpatialize() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("spatialize ").append(SFBool.toString(this.getSpatialize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.source != null) {
                stringClassicVRML.append(indentCharacter).append("source").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.source)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.sourceProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("source").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.sourceProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.source != null && (referenceElement = ((X3DConcreteElement)((Object)this.source)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.sourceProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.sourceProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.source != null && (referenceNode = ((X3DConcreteElement)((Object)this.source)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.sourceProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.sourceProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setDescription(this.getDescription());
        this.setDirection(this.getDirection());
        this.setEnabled(this.getEnabled());
        this.setIntensity(this.getIntensity());
        this.setLocation(this.getLocation());
        this.setMaxBack(this.getMaxBack());
        this.setMaxFront(this.getMaxFront());
        this.setMinBack(this.getMinBack());
        this.setMinFront(this.getMinFront());
        this.setPriority(this.getPriority());
        this.setSpatialize(this.getSpatialize());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.source != null) {
            this.setSource(this.getSource());
            ((X3DConcreteElement)((Object)this.source)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.source)).getValidationResult());
        }
        if (this.sourceProtoInstance != null) {
            this.setSource(this.getSourceProtoInstance());
            ((X3DConcreteElement)this.sourceProtoInstance).validate();
            this.validationResult.append(this.sourceProtoInstance.getValidationResult());
        }
        if (this.source != null && this.sourceProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both source and sourceProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasSource()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained SFNode source";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "Sound USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent("Sound", 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'Sound' node, ensure sufficient support by adding head statement <component name='Sound' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Sound\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

