/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Sound;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class BufferAudioSource
extends X3DConcreteNode
implements org.web3d.x3d.sai.Sound.BufferAudioSource {
    private ArrayList<String> commentsList;
    private double autoRefresh;
    private double autoRefreshTimeLimit;
    private ArrayList<Float> buffer = new ArrayList();
    private double bufferDuration;
    private int bufferlength;
    private int channelCount;
    private String channelCountMode = new String();
    private String channelInterpretation = new String();
    private String description = new String();
    private float detune;
    private double elapsedTime;
    private boolean enabled;
    private float gain;
    private IS IS;
    private boolean isActive;
    private boolean isPaused;
    private int length;
    private boolean load;
    private boolean loop;
    private float loopEnd;
    private float loopStart;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private int numberOfChannels;
    private double pauseTime;
    private float playbackRate;
    private double resumeTime;
    private float sampleRate;
    private double startTime;
    private double stopTime;
    private ArrayList<String> url = new ArrayList();
    static boolean channelCountModeWarningAlreadyProvided = false;
    public static final String CHANNELCOUNTMODE_MAX = "MAX";
    public static final String CHANNELCOUNTMODE_MAX_ALIAS = "max";
    public static final String CHANNELCOUNTMODE_CLAMPED_MAX = "CLAMPED_MAX";
    public static final String CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS = "clamped-max";
    public static final String CHANNELCOUNTMODE_EXPLICIT = "EXPLICIT";
    public static final String CHANNELCOUNTMODE_EXPLICIT_ALIAS = "explicit";
    static boolean channelInterpretationWarningAlreadyProvided = false;
    public static final String CHANNELINTERPRETATION_SPEAKERS = "SPEAKERS";
    public static final String CHANNELINTERPRETATION_DISCRETE = "DISCRETE";
    public static final String NAME = "BufferAudioSource";
    public static final String COMPONENT = "Sound";
    public static final int LEVEL = 2;
    public static final double AUTOREFRESH_DEFAULT_VALUE = 0.0;
    public static final double AUTOREFRESHTIMELIMIT_DEFAULT_VALUE = 3600.0;
    public static final ArrayList<Float> BUFFER_DEFAULT_VALUE = new ArrayList<Float>(Arrays.asList(new Float[0]));
    public static final double BUFFERDURATION_DEFAULT_VALUE = 0.0;
    public static final String CHANNELCOUNTMODE_DEFAULT_VALUE = "MAX";
    public static final String CHANNELINTERPRETATION_DEFAULT_VALUE = "SPEAKERS";
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final float DETUNE_DEFAULT_VALUE = 0.0f;
    public static final boolean ENABLED_DEFAULT_VALUE = true;
    public static final float GAIN_DEFAULT_VALUE = 1.0f;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final boolean LOAD_DEFAULT_VALUE = true;
    public static final boolean LOOP_DEFAULT_VALUE = false;
    public static final float LOOPEND_DEFAULT_VALUE = 0.0f;
    public static final float LOOPSTART_DEFAULT_VALUE = 0.0f;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final int NUMBEROFCHANNELS_DEFAULT_VALUE = 0;
    public static final double PAUSETIME_DEFAULT_VALUE = 0.0;
    public static final float PLAYBACKRATE_DEFAULT_VALUE = 1.0f;
    public static final double RESUMETIME_DEFAULT_VALUE = 0.0;
    public static final float SAMPLERATE_DEFAULT_VALUE = 0.0f;
    public static final double STARTTIME_DEFAULT_VALUE = 0.0;
    public static final double STOPTIME_DEFAULT_VALUE = 0.0;
    public static final ArrayList<String> URL_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList(new String[0]));
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AUTOREFRESH = "autoRefresh";
    public static final String toField_AUTOREFRESH = "autoRefresh";
    public static final String fromField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String toField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String fromField_BUFFER = "buffer";
    public static final String toField_BUFFER = "buffer";
    public static final String fromField_BUFFERDURATION = "bufferDuration";
    public static final String toField_BUFFERDURATION = "bufferDuration";
    public static final String fromField_BUFFERLENGTH = "bufferlength";
    public static final String fromField_CHANNELCOUNT = "channelCount";
    public static final String fromField_CHANNELCOUNTMODE = "channelCountMode";
    public static final String toField_CHANNELCOUNTMODE = "channelCountMode";
    public static final String fromField_CHANNELINTERPRETATION = "channelInterpretation";
    public static final String toField_CHANNELINTERPRETATION = "channelInterpretation";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_DETUNE = "detune";
    public static final String toField_DETUNE = "detune";
    public static final String fromField_ELAPSEDTIME = "elapsedTime";
    public static final String fromField_ENABLED = "enabled";
    public static final String toField_ENABLED = "enabled";
    public static final String fromField_GAIN = "gain";
    public static final String toField_GAIN = "gain";
    public static final String fromField_IS = "IS";
    public static final String fromField_ISACTIVE = "isActive";
    public static final String fromField_ISPAUSED = "isPaused";
    public static final String fromField_LENGTH = "length";
    public static final String fromField_LOAD = "load";
    public static final String toField_LOAD = "load";
    public static final String fromField_LOOP = "loop";
    public static final String toField_LOOP = "loop";
    public static final String fromField_LOOPEND = "loopEnd";
    public static final String toField_LOOPEND = "loopEnd";
    public static final String fromField_LOOPSTART = "loopStart";
    public static final String toField_LOOPSTART = "loopStart";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_NUMBEROFCHANNELS = "numberOfChannels";
    public static final String toField_NUMBEROFCHANNELS = "numberOfChannels";
    public static final String fromField_PAUSETIME = "pauseTime";
    public static final String toField_PAUSETIME = "pauseTime";
    public static final String fromField_PLAYBACKRATE = "playbackRate";
    public static final String toField_PLAYBACKRATE = "playbackRate";
    public static final String fromField_RESUMETIME = "resumeTime";
    public static final String toField_RESUMETIME = "resumeTime";
    public static final String fromField_SAMPLERATE = "sampleRate";
    public static final String toField_SAMPLERATE = "sampleRate";
    public static final String fromField_STARTTIME = "startTime";
    public static final String toField_STARTTIME = "startTime";
    public static final String fromField_STOPTIME = "stopTime";
    public static final String toField_STOPTIME = "stopTime";
    public static final String fromField_URL = "url";
    public static final String toField_URL = "url";
    private boolean serializingVRML97output = false;

    public static String getChannelCountModeAlias(String channelCountModeValue) {
        if (channelCountModeValue.equalsIgnoreCase("MAX")) {
            return CHANNELCOUNTMODE_MAX_ALIAS;
        }
        if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_CLAMPED_MAX)) {
            return CHANNELCOUNTMODE_CLAMPED_MAX_ALIAS;
        }
        if (channelCountModeValue.equalsIgnoreCase(CHANNELCOUNTMODE_EXPLICIT)) {
            return CHANNELCOUNTMODE_EXPLICIT_ALIAS;
        }
        return DESCRIPTION_DEFAULT_VALUE;
    }

    public static boolean hasChannelCountModeAlias(String channelCountMode) {
        return !BufferAudioSource.getChannelCountModeAlias(channelCountMode).isEmpty();
    }

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "autoRefresh" -> "SFTime";
            case "autoRefreshTimeLimit" -> "SFTime";
            case "buffer" -> "MFFloat";
            case "bufferDuration" -> "SFTime";
            case fromField_BUFFERLENGTH -> "SFInt32";
            case fromField_CHANNELCOUNT -> "SFInt32";
            case "channelCountMode" -> "SFString";
            case "channelInterpretation" -> "SFString";
            case "description" -> "SFString";
            case "detune" -> "SFFloat";
            case fromField_ELAPSEDTIME -> "SFTime";
            case "enabled" -> "SFBool";
            case "gain" -> "SFFloat";
            case fromField_IS -> "SFNode";
            case fromField_ISACTIVE -> "SFBool";
            case fromField_ISPAUSED -> "SFBool";
            case fromField_LENGTH -> "SFInt32";
            case "load" -> "SFBool";
            case "loop" -> "SFBool";
            case "loopEnd" -> "SFFloat";
            case "loopStart" -> "SFFloat";
            case "metadata" -> "SFNode";
            case "numberOfChannels" -> "SFInt32";
            case "pauseTime" -> "SFTime";
            case "playbackRate" -> "SFFloat";
            case "resumeTime" -> "SFTime";
            case "sampleRate" -> "SFFloat";
            case "startTime" -> "SFTime";
            case "stopTime" -> "SFTime";
            case "url" -> "MFString";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "autoRefresh" -> "inputOutput";
            case "autoRefreshTimeLimit" -> "inputOutput";
            case "buffer" -> "inputOutput";
            case "bufferDuration" -> "inputOutput";
            case fromField_BUFFERLENGTH -> "outputOnly";
            case fromField_CHANNELCOUNT -> "outputOnly";
            case "channelCountMode" -> "inputOutput";
            case "channelInterpretation" -> "inputOutput";
            case "description" -> "inputOutput";
            case "detune" -> "inputOutput";
            case fromField_ELAPSEDTIME -> "outputOnly";
            case "enabled" -> "inputOutput";
            case "gain" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case fromField_ISACTIVE -> "outputOnly";
            case fromField_ISPAUSED -> "outputOnly";
            case fromField_LENGTH -> "outputOnly";
            case "load" -> "inputOutput";
            case "loop" -> "inputOutput";
            case "loopEnd" -> "inputOutput";
            case "loopStart" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "numberOfChannels" -> "inputOutput";
            case "pauseTime" -> "inputOutput";
            case "playbackRate" -> "inputOutput";
            case "resumeTime" -> "inputOutput";
            case "sampleRate" -> "inputOutput";
            case "startTime" -> "inputOutput";
            case "stopTime" -> "inputOutput";
            case "url" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public BufferAudioSource() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.autoRefresh = 0.0;
        this.autoRefreshTimeLimit = 3600.0;
        this.buffer = new ArrayList();
        this.bufferDuration = 0.0;
        this.channelCountMode = "MAX";
        this.channelInterpretation = "SPEAKERS";
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.detune = 0.0f;
        this.enabled = true;
        this.gain = 1.0f;
        this.IS = null;
        this.load = true;
        this.loop = false;
        this.loopEnd = 0.0f;
        this.loopStart = 0.0f;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.numberOfChannels = 0;
        this.pauseTime = 0.0;
        this.playbackRate = 1.0f;
        this.resumeTime = 0.0;
        this.sampleRate = 0.0f;
        this.startTime = 0.0;
        this.stopTime = 0.0;
        this.url = new ArrayList<String>(URL_DEFAULT_VALUE);
        this.commentsList = new ArrayList();
    }

    @Override
    public double getAutoRefresh() {
        return this.autoRefresh;
    }

    @Override
    public BufferAudioSource setAutoRefresh(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("BufferAudioSource autoRefresh newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefresh = newValue;
        return this;
    }

    public BufferAudioSource setAutoRefresh(SFTime newValue) {
        this.setAutoRefresh(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getAutoRefreshTimeLimit() {
        return this.autoRefreshTimeLimit;
    }

    @Override
    public BufferAudioSource setAutoRefreshTimeLimit(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("BufferAudioSource autoRefreshTimeLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefreshTimeLimit = newValue;
        return this;
    }

    public BufferAudioSource setAutoRefreshTimeLimit(SFTime newValue) {
        this.setAutoRefreshTimeLimit(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBuffer() {
        float[] valuesArray = new float[this.buffer.size()];
        int i = 0;
        for (Float arrayElement : this.buffer) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getBufferList() {
        return this.buffer;
    }

    public String getBufferString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.buffer) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public BufferAudioSource setBuffer(float[] newValue) {
        if (newValue == null) {
            this.clearBuffer();
            return this;
        }
        this.clearBuffer();
        for (int i = 0; i < newValue.length; ++i) {
            this.buffer.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public BufferAudioSource setBuffer(MFFloat newValue) {
        if (newValue == null) {
            this.clearBuffer();
            return this;
        }
        this.setBuffer(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setBuffer(ArrayList<Float> newValue) {
        if (newValue == null) {
            this.clearBuffer();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearBuffer();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setBuffer(newArray);
        }
        return this;
    }

    public BufferAudioSource clearBuffer() {
        this.buffer.clear();
        return this;
    }

    public BufferAudioSource setBuffer(int[] newValue) {
        if (newValue == null) {
            this.clearBuffer();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setBuffer(holdArray);
        return this;
    }

    public BufferAudioSource addBuffer(float newValue) {
        this.buffer.add(Float.valueOf(newValue));
        return this;
    }

    public BufferAudioSource addBuffer(SFFloat newValue) {
        if (newValue == null) {
            return this;
        }
        this.buffer.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public BufferAudioSource setBuffer(double[] newArray) {
        return this.setBuffer(new MFFloat(newArray));
    }

    @Override
    public double getBufferDuration() {
        return this.bufferDuration;
    }

    @Override
    public BufferAudioSource setBufferDuration(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("BufferAudioSource bufferDuration newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.bufferDuration = newValue;
        return this;
    }

    public BufferAudioSource setBufferDuration(SFTime newValue) {
        this.setBufferDuration(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getBufferlength() {
        return this.bufferlength;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public String getChannelCountMode() {
        return this.channelCountMode;
    }

    @Override
    public BufferAudioSource setChannelCountMode(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals("MAX") || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(CHANNELCOUNTMODE_CLAMPED_MAX) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(CHANNELCOUNTMODE_EXPLICIT))) {
            String warningMessage = "[warning] BufferAudioSource channelCountMode newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
            if (!channelCountModeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are MAX, CLAMPED_MAX, EXPLICIT";
                channelCountModeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.channelCountMode = newValue;
        return this;
    }

    public BufferAudioSource setChannelCountMode(SFString newValue) {
        this.setChannelCountMode(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getChannelInterpretation() {
        return this.channelInterpretation;
    }

    @Override
    public BufferAudioSource setChannelInterpretation(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals("SPEAKERS") || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(CHANNELINTERPRETATION_DISCRETE))) {
            String warningMessage = "[warning] BufferAudioSource channelInterpretation newValue='" + newValue + "' includes an unrecognized optional value not matching any of the required enumeration string tokens.";
            if (!channelInterpretationWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are SPEAKERS, DISCRETE";
                channelInterpretationWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.channelInterpretation = newValue;
        return this;
    }

    public BufferAudioSource setChannelInterpretation(SFString newValue) {
        this.setChannelInterpretation(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public BufferAudioSource setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public BufferAudioSource setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getDetune() {
        return this.detune;
    }

    @Override
    public BufferAudioSource setDetune(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("BufferAudioSource detune newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.detune = newValue;
        return this;
    }

    public BufferAudioSource setDetune(SFFloat newValue) {
        this.setDetune(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setDetune(double newValue) {
        return this.setDetune((float)newValue);
    }

    @Override
    public double getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public BufferAudioSource setEnabled(boolean newValue) {
        this.enabled = newValue;
        return this;
    }

    public BufferAudioSource setEnabled(SFBool newValue) {
        this.setEnabled(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public BufferAudioSource setGain(float newValue) {
        this.gain = newValue;
        return this;
    }

    public BufferAudioSource setGain(SFFloat newValue) {
        this.setGain(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setGain(double newValue) {
        return this.setGain((float)newValue);
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public BufferAudioSource setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public BufferAudioSource clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public boolean getIsPaused() {
        return this.isPaused;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean getLoad() {
        return this.load;
    }

    @Override
    public BufferAudioSource setLoad(boolean newValue) {
        this.load = newValue;
        return this;
    }

    public BufferAudioSource setLoad(SFBool newValue) {
        this.setLoad(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getLoop() {
        return this.loop;
    }

    @Override
    public BufferAudioSource setLoop(boolean newValue) {
        this.loop = newValue;
        return this;
    }

    public BufferAudioSource setLoop(SFBool newValue) {
        this.setLoop(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getLoopEnd() {
        return this.loopEnd;
    }

    @Override
    public BufferAudioSource setLoopEnd(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("BufferAudioSource loopEnd newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.loopEnd = newValue;
        return this;
    }

    public BufferAudioSource setLoopEnd(SFFloat newValue) {
        this.setLoopEnd(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setLoopEnd(double newValue) {
        return this.setLoopEnd((float)newValue);
    }

    @Override
    public float getLoopStart() {
        return this.loopStart;
    }

    @Override
    public BufferAudioSource setLoopStart(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("BufferAudioSource loopStart newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.loopStart = newValue;
        return this;
    }

    public BufferAudioSource setLoopStart(SFFloat newValue) {
        this.setLoopStart(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setLoopStart(double newValue) {
        return this.setLoopStart((float)newValue);
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public BufferAudioSource setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public BufferAudioSource clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public BufferAudioSource setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    @Override
    public BufferAudioSource setNumberOfChannels(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("BufferAudioSource numberOfChannels newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.numberOfChannels = newValue;
        return this;
    }

    public BufferAudioSource setNumberOfChannels(SFInt32 newValue) {
        this.setNumberOfChannels(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getPauseTime() {
        return this.pauseTime;
    }

    @Override
    public BufferAudioSource setPauseTime(double newValue) {
        this.pauseTime = newValue;
        return this;
    }

    public BufferAudioSource setPauseTime(SFTime newValue) {
        this.setPauseTime(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getPlaybackRate() {
        return this.playbackRate;
    }

    @Override
    public BufferAudioSource setPlaybackRate(float newValue) {
        this.playbackRate = newValue;
        return this;
    }

    public BufferAudioSource setPlaybackRate(SFFloat newValue) {
        this.setPlaybackRate(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setPlaybackRate(double newValue) {
        return this.setPlaybackRate((float)newValue);
    }

    @Override
    public double getResumeTime() {
        return this.resumeTime;
    }

    @Override
    public BufferAudioSource setResumeTime(double newValue) {
        this.resumeTime = newValue;
        return this;
    }

    public BufferAudioSource setResumeTime(SFTime newValue) {
        this.setResumeTime(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public BufferAudioSource setSampleRate(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("BufferAudioSource sampleRate newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.sampleRate = newValue;
        return this;
    }

    public BufferAudioSource setSampleRate(SFFloat newValue) {
        this.setSampleRate(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setSampleRate(double newValue) {
        return this.setSampleRate((float)newValue);
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public BufferAudioSource setStartTime(double newValue) {
        this.startTime = newValue;
        return this;
    }

    public BufferAudioSource setStartTime(SFTime newValue) {
        this.setStartTime(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getStopTime() {
        return this.stopTime;
    }

    @Override
    public BufferAudioSource setStopTime(double newValue) {
        this.stopTime = newValue;
        return this;
    }

    public BufferAudioSource setStopTime(SFTime newValue) {
        this.setStopTime(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String[] getUrl() {
        String[] valuesArray = new String[this.url.size()];
        int i = 0;
        for (String arrayElement : this.url) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getUrlList() {
        return this.url;
    }

    public String getUrlString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.url) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public BufferAudioSource setUrl(String[] newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.clearUrl();
        for (int i = 0; i < newValue.length; ++i) {
            this.url.add(newValue[i]);
        }
        return this;
    }

    public BufferAudioSource setUrl(MFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.setUrl(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setUrl(SFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.setUrl(newValue.getValue());
        return this;
    }

    public BufferAudioSource setUrl(String newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.clearUrl();
        this.url.add(newValue);
        return this;
    }

    public BufferAudioSource setUrl(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearUrl();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setUrl(newArray);
        }
        return this;
    }

    public BufferAudioSource clearUrl() {
        this.url.clear();
        return this;
    }

    public BufferAudioSource addUrl(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.url.contains(newValue)) {
            this.url.add(newValue);
        }
        return this;
    }

    public BufferAudioSource addUrl(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.url.contains(newValue.getValue())) {
            this.url.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final BufferAudioSource setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("BufferAudioSource DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public BufferAudioSource setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final BufferAudioSource setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("BufferAudioSource USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public BufferAudioSource setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final BufferAudioSource setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public BufferAudioSource setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final BufferAudioSource setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public BufferAudioSource setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final BufferAudioSource setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public BufferAudioSource setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public BufferAudioSource setUSE(BufferAudioSource DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on BufferAudioSource that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public BufferAudioSource(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public BufferAudioSource addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public BufferAudioSource addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public BufferAudioSource addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<BufferAudioSource");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAutoRefresh() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefresh='").append(SFTime.toString(this.getAutoRefresh())).append("'");
            }
            if (!(this.getAutoRefreshTimeLimit() == 3600.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefreshTimeLimit='").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("'");
            }
            if (!(this.getBuffer().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" buffer='").append(MFFloat.toString(this.getBuffer())).append("'");
            }
            if (!(this.getBufferDuration() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bufferDuration='").append(SFTime.toString(this.getBufferDuration())).append("'");
            }
            if (!(this.getChannelCountMode().equals("MAX") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" channelCountMode='").append(new SFString(this.getChannelCountMode()).toStringX3D()).append("'");
            }
            if (!(this.getChannelInterpretation().equals("SPEAKERS") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" channelInterpretation='").append(new SFString(this.getChannelInterpretation()).toStringX3D()).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(this.getDetune() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" detune='").append(SFFloat.toString(this.getDetune())).append("'");
            }
            if (!(this.getEnabled() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" enabled='").append(SFBool.toString(this.getEnabled())).append("'");
            }
            if (!(this.getGain() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" gain='").append(SFFloat.toString(this.getGain())).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getLoad() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" load='").append(SFBool.toString(this.getLoad())).append("'");
            }
            if (!(!this.getLoop() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" loop='").append(SFBool.toString(this.getLoop())).append("'");
            }
            if (!(this.getLoopEnd() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" loopEnd='").append(SFFloat.toString(this.getLoopEnd())).append("'");
            }
            if (!(this.getLoopStart() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" loopStart='").append(SFFloat.toString(this.getLoopStart())).append("'");
            }
            if (!(this.getNumberOfChannels() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" numberOfChannels='").append(SFInt32.toString(this.getNumberOfChannels())).append("'");
            }
            if (!(this.getPauseTime() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" pauseTime='").append(SFTime.toString(this.getPauseTime())).append("'");
            }
            if (!(this.getPlaybackRate() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" playbackRate='").append(SFFloat.toString(this.getPlaybackRate())).append("'");
            }
            if (!(this.getResumeTime() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" resumeTime='").append(SFTime.toString(this.getResumeTime())).append("'");
            }
            if (!(this.getSampleRate() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" sampleRate='").append(SFFloat.toString(this.getSampleRate())).append("'");
            }
            if (!(this.getStartTime() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" startTime='").append(SFTime.toString(this.getStartTime())).append("'");
            }
            if (!(this.getStopTime() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" stopTime='").append(SFTime.toString(this.getStopTime())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getUrl().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" url='").append(new MFString(this.getUrl()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</BufferAudioSource>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefresh")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefresh").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefresh() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefresh ").append(SFTime.toString(this.getAutoRefresh())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefreshTimeLimit")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefreshTimeLimit").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefreshTimeLimit() != 3600.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefreshTimeLimit ").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("buffer")) continue;
                        stringClassicVRML.append(indentCharacter).append("buffer").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBuffer().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("buffer ").append("[ ").append(MFFloat.toString(this.getBuffer())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bufferDuration")) continue;
                        stringClassicVRML.append(indentCharacter).append("bufferDuration").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBufferDuration() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bufferDuration ").append(SFTime.toString(this.getBufferDuration())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("channelCountMode")) continue;
                        stringClassicVRML.append(indentCharacter).append("channelCountMode").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getChannelCountMode().equals("MAX") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("channelCountMode ").append("\"").append(SFString.toString(this.getChannelCountMode())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("channelInterpretation")) continue;
                        stringClassicVRML.append(indentCharacter).append("channelInterpretation").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getChannelInterpretation().equals("SPEAKERS") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("channelInterpretation ").append("\"").append(SFString.toString(this.getChannelInterpretation())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("detune")) continue;
                        stringClassicVRML.append(indentCharacter).append("detune").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getDetune() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("detune ").append(SFFloat.toString(this.getDetune())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("enabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEnabled() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("enabled ").append(SFBool.toString(this.getEnabled())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("gain")) continue;
                        stringClassicVRML.append(indentCharacter).append("gain").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getGain() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("gain ").append(SFFloat.toString(this.getGain())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("load")) continue;
                        stringClassicVRML.append(indentCharacter).append("load").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getLoad() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("load ").append(SFBool.toString(this.getLoad())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("loop")) continue;
                        stringClassicVRML.append(indentCharacter).append("loop").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getLoop() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("loop ").append(SFBool.toString(this.getLoop())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("loopEnd")) continue;
                        stringClassicVRML.append(indentCharacter).append("loopEnd").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getLoopEnd() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("loopEnd ").append(SFFloat.toString(this.getLoopEnd())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("loopStart")) continue;
                        stringClassicVRML.append(indentCharacter).append("loopStart").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getLoopStart() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("loopStart ").append(SFFloat.toString(this.getLoopStart())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("numberOfChannels")) continue;
                        stringClassicVRML.append(indentCharacter).append("numberOfChannels").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getNumberOfChannels() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("numberOfChannels ").append(SFInt32.toString(this.getNumberOfChannels())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("pauseTime")) continue;
                        stringClassicVRML.append(indentCharacter).append("pauseTime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getPauseTime() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("pauseTime ").append(SFTime.toString(this.getPauseTime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("playbackRate")) continue;
                        stringClassicVRML.append(indentCharacter).append("playbackRate").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getPlaybackRate() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("playbackRate ").append(SFFloat.toString(this.getPlaybackRate())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("resumeTime")) continue;
                        stringClassicVRML.append(indentCharacter).append("resumeTime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getResumeTime() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("resumeTime ").append(SFTime.toString(this.getResumeTime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("sampleRate")) continue;
                        stringClassicVRML.append(indentCharacter).append("sampleRate").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSampleRate() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("sampleRate ").append(SFFloat.toString(this.getSampleRate())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("startTime")) continue;
                        stringClassicVRML.append(indentCharacter).append("startTime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getStartTime() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("startTime ").append(SFTime.toString(this.getStartTime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("stopTime")) continue;
                        stringClassicVRML.append(indentCharacter).append("stopTime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getStopTime() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("stopTime ").append(SFTime.toString(this.getStopTime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("url")) continue;
                        stringClassicVRML.append(indentCharacter).append("url").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getUrl().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("url ").append("[ ").append(MFString.toString(this.getUrl())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAutoRefresh(this.getAutoRefresh());
        this.setAutoRefreshTimeLimit(this.getAutoRefreshTimeLimit());
        this.setBuffer(this.getBuffer());
        this.setBufferDuration(this.getBufferDuration());
        this.setChannelCountMode(this.getChannelCountMode());
        this.setChannelInterpretation(this.getChannelInterpretation());
        this.setDescription(this.getDescription());
        this.setDetune(this.getDetune());
        this.setEnabled(this.getEnabled());
        this.setGain(this.getGain());
        this.setLoad(this.getLoad());
        this.setLoop(this.getLoop());
        this.setLoopEnd(this.getLoopEnd());
        this.setLoopStart(this.getLoopStart());
        this.setNumberOfChannels(this.getNumberOfChannels());
        this.setPauseTime(this.getPauseTime());
        this.setPlaybackRate(this.getPlaybackRate());
        this.setResumeTime(this.getResumeTime());
        this.setSampleRate(this.getSampleRate());
        this.setStartTime(this.getStartTime());
        this.setStopTime(this.getStopTime());
        this.setUrl(this.getUrl());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "BufferAudioSource USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "BufferAudioSource USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "BufferAudioSource USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "BufferAudioSource USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'BufferAudioSource' node, ensure sufficient support by adding head statement <component name='Sound' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Sound\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

