/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Picking;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class PickableGroup
extends X3DConcreteNode
implements org.web3d.x3d.sai.Picking.PickableGroup {
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private ArrayList<X3DNode> children = new ArrayList();
    private String description = new String();
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private ArrayList<String> objectType = new ArrayList();
    private boolean pickable;
    private boolean visible;
    static boolean objectTypeWarningAlreadyProvided = false;
    public static final String OBJECTTYPE_ALL = "ALL";
    public static final String OBJECTTYPE_NONE = "NONE";
    public static final String OBJECTTYPE_TERRAIN = "TERRAIN";
    public static final String NAME = "PickableGroup";
    public static final String COMPONENT = "Picking";
    public static final int LEVEL = 1;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final ArrayList<String> OBJECTTYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("ALL"));
    public static final boolean PICKABLE_DEFAULT_VALUE = true;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String toField_ADDCHILDREN = "addChildren";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_CHILDREN = "children";
    public static final String toField_CHILDREN = "children";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_OBJECTTYPE = "objectType";
    public static final String toField_OBJECTTYPE = "objectType";
    public static final String fromField_PICKABLE = "pickable";
    public static final String toField_PICKABLE = "pickable";
    public static final String toField_REMOVECHILDREN = "removeChildren";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case toField_ADDCHILDREN -> "MFNode";
            case "bboxCenter" -> "SFVec3f";
            case "bboxDisplay" -> "SFBool";
            case "bboxSize" -> "SFVec3f";
            case "children" -> "MFNode";
            case "description" -> "SFString";
            case fromField_IS -> "SFNode";
            case "metadata" -> "SFNode";
            case "objectType" -> "MFString";
            case "pickable" -> "SFBool";
            case toField_REMOVECHILDREN -> "MFNode";
            case "visible" -> "SFBool";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case toField_ADDCHILDREN -> "inputOnly";
            case "bboxCenter" -> "initializeOnly";
            case "bboxDisplay" -> "inputOutput";
            case "bboxSize" -> "initializeOnly";
            case "children" -> "inputOutput";
            case "description" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "objectType" -> "inputOutput";
            case "pickable" -> "inputOutput";
            case toField_REMOVECHILDREN -> "inputOnly";
            case "visible" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return "children";
    }

    public PickableGroup() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{"children"};
        this.bboxCenter = BBOXCENTER_DEFAULT_VALUE;
        this.bboxDisplay = false;
        this.bboxSize = BBOXSIZE_DEFAULT_VALUE;
        this.children = new ArrayList();
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.objectType = new ArrayList<String>(OBJECTTYPE_DEFAULT_VALUE);
        this.pickable = true;
        this.visible = true;
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public PickableGroup setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("PickableGroup bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public PickableGroup setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public PickableGroup setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public PickableGroup setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public PickableGroup setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public PickableGroup setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public PickableGroup setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public PickableGroup setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("PickableGroup bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("PickableGroup bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public PickableGroup setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public PickableGroup setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public PickableGroup setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public PickableGroup setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public X3DNode[] getChildren() {
        X3DNode[] valuesArray = new X3DNode[this.children.size()];
        int i = 0;
        for (X3DNode arrayElement : this.children) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getChildrenList() {
        return this.children;
    }

    @Override
    public PickableGroup setChildren(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearChildren();
            return this;
        }
        this.clearChildren();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.children.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public PickableGroup setChildren(ArrayList<X3DChildNode> newValue) {
        if (newValue == null) {
            this.clearChildren();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearChildren();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setChildren(newArray);
        }
        for (X3DChildNode element : newValue) {
            this.children.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public void addChildren(X3DNode newValue) {
        if (newValue == null) {
            return;
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
    }

    public PickableGroup addChildren(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.children.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public PickableGroup addChild(X3DChildNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    @Override
    public void addChildren(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.children.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("children");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setChildren(X3DNode newValue) {
        if (newValue == null) {
            this.clearChildren();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.children) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + String.valueOf(newValue));
        }
        this.clearChildren();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.children.add(newValue);
    }

    public PickableGroup clearChildren() {
        for (X3DNode element : this.children) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.children.clear();
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public PickableGroup addComments(String newComment) {
        if (newComment == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComment));
        return this;
    }

    @Override
    public PickableGroup addComments(String[] newComments) {
        if (newComments == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComments));
        return this;
    }

    @Override
    public PickableGroup addComments(CommentsBlock newCommentsBlock) {
        if (newCommentsBlock == null) {
            return this;
        }
        this.children.add(newCommentsBlock);
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PickableGroup setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public PickableGroup setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public PickableGroup setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public PickableGroup clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public PickableGroup setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public PickableGroup clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public PickableGroup setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public String[] getObjectType() {
        String[] valuesArray = new String[this.objectType.size()];
        int i = 0;
        for (String arrayElement : this.objectType) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getObjectTypeList() {
        return this.objectType;
    }

    public String getObjectTypeString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.objectType) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public PickableGroup setObjectType(String[] newValue) {
        int i;
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        for (i = 0; i < newValue.length; ++i) {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"") || !newValue[i].trim().equals(priorValue)) {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose()) {
                    System.out.println("trimmed MFString newValue[" + i + "]=" + newValue[i]);
                }
                boolean reduced = false;
                if (newValue[i].startsWith("\"")) {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\"")) {
                    newValue[i] = newValue[i].substring(1, newValue[i].length() - 1);
                    reduced = true;
                }
                if (reduced && ConfigurationProperties.isConsoleOutputVerbose()) {
                    System.out.println("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + " from prior value \"" + priorValue + "\"");
                }
            }
            if (newValue.length == 0 || newValue[i].toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_ALL) || newValue[i].toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_NONE) || newValue[i].toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_TERRAIN)) continue;
            String warningMessage = "[info] PickableGroup objectType newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (newValue[i].contains(" ")) {
                warningMessage = warningMessage + " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
            }
            if (!ConfigurationProperties.isConsoleOutputVerbose()) continue;
            System.out.println(warningMessage);
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        this.clearObjectType();
        for (i = 0; i < newValue.length; ++i) {
            this.objectType.add(newValue[i]);
        }
        return this;
    }

    public PickableGroup setObjectType(MFString newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        this.setObjectType(newValue.getPrimitiveValue());
        return this;
    }

    public PickableGroup setObjectType(SFString newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setObjectType(new MFString(newValue));
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.getValue().isEmpty() || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] PickableGroup objectType newValue='" + String.valueOf(newValue) + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        this.setObjectType(MFString.cleanupEnumerationValues(newValue.toString()));
        return this;
    }

    public PickableGroup setObjectType(String newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setObjectType(new MFString(newValue));
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.isEmpty() || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] PickableGroup objectType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        this.setObjectType(MFString.cleanupEnumerationValues(newValue));
        return this;
    }

    public PickableGroup setObjectType(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.size() == 0 || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", DESCRIPTION_DEFAULT_VALUE).equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] PickableGroup objectType newValue='" + String.valueOf(newValue) + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        if (newValue.isEmpty()) {
            this.clearObjectType();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setObjectType(newArray);
        }
        return this;
    }

    public PickableGroup clearObjectType() {
        this.objectType.clear();
        return this;
    }

    public PickableGroup addObjectType(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.objectType.contains(newValue)) {
            this.objectType.add(newValue);
        }
        return this;
    }

    public PickableGroup addObjectType(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.objectType.contains(newValue.getValue())) {
            this.objectType.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public boolean getPickable() {
        return this.pickable;
    }

    @Override
    public PickableGroup setPickable(boolean newValue) {
        this.pickable = newValue;
        return this;
    }

    public PickableGroup setPickable(SFBool newValue) {
        this.setPickable(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public PickableGroup setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public PickableGroup setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final PickableGroup setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PickableGroup DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public PickableGroup setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final PickableGroup setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PickableGroup USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public PickableGroup setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final PickableGroup setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public PickableGroup setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final PickableGroup setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public PickableGroup setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final PickableGroup setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public PickableGroup setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public PickableGroup setUSE(PickableGroup DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on PickableGroup that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public PickableGroup(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.children.isEmpty() || this.IS != null || this.metadata != null || this.metadataProtoInstance != null;
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<PickableGroup");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(!this.getBboxDisplay() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getObjectType().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" objectType='").append(new MFString(this.getObjectType()).toStringX3D()).append("'");
            }
            if (!(this.getPickable() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" pickable='").append(SFBool.toString(this.getPickable())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.children) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</PickableGroup>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.children.isEmpty() || this.IS != null || this.metadata != null || this.metadataProtoInstance != null;
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toString(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("objectType")) continue;
                        stringClassicVRML.append(indentCharacter).append("objectType").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getObjectType().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("objectType ").append("[ ").append(MFString.toString(this.getObjectType())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("pickable")) continue;
                        stringClassicVRML.append(indentCharacter).append("pickable").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getPickable() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("pickable ").append(SFBool.toString(this.getPickable())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.children.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("children").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.children) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (X3DNode element : this.children) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        for (X3DNode element : this.children) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice;
        this.validationResult = new StringBuilder();
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setDescription(this.getDescription());
        this.setObjectType(this.getObjectType());
        this.setPickable(this.getPickable());
        this.setVisible(this.getVisible());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        for (X3DNode element : this.children) {
            try {
                ((X3DConcreteElement)((Object)element)).validate();
                this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setChildren(this.getChildren());
        if (this.hasUSE() && this.hasChildren()) {
            errorNotice = "PickableGroup USE='" + this.getUSE() + "' is not allowed to have contained MFNode children";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            errorNotice = "PickableGroup USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice);
            throw new InvalidProtoException((String)errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            errorNotice = "PickableGroup USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidProtoException((String)errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidFieldException((String)errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice2 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'PickableGroup' node, ensure sufficient support by adding head statement <component name='Picking' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Picking\").setLevel(1);";
                this.validationResult.append(errorNotice2).append("\n");
                throw new InvalidFieldException(errorNotice2);
            }
        }
        return this.validationResult.toString();
    }
}

