/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Networking;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class IMPORT
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    private String AS = new String();
    private String importedDEF = new String();
    private String inlineDEF = new String();
    public static final String NAME = "IMPORT";
    public static final String COMPONENT = "Networking";
    public static final int LEVEL = 3;
    public static final String AS_DEFAULT_VALUE = "";
    public static final String IMPORTEDDEF_DEFAULT_VALUE = "";
    public static final String INLINEDEF_DEFAULT_VALUE = "";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 3;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "AS" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "importedDEF" -> "SFString";
            case "inlineDEF" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "AS" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "importedDEF" -> "inputOutput";
            case "inlineDEF" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public IMPORT() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.AS = "";
        this.importedDEF = "";
        this.inlineDEF = "";
        this.commentsList = new ArrayList();
    }

    public String getAS() {
        return this.AS;
    }

    public IMPORT setAS(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT AS newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.AS = newValue;
        return this;
    }

    public IMPORT setAS(SFString newValue) {
        this.setAS(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final IMPORT setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT class newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public IMPORT setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    public final IMPORT setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT id newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public IMPORT setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    public String getImportedDEF() {
        return this.importedDEF;
    }

    public IMPORT setImportedDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT importedDEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.importedDEF = newValue;
        return this;
    }

    public IMPORT setImportedDEF(SFString newValue) {
        this.setImportedDEF(newValue.getPrimitiveValue());
        return this;
    }

    public String getInlineDEF() {
        return this.inlineDEF;
    }

    public IMPORT setInlineDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT inlineDEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.inlineDEF = newValue;
        return this;
    }

    public IMPORT setInlineDEF(SFString newValue) {
        this.setInlineDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final IMPORT setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("IMPORT style newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public IMPORT setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IMPORT addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public IMPORT addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public IMPORT addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<IMPORT");
        if (hasAttributes) {
            if (!this.getAS().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" AS='").append(new SFString(this.getAS()).toStringX3D()).append("'");
            }
            if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!this.getImportedDEF().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" importedDEF='").append(new SFString(this.getImportedDEF()).toStringX3D()).append("'");
            }
            if (!this.getInlineDEF().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" inlineDEF='").append(new SFString(this.getInlineDEF()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</IMPORT>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("IMPORT ");
        stringClassicVRML.append(this.getInlineDEF());
        if (this.getInlineDEF().equals("")) {
            stringClassicVRML.append("TODO_MISSING_INLINEDEF");
        }
        stringClassicVRML.append(".");
        stringClassicVRML.append(this.getImportedDEF());
        if (this.getImportedDEF().equals("")) {
            stringClassicVRML.append("TODO_MISSING_IMPORTEDDEF");
        }
        if (!this.getAS().equals("")) {
            stringClassicVRML.append(" AS ").append(SFString.toString(this.getAS())).append(" ");
        }
        stringClassicVRML.append("\n").append((CharSequence)indent);
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAS(this.getAS());
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        if (this.getImportedDEF().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, IMPORT importedDEF field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setImportedDEF(this.getImportedDEF());
        if (this.getInlineDEF().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, IMPORT inlineDEF field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setInlineDEF(this.getInlineDEF());
        this.setCssStyle(this.getCssStyle());
        Object errorNotice = new String();
        String IMPORT_description = "<IMPORT inlineDEF='" + this.inlineDEF + "' importedDEF='" + this.importedDEF + "' AS='" + this.AS + "'/>";
        if (this.findAncestorScene() == null) {
            if (!ConfigurationProperties.isCreationConnectionValidationExceptionAllowed()) {
                errorNotice = "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH: IMPORT is not currently connected to Scene scene graph and thus cannot get checked.";
                this.validationResult.append(IMPORT_description).append("\n").append((String)errorNotice).append("\n");
            }
        } else {
            X3DConcreteNode inlineDEFObject = this.findAncestorScene().findNodeByDEF(this.inlineDEF);
            X3DConcreteNode importedDEF_InlineObject = this.findAncestorScene().findNodeByDEF(this.importedDEF);
            X3DConcreteNode AS_InlineObject = this.findAncestorScene().findNodeByDEF(this.AS);
            if (this.inlineDEF.isEmpty()) {
                errorNotice = (String)errorNotice + "IMPORT error: no inlineDEF value defined. ";
            } else if (inlineDEFObject == null) {
                errorNotice = (String)errorNotice + "IMPORT error: corresponding <Inline DEF='" + this.inlineDEF + "'/> not found. ";
            }
            if (!this.AS.isEmpty() && AS_InlineObject != null) {
                errorNotice = (String)errorNotice + "IMPORT collision in parent scene: another " + AS_InlineObject.getElementName() + " node found with DEF value matching IMPORT AS value. ";
            } else if (this.AS.isEmpty() && !this.importedDEF.isEmpty() && importedDEF_InlineObject != null) {
                errorNotice = (String)errorNotice + "IMPORT collision: another " + importedDEF_InlineObject.getElementName() + " node found with DEF value matching IMPORT importedDEF value. ";
            }
            if (!((String)errorNotice).isEmpty()) {
                this.validationResult.append(IMPORT_description).append("\n").append((String)errorNotice).append("\n");
                throw new InvalidFieldValueException(IMPORT_description + "\n" + (String)errorNotice);
            }
        }
        return this.validationResult.toString();
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public IMPORT setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public IMPORT setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public IMPORT setUSE(String newValue) {
        return this;
    }
}

