/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.jsail.X3DLoaderDOM;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.InvalidExecutionContextException;

public class MeshLabLauncher {
    public static final String MESHLAB_URL = "https://www.MeshLab.net";
    public static final String MESHLABSERVER_ERROR_NOTICE = "\nFor MeshLab releases starting in 2021, meshlabserver is discontinued. See https://stackoverflow.com/questions/65825861/where-is-meshlabserver-exe-in-2020-12\nCapabilities are in PyMeshLab which requires Python language support. See https://github.com/cnr-isti-vclab/PyMeshLab";
    private static final String meshLabServerExecutableName_DEFAULT = "meshlabserver";
    private static String meshLabServerExecutableName = "meshlabserver";
    private static String meshLabPath = "";
    public static final String MESHLAB_PATH_DEFAULT_WINDOWS = "C:\\Program Files\\VCG\\MeshLab";
    public static final String MESHLAB_PATH_DEFAULT_MACOS = "/Applications/meshlab.app/Contents/MacOS/meshlabserver";
    public static final String MESHLAB_PATH_DEFAULT_LINUX = "/usr/bin/meshlab";
    private static boolean executeCommandSuccessful = false;
    private static String meshLabTraceLogFilePath = new String();
    public static final String USAGE = "Usage: java [-classpath X3DJSAIL.*.jar] org.web3d.x3d.jsail.MeshLabLauncher sourceFile [-convert [resultFile]] [-home | -help | -properties fileName.properties | -MESHLAB_PATH directoryPath]";
    private static final String WARNING = "[Warning] ";
    private static final String ERROR = "[Error] ";
    private static boolean modelConvert = false;
    private static boolean modelExport = false;
    private static boolean modelImport = false;
    private static String conversionExtension = new String();
    private static BufferedWriter bufferedWriter;

    public static final String getMeshLabServerExecutableName() {
        String OPERATING_SYSTEM_NAME = System.getProperty("os.name");
        if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("windows") && meshLabServerExecutableName.equals(meshLabServerExecutableName_DEFAULT)) {
            meshLabServerExecutableName = meshLabServerExecutableName + ".exe";
        }
        return meshLabServerExecutableName;
    }

    public static final void setMeshLabServerExecutableName(String newValue) {
        meshLabServerExecutableName = newValue;
    }

    public static final String getMeshLabPath() {
        return meshLabPath;
    }

    public static final void setMeshLabPath(String newValue) {
        File meshLabServerFile;
        meshLabPath = newValue;
        if (meshLabPath.endsWith(MeshLabLauncher.getMeshLabServerExecutableName())) {
            meshLabPath = meshLabPath.substring(0, meshLabPath.lastIndexOf(MeshLabLauncher.getMeshLabServerExecutableName()));
        }
        if (!meshLabPath.endsWith("\\") && !meshLabPath.endsWith(File.separator)) {
            meshLabPath = meshLabPath + File.separator;
        }
        if (!(meshLabServerFile = new File(meshLabPath, MeshLabLauncher.getMeshLabServerExecutableName())).exists()) {
            String errorNotice = "Invalid setMeshLabPath(String newValue) invocation, newValue='" + newValue + "', " + MeshLabLauncher.getMeshLabServerExecutableName() + " program not found at this location";
            errorNotice = errorNotice + MESHLABSERVER_ERROR_NOTICE;
            System.out.println(errorNotice);
        }
    }

    public static void checkMeshLabPath() {
        Object systemMeshLabPath;
        String MESHLAB_PATH_ENVIRONMENT_VARIABLE = System.getProperty("MESHLAB_PATH");
        String OPERATING_SYSTEM_NAME = System.getProperty("os.name");
        if (MeshLabLauncher.getMeshLabPath() == null || MeshLabLauncher.getMeshLabPath().isEmpty()) {
            if (MESHLAB_PATH_ENVIRONMENT_VARIABLE != null && !MESHLAB_PATH_ENVIRONMENT_VARIABLE.isEmpty()) {
                MeshLabLauncher.setMeshLabPath(MESHLAB_PATH_ENVIRONMENT_VARIABLE);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("windows")) {
                MeshLabLauncher.setMeshLabPath(MESHLAB_PATH_DEFAULT_WINDOWS);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("mac")) {
                MeshLabLauncher.setMeshLabPath(MESHLAB_PATH_DEFAULT_MACOS);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("linux")) {
                MeshLabLauncher.setMeshLabPath(MESHLAB_PATH_DEFAULT_LINUX);
            }
        }
        if (!(((String)(systemMeshLabPath = MeshLabLauncher.getMeshLabPath())).isEmpty() || ((String)systemMeshLabPath).endsWith("\\") || ((String)systemMeshLabPath).endsWith("/"))) {
            systemMeshLabPath = (String)systemMeshLabPath + File.separator;
            MeshLabLauncher.setMeshLabPath((String)systemMeshLabPath);
        }
    }

    public static boolean wasPriorCommandSuccessful() {
        return executeCommandSuccessful;
    }

    protected static String executeCommand(String command) {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList(command.split("\\s")));
            ProcessBuilder processBuilder = new ProcessBuilder(commandArgs);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                outputBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            outputBuilder.append(e.getMessage()).append("\n").append(e.getCause()).append("\n");
            e.printStackTrace();
            throw new InvalidExecutionContextException(command);
        }
        return outputBuilder.toString();
    }

    public static boolean convertModel(String inputFileName, String outputFileName) {
        return MeshLabLauncher.convertModel("", inputFileName, outputFileName);
    }

    public static boolean convertModel(String path, String inputFileName, String outputFileName) {
        File inputFile;
        MeshLabLauncher.checkMeshLabPath();
        String separator = "";
        if (path == null) {
            path = "";
        }
        if (!(path.endsWith("\\") || path.endsWith("/") || path.isEmpty())) {
            separator = File.separator;
        }
        if (!(inputFile = path.isEmpty() || path.equals(".") ? new File(inputFileName) : new File(path, inputFileName)).exists()) {
            throw new InvalidDocumentException("path='" + path + "', inputFile='" + inputFileName + "' does not exist and cannot be loaded, check path and filename.");
        }
        String fileNameRoot = outputFileName.substring(0, outputFileName.lastIndexOf("."));
        String meshLabTraceLogFile = fileNameRoot + ".MeshLab.log.txt";
        meshLabTraceLogFilePath = path + separator + meshLabTraceLogFile;
        StringBuilder meshLabCommand = new StringBuilder();
        meshLabCommand.append(MeshLabLauncher.getMeshLabPath()).append(MeshLabLauncher.getMeshLabServerExecutableName()).append(" -l ").append(meshLabTraceLogFilePath).append(" -i ").append(path).append(separator).append(inputFileName).append(" -o ").append(path).append(separator).append(outputFileName);
        System.out.println(meshLabCommand.toString());
        MeshLabLauncher.executeCommand(meshLabCommand.toString());
        File outputFile = path == null || path.isEmpty() || path.equals(".") ? new File(outputFileName) : new File(path, outputFileName);
        if (!outputFile.exists()) {
            throw new InvalidDocumentException("path='" + path + "', outputFileName='" + outputFileName + "' does not exist and cannot be loaded, check path and filename.");
        }
        return MeshLabLauncher.wasPriorCommandSuccessful();
    }

    public static X3D importModel(String fileName) {
        return MeshLabLauncher.importModel("", fileName);
    }

    public static X3D importModel(String path, String fileName) {
        String separator = "";
        if (path == null) {
            path = "";
        }
        if (!(path.endsWith("\\") || path.endsWith("/") || path.isEmpty())) {
            separator = File.separator;
        }
        String fileNameRoot = fileName.substring(0, fileName.lastIndexOf("."));
        String fileNameX3dModel = fileNameRoot + ".MeshLab.x3d";
        String meshLabTraceLogFile = fileNameRoot + ".MeshLab.log.txt";
        meshLabTraceLogFilePath = path + separator + meshLabTraceLogFile;
        StringBuilder meshLabCommand = new StringBuilder();
        meshLabCommand.append(MeshLabLauncher.getMeshLabPath()).append(MeshLabLauncher.getMeshLabServerExecutableName()).append(" -l ").append(meshLabTraceLogFilePath).append(" -i ").append(path).append(separator).append(fileName).append(" -o ").append(path).append(separator).append(fileNameX3dModel);
        System.out.println(meshLabCommand.toString());
        MeshLabLauncher.executeCommand(meshLabCommand.toString());
        X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
        x3dLoader.loadModelFromFileX3D(path, fileNameX3dModel);
        return (X3D)x3dLoader.getX3dObjectTree();
    }

    public X3D importSTL(String path, String fileName) {
        return null;
    }

    public static boolean exportModelToFile(X3D modelToExport, String path, String fileName) {
        return false;
    }

    public static boolean exportSTLtoFile(X3D modelToExport, String path, String fileName) {
        boolean result = MeshLabLauncher.exportModelToFile(modelToExport, path, fileName);
        return true;
    }

    public static String getMeshLabAnalytics(X3D modelOfInterest) {
        return "";
    }

    public static MetadataSet getMeshLabAnalyticsX3dMetadataSet(X3D modelOfInterest) {
        return null;
    }

    public static String getMeshLabVersion() {
        String helpString = MeshLabLauncher.getMeshLabHelp() + "\n";
        return helpString.substring(0, helpString.indexOf("\n"));
    }

    public static boolean hasMeshLab() {
        MeshLabLauncher.checkMeshLabPath();
        StringBuilder meshLabCommand = new StringBuilder();
        meshLabCommand.append(MeshLabLauncher.getMeshLabPath()).append(MeshLabLauncher.getMeshLabServerExecutableName()).append(" --help");
        String meshLabHelp = MeshLabLauncher.executeCommand(meshLabCommand.toString());
        return meshLabHelp != null && meshLabHelp.contains("meshlabserver [logargs] [args]");
    }

    public static String getMeshLabHelp() {
        MeshLabLauncher.checkMeshLabPath();
        StringBuilder meshLabCommand = new StringBuilder();
        meshLabCommand.append(MeshLabLauncher.getMeshLabPath()).append(MeshLabLauncher.getMeshLabServerExecutableName());
        String meshLabHelp = MeshLabLauncher.executeCommand(meshLabCommand.toString());
        return meshLabHelp.replaceAll("\r\n", "\n").replaceAll("\n\n", "\n").trim();
    }

    public static String getPriorMeshLabTraceLogFilePath() {
        return meshLabTraceLogFilePath;
    }

    public static void setPriorMeshLabTraceLogFilePath(String value) {
        meshLabTraceLogFilePath = value;
    }

    public static String getPriorMeshLabTraceLogContents() {
        List<String> priorMeshLabTraceLog;
        if (meshLabTraceLogFilePath == null || meshLabTraceLogFilePath.isEmpty()) {
            return "";
        }
        try {
            Path priorMeshLabTraceLogPath = FileSystems.getDefault().getPath(meshLabTraceLogFilePath, new String[0]);
            if (priorMeshLabTraceLogPath == null) {
                return "";
            }
            priorMeshLabTraceLog = Files.readAllLines(priorMeshLabTraceLogPath);
        }
        catch (IOException ioe) {
            String message = "Exception when trying to getPriorMeshLabTraceLogContents()\n" + ioe.getMessage();
            ioe.printStackTrace();
            throw new InvalidExecutionContextException(message);
        }
        return priorMeshLabTraceLog.toString();
    }

    public static final void initialize() {
        MeshLabLauncher.checkMeshLabPath();
        MeshLabLauncher.initializeConfigurationSwitches();
    }

    private static void initializeConfigurationSwitches() {
        modelConvert = true;
        modelExport = false;
        modelImport = false;
        conversionExtension = new String();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"-version"};
        }
        System.out.println(MESHLABSERVER_ERROR_NOTICE);
    }

    public static void run(String singleStringArguments) {
        MeshLabLauncher.run(singleStringArguments.split("(\\s)"));
    }

    public static void run(String[] args) {
        long sourceFileLength = 0L;
        String sourceFileName = "";
        String sourceFileNameRoot = "";
        boolean convertToFile = false;
        boolean createImageSnapshot = false;
        boolean loadProperties = false;
        boolean resetPath = false;
        Object resultFileName = "";
        Object resultFileNameRoot = "";
        String propertiesFileName = "";
        String propertiesFileNameRoot = "";
        DecimalFormat formatPrecision2 = new DecimalFormat("#0.00");
        MeshLabLauncher.initializeConfigurationSwitches();
        if (args == null || args.length < 1) {
            System.out.println(USAGE);
            return;
        }
        for (int i = 0; i <= args.length - 1; ++i) {
            args[i] = args[i].trim();
            if (!args[i].startsWith("-")) {
                File sourceFile;
                if (modelConvert && !sourceFileName.isEmpty() && !((String)resultFileName).isEmpty()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.MeshLabLauncher] too many file names found, source=\"" + sourceFileName + "\" and result \"" + (String)resultFileName + "\" prior to argument \"" + args[i] + "\". Check usage:");
                    System.out.println(USAGE);
                    return;
                }
                if (modelConvert && !sourceFileName.isEmpty()) {
                    resultFileName = args[i];
                    resultFileNameRoot = resultFileName;
                    if (((String)resultFileNameRoot).contains(".")) {
                        resultFileNameRoot = ((String)resultFileName).substring(0, ((String)resultFileNameRoot).lastIndexOf("."));
                    }
                    File resultFile = new File((String)resultFileName);
                    conversionExtension = ((String)resultFileName).substring(((String)resultFileName).lastIndexOf("."));
                    if (!conversionExtension.isEmpty()) continue;
                    System.out.println("[Error]  [org.web3d.x3d.jsail.MeshLabLauncher] result file extension is needed for conversion but not found: " + (String)resultFileName);
                    System.out.println(USAGE);
                    return;
                }
                sourceFileName = args[i];
                sourceFileNameRoot = sourceFileName;
                if (sourceFileNameRoot.contains(".")) {
                    sourceFileNameRoot = sourceFileName.substring(0, sourceFileName.lastIndexOf("."));
                }
                if (!(sourceFile = new File(sourceFileName)).exists()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.MeshLabLauncher] file not found: " + sourceFileName);
                    return;
                }
                sourceFileLength = sourceFile.length();
                System.out.println("MeshLabLauncher parameter: source file " + sourceFile.getName() + " filesize " + sourceFileLength + " bytes");
                continue;
            }
            if (args[i].equalsIgnoreCase("-properties") || args[i].equalsIgnoreCase("-propertiesFile")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    propertiesFileName = args[i + 1];
                    propertiesFileNameRoot = propertiesFileName.substring(0, propertiesFileName.lastIndexOf("."));
                    System.out.println("MeshLabLauncher parameter: \"" + args[i] + "\" \"" + args[i + 1] + "\" for properties file name root " + propertiesFileNameRoot);
                    ++i;
                } else {
                    System.out.println("MeshLabLauncher parameter: \"" + args[i] + "\" for properties file name root " + propertiesFileNameRoot);
                }
                loadProperties = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-MESHLAB_PATH") || args[i].equalsIgnoreCase("-MESHLABPATH")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    String newPath = args[i + 1];
                    System.out.println("parameters: \"" + args[i] + "\" \"" + newPath + "\" for setting MeshLab path");
                    MeshLabLauncher.setMeshLabPath(newPath);
                    MeshLabLauncher.checkMeshLabPath();
                    ++i;
                } else {
                    System.out.println("Error: parameter: \"" + args[i] + "\" missing new MeshLab path value");
                }
                resetPath = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-convert")) {
                MeshLabLauncher.initializeConfigurationSwitches();
                modelConvert = true;
                System.out.println("MeshLabLauncher parameter: \"" + args[i] + "\" for conversion between formats");
                continue;
            }
            if (args[i].equalsIgnoreCase("-home") || args[i].equalsIgnoreCase("-page") || args[i].equalsIgnoreCase("-homepage") || args[i].equalsIgnoreCase("-website")) {
                MeshLabLauncher.launchMeshLabWebPage();
                return;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.out.println(MeshLabLauncher.getMeshLabVersion());
                return;
            }
            if (args[i].toLowerCase().contains("-help")) {
                System.out.println(USAGE);
                System.out.println(MESHLAB_URL);
                System.out.println("Meshlab help:");
                System.out.println(MeshLabLauncher.getMeshLabHelp());
                return;
            }
            System.out.println("[Error]  [org.web3d.x3d.jsail.MeshLabLauncher] unrecognized MeshLabLauncher option \"" + args[i] + "\"");
            System.out.println(USAGE);
            return;
        }
        if (loadProperties) {
            if (!propertiesFileName.isEmpty()) {
                ConfigurationProperties.setPropertiesFileName(propertiesFileName);
            }
            ConfigurationProperties.loadProperties();
        }
        if (!sourceFileName.isEmpty() && ((String)resultFileName).isEmpty()) {
            conversionExtension = ".x3d";
            resultFileName = sourceFileNameRoot + conversionExtension;
            resultFileNameRoot = sourceFileNameRoot;
            File file = new File((String)resultFileName);
        }
        if (modelImport && !conversionExtension.equalsIgnoreCase(".x3d")) {
            System.out.println("[Warning]  [org.web3d.x3d.jsail.MeshLabLauncher] resultFile " + (String)resultFileName + " has mismatched file extension \"" + conversionExtension + "\" for conversion");
        }
        if (!sourceFileName.isEmpty()) {
            if (modelConvert) {
                executeCommandSuccessful = MeshLabLauncher.convertModel(sourceFileName, (String)resultFileName);
                System.out.println("load success: " + executeCommandSuccessful);
                return;
            }
        } else if (!loadProperties && !resetPath) {
            String message = "[Error] Source model file name is empty, therefore file loading not possible.";
            System.out.println(message);
            throw new InvalidExecutionContextException(message);
        }
    }

    public static void launchMeshLabWebPage() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(MESHLAB_URL));
            }
        }
        catch (IOException | URISyntaxException e2) {
            System.out.println("launchMeshLabWebPage failure: " + e2.getMessage());
        }
    }
}

