/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Lighting;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFColor;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class PointLight
extends X3DConcreteNode
implements org.web3d.x3d.sai.Lighting.PointLight {
    private ArrayList<String> commentsList;
    private float ambientIntensity;
    private float[] attenuation;
    private float[] color;
    private boolean global;
    private float intensity;
    private IS IS;
    private float[] location;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private boolean on;
    private float radius;
    private float shadowIntensity;
    private boolean shadows;
    public static final String NAME = "PointLight";
    public static final String COMPONENT = "Lighting";
    public static final int LEVEL = 2;
    public static final float AMBIENTINTENSITY_DEFAULT_VALUE = 0.0f;
    public static final float[] ATTENUATION_DEFAULT_VALUE = new float[]{1.0f, 0.0f, 0.0f};
    public static final float[] COLOR_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final boolean GLOBAL_DEFAULT_VALUE = true;
    public static final float INTENSITY_DEFAULT_VALUE = 1.0f;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final float[] LOCATION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final boolean ON_DEFAULT_VALUE = true;
    public static final float RADIUS_DEFAULT_VALUE = 100.0f;
    public static final float SHADOWINTENSITY_DEFAULT_VALUE = 1.0f;
    public static final boolean SHADOWS_DEFAULT_VALUE = false;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AMBIENTINTENSITY = "ambientIntensity";
    public static final String toField_AMBIENTINTENSITY = "ambientIntensity";
    public static final String fromField_ATTENUATION = "attenuation";
    public static final String toField_ATTENUATION = "attenuation";
    public static final String fromField_COLOR = "color";
    public static final String toField_COLOR = "color";
    public static final String fromField_GLOBAL = "global";
    public static final String toField_GLOBAL = "global";
    public static final String fromField_INTENSITY = "intensity";
    public static final String toField_INTENSITY = "intensity";
    public static final String fromField_IS = "IS";
    public static final String fromField_LOCATION = "location";
    public static final String toField_LOCATION = "location";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_ON = "on";
    public static final String toField_ON = "on";
    public static final String fromField_SHADOWINTENSITY = "shadowIntensity";
    public static final String toField_SHADOWINTENSITY = "shadowIntensity";
    public static final String fromField_SHADOWS = "shadows";
    public static final String toField_SHADOWS = "shadows";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "ambientIntensity" -> "SFFloat";
            case "attenuation" -> "SFVec3f";
            case "color" -> "SFColor";
            case "global" -> "SFBool";
            case "intensity" -> "SFFloat";
            case fromField_IS -> "SFNode";
            case "location" -> "SFVec3f";
            case "metadata" -> "SFNode";
            case "on" -> "SFBool";
            case "radius" -> "SFFloat";
            case "shadowIntensity" -> "SFFloat";
            case "shadows" -> "SFBool";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "ambientIntensity" -> "inputOutput";
            case "attenuation" -> "inputOutput";
            case "color" -> "inputOutput";
            case "global" -> "inputOutput";
            case "intensity" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "location" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "on" -> "inputOutput";
            case "radius" -> "initializeOnly";
            case "shadowIntensity" -> "inputOutput";
            case "shadows" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public PointLight() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.ambientIntensity = 0.0f;
        this.attenuation = ATTENUATION_DEFAULT_VALUE;
        this.color = COLOR_DEFAULT_VALUE;
        this.global = true;
        this.intensity = 1.0f;
        this.IS = null;
        this.location = LOCATION_DEFAULT_VALUE;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.on = true;
        this.radius = 100.0f;
        this.shadowIntensity = 1.0f;
        this.shadows = false;
        this.commentsList = new ArrayList();
    }

    @Override
    public float getAmbientIntensity() {
        return this.ambientIntensity;
    }

    @Override
    public PointLight setAmbientIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("PointLight ambientIntensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("PointLight ambientIntensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.ambientIntensity = newValue;
        return this;
    }

    public PointLight setAmbientIntensity(SFFloat newValue) {
        this.setAmbientIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setAmbientIntensity(double newValue) {
        return this.setAmbientIntensity((float)newValue);
    }

    @Override
    public float[] getAttenuation() {
        return this.attenuation;
    }

    @Override
    public PointLight setAttenuation(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("PointLight attenuation newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) {
            throw new InvalidFieldValueException("PointLight attenuation newValue=" + String.valueOf(newValue) + " has component value less than restriction minInclusive=0");
        }
        this.attenuation = newValue;
        return this;
    }

    public PointLight setAttenuation(SFVec3f newValue) {
        this.setAttenuation(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setAttenuation(float x, float y, float z) {
        this.setAttenuation(new float[]{x, y, z});
        return this;
    }

    public PointLight setAttenuation(double x, double y, double z) {
        return this.setAttenuation(new SFVec3f(x, y, z));
    }

    public PointLight setAttenuation(double[] newArray) {
        return this.setAttenuation(new SFVec3f(newArray));
    }

    @Override
    public float[] getColor() {
        return this.color;
    }

    @Override
    public PointLight setColor(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("PointLight color newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) {
            throw new InvalidFieldValueException("PointLight color newValue=" + String.valueOf(newValue) + " has component value less than restriction minInclusive=0");
        }
        if (newValue[0] > 1.0f || newValue[1] > 1.0f || newValue[2] > 1.0f) {
            throw new InvalidFieldValueException("PointLight color newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.color = newValue;
        return this;
    }

    public PointLight setColor(SFColor newValue) {
        this.setColor(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setColor(float red, float green, float blue) {
        this.setColor(new float[]{red, green, blue});
        return this;
    }

    public PointLight setColor(double red, double green, double blue) {
        return this.setColor((float)red, (float)green, (float)blue);
    }

    public PointLight setColor(double[] newArray) {
        return this.setColor(new SFColor(newArray));
    }

    @Override
    public boolean getGlobal() {
        return this.global;
    }

    @Override
    public PointLight setGlobal(boolean newValue) {
        this.global = newValue;
        return this;
    }

    public PointLight setGlobal(SFBool newValue) {
        this.setGlobal(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getIntensity() {
        return this.intensity;
    }

    @Override
    public PointLight setIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("PointLight intensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.intensity = newValue;
        return this;
    }

    public PointLight setIntensity(SFFloat newValue) {
        this.setIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setIntensity(double newValue) {
        return this.setIntensity((float)newValue);
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public PointLight setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public PointLight clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public float[] getLocation() {
        return this.location;
    }

    @Override
    public PointLight setLocation(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("PointLight location newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.location = newValue;
        return this;
    }

    public PointLight setLocation(SFVec3f newValue) {
        this.setLocation(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setLocation(float x, float y, float z) {
        this.setLocation(new float[]{x, y, z});
        return this;
    }

    public PointLight setLocation(double x, double y, double z) {
        return this.setLocation(new SFVec3f(x, y, z));
    }

    public PointLight setLocation(double[] newArray) {
        return this.setLocation(new SFVec3f(newArray));
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public PointLight setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public PointLight clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public PointLight setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public boolean getOn() {
        return this.on;
    }

    @Override
    public PointLight setOn(boolean newValue) {
        this.on = newValue;
        return this;
    }

    public PointLight setOn(SFBool newValue) {
        this.setOn(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public PointLight setRadius(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("PointLight radius newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.radius = newValue;
        return this;
    }

    public PointLight setRadius(SFFloat newValue) {
        this.setRadius(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setRadius(double newValue) {
        return this.setRadius((float)newValue);
    }

    @Override
    public float getShadowIntensity() {
        return this.shadowIntensity;
    }

    @Override
    public PointLight setShadowIntensity(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("PointLight shadowIntensity newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("PointLight shadowIntensity newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.shadowIntensity = newValue;
        return this;
    }

    public PointLight setShadowIntensity(SFFloat newValue) {
        this.setShadowIntensity(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setShadowIntensity(double newValue) {
        return this.setShadowIntensity((float)newValue);
    }

    @Override
    public boolean getShadows() {
        return this.shadows;
    }

    @Override
    public PointLight setShadows(boolean newValue) {
        this.shadows = newValue;
        return this;
    }

    public PointLight setShadows(SFBool newValue) {
        this.setShadows(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final PointLight setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PointLight DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public PointLight setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final PointLight setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PointLight USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public PointLight setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final PointLight setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public PointLight setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final PointLight setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public PointLight setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final PointLight setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public PointLight setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public PointLight setUSE(PointLight DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on PointLight that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public PointLight(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public PointLight addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public PointLight addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public PointLight addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<PointLight");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAmbientIntensity() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" ambientIntensity='").append(SFFloat.toString(this.getAmbientIntensity())).append("'");
            }
            if (!(Arrays.equals(this.getAttenuation(), ATTENUATION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" attenuation='").append(SFVec3f.toString(this.getAttenuation())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getColor(), COLOR_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" color='").append(SFColor.toString(this.getColor())).append("'");
            }
            if (!(this.getGlobal() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" global='").append(SFBool.toString(this.getGlobal())).append("'");
            }
            if (!(this.getHtmlID().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getIntensity() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" intensity='").append(SFFloat.toString(this.getIntensity())).append("'");
            }
            if (!(Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" location='").append(SFVec3f.toString(this.getLocation())).append("'");
            }
            if (!(this.getOn() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" on='").append(SFBool.toString(this.getOn())).append("'");
            }
            if (!(this.getRadius() == 100.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" radius='").append(SFFloat.toString(this.getRadius())).append("'");
            }
            if (!(this.getShadowIntensity() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" shadowIntensity='").append(SFFloat.toString(this.getShadowIntensity())).append("'");
            }
            if (!(!this.getShadows() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" shadows='").append(SFBool.toString(this.getShadows())).append("'");
            }
            if (!(this.getCssStyle().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</PointLight>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("ambientIntensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("ambientIntensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAmbientIntensity() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("ambientIntensity ").append(SFFloat.toString(this.getAmbientIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("attenuation")) continue;
                        stringClassicVRML.append(indentCharacter).append("attenuation").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getAttenuation(), ATTENUATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("attenuation ").append(SFVec3f.toString(this.getAttenuation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("color")) continue;
                        stringClassicVRML.append(indentCharacter).append("color").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getColor(), COLOR_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("color ").append(SFColor.toString(this.getColor())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("global")) continue;
                        stringClassicVRML.append(indentCharacter).append("global").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getGlobal() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("global ").append(SFBool.toString(this.getGlobal())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("intensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("intensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getIntensity() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("intensity ").append(SFFloat.toString(this.getIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("location")) continue;
                        stringClassicVRML.append(indentCharacter).append("location").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getLocation(), LOCATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("location ").append(SFVec3f.toString(this.getLocation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("on")) continue;
                        stringClassicVRML.append(indentCharacter).append("on").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getOn() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("on ").append(SFBool.toString(this.getOn())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("radius")) continue;
                        stringClassicVRML.append(indentCharacter).append("radius").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getRadius() != 100.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("radius ").append(SFFloat.toString(this.getRadius())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("shadowIntensity")) continue;
                        stringClassicVRML.append(indentCharacter).append("shadowIntensity").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getShadowIntensity() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("shadowIntensity ").append(SFFloat.toString(this.getShadowIntensity())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("shadows")) continue;
                        stringClassicVRML.append(indentCharacter).append("shadows").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getShadows() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("shadows ").append(SFBool.toString(this.getShadows())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAmbientIntensity(this.getAmbientIntensity());
        this.setAttenuation(this.getAttenuation());
        this.setColor(this.getColor());
        this.setGlobal(this.getGlobal());
        this.setIntensity(this.getIntensity());
        this.setLocation(this.getLocation());
        this.setOn(this.getOn());
        this.setRadius(this.getRadius());
        this.setShadowIntensity(this.getShadowIntensity());
        this.setShadows(this.getShadows());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "PointLight USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "PointLight USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "PointLight USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "PointLight USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'PointLight' node, ensure sufficient support by adding head statement <component name='Lighting' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Lighting\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

