/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Layout;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Layering.X3DViewportNode;
import org.web3d.x3d.sai.Layout.X3DLayoutNode;

public class LayoutLayer
extends X3DConcreteNode
implements org.web3d.x3d.sai.Layout.LayoutLayer {
    private ArrayList<X3DNode> children = new ArrayList();
    private IS IS;
    private X3DLayoutNode layout;
    private ProtoInstance layoutProtoInstance;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private ArrayList<String> objectType = new ArrayList();
    private boolean pickable;
    private X3DViewportNode viewport;
    private ProtoInstance viewportProtoInstance;
    private boolean visible;
    static boolean objectTypeWarningAlreadyProvided = false;
    public static final String OBJECTTYPE_ALL = "ALL";
    public static final String OBJECTTYPE_NONE = "NONE";
    public static final String OBJECTTYPE_TERRAIN = "TERRAIN";
    public static final String NAME = "LayoutLayer";
    public static final String COMPONENT = "Layout";
    public static final int LEVEL = 1;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DLayoutNode LAYOUT_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final ArrayList<String> OBJECTTYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("ALL"));
    public static final boolean PICKABLE_DEFAULT_VALUE = true;
    public static final X3DViewportNode VIEWPORT_DEFAULT_VALUE = null;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final String containerField_DEFAULT_VALUE = "layers";
    public static final String toField_ADDCHILDREN = "addChildren";
    public static final String fromField_CHILDREN = "children";
    public static final String toField_CHILDREN = "children";
    public static final String fromField_IS = "IS";
    public static final String fromField_LAYOUT = "layout";
    public static final String toField_LAYOUT = "layout";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_OBJECTTYPE = "objectType";
    public static final String toField_OBJECTTYPE = "objectType";
    public static final String fromField_PICKABLE = "pickable";
    public static final String toField_PICKABLE = "pickable";
    public static final String toField_REMOVECHILDREN = "removeChildren";
    public static final String fromField_VIEWPORT = "viewport";
    public static final String toField_VIEWPORT = "viewport";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case toField_ADDCHILDREN -> "MFNode";
            case "children" -> "MFNode";
            case fromField_IS -> "SFNode";
            case "layout" -> "SFNode";
            case "metadata" -> "SFNode";
            case "objectType" -> "MFString";
            case "pickable" -> "SFBool";
            case toField_REMOVECHILDREN -> "MFNode";
            case "viewport" -> "SFNode";
            case "visible" -> "SFBool";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case toField_ADDCHILDREN -> "inputOnly";
            case "children" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "layout" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "objectType" -> "inputOutput";
            case "pickable" -> "inputOutput";
            case toField_REMOVECHILDREN -> "inputOnly";
            case "viewport" -> "inputOutput";
            case "visible" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public LayoutLayer() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.children = new ArrayList();
        this.IS = null;
        this.layout = null;
        this.layoutProtoInstance = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.objectType = new ArrayList<String>(OBJECTTYPE_DEFAULT_VALUE);
        this.pickable = true;
        this.viewport = null;
        this.viewportProtoInstance = null;
        this.visible = true;
    }

    @Override
    public X3DNode[] getChildren() {
        X3DNode[] valuesArray = new X3DNode[this.children.size()];
        int i = 0;
        for (X3DNode arrayElement : this.children) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getChildrenList() {
        return this.children;
    }

    @Override
    public LayoutLayer setChildren(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearChildren();
            return this;
        }
        this.clearChildren();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.children.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public LayoutLayer setChildren(ArrayList<X3DChildNode> newValue) {
        if (newValue == null) {
            this.clearChildren();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearChildren();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setChildren(newArray);
        }
        for (X3DChildNode element : newValue) {
            this.children.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public void addChildren(X3DNode newValue) {
        if (newValue == null) {
            return;
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
    }

    public LayoutLayer addChildren(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.children.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public LayoutLayer addChild(X3DChildNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.children.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    @Override
    public void addChildren(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.children.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("children");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setChildren(X3DNode newValue) {
        if (newValue == null) {
            this.clearChildren();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.children) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + String.valueOf(newValue));
        }
        this.clearChildren();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.children.add(newValue);
    }

    public LayoutLayer clearChildren() {
        for (X3DNode element : this.children) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.children.clear();
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public LayoutLayer addComments(String newComment) {
        if (newComment == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComment));
        return this;
    }

    @Override
    public LayoutLayer addComments(String[] newComments) {
        if (newComments == null) {
            return this;
        }
        this.children.add(new CommentsBlock(newComments));
        return this;
    }

    @Override
    public LayoutLayer addComments(CommentsBlock newCommentsBlock) {
        if (newCommentsBlock == null) {
            return this;
        }
        this.children.add(newCommentsBlock);
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public LayoutLayer setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public LayoutLayer clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DLayoutNode getLayout() {
        return this.layout;
    }

    @Override
    public LayoutLayer setLayout(X3DLayoutNode newValue) {
        this.layout = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.layout)).setParent(this);
        }
        if (this.layoutProtoInstance != null) {
            this.layoutProtoInstance.setParent(null);
            this.layoutProtoInstance = null;
        }
        return this;
    }

    public LayoutLayer clearLayout() {
        ((X3DConcreteElement)((Object)this.layout)).clearParent();
        this.layout = null;
        return this;
    }

    public LayoutLayer setLayout(ProtoInstance newValue) {
        if (this.layoutProtoInstance != null) {
            this.layoutProtoInstance.setParent(null);
        }
        this.layoutProtoInstance = newValue;
        if (newValue != null) {
            this.layoutProtoInstance.setParent(this);
            this.layoutProtoInstance.setContainerField("layout");
        }
        if (this.layout != null) {
            ((X3DConcreteElement)((Object)this.layout)).setParent(null);
            this.layout = null;
        }
        return this;
    }

    private ProtoInstance getLayoutProtoInstance() {
        return this.layoutProtoInstance;
    }

    public boolean hasLayout() {
        return this.layout != null || this.layoutProtoInstance != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public LayoutLayer setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public LayoutLayer clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public LayoutLayer setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public String[] getObjectType() {
        String[] valuesArray = new String[this.objectType.size()];
        int i = 0;
        for (String arrayElement : this.objectType) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getObjectTypeList() {
        return this.objectType;
    }

    public String getObjectTypeString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.objectType) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public LayoutLayer setObjectType(String[] newValue) {
        int i;
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        for (i = 0; i < newValue.length; ++i) {
            String priorValue = newValue[i];
            if (newValue[i].trim().startsWith("\"") || newValue[i].trim().endsWith("\"") && !newValue[i].trim().endsWith("\\\"") || !newValue[i].trim().equals(priorValue)) {
                newValue[i] = newValue[i].trim();
                if (ConfigurationProperties.isConsoleOutputVerbose()) {
                    System.out.println("trimmed MFString newValue[" + i + "]=" + newValue[i]);
                }
                boolean reduced = false;
                if (newValue[i].startsWith("\"")) {
                    newValue[i] = newValue[i].substring(1);
                    reduced = true;
                }
                if (newValue[i].endsWith("\"") && !newValue[i].endsWith("\\\"")) {
                    newValue[i] = newValue[i].substring(1, newValue[i].length() - 1);
                    reduced = true;
                }
                if (reduced && ConfigurationProperties.isConsoleOutputVerbose()) {
                    System.out.println("[error] trimmed MFString newValue[" + i + "]=" + newValue[i] + " from prior value \"" + priorValue + "\"");
                }
            }
            if (newValue.length == 0 || newValue[i].toString().replace("\"", "").equals(OBJECTTYPE_ALL) || newValue[i].toString().replace("\"", "").equals(OBJECTTYPE_NONE) || newValue[i].toString().replace("\"", "").equals(OBJECTTYPE_TERRAIN)) continue;
            String warningMessage = "[info] LayoutLayer objectType newValue='" + Arrays.toString(newValue) + "' includes an unrecognized value newValue[" + i + "]=" + newValue[i] + " not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (newValue[i].contains(" ")) {
                warningMessage = warningMessage + " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
            }
            if (!ConfigurationProperties.isConsoleOutputVerbose()) continue;
            System.out.println(warningMessage);
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        this.clearObjectType();
        for (i = 0; i < newValue.length; ++i) {
            this.objectType.add(newValue[i]);
        }
        return this;
    }

    public LayoutLayer setObjectType(MFString newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        this.setObjectType(newValue.getPrimitiveValue());
        return this;
    }

    public LayoutLayer setObjectType(SFString newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", "").length() > 2) {
            return this.setObjectType(new MFString(newValue));
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.getValue().isEmpty() || newValue.toString().replace("\"", "").equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] LayoutLayer objectType newValue='" + String.valueOf(newValue) + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        this.setObjectType(MFString.cleanupEnumerationValues(newValue.toString()));
        return this;
    }

    public LayoutLayer setObjectType(String newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", "").length() > 2) {
            return this.setObjectType(new MFString(newValue));
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.isEmpty() || newValue.toString().replace("\"", "").equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] LayoutLayer objectType newValue='" + newValue + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        this.setObjectType(MFString.cleanupEnumerationValues(newValue));
        return this;
    }

    public LayoutLayer setObjectType(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (newValue == null) {
            this.clearObjectType();
            return this;
        }
        if (!(newValue.size() == 0 || newValue.toString().replace("\"", "").equals(OBJECTTYPE_ALL) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_NONE) || newValue.toString().replace("\"", "").equals(OBJECTTYPE_TERRAIN))) {
            String warningMessage = "[info] LayoutLayer objectType newValue='" + String.valueOf(newValue) + "' includes an unrecognized value not matching any of the optional string tokens.";
            if (!objectTypeWarningAlreadyProvided) {
                warningMessage = warningMessage + "\n      Supported values are \"ALL\", \"NONE\", \"TERRAIN\"";
                objectTypeWarningAlreadyProvided = true;
            }
            if (ConfigurationProperties.isConsoleOutputVerbose()) {
                System.out.println(warningMessage);
            }
        }
        if (newValue.isEmpty()) {
            this.clearObjectType();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setObjectType(newArray);
        }
        return this;
    }

    public LayoutLayer clearObjectType() {
        this.objectType.clear();
        return this;
    }

    public LayoutLayer addObjectType(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.objectType.contains(newValue)) {
            this.objectType.add(newValue);
        }
        return this;
    }

    public LayoutLayer addObjectType(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.objectType.contains(newValue.getValue())) {
            this.objectType.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public boolean getPickable() {
        return this.pickable;
    }

    @Override
    public LayoutLayer setPickable(boolean newValue) {
        this.pickable = newValue;
        return this;
    }

    public LayoutLayer setPickable(SFBool newValue) {
        this.setPickable(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DViewportNode getViewport() {
        return this.viewport;
    }

    @Override
    public LayoutLayer setViewport(X3DViewportNode newValue) {
        this.viewport = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.viewport)).setParent(this);
        }
        if (this.viewportProtoInstance != null) {
            this.viewportProtoInstance.setParent(null);
            this.viewportProtoInstance = null;
        }
        return this;
    }

    public LayoutLayer clearViewport() {
        ((X3DConcreteElement)((Object)this.viewport)).clearParent();
        this.viewport = null;
        return this;
    }

    public LayoutLayer setViewport(ProtoInstance newValue) {
        if (this.viewportProtoInstance != null) {
            this.viewportProtoInstance.setParent(null);
        }
        this.viewportProtoInstance = newValue;
        if (newValue != null) {
            this.viewportProtoInstance.setParent(this);
            this.viewportProtoInstance.setContainerField("viewport");
        }
        if (this.viewport != null) {
            ((X3DConcreteElement)((Object)this.viewport)).setParent(null);
            this.viewport = null;
        }
        return this;
    }

    private ProtoInstance getViewportProtoInstance() {
        return this.viewportProtoInstance;
    }

    public boolean hasViewport() {
        return this.viewport != null || this.viewportProtoInstance != null;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public LayoutLayer setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public LayoutLayer setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final LayoutLayer setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("LayoutLayer DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public LayoutLayer setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final LayoutLayer setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("LayoutLayer USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public LayoutLayer setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final LayoutLayer setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public LayoutLayer setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final LayoutLayer setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public LayoutLayer setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final LayoutLayer setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public LayoutLayer setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public LayoutLayer setUSE(LayoutLayer DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on LayoutLayer that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public LayoutLayer(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.children.isEmpty() || this.IS != null || this.layout != null || this.layoutProtoInstance != null || this.metadata != null || this.metadataProtoInstance != null || this.viewport != null || this.viewportProtoInstance != null;
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<LayoutLayer");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlID().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getObjectType().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" objectType='").append(new MFString(this.getObjectType()).toStringX3D()).append("'");
            }
            if (!(this.getPickable() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" pickable='").append(SFBool.toString(this.getPickable())).append("'");
            }
            if (!(this.getCssStyle().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.children) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.layout != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.layout)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.layoutProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.layoutProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.viewport != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.viewport)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.viewportProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.viewportProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</LayoutLayer>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.children.isEmpty() || this.IS != null || this.layout != null || this.layoutProtoInstance != null || this.metadata != null || this.metadataProtoInstance != null || this.viewport != null || this.viewportProtoInstance != null;
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("objectType")) continue;
                        stringClassicVRML.append(indentCharacter).append("objectType").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getObjectType().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("objectType ").append("[ ").append(MFString.toString(this.getObjectType())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("pickable")) continue;
                        stringClassicVRML.append(indentCharacter).append("pickable").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getPickable() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("pickable ").append(SFBool.toString(this.getPickable())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.children.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("children").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.children) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
            if (this.layout != null) {
                stringClassicVRML.append(indentCharacter).append("layout").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.layout)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.layoutProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("layout").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.layoutProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.viewport != null) {
                stringClassicVRML.append(indentCharacter).append("viewport").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.viewport)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.viewportProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("viewport").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.viewportProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (X3DNode element : this.children) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.layout != null && (referenceElement = ((X3DConcreteElement)((Object)this.layout)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.layoutProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.layoutProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.viewport != null && (referenceElement = ((X3DConcreteElement)((Object)this.viewport)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.viewportProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.viewportProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        for (X3DNode element : this.children) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.layout != null && (referenceNode = ((X3DConcreteElement)((Object)this.layout)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.layoutProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.layoutProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.viewport != null && (referenceNode = ((X3DConcreteElement)((Object)this.viewport)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.viewportProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.viewportProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice;
        this.validationResult = new StringBuilder();
        this.setObjectType(this.getObjectType());
        this.setPickable(this.getPickable());
        this.setVisible(this.getVisible());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        for (X3DNode element : this.children) {
            try {
                ((X3DConcreteElement)((Object)element)).validate();
                this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setChildren(this.getChildren());
        if (this.hasUSE() && this.hasChildren()) {
            errorNotice = "LayoutLayer USE='" + this.getUSE() + "' is not allowed to have contained MFNode children";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            errorNotice = "LayoutLayer USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.layout != null) {
            this.setLayout(this.getLayout());
            ((X3DConcreteElement)((Object)this.layout)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.layout)).getValidationResult());
        }
        if (this.layoutProtoInstance != null) {
            this.setLayout(this.getLayoutProtoInstance());
            ((X3DConcreteElement)this.layoutProtoInstance).validate();
            this.validationResult.append(this.layoutProtoInstance.getValidationResult());
        }
        if (this.layout != null && this.layoutProtoInstance != null) {
            errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both layout and layoutProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice);
            throw new InvalidProtoException((String)errorNotice);
        }
        if (this.hasUSE() && this.hasLayout()) {
            errorNotice = "LayoutLayer USE='" + this.getUSE() + "' is not allowed to have contained SFNode layout";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice);
            throw new InvalidProtoException((String)errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            errorNotice = "LayoutLayer USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.viewport != null) {
            this.setViewport(this.getViewport());
            ((X3DConcreteElement)((Object)this.viewport)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.viewport)).getValidationResult());
        }
        if (this.viewportProtoInstance != null) {
            this.setViewport(this.getViewportProtoInstance());
            ((X3DConcreteElement)this.viewportProtoInstance).validate();
            this.validationResult.append(this.viewportProtoInstance.getValidationResult());
        }
        if (this.viewport != null && this.viewportProtoInstance != null) {
            errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both viewport and viewportProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice);
            throw new InvalidProtoException((String)errorNotice);
        }
        if (this.hasUSE() && this.hasViewport()) {
            errorNotice = "LayoutLayer USE='" + this.getUSE() + "' is not allowed to have contained SFNode viewport";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidProtoException((String)errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidFieldException((String)errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice2 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'LayoutLayer' node, ensure sufficient support by adding head statement <component name='Layout' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Layout\").setLevel(1);";
                this.validationResult.append(errorNotice2).append("\n");
                throw new InvalidFieldException(errorNotice2);
            }
        }
        return this.validationResult.toString();
    }
}

