/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Geospatial;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class GeoMetadata
extends X3DConcreteNode
implements org.web3d.x3d.sai.Geospatial.GeoMetadata {
    private ArrayList<String> commentsList;
    private double autoRefresh;
    private double autoRefreshTimeLimit;
    private ArrayList<X3DNode> data = new ArrayList();
    private String description = new String();
    private IS IS;
    private boolean load;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private ArrayList<String> summary = new ArrayList();
    private ArrayList<String> url = new ArrayList();
    public static final String NAME = "GeoMetadata";
    public static final String COMPONENT = "Geospatial";
    public static final int LEVEL = 1;
    public static final double AUTOREFRESH_DEFAULT_VALUE = 0.0;
    public static final double AUTOREFRESHTIMELIMIT_DEFAULT_VALUE = 3600.0;
    public static final String DESCRIPTION_DEFAULT_VALUE = "";
    public static final IS IS_DEFAULT_VALUE = null;
    public static final boolean LOAD_DEFAULT_VALUE = true;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final ArrayList<String> SUMMARY_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList(new String[0]));
    public static final ArrayList<String> URL_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList(new String[0]));
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AUTOREFRESH = "autoRefresh";
    public static final String toField_AUTOREFRESH = "autoRefresh";
    public static final String fromField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String toField_AUTOREFRESHTIMELIMIT = "autoRefreshTimeLimit";
    public static final String fromField_DATA = "data";
    public static final String toField_DATA = "data";
    public static final String fromField_DESCRIPTION = "description";
    public static final String toField_DESCRIPTION = "description";
    public static final String fromField_IS = "IS";
    public static final String fromField_LOAD = "load";
    public static final String toField_LOAD = "load";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_SUMMARY = "summary";
    public static final String toField_SUMMARY = "summary";
    public static final String fromField_URL = "url";
    public static final String toField_URL = "url";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "autoRefresh" -> "SFTime";
            case "autoRefreshTimeLimit" -> "SFTime";
            case "data" -> "MFNode";
            case "description" -> "SFString";
            case fromField_IS -> "SFNode";
            case "load" -> "SFBool";
            case "metadata" -> "SFNode";
            case "summary" -> "MFString";
            case "url" -> "MFString";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "autoRefresh" -> "inputOutput";
            case "autoRefreshTimeLimit" -> "inputOutput";
            case "data" -> "inputOutput";
            case "description" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "load" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "summary" -> "inputOutput";
            case "url" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public GeoMetadata() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride(DESCRIPTION_DEFAULT_VALUE);
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE, containerField_DEFAULT_VALUE};
        this.autoRefresh = 0.0;
        this.autoRefreshTimeLimit = 3600.0;
        this.data = new ArrayList();
        this.description = DESCRIPTION_DEFAULT_VALUE;
        this.IS = null;
        this.load = true;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.summary = new ArrayList<String>(SUMMARY_DEFAULT_VALUE);
        this.url = new ArrayList<String>(URL_DEFAULT_VALUE);
        this.commentsList = new ArrayList();
    }

    @Override
    public double getAutoRefresh() {
        return this.autoRefresh;
    }

    @Override
    public GeoMetadata setAutoRefresh(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("GeoMetadata autoRefresh newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefresh = newValue;
        return this;
    }

    public GeoMetadata setAutoRefresh(SFTime newValue) {
        this.setAutoRefresh(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getAutoRefreshTimeLimit() {
        return this.autoRefreshTimeLimit;
    }

    @Override
    public GeoMetadata setAutoRefreshTimeLimit(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("GeoMetadata autoRefreshTimeLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.autoRefreshTimeLimit = newValue;
        return this;
    }

    public GeoMetadata setAutoRefreshTimeLimit(SFTime newValue) {
        this.setAutoRefreshTimeLimit(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DNode[] getData() {
        X3DNode[] valuesArray = new X3DNode[this.data.size()];
        int i = 0;
        for (X3DNode arrayElement : this.data) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getDataList() {
        return this.data;
    }

    @Override
    public GeoMetadata setData(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearData();
            return this;
        }
        this.clearData();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.data.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public GeoMetadata setData(ArrayList<X3DNode> newValue) {
        if (newValue == null) {
            this.clearData();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearData();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setData(newArray);
        }
        for (X3DNode element : newValue) {
            this.data.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public GeoMetadata addData(X3DNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.data.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    public GeoMetadata addData(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.data.add(newValue);
        newValue.setParent(this);
        return this;
    }

    @Override
    public void addData(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.data.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("data");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setData(X3DNode newValue) {
        if (newValue == null) {
            this.clearData();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.data) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + String.valueOf(newValue));
        }
        this.clearData();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.data.add(newValue);
    }

    public GeoMetadata clearData() {
        for (X3DNode element : this.data) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.data.clear();
        return this;
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public GeoMetadata setDescription(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.description = newValue;
        return this;
    }

    public GeoMetadata setDescription(SFString newValue) {
        this.setDescription(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public GeoMetadata setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public GeoMetadata clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getLoad() {
        return this.load;
    }

    @Override
    public GeoMetadata setLoad(boolean newValue) {
        this.load = newValue;
        return this;
    }

    public GeoMetadata setLoad(SFBool newValue) {
        this.setLoad(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public GeoMetadata setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public GeoMetadata clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public GeoMetadata setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public String[] getSummary() {
        String[] valuesArray = new String[this.summary.size()];
        int i = 0;
        for (String arrayElement : this.summary) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getSummaryList() {
        return this.summary;
    }

    public String getSummaryString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.summary) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public GeoMetadata setSummary(String[] newValue) {
        if (newValue == null) {
            this.clearSummary();
            return this;
        }
        this.clearSummary();
        for (int i = 0; i < newValue.length; ++i) {
            this.summary.add(newValue[i]);
        }
        return this;
    }

    public GeoMetadata setSummary(MFString newValue) {
        if (newValue == null) {
            this.clearSummary();
            return this;
        }
        this.setSummary(newValue.getPrimitiveValue());
        return this;
    }

    public GeoMetadata setSummary(SFString newValue) {
        if (newValue == null) {
            this.clearSummary();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setSummary(new MFString(newValue));
        }
        this.setSummary(newValue.getValue());
        return this;
    }

    public GeoMetadata setSummary(String newValue) {
        if (newValue == null) {
            this.clearSummary();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setSummary(new MFString(newValue));
        }
        this.clearSummary();
        this.summary.add(newValue);
        return this;
    }

    public GeoMetadata setSummary(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearSummary();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearSummary();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setSummary(newArray);
        }
        return this;
    }

    public GeoMetadata clearSummary() {
        this.summary.clear();
        return this;
    }

    public GeoMetadata addSummary(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.summary.contains(newValue)) {
            this.summary.add(newValue);
        }
        return this;
    }

    public GeoMetadata addSummary(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.summary.contains(newValue.getValue())) {
            this.summary.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public String[] getUrl() {
        String[] valuesArray = new String[this.url.size()];
        int i = 0;
        for (String arrayElement : this.url) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getUrlList() {
        return this.url;
    }

    public String getUrlString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.url) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public GeoMetadata setUrl(String[] newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.clearUrl();
        for (int i = 0; i < newValue.length; ++i) {
            this.url.add(newValue[i]);
        }
        return this;
    }

    public GeoMetadata setUrl(MFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        this.setUrl(newValue.getPrimitiveValue());
        return this;
    }

    public GeoMetadata setUrl(SFString newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.getValue().length() - newValue.getValue().replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.setUrl(newValue.getValue());
        return this;
    }

    public GeoMetadata setUrl(String newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.length() - newValue.replace("\"", DESCRIPTION_DEFAULT_VALUE).length() > 2) {
            return this.setUrl(new MFString(newValue));
        }
        this.clearUrl();
        this.url.add(newValue);
        return this;
    }

    public GeoMetadata setUrl(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearUrl();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearUrl();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setUrl(newArray);
        }
        return this;
    }

    public GeoMetadata clearUrl() {
        this.url.clear();
        return this;
    }

    public GeoMetadata addUrl(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.url.contains(newValue)) {
            this.url.add(newValue);
        }
        return this;
    }

    public GeoMetadata addUrl(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.url.contains(newValue.getValue())) {
            this.url.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final GeoMetadata setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoMetadata DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteDEF(newValue);
        return this;
    }

    public GeoMetadata setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final GeoMetadata setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoMetadata USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF(DESCRIPTION_DEFAULT_VALUE);
        this.setConcreteUSE(newValue);
        return this;
    }

    public GeoMetadata setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final GeoMetadata setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public GeoMetadata setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlID() {
        return super.getHtmlID();
    }

    @Override
    public final GeoMetadata setHtmlID(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlID(newValue);
        return this;
    }

    public GeoMetadata setHtmlID(SFString newValue) {
        this.setHtmlID(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final GeoMetadata setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public GeoMetadata setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public GeoMetadata setUSE(GeoMetadata DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on GeoMetadata that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public GeoMetadata(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public GeoMetadata addComments(String newComment) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public GeoMetadata addComments(String[] newComments) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public GeoMetadata addComments(CommentsBlock newCommentsBlock) {
        if (this.hasUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.data.isEmpty() || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<GeoMetadata");
        if (hasAttributes) {
            if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAutoRefresh() == 0.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefresh='").append(SFTime.toString(this.getAutoRefresh())).append("'");
            }
            if (!(this.getAutoRefreshTimeLimit() == 3600.0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" autoRefreshTimeLimit='").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("'");
            }
            if (!(this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" description='").append(new SFString(this.getDescription()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlID()).toStringX3D()).append("'");
            }
            if (!(this.getLoad() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" load='").append(SFBool.toString(this.getLoad())).append("'");
            }
            if (!(this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getSummary().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" summary='").append(new MFString(this.getSummary()).toStringX3D()).append("'");
            }
            if (!(this.getUrl().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" url='").append(new MFString(this.getUrl()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.data) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</GeoMetadata>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || !this.data.isEmpty() || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(DESCRIPTION_DEFAULT_VALUE)) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefresh")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefresh").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefresh() != 0.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefresh ").append(SFTime.toString(this.getAutoRefresh())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("autoRefreshTimeLimit")) continue;
                        stringClassicVRML.append(indentCharacter).append("autoRefreshTimeLimit").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAutoRefreshTimeLimit() != 3600.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("autoRefreshTimeLimit ").append(SFTime.toString(this.getAutoRefreshTimeLimit())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("description")) continue;
                        stringClassicVRML.append(indentCharacter).append("description").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getDescription().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("description ").append("\"").append(SFString.toString(this.getDescription())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlID().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlID())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("load")) continue;
                        stringClassicVRML.append(indentCharacter).append("load").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getLoad() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("load ").append(SFBool.toString(this.getLoad())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(DESCRIPTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("summary")) continue;
                        stringClassicVRML.append(indentCharacter).append("summary").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSummary().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("summary ").append("[ ").append(MFString.toString(this.getSummary())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("url")) continue;
                        stringClassicVRML.append(indentCharacter).append("url").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getUrl().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("url ").append("[ ").append(MFString.toString(this.getUrl())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.data.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("data").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.data) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, DESCRIPTION_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        for (X3DNode element : this.data) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        for (X3DNode element : this.data) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice;
        this.validationResult = new StringBuilder();
        this.setAutoRefresh(this.getAutoRefresh());
        this.setAutoRefreshTimeLimit(this.getAutoRefreshTimeLimit());
        this.setDescription(this.getDescription());
        this.setLoad(this.getLoad());
        this.setSummary(this.getSummary());
        this.setUrl(this.getUrl());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlID(this.getHtmlID());
        this.setCssStyle(this.getCssStyle());
        for (X3DNode element : this.data) {
            try {
                ((X3DConcreteElement)((Object)element)).validate();
                this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
            }
            catch (Exception e) {
                String exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace();
            }
        }
        this.setData(this.getData());
        if (this.hasUSE() && this.hasData()) {
            errorNotice = "GeoMetadata USE='" + this.getUSE() + "' is not allowed to have contained MFNode data";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            errorNotice = "GeoMetadata USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            errorNotice = "GeoMetadata USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice);
            throw new InvalidProtoException((String)errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            errorNotice = "GeoMetadata USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.hasUSE() && !this.commentsList.isEmpty()) {
            errorNotice = "GeoMetadata USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice);
            throw new InvalidFieldValueException((String)errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidProtoException((String)errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice).append("\n");
            throw new InvalidFieldException((String)errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice2 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'GeoMetadata' node, ensure sufficient support by adding head statement <component name='Geospatial' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Geospatial\").setLevel(1);";
                this.validationResult.append(errorNotice2).append("\n");
                throw new InvalidFieldException(errorNotice2);
            }
        }
        return this.validationResult.toString();
    }
}

